// Type definitions for meilisearch
// Project: https://github.com/meilisearch/meilisearch-js
// Definitions by: qdequele <quentin@meilisearch.com> <https://github.com/meilisearch>
// Definitions: https://github.com/meilisearch/meilisearch-js
// TypeScript Version: ^3.8.3
import { Task } from "./task.js";
import { Batch } from "./batch.js";
/*
 * SEARCH PARAMETERS
 */
export const MatchingStrategies = {
    ALL: "all",
    LAST: "last",
    FREQUENCY: "frequency",
};
export const ContentTypeEnum = {
    JSON: "application/json",
    CSV: "text/csv",
    NDJSON: "application/x-ndjson",
};
/*
 ** TASKS
 */
export const TaskStatus = {
    TASK_SUCCEEDED: "succeeded",
    TASK_PROCESSING: "processing",
    TASK_FAILED: "failed",
    TASK_ENQUEUED: "enqueued",
    TASK_CANCELED: "canceled",
};
export const TaskTypes = {
    DOCUMENTS_ADDITION_OR_UPDATE: "documentAdditionOrUpdate",
    DOCUMENT_DELETION: "documentDeletion",
    DUMP_CREATION: "dumpCreation",
    INDEX_CREATION: "indexCreation",
    INDEX_DELETION: "indexDeletion",
    INDEXES_SWAP: "indexSwap",
    INDEX_UPDATE: "indexUpdate",
    SETTINGS_UPDATE: "settingsUpdate",
    SNAPSHOT_CREATION: "snapshotCreation",
    TASK_CANCELATION: "taskCancelation",
    TASK_DELETION: "taskDeletion",
};
// @TODO: This doesn't seem to be up to date, and its usefullness comes into question.
export const ErrorStatusCode = {
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#index_creation_failed */
    INDEX_CREATION_FAILED: "index_creation_failed",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_index_uid */
    MISSING_INDEX_UID: "missing_index_uid",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#index_already_exists */
    INDEX_ALREADY_EXISTS: "index_already_exists",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#index_not_found */
    INDEX_NOT_FOUND: "index_not_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_index_uid */
    INVALID_INDEX_UID: "invalid_index_uid",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#index_not_accessible */
    INDEX_NOT_ACCESSIBLE: "index_not_accessible",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_index_offset */
    INVALID_INDEX_OFFSET: "invalid_index_offset",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_index_limit */
    INVALID_INDEX_LIMIT: "invalid_index_limit",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_state */
    INVALID_STATE: "invalid_state",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#primary_key_inference_failed */
    PRIMARY_KEY_INFERENCE_FAILED: "primary_key_inference_failed",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#index_primary_key_already_exists */
    INDEX_PRIMARY_KEY_ALREADY_EXISTS: "index_primary_key_already_exists",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_index_primary_key */
    INVALID_INDEX_PRIMARY_KEY: "invalid_index_primary_key",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#max_fields_limit_exceeded */
    DOCUMENTS_FIELDS_LIMIT_REACHED: "document_fields_limit_reached",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_document_id */
    MISSING_DOCUMENT_ID: "missing_document_id",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_document_id */
    INVALID_DOCUMENT_ID: "invalid_document_id",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_content_type */
    INVALID_CONTENT_TYPE: "invalid_content_type",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_content_type */
    MISSING_CONTENT_TYPE: "missing_content_type",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_fields */
    INVALID_DOCUMENT_FIELDS: "invalid_document_fields",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_limit */
    INVALID_DOCUMENT_LIMIT: "invalid_document_limit",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_offset */
    INVALID_DOCUMENT_OFFSET: "invalid_document_offset",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_filter */
    INVALID_DOCUMENT_FILTER: "invalid_document_filter",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_document_filter */
    MISSING_DOCUMENT_FILTER: "missing_document_filter",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_vectors_field */
    INVALID_DOCUMENT_VECTORS_FIELD: "invalid_document_vectors_field",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#payload_too_large */
    PAYLOAD_TOO_LARGE: "payload_too_large",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_payload */
    MISSING_PAYLOAD: "missing_payload",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#malformed_payload */
    MALFORMED_PAYLOAD: "malformed_payload",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#no_space_left_on_device */
    NO_SPACE_LEFT_ON_DEVICE: "no_space_left_on_device",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_store_file */
    INVALID_STORE_FILE: "invalid_store_file",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_ranking_rules */
    INVALID_RANKING_RULES: "missing_document_id",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_request */
    INVALID_REQUEST: "invalid_request",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_document_geo_field */
    INVALID_DOCUMENT_GEO_FIELD: "invalid_document_geo_field",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_q */
    INVALID_SEARCH_Q: "invalid_search_q",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_offset */
    INVALID_SEARCH_OFFSET: "invalid_search_offset",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_limit */
    INVALID_SEARCH_LIMIT: "invalid_search_limit",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_page */
    INVALID_SEARCH_PAGE: "invalid_search_page",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_hits_per_page */
    INVALID_SEARCH_HITS_PER_PAGE: "invalid_search_hits_per_page",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_attributes_to_retrieve */
    INVALID_SEARCH_ATTRIBUTES_TO_RETRIEVE: "invalid_search_attributes_to_retrieve",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_attributes_to_crop */
    INVALID_SEARCH_ATTRIBUTES_TO_CROP: "invalid_search_attributes_to_crop",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_crop_length */
    INVALID_SEARCH_CROP_LENGTH: "invalid_search_crop_length",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_attributes_to_highlight */
    INVALID_SEARCH_ATTRIBUTES_TO_HIGHLIGHT: "invalid_search_attributes_to_highlight",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_show_matches_position */
    INVALID_SEARCH_SHOW_MATCHES_POSITION: "invalid_search_show_matches_position",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_filter */
    INVALID_SEARCH_FILTER: "invalid_search_filter",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_sort */
    INVALID_SEARCH_SORT: "invalid_search_sort",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_facets */
    INVALID_SEARCH_FACETS: "invalid_search_facets",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_highlight_pre_tag */
    INVALID_SEARCH_HIGHLIGHT_PRE_TAG: "invalid_search_highlight_pre_tag",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_highlight_post_tag */
    INVALID_SEARCH_HIGHLIGHT_POST_TAG: "invalid_search_highlight_post_tag",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_crop_marker */
    INVALID_SEARCH_CROP_MARKER: "invalid_search_crop_marker",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_matching_strategy */
    INVALID_SEARCH_MATCHING_STRATEGY: "invalid_search_matching_strategy",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_vector */
    INVALID_SEARCH_VECTOR: "invalid_search_vector",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_attributes_to_search_on */
    INVALID_SEARCH_ATTRIBUTES_TO_SEARCH_ON: "invalid_search_attributes_to_search_on",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#bad_request */
    BAD_REQUEST: "bad_request",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#document_not_found */
    DOCUMENT_NOT_FOUND: "document_not_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#internal */
    INTERNAL: "internal",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key */
    INVALID_API_KEY: "invalid_api_key",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_description */
    INVALID_API_KEY_DESCRIPTION: "invalid_api_key_description",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_actions */
    INVALID_API_KEY_ACTIONS: "invalid_api_key_actions",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_indexes */
    INVALID_API_KEY_INDEXES: "invalid_api_key_indexes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_expires_at */
    INVALID_API_KEY_EXPIRES_AT: "invalid_api_key_expires_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#api_key_not_found */
    API_KEY_NOT_FOUND: "api_key_not_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_uid */
    IMMUTABLE_API_KEY_UID: "immutable_api_key_uid",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_actions */
    IMMUTABLE_API_KEY_ACTIONS: "immutable_api_key_actions",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_indexes */
    IMMUTABLE_API_KEY_INDEXES: "immutable_api_key_indexes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_expires_at */
    IMMUTABLE_API_KEY_EXPIRES_AT: "immutable_api_key_expires_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_created_at */
    IMMUTABLE_API_KEY_CREATED_AT: "immutable_api_key_created_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_api_key_updated_at */
    IMMUTABLE_API_KEY_UPDATED_AT: "immutable_api_key_updated_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_authorization_header */
    MISSING_AUTHORIZATION_HEADER: "missing_authorization_header",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#unretrievable_document */
    UNRETRIEVABLE_DOCUMENT: "unretrievable_document",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#database_size_limit_reached */
    MAX_DATABASE_SIZE_LIMIT_REACHED: "database_size_limit_reached",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#task_not_found */
    TASK_NOT_FOUND: "task_not_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#dump_process_failed */
    DUMP_PROCESS_FAILED: "dump_process_failed",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#dump_not_found */
    DUMP_NOT_FOUND: "dump_not_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_swap_duplicate_index_found */
    INVALID_SWAP_DUPLICATE_INDEX_FOUND: "invalid_swap_duplicate_index_found",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_swap_indexes */
    INVALID_SWAP_INDEXES: "invalid_swap_indexes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_swap_indexes */
    MISSING_SWAP_INDEXES: "missing_swap_indexes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_master_key */
    MISSING_MASTER_KEY: "missing_master_key",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_types */
    INVALID_TASK_TYPES: "invalid_task_types",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_uids */
    INVALID_TASK_UIDS: "invalid_task_uids",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_statuses */
    INVALID_TASK_STATUSES: "invalid_task_statuses",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_limit */
    INVALID_TASK_LIMIT: "invalid_task_limit",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_from */
    INVALID_TASK_FROM: "invalid_task_from",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_canceled_by */
    INVALID_TASK_CANCELED_BY: "invalid_task_canceled_by",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_task_filters */
    MISSING_TASK_FILTERS: "missing_task_filters",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#too_many_open_files */
    TOO_MANY_OPEN_FILES: "too_many_open_files",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#io_error */
    IO_ERROR: "io_error",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_index_uids */
    INVALID_TASK_INDEX_UIDS: "invalid_task_index_uids",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_index_uid */
    IMMUTABLE_INDEX_UID: "immutable_index_uid",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_index_created_at */
    IMMUTABLE_INDEX_CREATED_AT: "immutable_index_created_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#immutable_index_updated_at */
    IMMUTABLE_INDEX_UPDATED_AT: "immutable_index_updated_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_displayed_attributes */
    INVALID_SETTINGS_DISPLAYED_ATTRIBUTES: "invalid_settings_displayed_attributes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_searchable_attributes */
    INVALID_SETTINGS_SEARCHABLE_ATTRIBUTES: "invalid_settings_searchable_attributes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_filterable_attributes */
    INVALID_SETTINGS_FILTERABLE_ATTRIBUTES: "invalid_settings_filterable_attributes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_sortable_attributes */
    INVALID_SETTINGS_SORTABLE_ATTRIBUTES: "invalid_settings_sortable_attributes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_ranking_rules */
    INVALID_SETTINGS_RANKING_RULES: "invalid_settings_ranking_rules",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_stop_words */
    INVALID_SETTINGS_STOP_WORDS: "invalid_settings_stop_words",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_synonyms */
    INVALID_SETTINGS_SYNONYMS: "invalid_settings_synonyms",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_distinct_attribute */
    INVALID_SETTINGS_DISTINCT_ATTRIBUTE: "invalid_settings_distinct_attribute",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_typo_tolerance */
    INVALID_SETTINGS_TYPO_TOLERANCE: "invalid_settings_typo_tolerance",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_faceting */
    INVALID_SETTINGS_FACETING: "invalid_settings_faceting",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_pagination */
    INVALID_SETTINGS_PAGINATION: "invalid_settings_pagination",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_search_cutoff_ms */
    INVALID_SETTINGS_SEARCH_CUTOFF_MS: "invalid_settings_search_cutoff_ms",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_settings_search_cutoff_ms */
    INVALID_SETTINGS_LOCALIZED_ATTRIBUTES: "invalid_settings_localized_attributes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_before_enqueued_at */
    INVALID_TASK_BEFORE_ENQUEUED_AT: "invalid_task_before_enqueued_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_after_enqueued_at */
    INVALID_TASK_AFTER_ENQUEUED_AT: "invalid_task_after_enqueued_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_before_started_at */
    INVALID_TASK_BEFORE_STARTED_AT: "invalid_task_before_started_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_after_started_at */
    INVALID_TASK_AFTER_STARTED_AT: "invalid_task_after_started_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_before_finished_at */
    INVALID_TASK_BEFORE_FINISHED_AT: "invalid_task_before_finished_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_task_after_finished_at */
    INVALID_TASK_AFTER_FINISHED_AT: "invalid_task_after_finished_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_api_key_actions */
    MISSING_API_KEY_ACTIONS: "missing_api_key_actions",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_api_key_indexes */
    MISSING_API_KEY_INDEXES: "missing_api_key_indexes",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_api_key_expires_at */
    MISSING_API_KEY_EXPIRES_AT: "missing_api_key_expires_at",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_limit */
    INVALID_API_KEY_LIMIT: "invalid_api_key_limit",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_api_key_offset */
    INVALID_API_KEY_OFFSET: "invalid_api_key_offset",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_facet_search_facet_name */
    INVALID_FACET_SEARCH_FACET_NAME: "invalid_facet_search_facet_name",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#missing_facet_search_facet_name */
    MISSING_FACET_SEARCH_FACET_NAME: "missing_facet_search_facet_name",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_facet_search_facet_query */
    INVALID_FACET_SEARCH_FACET_QUERY: "invalid_facet_search_facet_query",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_search_ranking_score_threshold */
    INVALID_SEARCH_RANKING_SCORE_THRESHOLD: "invalid_search_ranking_score_threshold",
    /** @see https://www.meilisearch.com/docs/reference/errors/error_codes#invalid_similar_ranking_score_threshold */
    INVALID_SIMILAR_RANKING_SCORE_THRESHOLD: "invalid_similar_ranking_score_threshold",
};
