import type { Config, BatchObject, BatchesQuery, BatchesResults } from "./types.js";
import { HttpRequests } from "./http-requests.js";
declare class Batch {
    uid: BatchObject["uid"];
    details: BatchObject["details"];
    stats: BatchObject["stats"];
    startedAt: BatchObject["startedAt"];
    finishedAt: BatchObject["finishedAt"];
    duration: BatchObject["duration"];
    progress: BatchObject["progress"];
    constructor(batch: BatchObject);
}
declare class BatchClient {
    httpRequest: HttpRequests;
    constructor(config: Config);
    /**
     * Get one batch
     *
     * @param uid - Unique identifier of the batch
     * @returns
     */
    getBatch(uid: number): Promise<Batch>;
    /**
     * Get batches
     *
     * @param parameters - Parameters to browse the batches
     * @returns Promise containing all batches
     */
    getBatches(parameters?: BatchesQuery): Promise<BatchesResults>;
}
export { BatchClient, Batch };
//# sourceMappingURL=batch.d.ts.map