import type { Config, WaitOptions, TasksQuery, TasksResults, TaskObject, CancelTasksQuery, DeleteTasksQuery } from "./types.js";
import { HttpRequests } from "./http-requests.js";
import { EnqueuedTask } from "./enqueued-task.js";
declare class Task {
    indexUid: TaskObject["indexUid"];
    status: TaskObject["status"];
    type: TaskObject["type"];
    uid: TaskObject["uid"];
    batchUid: TaskObject["batchUid"];
    canceledBy: TaskObject["canceledBy"];
    details: TaskObject["details"];
    error: TaskObject["error"];
    duration: TaskObject["duration"];
    startedAt: Date;
    enqueuedAt: Date;
    finishedAt: Date;
    constructor(task: TaskObject);
}
declare class TaskClient {
    httpRequest: HttpRequests;
    constructor(config: Config);
    /**
     * Get one task
     *
     * @param uid - Unique identifier of the task
     * @returns
     */
    getTask(uid: number): Promise<Task>;
    /**
     * Get tasks
     *
     * @param parameters - Parameters to browse the tasks
     * @returns Promise containing all tasks
     */
    getTasks(parameters?: TasksQuery): Promise<TasksResults>;
    /**
     * Wait for a task to be processed.
     *
     * @param taskUid - Task identifier
     * @param options - Additional configuration options
     * @returns Promise returning a task after it has been processed
     */
    waitForTask(taskUid: number, { timeOutMs, intervalMs }?: WaitOptions): Promise<Task>;
    /**
     * Waits for multiple tasks to be processed
     *
     * @param taskUids - Tasks identifier list
     * @param options - Wait options
     * @returns Promise returning a list of tasks after they have been processed
     */
    waitForTasks(taskUids: number[], { timeOutMs, intervalMs }?: WaitOptions): Promise<Task[]>;
    /**
     * Cancel a list of enqueued or processing tasks.
     *
     * @param parameters - Parameters to filter the tasks.
     * @returns Promise containing an EnqueuedTask
     */
    cancelTasks(parameters?: CancelTasksQuery): Promise<EnqueuedTask>;
    /**
     * Delete a list tasks.
     *
     * @param parameters - Parameters to filter the tasks.
     * @returns Promise containing an EnqueuedTask
     */
    deleteTasks(parameters?: DeleteTasksQuery): Promise<EnqueuedTask>;
}
export { TaskClient, Task };
//# sourceMappingURL=task.d.ts.map