import type { TenantTokenGeneratorOptions } from "./types.js";
/**
 * Generate a tenant token.
 *
 * @remarks
 * Warning: while this can be used in browsers with
 * {@link TenantTokenGeneratorOptions.force}, it is only intended for server
 * side. Don't use this in production on the frontend, unless you really know
 * what you're doing!
 * @param options - Options object for tenant token generation
 * @returns The token in JWT (JSON Web Token) format
 * @see {@link https://www.meilisearch.com/docs/learn/security/basic_security | Securing your project}
 */
export declare function generateTenantToken(options: TenantTokenGeneratorOptions): Promise<string>;
//# sourceMappingURL=token.d.ts.map