"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return build;
    }
});
require("../lib/setup-exception-listeners");
const _env = require("@next/env");
const _chalk = /*#__PURE__*/ _interop_require_default(require("next/dist/compiled/chalk"));
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _micromatch = require("next/dist/compiled/micromatch");
const _fs = require("fs");
const _os = /*#__PURE__*/ _interop_require_default(require("os"));
const _worker = require("../lib/worker");
const _configshared = require("../server/config-shared");
const _devalue = /*#__PURE__*/ _interop_require_default(require("next/dist/compiled/devalue"));
const _escaperegexp = require("../shared/lib/escape-regexp");
const _findup = /*#__PURE__*/ _interop_require_default(require("next/dist/compiled/find-up"));
const _indexcjs = require("next/dist/compiled/nanoid/index.cjs");
const _pathtoregexp = require("next/dist/compiled/path-to-regexp");
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _constants = require("../lib/constants");
const _fileexists = require("../lib/file-exists");
const _findpagesdir = require("../lib/find-pages-dir");
const _loadcustomroutes = /*#__PURE__*/ _interop_require_wildcard(require("../lib/load-custom-routes"));
const _redirectstatus = require("../lib/redirect-status");
const _nonnullable = require("../lib/non-nullable");
const _recursivedelete = require("../lib/recursive-delete");
const _verifypartytownsetup = require("../lib/verify-partytown-setup");
const _constants1 = require("../shared/lib/constants");
const _utils = require("../shared/lib/router/utils");
const _config = /*#__PURE__*/ _interop_require_default(require("../server/config"));
const _normalizepagepath = require("../shared/lib/page-path/normalize-page-path");
const _require = require("../server/require");
const _ciinfo = /*#__PURE__*/ _interop_require_wildcard(require("../telemetry/ci-info"));
const _events = require("../telemetry/events");
const _storage = require("../telemetry/storage");
const _getpagestaticinfo = require("./analysis/get-page-static-info");
const _entries = require("./entries");
const _generatebuildid = require("./generate-build-id");
const _iswriteable = require("./is-writeable");
const _log = /*#__PURE__*/ _interop_require_wildcard(require("./output/log"));
const _spinner = /*#__PURE__*/ _interop_require_default(require("./spinner"));
const _trace = require("../trace");
const _utils1 = require("./utils");
const _writebuildid = require("./write-build-id");
const _normalizelocalepath = require("../shared/lib/i18n/normalize-locale-path");
const _iserror = /*#__PURE__*/ _interop_require_default(require("../lib/is-error"));
const _isedgeruntime = require("../lib/is-edge-runtime");
const _recursivecopy = require("../lib/recursive-copy");
const _recursivereaddir = require("../lib/recursive-readdir");
const _swc = require("./swc");
const _routeregex = require("../shared/lib/router/utils/route-regex");
const _flatreaddir = require("../lib/flat-readdir");
const _swcplugins = require("../telemetry/events/swc-plugins");
const _apppaths = require("../shared/lib/router/utils/app-paths");
const _approuterheaders = require("../client/components/app-router-headers");
const _webpackbuild = require("./webpack-build");
const _buildcontext = require("./build-context");
const _normalizepathsep = require("../shared/lib/page-path/normalize-path-sep");
const _isapprouteroute = require("../lib/is-app-route-route");
const _createclientrouterfilter = require("../lib/create-client-router-filter");
const _findpagefile = require("../server/lib/find-page-file");
const _typecheck = require("./type-check");
const _generateinterceptionroutesrewrites = require("../lib/generate-interception-routes-rewrites");
const _requirehook = require("../server/require-hook");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {};
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function generateClientSsgManifest(prerenderManifest, { buildId , distDir , locales  }) {
    const ssgPages = new Set([
        ...Object.entries(prerenderManifest.routes)// Filter out dynamic routes
        .filter(([, { srcRoute  }])=>srcRoute == null).map(([route])=>(0, _normalizelocalepath.normalizeLocalePath)(route, locales).pathname),
        ...Object.keys(prerenderManifest.dynamicRoutes)
    ].sort());
    const clientSsgManifestContent = `self.__SSG_MANIFEST=${(0, _devalue.default)(ssgPages)};self.__SSG_MANIFEST_CB&&self.__SSG_MANIFEST_CB()`;
    await _fs.promises.writeFile(_path.default.join(distDir, _constants1.CLIENT_STATIC_FILES_PATH, buildId, "_ssgManifest.js"), clientSsgManifestContent);
}
function pageToRoute(page) {
    const routeRegex = (0, _routeregex.getNamedRouteRegex)(page, true);
    return {
        page,
        regex: (0, _loadcustomroutes.normalizeRouteRegex)(routeRegex.re.source),
        routeKeys: routeRegex.routeKeys,
        namedRegex: routeRegex.namedRegex
    };
}
async function build(dir, reactProductionProfiling = false, debugOutput = false, runLint = true, noMangling = false, appDirOnly = false, turboNextBuild = false, turboNextBuildRoot = null, buildMode) {
    const isCompile = buildMode === "experimental-compile";
    const isGenerate = buildMode === "experimental-generate";
    let hasAppDir = false;
    try {
        const nextBuildSpan = (0, _trace.trace)("next-build", undefined, {
            version: "13.4.12"
        });
        _buildcontext.NextBuildContext.nextBuildSpan = nextBuildSpan;
        _buildcontext.NextBuildContext.dir = dir;
        _buildcontext.NextBuildContext.appDirOnly = appDirOnly;
        _buildcontext.NextBuildContext.reactProductionProfiling = reactProductionProfiling;
        _buildcontext.NextBuildContext.noMangling = noMangling;
        const buildResult = await nextBuildSpan.traceAsyncFn(async ()=>{
            var _mappedPages_404, _config_images;
            // attempt to load global env values so they are available in next.config.js
            const { loadedEnvFiles  } = nextBuildSpan.traceChild("load-dotenv").traceFn(()=>(0, _env.loadEnvConfig)(dir, false, _log));
            _buildcontext.NextBuildContext.loadedEnvFiles = loadedEnvFiles;
            const config = await nextBuildSpan.traceChild("load-next-config").traceAsyncFn(()=>(0, _config.default)(_constants1.PHASE_PRODUCTION_BUILD, dir));
            _buildcontext.NextBuildContext.config = config;
            let configOutDir = "out";
            if (config.output === "export" && config.distDir !== ".next") {
                // In the past, a user had to run "next build" to generate
                // ".next" (or whatever the distDir) followed by "next export"
                // to generate "out" (or whatever the outDir). However, when
                // "output: export" is configured, "next build" does both steps.
                // So the user-configured distDir is actually the outDir.
                configOutDir = config.distDir;
                config.distDir = ".next";
            }
            const distDir = _path.default.join(dir, config.distDir);
            (0, _trace.setGlobal)("phase", _constants1.PHASE_PRODUCTION_BUILD);
            (0, _trace.setGlobal)("distDir", distDir);
            let buildId = "";
            if (isGenerate) {
                buildId = await _fs.promises.readFile(_path.default.join(distDir, "BUILD_ID"), "utf8");
            } else {
                buildId = await nextBuildSpan.traceChild("generate-buildid").traceAsyncFn(()=>(0, _generatebuildid.generateBuildId)(config.generateBuildId, _indexcjs.nanoid));
            }
            _buildcontext.NextBuildContext.buildId = buildId;
            const customRoutes = await nextBuildSpan.traceChild("load-custom-routes").traceAsyncFn(()=>(0, _loadcustomroutes.default)(config));
            const { headers , rewrites , redirects  } = customRoutes;
            _buildcontext.NextBuildContext.rewrites = rewrites;
            _buildcontext.NextBuildContext.originalRewrites = config._originalRewrites;
            _buildcontext.NextBuildContext.originalRedirects = config._originalRedirects;
            const cacheDir = _path.default.join(distDir, "cache");
            if (_ciinfo.isCI && !_ciinfo.hasNextSupport) {
                const hasCache = await (0, _fileexists.fileExists)(cacheDir);
                if (!hasCache) {
                    // Intentionally not piping to stderr in case people fail in CI when
                    // stderr is detected.
                    console.log(`${_log.prefixes.warn} No build cache found. Please configure build caching for faster rebuilds. Read more: https://nextjs.org/docs/messages/no-cache`);
                }
            }
            const telemetry = new _storage.Telemetry({
                distDir
            });
            (0, _trace.setGlobal)("telemetry", telemetry);
            const publicDir = _path.default.join(dir, "public");
            const isAppDirEnabled = !!config.experimental.appDir;
            const { pagesDir , appDir  } = (0, _findpagesdir.findPagesDir)(dir, isAppDirEnabled);
            _buildcontext.NextBuildContext.pagesDir = pagesDir;
            _buildcontext.NextBuildContext.appDir = appDir;
            hasAppDir = Boolean(appDir);
            const isSrcDir = _path.default.relative(dir, pagesDir || appDir || "").startsWith("src");
            const hasPublicDir = await (0, _fileexists.fileExists)(publicDir);
            telemetry.record((0, _events.eventCliSession)(dir, config, {
                webpackVersion: 5,
                cliCommand: "build",
                isSrcDir,
                hasNowJson: !!await (0, _findup.default)("now.json", {
                    cwd: dir
                }),
                isCustomServer: null,
                turboFlag: false,
                pagesDir: !!pagesDir,
                appDir: !!appDir
            }));
            (0, _events.eventNextPlugins)(_path.default.resolve(dir)).then((events)=>telemetry.record(events));
            (0, _swcplugins.eventSwcPlugins)(_path.default.resolve(dir), config).then((events)=>telemetry.record(events));
            const ignoreESLint = Boolean(config.eslint.ignoreDuringBuilds);
            const shouldLint = !ignoreESLint && runLint;
            const typeCheckingOptions = {
                dir,
                appDir,
                pagesDir,
                runLint,
                shouldLint,
                ignoreESLint,
                telemetry,
                nextBuildSpan,
                config,
                cacheDir
            };
            // For app directory, we run type checking after build. That's because
            // we dynamically generate types for each layout and page in the app
            // directory.
            if (!appDir && !isCompile) await (0, _typecheck.startTypeChecking)(typeCheckingOptions);
            if (appDir && "exportPathMap" in config) {
                _log.error('The "exportPathMap" configuration cannot be used with the "app" directory. Please use generateStaticParams() instead.');
                await telemetry.flush();
                process.exit(1);
            }
            const buildLintEvent = {
                featureName: "build-lint",
                invocationCount: shouldLint ? 1 : 0
            };
            telemetry.record({
                eventName: _events.EVENT_BUILD_FEATURE_USAGE,
                payload: buildLintEvent
            });
            let buildSpinner = {
                stopAndPersist () {
                    return this;
                }
            };
            if (!isGenerate) {
                buildSpinner = (0, _spinner.default)({
                    prefixText: `${_log.prefixes.info} Creating an optimized production build`
                });
            }
            _buildcontext.NextBuildContext.buildSpinner = buildSpinner;
            const validFileMatcher = (0, _findpagefile.createValidFileMatcher)(config.pageExtensions, appDir);
            const pagesPaths = !appDirOnly && pagesDir ? await nextBuildSpan.traceChild("collect-pages").traceAsyncFn(()=>(0, _recursivereaddir.recursiveReadDir)(pagesDir, validFileMatcher.isPageFile)) : [];
            const middlewareDetectionRegExp = new RegExp(`^${_constants.MIDDLEWARE_FILENAME}\\.(?:${config.pageExtensions.join("|")})$`);
            const instrumentationHookDetectionRegExp = new RegExp(`^${_constants.INSTRUMENTATION_HOOK_FILENAME}\\.(?:${config.pageExtensions.join("|")})$`);
            const rootDir = _path.default.join(pagesDir || appDir, "..");
            const instrumentationHookEnabled = Boolean(config.experimental.instrumentationHook);
            const rootPaths = (await (0, _flatreaddir.flatReaddir)(rootDir, [
                middlewareDetectionRegExp,
                ...instrumentationHookEnabled ? [
                    instrumentationHookDetectionRegExp
                ] : []
            ])).map((absoluteFile)=>absoluteFile.replace(dir, ""));
            const hasInstrumentationHook = rootPaths.some((p)=>p.includes(_constants.INSTRUMENTATION_HOOK_FILENAME));
            _buildcontext.NextBuildContext.hasInstrumentationHook = hasInstrumentationHook;
            const previewProps = {
                previewModeId: _crypto.default.randomBytes(16).toString("hex"),
                previewModeSigningKey: _crypto.default.randomBytes(32).toString("hex"),
                previewModeEncryptionKey: _crypto.default.randomBytes(32).toString("hex")
            };
            _buildcontext.NextBuildContext.previewProps = previewProps;
            const mappedPages = nextBuildSpan.traceChild("create-pages-mapping").traceFn(()=>(0, _entries.createPagesMapping)({
                    isDev: false,
                    pageExtensions: config.pageExtensions,
                    pagesType: "pages",
                    pagePaths: pagesPaths,
                    pagesDir
                }));
            _buildcontext.NextBuildContext.mappedPages = mappedPages;
            let mappedAppPages;
            let denormalizedAppPages;
            if (appDir) {
                const appPaths = await nextBuildSpan.traceChild("collect-app-paths").traceAsyncFn(()=>(0, _recursivereaddir.recursiveReadDir)(appDir, (absolutePath)=>validFileMatcher.isAppRouterPage(absolutePath) || // For now we only collect the root /not-found page in the app
                        // directory as the 404 fallback
                        validFileMatcher.isRootNotFound(absolutePath), undefined, (part)=>part.startsWith("_")));
                mappedAppPages = nextBuildSpan.traceChild("create-app-mapping").traceFn(()=>(0, _entries.createPagesMapping)({
                        pagePaths: appPaths,
                        isDev: false,
                        pagesType: "app",
                        pageExtensions: config.pageExtensions,
                        pagesDir: pagesDir
                    }));
                // If the metadata route doesn't contain generating dynamic exports,
                // we can replace the dynamic catch-all route and use the static route instead.
                for (const [pageKey, pagePath] of Object.entries(mappedAppPages)){
                    if (pageKey.includes("[[...__metadata_id__]]")) {
                        const pageFilePath = (0, _entries.getPageFilePath)({
                            absolutePagePath: pagePath,
                            pagesDir,
                            appDir,
                            rootDir
                        });
                        const isDynamic = await (0, _getpagestaticinfo.isDynamicMetadataRoute)(pageFilePath);
                        if (!isDynamic) {
                            delete mappedAppPages[pageKey];
                            mappedAppPages[pageKey.replace("[[...__metadata_id__]]/", "")] = pagePath;
                        }
                        if (pageKey.includes("sitemap.xml/[[...__metadata_id__]]") && isDynamic) {
                            delete mappedAppPages[pageKey];
                            mappedAppPages[pageKey.replace("sitemap.xml/[[...__metadata_id__]]", "sitemap/[__metadata_id__]")] = pagePath;
                        }
                    }
                }
                _buildcontext.NextBuildContext.mappedAppPages = mappedAppPages;
            }
            let mappedRootPaths = {};
            if (rootPaths.length > 0) {
                mappedRootPaths = (0, _entries.createPagesMapping)({
                    isDev: false,
                    pageExtensions: config.pageExtensions,
                    pagePaths: rootPaths,
                    pagesType: "root",
                    pagesDir: pagesDir
                });
            }
            _buildcontext.NextBuildContext.mappedRootPaths = mappedRootPaths;
            const pagesPageKeys = Object.keys(mappedPages);
            const conflictingAppPagePaths = [];
            const appPageKeys = [];
            if (mappedAppPages) {
                denormalizedAppPages = Object.keys(mappedAppPages);
                for (const appKey of denormalizedAppPages){
                    const normalizedAppPageKey = (0, _apppaths.normalizeAppPath)(appKey);
                    const pagePath = mappedPages[normalizedAppPageKey];
                    if (pagePath) {
                        const appPath = mappedAppPages[appKey];
                        conflictingAppPagePaths.push([
                            pagePath.replace(/^private-next-pages/, "pages"),
                            appPath.replace(/^private-next-app-dir/, "app")
                        ]);
                    }
                    appPageKeys.push(normalizedAppPageKey);
                }
            }
            // Interception routes are modelled as beforeFiles rewrites
            rewrites.beforeFiles.push(...(0, _generateinterceptionroutesrewrites.generateInterceptionRoutesRewrites)(appPageKeys));
            const totalAppPagesCount = appPageKeys.length;
            const pageKeys = {
                pages: pagesPageKeys,
                app: appPageKeys.length > 0 ? appPageKeys : undefined
            };
            if (turboNextBuild) {
                // TODO(WEB-397) This is a temporary workaround to allow for filtering a
                // subset of pages when building with --experimental-turbo, until we
                // have complete support for all pages.
                if (process.env.NEXT_TURBO_FILTER_PAGES) {
                    var _pageKeys_app;
                    const filterPages = process.env.NEXT_TURBO_FILTER_PAGES.split(",");
                    pageKeys.pages = pageKeys.pages.filter((page)=>{
                        return filterPages.some((filterPage)=>{
                            return (0, _micromatch.isMatch)(page, filterPage);
                        });
                    });
                    pageKeys.app = (_pageKeys_app = pageKeys.app) == null ? void 0 : _pageKeys_app.filter((page)=>{
                        return filterPages.some((filterPage)=>{
                            return (0, _micromatch.isMatch)(page, filterPage);
                        });
                    });
                }
            }
            const numConflictingAppPaths = conflictingAppPagePaths.length;
            if (mappedAppPages && numConflictingAppPaths > 0) {
                _log.error(`Conflicting app and page file${numConflictingAppPaths === 1 ? " was" : "s were"} found, please remove the conflicting files to continue:`);
                for (const [pagePath, appPath] of conflictingAppPagePaths){
                    _log.error(`  "${pagePath}" - "${appPath}"`);
                }
                await telemetry.flush();
                process.exit(1);
            }
            const conflictingPublicFiles = [];
            const hasPages404 = (_mappedPages_404 = mappedPages["/404"]) == null ? void 0 : _mappedPages_404.startsWith(_constants.PAGES_DIR_ALIAS);
            const hasApp404 = !!(mappedAppPages == null ? void 0 : mappedAppPages["/_not-found"]);
            const hasCustomErrorPage = mappedPages["/_error"].startsWith(_constants.PAGES_DIR_ALIAS);
            if (hasPublicDir) {
                const hasPublicUnderScoreNextDir = await (0, _fileexists.fileExists)(_path.default.join(publicDir, "_next"));
                if (hasPublicUnderScoreNextDir) {
                    throw new Error(_constants.PUBLIC_DIR_MIDDLEWARE_CONFLICT);
                }
            }
            await nextBuildSpan.traceChild("public-dir-conflict-check").traceAsyncFn(async ()=>{
                // Check if pages conflict with files in `public`
                // Only a page of public file can be served, not both.
                for(const page in mappedPages){
                    const hasPublicPageFile = await (0, _fileexists.fileExists)(_path.default.join(publicDir, page === "/" ? "/index" : page), _fileexists.FileType.File);
                    if (hasPublicPageFile) {
                        conflictingPublicFiles.push(page);
                    }
                }
                const numConflicting = conflictingPublicFiles.length;
                if (numConflicting) {
                    throw new Error(`Conflicting public and page file${numConflicting === 1 ? " was" : "s were"} found. https://nextjs.org/docs/messages/conflicting-public-file-page\n${conflictingPublicFiles.join("\n")}`);
                }
            });
            const nestedReservedPages = pageKeys.pages.filter((page)=>{
                return page.match(/\/(_app|_document|_error)$/) && _path.default.dirname(page) !== "/";
            });
            if (nestedReservedPages.length) {
                _log.warn(`The following reserved Next.js pages were detected not directly under the pages directory:\n` + nestedReservedPages.join("\n") + `\nSee more info here: https://nextjs.org/docs/messages/nested-reserved-page\n`);
            }
            const restrictedRedirectPaths = [
                "/_next"
            ].map((p)=>config.basePath ? `${config.basePath}${p}` : p);
            const buildCustomRoute = (r, type)=>{
                const keys = [];
                const routeRegex = (0, _pathtoregexp.pathToRegexp)(r.source, keys, {
                    strict: true,
                    sensitive: false,
                    delimiter: "/"
                });
                let regexSource = routeRegex.source;
                if (!r.internal) {
                    regexSource = (0, _redirectstatus.modifyRouteRegex)(routeRegex.source, type === "redirect" ? restrictedRedirectPaths : undefined);
                }
                return {
                    ...r,
                    ...type === "redirect" ? {
                        statusCode: (0, _redirectstatus.getRedirectStatus)(r),
                        permanent: undefined
                    } : {},
                    regex: (0, _loadcustomroutes.normalizeRouteRegex)(regexSource)
                };
            };
            const routesManifestPath = _path.default.join(distDir, _constants1.ROUTES_MANIFEST);
            const routesManifest = nextBuildSpan.traceChild("generate-routes-manifest").traceFn(()=>{
                const sortedRoutes = (0, _utils.getSortedRoutes)([
                    ...pageKeys.pages,
                    ...pageKeys.app ?? []
                ]);
                const dynamicRoutes = [];
                const staticRoutes = [];
                for (const route of sortedRoutes){
                    if ((0, _utils.isDynamicRoute)(route)) {
                        dynamicRoutes.push(pageToRoute(route));
                    } else if (!(0, _utils1.isReservedPage)(route)) {
                        staticRoutes.push(pageToRoute(route));
                    }
                }
                return {
                    version: 3,
                    pages404: true,
                    caseSensitive: !!config.experimental.caseSensitiveRoutes,
                    basePath: config.basePath,
                    redirects: redirects.map((r)=>buildCustomRoute(r, "redirect")),
                    headers: headers.map((r)=>buildCustomRoute(r, "header")),
                    dynamicRoutes,
                    staticRoutes,
                    dataRoutes: [],
                    i18n: config.i18n || undefined,
                    rsc: {
                        header: _approuterheaders.RSC,
                        varyHeader: _approuterheaders.RSC_VARY_HEADER,
                        contentTypeHeader: _approuterheaders.RSC_CONTENT_TYPE_HEADER
                    },
                    skipMiddlewareUrlNormalize: config.skipMiddlewareUrlNormalize
                };
            });
            if (rewrites.beforeFiles.length === 0 && rewrites.fallback.length === 0) {
                routesManifest.rewrites = rewrites.afterFiles.map((r)=>buildCustomRoute(r, "rewrite"));
            } else {
                routesManifest.rewrites = {
                    beforeFiles: rewrites.beforeFiles.map((r)=>buildCustomRoute(r, "rewrite")),
                    afterFiles: rewrites.afterFiles.map((r)=>buildCustomRoute(r, "rewrite")),
                    fallback: rewrites.fallback.map((r)=>buildCustomRoute(r, "rewrite"))
                };
            }
            const combinedRewrites = [
                ...rewrites.beforeFiles,
                ...rewrites.afterFiles,
                ...rewrites.fallback
            ];
            if (config.experimental.clientRouterFilter) {
                const nonInternalRedirects = (config._originalRedirects || []).filter((r)=>!r.internal);
                const clientRouterFilters = (0, _createclientrouterfilter.createClientRouterFilter)(appPageKeys, config.experimental.clientRouterFilterRedirects ? nonInternalRedirects : [], config.experimental.clientRouterFilterAllowedRate);
                _buildcontext.NextBuildContext.clientRouterFilters = clientRouterFilters;
            }
            const distDirCreated = await nextBuildSpan.traceChild("create-dist-dir").traceAsyncFn(async ()=>{
                try {
                    await _fs.promises.mkdir(distDir, {
                        recursive: true
                    });
                    return true;
                } catch (err) {
                    if ((0, _iserror.default)(err) && err.code === "EPERM") {
                        return false;
                    }
                    throw err;
                }
            });
            if (!distDirCreated || !await (0, _iswriteable.isWriteable)(distDir)) {
                throw new Error("> Build directory is not writeable. https://nextjs.org/docs/messages/build-dir-not-writeable");
            }
            if (config.cleanDistDir && !isGenerate) {
                await (0, _recursivedelete.recursiveDelete)(distDir, /^cache/);
            }
            // Ensure commonjs handling is used for files in the distDir (generally .next)
            // Files outside of the distDir can be "type": "module"
            await _fs.promises.writeFile(_path.default.join(distDir, "package.json"), '{"type": "commonjs"}');
            // We need to write the manifest with rewrites before build
            await nextBuildSpan.traceChild("write-routes-manifest").traceAsyncFn(()=>_fs.promises.writeFile(routesManifestPath, JSON.stringify(routesManifest), "utf8"));
            const outputFileTracingRoot = config.experimental.outputFileTracingRoot || dir;
            const manifestPath = _path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.PAGES_MANIFEST);
            const { incrementalCacheHandlerPath  } = config.experimental;
            const requiredServerFiles = nextBuildSpan.traceChild("generate-required-server-files").traceFn(()=>({
                    version: 1,
                    config: {
                        ...config,
                        configFile: undefined,
                        ..._ciinfo.hasNextSupport ? {
                            compress: false
                        } : {},
                        experimental: {
                            ...config.experimental,
                            trustHostHeader: _ciinfo.hasNextSupport,
                            incrementalCacheHandlerPath: incrementalCacheHandlerPath ? _path.default.relative(distDir, incrementalCacheHandlerPath) : undefined
                        }
                    },
                    appDir: dir,
                    relativeAppDir: _path.default.relative(outputFileTracingRoot, dir),
                    files: [
                        _constants1.ROUTES_MANIFEST,
                        _path.default.relative(distDir, manifestPath),
                        _constants1.BUILD_MANIFEST,
                        _constants1.PRERENDER_MANIFEST,
                        _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_MANIFEST),
                        _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_BUILD_MANIFEST + ".js"),
                        _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_REACT_LOADABLE_MANIFEST + ".js"),
                        ...appDir ? [
                            ...config.experimental.sri ? [
                                _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.SUBRESOURCE_INTEGRITY_MANIFEST + ".js"),
                                _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.SUBRESOURCE_INTEGRITY_MANIFEST + ".json")
                            ] : [],
                            _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.APP_PATHS_MANIFEST),
                            _constants1.APP_BUILD_MANIFEST,
                            _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.SERVER_REFERENCE_MANIFEST + ".js"),
                            _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.SERVER_REFERENCE_MANIFEST + ".json")
                        ] : [],
                        _constants1.REACT_LOADABLE_MANIFEST,
                        config.optimizeFonts ? _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.FONT_MANIFEST) : null,
                        _constants1.BUILD_ID_FILE,
                        _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.NEXT_FONT_MANIFEST + ".js"),
                        _path.default.join(_constants1.SERVER_DIRECTORY, _constants1.NEXT_FONT_MANIFEST + ".json"),
                        ...hasInstrumentationHook ? [
                            _path.default.join(_constants1.SERVER_DIRECTORY, `${_constants.INSTRUMENTATION_HOOK_FILENAME}.js`),
                            _path.default.join(_constants1.SERVER_DIRECTORY, `edge-${_constants.INSTRUMENTATION_HOOK_FILENAME}.js`)
                        ] : []
                    ].filter(_nonnullable.nonNullable).map((file)=>_path.default.join(config.distDir, file)),
                    ignore: []
                }));
            let binding = await (0, _swc.loadBindings)();
            async function turbopackBuild() {
                const turboNextBuildStart = process.hrtime();
                const turboJson = _findup.default.sync("turbo.json", {
                    cwd: dir
                });
                // eslint-disable-next-line no-shadow
                const packagePath = _findup.default.sync("package.json", {
                    cwd: dir
                });
                let root = turboNextBuildRoot ?? (turboJson ? _path.default.dirname(turboJson) : packagePath ? _path.default.dirname(packagePath) : undefined);
                await binding.turbo.nextBuild({
                    ..._buildcontext.NextBuildContext,
                    root
                });
                const [duration] = process.hrtime(turboNextBuildStart);
                return {
                    duration,
                    turbotraceContext: null
                };
            }
            let runTurbotrace = async (_staticPages)=>{};
            let turboTasksForTrace;
            if (!isGenerate) {
                const { duration: webpackBuildDuration , turbotraceContext  } = turboNextBuild ? await turbopackBuild() : await (0, _webpackbuild.webpackBuild)();
                telemetry.record((0, _events.eventBuildCompleted)(pagesPaths, {
                    durationInSeconds: webpackBuildDuration,
                    totalAppPagesCount
                }));
                runTurbotrace = async function(staticPages) {
                    if (!turbotraceContext) {
                        return;
                    }
                    if (!(binding == null ? void 0 : binding.isWasm) && typeof binding.turbo.startTrace === "function") {
                        var _config_experimental_turbotrace;
                        let turbotraceOutputPath;
                        let turbotraceFiles;
                        turboTasksForTrace = binding.turbo.createTurboTasks((((_config_experimental_turbotrace = config.experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace.memoryLimit) ?? _constants1.TURBO_TRACE_DEFAULT_MEMORY_LIMIT) * 1024 * 1024);
                        const { entriesTrace , chunksTrace  } = turbotraceContext;
                        if (entriesTrace) {
                            const { appDir: turbotraceContextAppDir , depModArray , entryNameMap , outputPath , action  } = entriesTrace;
                            const depModSet = new Set(depModArray);
                            const filesTracedInEntries = await binding.turbo.startTrace(action, turboTasksForTrace);
                            const { contextDirectory , input: entriesToTrace  } = action;
                            // only trace the assets under the appDir
                            // exclude files from node_modules, entries and processed by webpack
                            const filesTracedFromEntries = filesTracedInEntries.map((f)=>_path.default.join(contextDirectory, f)).filter((f)=>!f.includes("/node_modules/") && f.startsWith(turbotraceContextAppDir) && !entriesToTrace.includes(f) && !depModSet.has(f));
                            if (filesTracedFromEntries.length) {
                                // The turbo trace doesn't provide the traced file type and reason at present
                                // let's write the traced files into the first [entry].nft.json
                                const [[, entryName]] = Array.from(entryNameMap.entries()).filter(([k])=>k.startsWith(turbotraceContextAppDir));
                                const traceOutputPath = _path.default.join(outputPath, `../${entryName}.js.nft.json`);
                                const traceOutputDir = _path.default.dirname(traceOutputPath);
                                turbotraceOutputPath = traceOutputPath;
                                turbotraceFiles = filesTracedFromEntries.map((file)=>_path.default.relative(traceOutputDir, file));
                            }
                        }
                        if (chunksTrace) {
                            const { action , outputPath  } = chunksTrace;
                            action.input = action.input.filter((f)=>{
                                const outputPagesPath = _path.default.join(outputPath, "..", "pages");
                                return !f.startsWith(outputPagesPath) || !staticPages.has(// strip `outputPagesPath` and file ext from absolute
                                f.substring(outputPagesPath.length, f.length - 3));
                            });
                            await binding.turbo.startTrace(action, turboTasksForTrace);
                            if (turbotraceOutputPath && turbotraceFiles) {
                                const existedNftFile = await _fs.promises.readFile(turbotraceOutputPath, "utf8").then((existedContent)=>JSON.parse(existedContent)).catch(()=>({
                                        version: _constants1.TRACE_OUTPUT_VERSION,
                                        files: []
                                    }));
                                existedNftFile.files.push(...turbotraceFiles);
                                const filesSet = new Set(existedNftFile.files);
                                existedNftFile.files = [
                                    ...filesSet
                                ];
                                await _fs.promises.writeFile(turbotraceOutputPath, JSON.stringify(existedNftFile), "utf8");
                            }
                        }
                    }
                };
            }
            // For app directory, we run type checking after build.
            if (appDir && !(isCompile || isGenerate)) {
                await (0, _typecheck.startTypeChecking)(typeCheckingOptions);
            }
            const postCompileSpinner = (0, _spinner.default)({
                prefixText: `${_log.prefixes.info} Collecting page data`
            });
            const buildManifestPath = _path.default.join(distDir, _constants1.BUILD_MANIFEST);
            const appBuildManifestPath = _path.default.join(distDir, _constants1.APP_BUILD_MANIFEST);
            let staticAppPagesCount = 0;
            let serverAppPagesCount = 0;
            let edgeRuntimeAppCount = 0;
            let edgeRuntimePagesCount = 0;
            const ssgPages = new Set();
            const ssgStaticFallbackPages = new Set();
            const ssgBlockingFallbackPages = new Set();
            const staticPages = new Set();
            const invalidPages = new Set();
            const hybridAmpPages = new Set();
            const serverPropsPages = new Set();
            const additionalSsgPaths = new Map();
            const additionalSsgPathsEncoded = new Map();
            const appStaticPaths = new Map();
            const appStaticPathsEncoded = new Map();
            const appNormalizedPaths = new Map();
            const appDynamicParamPaths = new Set();
            const appDefaultConfigs = new Map();
            const pageInfos = new Map();
            const pagesManifest = JSON.parse(await _fs.promises.readFile(manifestPath, "utf8"));
            const buildManifest = JSON.parse(await _fs.promises.readFile(buildManifestPath, "utf8"));
            const appBuildManifest = appDir ? JSON.parse(await _fs.promises.readFile(appBuildManifestPath, "utf8")) : undefined;
            const timeout = config.staticPageGenerationTimeout || 0;
            const sharedPool = config.experimental.sharedPool || false;
            const staticWorkerPath = sharedPool ? require.resolve("./worker") : require.resolve("./utils");
            let appPathsManifest = {};
            const appPathRoutes = {};
            if (appDir) {
                appPathsManifest = JSON.parse(await _fs.promises.readFile(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.APP_PATHS_MANIFEST), "utf8"));
                Object.keys(appPathsManifest).forEach((entry)=>{
                    appPathRoutes[entry] = (0, _apppaths.normalizeAppPath)(entry);
                });
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.APP_PATH_ROUTES_MANIFEST), JSON.stringify(appPathRoutes, null, 2));
            }
            process.env.NEXT_PHASE = _constants1.PHASE_PRODUCTION_BUILD;
            const numWorkers = config.experimental.memoryBasedWorkersCount ? Math.max(config.experimental.cpus !== _configshared.defaultConfig.experimental.cpus ? config.experimental.cpus : Math.min(config.experimental.cpus || 1, Math.floor(_os.default.freemem() / 1e9)), // enforce a minimum of 4 workers
            4) : config.experimental.cpus || 4;
            function createStaticWorker(type) {
                let infoPrinted = false;
                return new _worker.Worker(staticWorkerPath, {
                    timeout: timeout * 1000,
                    onRestart: (method, [arg], attempts)=>{
                        if (method === "exportPage") {
                            const { path: pagePath  } = arg;
                            if (attempts >= 3) {
                                throw new Error(`Static page generation for ${pagePath} is still timing out after 3 attempts. See more info here https://nextjs.org/docs/messages/static-page-generation-timeout`);
                            }
                            _log.warn(`Restarted static page generation for ${pagePath} because it took more than ${timeout} seconds`);
                        } else {
                            const pagePath = arg;
                            if (attempts >= 2) {
                                throw new Error(`Collecting page data for ${pagePath} is still timing out after 2 attempts. See more info here https://nextjs.org/docs/messages/page-data-collection-timeout`);
                            }
                            _log.warn(`Restarted collecting page data for ${pagePath} because it took more than ${timeout} seconds`);
                        }
                        if (!infoPrinted) {
                            _log.warn("See more info here https://nextjs.org/docs/messages/static-page-generation-timeout");
                            infoPrinted = true;
                        }
                    },
                    numWorkers,
                    forkOptions: {
                        env: {
                            ...process.env,
                            __NEXT_PRIVATE_PREBUNDLED_REACT: type === "app" ? config.experimental.serverActions ? "experimental" : "next" : ""
                        }
                    },
                    enableWorkerThreads: config.experimental.workerThreads,
                    exposedMethods: sharedPool ? [
                        "hasCustomGetInitialProps",
                        "isPageStatic",
                        "getDefinedNamedExports",
                        "exportPage"
                    ] : [
                        "hasCustomGetInitialProps",
                        "isPageStatic",
                        "getDefinedNamedExports"
                    ]
                });
            }
            const pagesStaticWorkers = createStaticWorker("pages");
            const appStaticWorkers = isAppDirEnabled ? createStaticWorker("app") : undefined;
            const analysisBegin = process.hrtime();
            const staticCheckSpan = nextBuildSpan.traceChild("static-check");
            const functionsConfigManifest = {};
            const { customAppGetInitialProps , namedExports , isNextImageImported , hasSsrAmpPages , hasNonStaticErrorPage  } = await staticCheckSpan.traceAsyncFn(async ()=>{
                if (isCompile) {
                    return {
                        customAppGetInitialProps: false,
                        namedExports: [],
                        isNextImageImported: true,
                        hasSsrAmpPages: !!pagesDir,
                        hasNonStaticErrorPage: true
                    };
                }
                const { configFileName , publicRuntimeConfig , serverRuntimeConfig  } = config;
                const runtimeEnvConfig = {
                    publicRuntimeConfig,
                    serverRuntimeConfig
                };
                const nonStaticErrorPageSpan = staticCheckSpan.traceChild("check-static-error-page");
                const errorPageHasCustomGetInitialProps = nonStaticErrorPageSpan.traceAsyncFn(async ()=>hasCustomErrorPage && await pagesStaticWorkers.hasCustomGetInitialProps("/_error", distDir, runtimeEnvConfig, false));
                const errorPageStaticResult = nonStaticErrorPageSpan.traceAsyncFn(async ()=>{
                    var _config_i18n, _config_i18n1;
                    return hasCustomErrorPage && pagesStaticWorkers.isPageStatic({
                        page: "/_error",
                        distDir,
                        configFileName,
                        runtimeEnvConfig,
                        httpAgentOptions: config.httpAgentOptions,
                        locales: (_config_i18n = config.i18n) == null ? void 0 : _config_i18n.locales,
                        defaultLocale: (_config_i18n1 = config.i18n) == null ? void 0 : _config_i18n1.defaultLocale,
                        nextConfigOutput: config.output
                    });
                });
                const appPageToCheck = "/_app";
                const customAppGetInitialPropsPromise = pagesStaticWorkers.hasCustomGetInitialProps(appPageToCheck, distDir, runtimeEnvConfig, true);
                const namedExportsPromise = pagesStaticWorkers.getDefinedNamedExports(appPageToCheck, distDir, runtimeEnvConfig);
                // eslint-disable-next-line @typescript-eslint/no-shadow
                let isNextImageImported;
                // eslint-disable-next-line @typescript-eslint/no-shadow
                let hasSsrAmpPages = false;
                const computedManifestData = await (0, _utils1.computeFromManifest)({
                    build: buildManifest,
                    app: appBuildManifest
                }, distDir, config.experimental.gzipSize);
                const middlewareManifest = require(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_MANIFEST));
                const actionManifest = appDir ? require(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.SERVER_REFERENCE_MANIFEST + ".json")) : null;
                const entriesWithAction = actionManifest ? new Set() : null;
                if (actionManifest && entriesWithAction) {
                    for(const id in actionManifest.node){
                        for(const entry in actionManifest.node[id].workers){
                            entriesWithAction.add(entry);
                        }
                    }
                    for(const id in actionManifest.edge){
                        for(const entry in actionManifest.edge[id].workers){
                            entriesWithAction.add(entry);
                        }
                    }
                }
                for (const key of Object.keys(middlewareManifest == null ? void 0 : middlewareManifest.functions)){
                    if (key.startsWith("/api")) {
                        edgeRuntimePagesCount++;
                    }
                }
                await Promise.all(Object.entries(pageKeys).reduce((acc, [key, files])=>{
                    if (!files) {
                        return acc;
                    }
                    const pageType = key;
                    for (const page of files){
                        acc.push({
                            pageType,
                            page
                        });
                    }
                    return acc;
                }, []).map(({ pageType , page  })=>{
                    const checkPageSpan = staticCheckSpan.traceChild("check-page", {
                        page
                    });
                    return checkPageSpan.traceAsyncFn(async ()=>{
                        const actualPage = (0, _normalizepagepath.normalizePagePath)(page);
                        const [selfSize, allSize] = await (0, _utils1.getJsPageSizeInKb)(pageType, actualPage, distDir, buildManifest, appBuildManifest, config.experimental.gzipSize, computedManifestData);
                        let isSsg = false;
                        let isStatic = false;
                        let isServerComponent = false;
                        let isHybridAmp = false;
                        let ssgPageRoutes = null;
                        let pagePath = "";
                        if (pageType === "pages") {
                            pagePath = pagesPaths.find((p)=>{
                                p = (0, _normalizepathsep.normalizePathSep)(p);
                                return p.startsWith(actualPage + ".") || p.startsWith(actualPage + "/index.");
                            }) || "";
                        }
                        let originalAppPath;
                        if (pageType === "app" && mappedAppPages) {
                            for (const [originalPath, normalizedPath] of Object.entries(appPathRoutes)){
                                if (normalizedPath === page) {
                                    pagePath = mappedAppPages[originalPath].replace(/^private-next-app-dir/, "");
                                    originalAppPath = originalPath;
                                    break;
                                }
                            }
                        }
                        const staticInfo = pagePath ? await (0, _getpagestaticinfo.getPageStaticInfo)({
                            pageFilePath: _path.default.join((pageType === "pages" ? pagesDir : appDir) || "", pagePath),
                            nextConfig: config,
                            pageType
                        }) : undefined;
                        if (staticInfo == null ? void 0 : staticInfo.extraConfig) {
                            functionsConfigManifest[page] = staticInfo.extraConfig;
                        }
                        const pageRuntime = middlewareManifest.functions[originalAppPath || page] ? "edge" : staticInfo == null ? void 0 : staticInfo.runtime;
                        if (!isCompile) {
                            isServerComponent = pageType === "app" && (staticInfo == null ? void 0 : staticInfo.rsc) !== _constants1.RSC_MODULE_TYPES.client;
                            if (pageType === "app" || !(0, _utils1.isReservedPage)(page)) {
                                try {
                                    let edgeInfo;
                                    if ((0, _isedgeruntime.isEdgeRuntime)(pageRuntime)) {
                                        if (pageType === "app") {
                                            edgeRuntimeAppCount++;
                                        } else {
                                            edgeRuntimePagesCount++;
                                        }
                                        const manifestKey = pageType === "pages" ? page : originalAppPath || "";
                                        edgeInfo = middlewareManifest.functions[manifestKey];
                                    }
                                    let isPageStaticSpan = checkPageSpan.traceChild("is-page-static");
                                    let workerResult = await isPageStaticSpan.traceAsyncFn(()=>{
                                        var _config_i18n, _config_i18n1;
                                        return (pageType === "app" ? appStaticWorkers : pagesStaticWorkers).isPageStatic({
                                            page,
                                            originalAppPath,
                                            distDir,
                                            configFileName,
                                            runtimeEnvConfig,
                                            httpAgentOptions: config.httpAgentOptions,
                                            locales: (_config_i18n = config.i18n) == null ? void 0 : _config_i18n.locales,
                                            defaultLocale: (_config_i18n1 = config.i18n) == null ? void 0 : _config_i18n1.defaultLocale,
                                            parentId: isPageStaticSpan.id,
                                            pageRuntime,
                                            edgeInfo,
                                            pageType,
                                            incrementalCacheHandlerPath: config.experimental.incrementalCacheHandlerPath,
                                            isrFlushToDisk: config.experimental.isrFlushToDisk,
                                            maxMemoryCacheSize: config.experimental.isrMemoryCacheSize,
                                            nextConfigOutput: config.output
                                        });
                                    });
                                    if (pageType === "app" && originalAppPath) {
                                        appNormalizedPaths.set(originalAppPath, page);
                                        // TODO-APP: handle prerendering with edge
                                        if ((0, _isedgeruntime.isEdgeRuntime)(pageRuntime)) {
                                            isStatic = false;
                                            isSsg = false;
                                        } else {
                                            // If a page has action and it is static, we need to
                                            // change it to SSG to keep the worker created.
                                            // TODO: This is a workaround for now, we should have a
                                            // dedicated worker defined in a heuristic way.
                                            const hasAction = entriesWithAction == null ? void 0 : entriesWithAction.has("app" + originalAppPath);
                                            if (workerResult.encodedPrerenderRoutes && workerResult.prerenderRoutes) {
                                                appStaticPaths.set(originalAppPath, workerResult.prerenderRoutes);
                                                appStaticPathsEncoded.set(originalAppPath, workerResult.encodedPrerenderRoutes);
                                                ssgPageRoutes = workerResult.prerenderRoutes;
                                                isSsg = true;
                                            }
                                            const appConfig = workerResult.appConfig || {};
                                            if (appConfig.revalidate !== 0 && !hasAction) {
                                                var _workerResult_prerenderRoutes;
                                                const isDynamic = (0, _utils.isDynamicRoute)(page);
                                                const hasGenerateStaticParams = !!((_workerResult_prerenderRoutes = workerResult.prerenderRoutes) == null ? void 0 : _workerResult_prerenderRoutes.length);
                                                if (// Mark the app as static if:
                                                // - It has no dynamic param
                                                // - It doesn't have generateStaticParams but `dynamic` is set to
                                                //   `error` or `force-static`
                                                !isDynamic) {
                                                    appStaticPaths.set(originalAppPath, [
                                                        page
                                                    ]);
                                                    appStaticPathsEncoded.set(originalAppPath, [
                                                        page
                                                    ]);
                                                    isStatic = true;
                                                } else if (isDynamic && !hasGenerateStaticParams && (appConfig.dynamic === "error" || appConfig.dynamic === "force-static")) {
                                                    appStaticPaths.set(originalAppPath, []);
                                                    appStaticPathsEncoded.set(originalAppPath, []);
                                                    isStatic = true;
                                                }
                                            }
                                            if (workerResult.prerenderFallback) {
                                                // whether or not to allow requests for paths not
                                                // returned from generateStaticParams
                                                appDynamicParamPaths.add(originalAppPath);
                                            }
                                            appDefaultConfigs.set(originalAppPath, appConfig);
                                        }
                                    } else {
                                        if ((0, _isedgeruntime.isEdgeRuntime)(pageRuntime)) {
                                            if (workerResult.hasStaticProps) {
                                                console.warn(`"getStaticProps" is not yet supported fully with "experimental-edge", detected on ${page}`);
                                            }
                                            // TODO: add handling for statically rendering edge
                                            // pages and allow edge with Prerender outputs
                                            workerResult.isStatic = false;
                                            workerResult.hasStaticProps = false;
                                        }
                                        if (workerResult.isStatic === false && (workerResult.isHybridAmp || workerResult.isAmpOnly)) {
                                            hasSsrAmpPages = true;
                                        }
                                        if (workerResult.isHybridAmp) {
                                            isHybridAmp = true;
                                            hybridAmpPages.add(page);
                                        }
                                        if (workerResult.isNextImageImported) {
                                            isNextImageImported = true;
                                        }
                                        if (workerResult.hasStaticProps) {
                                            ssgPages.add(page);
                                            isSsg = true;
                                            if (workerResult.prerenderRoutes && workerResult.encodedPrerenderRoutes) {
                                                additionalSsgPaths.set(page, workerResult.prerenderRoutes);
                                                additionalSsgPathsEncoded.set(page, workerResult.encodedPrerenderRoutes);
                                                ssgPageRoutes = workerResult.prerenderRoutes;
                                            }
                                            if (workerResult.prerenderFallback === "blocking") {
                                                ssgBlockingFallbackPages.add(page);
                                            } else if (workerResult.prerenderFallback === true) {
                                                ssgStaticFallbackPages.add(page);
                                            }
                                        } else if (workerResult.hasServerProps) {
                                            serverPropsPages.add(page);
                                        } else if (workerResult.isStatic && !isServerComponent && await customAppGetInitialPropsPromise === false) {
                                            staticPages.add(page);
                                            isStatic = true;
                                        } else if (isServerComponent) {
                                            // This is a static server component page that doesn't have
                                            // gSP or gSSP. We still treat it as a SSG page.
                                            ssgPages.add(page);
                                            isSsg = true;
                                        }
                                        if (hasPages404 && page === "/404") {
                                            if (!workerResult.isStatic && !workerResult.hasStaticProps) {
                                                throw new Error(`\`pages/404\` ${_constants.STATIC_STATUS_PAGE_GET_INITIAL_PROPS_ERROR}`);
                                            }
                                            // we need to ensure the 404 lambda is present since we use
                                            // it when _app has getInitialProps
                                            if (await customAppGetInitialPropsPromise && !workerResult.hasStaticProps) {
                                                staticPages.delete(page);
                                            }
                                        }
                                        if (_constants1.STATIC_STATUS_PAGES.includes(page) && !workerResult.isStatic && !workerResult.hasStaticProps) {
                                            throw new Error(`\`pages${page}\` ${_constants.STATIC_STATUS_PAGE_GET_INITIAL_PROPS_ERROR}`);
                                        }
                                    }
                                } catch (err) {
                                    if (!(0, _iserror.default)(err) || err.message !== "INVALID_DEFAULT_EXPORT") throw err;
                                    invalidPages.add(page);
                                }
                            }
                            if (pageType === "app") {
                                if (isSsg || isStatic) {
                                    staticAppPagesCount++;
                                } else {
                                    serverAppPagesCount++;
                                }
                            }
                        }
                        pageInfos.set(page, {
                            size: selfSize,
                            totalSize: allSize,
                            static: isStatic,
                            isSsg,
                            isHybridAmp,
                            ssgPageRoutes,
                            initialRevalidateSeconds: false,
                            runtime: pageRuntime,
                            pageDuration: undefined,
                            ssgPageDurations: undefined
                        });
                    });
                }));
                const errorPageResult = await errorPageStaticResult;
                const nonStaticErrorPage = await errorPageHasCustomGetInitialProps || errorPageResult && errorPageResult.hasServerProps;
                const returnValue = {
                    customAppGetInitialProps: await customAppGetInitialPropsPromise,
                    namedExports: await namedExportsPromise,
                    isNextImageImported,
                    hasSsrAmpPages,
                    hasNonStaticErrorPage: nonStaticErrorPage
                };
                if (!sharedPool) {
                    pagesStaticWorkers.end();
                    appStaticWorkers == null ? void 0 : appStaticWorkers.end();
                }
                return returnValue;
            });
            await runTurbotrace(staticPages);
            if (customAppGetInitialProps) {
                console.warn(_chalk.default.bold.yellow(`Warning: `) + _chalk.default.yellow(`You have opted-out of Automatic Static Optimization due to \`getInitialProps\` in \`pages/_app\`. This does not opt-out pages with \`getStaticProps\``));
                console.warn("Read more: https://nextjs.org/docs/messages/opt-out-auto-static-optimization\n");
            }
            if (!hasSsrAmpPages) {
                requiredServerFiles.ignore.push(_path.default.relative(dir, _path.default.join(_path.default.dirname(require.resolve("next/dist/compiled/@ampproject/toolbox-optimizer")), "**/*")));
            }
            if (Object.keys(functionsConfigManifest).length > 0) {
                const manifest = {
                    version: 1,
                    functions: functionsConfigManifest
                };
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.FUNCTIONS_CONFIG_MANIFEST), JSON.stringify(manifest, null, 2));
            }
            const nextServerTraceOutput = _path.default.join(distDir, "next-server.js.nft.json");
            const nextMinimalTraceOutput = _path.default.join(distDir, "next-minimal-server.js.nft.json");
            if (!isGenerate && config.outputFileTracing) {
                let nodeFileTrace;
                if (config.experimental.turbotrace) {
                    if (!(binding == null ? void 0 : binding.isWasm)) {
                        nodeFileTrace = binding.turbo.startTrace;
                    }
                }
                if (!nodeFileTrace) {
                    nodeFileTrace = require("next/dist/compiled/@vercel/nft").nodeFileTrace;
                }
                const includeExcludeSpan = nextBuildSpan.traceChild("apply-include-excludes");
                const resolvedTraceIncludes = new Map();
                const { outputFileTracingIncludes ={} , outputFileTracingExcludes ={}  } = config.experimental;
                const includeGlobKeys = Object.keys(outputFileTracingIncludes);
                const excludeGlobKeys = Object.keys(outputFileTracingExcludes);
                await includeExcludeSpan.traceAsyncFn(async ()=>{
                    const globOrig = require("next/dist/compiled/glob");
                    const glob = (pattern)=>{
                        return new Promise((resolve, reject)=>{
                            globOrig(pattern, {
                                cwd: dir,
                                nodir: true,
                                dot: true
                            }, (err, files)=>{
                                if (err) {
                                    return reject(err);
                                }
                                resolve(files);
                            });
                        });
                    };
                    if (config.outputFileTracing) {
                        for (let page of pageKeys.pages){
                            // edge routes have no trace files
                            const pageInfo = pageInfos.get(page);
                            if ((pageInfo == null ? void 0 : pageInfo.runtime) === "edge") {
                                continue;
                            }
                            const combinedIncludes = new Set();
                            const combinedExcludes = new Set();
                            page = (0, _normalizepagepath.normalizePagePath)(page);
                            for (const curGlob of includeGlobKeys){
                                if ((0, _micromatch.isMatch)(page, [
                                    curGlob
                                ])) {
                                    outputFileTracingIncludes[curGlob].forEach((include)=>{
                                        combinedIncludes.add(include);
                                    });
                                }
                            }
                            for (const curGlob of excludeGlobKeys){
                                if ((0, _micromatch.isMatch)(page, [
                                    curGlob
                                ])) {
                                    outputFileTracingExcludes[curGlob].forEach((exclude)=>{
                                        combinedExcludes.add(exclude);
                                    });
                                }
                            }
                            if (!(combinedIncludes == null ? void 0 : combinedIncludes.size) && !(combinedExcludes == null ? void 0 : combinedExcludes.size)) {
                                continue;
                            }
                            const traceFile = _path.default.join(distDir, "server/pages", `${page}.js.nft.json`);
                            const pageDir = _path.default.dirname(traceFile);
                            const traceContent = JSON.parse(await _fs.promises.readFile(traceFile, "utf8"));
                            const includes = [];
                            if (combinedIncludes == null ? void 0 : combinedIncludes.size) {
                                await Promise.all([
                                    ...combinedIncludes
                                ].map(async (includeGlob)=>{
                                    const results = await glob(includeGlob);
                                    const resolvedInclude = resolvedTraceIncludes.get(includeGlob) || [
                                        ...results.map((file)=>{
                                            return _path.default.relative(pageDir, _path.default.join(dir, file));
                                        })
                                    ];
                                    includes.push(...resolvedInclude);
                                    resolvedTraceIncludes.set(includeGlob, resolvedInclude);
                                }));
                            }
                            const combined = new Set([
                                ...traceContent.files,
                                ...includes
                            ]);
                            if (combinedExcludes == null ? void 0 : combinedExcludes.size) {
                                const resolvedGlobs = [
                                    ...combinedExcludes
                                ].map((exclude)=>_path.default.join(dir, exclude));
                                combined.forEach((file)=>{
                                    if ((0, _micromatch.isMatch)(_path.default.join(pageDir, file), resolvedGlobs)) {
                                        combined.delete(file);
                                    }
                                });
                            }
                            await _fs.promises.writeFile(traceFile, JSON.stringify({
                                version: traceContent.version,
                                files: [
                                    ...combined
                                ]
                            }));
                        }
                    }
                });
                await nextBuildSpan.traceChild("trace-next-server").traceAsyncFn(async ()=>{
                    var _config_experimental, _config_experimental_turbotrace;
                    let cacheKey;
                    // consider all lockFiles in tree in case user accidentally
                    // has both package-lock.json and yarn.lock
                    const lockFiles = (await Promise.all([
                        "package-lock.json",
                        "yarn.lock",
                        "pnpm-lock.yaml"
                    ].map((file)=>(0, _findup.default)(file, {
                            cwd: dir
                        })))).filter(Boolean)// TypeScript doesn't like this filter
                    ;
                    const cachedTracePath = _path.default.join(distDir, "cache/next-server.js.nft.json");
                    if (lockFiles.length > 0 && // we can't leverage trace cache if this is configured
                    // currently unless we break this to a separate trace
                    // file
                    !config.experimental.incrementalCacheHandlerPath) {
                        const cacheHash = require("crypto").createHash("sha1");
                        cacheHash.update(require("next/package").version);
                        cacheHash.update(hasSsrAmpPages + "");
                        cacheHash.update(_ciinfo.hasNextSupport + "");
                        await Promise.all(lockFiles.map(async (lockFile)=>{
                            cacheHash.update(await _fs.promises.readFile(lockFile));
                        }));
                        cacheKey = cacheHash.digest("hex");
                        try {
                            const existingTrace = JSON.parse(await _fs.promises.readFile(cachedTracePath, "utf8"));
                            if (existingTrace.cacheKey === cacheKey) {
                                await _fs.promises.copyFile(cachedTracePath, nextServerTraceOutput);
                                return;
                            }
                        } catch (_) {}
                    }
                    const root = ((_config_experimental = config.experimental) == null ? void 0 : (_config_experimental_turbotrace = _config_experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace.contextDirectory) ?? outputFileTracingRoot;
                    // Under standalone mode, we need to trace the extra IPC server and
                    // worker files.
                    const isStandalone = config.output === "standalone";
                    const nextServerEntry = require.resolve("next/dist/server/next-server");
                    const sharedEntriesSet = [
                        ...Object.values(_requirehook.baseOverrides).map((override)=>require.resolve(override)),
                        ...Object.values(_requirehook.experimentalOverrides).map((override)=>require.resolve(override))
                    ];
                    // ensure we trace any dependencies needed for custom
                    // incremental cache handler
                    if (incrementalCacheHandlerPath) {
                        sharedEntriesSet.push(require.resolve(_path.default.isAbsolute(incrementalCacheHandlerPath) ? incrementalCacheHandlerPath : _path.default.join(dir, incrementalCacheHandlerPath)));
                    }
                    const vanillaServerEntries = [
                        ...sharedEntriesSet,
                        isStandalone ? require.resolve("next/dist/server/lib/render-server-standalone") : null,
                        require.resolve("next/dist/server/next-server")
                    ].filter(Boolean);
                    const minimalServerEntries = [
                        ...sharedEntriesSet,
                        require.resolve("next/dist/compiled/minimal-next-server/next-server-cached.js"),
                        require.resolve("next/dist/compiled/minimal-next-server/next-server.js")
                    ].filter(Boolean);
                    const additionalIgnores = new Set();
                    for (const glob of excludeGlobKeys){
                        if ((0, _micromatch.isMatch)("next-server", glob)) {
                            outputFileTracingExcludes[glob].forEach((exclude)=>{
                                additionalIgnores.add(exclude);
                            });
                        }
                    }
                    const ignores = [
                        "**/*.d.ts",
                        "**/*.map",
                        "**/next/dist/pages/**/*",
                        isStandalone ? null : "**/next/dist/compiled/jest-worker/**/*",
                        "**/next/dist/compiled/webpack/(bundle4|bundle5).js",
                        "**/node_modules/webpack5/**/*",
                        "**/next/dist/server/lib/squoosh/**/*.wasm",
                        "**/next/dist/server/lib/route-resolver*",
                        ..._ciinfo.hasNextSupport ? [
                            // only ignore image-optimizer code when
                            // this is being handled outside of next-server
                            "**/next/dist/server/image-optimizer.js",
                            "**/node_modules/sharp/**/*"
                        ] : [],
                        ...!hasSsrAmpPages ? [
                            "**/next/dist/compiled/@ampproject/toolbox-optimizer/**/*"
                        ] : [],
                        ...additionalIgnores
                    ].filter(_nonnullable.nonNullable);
                    const ignoreFn = (pathname)=>{
                        if (_path.default.isAbsolute(pathname) && !pathname.startsWith(root)) {
                            return true;
                        }
                        return (0, _micromatch.isMatch)(pathname, ignores, {
                            contains: true,
                            dot: true
                        });
                    };
                    const traceContext = _path.default.join(nextServerEntry, "..", "..");
                    const tracedFiles = new Set();
                    const minimalTracedFiles = new Set();
                    function addToTracedFiles(base, file, dest) {
                        dest.add(_path.default.relative(distDir, _path.default.join(base, file)).replace(/\\/g, "/"));
                    }
                    if (isStandalone) {
                        addToTracedFiles("", require.resolve("next/dist/compiled/jest-worker/processChild"), tracedFiles);
                        addToTracedFiles("", require.resolve("next/dist/compiled/jest-worker/threadChild"), tracedFiles);
                    }
                    if (config.experimental.turbotrace) {
                        const makeTrace = async (entries)=>{
                            var _config_experimental_turbotrace, _config_experimental_turbotrace1, _config_experimental_turbotrace2, _config_experimental_turbotrace3;
                            return nodeFileTrace({
                                action: "print",
                                input: entries,
                                contextDirectory: traceContext,
                                logLevel: (_config_experimental_turbotrace = config.experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace.logLevel,
                                processCwd: (_config_experimental_turbotrace1 = config.experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace1.processCwd,
                                logDetail: (_config_experimental_turbotrace2 = config.experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace2.logDetail,
                                showAll: (_config_experimental_turbotrace3 = config.experimental.turbotrace) == null ? void 0 : _config_experimental_turbotrace3.logAll
                            }, turboTasksForTrace);
                        };
                        // turbotrace does not handle concurrent tracing
                        const vanillaFiles = await makeTrace(vanillaServerEntries);
                        const minimalFiles = await makeTrace(minimalServerEntries);
                        for (const [set, files] of [
                            [
                                tracedFiles,
                                vanillaFiles
                            ],
                            [
                                minimalTracedFiles,
                                minimalFiles
                            ]
                        ]){
                            for (const file of files){
                                if (!ignoreFn(_path.default.join(traceContext, file))) {
                                    addToTracedFiles(traceContext, file, set);
                                }
                            }
                        }
                    } else {
                        const makeTrace = async (entries)=>nodeFileTrace(entries, {
                                base: root,
                                processCwd: dir,
                                ignore: ignoreFn
                            });
                        const [vanillaFiles, minimalFiles] = await Promise.all([
                            makeTrace(vanillaServerEntries),
                            makeTrace(minimalServerEntries)
                        ]);
                        for (const [set, traceResult] of [
                            [
                                tracedFiles,
                                vanillaFiles
                            ],
                            [
                                minimalTracedFiles,
                                minimalFiles
                            ]
                        ]){
                            for (const file of traceResult.fileList){
                                addToTracedFiles(root, file, set);
                            }
                        }
                    }
                    await Promise.all([
                        _fs.promises.writeFile(nextServerTraceOutput, JSON.stringify({
                            version: 1,
                            cacheKey,
                            files: Array.from(tracedFiles)
                        })),
                        _fs.promises.writeFile(nextMinimalTraceOutput, JSON.stringify({
                            version: 1,
                            cacheKey,
                            files: Array.from(minimalTracedFiles)
                        }))
                    ]);
                    await _fs.promises.unlink(cachedTracePath).catch(()=>{});
                    await _fs.promises.copyFile(nextServerTraceOutput, cachedTracePath).catch(()=>{});
                });
            }
            if (serverPropsPages.size > 0 || ssgPages.size > 0) {
                // We update the routes manifest after the build with the
                // data routes since we can't determine these until after build
                routesManifest.dataRoutes = (0, _utils.getSortedRoutes)([
                    ...serverPropsPages,
                    ...ssgPages
                ]).map((page)=>{
                    const pagePath = (0, _normalizepagepath.normalizePagePath)(page);
                    const dataRoute = _path.default.posix.join("/_next/data", buildId, `${pagePath}.json`);
                    let dataRouteRegex;
                    let namedDataRouteRegex;
                    let routeKeys;
                    if ((0, _utils.isDynamicRoute)(page)) {
                        const routeRegex = (0, _routeregex.getNamedRouteRegex)(dataRoute.replace(/\.json$/, ""), true);
                        dataRouteRegex = (0, _loadcustomroutes.normalizeRouteRegex)(routeRegex.re.source.replace(/\(\?:\\\/\)\?\$$/, `\\.json$`));
                        namedDataRouteRegex = routeRegex.namedRegex.replace(/\(\?:\/\)\?\$$/, `\\.json$`);
                        routeKeys = routeRegex.routeKeys;
                    } else {
                        dataRouteRegex = (0, _loadcustomroutes.normalizeRouteRegex)(new RegExp(`^${_path.default.posix.join("/_next/data", (0, _escaperegexp.escapeStringRegexp)(buildId), `${pagePath}.json`)}$`).source);
                    }
                    return {
                        page,
                        routeKeys,
                        dataRouteRegex,
                        namedDataRouteRegex
                    };
                });
                await _fs.promises.writeFile(routesManifestPath, JSON.stringify(routesManifest), "utf8");
            }
            // Since custom _app.js can wrap the 404 page we have to opt-out of static optimization if it has getInitialProps
            // Only export the static 404 when there is no /_error present
            const useStatic404 = !customAppGetInitialProps && (!hasNonStaticErrorPage || hasPages404 || hasApp404);
            if (invalidPages.size > 0) {
                const err = new Error(`Build optimization failed: found page${invalidPages.size === 1 ? "" : "s"} without a React Component as default export in \n${[
                    ...invalidPages
                ].map((pg)=>`pages${pg}`).join("\n")}\n\nSee https://nextjs.org/docs/messages/page-without-valid-component for more info.\n`);
                err.code = "BUILD_OPTIMIZATION_FAILED";
                throw err;
            }
            await (0, _writebuildid.writeBuildId)(distDir, buildId);
            if (config.experimental.optimizeCss) {
                const globOrig = require("next/dist/compiled/glob");
                const cssFilePaths = await new Promise((resolve, reject)=>{
                    globOrig("**/*.css", {
                        cwd: _path.default.join(distDir, "static")
                    }, (err, files)=>{
                        if (err) {
                            return reject(err);
                        }
                        resolve(files);
                    });
                });
                requiredServerFiles.files.push(...cssFilePaths.map((filePath)=>_path.default.join(config.distDir, "static", filePath)));
            }
            const features = [
                {
                    featureName: "experimental/optimizeCss",
                    invocationCount: config.experimental.optimizeCss ? 1 : 0
                },
                {
                    featureName: "experimental/nextScriptWorkers",
                    invocationCount: config.experimental.nextScriptWorkers ? 1 : 0
                },
                {
                    featureName: "optimizeFonts",
                    invocationCount: config.optimizeFonts ? 1 : 0
                }
            ];
            telemetry.record(features.map((feature)=>{
                return {
                    eventName: _events.EVENT_BUILD_FEATURE_USAGE,
                    payload: feature
                };
            }));
            await _fs.promises.writeFile(_path.default.join(distDir, _constants1.SERVER_FILES_MANIFEST), JSON.stringify(requiredServerFiles), "utf8");
            const middlewareManifest = JSON.parse(await _fs.promises.readFile(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_MANIFEST), "utf8"));
            if (config.output === "standalone") {
                await nextBuildSpan.traceChild("copy-traced-files").traceAsyncFn(async ()=>{
                    await (0, _utils1.copyTracedFiles)(dir, distDir, pageKeys.pages, denormalizedAppPages, outputFileTracingRoot, requiredServerFiles.config, middlewareManifest, hasInstrumentationHook);
                });
            }
            const finalPrerenderRoutes = {};
            const finalDynamicRoutes = {};
            const tbdPrerenderRoutes = [];
            let ssgNotFoundPaths = [];
            if (postCompileSpinner) postCompileSpinner.stopAndPersist();
            const { i18n  } = config;
            const usedStaticStatusPages = _constants1.STATIC_STATUS_PAGES.filter((page)=>mappedPages[page] && mappedPages[page].startsWith("private-next-pages"));
            usedStaticStatusPages.forEach((page)=>{
                if (!ssgPages.has(page) && !customAppGetInitialProps) {
                    staticPages.add(page);
                }
            });
            const hasPages500 = usedStaticStatusPages.includes("/500");
            const useDefaultStatic500 = !hasPages500 && !hasNonStaticErrorPage && !customAppGetInitialProps;
            const combinedPages = [
                ...staticPages,
                ...ssgPages
            ];
            // we need to trigger automatic exporting when we have
            // - static 404/500
            // - getStaticProps paths
            // - experimental app is enabled
            if (!isCompile && (combinedPages.length > 0 || useStatic404 || useDefaultStatic500 || isAppDirEnabled)) {
                const staticGenerationSpan = nextBuildSpan.traceChild("static-generation");
                await staticGenerationSpan.traceAsyncFn(async ()=>{
                    (0, _utils1.detectConflictingPaths)([
                        ...combinedPages,
                        ...pageKeys.pages.filter((page)=>!combinedPages.includes(page))
                    ], ssgPages, additionalSsgPaths);
                    const exportApp = require("../export").default;
                    const exportConfig = {
                        ...config,
                        initialPageRevalidationMap: {},
                        initialPageMetaMap: {},
                        pageDurationMap: {},
                        ssgNotFoundPaths: [],
                        // Default map will be the collection of automatic statically exported
                        // pages and incremental pages.
                        // n.b. we cannot handle this above in combinedPages because the dynamic
                        // page must be in the `pages` array, but not in the mapping.
                        exportPathMap: (defaultMap)=>{
                            // Dynamically routed pages should be prerendered to be used as
                            // a client-side skeleton (fallback) while data is being fetched.
                            // This ensures the end-user never sees a 500 or slow response from the
                            // server.
                            //
                            // Note: prerendering disables automatic static optimization.
                            ssgPages.forEach((page)=>{
                                if ((0, _utils.isDynamicRoute)(page)) {
                                    tbdPrerenderRoutes.push(page);
                                    if (ssgStaticFallbackPages.has(page)) {
                                        // Override the rendering for the dynamic page to be treated as a
                                        // fallback render.
                                        if (i18n) {
                                            defaultMap[`/${i18n.defaultLocale}${page}`] = {
                                                page,
                                                query: {
                                                    __nextFallback: "true"
                                                }
                                            };
                                        } else {
                                            defaultMap[page] = {
                                                page,
                                                query: {
                                                    __nextFallback: "true"
                                                }
                                            };
                                        }
                                    } else {
                                        // Remove dynamically routed pages from the default path map when
                                        // fallback behavior is disabled.
                                        delete defaultMap[page];
                                    }
                                }
                            });
                            // Append the "well-known" routes we should prerender for, e.g. blog
                            // post slugs.
                            additionalSsgPaths.forEach((routes, page)=>{
                                const encodedRoutes = additionalSsgPathsEncoded.get(page);
                                routes.forEach((route, routeIdx)=>{
                                    defaultMap[route] = {
                                        page,
                                        query: {
                                            __nextSsgPath: encodedRoutes == null ? void 0 : encodedRoutes[routeIdx]
                                        }
                                    };
                                });
                            });
                            if (useStatic404) {
                                defaultMap["/404"] = {
                                    page: hasPages404 ? "/404" : "/_error"
                                };
                            }
                            if (useDefaultStatic500) {
                                defaultMap["/500"] = {
                                    page: "/_error"
                                };
                            }
                            // TODO: output manifest specific to app paths and their
                            // revalidate periods and dynamicParams settings
                            appStaticPaths.forEach((routes, originalAppPath)=>{
                                const encodedRoutes = appStaticPathsEncoded.get(originalAppPath);
                                const appConfig = appDefaultConfigs.get(originalAppPath) || {};
                                routes.forEach((route, routeIdx)=>{
                                    defaultMap[route] = {
                                        page: originalAppPath,
                                        query: {
                                            __nextSsgPath: encodedRoutes == null ? void 0 : encodedRoutes[routeIdx]
                                        },
                                        _isDynamicError: appConfig.dynamic === "error",
                                        _isAppDir: true
                                    };
                                });
                            });
                            if (i18n) {
                                for (const page of [
                                    ...staticPages,
                                    ...ssgPages,
                                    ...useStatic404 ? [
                                        "/404"
                                    ] : [],
                                    ...useDefaultStatic500 ? [
                                        "/500"
                                    ] : []
                                ]){
                                    const isSsg = ssgPages.has(page);
                                    const isDynamic = (0, _utils.isDynamicRoute)(page);
                                    const isFallback = isSsg && ssgStaticFallbackPages.has(page);
                                    for (const locale of i18n.locales){
                                        var _defaultMap_page;
                                        // skip fallback generation for SSG pages without fallback mode
                                        if (isSsg && isDynamic && !isFallback) continue;
                                        const outputPath = `/${locale}${page === "/" ? "" : page}`;
                                        defaultMap[outputPath] = {
                                            page: ((_defaultMap_page = defaultMap[page]) == null ? void 0 : _defaultMap_page.page) || page,
                                            query: {
                                                __nextLocale: locale,
                                                __nextFallback: isFallback ? "true" : undefined
                                            }
                                        };
                                    }
                                    if (isSsg) {
                                        // remove non-locale prefixed variant from defaultMap
                                        delete defaultMap[page];
                                    }
                                }
                            }
                            return defaultMap;
                        }
                    };
                    const exportOptions = {
                        isInvokedFromCli: false,
                        nextConfig: exportConfig,
                        hasAppDir,
                        silent: false,
                        buildExport: true,
                        debugOutput,
                        threads: config.experimental.cpus,
                        pages: combinedPages,
                        outdir: _path.default.join(distDir, "export"),
                        statusMessage: "Generating static pages",
                        exportAppPageWorker: sharedPool ? appStaticWorkers == null ? void 0 : appStaticWorkers.exportPage.bind(appStaticWorkers) : undefined,
                        exportPageWorker: sharedPool ? pagesStaticWorkers.exportPage.bind(pagesStaticWorkers) : undefined,
                        endWorker: sharedPool ? async ()=>{
                            await pagesStaticWorkers.end();
                            await (appStaticWorkers == null ? void 0 : appStaticWorkers.end());
                        } : undefined
                    };
                    await exportApp(dir, exportOptions, nextBuildSpan);
                    const postBuildSpinner = (0, _spinner.default)({
                        prefixText: `${_log.prefixes.info} Finalizing page optimization`
                    });
                    ssgNotFoundPaths = exportConfig.ssgNotFoundPaths;
                    // remove server bundles that were exported
                    for (const page of staticPages){
                        const serverBundle = (0, _require.getPagePath)(page, distDir, undefined, false);
                        await _fs.promises.unlink(serverBundle);
                    }
                    for (const [originalAppPath, routes] of appStaticPaths){
                        const page = appNormalizedPaths.get(originalAppPath) || "";
                        const appConfig = appDefaultConfigs.get(originalAppPath) || {};
                        let hasDynamicData = appConfig.revalidate === 0 || exportConfig.initialPageRevalidationMap[page] === 0;
                        const isRouteHandler = (0, _isapprouteroute.isAppRouteRoute)(originalAppPath);
                        routes.forEach((route)=>{
                            if ((0, _utils.isDynamicRoute)(page) && route === page) return;
                            if (route === "/_not-found") return;
                            let revalidate = exportConfig.initialPageRevalidationMap[route];
                            if (typeof revalidate === "undefined") {
                                revalidate = typeof appConfig.revalidate !== "undefined" ? appConfig.revalidate : false;
                            }
                            // ensure revalidate is normalized correctly
                            if (typeof revalidate !== "number" && typeof revalidate !== "boolean") {
                                revalidate = false;
                            }
                            if (revalidate !== 0) {
                                const normalizedRoute = (0, _normalizepagepath.normalizePagePath)(route);
                                const dataRoute = isRouteHandler ? null : _path.default.posix.join(`${normalizedRoute}.rsc`);
                                const routeMeta = {};
                                const exportRouteMeta = exportConfig.initialPageMetaMap[route] || {};
                                if (exportRouteMeta.status !== 200) {
                                    routeMeta.initialStatus = exportRouteMeta.status;
                                }
                                const exportHeaders = exportRouteMeta.headers;
                                const headerKeys = Object.keys(exportHeaders || {});
                                if (exportHeaders && headerKeys.length) {
                                    routeMeta.initialHeaders = {};
                                    // normalize header values as initialHeaders
                                    // must be Record<string, string>
                                    for (const key of headerKeys){
                                        let value = exportHeaders[key];
                                        if (Array.isArray(value)) {
                                            if (key === "set-cookie") {
                                                value = value.join(",");
                                            } else {
                                                value = value[value.length - 1];
                                            }
                                        }
                                        if (typeof value === "string") {
                                            routeMeta.initialHeaders[key] = value;
                                        }
                                    }
                                }
                                finalPrerenderRoutes[route] = {
                                    ...routeMeta,
                                    initialRevalidateSeconds: revalidate,
                                    srcRoute: page,
                                    dataRoute
                                };
                            } else {
                                hasDynamicData = true;
                                // we might have determined during prerendering that this page
                                // used dynamic data
                                pageInfos.set(route, {
                                    ...pageInfos.get(route),
                                    isSsg: false,
                                    static: false
                                });
                            }
                        });
                        if (!hasDynamicData && (0, _utils.isDynamicRoute)(originalAppPath)) {
                            const normalizedRoute = (0, _normalizepagepath.normalizePagePath)(page);
                            const dataRoute = _path.default.posix.join(`${normalizedRoute}.rsc`);
                            // TODO: create a separate manifest to allow enforcing
                            // dynamicParams for non-static paths?
                            finalDynamicRoutes[page] = {
                                routeRegex: (0, _loadcustomroutes.normalizeRouteRegex)((0, _routeregex.getNamedRouteRegex)(page, false).re.source),
                                dataRoute,
                                // if dynamicParams are enabled treat as fallback:
                                // 'blocking' if not it's fallback: false
                                fallback: appDynamicParamPaths.has(originalAppPath) ? null : false,
                                dataRouteRegex: isRouteHandler ? null : (0, _loadcustomroutes.normalizeRouteRegex)((0, _routeregex.getNamedRouteRegex)(dataRoute.replace(/\.rsc$/, ""), false).re.source.replace(/\(\?:\\\/\)\?\$$/, "\\.rsc$"))
                            };
                        }
                    }
                    const moveExportedPage = async (originPage, page, file, isSsg, ext, additionalSsgFile = false)=>{
                        return staticGenerationSpan.traceChild("move-exported-page").traceAsyncFn(async ()=>{
                            file = `${file}.${ext}`;
                            const orig = _path.default.join(exportOptions.outdir, file);
                            const pagePath = (0, _require.getPagePath)(originPage, distDir, undefined, false);
                            const relativeDest = _path.default.relative(_path.default.join(distDir, _constants1.SERVER_DIRECTORY), _path.default.join(_path.default.join(pagePath, // strip leading / and then recurse number of nested dirs
                            // to place from base folder
                            originPage.slice(1).split("/").map(()=>"..").join("/")), file)).replace(/\\/g, "/");
                            if (!isSsg && !// don't add static status page to manifest if it's
                            // the default generated version e.g. no pages/500
                            (_constants1.STATIC_STATUS_PAGES.includes(page) && !usedStaticStatusPages.includes(page))) {
                                pagesManifest[page] = relativeDest;
                            }
                            const dest = _path.default.join(distDir, _constants1.SERVER_DIRECTORY, relativeDest);
                            const isNotFound = ssgNotFoundPaths.includes(page);
                            // for SSG files with i18n the non-prerendered variants are
                            // output with the locale prefixed so don't attempt moving
                            // without the prefix
                            if ((!i18n || additionalSsgFile) && !isNotFound) {
                                await _fs.promises.mkdir(_path.default.dirname(dest), {
                                    recursive: true
                                });
                                await _fs.promises.rename(orig, dest);
                            } else if (i18n && !isSsg) {
                                // this will be updated with the locale prefixed variant
                                // since all files are output with the locale prefix
                                delete pagesManifest[page];
                            }
                            if (i18n) {
                                if (additionalSsgFile) return;
                                for (const locale of i18n.locales){
                                    const curPath = `/${locale}${page === "/" ? "" : page}`;
                                    const localeExt = page === "/" ? _path.default.extname(file) : "";
                                    const relativeDestNoPages = relativeDest.slice("pages/".length);
                                    if (isSsg && ssgNotFoundPaths.includes(curPath)) {
                                        continue;
                                    }
                                    const updatedRelativeDest = _path.default.join("pages", locale + localeExt, // if it's the top-most index page we want it to be locale.EXT
                                    // instead of locale/index.html
                                    page === "/" ? "" : relativeDestNoPages).replace(/\\/g, "/");
                                    const updatedOrig = _path.default.join(exportOptions.outdir, locale + localeExt, page === "/" ? "" : file);
                                    const updatedDest = _path.default.join(distDir, _constants1.SERVER_DIRECTORY, updatedRelativeDest);
                                    if (!isSsg) {
                                        pagesManifest[curPath] = updatedRelativeDest;
                                    }
                                    await _fs.promises.mkdir(_path.default.dirname(updatedDest), {
                                        recursive: true
                                    });
                                    await _fs.promises.rename(updatedOrig, updatedDest);
                                }
                            }
                        });
                    };
                    async function moveExportedAppNotFoundTo404() {
                        return staticGenerationSpan.traceChild("move-exported-app-not-found-").traceAsyncFn(async ()=>{
                            const orig = _path.default.join(distDir, "server", "app", "_not-found.html");
                            const updatedRelativeDest = _path.default.join("pages", "404.html").replace(/\\/g, "/");
                            if (await (0, _fileexists.fileExists)(orig)) {
                                await _fs.promises.copyFile(orig, _path.default.join(distDir, "server", updatedRelativeDest));
                                pagesManifest["/404"] = updatedRelativeDest;
                            }
                        });
                    }
                    // If there's /not-found inside app, we prefer it over the pages 404
                    if (hasApp404 && useStatic404) {
                        // await moveExportedPage('/_error', '/404', '/404', false, 'html')
                        await moveExportedAppNotFoundTo404();
                    } else {
                        // Only move /404 to /404 when there is no custom 404 as in that case we don't know about the 404 page
                        if (!hasPages404 && useStatic404) {
                            await moveExportedPage("/_error", "/404", "/404", false, "html");
                        }
                    }
                    if (useDefaultStatic500) {
                        await moveExportedPage("/_error", "/500", "/500", false, "html");
                    }
                    for (const page of combinedPages){
                        const isSsg = ssgPages.has(page);
                        const isStaticSsgFallback = ssgStaticFallbackPages.has(page);
                        const isDynamic = (0, _utils.isDynamicRoute)(page);
                        const hasAmp = hybridAmpPages.has(page);
                        const file = (0, _normalizepagepath.normalizePagePath)(page);
                        const pageInfo = pageInfos.get(page);
                        const durationInfo = exportConfig.pageDurationMap[page];
                        if (pageInfo && durationInfo) {
                            // Set Build Duration
                            if (pageInfo.ssgPageRoutes) {
                                pageInfo.ssgPageDurations = pageInfo.ssgPageRoutes.map((pagePath)=>durationInfo[pagePath]);
                            }
                            pageInfo.pageDuration = durationInfo[page];
                        }
                        // The dynamic version of SSG pages are only prerendered if the
                        // fallback is enabled. Below, we handle the specific prerenders
                        // of these.
                        const hasHtmlOutput = !(isSsg && isDynamic && !isStaticSsgFallback);
                        if (hasHtmlOutput) {
                            await moveExportedPage(page, page, file, isSsg, "html");
                        }
                        if (hasAmp && (!isSsg || isSsg && !isDynamic)) {
                            const ampPage = `${file}.amp`;
                            await moveExportedPage(page, ampPage, ampPage, isSsg, "html");
                            if (isSsg) {
                                await moveExportedPage(page, ampPage, ampPage, isSsg, "json");
                            }
                        }
                        if (isSsg) {
                            // For a non-dynamic SSG page, we must copy its data file
                            // from export, we already moved the HTML file above
                            if (!isDynamic) {
                                await moveExportedPage(page, page, file, isSsg, "json");
                                if (i18n) {
                                    // TODO: do we want to show all locale variants in build output
                                    for (const locale of i18n.locales){
                                        const localePage = `/${locale}${page === "/" ? "" : page}`;
                                        finalPrerenderRoutes[localePage] = {
                                            initialRevalidateSeconds: exportConfig.initialPageRevalidationMap[localePage],
                                            srcRoute: null,
                                            dataRoute: _path.default.posix.join("/_next/data", buildId, `${file}.json`)
                                        };
                                    }
                                } else {
                                    finalPrerenderRoutes[page] = {
                                        initialRevalidateSeconds: exportConfig.initialPageRevalidationMap[page],
                                        srcRoute: null,
                                        dataRoute: _path.default.posix.join("/_next/data", buildId, `${file}.json`)
                                    };
                                }
                                // Set Page Revalidation Interval
                                if (pageInfo) {
                                    pageInfo.initialRevalidateSeconds = exportConfig.initialPageRevalidationMap[page];
                                }
                            } else {
                                // For a dynamic SSG page, we did not copy its data exports and only
                                // copy the fallback HTML file (if present).
                                // We must also copy specific versions of this page as defined by
                                // `getStaticPaths` (additionalSsgPaths).
                                const extraRoutes = additionalSsgPaths.get(page) || [];
                                for (const route of extraRoutes){
                                    const pageFile = (0, _normalizepagepath.normalizePagePath)(route);
                                    await moveExportedPage(page, route, pageFile, isSsg, "html", true);
                                    await moveExportedPage(page, route, pageFile, isSsg, "json", true);
                                    if (hasAmp) {
                                        const ampPage = `${pageFile}.amp`;
                                        await moveExportedPage(page, ampPage, ampPage, isSsg, "html", true);
                                        await moveExportedPage(page, ampPage, ampPage, isSsg, "json", true);
                                    }
                                    finalPrerenderRoutes[route] = {
                                        initialRevalidateSeconds: exportConfig.initialPageRevalidationMap[route],
                                        srcRoute: page,
                                        dataRoute: _path.default.posix.join("/_next/data", buildId, `${(0, _normalizepagepath.normalizePagePath)(route)}.json`)
                                    };
                                    // Set route Revalidation Interval
                                    if (pageInfo) {
                                        pageInfo.initialRevalidateSeconds = exportConfig.initialPageRevalidationMap[route];
                                    }
                                }
                            }
                        }
                    }
                    // remove temporary export folder
                    await (0, _recursivedelete.recursiveDelete)(exportOptions.outdir);
                    await _fs.promises.rmdir(exportOptions.outdir);
                    await _fs.promises.writeFile(manifestPath, JSON.stringify(pagesManifest, null, 2), "utf8");
                    if (postBuildSpinner) postBuildSpinner.stopAndPersist();
                    console.log();
                });
            }
            // ensure the worker is not left hanging
            pagesStaticWorkers.close();
            appStaticWorkers == null ? void 0 : appStaticWorkers.close();
            const analysisEnd = process.hrtime(analysisBegin);
            telemetry.record((0, _events.eventBuildOptimize)(pagesPaths, {
                durationInSeconds: analysisEnd[0],
                staticPageCount: staticPages.size,
                staticPropsPageCount: ssgPages.size,
                serverPropsPageCount: serverPropsPages.size,
                ssrPageCount: pagesPaths.length - (staticPages.size + ssgPages.size + serverPropsPages.size),
                hasStatic404: useStatic404,
                hasReportWebVitals: (namedExports == null ? void 0 : namedExports.includes("reportWebVitals")) ?? false,
                rewritesCount: combinedRewrites.length,
                headersCount: headers.length,
                redirectsCount: redirects.length - 1,
                headersWithHasCount: headers.filter((r)=>!!r.has).length,
                rewritesWithHasCount: combinedRewrites.filter((r)=>!!r.has).length,
                redirectsWithHasCount: redirects.filter((r)=>!!r.has).length,
                middlewareCount: Object.keys(rootPaths).length > 0 ? 1 : 0,
                totalAppPagesCount,
                staticAppPagesCount,
                serverAppPagesCount,
                edgeRuntimeAppCount,
                edgeRuntimePagesCount
            }));
            if (_buildcontext.NextBuildContext.telemetryPlugin) {
                const events = (0, _events.eventBuildFeatureUsage)(_buildcontext.NextBuildContext.telemetryPlugin);
                telemetry.record(events);
                telemetry.record((0, _events.eventPackageUsedInGetServerSideProps)(_buildcontext.NextBuildContext.telemetryPlugin));
            }
            if (ssgPages.size > 0 || appDir) {
                var _config_i18n;
                tbdPrerenderRoutes.forEach((tbdRoute)=>{
                    const normalizedRoute = (0, _normalizepagepath.normalizePagePath)(tbdRoute);
                    const dataRoute = _path.default.posix.join("/_next/data", buildId, `${normalizedRoute}.json`);
                    finalDynamicRoutes[tbdRoute] = {
                        routeRegex: (0, _loadcustomroutes.normalizeRouteRegex)((0, _routeregex.getNamedRouteRegex)(tbdRoute, false).re.source),
                        dataRoute,
                        fallback: ssgBlockingFallbackPages.has(tbdRoute) ? null : ssgStaticFallbackPages.has(tbdRoute) ? `${normalizedRoute}.html` : false,
                        dataRouteRegex: (0, _loadcustomroutes.normalizeRouteRegex)((0, _routeregex.getNamedRouteRegex)(dataRoute.replace(/\.json$/, ""), false).re.source.replace(/\(\?:\\\/\)\?\$$/, "\\.json$"))
                    };
                });
                const prerenderManifest = {
                    version: 4,
                    routes: finalPrerenderRoutes,
                    dynamicRoutes: finalDynamicRoutes,
                    notFoundRoutes: ssgNotFoundPaths,
                    preview: previewProps
                };
                _buildcontext.NextBuildContext.previewModeId = previewProps.previewModeId;
                _buildcontext.NextBuildContext.fetchCacheKeyPrefix = config.experimental.fetchCacheKeyPrefix;
                _buildcontext.NextBuildContext.allowedRevalidateHeaderKeys = config.experimental.allowedRevalidateHeaderKeys;
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.PRERENDER_MANIFEST), JSON.stringify(prerenderManifest), "utf8");
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.PRERENDER_MANIFEST).replace(/\.json$/, ".js"), `self.__PRERENDER_MANIFEST=${JSON.stringify(JSON.stringify(prerenderManifest))}`, "utf8");
                await generateClientSsgManifest(prerenderManifest, {
                    distDir,
                    buildId,
                    locales: ((_config_i18n = config.i18n) == null ? void 0 : _config_i18n.locales) || []
                });
            } else {
                const prerenderManifest = {
                    version: 4,
                    routes: {},
                    dynamicRoutes: {},
                    preview: previewProps,
                    notFoundRoutes: []
                };
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.PRERENDER_MANIFEST), JSON.stringify(prerenderManifest), "utf8");
                await _fs.promises.writeFile(_path.default.join(distDir, _constants1.PRERENDER_MANIFEST).replace(/\.json$/, ".js"), `self.__PRERENDER_MANIFEST=${JSON.stringify(JSON.stringify(prerenderManifest))}`, "utf8");
            }
            const images = {
                ...config.images
            };
            const { deviceSizes , imageSizes  } = images;
            images.sizes = [
                ...deviceSizes,
                ...imageSizes
            ];
            images.remotePatterns = ((config == null ? void 0 : (_config_images = config.images) == null ? void 0 : _config_images.remotePatterns) || []).map((p)=>({
                    // Should be the same as matchRemotePattern()
                    protocol: p.protocol,
                    hostname: (0, _micromatch.makeRe)(p.hostname).source,
                    port: p.port,
                    pathname: (0, _micromatch.makeRe)(p.pathname ?? "**").source
                }));
            await _fs.promises.writeFile(_path.default.join(distDir, _constants1.IMAGES_MANIFEST), JSON.stringify({
                version: 1,
                images
            }), "utf8");
            await _fs.promises.writeFile(_path.default.join(distDir, _constants1.EXPORT_MARKER), JSON.stringify({
                version: 1,
                hasExportPathMap: typeof config.exportPathMap === "function",
                exportTrailingSlash: config.trailingSlash === true,
                isNextImageImported: isNextImageImported === true
            }), "utf8");
            await _fs.promises.unlink(_path.default.join(distDir, _constants1.EXPORT_DETAIL)).catch((err)=>{
                if (err.code === "ENOENT") {
                    return Promise.resolve();
                }
                return Promise.reject(err);
            });
            if (config.output === "standalone") {
                for (const file of [
                    ...requiredServerFiles.files,
                    _path.default.join(config.distDir, _constants1.SERVER_FILES_MANIFEST),
                    ...loadedEnvFiles.reduce((acc, envFile)=>{
                        if ([
                            ".env",
                            ".env.production"
                        ].includes(envFile.path)) {
                            acc.push(envFile.path);
                        }
                        return acc;
                    }, [])
                ]){
                    const filePath = _path.default.join(dir, file);
                    const outputPath = _path.default.join(distDir, "standalone", _path.default.relative(outputFileTracingRoot, filePath));
                    await _fs.promises.mkdir(_path.default.dirname(outputPath), {
                        recursive: true
                    });
                    await _fs.promises.copyFile(filePath, outputPath);
                }
                await (0, _recursivecopy.recursiveCopy)(_path.default.join(distDir, _constants1.SERVER_DIRECTORY, "pages"), _path.default.join(distDir, "standalone", _path.default.relative(outputFileTracingRoot, distDir), _constants1.SERVER_DIRECTORY, "pages"), {
                    overwrite: true
                });
                if (appDir) {
                    const originalServerApp = _path.default.join(distDir, _constants1.SERVER_DIRECTORY, "app");
                    if ((0, _fs.existsSync)(originalServerApp)) {
                        await (0, _recursivecopy.recursiveCopy)(originalServerApp, _path.default.join(distDir, "standalone", _path.default.relative(outputFileTracingRoot, distDir), _constants1.SERVER_DIRECTORY, "app"), {
                            overwrite: true
                        });
                    }
                }
            }
            await nextBuildSpan.traceChild("print-tree-view").traceAsyncFn(()=>(0, _utils1.printTreeView)(pageKeys, pageInfos, {
                    distPath: distDir,
                    buildId: buildId,
                    pagesDir,
                    useStatic404,
                    pageExtensions: config.pageExtensions,
                    appBuildManifest,
                    buildManifest,
                    middlewareManifest,
                    gzipSize: config.experimental.gzipSize
                }));
            if (debugOutput) {
                nextBuildSpan.traceChild("print-custom-routes").traceFn(()=>(0, _utils1.printCustomRoutes)({
                        redirects,
                        rewrites,
                        headers
                    }));
            }
            if (config.analyticsId) {
                console.log(_chalk.default.bold.green("Next.js Speed Insights") + " is enabled for this production build. " + "You'll receive a Real Experience Score computed by all of your visitors.");
                console.log("");
            }
            if (Boolean(config.experimental.nextScriptWorkers)) {
                await nextBuildSpan.traceChild("verify-partytown-setup").traceAsyncFn(async ()=>{
                    await (0, _verifypartytownsetup.verifyPartytownSetup)(dir, _path.default.join(distDir, _constants1.CLIENT_STATIC_FILES_PATH));
                });
            }
            if (config.output === "export") {
                const exportApp = require("../export").default;
                const pagesWorker = createStaticWorker("pages");
                const appWorker = createStaticWorker("app");
                const options = {
                    isInvokedFromCli: false,
                    buildExport: false,
                    nextConfig: config,
                    hasAppDir,
                    silent: true,
                    threads: config.experimental.cpus,
                    outdir: _path.default.join(dir, configOutDir),
                    exportAppPageWorker: sharedPool ? appWorker.exportPage.bind(appWorker) : undefined,
                    exportPageWorker: sharedPool ? pagesWorker.exportPage.bind(pagesWorker) : undefined,
                    endWorker: sharedPool ? async ()=>{
                        await pagesWorker.end();
                        await appWorker.end();
                    } : undefined
                };
                await exportApp(dir, options, nextBuildSpan);
                // ensure the worker is not left hanging
                pagesWorker.close();
                appWorker.close();
            }
            await nextBuildSpan.traceChild("telemetry-flush").traceAsyncFn(()=>telemetry.flush());
        });
        return buildResult;
    } finally{
        // Ensure we wait for lockfile patching if present
        await _swc.lockfilePatchPromise.cur;
        // Ensure all traces are flushed before finishing the command
        await (0, _trace.flushAllTraces)();
        (0, _swc.teardownTraceSubscriber)();
        (0, _swc.teardownHeapProfiler)();
        (0, _swc.teardownCrashReporter)();
    }
}

//# sourceMappingURL=index.js.map