"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getRender", {
    enumerable: true,
    get: function() {
        return getRender;
    }
});
const _webserver = /*#__PURE__*/ _interop_require_default(require("../../../../server/web-server"));
const _web = require("../../../../server/base-http/web");
const _constants = require("../../../../lib/constants");
const _apppaths = require("../../../../shared/lib/router/utils/app-paths");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function getRender({ dev , page , appMod , pageMod , errorMod , error500Mod , pagesType , Document , buildManifest , prerenderManifest , reactLoadableManifest , renderToHTML , clientReferenceManifest , subresourceIntegrityManifest , serverActionsManifest , serverActionsBodySizeLimit , config , buildId , nextFontManifest , incrementalCacheHandler  }) {
    const isAppPath = pagesType === "app";
    const baseLoadComponentResult = {
        dev,
        buildManifest,
        reactLoadableManifest,
        subresourceIntegrityManifest,
        Document,
        App: appMod == null ? void 0 : appMod.default,
        clientReferenceManifest
    };
    const server = new _webserver.default({
        dev,
        conf: config,
        minimalMode: true,
        webServerConfig: {
            page,
            normalizedPage: isAppPath ? (0, _apppaths.normalizeAppPath)(page) : page,
            pagesType,
            prerenderManifest,
            extendRenderOpts: {
                buildId,
                runtime: _constants.SERVER_RUNTIME.experimentalEdge,
                supportsDynamicHTML: true,
                disableOptimizedLoading: true,
                serverActionsManifest,
                serverActionsBodySizeLimit,
                nextFontManifest
            },
            renderToHTML,
            incrementalCacheHandler,
            loadComponent: async (pathname)=>{
                if (pathname === page) {
                    return {
                        ...baseLoadComponentResult,
                        Component: pageMod.default,
                        pageConfig: pageMod.config || {},
                        getStaticProps: pageMod.getStaticProps,
                        getServerSideProps: pageMod.getServerSideProps,
                        getStaticPaths: pageMod.getStaticPaths,
                        ComponentMod: pageMod,
                        isAppPath: !!pageMod.__next_app__,
                        pathname,
                        routeModule: pageMod.routeModule
                    };
                }
                // If there is a custom 500 page, we need to handle it separately.
                if (pathname === "/500" && error500Mod) {
                    return {
                        ...baseLoadComponentResult,
                        Component: error500Mod.default,
                        pageConfig: error500Mod.config || {},
                        getStaticProps: error500Mod.getStaticProps,
                        getServerSideProps: error500Mod.getServerSideProps,
                        getStaticPaths: error500Mod.getStaticPaths,
                        ComponentMod: error500Mod,
                        pathname,
                        routeModule: error500Mod.routeModule
                    };
                }
                if (pathname === "/_error") {
                    return {
                        ...baseLoadComponentResult,
                        Component: errorMod.default,
                        pageConfig: errorMod.config || {},
                        getStaticProps: errorMod.getStaticProps,
                        getServerSideProps: errorMod.getServerSideProps,
                        getStaticPaths: errorMod.getStaticPaths,
                        ComponentMod: errorMod,
                        pathname,
                        routeModule: errorMod.routeModule
                    };
                }
                return null;
            }
        }
    });
    const handler = server.getRequestHandler();
    return async function render(request) {
        const extendedReq = new _web.WebNextRequest(request);
        const extendedRes = new _web.WebNextResponse();
        handler(extendedReq, extendedRes);
        return await extendedRes.toResponse();
    };
}

//# sourceMappingURL=render.js.map