/* global location */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
0 && (module.exports = {
    version: null,
    router: null,
    emitter: null,
    initialize: null,
    hydrate: null
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    version: function() {
        return version;
    },
    router: function() {
        return router;
    },
    emitter: function() {
        return emitter;
    },
    initialize: function() {
        return initialize;
    },
    hydrate: function() {
        return hydrate;
    }
});
const _interop_require_default = require("@swc/helpers/_/_interop_require_default");
require("../build/polyfills/polyfill-module");
const _react = /*#__PURE__*/ _interop_require_default._(require("react"));
const _client = /*#__PURE__*/ _interop_require_default._(require("react-dom/client"));
const _headmanagercontext = require("../shared/lib/head-manager-context");
const _mitt = /*#__PURE__*/ _interop_require_default._(require("../shared/lib/mitt"));
const _routercontext = require("../shared/lib/router-context");
const _handlesmoothscroll = require("../shared/lib/router/utils/handle-smooth-scroll");
const _isdynamic = require("../shared/lib/router/utils/is-dynamic");
const _querystring = require("../shared/lib/router/utils/querystring");
const _runtimeconfig = require("../shared/lib/runtime-config");
const _utils = require("../shared/lib/utils");
const _portal = require("./portal");
const _headmanager = /*#__PURE__*/ _interop_require_default._(require("./head-manager"));
const _pageloader = /*#__PURE__*/ _interop_require_default._(require("./page-loader"));
const _performancerelayer = /*#__PURE__*/ _interop_require_default._(require("./performance-relayer"));
const _routeannouncer = require("./route-announcer");
const _router = require("./router");
const _iserror = require("../lib/is-error");
const _imageconfigcontext = require("../shared/lib/image-config-context");
const _removebasepath = require("./remove-base-path");
const _hasbasepath = require("./has-base-path");
const _approutercontext = require("../shared/lib/app-router-context");
const _adapters = require("../shared/lib/router/adapters");
const _hooksclientcontext = require("../shared/lib/hooks-client-context");
const _onrecoverableerror = /*#__PURE__*/ _interop_require_default._(require("./on-recoverable-error"));
const addChunkSuffix = (getOriginalChunk)=>(chunkId)=>{
        return getOriginalChunk(chunkId) + ("" + (process.env.NEXT_DEPLOYMENT_ID ? "?dpl=" + process.env.NEXT_DEPLOYMENT_ID : ""));
    };
// ensure dynamic imports have deployment id added if enabled
const getChunkScriptFilename = __webpack_require__.u;
// eslint-disable-next-line no-undef
__webpack_require__.u = addChunkSuffix(getChunkScriptFilename);
// eslint-disable-next-line no-undef
const getChunkCssFilename = __webpack_require__.k;
// eslint-disable-next-line no-undef
__webpack_require__.k = addChunkSuffix(getChunkCssFilename);
// eslint-disable-next-line no-undef
const getMiniCssFilename = __webpack_require__.miniCssF;
// eslint-disable-next-line no-undef
__webpack_require__.miniCssF = addChunkSuffix(getMiniCssFilename);
const version = "13.4.12";
let router;
const emitter = (0, _mitt.default)();
const looseToArray = (input)=>[].slice.call(input);
let initialData;
let defaultLocale = undefined;
let asPath;
let pageLoader;
let appElement;
let headManager;
let initialMatchesMiddleware = false;
let lastAppProps;
let lastRenderReject;
let webpackHMR;
let CachedApp, onPerfEntry;
let CachedComponent;
self.__next_require__ = __webpack_require__;
class Container extends _react.default.Component {
    componentDidCatch(componentErr, info) {
        this.props.fn(componentErr, info);
    }
    componentDidMount() {
        this.scrollToHash();
        // We need to replace the router state if:
        // - the page was (auto) exported and has a query string or search (hash)
        // - it was auto exported and is a dynamic route (to provide params)
        // - if it is a client-side skeleton (fallback render)
        // - if middleware matches the current page (may have rewrite params)
        // - if rewrites in next.config.js match (may have rewrite params)
        if (router.isSsr && (initialData.isFallback || initialData.nextExport && ((0, _isdynamic.isDynamicRoute)(router.pathname) || location.search || process.env.__NEXT_HAS_REWRITES || initialMatchesMiddleware) || initialData.props && initialData.props.__N_SSG && (location.search || process.env.__NEXT_HAS_REWRITES || initialMatchesMiddleware))) {
            // update query on mount for exported pages
            router.replace(router.pathname + "?" + String((0, _querystring.assign)((0, _querystring.urlQueryToSearchParams)(router.query), new URLSearchParams(location.search))), asPath, {
                // @ts-ignore
                // WARNING: `_h` is an internal option for handing Next.js
                // client-side hydration. Your app should _never_ use this property.
                // It may change at any time without notice.
                _h: 1,
                // Fallback pages must trigger the data fetch, so the transition is
                // not shallow.
                // Other pages (strictly updating query) happens shallowly, as data
                // requirements would already be present.
                shallow: !initialData.isFallback && !initialMatchesMiddleware
            }).catch((err)=>{
                if (!err.cancelled) throw err;
            });
        }
    }
    componentDidUpdate() {
        this.scrollToHash();
    }
    scrollToHash() {
        let { hash  } = location;
        hash = hash && hash.substring(1);
        if (!hash) return;
        const el = document.getElementById(hash);
        if (!el) return;
        // If we call scrollIntoView() in here without a setTimeout
        // it won't scroll properly.
        setTimeout(()=>el.scrollIntoView(), 0);
    }
    render() {
        if (process.env.NODE_ENV === "production") {
            return this.props.children;
        } else {
            const { ReactDevOverlay  } = require("next/dist/compiled/@next/react-dev-overlay/dist/client");
            return /*#__PURE__*/ _react.default.createElement(ReactDevOverlay, null, this.props.children);
        }
    }
}
async function initialize(opts) {
    if (opts === void 0) opts = {};
    // This makes sure this specific lines are removed in production
    if (process.env.NODE_ENV === "development") {
        webpackHMR = opts.webpackHMR;
    }
    initialData = JSON.parse(document.getElementById("__NEXT_DATA__").textContent);
    window.__NEXT_DATA__ = initialData;
    defaultLocale = initialData.defaultLocale;
    const prefix = initialData.assetPrefix || "";
    // With dynamic assetPrefix it's no longer possible to set assetPrefix at the build time
    // So, this is how we do it in the client side at runtime
    __webpack_public_path__ = "" + prefix + "/_next/" //eslint-disable-line
    ;
    // Initialize next/config with the environment configuration
    (0, _runtimeconfig.setConfig)({
        serverRuntimeConfig: {},
        publicRuntimeConfig: initialData.runtimeConfig || {}
    });
    asPath = (0, _utils.getURL)();
    // make sure not to attempt stripping basePath for 404s
    if ((0, _hasbasepath.hasBasePath)(asPath)) {
        asPath = (0, _removebasepath.removeBasePath)(asPath);
    }
    if (process.env.__NEXT_I18N_SUPPORT) {
        const { normalizeLocalePath  } = require("../shared/lib/i18n/normalize-locale-path");
        const { detectDomainLocale  } = require("../shared/lib/i18n/detect-domain-locale");
        const { parseRelativeUrl  } = require("../shared/lib/router/utils/parse-relative-url");
        const { formatUrl  } = require("../shared/lib/router/utils/format-url");
        if (initialData.locales) {
            const parsedAs = parseRelativeUrl(asPath);
            const localePathResult = normalizeLocalePath(parsedAs.pathname, initialData.locales);
            if (localePathResult.detectedLocale) {
                parsedAs.pathname = localePathResult.pathname;
                asPath = formatUrl(parsedAs);
            } else {
                // derive the default locale if it wasn't detected in the asPath
                // since we don't prerender static pages with all possible default
                // locales
                defaultLocale = initialData.locale;
            }
            // attempt detecting default locale based on hostname
            const detectedDomain = detectDomainLocale(process.env.__NEXT_I18N_DOMAINS, window.location.hostname);
            // TODO: investigate if defaultLocale needs to be populated after
            // hydration to prevent mismatched renders
            if (detectedDomain) {
                defaultLocale = detectedDomain.defaultLocale;
            }
        }
    }
    if (initialData.scriptLoader) {
        const { initScriptLoader  } = require("./script");
        initScriptLoader(initialData.scriptLoader);
    }
    pageLoader = new _pageloader.default(initialData.buildId, prefix);
    const register = (param)=>{
        let [r, f] = param;
        return pageLoader.routeLoader.onEntrypoint(r, f);
    };
    if (window.__NEXT_P) {
        // Defer page registration for another tick. This will increase the overall
        // latency in hydrating the page, but reduce the total blocking time.
        window.__NEXT_P.map((p)=>setTimeout(()=>register(p), 0));
    }
    window.__NEXT_P = [];
    window.__NEXT_P.push = register;
    headManager = (0, _headmanager.default)();
    headManager.getIsSsr = ()=>{
        return router.isSsr;
    };
    appElement = document.getElementById("__next");
    return {
        assetPrefix: prefix
    };
}
function renderApp(App, appProps) {
    return /*#__PURE__*/ _react.default.createElement(App, appProps);
}
function AppContainer(param) {
    let { children  } = param;
    // Create a memoized value for next/navigation router context.
    const adaptedForAppRouter = _react.default.useMemo(()=>{
        return (0, _adapters.adaptForAppRouterInstance)(router);
    }, []);
    var _self___NEXT_DATA___autoExport;
    return /*#__PURE__*/ _react.default.createElement(Container, {
        fn: (error)=>// TODO: Fix disabled eslint rule
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            renderError({
                App: CachedApp,
                err: error
            }).catch((err)=>console.error("Error rendering page: ", err))
    }, /*#__PURE__*/ _react.default.createElement(_approutercontext.AppRouterContext.Provider, {
        value: adaptedForAppRouter
    }, /*#__PURE__*/ _react.default.createElement(_hooksclientcontext.SearchParamsContext.Provider, {
        value: (0, _adapters.adaptForSearchParams)(router)
    }, /*#__PURE__*/ _react.default.createElement(_adapters.PathnameContextProviderAdapter, {
        router: router,
        isAutoExport: (_self___NEXT_DATA___autoExport = self.__NEXT_DATA__.autoExport) != null ? _self___NEXT_DATA___autoExport : false
    }, /*#__PURE__*/ _react.default.createElement(_routercontext.RouterContext.Provider, {
        value: (0, _router.makePublicRouterInstance)(router)
    }, /*#__PURE__*/ _react.default.createElement(_headmanagercontext.HeadManagerContext.Provider, {
        value: headManager
    }, /*#__PURE__*/ _react.default.createElement(_imageconfigcontext.ImageConfigContext.Provider, {
        value: process.env.__NEXT_IMAGE_OPTS
    }, children)))))));
}
const wrapApp = (App)=>(wrappedAppProps)=>{
        const appProps = {
            ...wrappedAppProps,
            Component: CachedComponent,
            err: initialData.err,
            router
        };
        return /*#__PURE__*/ _react.default.createElement(AppContainer, null, renderApp(App, appProps));
    };
// This method handles all runtime and debug errors.
// 404 and 500 errors are special kind of errors
// and they are still handle via the main render method.
function renderError(renderErrorProps) {
    let { App , err  } = renderErrorProps;
    // In development runtime errors are caught by our overlay
    // In production we catch runtime errors using componentDidCatch which will trigger renderError
    if (process.env.NODE_ENV !== "production") {
        // A Next.js rendering runtime error is always unrecoverable
        // FIXME: let's make this recoverable (error in GIP client-transition)
        webpackHMR.onUnrecoverableError();
        // We need to render an empty <App> so that the `<ReactDevOverlay>` can
        // render itself.
        // TODO: Fix disabled eslint rule
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        return doRender({
            App: ()=>null,
            props: {},
            Component: ()=>null,
            styleSheets: []
        });
    }
    // Make sure we log the error to the console, otherwise users can't track down issues.
    console.error(err);
    console.error("A client-side exception has occurred, see here for more info: https://nextjs.org/docs/messages/client-side-exception-occurred");
    return pageLoader.loadPage("/_error").then((param)=>{
        let { page: ErrorComponent , styleSheets  } = param;
        return (lastAppProps == null ? void 0 : lastAppProps.Component) === ErrorComponent ? import("../pages/_error").then((errorModule)=>{
            return import("../pages/_app").then((appModule)=>{
                App = appModule.default;
                renderErrorProps.App = App;
                return errorModule;
            });
        }).then((m)=>({
                ErrorComponent: m.default,
                styleSheets: []
            })) : {
            ErrorComponent,
            styleSheets
        };
    }).then((param)=>{
        let { ErrorComponent , styleSheets  } = param;
        var _renderErrorProps_props;
        // In production we do a normal render with the `ErrorComponent` as component.
        // If we've gotten here upon initial render, we can use the props from the server.
        // Otherwise, we need to call `getInitialProps` on `App` before mounting.
        const AppTree = wrapApp(App);
        const appCtx = {
            Component: ErrorComponent,
            AppTree,
            router,
            ctx: {
                err,
                pathname: initialData.page,
                query: initialData.query,
                asPath,
                AppTree
            }
        };
        return Promise.resolve(((_renderErrorProps_props = renderErrorProps.props) == null ? void 0 : _renderErrorProps_props.err) ? renderErrorProps.props : (0, _utils.loadGetInitialProps)(App, appCtx)).then((initProps)=>// TODO: Fix disabled eslint rule
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            doRender({
                ...renderErrorProps,
                err,
                Component: ErrorComponent,
                styleSheets,
                props: initProps
            }));
    });
}
// Dummy component that we render as a child of Root so that we can
// toggle the correct styles before the page is rendered.
function Head(param) {
    let { callback  } = param;
    // We use `useLayoutEffect` to guarantee the callback is executed
    // as soon as React flushes the update.
    _react.default.useLayoutEffect(()=>callback(), [
        callback
    ]);
    return null;
}
let reactRoot = null;
// On initial render a hydrate should always happen
let shouldHydrate = true;
function clearMarks() {
    [
        "beforeRender",
        "afterHydrate",
        "afterRender",
        "routeChange"
    ].forEach((mark)=>performance.clearMarks(mark));
}
function markHydrateComplete() {
    if (!_utils.ST) return;
    performance.mark("afterHydrate") // mark end of hydration
    ;
    performance.measure("Next.js-before-hydration", "navigationStart", "beforeRender");
    performance.measure("Next.js-hydration", "beforeRender", "afterHydrate");
    if (onPerfEntry) {
        performance.getEntriesByName("Next.js-hydration").forEach(onPerfEntry);
    }
    clearMarks();
}
function markRenderComplete() {
    if (!_utils.ST) return;
    performance.mark("afterRender") // mark end of render
    ;
    const navStartEntries = performance.getEntriesByName("routeChange", "mark");
    if (!navStartEntries.length) return;
    performance.measure("Next.js-route-change-to-render", navStartEntries[0].name, "beforeRender");
    performance.measure("Next.js-render", "beforeRender", "afterRender");
    if (onPerfEntry) {
        performance.getEntriesByName("Next.js-render").forEach(onPerfEntry);
        performance.getEntriesByName("Next.js-route-change-to-render").forEach(onPerfEntry);
    }
    clearMarks();
    [
        "Next.js-route-change-to-render",
        "Next.js-render"
    ].forEach((measure)=>performance.clearMeasures(measure));
}
function renderReactElement(domEl, fn) {
    // mark start of hydrate/render
    if (_utils.ST) {
        performance.mark("beforeRender");
    }
    const reactEl = fn(shouldHydrate ? markHydrateComplete : markRenderComplete);
    if (!reactRoot) {
        // Unlike with createRoot, you don't need a separate root.render() call here
        reactRoot = _client.default.hydrateRoot(domEl, reactEl, {
            onRecoverableError: _onrecoverableerror.default
        });
        // TODO: Remove shouldHydrate variable when React 18 is stable as it can depend on `reactRoot` existing
        shouldHydrate = false;
    } else {
        const startTransition = _react.default.startTransition;
        startTransition(()=>{
            reactRoot.render(reactEl);
        });
    }
}
function Root(param) {
    let { callbacks , children  } = param;
    // We use `useLayoutEffect` to guarantee the callbacks are executed
    // as soon as React flushes the update
    _react.default.useLayoutEffect(()=>callbacks.forEach((callback)=>callback()), [
        callbacks
    ]);
    // We should ask to measure the Web Vitals after rendering completes so we
    // don't cause any hydration delay:
    _react.default.useEffect(()=>{
        (0, _performancerelayer.default)(onPerfEntry);
    }, []);
    if (process.env.__NEXT_TEST_MODE) {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        _react.default.useEffect(()=>{
            window.__NEXT_HYDRATED = true;
            if (window.__NEXT_HYDRATED_CB) {
                window.__NEXT_HYDRATED_CB();
            }
        }, []);
    }
    return children;
}
function doRender(input) {
    let { App , Component , props , err  } = input;
    let styleSheets = "initial" in input ? undefined : input.styleSheets;
    Component = Component || lastAppProps.Component;
    props = props || lastAppProps.props;
    const appProps = {
        ...props,
        Component,
        err,
        router
    };
    // lastAppProps has to be set before ReactDom.render to account for ReactDom throwing an error.
    lastAppProps = appProps;
    let canceled = false;
    let resolvePromise;
    const renderPromise = new Promise((resolve, reject)=>{
        if (lastRenderReject) {
            lastRenderReject();
        }
        resolvePromise = ()=>{
            lastRenderReject = null;
            resolve();
        };
        lastRenderReject = ()=>{
            canceled = true;
            lastRenderReject = null;
            const error = new Error("Cancel rendering route");
            error.cancelled = true;
            reject(error);
        };
    });
    // This function has a return type to ensure it doesn't start returning a
    // Promise. It should remain synchronous.
    function onStart() {
        if (!styleSheets || // We use `style-loader` in development, so we don't need to do anything
        // unless we're in production:
        process.env.NODE_ENV !== "production") {
            return false;
        }
        const currentStyleTags = looseToArray(document.querySelectorAll("style[data-n-href]"));
        const currentHrefs = new Set(currentStyleTags.map((tag)=>tag.getAttribute("data-n-href")));
        const noscript = document.querySelector("noscript[data-n-css]");
        const nonce = noscript == null ? void 0 : noscript.getAttribute("data-n-css");
        styleSheets.forEach((param)=>{
            let { href , text  } = param;
            if (!currentHrefs.has(href)) {
                const styleTag = document.createElement("style");
                styleTag.setAttribute("data-n-href", href);
                styleTag.setAttribute("media", "x");
                if (nonce) {
                    styleTag.setAttribute("nonce", nonce);
                }
                document.head.appendChild(styleTag);
                styleTag.appendChild(document.createTextNode(text));
            }
        });
        return true;
    }
    function onHeadCommit() {
        if (// We use `style-loader` in development, so we don't need to do anything
        // unless we're in production:
        process.env.NODE_ENV === "production" && // We can skip this during hydration. Running it wont cause any harm, but
        // we may as well save the CPU cycles:
        styleSheets && // Ensure this render was not canceled
        !canceled) {
            const desiredHrefs = new Set(styleSheets.map((s)=>s.href));
            const currentStyleTags = looseToArray(document.querySelectorAll("style[data-n-href]"));
            const currentHrefs = currentStyleTags.map((tag)=>tag.getAttribute("data-n-href"));
            // Toggle `<style>` tags on or off depending on if they're needed:
            for(let idx = 0; idx < currentHrefs.length; ++idx){
                if (desiredHrefs.has(currentHrefs[idx])) {
                    currentStyleTags[idx].removeAttribute("media");
                } else {
                    currentStyleTags[idx].setAttribute("media", "x");
                }
            }
            // Reorder styles into intended order:
            let referenceNode = document.querySelector("noscript[data-n-css]");
            if (// This should be an invariant:
            referenceNode) {
                styleSheets.forEach((param)=>{
                    let { href  } = param;
                    const targetTag = document.querySelector('style[data-n-href="' + href + '"]');
                    if (// This should be an invariant:
                    targetTag) {
                        referenceNode.parentNode.insertBefore(targetTag, referenceNode.nextSibling);
                        referenceNode = targetTag;
                    }
                });
            }
            // Finally, clean up server rendered stylesheets:
            looseToArray(document.querySelectorAll("link[data-n-p]")).forEach((el)=>{
                el.parentNode.removeChild(el);
            });
        }
        if (input.scroll) {
            const { x , y  } = input.scroll;
            (0, _handlesmoothscroll.handleSmoothScroll)(()=>{
                window.scrollTo(x, y);
            });
        }
    }
    function onRootCommit() {
        resolvePromise();
    }
    onStart();
    const elem = /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(Head, {
        callback: onHeadCommit
    }), /*#__PURE__*/ _react.default.createElement(AppContainer, null, renderApp(App, appProps), /*#__PURE__*/ _react.default.createElement(_portal.Portal, {
        type: "next-route-announcer"
    }, /*#__PURE__*/ _react.default.createElement(_routeannouncer.RouteAnnouncer, null))));
    // We catch runtime errors using componentDidCatch which will trigger renderError
    renderReactElement(appElement, (callback)=>/*#__PURE__*/ _react.default.createElement(Root, {
            callbacks: [
                callback,
                onRootCommit
            ]
        }, process.env.__NEXT_STRICT_MODE ? /*#__PURE__*/ _react.default.createElement(_react.default.StrictMode, null, elem) : elem));
    return renderPromise;
}
async function render(renderingProps) {
    if (renderingProps.err) {
        await renderError(renderingProps);
        return;
    }
    try {
        await doRender(renderingProps);
    } catch (err) {
        const renderErr = (0, _iserror.getProperError)(err);
        // bubble up cancelation errors
        if (renderErr.cancelled) {
            throw renderErr;
        }
        if (process.env.NODE_ENV === "development") {
            // Ensure this error is displayed in the overlay in development
            setTimeout(()=>{
                throw renderErr;
            });
        }
        await renderError({
            ...renderingProps,
            err: renderErr
        });
    }
}
async function hydrate(opts) {
    let initialErr = initialData.err;
    try {
        const appEntrypoint = await pageLoader.routeLoader.whenEntrypoint("/_app");
        if ("error" in appEntrypoint) {
            throw appEntrypoint.error;
        }
        const { component: app , exports: mod  } = appEntrypoint;
        CachedApp = app;
        if (mod && mod.reportWebVitals) {
            onPerfEntry = (param)=>{
                let { id , name , startTime , value , duration , entryType , entries , attribution  } = param;
                // Combines timestamp with random number for unique ID
                const uniqueID = Date.now() + "-" + (Math.floor(Math.random() * (9e12 - 1)) + 1e12);
                let perfStartEntry;
                if (entries && entries.length) {
                    perfStartEntry = entries[0].startTime;
                }
                const webVitals = {
                    id: id || uniqueID,
                    name,
                    startTime: startTime || perfStartEntry,
                    value: value == null ? duration : value,
                    label: entryType === "mark" || entryType === "measure" ? "custom" : "web-vital"
                };
                if (attribution) {
                    webVitals.attribution = attribution;
                }
                mod.reportWebVitals(webVitals);
            };
        }
        const pageEntrypoint = // The dev server fails to serve script assets when there's a hydration
        // error, so we need to skip waiting for the entrypoint.
        process.env.NODE_ENV === "development" && initialData.err ? {
            error: initialData.err
        } : await pageLoader.routeLoader.whenEntrypoint(initialData.page);
        if ("error" in pageEntrypoint) {
            throw pageEntrypoint.error;
        }
        CachedComponent = pageEntrypoint.component;
        if (process.env.NODE_ENV !== "production") {
            const { isValidElementType  } = require("next/dist/compiled/react-is");
            if (!isValidElementType(CachedComponent)) {
                throw new Error('The default export is not a React Component in page: "' + initialData.page + '"');
            }
        }
    } catch (error) {
        // This catches errors like throwing in the top level of a module
        initialErr = (0, _iserror.getProperError)(error);
    }
    if (process.env.NODE_ENV === "development") {
        const { getServerError  } = require("next/dist/compiled/@next/react-dev-overlay/dist/client");
        // Server-side runtime errors need to be re-thrown on the client-side so
        // that the overlay is rendered.
        if (initialErr) {
            if (initialErr === initialData.err) {
                setTimeout(()=>{
                    let error;
                    try {
                        // Generate a new error object. We `throw` it because some browsers
                        // will set the `stack` when thrown, and we want to ensure ours is
                        // not overridden when we re-throw it below.
                        throw new Error(initialErr.message);
                    } catch (e) {
                        error = e;
                    }
                    error.name = initialErr.name;
                    error.stack = initialErr.stack;
                    throw getServerError(error, initialErr.source);
                });
            } else {
                setTimeout(()=>{
                    throw initialErr;
                });
            }
        }
    }
    if (window.__NEXT_PRELOADREADY) {
        await window.__NEXT_PRELOADREADY(initialData.dynamicIds);
    }
    router = (0, _router.createRouter)(initialData.page, initialData.query, asPath, {
        initialProps: initialData.props,
        pageLoader,
        App: CachedApp,
        Component: CachedComponent,
        wrapApp,
        err: initialErr,
        isFallback: Boolean(initialData.isFallback),
        subscription: (info, App, scroll)=>render(Object.assign({}, info, {
                App,
                scroll
            })),
        locale: initialData.locale,
        locales: initialData.locales,
        defaultLocale,
        domainLocales: initialData.domainLocales,
        isPreview: initialData.isPreview
    });
    initialMatchesMiddleware = await router._initialMatchesMiddlewarePromise;
    const renderCtx = {
        App: CachedApp,
        initial: true,
        Component: CachedComponent,
        props: initialData.props,
        err: initialErr
    };
    if (opts == null ? void 0 : opts.beforeRender) {
        await opts.beforeRender();
    }
    render(renderCtx);
}

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=index.js.map