"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
0 && (module.exports = {
    ExportError: null,
    default: null
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ExportError: function() {
        return ExportError;
    },
    default: function() {
        return exportApp;
    }
});
const _chalk = /*#__PURE__*/ _interop_require_default(require("next/dist/compiled/chalk"));
const _findup = /*#__PURE__*/ _interop_require_default(require("next/dist/compiled/find-up"));
const _fs = require("fs");
require("../server/require-hook");
const _worker = require("../lib/worker");
const _path = require("path");
const _util = require("util");
const _index = require("../build/output/index");
const _log = /*#__PURE__*/ _interop_require_wildcard(require("../build/output/log"));
const _spinner = /*#__PURE__*/ _interop_require_default(require("../build/spinner"));
const _constants = require("../lib/constants");
const _recursivecopy = require("../lib/recursive-copy");
const _recursivedelete = require("../lib/recursive-delete");
const _constants1 = require("../shared/lib/constants");
const _config = /*#__PURE__*/ _interop_require_default(require("../server/config"));
const _events = require("../telemetry/events");
const _ciinfo = require("../telemetry/ci-info");
const _storage = require("../telemetry/storage");
const _normalizepagepath = require("../shared/lib/page-path/normalize-page-path");
const _denormalizepagepath = require("../shared/lib/page-path/denormalize-page-path");
const _env = require("@next/env");
const _isapiroute = require("../lib/is-api-route");
const _require = require("../server/require");
const _isapprouteroute = require("../lib/is-app-route-route");
const _isapppageroute = require("../lib/is-app-page-route");
const _iserror = /*#__PURE__*/ _interop_require_default(require("../lib/is-error"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {};
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const exists = (0, _util.promisify)(_fs.exists);
function divideSegments(number, segments) {
    const result = [];
    while(number > 0 && segments > 0){
        const dividedNumber = number < segments ? number : Math.floor(number / segments);
        number -= dividedNumber;
        segments--;
        result.push(dividedNumber);
    }
    return result;
}
const createProgress = (total, label)=>{
    const segments = divideSegments(total, 4);
    if (total === 0) {
        throw new Error("invariant: progress total can not be zero");
    }
    let currentSegmentTotal = segments.shift();
    let currentSegmentCount = 0;
    let lastProgressOutput = Date.now();
    let curProgress = 0;
    let progressSpinner = (0, _spinner.default)(`${label} (${curProgress}/${total})`, {
        spinner: {
            frames: [
                "[    ]",
                "[=   ]",
                "[==  ]",
                "[=== ]",
                "[ ===]",
                "[  ==]",
                "[   =]",
                "[    ]",
                "[   =]",
                "[  ==]",
                "[ ===]",
                "[====]",
                "[=== ]",
                "[==  ]",
                "[=   ]"
            ],
            interval: 500
        }
    });
    return ()=>{
        curProgress++;
        // Make sure we only log once
        // - per fully generated segment, or
        // - per minute
        // when not showing the spinner
        if (!progressSpinner) {
            currentSegmentCount++;
            if (currentSegmentCount === currentSegmentTotal) {
                currentSegmentTotal = segments.shift();
                currentSegmentCount = 0;
            } else if (lastProgressOutput + 60000 > Date.now()) {
                return;
            }
            lastProgressOutput = Date.now();
        }
        const newText = `${label} (${curProgress}/${total})`;
        if (progressSpinner) {
            progressSpinner.text = newText;
        } else {
            console.log(newText);
        }
        if (curProgress === total && progressSpinner) {
            progressSpinner.stop();
            console.log(newText);
        }
    };
};
class ExportError extends Error {
    constructor(...args){
        super(...args);
        this.code = "NEXT_EXPORT_ERROR";
    }
}
async function exportApp(dir, options, span) {
    const nextExportSpan = span.traceChild("next-export");
    return nextExportSpan.traceAsyncFn(async ()=>{
        var _nextConfig_amp, _nextConfig_experimental_amp, _nextConfig_experimental_amp1, _nextConfig_experimental_amp2;
        dir = (0, _path.resolve)(dir);
        // attempt to load global env values so they are available in next.config.js
        nextExportSpan.traceChild("load-dotenv").traceFn(()=>(0, _env.loadEnvConfig)(dir, false, _log));
        const nextConfig = options.nextConfig || await nextExportSpan.traceChild("load-next-config").traceAsyncFn(()=>(0, _config.default)(_constants1.PHASE_EXPORT, dir));
        const threads = options.threads || nextConfig.experimental.cpus;
        const distDir = (0, _path.join)(dir, nextConfig.distDir);
        const isExportOutput = nextConfig.output === "export";
        // Running 'next export'
        if (options.isInvokedFromCli) {
            if (isExportOutput) {
                if (options.hasOutdirFromCli) {
                    throw new ExportError('"next export -o <dir>" cannot be used when "output: export" is configured in next.config.js. Instead add "distDir" in next.config.js https://nextjs.org/docs/advanced-features/static-html-export');
                }
                _log.warn('"next export" is no longer needed when "output: export" is configured in next.config.js https://nextjs.org/docs/advanced-features/static-html-export');
                return;
            }
            if ((0, _fs.existsSync)((0, _path.join)(distDir, "server", "app"))) {
                throw new ExportError('"next export" does not work with App Router. Please use "output: export" in next.config.js https://nextjs.org/docs/advanced-features/static-html-export');
            }
            _log.warn('"next export" is deprecated in favor of "output: export" in next.config.js https://nextjs.org/docs/advanced-features/static-html-export');
        }
        // Running 'next export' or output is set to 'export'
        if (options.isInvokedFromCli || isExportOutput) {
            if (nextConfig.experimental.serverActions) {
                throw new ExportError(`Server Actions are not supported with static export.`);
            }
        }
        const telemetry = options.buildExport ? null : new _storage.Telemetry({
            distDir
        });
        if (telemetry) {
            telemetry.record((0, _events.eventCliSession)(distDir, nextConfig, {
                webpackVersion: null,
                cliCommand: "export",
                isSrcDir: null,
                hasNowJson: !!await (0, _findup.default)("now.json", {
                    cwd: dir
                }),
                isCustomServer: null,
                turboFlag: false,
                pagesDir: null,
                appDir: null
            }));
        }
        const subFolders = nextConfig.trailingSlash && !options.buildExport;
        if (!options.silent && !options.buildExport) {
            _log.info(`using build directory: ${distDir}`);
        }
        const buildIdFile = (0, _path.join)(distDir, _constants1.BUILD_ID_FILE);
        if (!(0, _fs.existsSync)(buildIdFile)) {
            throw new ExportError(`Could not find a production build in the '${distDir}' directory. Try building your app with 'next build' before starting the static export. https://nextjs.org/docs/messages/next-export-no-build-id`);
        }
        const customRoutesDetected = [
            "rewrites",
            "redirects",
            "headers"
        ].filter((config)=>typeof nextConfig[config] === "function");
        if (!_ciinfo.hasNextSupport && !options.buildExport && customRoutesDetected.length > 0) {
            _log.warn(`rewrites, redirects, and headers are not applied when exporting your application, detected (${customRoutesDetected.join(", ")}). See more info here: https://nextjs.org/docs/messages/export-no-custom-routes`);
        }
        const buildId = (0, _fs.readFileSync)(buildIdFile, "utf8");
        const pagesManifest = !options.pages && require((0, _path.join)(distDir, _constants1.SERVER_DIRECTORY, _constants1.PAGES_MANIFEST));
        let prerenderManifest = undefined;
        try {
            prerenderManifest = require((0, _path.join)(distDir, _constants1.PRERENDER_MANIFEST));
        } catch (_) {}
        let appRoutePathManifest = undefined;
        try {
            appRoutePathManifest = require((0, _path.join)(distDir, _constants1.APP_PATH_ROUTES_MANIFEST));
        } catch (err) {
            if ((0, _iserror.default)(err) && (err.code === "ENOENT" || err.code === "MODULE_NOT_FOUND")) {
                // the manifest doesn't exist which will happen when using
                // "pages" dir instead of "app" dir.
                appRoutePathManifest = undefined;
            } else {
                // the manifest is malformed (invalid json)
                throw err;
            }
        }
        const excludedPrerenderRoutes = new Set();
        const pages = options.pages || Object.keys(pagesManifest);
        const defaultPathMap = {};
        let hasApiRoutes = false;
        for (const page of pages){
            // _document and _app are not real pages
            // _error is exported as 404.html later on
            // API Routes are Node.js functions
            if ((0, _isapiroute.isAPIRoute)(page)) {
                hasApiRoutes = true;
                continue;
            }
            if (page === "/_document" || page === "/_app" || page === "/_error") {
                continue;
            }
            // iSSG pages that are dynamic should not export templated version by
            // default. In most cases, this would never work. There is no server that
            // could run `getStaticProps`. If users make their page work lazily, they
            // can manually add it to the `exportPathMap`.
            if (prerenderManifest == null ? void 0 : prerenderManifest.dynamicRoutes[page]) {
                excludedPrerenderRoutes.add(page);
                continue;
            }
            defaultPathMap[page] = {
                page
            };
        }
        const mapAppRouteToPage = new Map();
        if (!options.buildExport && appRoutePathManifest) {
            for (const [pageName, routePath] of Object.entries(appRoutePathManifest)){
                mapAppRouteToPage.set(routePath, pageName);
                if ((0, _isapppageroute.isAppPageRoute)(pageName) && !(prerenderManifest == null ? void 0 : prerenderManifest.routes[routePath]) && !(prerenderManifest == null ? void 0 : prerenderManifest.dynamicRoutes[routePath])) {
                    defaultPathMap[routePath] = {
                        page: pageName,
                        _isAppDir: true
                    };
                }
            }
        }
        // Initialize the output directory
        const outDir = options.outdir;
        if (outDir === (0, _path.join)(dir, "public")) {
            throw new ExportError(`The 'public' directory is reserved in Next.js and can not be used as the export out directory. https://nextjs.org/docs/messages/can-not-output-to-public`);
        }
        if (outDir === (0, _path.join)(dir, "static")) {
            throw new ExportError(`The 'static' directory is reserved in Next.js and can not be used as the export out directory. https://nextjs.org/docs/messages/can-not-output-to-static`);
        }
        await (0, _recursivedelete.recursiveDelete)((0, _path.join)(outDir));
        await _fs.promises.mkdir((0, _path.join)(outDir, "_next", buildId), {
            recursive: true
        });
        (0, _fs.writeFileSync)((0, _path.join)(distDir, _constants1.EXPORT_DETAIL), JSON.stringify({
            version: 1,
            outDirectory: outDir,
            success: false
        }), "utf8");
        // Copy static directory
        if (!options.buildExport && (0, _fs.existsSync)((0, _path.join)(dir, "static"))) {
            if (!options.silent) {
                _log.info('Copying "static" directory');
            }
            await nextExportSpan.traceChild("copy-static-directory").traceAsyncFn(()=>(0, _recursivecopy.recursiveCopy)((0, _path.join)(dir, "static"), (0, _path.join)(outDir, "static")));
        }
        // Copy .next/static directory
        if (!options.buildExport && (0, _fs.existsSync)((0, _path.join)(distDir, _constants1.CLIENT_STATIC_FILES_PATH))) {
            if (!options.silent) {
                _log.info('Copying "static build" directory');
            }
            await nextExportSpan.traceChild("copy-next-static-directory").traceAsyncFn(()=>(0, _recursivecopy.recursiveCopy)((0, _path.join)(distDir, _constants1.CLIENT_STATIC_FILES_PATH), (0, _path.join)(outDir, "_next", _constants1.CLIENT_STATIC_FILES_PATH)));
        }
        // Get the exportPathMap from the config file
        if (typeof nextConfig.exportPathMap !== "function") {
            nextConfig.exportPathMap = async (defaultMap)=>{
                return defaultMap;
            };
        }
        const { i18n , images: { loader ="default" , unoptimized  }  } = nextConfig;
        if (i18n && !options.buildExport) {
            throw new ExportError(`i18n support is not compatible with next export. See here for more info on deploying: https://nextjs.org/docs/messages/export-no-custom-routes`);
        }
        if (!options.buildExport) {
            const { isNextImageImported  } = await nextExportSpan.traceChild("is-next-image-imported").traceAsyncFn(()=>_fs.promises.readFile((0, _path.join)(distDir, _constants1.EXPORT_MARKER), "utf8").then((text)=>JSON.parse(text)).catch(()=>({})));
            if (isNextImageImported && loader === "default" && !unoptimized && !_ciinfo.hasNextSupport) {
                throw new ExportError(`Image Optimization using the default loader is not compatible with export.
  Possible solutions:
    - Use \`next start\` to run a server, which includes the Image Optimization API.
    - Configure \`images.unoptimized = true\` in \`next.config.js\` to disable the Image Optimization API.
  Read more: https://nextjs.org/docs/messages/export-image-api`);
            }
        }
        // Start the rendering process
        const renderOpts = {
            dir,
            buildId,
            nextExport: true,
            assetPrefix: nextConfig.assetPrefix.replace(/\/$/, ""),
            distDir,
            dev: false,
            hotReloader: null,
            basePath: nextConfig.basePath,
            canonicalBase: ((_nextConfig_amp = nextConfig.amp) == null ? void 0 : _nextConfig_amp.canonicalBase) || "",
            ampValidatorPath: ((_nextConfig_experimental_amp = nextConfig.experimental.amp) == null ? void 0 : _nextConfig_experimental_amp.validator) || undefined,
            ampSkipValidation: ((_nextConfig_experimental_amp1 = nextConfig.experimental.amp) == null ? void 0 : _nextConfig_experimental_amp1.skipValidation) || false,
            ampOptimizerConfig: ((_nextConfig_experimental_amp2 = nextConfig.experimental.amp) == null ? void 0 : _nextConfig_experimental_amp2.optimizer) || undefined,
            locales: i18n == null ? void 0 : i18n.locales,
            locale: i18n == null ? void 0 : i18n.defaultLocale,
            defaultLocale: i18n == null ? void 0 : i18n.defaultLocale,
            domainLocales: i18n == null ? void 0 : i18n.domains,
            trailingSlash: nextConfig.trailingSlash,
            disableOptimizedLoading: nextConfig.experimental.disableOptimizedLoading,
            // Exported pages do not currently support dynamic HTML.
            supportsDynamicHTML: false,
            crossOrigin: nextConfig.crossOrigin,
            optimizeCss: nextConfig.experimental.optimizeCss,
            nextConfigOutput: nextConfig.output,
            nextScriptWorkers: nextConfig.experimental.nextScriptWorkers,
            optimizeFonts: nextConfig.optimizeFonts,
            largePageDataBytes: nextConfig.experimental.largePageDataBytes,
            serverComponents: options.hasAppDir,
            hasServerComponents: options.hasAppDir,
            serverActionsBodySizeLimit: nextConfig.experimental.serverActionsBodySizeLimit,
            nextFontManifest: require((0, _path.join)(distDir, "server", `${_constants1.NEXT_FONT_MANIFEST}.json`)),
            images: nextConfig.images,
            ...options.hasAppDir ? {
                serverActionsManifest: require((0, _path.join)(distDir, _constants1.SERVER_DIRECTORY, _constants1.SERVER_REFERENCE_MANIFEST + ".json"))
            } : {},
            strictNextHead: !!nextConfig.experimental.strictNextHead,
            deploymentId: nextConfig.experimental.deploymentId
        };
        const { serverRuntimeConfig , publicRuntimeConfig  } = nextConfig;
        if (Object.keys(publicRuntimeConfig).length > 0) {
            renderOpts.runtimeConfig = publicRuntimeConfig;
        }
        globalThis.__NEXT_DATA__ = {
            nextExport: true
        };
        if (!options.silent && !options.buildExport) {
            _log.info(`Launching ${threads} workers`);
        }
        const exportPathMap = await nextExportSpan.traceChild("run-export-path-map").traceAsyncFn(async ()=>{
            const exportMap = await nextConfig.exportPathMap(defaultPathMap, {
                dev: false,
                dir,
                outDir,
                distDir,
                buildId
            });
            return exportMap;
        });
        // only add missing 404 page when `buildExport` is false
        if (!options.buildExport) {
            // only add missing /404 if not specified in `exportPathMap`
            if (!exportPathMap["/404"]) {
                exportPathMap["/404"] = {
                    page: "/_error"
                };
            }
            /**
       * exports 404.html for backwards compat
       * E.g. GitHub Pages, GitLab Pages, Cloudflare Pages, Netlify
       */ if (!exportPathMap["/404.html"]) {
                // alias /404.html to /404 to be compatible with custom 404 / _error page
                exportPathMap["/404.html"] = exportPathMap["/404"];
            }
        }
        // make sure to prevent duplicates
        const exportPaths = [
            ...new Set(Object.keys(exportPathMap).map((path)=>(0, _denormalizepagepath.denormalizePagePath)((0, _normalizepagepath.normalizePagePath)(path))))
        ];
        const filteredPaths = exportPaths.filter(// Remove API routes
        (route)=>exportPathMap[route]._isAppDir || !(0, _isapiroute.isAPIRoute)(exportPathMap[route].page));
        if (filteredPaths.length !== exportPaths.length) {
            hasApiRoutes = true;
        }
        if (filteredPaths.length === 0) {
            return;
        }
        if (prerenderManifest && !options.buildExport) {
            const fallbackEnabledPages = new Set();
            for (const path of Object.keys(exportPathMap)){
                const page = exportPathMap[path].page;
                const prerenderInfo = prerenderManifest.dynamicRoutes[page];
                if (prerenderInfo && prerenderInfo.fallback !== false) {
                    fallbackEnabledPages.add(page);
                }
            }
            if (fallbackEnabledPages.size) {
                throw new ExportError(`Found pages with \`fallback\` enabled:\n${[
                    ...fallbackEnabledPages
                ].join("\n")}\n${_constants.SSG_FALLBACK_EXPORT_ERROR}\n`);
            }
        }
        let hasMiddleware = false;
        if (!options.buildExport) {
            try {
                const middlewareManifest = require((0, _path.join)(distDir, _constants1.SERVER_DIRECTORY, _constants1.MIDDLEWARE_MANIFEST));
                hasMiddleware = Object.keys(middlewareManifest.middleware).length > 0;
            } catch (_) {}
            // Warn if the user defines a path for an API page
            if (hasApiRoutes || hasMiddleware) {
                if (!options.silent) {
                    _log.warn(_chalk.default.yellow(`Statically exporting a Next.js application via \`next export\` disables API routes and middleware.`) + `\n` + _chalk.default.yellow(`This command is meant for static-only hosts, and is` + " " + _chalk.default.bold(`not necessary to make your application static.`)) + `\n` + _chalk.default.yellow(`Pages in your application without server-side data dependencies will be automatically statically exported by \`next build\`, including pages powered by \`getStaticProps\`.`) + `\n` + _chalk.default.yellow(`Learn more: https://nextjs.org/docs/messages/api-routes-static-export`));
                }
            }
        }
        const progress = !options.silent && createProgress(filteredPaths.length, `${_log.prefixes.info} ${options.statusMessage || "Exporting"}`);
        const pagesDataDir = options.buildExport ? outDir : (0, _path.join)(outDir, "_next/data", buildId);
        const ampValidations = {};
        let hadValidationError = false;
        const publicDir = (0, _path.join)(dir, _constants1.CLIENT_PUBLIC_FILES_PATH);
        // Copy public directory
        if (!options.buildExport && (0, _fs.existsSync)(publicDir)) {
            if (!options.silent) {
                _log.info('Copying "public" directory');
            }
            await nextExportSpan.traceChild("copy-public-directory").traceAsyncFn(()=>(0, _recursivecopy.recursiveCopy)(publicDir, outDir, {
                    filter (path) {
                        // Exclude paths used by pages
                        return !exportPathMap[path];
                    }
                }));
        }
        const timeout = (nextConfig == null ? void 0 : nextConfig.staticPageGenerationTimeout) || 0;
        let infoPrinted = false;
        let exportPage;
        let exportAppPage;
        let endWorker;
        if (options.exportPageWorker) {
            exportPage = options.exportPageWorker;
            exportAppPage = options.exportAppPageWorker;
            endWorker = options.endWorker || (()=>Promise.resolve());
        } else {
            const worker = new _worker.Worker(require.resolve("./worker"), {
                timeout: timeout * 1000,
                onRestart: (_method, [{ path  }], attempts)=>{
                    if (attempts >= 3) {
                        throw new ExportError(`Static page generation for ${path} is still timing out after 3 attempts. See more info here https://nextjs.org/docs/messages/static-page-generation-timeout`);
                    }
                    _log.warn(`Restarted static page generation for ${path} because it took more than ${timeout} seconds`);
                    if (!infoPrinted) {
                        _log.warn("See more info here https://nextjs.org/docs/messages/static-page-generation-timeout");
                        infoPrinted = true;
                    }
                },
                maxRetries: 0,
                numWorkers: threads,
                enableWorkerThreads: nextConfig.experimental.workerThreads,
                exposedMethods: [
                    "default"
                ]
            });
            exportPage = worker.default.bind(worker);
            endWorker = async ()=>{
                await worker.end();
            };
        }
        let renderError = false;
        const errorPaths = [];
        await Promise.all(filteredPaths.map(async (path)=>{
            const pageExportSpan = nextExportSpan.traceChild("export-page");
            pageExportSpan.setAttribute("path", path);
            return pageExportSpan.traceAsyncFn(async ()=>{
                const pathMap = exportPathMap[path];
                const exportPageOrApp = pathMap._isAppDir ? exportAppPage : exportPage;
                if (!exportPageOrApp) {
                    throw new Error("invariant: Undefined export worker for app dir, this is a bug in Next.js.");
                }
                const result = await exportPageOrApp({
                    path,
                    pathMap,
                    distDir,
                    outDir,
                    pagesDataDir,
                    renderOpts,
                    serverRuntimeConfig,
                    subFolders,
                    buildExport: options.buildExport,
                    optimizeFonts: nextConfig.optimizeFonts,
                    optimizeCss: nextConfig.experimental.optimizeCss,
                    disableOptimizedLoading: nextConfig.experimental.disableOptimizedLoading,
                    parentSpanId: pageExportSpan.id,
                    httpAgentOptions: nextConfig.httpAgentOptions,
                    debugOutput: options.debugOutput,
                    isrMemoryCacheSize: nextConfig.experimental.isrMemoryCacheSize,
                    fetchCache: nextConfig.experimental.appDir,
                    fetchCacheKeyPrefix: nextConfig.experimental.fetchCacheKeyPrefix,
                    incrementalCacheHandlerPath: nextConfig.experimental.incrementalCacheHandlerPath
                });
                for (const validation of result.ampValidations || []){
                    const { page , result: ampValidationResult  } = validation;
                    ampValidations[page] = ampValidationResult;
                    hadValidationError = hadValidationError || Array.isArray(ampValidationResult == null ? void 0 : ampValidationResult.errors) && ampValidationResult.errors.length > 0;
                }
                renderError = renderError || !!result.error;
                if (!!result.error) {
                    const { page  } = pathMap;
                    errorPaths.push(page !== path ? `${page}: ${path}` : path);
                }
                if (options.buildExport) {
                    if (typeof result.fromBuildExportRevalidate !== "undefined") {
                        nextConfig.initialPageRevalidationMap[path] = result.fromBuildExportRevalidate;
                    }
                    if (typeof result.fromBuildExportMeta !== "undefined") {
                        nextConfig.initialPageMetaMap[path] = result.fromBuildExportMeta;
                    }
                    if (result.ssgNotFound === true) {
                        nextConfig.ssgNotFoundPaths.push(path);
                    }
                    const durations = nextConfig.pageDurationMap[pathMap.page] = nextConfig.pageDurationMap[pathMap.page] || {};
                    durations[path] = result.duration;
                }
                if (progress) progress();
            });
        }));
        const endWorkerPromise = endWorker();
        // copy prerendered routes to outDir
        if (!options.buildExport && prerenderManifest) {
            await Promise.all(Object.keys(prerenderManifest.routes).map(async (route)=>{
                const { srcRoute  } = prerenderManifest.routes[route];
                const appPageName = mapAppRouteToPage.get(srcRoute || "");
                const pageName = appPageName || srcRoute || route;
                const isAppPath = Boolean(appPageName);
                const isAppRouteHandler = appPageName && (0, _isapprouteroute.isAppRouteRoute)(appPageName);
                // returning notFound: true from getStaticProps will not
                // output html/json files during the build
                if (prerenderManifest.notFoundRoutes.includes(route)) {
                    return;
                }
                route = (0, _normalizepagepath.normalizePagePath)(route);
                const pagePath = (0, _require.getPagePath)(pageName, distDir, undefined, isAppPath);
                const distPagesDir = (0, _path.join)(pagePath, // strip leading / and then recurse number of nested dirs
                // to place from base folder
                pageName.slice(1).split("/").map(()=>"..").join("/"));
                const orig = (0, _path.join)(distPagesDir, route);
                const handlerSrc = `${orig}.body`;
                const handlerDest = (0, _path.join)(outDir, route);
                if (isAppRouteHandler && await exists(handlerSrc)) {
                    await _fs.promises.mkdir((0, _path.dirname)(handlerDest), {
                        recursive: true
                    });
                    await _fs.promises.copyFile(handlerSrc, handlerDest);
                    return;
                }
                const htmlDest = (0, _path.join)(outDir, `${route}${subFolders && route !== "/index" ? `${_path.sep}index` : ""}.html`);
                const ampHtmlDest = (0, _path.join)(outDir, `${route}.amp${subFolders ? `${_path.sep}index` : ""}.html`);
                const jsonDest = isAppPath ? (0, _path.join)(outDir, `${route}${subFolders && route !== "/index" ? `${_path.sep}index` : ""}.txt`) : (0, _path.join)(pagesDataDir, `${route}.json`);
                await _fs.promises.mkdir((0, _path.dirname)(htmlDest), {
                    recursive: true
                });
                await _fs.promises.mkdir((0, _path.dirname)(jsonDest), {
                    recursive: true
                });
                const htmlSrc = `${orig}.html`;
                const jsonSrc = `${orig}${isAppPath ? ".rsc" : ".json"}`;
                await _fs.promises.copyFile(htmlSrc, htmlDest);
                await _fs.promises.copyFile(jsonSrc, jsonDest);
                if (await exists(`${orig}.amp.html`)) {
                    await _fs.promises.mkdir((0, _path.dirname)(ampHtmlDest), {
                        recursive: true
                    });
                    await _fs.promises.copyFile(`${orig}.amp.html`, ampHtmlDest);
                }
            }));
        }
        if (Object.keys(ampValidations).length) {
            console.log((0, _index.formatAmpMessages)(ampValidations));
        }
        if (hadValidationError) {
            throw new ExportError(`AMP Validation caused the export to fail. https://nextjs.org/docs/messages/amp-export-validation`);
        }
        if (renderError) {
            throw new ExportError(`Export encountered errors on following paths:\n\t${errorPaths.sort().join("\n	")}`);
        }
        (0, _fs.writeFileSync)((0, _path.join)(distDir, _constants1.EXPORT_DETAIL), JSON.stringify({
            version: 1,
            outDirectory: outDir,
            success: true
        }), "utf8");
        if (telemetry) {
            await telemetry.flush();
        }
        await endWorkerPromise;
    });
}

//# sourceMappingURL=index.js.map