/// <reference types="node" />
/// <reference types="node" />
import type { NextConfig } from './config';
import type { ParsedUrlQuery } from 'querystring';
import type { BaseNextRequest, BaseNextResponse } from './base-http';
import type { RouteMatchFn, Params } from '../shared/lib/router/utils/route-matcher';
import type { RouteHas } from '../lib/load-custom-routes';
import { NextUrlWithParsedQuery } from './request-meta';
import { RouteMatcherManager } from './future/route-matcher-managers/route-matcher-manager';
import type { I18NProvider } from './future/helpers/i18n-provider';
type RouteResult = {
    finished: boolean;
    pathname?: string;
    query?: ParsedUrlQuery;
};
type RouteFn = (req: BaseNextRequest, res: BaseNextResponse, params: Params, parsedUrl: NextUrlWithParsedQuery, upgradeHead?: Buffer) => Promise<RouteResult> | RouteResult;
export type Route = {
    match: RouteMatchFn;
    has?: RouteHas[];
    missing?: RouteHas[];
    type: string;
    check?: boolean;
    statusCode?: number;
    name: string;
    matchesBasePath?: true;
    matchesLocale?: true;
    matchesLocaleAPIRoutes?: true;
    matchesTrailingSlash?: true;
    internal?: true;
    fn: RouteFn;
};
export type RouterOptions = {
    headers: ReadonlyArray<Route>;
    fsRoutes: ReadonlyArray<Route>;
    rewrites: {
        beforeFiles: ReadonlyArray<Route>;
        afterFiles: ReadonlyArray<Route>;
        fallback: ReadonlyArray<Route>;
    };
    redirects: ReadonlyArray<Route>;
    catchAllRoute: Route;
    catchAllMiddleware: ReadonlyArray<Route>;
    matchers: RouteMatcherManager;
    useFileSystemPublicRoutes: boolean;
    nextConfig: NextConfig;
    i18nProvider?: I18NProvider;
};
export type PageChecker = (pathname: string) => Promise<boolean>;
export default class Router {
    catchAllMiddleware: ReadonlyArray<Route>;
    private readonly headers;
    private readonly fsRoutes;
    private readonly redirects;
    private rewrites;
    private readonly catchAllRoute;
    private readonly matchers;
    private readonly useFileSystemPublicRoutes;
    private readonly nextConfig;
    private readonly i18nProvider?;
    private compiledRoutes;
    private needsRecompilation;
    constructor({ headers, fsRoutes, rewrites, redirects, catchAllRoute, catchAllMiddleware, matchers, useFileSystemPublicRoutes, nextConfig, i18nProvider, }: RouterOptions);
    get basePath(): string;
    /**
     * True when the router has catch-all middleware routes configured.
     */
    get hasMiddleware(): boolean;
    setCatchallMiddleware(catchAllMiddleware: ReadonlyArray<Route>): void;
    setRewrites(rewrites: RouterOptions['rewrites']): void;
    addFsRoute(fsRoute: Route): void;
    private compileRoutes;
    private checkFsRoutes;
    execute(req: BaseNextRequest, res: BaseNextResponse, parsedUrl: NextUrlWithParsedQuery, upgradeHead?: Buffer): Promise<boolean>;
}
export declare const makeResolver: any;
export {};
