module.exports = "\"use strict\";\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __name = (target, value) => __defProp(target, \"name\", { value, configurable: true });\nvar __export = (target, all) => {\n  for (var name in all)\n    __defProp(target, name, { get: all[name], enumerable: true });\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toCommonJS = (mod) => __copyProps(__defProp({}, \"__esModule\", { value: true }), mod);\n\n// src/primitives/url.js\nvar url_exports = {};\n__export(url_exports, {\n  URLPattern: () => URLPattern\n});\nmodule.exports = __toCommonJS(url_exports);\n\n// ../../node_modules/.pnpm/urlpattern-polyfill@8.0.2/node_modules/urlpattern-polyfill/dist/urlpattern.js\nvar Part = /* @__PURE__ */ __name(class {\n  constructor(type, name, prefix, value, suffix, modifier) {\n    this.type = 3;\n    this.name = \"\";\n    this.prefix = \"\";\n    this.value = \"\";\n    this.suffix = \"\";\n    this.modifier = 3;\n    this.type = type;\n    this.name = name;\n    this.prefix = prefix;\n    this.value = value;\n    this.suffix = suffix;\n    this.modifier = modifier;\n  }\n  hasCustomName() {\n    return this.name !== \"\" && typeof this.name !== \"number\";\n  }\n}, \"Part\");\nvar regexIdentifierStart = /[$_\\p{ID_Start}]/u;\nvar regexIdentifierPart = /[$_\\u200C\\u200D\\p{ID_Continue}]/u;\nvar kFullWildcardRegex = \".*\";\nfunction isASCII(str, extended) {\n  return (extended ? /^[\\x00-\\xFF]*$/ : /^[\\x00-\\x7F]*$/).test(str);\n}\n__name(isASCII, \"isASCII\");\nfunction lexer(str, lenient = false) {\n  const tokens = [];\n  let i = 0;\n  while (i < str.length) {\n    const char = str[i];\n    const ErrorOrInvalid = /* @__PURE__ */ __name(function(msg) {\n      if (!lenient)\n        throw new TypeError(msg);\n      tokens.push({ type: \"INVALID_CHAR\", index: i, value: str[i++] });\n    }, \"ErrorOrInvalid\");\n    if (char === \"*\") {\n      tokens.push({ type: \"ASTERISK\", index: i, value: str[i++] });\n      continue;\n    }\n    if (char === \"+\" || char === \"?\") {\n      tokens.push({ type: \"OTHER_MODIFIER\", index: i, value: str[i++] });\n      continue;\n    }\n    if (char === \"\\\\\") {\n      tokens.push({ type: \"ESCAPED_CHAR\", index: i++, value: str[i++] });\n      continue;\n    }\n    if (char === \"{\") {\n      tokens.push({ type: \"OPEN\", index: i, value: str[i++] });\n      continue;\n    }\n    if (char === \"}\") {\n      tokens.push({ type: \"CLOSE\", index: i, value: str[i++] });\n      continue;\n    }\n    if (char === \":\") {\n      let name = \"\";\n      let j = i + 1;\n      while (j < str.length) {\n        const code = str.substr(j, 1);\n        if (j === i + 1 && regexIdentifierStart.test(code) || j !== i + 1 && regexIdentifierPart.test(code)) {\n          name += str[j++];\n          continue;\n        }\n        break;\n      }\n      if (!name) {\n        ErrorOrInvalid(`Missing parameter name at ${i}`);\n        continue;\n      }\n      tokens.push({ type: \"NAME\", index: i, value: name });\n      i = j;\n      continue;\n    }\n    if (char === \"(\") {\n      let count = 1;\n      let pattern = \"\";\n      let j = i + 1;\n      let error = false;\n      if (str[j] === \"?\") {\n        ErrorOrInvalid(`Pattern cannot start with \"?\" at ${j}`);\n        continue;\n      }\n      while (j < str.length) {\n        if (!isASCII(str[j], false)) {\n          ErrorOrInvalid(`Invalid character '${str[j]}' at ${j}.`);\n          error = true;\n          break;\n        }\n        if (str[j] === \"\\\\\") {\n          pattern += str[j++] + str[j++];\n          continue;\n        }\n        if (str[j] === \")\") {\n          count--;\n          if (count === 0) {\n            j++;\n            break;\n          }\n        } else if (str[j] === \"(\") {\n          count++;\n          if (str[j + 1] !== \"?\") {\n            ErrorOrInvalid(`Capturing groups are not allowed at ${j}`);\n            error = true;\n            break;\n          }\n        }\n        pattern += str[j++];\n      }\n      if (error) {\n        continue;\n      }\n      if (count) {\n        ErrorOrInvalid(`Unbalanced pattern at ${i}`);\n        continue;\n      }\n      if (!pattern) {\n        ErrorOrInvalid(`Missing pattern at ${i}`);\n        continue;\n      }\n      tokens.push({ type: \"REGEX\", index: i, value: pattern });\n      i = j;\n      continue;\n    }\n    tokens.push({ type: \"CHAR\", index: i, value: str[i++] });\n  }\n  tokens.push({ type: \"END\", index: i, value: \"\" });\n  return tokens;\n}\n__name(lexer, \"lexer\");\nfunction parse(str, options = {}) {\n  const tokens = lexer(str);\n  options.delimiter ?? (options.delimiter = \"/#?\");\n  options.prefixes ?? (options.prefixes = \"./\");\n  const segmentWildcardRegex = `[^${escapeString(options.delimiter)}]+?`;\n  const result = [];\n  let key = 0;\n  let i = 0;\n  let path = \"\";\n  let nameSet = /* @__PURE__ */ new Set();\n  const tryConsume = /* @__PURE__ */ __name((type) => {\n    if (i < tokens.length && tokens[i].type === type)\n      return tokens[i++].value;\n  }, \"tryConsume\");\n  const tryConsumeModifier = /* @__PURE__ */ __name(() => {\n    return tryConsume(\"OTHER_MODIFIER\") ?? tryConsume(\"ASTERISK\");\n  }, \"tryConsumeModifier\");\n  const mustConsume = /* @__PURE__ */ __name((type) => {\n    const value = tryConsume(type);\n    if (value !== void 0)\n      return value;\n    const { type: nextType, index } = tokens[i];\n    throw new TypeError(`Unexpected ${nextType} at ${index}, expected ${type}`);\n  }, \"mustConsume\");\n  const consumeText = /* @__PURE__ */ __name(() => {\n    let result2 = \"\";\n    let value;\n    while (value = tryConsume(\"CHAR\") ?? tryConsume(\"ESCAPED_CHAR\")) {\n      result2 += value;\n    }\n    return result2;\n  }, \"consumeText\");\n  const DefaultEncodePart = /* @__PURE__ */ __name((value) => {\n    return value;\n  }, \"DefaultEncodePart\");\n  const encodePart = options.encodePart || DefaultEncodePart;\n  let pendingFixedValue = \"\";\n  const appendToPendingFixedValue = /* @__PURE__ */ __name((value) => {\n    pendingFixedValue += value;\n  }, \"appendToPendingFixedValue\");\n  const maybeAddPartFromPendingFixedValue = /* @__PURE__ */ __name(() => {\n    if (!pendingFixedValue.length) {\n      return;\n    }\n    result.push(new Part(\n      3,\n      \"\",\n      \"\",\n      encodePart(pendingFixedValue),\n      \"\",\n      3\n      /* kNone */\n    ));\n    pendingFixedValue = \"\";\n  }, \"maybeAddPartFromPendingFixedValue\");\n  const addPart = /* @__PURE__ */ __name((prefix, nameToken, regexOrWildcardToken, suffix, modifierToken) => {\n    let modifier = 3;\n    switch (modifierToken) {\n      case \"?\":\n        modifier = 1;\n        break;\n      case \"*\":\n        modifier = 0;\n        break;\n      case \"+\":\n        modifier = 2;\n        break;\n    }\n    if (!nameToken && !regexOrWildcardToken && modifier === 3) {\n      appendToPendingFixedValue(prefix);\n      return;\n    }\n    maybeAddPartFromPendingFixedValue();\n    if (!nameToken && !regexOrWildcardToken) {\n      if (!prefix) {\n        return;\n      }\n      result.push(new Part(3, \"\", \"\", encodePart(prefix), \"\", modifier));\n      return;\n    }\n    let regexValue;\n    if (!regexOrWildcardToken) {\n      regexValue = segmentWildcardRegex;\n    } else if (regexOrWildcardToken === \"*\") {\n      regexValue = kFullWildcardRegex;\n    } else {\n      regexValue = regexOrWildcardToken;\n    }\n    let type = 2;\n    if (regexValue === segmentWildcardRegex) {\n      type = 1;\n      regexValue = \"\";\n    } else if (regexValue === kFullWildcardRegex) {\n      type = 0;\n      regexValue = \"\";\n    }\n    let name;\n    if (nameToken) {\n      name = nameToken;\n    } else if (regexOrWildcardToken) {\n      name = key++;\n    }\n    if (nameSet.has(name)) {\n      throw new TypeError(`Duplicate name '${name}'.`);\n    }\n    nameSet.add(name);\n    result.push(new Part(type, name, encodePart(prefix), regexValue, encodePart(suffix), modifier));\n  }, \"addPart\");\n  while (i < tokens.length) {\n    const charToken = tryConsume(\"CHAR\");\n    const nameToken = tryConsume(\"NAME\");\n    let regexOrWildcardToken = tryConsume(\"REGEX\");\n    if (!nameToken && !regexOrWildcardToken) {\n      regexOrWildcardToken = tryConsume(\"ASTERISK\");\n    }\n    if (nameToken || regexOrWildcardToken) {\n      let prefix = charToken ?? \"\";\n      if (options.prefixes.indexOf(prefix) === -1) {\n        appendToPendingFixedValue(prefix);\n        prefix = \"\";\n      }\n      maybeAddPartFromPendingFixedValue();\n      let modifierToken = tryConsumeModifier();\n      addPart(prefix, nameToken, regexOrWildcardToken, \"\", modifierToken);\n      continue;\n    }\n    const value = charToken ?? tryConsume(\"ESCAPED_CHAR\");\n    if (value) {\n      appendToPendingFixedValue(value);\n      continue;\n    }\n    const openToken = tryConsume(\"OPEN\");\n    if (openToken) {\n      const prefix = consumeText();\n      const nameToken2 = tryConsume(\"NAME\");\n      let regexOrWildcardToken2 = tryConsume(\"REGEX\");\n      if (!nameToken2 && !regexOrWildcardToken2) {\n        regexOrWildcardToken2 = tryConsume(\"ASTERISK\");\n      }\n      const suffix = consumeText();\n      mustConsume(\"CLOSE\");\n      const modifierToken = tryConsumeModifier();\n      addPart(prefix, nameToken2, regexOrWildcardToken2, suffix, modifierToken);\n      continue;\n    }\n    maybeAddPartFromPendingFixedValue();\n    mustConsume(\"END\");\n  }\n  return result;\n}\n__name(parse, \"parse\");\nfunction escapeString(str) {\n  return str.replace(/([.+*?^${}()[\\]|/\\\\])/g, \"\\\\$1\");\n}\n__name(escapeString, \"escapeString\");\nfunction flags(options) {\n  return options && options.ignoreCase ? \"ui\" : \"u\";\n}\n__name(flags, \"flags\");\nfunction stringToRegexp(path, names, options) {\n  return partsToRegexp(parse(path, options), names, options);\n}\n__name(stringToRegexp, \"stringToRegexp\");\nfunction modifierToString(modifier) {\n  switch (modifier) {\n    case 0:\n      return \"*\";\n    case 1:\n      return \"?\";\n    case 2:\n      return \"+\";\n    case 3:\n      return \"\";\n  }\n}\n__name(modifierToString, \"modifierToString\");\nfunction partsToRegexp(parts, names, options = {}) {\n  options.delimiter ?? (options.delimiter = \"/#?\");\n  options.prefixes ?? (options.prefixes = \"./\");\n  options.sensitive ?? (options.sensitive = false);\n  options.strict ?? (options.strict = false);\n  options.end ?? (options.end = true);\n  options.start ?? (options.start = true);\n  options.endsWith = \"\";\n  let result = options.start ? \"^\" : \"\";\n  for (const part of parts) {\n    if (part.type === 3) {\n      if (part.modifier === 3) {\n        result += escapeString(part.value);\n      } else {\n        result += `(?:${escapeString(part.value)})${modifierToString(part.modifier)}`;\n      }\n      continue;\n    }\n    if (names)\n      names.push(part.name);\n    const segmentWildcardRegex = `[^${escapeString(options.delimiter)}]+?`;\n    let regexValue = part.value;\n    if (part.type === 1)\n      regexValue = segmentWildcardRegex;\n    else if (part.type === 0)\n      regexValue = kFullWildcardRegex;\n    if (!part.prefix.length && !part.suffix.length) {\n      if (part.modifier === 3 || part.modifier === 1) {\n        result += `(${regexValue})${modifierToString(part.modifier)}`;\n      } else {\n        result += `((?:${regexValue})${modifierToString(part.modifier)})`;\n      }\n      continue;\n    }\n    if (part.modifier === 3 || part.modifier === 1) {\n      result += `(?:${escapeString(part.prefix)}(${regexValue})${escapeString(part.suffix)})`;\n      result += modifierToString(part.modifier);\n      continue;\n    }\n    result += `(?:${escapeString(part.prefix)}`;\n    result += `((?:${regexValue})(?:`;\n    result += escapeString(part.suffix);\n    result += escapeString(part.prefix);\n    result += `(?:${regexValue}))*)${escapeString(part.suffix)})`;\n    if (part.modifier === 0) {\n      result += \"?\";\n    }\n  }\n  const endsWith = `[${escapeString(options.endsWith)}]|$`;\n  const delimiter = `[${escapeString(options.delimiter)}]`;\n  if (options.end) {\n    if (!options.strict) {\n      result += `${delimiter}?`;\n    }\n    if (!options.endsWith.length) {\n      result += \"$\";\n    } else {\n      result += `(?=${endsWith})`;\n    }\n    return new RegExp(result, flags(options));\n  }\n  if (!options.strict) {\n    result += `(?:${delimiter}(?=${endsWith}))?`;\n  }\n  let isEndDelimited = false;\n  if (parts.length) {\n    const lastPart = parts[parts.length - 1];\n    if (lastPart.type === 3 && lastPart.modifier === 3) {\n      isEndDelimited = options.delimiter.indexOf(lastPart) > -1;\n    }\n  }\n  if (!isEndDelimited) {\n    result += `(?=${delimiter}|${endsWith})`;\n  }\n  return new RegExp(result, flags(options));\n}\n__name(partsToRegexp, \"partsToRegexp\");\nvar DEFAULT_OPTIONS = {\n  delimiter: \"\",\n  prefixes: \"\",\n  sensitive: true,\n  strict: true\n};\nvar HOSTNAME_OPTIONS = {\n  delimiter: \".\",\n  prefixes: \"\",\n  sensitive: true,\n  strict: true\n};\nvar PATHNAME_OPTIONS = {\n  delimiter: \"/\",\n  prefixes: \"/\",\n  sensitive: true,\n  strict: true\n};\nfunction isAbsolutePathname(pathname, isPattern) {\n  if (!pathname.length) {\n    return false;\n  }\n  if (pathname[0] === \"/\") {\n    return true;\n  }\n  if (!isPattern) {\n    return false;\n  }\n  if (pathname.length < 2) {\n    return false;\n  }\n  if ((pathname[0] == \"\\\\\" || pathname[0] == \"{\") && pathname[1] == \"/\") {\n    return true;\n  }\n  return false;\n}\n__name(isAbsolutePathname, \"isAbsolutePathname\");\nfunction maybeStripPrefix(value, prefix) {\n  if (value.startsWith(prefix)) {\n    return value.substring(prefix.length, value.length);\n  }\n  return value;\n}\n__name(maybeStripPrefix, \"maybeStripPrefix\");\nfunction maybeStripSuffix(value, suffix) {\n  if (value.endsWith(suffix)) {\n    return value.substr(0, value.length - suffix.length);\n  }\n  return value;\n}\n__name(maybeStripSuffix, \"maybeStripSuffix\");\nfunction treatAsIPv6Hostname(value) {\n  if (!value || value.length < 2) {\n    return false;\n  }\n  if (value[0] === \"[\") {\n    return true;\n  }\n  if ((value[0] === \"\\\\\" || value[0] === \"{\") && value[1] === \"[\") {\n    return true;\n  }\n  return false;\n}\n__name(treatAsIPv6Hostname, \"treatAsIPv6Hostname\");\nvar SPECIAL_SCHEMES = [\n  \"ftp\",\n  \"file\",\n  \"http\",\n  \"https\",\n  \"ws\",\n  \"wss\"\n];\nfunction isSpecialScheme(protocol_regexp) {\n  if (!protocol_regexp) {\n    return true;\n  }\n  for (const scheme of SPECIAL_SCHEMES) {\n    if (protocol_regexp.test(scheme)) {\n      return true;\n    }\n  }\n  return false;\n}\n__name(isSpecialScheme, \"isSpecialScheme\");\nfunction canonicalizeHash(hash, isPattern) {\n  hash = maybeStripPrefix(hash, \"#\");\n  if (isPattern || hash === \"\") {\n    return hash;\n  }\n  const url = new URL(\"https://example.com\");\n  url.hash = hash;\n  return url.hash ? url.hash.substring(1, url.hash.length) : \"\";\n}\n__name(canonicalizeHash, \"canonicalizeHash\");\nfunction canonicalizeSearch(search, isPattern) {\n  search = maybeStripPrefix(search, \"?\");\n  if (isPattern || search === \"\") {\n    return search;\n  }\n  const url = new URL(\"https://example.com\");\n  url.search = search;\n  return url.search ? url.search.substring(1, url.search.length) : \"\";\n}\n__name(canonicalizeSearch, \"canonicalizeSearch\");\nfunction canonicalizeHostname(hostname, isPattern) {\n  if (isPattern || hostname === \"\") {\n    return hostname;\n  }\n  if (treatAsIPv6Hostname(hostname)) {\n    return ipv6HostnameEncodeCallback(hostname);\n  } else {\n    return hostnameEncodeCallback(hostname);\n  }\n}\n__name(canonicalizeHostname, \"canonicalizeHostname\");\nfunction canonicalizePassword(password, isPattern) {\n  if (isPattern || password === \"\") {\n    return password;\n  }\n  const url = new URL(\"https://example.com\");\n  url.password = password;\n  return url.password;\n}\n__name(canonicalizePassword, \"canonicalizePassword\");\nfunction canonicalizeUsername(username, isPattern) {\n  if (isPattern || username === \"\") {\n    return username;\n  }\n  const url = new URL(\"https://example.com\");\n  url.username = username;\n  return url.username;\n}\n__name(canonicalizeUsername, \"canonicalizeUsername\");\nfunction canonicalizePathname(pathname, protocol, isPattern) {\n  if (isPattern || pathname === \"\") {\n    return pathname;\n  }\n  if (protocol && !SPECIAL_SCHEMES.includes(protocol)) {\n    const url = new URL(`${protocol}:${pathname}`);\n    return url.pathname;\n  }\n  const leadingSlash = pathname[0] == \"/\";\n  pathname = new URL(\n    !leadingSlash ? \"/-\" + pathname : pathname,\n    \"https://example.com\"\n  ).pathname;\n  if (!leadingSlash) {\n    pathname = pathname.substring(2, pathname.length);\n  }\n  return pathname;\n}\n__name(canonicalizePathname, \"canonicalizePathname\");\nfunction canonicalizePort(port, protocol, isPattern) {\n  if (defaultPortForProtocol(protocol) === port) {\n    port = \"\";\n  }\n  if (isPattern || port === \"\") {\n    return port;\n  }\n  return portEncodeCallback(port);\n}\n__name(canonicalizePort, \"canonicalizePort\");\nfunction canonicalizeProtocol(protocol, isPattern) {\n  protocol = maybeStripSuffix(protocol, \":\");\n  if (isPattern || protocol === \"\") {\n    return protocol;\n  }\n  return protocolEncodeCallback(protocol);\n}\n__name(canonicalizeProtocol, \"canonicalizeProtocol\");\nfunction defaultPortForProtocol(protocol) {\n  switch (protocol) {\n    case \"ws\":\n    case \"http\":\n      return \"80\";\n    case \"wws\":\n    case \"https\":\n      return \"443\";\n    case \"ftp\":\n      return \"21\";\n    default:\n      return \"\";\n  }\n}\n__name(defaultPortForProtocol, \"defaultPortForProtocol\");\nfunction protocolEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  if (/^[-+.A-Za-z0-9]*$/.test(input))\n    return input.toLowerCase();\n  throw new TypeError(`Invalid protocol '${input}'.`);\n}\n__name(protocolEncodeCallback, \"protocolEncodeCallback\");\nfunction usernameEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(\"https://example.com\");\n  url.username = input;\n  return url.username;\n}\n__name(usernameEncodeCallback, \"usernameEncodeCallback\");\nfunction passwordEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(\"https://example.com\");\n  url.password = input;\n  return url.password;\n}\n__name(passwordEncodeCallback, \"passwordEncodeCallback\");\nfunction hostnameEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  if (/[\\t\\n\\r #%/:<>?@[\\]^\\\\|]/g.test(input)) {\n    throw new TypeError(`Invalid hostname '${input}'`);\n  }\n  const url = new URL(\"https://example.com\");\n  url.hostname = input;\n  return url.hostname;\n}\n__name(hostnameEncodeCallback, \"hostnameEncodeCallback\");\nfunction ipv6HostnameEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  if (/[^0-9a-fA-F[\\]:]/g.test(input)) {\n    throw new TypeError(`Invalid IPv6 hostname '${input}'`);\n  }\n  return input.toLowerCase();\n}\n__name(ipv6HostnameEncodeCallback, \"ipv6HostnameEncodeCallback\");\nfunction portEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  if (/^[0-9]*$/.test(input) && parseInt(input) <= 65535) {\n    return input;\n  }\n  throw new TypeError(`Invalid port '${input}'.`);\n}\n__name(portEncodeCallback, \"portEncodeCallback\");\nfunction standardURLPathnameEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(\"https://example.com\");\n  url.pathname = input[0] !== \"/\" ? \"/-\" + input : input;\n  if (input[0] !== \"/\") {\n    return url.pathname.substring(2, url.pathname.length);\n  }\n  return url.pathname;\n}\n__name(standardURLPathnameEncodeCallback, \"standardURLPathnameEncodeCallback\");\nfunction pathURLPathnameEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(`data:${input}`);\n  return url.pathname;\n}\n__name(pathURLPathnameEncodeCallback, \"pathURLPathnameEncodeCallback\");\nfunction searchEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(\"https://example.com\");\n  url.search = input;\n  return url.search.substring(1, url.search.length);\n}\n__name(searchEncodeCallback, \"searchEncodeCallback\");\nfunction hashEncodeCallback(input) {\n  if (input === \"\") {\n    return input;\n  }\n  const url = new URL(\"https://example.com\");\n  url.hash = input;\n  return url.hash.substring(1, url.hash.length);\n}\n__name(hashEncodeCallback, \"hashEncodeCallback\");\nvar Parser = /* @__PURE__ */ __name(class {\n  constructor(input) {\n    this.tokenList = [];\n    this.internalResult = {};\n    this.tokenIndex = 0;\n    this.tokenIncrement = 1;\n    this.componentStart = 0;\n    this.state = 0;\n    this.groupDepth = 0;\n    this.hostnameIPv6BracketDepth = 0;\n    this.shouldTreatAsStandardURL = false;\n    this.input = input;\n  }\n  // Return the parse result.  The result is only available after the\n  // `parse()` method completes.\n  get result() {\n    return this.internalResult;\n  }\n  // Attempt to parse the input string used to construct the Parser object.\n  // This method may only be called once.  Any errors will be thrown as an\n  // exception.  Retrieve the parse result by accessing the `Parser.result`\n  // property getter.\n  parse() {\n    this.tokenList = lexer(\n      this.input,\n      /*lenient=*/\n      true\n    );\n    for (; this.tokenIndex < this.tokenList.length; this.tokenIndex += this.tokenIncrement) {\n      this.tokenIncrement = 1;\n      if (this.tokenList[this.tokenIndex].type === \"END\") {\n        if (this.state === 0) {\n          this.rewind();\n          if (this.isHashPrefix()) {\n            this.changeState(\n              9,\n              /*skip=*/\n              1\n            );\n          } else if (this.isSearchPrefix()) {\n            this.changeState(\n              8,\n              /*skip=*/\n              1\n            );\n            this.internalResult.hash = \"\";\n          } else {\n            this.changeState(\n              7,\n              /*skip=*/\n              0\n            );\n            this.internalResult.search = \"\";\n            this.internalResult.hash = \"\";\n          }\n          continue;\n        } else if (this.state === 2) {\n          this.rewindAndSetState(\n            5\n            /* HOSTNAME */\n          );\n          continue;\n        }\n        this.changeState(\n          10,\n          /*skip=*/\n          0\n        );\n        break;\n      }\n      if (this.groupDepth > 0) {\n        if (this.isGroupClose()) {\n          this.groupDepth -= 1;\n        } else {\n          continue;\n        }\n      }\n      if (this.isGroupOpen()) {\n        this.groupDepth += 1;\n        continue;\n      }\n      switch (this.state) {\n        case 0:\n          if (this.isProtocolSuffix()) {\n            this.internalResult.username = \"\";\n            this.internalResult.password = \"\";\n            this.internalResult.hostname = \"\";\n            this.internalResult.port = \"\";\n            this.internalResult.pathname = \"\";\n            this.internalResult.search = \"\";\n            this.internalResult.hash = \"\";\n            this.rewindAndSetState(\n              1\n              /* PROTOCOL */\n            );\n          }\n          break;\n        case 1:\n          if (this.isProtocolSuffix()) {\n            this.computeShouldTreatAsStandardURL();\n            let nextState = 7;\n            let skip = 1;\n            if (this.shouldTreatAsStandardURL) {\n              this.internalResult.pathname = \"/\";\n            }\n            if (this.nextIsAuthoritySlashes()) {\n              nextState = 2;\n              skip = 3;\n            } else if (this.shouldTreatAsStandardURL) {\n              nextState = 2;\n            }\n            this.changeState(nextState, skip);\n          }\n          break;\n        case 2:\n          if (this.isIdentityTerminator()) {\n            this.rewindAndSetState(\n              3\n              /* USERNAME */\n            );\n          } else if (this.isPathnameStart() || this.isSearchPrefix() || this.isHashPrefix()) {\n            this.rewindAndSetState(\n              5\n              /* HOSTNAME */\n            );\n          }\n          break;\n        case 3:\n          if (this.isPasswordPrefix()) {\n            this.changeState(\n              4,\n              /*skip=*/\n              1\n            );\n          } else if (this.isIdentityTerminator()) {\n            this.changeState(\n              5,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 4:\n          if (this.isIdentityTerminator()) {\n            this.changeState(\n              5,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 5:\n          if (this.isIPv6Open()) {\n            this.hostnameIPv6BracketDepth += 1;\n          } else if (this.isIPv6Close()) {\n            this.hostnameIPv6BracketDepth -= 1;\n          }\n          if (this.isPortPrefix() && !this.hostnameIPv6BracketDepth) {\n            this.changeState(\n              6,\n              /*skip=*/\n              1\n            );\n          } else if (this.isPathnameStart()) {\n            this.changeState(\n              7,\n              /*skip=*/\n              0\n            );\n          } else if (this.isSearchPrefix()) {\n            this.changeState(\n              8,\n              /*skip=*/\n              1\n            );\n          } else if (this.isHashPrefix()) {\n            this.changeState(\n              9,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 6:\n          if (this.isPathnameStart()) {\n            this.changeState(\n              7,\n              /*skip=*/\n              0\n            );\n          } else if (this.isSearchPrefix()) {\n            this.changeState(\n              8,\n              /*skip=*/\n              1\n            );\n          } else if (this.isHashPrefix()) {\n            this.changeState(\n              9,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 7:\n          if (this.isSearchPrefix()) {\n            this.changeState(\n              8,\n              /*skip=*/\n              1\n            );\n          } else if (this.isHashPrefix()) {\n            this.changeState(\n              9,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 8:\n          if (this.isHashPrefix()) {\n            this.changeState(\n              9,\n              /*skip=*/\n              1\n            );\n          }\n          break;\n        case 9:\n          break;\n        case 10:\n          break;\n      }\n    }\n  }\n  changeState(newState, skip) {\n    switch (this.state) {\n      case 0:\n        break;\n      case 1:\n        this.internalResult.protocol = this.makeComponentString();\n        break;\n      case 2:\n        break;\n      case 3:\n        this.internalResult.username = this.makeComponentString();\n        break;\n      case 4:\n        this.internalResult.password = this.makeComponentString();\n        break;\n      case 5:\n        this.internalResult.hostname = this.makeComponentString();\n        break;\n      case 6:\n        this.internalResult.port = this.makeComponentString();\n        break;\n      case 7:\n        this.internalResult.pathname = this.makeComponentString();\n        break;\n      case 8:\n        this.internalResult.search = this.makeComponentString();\n        break;\n      case 9:\n        this.internalResult.hash = this.makeComponentString();\n        break;\n      case 10:\n        break;\n    }\n    this.changeStateWithoutSettingComponent(newState, skip);\n  }\n  changeStateWithoutSettingComponent(newState, skip) {\n    this.state = newState;\n    this.componentStart = this.tokenIndex + skip;\n    this.tokenIndex += skip;\n    this.tokenIncrement = 0;\n  }\n  rewind() {\n    this.tokenIndex = this.componentStart;\n    this.tokenIncrement = 0;\n  }\n  rewindAndSetState(newState) {\n    this.rewind();\n    this.state = newState;\n  }\n  safeToken(index) {\n    if (index < 0) {\n      index = this.tokenList.length - index;\n    }\n    if (index < this.tokenList.length) {\n      return this.tokenList[index];\n    }\n    return this.tokenList[this.tokenList.length - 1];\n  }\n  isNonSpecialPatternChar(index, value) {\n    const token = this.safeToken(index);\n    return token.value === value && (token.type === \"CHAR\" || token.type === \"ESCAPED_CHAR\" || token.type === \"INVALID_CHAR\");\n  }\n  isProtocolSuffix() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \":\");\n  }\n  nextIsAuthoritySlashes() {\n    return this.isNonSpecialPatternChar(this.tokenIndex + 1, \"/\") && this.isNonSpecialPatternChar(this.tokenIndex + 2, \"/\");\n  }\n  isIdentityTerminator() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \"@\");\n  }\n  isPasswordPrefix() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \":\");\n  }\n  isPortPrefix() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \":\");\n  }\n  isPathnameStart() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \"/\");\n  }\n  isSearchPrefix() {\n    if (this.isNonSpecialPatternChar(this.tokenIndex, \"?\")) {\n      return true;\n    }\n    if (this.tokenList[this.tokenIndex].value !== \"?\") {\n      return false;\n    }\n    const previousToken = this.safeToken(this.tokenIndex - 1);\n    return previousToken.type !== \"NAME\" && previousToken.type !== \"REGEX\" && previousToken.type !== \"CLOSE\" && previousToken.type !== \"ASTERISK\";\n  }\n  isHashPrefix() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \"#\");\n  }\n  isGroupOpen() {\n    return this.tokenList[this.tokenIndex].type == \"OPEN\";\n  }\n  isGroupClose() {\n    return this.tokenList[this.tokenIndex].type == \"CLOSE\";\n  }\n  isIPv6Open() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \"[\");\n  }\n  isIPv6Close() {\n    return this.isNonSpecialPatternChar(this.tokenIndex, \"]\");\n  }\n  makeComponentString() {\n    const token = this.tokenList[this.tokenIndex];\n    const componentCharStart = this.safeToken(this.componentStart).index;\n    return this.input.substring(componentCharStart, token.index);\n  }\n  computeShouldTreatAsStandardURL() {\n    const options = {};\n    Object.assign(options, DEFAULT_OPTIONS);\n    options.encodePart = protocolEncodeCallback;\n    const regexp = stringToRegexp(\n      this.makeComponentString(),\n      /*keys=*/\n      void 0,\n      options\n    );\n    this.shouldTreatAsStandardURL = isSpecialScheme(regexp);\n  }\n}, \"Parser\");\nvar COMPONENTS = [\n  \"protocol\",\n  \"username\",\n  \"password\",\n  \"hostname\",\n  \"port\",\n  \"pathname\",\n  \"search\",\n  \"hash\"\n];\nvar DEFAULT_PATTERN = \"*\";\nfunction extractValues(url, baseURL) {\n  if (typeof url !== \"string\") {\n    throw new TypeError(`parameter 1 is not of type 'string'.`);\n  }\n  const o = new URL(url, baseURL);\n  return {\n    protocol: o.protocol.substring(0, o.protocol.length - 1),\n    username: o.username,\n    password: o.password,\n    hostname: o.hostname,\n    port: o.port,\n    pathname: o.pathname,\n    search: o.search !== \"\" ? o.search.substring(1, o.search.length) : void 0,\n    hash: o.hash !== \"\" ? o.hash.substring(1, o.hash.length) : void 0\n  };\n}\n__name(extractValues, \"extractValues\");\nfunction processBaseURLString(input, isPattern) {\n  if (!isPattern) {\n    return input;\n  }\n  return escapePatternString(input);\n}\n__name(processBaseURLString, \"processBaseURLString\");\nfunction applyInit(o, init, isPattern) {\n  let baseURL;\n  if (typeof init.baseURL === \"string\") {\n    try {\n      baseURL = new URL(init.baseURL);\n      o.protocol = processBaseURLString(baseURL.protocol.substring(0, baseURL.protocol.length - 1), isPattern);\n      o.username = processBaseURLString(baseURL.username, isPattern);\n      o.password = processBaseURLString(baseURL.password, isPattern);\n      o.hostname = processBaseURLString(baseURL.hostname, isPattern);\n      o.port = processBaseURLString(baseURL.port, isPattern);\n      o.pathname = processBaseURLString(baseURL.pathname, isPattern);\n      o.search = processBaseURLString(baseURL.search.substring(1, baseURL.search.length), isPattern);\n      o.hash = processBaseURLString(baseURL.hash.substring(1, baseURL.hash.length), isPattern);\n    } catch {\n      throw new TypeError(`invalid baseURL '${init.baseURL}'.`);\n    }\n  }\n  if (typeof init.protocol === \"string\") {\n    o.protocol = canonicalizeProtocol(init.protocol, isPattern);\n  }\n  if (typeof init.username === \"string\") {\n    o.username = canonicalizeUsername(init.username, isPattern);\n  }\n  if (typeof init.password === \"string\") {\n    o.password = canonicalizePassword(init.password, isPattern);\n  }\n  if (typeof init.hostname === \"string\") {\n    o.hostname = canonicalizeHostname(init.hostname, isPattern);\n  }\n  if (typeof init.port === \"string\") {\n    o.port = canonicalizePort(init.port, o.protocol, isPattern);\n  }\n  if (typeof init.pathname === \"string\") {\n    o.pathname = init.pathname;\n    if (baseURL && !isAbsolutePathname(o.pathname, isPattern)) {\n      const slashIndex = baseURL.pathname.lastIndexOf(\"/\");\n      if (slashIndex >= 0) {\n        o.pathname = processBaseURLString(baseURL.pathname.substring(0, slashIndex + 1), isPattern) + o.pathname;\n      }\n    }\n    o.pathname = canonicalizePathname(o.pathname, o.protocol, isPattern);\n  }\n  if (typeof init.search === \"string\") {\n    o.search = canonicalizeSearch(init.search, isPattern);\n  }\n  if (typeof init.hash === \"string\") {\n    o.hash = canonicalizeHash(init.hash, isPattern);\n  }\n  return o;\n}\n__name(applyInit, \"applyInit\");\nfunction escapePatternString(value) {\n  return value.replace(/([+*?:{}()\\\\])/g, \"\\\\$1\");\n}\n__name(escapePatternString, \"escapePatternString\");\nfunction escapeRegexpString(value) {\n  return value.replace(/([.+*?^${}()[\\]|/\\\\])/g, \"\\\\$1\");\n}\n__name(escapeRegexpString, \"escapeRegexpString\");\nfunction partsToPattern(parts, options) {\n  options.delimiter ?? (options.delimiter = \"/#?\");\n  options.prefixes ?? (options.prefixes = \"./\");\n  options.sensitive ?? (options.sensitive = false);\n  options.strict ?? (options.strict = false);\n  options.end ?? (options.end = true);\n  options.start ?? (options.start = true);\n  options.endsWith = \"\";\n  const kFullWildcardRegex2 = \".*\";\n  const segmentWildcardRegex = `[^${escapeRegexpString(options.delimiter)}]+?`;\n  const regexIdentifierPart2 = /[$_\\u200C\\u200D\\p{ID_Continue}]/u;\n  let result = \"\";\n  for (let i = 0; i < parts.length; ++i) {\n    const part = parts[i];\n    if (part.type === 3) {\n      if (part.modifier === 3) {\n        result += escapePatternString(part.value);\n        continue;\n      }\n      result += `{${escapePatternString(part.value)}}${modifierToString(part.modifier)}`;\n      continue;\n    }\n    const customName = part.hasCustomName();\n    let needsGrouping = !!part.suffix.length || !!part.prefix.length && (part.prefix.length !== 1 || !options.prefixes.includes(part.prefix));\n    const lastPart = i > 0 ? parts[i - 1] : null;\n    const nextPart = i < parts.length - 1 ? parts[i + 1] : null;\n    if (!needsGrouping && customName && part.type === 1 && part.modifier === 3 && nextPart && !nextPart.prefix.length && !nextPart.suffix.length) {\n      if (nextPart.type === 3) {\n        const code = nextPart.value.length > 0 ? nextPart.value[0] : \"\";\n        needsGrouping = regexIdentifierPart2.test(code);\n      } else {\n        needsGrouping = !nextPart.hasCustomName();\n      }\n    }\n    if (!needsGrouping && !part.prefix.length && lastPart && lastPart.type === 3) {\n      const code = lastPart.value[lastPart.value.length - 1];\n      needsGrouping = options.prefixes.includes(code);\n    }\n    if (needsGrouping) {\n      result += \"{\";\n    }\n    result += escapePatternString(part.prefix);\n    if (customName) {\n      result += `:${part.name}`;\n    }\n    if (part.type === 2) {\n      result += `(${part.value})`;\n    } else if (part.type === 1) {\n      if (!customName) {\n        result += `(${segmentWildcardRegex})`;\n      }\n    } else if (part.type === 0) {\n      if (!customName && (!lastPart || lastPart.type === 3 || lastPart.modifier !== 3 || needsGrouping || part.prefix !== \"\")) {\n        result += \"*\";\n      } else {\n        result += `(${kFullWildcardRegex2})`;\n      }\n    }\n    if (part.type === 1 && customName && !!part.suffix.length) {\n      if (regexIdentifierPart2.test(part.suffix[0])) {\n        result += \"\\\\\";\n      }\n    }\n    result += escapePatternString(part.suffix);\n    if (needsGrouping) {\n      result += \"}\";\n    }\n    if (part.modifier !== 3) {\n      result += modifierToString(part.modifier);\n    }\n  }\n  return result;\n}\n__name(partsToPattern, \"partsToPattern\");\nvar URLPattern = /* @__PURE__ */ __name(class {\n  constructor(init = {}, baseURLOrOptions, options) {\n    this.regexp = {};\n    this.names = {};\n    this.component_pattern = {};\n    this.parts = {};\n    try {\n      let baseURL = void 0;\n      if (typeof baseURLOrOptions === \"string\") {\n        baseURL = baseURLOrOptions;\n      } else {\n        options = baseURLOrOptions;\n      }\n      if (typeof init === \"string\") {\n        const parser = new Parser(init);\n        parser.parse();\n        init = parser.result;\n        if (baseURL === void 0 && typeof init.protocol !== \"string\") {\n          throw new TypeError(`A base URL must be provided for a relative constructor string.`);\n        }\n        init.baseURL = baseURL;\n      } else {\n        if (!init || typeof init !== \"object\") {\n          throw new TypeError(`parameter 1 is not of type 'string' and cannot convert to dictionary.`);\n        }\n        if (baseURL) {\n          throw new TypeError(`parameter 1 is not of type 'string'.`);\n        }\n      }\n      if (typeof options === \"undefined\") {\n        options = { ignoreCase: false };\n      }\n      const ignoreCaseOptions = { ignoreCase: options.ignoreCase === true };\n      const defaults = {\n        pathname: DEFAULT_PATTERN,\n        protocol: DEFAULT_PATTERN,\n        username: DEFAULT_PATTERN,\n        password: DEFAULT_PATTERN,\n        hostname: DEFAULT_PATTERN,\n        port: DEFAULT_PATTERN,\n        search: DEFAULT_PATTERN,\n        hash: DEFAULT_PATTERN\n      };\n      this.pattern = applyInit(defaults, init, true);\n      if (defaultPortForProtocol(this.pattern.protocol) === this.pattern.port) {\n        this.pattern.port = \"\";\n      }\n      let component;\n      for (component of COMPONENTS) {\n        if (!(component in this.pattern))\n          continue;\n        const options2 = {};\n        const pattern = this.pattern[component];\n        this.names[component] = [];\n        switch (component) {\n          case \"protocol\":\n            Object.assign(options2, DEFAULT_OPTIONS);\n            options2.encodePart = protocolEncodeCallback;\n            break;\n          case \"username\":\n            Object.assign(options2, DEFAULT_OPTIONS);\n            options2.encodePart = usernameEncodeCallback;\n            break;\n          case \"password\":\n            Object.assign(options2, DEFAULT_OPTIONS);\n            options2.encodePart = passwordEncodeCallback;\n            break;\n          case \"hostname\":\n            Object.assign(options2, HOSTNAME_OPTIONS);\n            if (treatAsIPv6Hostname(pattern)) {\n              options2.encodePart = ipv6HostnameEncodeCallback;\n            } else {\n              options2.encodePart = hostnameEncodeCallback;\n            }\n            break;\n          case \"port\":\n            Object.assign(options2, DEFAULT_OPTIONS);\n            options2.encodePart = portEncodeCallback;\n            break;\n          case \"pathname\":\n            if (isSpecialScheme(this.regexp.protocol)) {\n              Object.assign(options2, PATHNAME_OPTIONS, ignoreCaseOptions);\n              options2.encodePart = standardURLPathnameEncodeCallback;\n            } else {\n              Object.assign(options2, DEFAULT_OPTIONS, ignoreCaseOptions);\n              options2.encodePart = pathURLPathnameEncodeCallback;\n            }\n            break;\n          case \"search\":\n            Object.assign(options2, DEFAULT_OPTIONS, ignoreCaseOptions);\n            options2.encodePart = searchEncodeCallback;\n            break;\n          case \"hash\":\n            Object.assign(options2, DEFAULT_OPTIONS, ignoreCaseOptions);\n            options2.encodePart = hashEncodeCallback;\n            break;\n        }\n        try {\n          this.parts[component] = parse(pattern, options2);\n          this.regexp[component] = partsToRegexp(\n            this.parts[component],\n            /* out */\n            this.names[component],\n            options2\n          );\n          this.component_pattern[component] = partsToPattern(this.parts[component], options2);\n        } catch (err) {\n          throw new TypeError(`invalid ${component} pattern '${this.pattern[component]}'.`);\n        }\n      }\n    } catch (err) {\n      throw new TypeError(`Failed to construct 'URLPattern': ${err.message}`);\n    }\n  }\n  test(input = {}, baseURL) {\n    let values = {\n      pathname: \"\",\n      protocol: \"\",\n      username: \"\",\n      password: \"\",\n      hostname: \"\",\n      port: \"\",\n      search: \"\",\n      hash: \"\"\n    };\n    if (typeof input !== \"string\" && baseURL) {\n      throw new TypeError(`parameter 1 is not of type 'string'.`);\n    }\n    if (typeof input === \"undefined\") {\n      return false;\n    }\n    try {\n      if (typeof input === \"object\") {\n        values = applyInit(values, input, false);\n      } else {\n        values = applyInit(values, extractValues(input, baseURL), false);\n      }\n    } catch (err) {\n      return false;\n    }\n    let component;\n    for (component of COMPONENTS) {\n      if (!this.regexp[component].exec(values[component])) {\n        return false;\n      }\n    }\n    return true;\n  }\n  exec(input = {}, baseURL) {\n    let values = {\n      pathname: \"\",\n      protocol: \"\",\n      username: \"\",\n      password: \"\",\n      hostname: \"\",\n      port: \"\",\n      search: \"\",\n      hash: \"\"\n    };\n    if (typeof input !== \"string\" && baseURL) {\n      throw new TypeError(`parameter 1 is not of type 'string'.`);\n    }\n    if (typeof input === \"undefined\") {\n      return;\n    }\n    try {\n      if (typeof input === \"object\") {\n        values = applyInit(values, input, false);\n      } else {\n        values = applyInit(values, extractValues(input, baseURL), false);\n      }\n    } catch (err) {\n      return null;\n    }\n    let result = {};\n    if (baseURL) {\n      result.inputs = [input, baseURL];\n    } else {\n      result.inputs = [input];\n    }\n    let component;\n    for (component of COMPONENTS) {\n      let match = this.regexp[component].exec(values[component]);\n      if (!match) {\n        return null;\n      }\n      let groups = {};\n      for (let [i, name] of this.names[component].entries()) {\n        if (typeof name === \"string\" || typeof name === \"number\") {\n          let value = match[i + 1];\n          groups[name] = value;\n        }\n      }\n      result[component] = {\n        input: values[component] ?? \"\",\n        groups\n      };\n    }\n    return result;\n  }\n  static compareComponent(component, left, right) {\n    const comparePart = /* @__PURE__ */ __name((left2, right2) => {\n      for (let attr of [\"type\", \"modifier\", \"prefix\", \"value\", \"suffix\"]) {\n        if (left2[attr] < right2[attr])\n          return -1;\n        else if (left2[attr] === right2[attr])\n          continue;\n        else\n          return 1;\n      }\n      return 0;\n    }, \"comparePart\");\n    const emptyFixedPart = new Part(\n      3,\n      \"\",\n      \"\",\n      \"\",\n      \"\",\n      3\n      /* kNone */\n    );\n    const wildcardOnlyPart = new Part(\n      0,\n      \"\",\n      \"\",\n      \"\",\n      \"\",\n      3\n      /* kNone */\n    );\n    const comparePartList = /* @__PURE__ */ __name((left2, right2) => {\n      let i = 0;\n      for (; i < Math.min(left2.length, right2.length); ++i) {\n        let result = comparePart(left2[i], right2[i]);\n        if (result)\n          return result;\n      }\n      if (left2.length === right2.length) {\n        return 0;\n      }\n      return comparePart(left2[i] ?? emptyFixedPart, right2[i] ?? emptyFixedPart);\n    }, \"comparePartList\");\n    if (!left.component_pattern[component] && !right.component_pattern[component]) {\n      return 0;\n    }\n    if (left.component_pattern[component] && !right.component_pattern[component]) {\n      return comparePartList(left.parts[component], [wildcardOnlyPart]);\n    }\n    if (!left.component_pattern[component] && right.component_pattern[component]) {\n      return comparePartList([wildcardOnlyPart], right.parts[component]);\n    }\n    return comparePartList(left.parts[component], right.parts[component]);\n  }\n  get protocol() {\n    return this.component_pattern.protocol;\n  }\n  get username() {\n    return this.component_pattern.username;\n  }\n  get password() {\n    return this.component_pattern.password;\n  }\n  get hostname() {\n    return this.component_pattern.hostname;\n  }\n  get port() {\n    return this.component_pattern.port;\n  }\n  get pathname() {\n    return this.component_pattern.pathname;\n  }\n  get search() {\n    return this.component_pattern.search;\n  }\n  get hash() {\n    return this.component_pattern.hash;\n  }\n}, \"URLPattern\");\n\n// ../../node_modules/.pnpm/urlpattern-polyfill@8.0.2/node_modules/urlpattern-polyfill/index.js\nif (!globalThis.URLPattern) {\n  globalThis.URLPattern = URLPattern;\n}\n// Annotate the CommonJS export names for ESM import in node:\n0 && (module.exports = {\n  URLPattern\n});\n"