/// <reference types="node" />
import type { NextConfigComplete } from '../server/config-shared';
import type { AppBuildManifest } from './webpack/plugins/app-build-manifest-plugin';
import type { GetStaticPaths, ServerRuntime } from 'next/types';
import type { BuildManifest } from '../server/get-page-files';
import type { CustomRoutes } from '../lib/load-custom-routes';
import type { UnwrapPromise } from '../lib/coalesced-function';
import type { MiddlewareManifest } from './webpack/plugins/middleware-plugin';
import '../server/require-hook';
import '../server/node-polyfill-fetch';
import '../server/node-polyfill-crypto';
import '../server/node-environment';
import { IncrementalCache } from '../server/lib/incremental-cache';
import { patchFetch } from '../server/lib/patch-fetch';
export type ROUTER_TYPE = 'pages' | 'app';
export declare function unique<T>(main: ReadonlyArray<T>, sub: ReadonlyArray<T>): T[];
export declare function difference<T>(main: ReadonlyArray<T> | ReadonlySet<T>, sub: ReadonlyArray<T> | ReadonlySet<T>): T[];
type ComputeFilesGroup = {
    files: ReadonlyArray<string>;
    size: {
        total: number;
    };
};
type ComputeFilesManifest = {
    unique: ComputeFilesGroup;
    common: ComputeFilesGroup;
};
type ComputeFilesManifestResult = {
    router: {
        pages: ComputeFilesManifest;
        app?: ComputeFilesManifest;
    };
    sizes: Map<string, number>;
};
export declare function computeFromManifest(manifests: {
    build: BuildManifest;
    app?: AppBuildManifest;
}, distPath: string, gzipSize?: boolean, pageInfos?: Map<string, PageInfo>): Promise<ComputeFilesManifestResult>;
export declare function isMiddlewareFilename(file?: string): boolean;
export declare function isInstrumentationHookFilename(file?: string): boolean;
export interface PageInfo {
    isHybridAmp?: boolean;
    size: number;
    totalSize: number;
    static: boolean;
    isSsg: boolean;
    ssgPageRoutes: string[] | null;
    initialRevalidateSeconds: number | false;
    pageDuration: number | undefined;
    ssgPageDurations: number[] | undefined;
    runtime: ServerRuntime;
}
export declare function printTreeView(lists: {
    pages: ReadonlyArray<string>;
    app?: ReadonlyArray<string>;
}, pageInfos: Map<string, PageInfo>, { distPath, buildId, pagesDir, pageExtensions, buildManifest, appBuildManifest, middlewareManifest, useStatic404, gzipSize, }: {
    distPath: string;
    buildId: string;
    pagesDir?: string;
    pageExtensions: string[];
    buildManifest: BuildManifest;
    appBuildManifest?: AppBuildManifest;
    middlewareManifest: MiddlewareManifest;
    useStatic404: boolean;
    gzipSize?: boolean;
}): Promise<void>;
export declare function printCustomRoutes({ redirects, rewrites, headers, }: CustomRoutes): void;
export declare function getJsPageSizeInKb(routerType: ROUTER_TYPE, page: string, distPath: string, buildManifest: BuildManifest, appBuildManifest?: AppBuildManifest, gzipSize?: boolean, cachedStats?: ComputeFilesManifestResult): Promise<[number, number]>;
export declare function buildStaticPaths({ page, getStaticPaths, staticPathsResult, configFileName, locales, defaultLocale, appDir, }: {
    page: string;
    getStaticPaths?: GetStaticPaths;
    staticPathsResult?: UnwrapPromise<ReturnType<GetStaticPaths>>;
    configFileName: string;
    locales?: string[];
    defaultLocale?: string;
    appDir?: boolean;
}): Promise<Omit<UnwrapPromise<ReturnType<GetStaticPaths>>, 'paths'> & {
    paths: string[];
    encodedPaths: string[];
}>;
export type AppConfig = {
    revalidate?: number | false;
    dynamicParams?: true | false;
    dynamic?: 'auto' | 'error' | 'force-static' | 'force-dynamic';
    fetchCache?: 'force-cache' | 'only-cache';
    preferredRegion?: string;
};
export type GenerateParams = Array<{
    config?: AppConfig;
    isDynamicSegment?: boolean;
    segmentPath: string;
    getStaticPaths?: GetStaticPaths;
    generateStaticParams?: any;
    isLayout?: boolean;
}>;
export declare const collectAppConfig: (mod: any) => AppConfig | undefined;
export declare const collectGenerateParams: (segment: any, parentSegments?: string[], generateParams?: GenerateParams) => Promise<GenerateParams>;
export declare function buildAppStaticPaths({ page, distDir, configFileName, generateParams, isrFlushToDisk, incrementalCacheHandlerPath, requestHeaders, maxMemoryCacheSize, fetchCacheKeyPrefix, staticGenerationAsyncStorage, serverHooks, }: {
    page: string;
    configFileName: string;
    generateParams: GenerateParams;
    incrementalCacheHandlerPath?: string;
    distDir: string;
    isrFlushToDisk?: boolean;
    fetchCacheKeyPrefix?: string;
    maxMemoryCacheSize?: number;
    requestHeaders: IncrementalCache['requestHeaders'];
    staticGenerationAsyncStorage: Parameters<typeof patchFetch>[0]['staticGenerationAsyncStorage'];
    serverHooks: Parameters<typeof patchFetch>[0]['serverHooks'];
}): Promise<(Omit<import("next/types").GetStaticPathsResult<import("querystring").ParsedUrlQuery>, "paths"> & {
    paths: string[];
    encodedPaths: string[];
}) | {
    paths: undefined;
    fallback: boolean | undefined;
    encodedPaths: undefined;
}>;
export declare function isPageStatic({ page, distDir, configFileName, runtimeEnvConfig, httpAgentOptions, locales, defaultLocale, parentId, pageRuntime, edgeInfo, pageType, originalAppPath, isrFlushToDisk, maxMemoryCacheSize, incrementalCacheHandlerPath, }: {
    page: string;
    distDir: string;
    configFileName: string;
    runtimeEnvConfig: any;
    httpAgentOptions: NextConfigComplete['httpAgentOptions'];
    locales?: string[];
    defaultLocale?: string;
    parentId?: any;
    edgeInfo?: any;
    pageType?: 'pages' | 'app';
    pageRuntime?: ServerRuntime;
    originalAppPath?: string;
    isrFlushToDisk?: boolean;
    maxMemoryCacheSize?: number;
    incrementalCacheHandlerPath?: string;
    nextConfigOutput: 'standalone' | 'export';
}): Promise<{
    isStatic?: boolean;
    isAmpOnly?: boolean;
    isHybridAmp?: boolean;
    hasServerProps?: boolean;
    hasStaticProps?: boolean;
    prerenderRoutes?: string[];
    encodedPrerenderRoutes?: string[];
    prerenderFallback?: boolean | 'blocking';
    isNextImageImported?: boolean;
    traceIncludes?: string[];
    traceExcludes?: string[];
    appConfig?: AppConfig;
}>;
export declare function hasCustomGetInitialProps(page: string, distDir: string, runtimeEnvConfig: any, checkingApp: boolean): Promise<boolean>;
export declare function getDefinedNamedExports(page: string, distDir: string, runtimeEnvConfig: any): Promise<ReadonlyArray<string>>;
export declare function detectConflictingPaths(combinedPages: string[], ssgPages: Set<string>, additionalSsgPaths: Map<string, string[]>): void;
export declare function copyTracedFiles(dir: string, distDir: string, pageKeys: readonly string[], appPageKeys: readonly string[] | undefined, tracingRoot: string, serverConfig: {
    [key: string]: any;
}, middlewareManifest: MiddlewareManifest, hasInstrumentationHook: boolean): Promise<void>;
export declare function isReservedPage(page: string): boolean;
export declare function isCustomErrorPage(page: string): boolean;
export declare function isMiddlewareFile(file: string): boolean;
export declare function isInstrumentationHookFile(file: string): boolean;
export declare function getPossibleInstrumentationHookFilenames(folder: string, extensions: string[]): string[];
export declare function getPossibleMiddlewareFilenames(folder: string, extensions: string[]): string[];
export declare class NestedMiddlewareError extends Error {
    constructor(nestedFileNames: string[], mainDir: string, pagesOrAppDir: string);
}
export declare function getSupportedBrowsers(dir: string, isDevelopment: boolean, config: NextConfigComplete): string[] | undefined;
export {};
