module.exports = "\"use strict\";\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __name = (target, value) => __defProp(target, \"name\", { value, configurable: true });\nvar __export = (target, all) => {\n  for (var name in all)\n    __defProp(target, name, { get: all[name], enumerable: true });\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toCommonJS = (mod) => __copyProps(__defProp({}, \"__esModule\", { value: true }), mod);\n\n// src/primitives/text-encoding-streams.js\nvar text_encoding_streams_exports = {};\n__export(text_encoding_streams_exports, {\n  TextDecoderStream: () => TextDecoderStream,\n  TextEncoderStream: () => TextEncoderStream\n});\nmodule.exports = __toCommonJS(text_encoding_streams_exports);\n\n// ../../node_modules/.pnpm/@stardazed+streams-text-encoding@1.0.2/node_modules/@stardazed/streams-text-encoding/dist/sd-streams-text-encoding.esm.js\nvar decDecoder = Symbol(\"decDecoder\");\nvar decTransform = Symbol(\"decTransform\");\nvar TextDecodeTransformer = class {\n  constructor(decoder) {\n    this.decoder_ = decoder;\n  }\n  transform(chunk, controller) {\n    if (!(chunk instanceof ArrayBuffer || ArrayBuffer.isView(chunk))) {\n      throw new TypeError(\"Input data must be a BufferSource\");\n    }\n    const text = this.decoder_.decode(chunk, { stream: true });\n    if (text.length !== 0) {\n      controller.enqueue(text);\n    }\n  }\n  flush(controller) {\n    const text = this.decoder_.decode();\n    if (text.length !== 0) {\n      controller.enqueue(text);\n    }\n  }\n};\n__name(TextDecodeTransformer, \"TextDecodeTransformer\");\nvar TextDecoderStream = class {\n  constructor(label, options) {\n    this[decDecoder] = new TextDecoder(label, options);\n    this[decTransform] = new TransformStream(new TextDecodeTransformer(this[decDecoder]));\n  }\n  get encoding() {\n    return this[decDecoder].encoding;\n  }\n  get fatal() {\n    return this[decDecoder].fatal;\n  }\n  get ignoreBOM() {\n    return this[decDecoder].ignoreBOM;\n  }\n  get readable() {\n    return this[decTransform].readable;\n  }\n  get writable() {\n    return this[decTransform].writable;\n  }\n};\n__name(TextDecoderStream, \"TextDecoderStream\");\nvar encEncoder = Symbol(\"encEncoder\");\nvar encTransform = Symbol(\"encTransform\");\nvar TextEncodeTransformer = class {\n  constructor(encoder) {\n    this.encoder_ = encoder;\n    this.partial_ = void 0;\n  }\n  transform(chunk, controller) {\n    let stringChunk = String(chunk);\n    if (this.partial_ !== void 0) {\n      stringChunk = this.partial_ + stringChunk;\n      this.partial_ = void 0;\n    }\n    const lastCharIndex = stringChunk.length - 1;\n    const lastCodeUnit = stringChunk.charCodeAt(lastCharIndex);\n    if (lastCodeUnit >= 55296 && lastCodeUnit < 56320) {\n      this.partial_ = String.fromCharCode(lastCodeUnit);\n      stringChunk = stringChunk.substring(0, lastCharIndex);\n    }\n    const bytes = this.encoder_.encode(stringChunk);\n    if (bytes.length !== 0) {\n      controller.enqueue(bytes);\n    }\n  }\n  flush(controller) {\n    if (this.partial_) {\n      controller.enqueue(this.encoder_.encode(this.partial_));\n      this.partial_ = void 0;\n    }\n  }\n};\n__name(TextEncodeTransformer, \"TextEncodeTransformer\");\nvar TextEncoderStream = class {\n  constructor() {\n    this[encEncoder] = new TextEncoder();\n    this[encTransform] = new TransformStream(new TextEncodeTransformer(this[encEncoder]));\n  }\n  get encoding() {\n    return this[encEncoder].encoding;\n  }\n  get readable() {\n    return this[encTransform].readable;\n  }\n  get writable() {\n    return this[encTransform].writable;\n  }\n};\n__name(TextEncoderStream, \"TextEncoderStream\");\n// Annotate the CommonJS export names for ESM import in node:\n0 && (module.exports = {\n  TextDecoderStream,\n  TextEncoderStream\n});\n"