import type { IncomingMessage, ServerResponse } from 'http';
import { StackFrame } from 'next/dist/compiled/stacktrace-parser';
import type { NextConfig } from '../config';
export type MiddlewareConfig = {
    matcher: string[];
    files: string[];
};
export type ServerAddress = {
    hostname?: string | null;
    port?: number | null;
};
export type RouteResult = {
    type: 'rewrite';
    url: string;
    statusCode: number;
    headers: Record<string, undefined | number | string | string[]>;
} | {
    type: 'error';
    error: {
        name: string;
        message: string;
        stack: StackFrame[];
    };
} | {
    type: 'none';
};
export declare function makeResolver(dir: string, nextConfig: NextConfig, middleware: MiddlewareConfig, serverAddr: Partial<ServerAddress>): Promise<(_req: IncomingMessage, _res: ServerResponse) => Promise<RouteResult | void>>;
