import React from 'react';
type ComponentModule<P = {}> = {
    default: React.ComponentType<P>;
};
export declare type LoaderComponent<P = {}> = Promise<React.ComponentType<P> | ComponentModule<P>>;
export declare type Loader<P = {}> = () => LoaderComponent<P>;
export type LoaderMap = {
    [module: string]: () => Loader<any>;
};
export type LoadableGeneratedOptions = {
    webpack?(): any;
    modules?(): LoaderMap;
};
export type DynamicOptionsLoadingProps = {
    error?: Error | null;
    isLoading?: boolean;
    pastDelay?: boolean;
    retry?: () => void;
    timedOut?: boolean;
};
export type DynamicOptions<P = {}> = LoadableGeneratedOptions & {
    loading?: (loadingProps: DynamicOptionsLoadingProps) => JSX.Element | null;
    loader?: Loader<P>;
    loadableGenerated?: LoadableGeneratedOptions;
    ssr?: boolean;
};
export type LoadableOptions<P = {}> = DynamicOptions<P>;
export type LoadableFn<P = {}> = (opts: LoadableOptions<P>) => React.ComponentType<P>;
export type LoadableComponent<P = {}> = React.ComponentType<P>;
export default function dynamic<P = {}>(dynamicOptions: DynamicOptions<P> | Loader<P>, options?: DynamicOptions<P>): React.ComponentType<P>;
export {};
