/** wrapper func for setState that returns a promise */

import type { RNIUtilitiesModule } from "../native_modules/RNIUtilitiesModule";

export class Helpers {

  // eslint-disable-next-line consistent-this
  static async setStateAsync<T extends {}>(
    that: React.Component,
    newState: T | ((prevState: T) => T)
  ){
    return new Promise<void>((resolve) => {
      that.setState(newState, () => {
        resolve();
      });
    });
  };

  /** wrapper for timeout that returns a promise */
  static async timeout(ms: number) {
    return new Promise<void>(resolve => {
      const timeoutID = setTimeout(() => {
        clearTimeout(timeoutID);
        resolve();
      }, ms);
    });
  };

  /** Wraps a promise that will reject if not not resolved in <ms> milliseconds */
  static async promiseWithTimeout<T>(ms: number, promise: Promise<T>){
    // Create a promise that rejects in <ms> milliseconds
    const timeoutPromise = new Promise<T>((_, reject) => {
      const timeoutID = setTimeout(() => {
        clearTimeout(timeoutID);
        reject(`Promise timed out in ${ms} ms.`)
      }, ms);
    });

    // Returns a race between our timeout and the passed in promise
    return Promise.race([promise, timeoutPromise]);
  };

  static pad(num: number | string, places = 2){
    return String(num).padStart(places, '0');
  };

  static getRNIUtilitiesModule(): typeof RNIUtilitiesModule{
    // @ts-ignore
    return global.RNIUtilitiesModule;
  };
};