"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAndroidMenu = void 0;

var _react = _interopRequireWildcard(require("react"));

var _menu = require("@react-native-menu/menu");

var _children = require("../children");

var _displayNames = require("../display-names");

var _filterNull = require("../filter-null");

var _reactNative = require("react-native");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const createAndroidMenu = Menu => {
  const Trigger = (0, _displayNames.create)(_ref => {
    let {
      children,
      style,
      asChild,
      ...props
    } = _ref;

    if (asChild) {
      return /*#__PURE__*/(0, _react.cloneElement)(children, {
        style,
        ...props
      });
    }

    return /*#__PURE__*/_react.default.createElement(_reactNative.View, {
      style: style
    }, children);
  }, 'Trigger');
  const Auxiliary = (0, _displayNames.create)(_ref2 => {
    let {} = _ref2;
    return null;
  }, 'Auxiliary');
  const Group = (0, _displayNames.create)(_ref3 => {
    let {
      children
    } = _ref3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Group');
  const Content = (0, _displayNames.create)(_ref4 => {
    let {
      children
    } = _ref4;

    if (!children) {
      console.error(`[zeego] <Content /> children must be written directly inline.

You cannot wrap this component into its own component. It should look like this:

<Root>
  <Content>
    <Item />
    <Item />
  </Content>
</Root>

Notice that the <Item /> are all children of the <Content /> component. That's important.

If you want to use a custom component as your <Content />, you can use the create() method. But you still need to pass all items as children of <Content />.`);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Content');
  const ItemTitle = (0, _displayNames.create)(_ref5 => {
    let {
      children
    } = _ref5;

    if (typeof children != 'string') {
      throw new Error('[zeego] <ItemTitle /> child must be a string');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'ItemTitle');
  const ItemIcon = (0, _displayNames.create)(props => {
    if (!props.androidIconName) {
      console.warn('[zeego] <ItemIcon /> missing androidIconName prop. Will do nothing on android. Consider passing an androidIconName or switching to <ItemImage />.');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'ItemIcon');
  const ItemImage = (0, _displayNames.create)(_ => {
    return null;
  }, 'ItemImage');
  const ItemSubtitle = (0, _displayNames.create)(_ref6 => {
    let {
      children
    } = _ref6;

    if (children && typeof children != 'string') {
      throw new Error('[zeego] <ItemSubtitle /> child must be a string');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'ItemSubtitle');
  const Item = (0, _displayNames.create)(_ref7 => {
    let {
      children
    } = _ref7;
    const titleChild = (0, _children.pickChildren)(children, ItemTitle).targetChildren;

    if (typeof children != 'string' && !(titleChild !== null && titleChild !== void 0 && titleChild.length)) {
      console.error(`[zeego] Invalid <Item />. It either needs <ItemTitle /> in the children.

<Item>
  <ItemTitle>
    Title here
  </ItemTitle>
</Item>
  `);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Item');
  const SubTrigger = (0, _displayNames.create)(_ref8 => {
    let {
      children
    } = _ref8;
    const titleChild = (0, _children.pickChildren)(children, ItemTitle).targetChildren;

    if (typeof children != 'string' && !(titleChild !== null && titleChild !== void 0 && titleChild.length)) {
      console.error(`[zeego] Invalid <SubTrigger />. It either needs an <ItemTitle /> in the children.

<SubTrigger>
  <ItemTitle>
    Title here
  </ItemTitle>
</SubTrigger>
  `);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'SubTrigger');
  const Sub = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'Sub');
  const SubContent = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'SubContent');
  const CheckboxItem = (0, _displayNames.create)(_ref9 => {
    let {} = _ref9;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'CheckboxItem');
  const Label = (0, _displayNames.create)(_ref10 => {
    let {
      children
    } = _ref10;

    if (typeof children != 'string') {
      console.error('[zeego] <Label /> children must be a string.');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Label');
  const Root = (0, _displayNames.create)(props => {
    var _pickChildren$targetC, _pickChildren$targetC5, _pickChildren$targetC6, _trigger$targetChildr;

    const trigger = (0, _children.pickChildren)(props.children, Trigger);
    const content = (_pickChildren$targetC = (0, _children.pickChildren)(props.children, Content).targetChildren) === null || _pickChildren$targetC === void 0 ? void 0 : _pickChildren$targetC[0];
    const callbacks = {};

    const getItemFromChild = (child, index) => {
      let title;
      const key = child.key ? `${child.key}` : `item-${index}`;
      let subtitle;
      const menuAttributes = {};

      if (child.props.disabled) {
        menuAttributes.disabled = true;
      }

      if (child.props.destructive) {
        menuAttributes.destructive = true;
      }

      if (child.props.hidden) {
        menuAttributes.hidden = true;
      }

      let icon;

      if (typeof child.props.children == 'string') {
        title = child.props.children;
      } else {
        var _child$props$textValu, _titleChild$, _subtitleChild$, _iconChildren$;

        const titleChild = (0, _children.pickChildren)(child.props.children, ItemTitle).targetChildren;
        let maybeTitle = (_child$props$textValu = child.props.textValue) !== null && _child$props$textValu !== void 0 ? _child$props$textValu : titleChild === null || titleChild === void 0 ? void 0 : (_titleChild$ = titleChild[0]) === null || _titleChild$ === void 0 ? void 0 : _titleChild$.props.children;

        if (Array.isArray(maybeTitle)) {
          /**
           * Use case: <ItemTitle>Here is some {text}</ItemTitle>
           * React will turn that into ['Here is some ', text] as an array
           * So we need to 1) detect that it's all strings and 2) join them together
           */
          let stringTitle = '';
          let isString = false;

          for (let i = 0; i < maybeTitle.length; i++) {
            const text = maybeTitle[i];

            if (text == null) {
              continue;
            }

            if (typeof text == 'string' || typeof text == 'number') {
              stringTitle += text;
              isString = true;
            } else {
              isString = false;
              break;
            }
          }

          if (isString) {
            maybeTitle = stringTitle;
          }
        }

        if (typeof maybeTitle === 'string') {
          title = maybeTitle;
        } else {
          console.error(`[zeego] Invalid <${Menu}.Item key="${key}" /> Missing valid title. Make sure you do one of the following:
  
  1. pass a string as the child of <${Menu}.ItemTitle />, nested directly inside of <${Menu}.Item />.
  2. OR, use the textValue prop on <${Menu}.Item textValue="Some value" />`);
        }

        const subtitleChild = (0, _children.pickChildren)(child.props.children, ItemSubtitle).targetChildren;

        if (typeof (subtitleChild === null || subtitleChild === void 0 ? void 0 : (_subtitleChild$ = subtitleChild[0]) === null || _subtitleChild$ === void 0 ? void 0 : _subtitleChild$.props.children) == 'string') {
          subtitle = subtitleChild[0].props.children;
        }

        const iconChildren = (0, _children.pickChildren)(child.props.children, ItemIcon).targetChildren;

        if (iconChildren !== null && iconChildren !== void 0 && (_iconChildren$ = iconChildren[0]) !== null && _iconChildren$ !== void 0 && _iconChildren$.props.androidIconName) {
          icon = iconChildren[0].props.androidIconName;
        }
      }

      if (title) {
        const maybeIndexKey = typeof child.key == 'string' && child.key.startsWith('.') ? child.key.substring(1) : undefined;

        if ( // if the key doesn't exist as a string
        typeof child.key != 'string' || // or if flattenChildren assigned the key as `.${key}${index}`
        child.key.startsWith('.') && !isNaN(Number(maybeIndexKey))) {
          console.warn(`[zeego] <Item /> is missing a unique key. Pass a unique key string for each item, such as: <Item key="${title.toLowerCase().replace(/ /g, '-') || `action-${index}`}" />. Falling back to index (${key}) instead, but this may have negative consequences.`);
        }

        if ('onSelect' in child.props && child.props.onSelect) {
          callbacks[key] = child.props.onSelect;
        } else if ('onValueChange' in child.props) {
          const menuState = child.props.value;
          const currentState = menuState === true ? 'on' : menuState === false ? 'off' : menuState;
          const nextState = currentState === 'mixed' || currentState === 'on' ? 'off' : 'on';
          const {
            onValueChange
          } = child.props;

          callbacks[key] = () => {
            onValueChange === null || onValueChange === void 0 ? void 0 : onValueChange(nextState, currentState);
          };
        }

        return {
          key,
          title,
          subtitle,
          menuAttributes,
          icon
        };
      }

      return;
    };

    const mapItemsChildren = children => {
      return _react.Children.map((0, _children.flattenChildren)(children).map(item => {
        // android menu doesn't support group feature like iOS `displayInline` option in menu
        if ((0, _children.isInstanceOfComponent)(item, Group) && typeof item === 'object') {
          return (0, _children.flattenChildren)(item.props.children);
        }

        return item;
      }).flat(), (_child, index) => {
        if ((0, _children.isInstanceOfComponent)(_child, Item)) {
          const child = _child;
          const item = getItemFromChild(child, index);

          if (item) {
            const {
              icon,
              title,
              key,
              menuAttributes,
              subtitle
            } = item;
            const finalItem = {
              id: key,
              title,
              image: icon,
              attributes: menuAttributes,
              subtitle
            };
            return finalItem;
          }
        } else if ((0, _children.isInstanceOfComponent)(_child, CheckboxItem)) {
          const child = _child;
          const item = getItemFromChild(child, index);

          if (item) {
            var _pickChildren$targetC2;

            const {
              icon,
              title,
              key,
              menuAttributes,
              subtitle
            } = item;
            const menuState = child.props.value;
            const currentState = menuState === true ? 'on' : menuState === false ? 'off' : menuState;
            const hasItemIndicator = ((_pickChildren$targetC2 = (0, _children.pickChildren)(child.props.children, ItemIndicator).targetChildren) === null || _pickChildren$targetC2 === void 0 ? void 0 : _pickChildren$targetC2[0]) !== undefined;
            let image = icon;

            if (hasItemIndicator && !icon) {
              image = currentState === 'on' ? 'checkbox_on_background' : 'checkbox_off_background';
            }

            const finalItem = {
              id: key,
              title,
              image,
              attributes: menuAttributes,
              subtitle,
              state: currentState
            };
            return finalItem;
          }
        } else if ((0, _children.isInstanceOfComponent)(_child, Sub)) {
          var _pickChildren$targetC3;

          const child = _child;
          const key = child.key ? `${child.key}` : `sub-${index}`;
          const triggerItemChild = (_pickChildren$targetC3 = (0, _children.pickChildren)(child.props.children, SubTrigger).targetChildren) === null || _pickChildren$targetC3 === void 0 ? void 0 : _pickChildren$targetC3[0];
          const triggerItem = triggerItemChild && getItemFromChild(triggerItemChild, index);

          if (triggerItem) {
            var _pickChildren$targetC4;

            const nestedContent = (_pickChildren$targetC4 = (0, _children.pickChildren)(child.props.children, SubContent).targetChildren) === null || _pickChildren$targetC4 === void 0 ? void 0 : _pickChildren$targetC4[0];

            if (nestedContent) {
              const nestedItems = mapItemsChildren(nestedContent.props.children).filter(_filterNull.filterNull);

              if (nestedItems.length) {
                const menuConfig = {
                  id: key,
                  title: triggerItem === null || triggerItem === void 0 ? void 0 : triggerItem.title,
                  image: triggerItem === null || triggerItem === void 0 ? void 0 : triggerItem.icon,
                  subactions: nestedItems,
                  attributes: triggerItem.menuAttributes
                };
                return menuConfig;
              }
            }
          }
        }

        return null;
      });
    };

    const menuItems = mapItemsChildren(content === null || content === void 0 ? void 0 : content.props.children).filter(_filterNull.filterNull);
    const label = (_pickChildren$targetC5 = (0, _children.pickChildren)(content === null || content === void 0 ? void 0 : content.props.children, Label).targetChildren) === null || _pickChildren$targetC5 === void 0 ? void 0 : (_pickChildren$targetC6 = _pickChildren$targetC5[0]) === null || _pickChildren$targetC6 === void 0 ? void 0 : _pickChildren$targetC6.props.children;
    let menuTitle = '';

    if (typeof label == 'string') {
      menuTitle = label;
    }

    const triggerItem = (_trigger$targetChildr = trigger.targetChildren) === null || _trigger$targetChildr === void 0 ? void 0 : _trigger$targetChildr[0];
    let shouldOpenOnLongPress = Menu === 'ContextMenu';

    if (triggerItem !== null && triggerItem !== void 0 && triggerItem.props.action) {
      shouldOpenOnLongPress = triggerItem.props.action === 'longPress';
    }

    return /*#__PURE__*/_react.default.createElement(_menu.MenuView, {
      title: menuTitle,
      style: props.style,
      onPressAction: _ref11 => {
        var _callbacks$nativeEven;

        let {
          nativeEvent
        } = _ref11;
        (_callbacks$nativeEven = callbacks[nativeEvent.event]) === null || _callbacks$nativeEven === void 0 ? void 0 : _callbacks$nativeEven.call(callbacks);
      },
      shouldOpenOnLongPress: shouldOpenOnLongPress,
      actions: menuItems // @ts-ignore
      ,
      onOpenMenu: () => {
        var _props$onOpenChange;

        (_props$onOpenChange = props.onOpenChange) === null || _props$onOpenChange === void 0 ? void 0 : _props$onOpenChange.call(props, true);
      } // @ts-ignore
      ,
      onCloseMenu: () => {
        var _props$onOpenChange2;

        (_props$onOpenChange2 = props.onOpenChange) === null || _props$onOpenChange2 === void 0 ? void 0 : _props$onOpenChange2.call(props, false);
      }
    }, triggerItem);
  }, 'Root');
  const Separator = (0, _displayNames.create)(_ => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Separator');
  const ItemIndicator = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'ItemIndicator');
  const Preview = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'Preview');
  const Arrow = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'Arrow');
  return {
    Root,
    Trigger,
    Content,
    Item,
    ItemTitle,
    ItemSubtitle,
    SubTrigger,
    Group,
    Separator,
    ItemIcon,
    ItemIndicator,
    CheckboxItem,
    ItemImage,
    Label,
    Preview,
    Arrow,
    Sub,
    SubContent,
    Auxiliary
  };
};

exports.createAndroidMenu = createAndroidMenu;
//# sourceMappingURL=index.android.js.map