"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = exports.MenuDisplayName = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const MenuDisplayName = {
  Root: 'Root',
  Item: 'Item',
  Content: 'Content',
  Separator: 'Separator',
  Group: 'Group',
  ItemTitle: 'ItemTitle',
  ItemSubtitle: 'ItemSubtitle',
  ItemIcon: 'ItemIcon',
  ItemImage: 'ItemImage',
  Trigger: 'Trigger',
  SubTrigger: 'SubTrigger',
  Sub: 'Sub',
  SubContent: 'SubContent',
  CheckboxItem: 'CheckboxItem',
  Label: 'Label',
  ItemIndicator: 'ItemIndicator',
  Preview: 'Preview',
  Arrow: 'Arrow',
  Auxiliary: 'Auxiliary'
};
exports.MenuDisplayName = MenuDisplayName;

const create = (Component, displayName) => {
  const MenuComponent = props => {
    return /*#__PURE__*/_react.default.createElement(Component, props);
  };

  MenuComponent.displayName = displayName;
  return MenuComponent;
};

exports.create = create;
//# sourceMappingURL=display-names.js.map