"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIosMenu = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactNative = require("react-native");

var _reactNativeIosContextMenu = require("react-native-ios-context-menu");

var _children = require("../children");

var _displayNames = require("../display-names");

var _filterNull = require("../filter-null");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const createIosMenu = Menu => {
  const Trigger = (0, _displayNames.create)(_ref => {
    let {
      children,
      style,
      asChild,
      ...props
    } = _ref;

    if (asChild) {
      return /*#__PURE__*/(0, _react.cloneElement)(children, {
        style,
        ...props
      });
    }

    return /*#__PURE__*/_react.default.createElement(_reactNative.View, {
      style: style
    }, children);
  }, 'Trigger');
  const Auxiliary = (0, _displayNames.create)(_ref2 => {
    let {} = _ref2;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Auxiliary');
  const Group = (0, _displayNames.create)(_ref3 => {
    let {
      children
    } = _ref3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Group');
  const Content = (0, _displayNames.create)(_ref4 => {
    let {
      children
    } = _ref4;

    if (!children) {
      console.error(`[zeego] <Content /> children must be written directly inline.

You cannot wrap this component into its own component. It should look like this:

<Root>
  <Content>
    <Item />
    <Item />
  </Content>
</Root>

Notice that the <Item /> are all children of the <Content /> component. That's important.

If you want to use a custom component as your <Content />, you can use the create() method. But you still need to pass all items as children of <Content />.`);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Content');
  const ItemTitle = (0, _displayNames.create)(_ref5 => {
    let {
      children
    } = _ref5;

    if (typeof children != 'string') {
      throw new Error('[zeego] <ItemTitle /> child must be a string');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'ItemTitle');
  const ItemIcon = (0, _displayNames.create)(_ => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'ItemIcon');
  const ItemImage = (0, _displayNames.create)(_ => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'ItemImage');
  const ItemSubtitle = (0, _displayNames.create)(_ref6 => {
    let {
      children
    } = _ref6;

    if (children && typeof children != 'string') {
      throw new Error('[zeego] <ItemSubtitle /> child must be a string');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'ItemSubtitle');
  const Item = (0, _displayNames.create)(_ref7 => {
    let {
      children
    } = _ref7;
    const titleChild = (0, _children.pickChildren)(children, ItemTitle).targetChildren;

    if (typeof children != 'string' && !(titleChild !== null && titleChild !== void 0 && titleChild.length)) {
      console.error(`[zeego] Invalid <Item />. It either needs <ItemTitle /> in the children.

<Item>
  <ItemTitle>
    Title here
  </ItemTitle>
</Item>
  `);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'Item');
  const SubTrigger = (0, _displayNames.create)(_ref8 => {
    let {
      children
    } = _ref8;
    const titleChild = (0, _children.pickChildren)(children, ItemTitle).targetChildren;

    if (typeof children != 'string' && !(titleChild !== null && titleChild !== void 0 && titleChild.length)) {
      console.error(`[zeego] Invalid <SubTrigger />. It either needs a string as the children, or a <ItemTitle /> in the children. However, it got neither.


<SubTrigger>
  <ItemTitle>
    Title here
  </ItemTitle>
</SubTrigger>
  `);
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }, 'SubTrigger');
  const Sub = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'Sub');
  const SubContent = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'SubContent');
  const Preview = (0, _displayNames.create)(_ => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Preview');
  Preview.defaultProps = {
    isResizeAnimated: true
  };
  const CheckboxItem = (0, _displayNames.create)(_ref9 => {
    let {} = _ref9;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'CheckboxItem');
  const Label = (0, _displayNames.create)(_ref10 => {
    let {
      children
    } = _ref10;

    if (typeof children != 'string') {
      console.error('[zeego] <Label /> children must be a string.');
    }

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Label');
  const Root = (0, _displayNames.create)(props => {
    var _pickChildren$targetC, _pickChildren$targetC7, _pickChildren$targetC8, _pickChildren$targetC9, _trigger$targetChildr, _pickChildren, _auxiliary$;

    const trigger = (0, _children.pickChildren)(props.children, Trigger);
    const content = (_pickChildren$targetC = (0, _children.pickChildren)(props.children, Content).targetChildren) === null || _pickChildren$targetC === void 0 ? void 0 : _pickChildren$targetC[0];
    const callbacks = {};

    const getItemFromChild = (child, index) => {
      let title;
      const key = child.key ? `${child.key}` : `item-${index}`;
      let subtitle;
      const menuAttributes = [];

      if (child.props.disabled) {
        menuAttributes.push('disabled');
      }

      if (child.props.destructive) {
        menuAttributes.push('destructive');
      }

      if (child.props.hidden) {
        menuAttributes.push('hidden');
      }

      if (child.props.shouldDismissMenuOnSelect === false) {
        menuAttributes.push('keepsMenuPresented');
      }

      let icon;

      if (typeof child.props.children == 'string') {
        title = child.props.children;
      } else {
        var _child$props$textValu, _titleChild$, _subtitleChild$, _iconChildren$, _iconChildren$2;

        const titleChild = (0, _children.pickChildren)(child.props.children, ItemTitle).targetChildren;
        let maybeTitle = (_child$props$textValu = child.props.textValue) !== null && _child$props$textValu !== void 0 ? _child$props$textValu : titleChild === null || titleChild === void 0 ? void 0 : (_titleChild$ = titleChild[0]) === null || _titleChild$ === void 0 ? void 0 : _titleChild$.props.children;

        if (Array.isArray(maybeTitle)) {
          /**
           * Use case: <ItemTitle>Here is some {text}</ItemTitle>
           * React will turn that into ['Here is some ', text] as an array
           * So we need to 1) detect that it's all strings and 2) join them together
           */
          let stringTitle = '';
          let isString = false;

          for (let i = 0; i < maybeTitle.length; i++) {
            const text = maybeTitle[i];

            if (text == null) {
              continue;
            }

            if (typeof text == 'string' || typeof text == 'number') {
              stringTitle += text;
              isString = true;
            } else {
              isString = false;
              break;
            }
          }

          if (isString) {
            maybeTitle = stringTitle;
          }
        }

        if (typeof maybeTitle === 'string') {
          title = maybeTitle;
        } else {
          console.error(`[zeego] Invalid <${Menu}.Item key="${key}" /> Missing valid title. Make sure you do one of the following:

1. pass a string as the child of <${Menu}.ItemTitle />, nested directly inside of <${Menu}.Item />.
2. OR, use the textValue prop on <${Menu}.Item textValue="Some value" />
3. OR, if you are using a horizontal Group with icons only, pass an empty string: <${Menu}.ItemTitle textValue="" />`);
        }

        const subtitleChild = (0, _children.pickChildren)(child.props.children, ItemSubtitle).targetChildren;

        if (typeof (subtitleChild === null || subtitleChild === void 0 ? void 0 : (_subtitleChild$ = subtitleChild[0]) === null || _subtitleChild$ === void 0 ? void 0 : _subtitleChild$.props.children) == 'string') {
          subtitle = subtitleChild[0].props.children;
        }

        const iconChildren = (0, _children.pickChildren)(child.props.children, ItemIcon).targetChildren;

        if (iconChildren !== null && iconChildren !== void 0 && (_iconChildren$ = iconChildren[0]) !== null && _iconChildren$ !== void 0 && _iconChildren$.props.iosIconName || iconChildren !== null && iconChildren !== void 0 && (_iconChildren$2 = iconChildren[0]) !== null && _iconChildren$2 !== void 0 && _iconChildren$2.props.ios) {
          var _iconChildren$3, _iconConfiguration$na;

          const iconConfiguration = iconChildren === null || iconChildren === void 0 ? void 0 : (_iconChildren$3 = iconChildren[0]) === null || _iconChildren$3 === void 0 ? void 0 : _iconChildren$3.props.ios;
          icon = {
            type: 'IMAGE_SYSTEM',
            imageValue: { ...iconConfiguration,
              systemName: (_iconConfiguration$na = iconConfiguration === null || iconConfiguration === void 0 ? void 0 : iconConfiguration.name) !== null && _iconConfiguration$na !== void 0 ? _iconConfiguration$na : iconChildren[0].props.iosIconName
            }
          };
        } else {
          var _pickChildren$targetC2;

          const imageChild = (_pickChildren$targetC2 = (0, _children.pickChildren)(child.props.children, ItemImage).targetChildren) === null || _pickChildren$targetC2 === void 0 ? void 0 : _pickChildren$targetC2[0];

          if (imageChild) {
            if (imageChild.props.source) {
              const {
                source,
                ios: {
                  lazy = true,
                  style
                } = {}
              } = imageChild.props;

              if (typeof source === 'object' && 'uri' in source && source.uri) {
                icon = {
                  type: 'IMAGE_REMOTE_URL',
                  imageValue: {
                    url: source.uri
                  },
                  imageLoadingConfig: {
                    shouldLazyLoad: lazy !== null && lazy !== void 0 ? lazy : true
                  },
                  imageOptions: style
                };
              } else {
                const imageValue = _reactNative.Image.resolveAssetSource(typeof imageChild.props.source === 'object' && 'src' in imageChild.props.source ? {
                  uri: imageChild.props.source.src
                } : imageChild.props.source);

                icon = {
                  type: 'IMAGE_REQUIRE',
                  imageValue
                };
              }
            }
          }
        }
      }

      if (typeof title == 'string') {
        const maybeIndexKey = typeof child.key == 'string' && child.key.startsWith('.') ? child.key.substring(1) : undefined;

        if ( // if the key doesn't exist as a string
        typeof child.key != 'string' || // or if flattenChildren assigned the key as `.${key}${index}`
        child.key.startsWith('.') && !isNaN(Number(maybeIndexKey))) {
          console.warn(`[zeego] <Item /> is missing a unique key. Pass a unique key string for each item, such as: <Item key="${title.toLowerCase().replace(/ /g, '-') || `action-${index}`}" />. Falling back to index (${key}) instead, but this may have negative consequences.`);
        }

        if ('onSelect' in child.props && child.props.onSelect) {
          callbacks[key] = () => {
            var _child$props$onSelect, _child$props;

            return (_child$props$onSelect = (_child$props = child.props).onSelect) === null || _child$props$onSelect === void 0 ? void 0 : _child$props$onSelect.call(_child$props);
          };
        } else if ('onValueChange' in child.props) {
          const menuState = child.props.value;
          const currentState = menuState === true ? 'on' : menuState === false ? 'off' : menuState;
          const nextState = currentState === 'mixed' || currentState === 'on' ? 'off' : 'on';
          const {
            onValueChange
          } = child.props;

          callbacks[key] = () => {
            onValueChange === null || onValueChange === void 0 ? void 0 : onValueChange(nextState, currentState);
          };
        }

        return {
          key,
          title,
          subtitle,
          menuAttributes,
          icon
        };
      }

      return undefined;
    };

    const mapItemsChildren = children => {
      return _react.Children.map((0, _children.flattenChildren)(children), (child, index) => {
        if ((0, _children.isInstanceOfComponent)(child, Item)) {
          const item = getItemFromChild(child, index);

          if (item) {
            const {
              icon,
              title,
              key,
              menuAttributes,
              subtitle
            } = item;
            const finalItem = {
              actionKey: key,
              actionTitle: title,
              icon,
              menuAttributes,
              discoverabilityTitle: subtitle
            };
            return finalItem;
          }
        } else if ((0, _children.isInstanceOfComponent)(child, CheckboxItem)) {
          const item = getItemFromChild(child, index);

          if (item) {
            const {
              icon,
              title,
              key,
              menuAttributes,
              subtitle
            } = item;
            const menuState = child.props.value;
            const currentState = menuState === true ? 'on' : menuState === false ? 'off' : menuState;
            const finalItem = {
              actionKey: key,
              actionTitle: title,
              icon,
              menuAttributes,
              discoverabilityTitle: subtitle,
              menuState: currentState
            };
            return finalItem;
          }
        } else if ((0, _children.isInstanceOfComponent)(child, Sub)) {
          var _pickChildren$targetC3;

          const triggerItemChild = (_pickChildren$targetC3 = (0, _children.pickChildren)(child.props.children, SubTrigger).targetChildren) === null || _pickChildren$targetC3 === void 0 ? void 0 : _pickChildren$targetC3[0];
          const triggerItem = triggerItemChild && getItemFromChild(triggerItemChild, index);

          if (triggerItem) {
            var _pickChildren$targetC4;

            const nestedContent = (_pickChildren$targetC4 = (0, _children.pickChildren)(child.props.children, SubContent).targetChildren) === null || _pickChildren$targetC4 === void 0 ? void 0 : _pickChildren$targetC4[0];

            if (nestedContent) {
              const nestedItems = mapItemsChildren(nestedContent.props.children).filter(_filterNull.filterNull);

              if (nestedItems.length) {
                const menuOptions = [];

                if (new Set(triggerItem.menuAttributes || []).has('destructive')) {
                  menuOptions.push('destructive');
                }

                const menuConfig = {
                  menuTitle: triggerItem === null || triggerItem === void 0 ? void 0 : triggerItem.title,
                  icon: triggerItem === null || triggerItem === void 0 ? void 0 : triggerItem.icon,
                  menuItems: nestedItems,
                  menuOptions,
                  // @ts-expect-error
                  menuAttributes: triggerItem.menuAttributes
                };
                return menuConfig;
              }
            }
          }
        } else if ((0, _children.isInstanceOfComponent)(child, Group)) {
          var _pickChildren$targetC5, _pickChildren$targetC6;

          const groupItems = mapItemsChildren(child.props.children).filter(_filterNull.filterNull);
          const groupTitle = (_pickChildren$targetC5 = (0, _children.pickChildren)(child.props.children, Label).targetChildren) === null || _pickChildren$targetC5 === void 0 ? void 0 : (_pickChildren$targetC6 = _pickChildren$targetC5[0]) === null || _pickChildren$targetC6 === void 0 ? void 0 : _pickChildren$targetC6.props.children;
          let menuPreferredElementSize;

          if (child.props.horizontal) {
            const hasGroupItemWithText = groupItems.some(item => {
              return item.type === 'action' && item.actionTitle;
            });

            if (hasGroupItemWithText) {
              menuPreferredElementSize = 'medium';
            } else {
              menuPreferredElementSize = 'small';
            }
          }

          return {
            menuTitle: typeof groupTitle == 'string' ? groupTitle : '',
            menuItems: groupItems,
            menuOptions: ['displayInline'],
            menuPreferredElementSize
          };
        }

        return null;
      });
    };

    const menuItems = mapItemsChildren(content === null || content === void 0 ? void 0 : content.props.children).filter(_filterNull.filterNull);
    const label = (_pickChildren$targetC7 = (0, _children.pickChildren)(content === null || content === void 0 ? void 0 : content.props.children, Label).targetChildren) === null || _pickChildren$targetC7 === void 0 ? void 0 : (_pickChildren$targetC8 = _pickChildren$targetC7[0]) === null || _pickChildren$targetC8 === void 0 ? void 0 : _pickChildren$targetC8.props.children;
    let menuTitle = '';

    if (typeof label == 'string') {
      menuTitle = label;
    }

    const Component = Menu === 'ContextMenu' ? _reactNativeIosContextMenu.ContextMenuView : _reactNativeIosContextMenu.ContextMenuButton;
    const preview = (_pickChildren$targetC9 = (0, _children.pickChildren)(content === null || content === void 0 ? void 0 : content.props.children, Preview).targetChildren) === null || _pickChildren$targetC9 === void 0 ? void 0 : _pickChildren$targetC9[0];
    const previewProps = preview === null || preview === void 0 ? void 0 : preview.props;

    const onMenuDidHide = props.onOpenChange && (() => {
      var _props$onOpenChange;

      (_props$onOpenChange = props.onOpenChange) === null || _props$onOpenChange === void 0 ? void 0 : _props$onOpenChange.call(props, false);
    });

    const onMenuDidShow = props.onOpenChange && (() => {
      var _props$onOpenChange2;

      (_props$onOpenChange2 = props.onOpenChange) === null || _props$onOpenChange2 === void 0 ? void 0 : _props$onOpenChange2.call(props, true);
    });

    const onMenuWillShow = props.onOpenWillChange && (() => {
      var _props$onOpenWillChan;

      (_props$onOpenWillChan = props.onOpenWillChange) === null || _props$onOpenWillChan === void 0 ? void 0 : _props$onOpenWillChan.call(props, true);
    });

    const onMenuWillHide = props.onOpenWillChange && (() => {
      var _props$onOpenWillChan2;

      (_props$onOpenWillChan2 = props.onOpenWillChange) === null || _props$onOpenWillChan2 === void 0 ? void 0 : _props$onOpenWillChan2.call(props, false);
    });

    const triggerItem = (_trigger$targetChildr = trigger.targetChildren) === null || _trigger$targetChildr === void 0 ? void 0 : _trigger$targetChildr[0];
    let shouldOpenOnSingleTap = Menu === 'DropdownMenu';

    if (triggerItem !== null && triggerItem !== void 0 && triggerItem.props.action) {
      shouldOpenOnSingleTap = triggerItem.props.action === 'press';
    }

    const auxiliary = Menu === 'ContextMenu' ? (_pickChildren = (0, _children.pickChildren)(content === null || content === void 0 ? void 0 : content.props.children, Auxiliary)) === null || _pickChildren === void 0 ? void 0 : _pickChildren.targetChildren : undefined;
    const auxiliaryProps = auxiliary === null || auxiliary === void 0 ? void 0 : (_auxiliary$ = auxiliary[0]) === null || _auxiliary$ === void 0 ? void 0 : _auxiliary$.props;
    const menuRef = (0, _react.useRef)();
    return /*#__PURE__*/_react.default.createElement(Component, _extends({
      ref: menuRef,
      onPressMenuItem: _ref11 => {
        let {
          nativeEvent
        } = _ref11;

        if (callbacks[nativeEvent.actionKey]) {
          callbacks[nativeEvent.actionKey]();
        }
      },
      isMenuPrimaryAction: shouldOpenOnSingleTap,
      style: [{
        flexGrow: 0
      }, props.style],
      menuConfig: {
        menuTitle,
        menuItems
      },
      renderPreview: Menu === 'ContextMenu' && preview && previewProps !== null && previewProps !== void 0 && previewProps.children ? () => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof (previewProps === null || previewProps === void 0 ? void 0 : previewProps.children) == 'function' ? previewProps.children() : previewProps === null || previewProps === void 0 ? void 0 : previewProps.children);
      } : undefined,
      lazyPreview: Menu === 'ContextMenu' ? typeof (previewProps === null || previewProps === void 0 ? void 0 : previewProps.children) == 'function' : undefined,
      onPressMenuPreview: Menu === 'ContextMenu' ? previewProps === null || previewProps === void 0 ? void 0 : previewProps.onPress : undefined,
      shouldPreventLongPressGestureFromPropagating: true,
      auxiliaryPreviewConfig: auxiliaryProps !== null && auxiliaryProps !== void 0 && auxiliaryProps.children ? {
        alignmentHorizontal: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.alignmentHorizontal,
        anchorPosition: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.anchorPosition,
        height: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.height,
        marginAuxiliaryPreview: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.marginWithScreenEdge,
        marginPreview: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.marginPreview,
        transitionConfigEntrance: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.transitionConfigEntrance,
        transitionEntranceDelay: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.transitionEntranceDelay,
        width: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.width
      } : undefined,
      isAuxiliaryPreviewEnabled: !!(auxiliaryProps !== null && auxiliaryProps !== void 0 && auxiliaryProps.children),
      onMenuAuxiliaryPreviewDidShow: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.onDidShow,
      onMenuAuxiliaryPreviewWillShow: auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.onWillShow,
      renderAuxiliaryPreview: auxiliaryProps !== null && auxiliaryProps !== void 0 && auxiliaryProps.children ? () => {
        const child = typeof (auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.children) == 'function' ? auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.children({
          dismissMenu() {
            var _menuRef$current;

            (_menuRef$current = menuRef.current) === null || _menuRef$current === void 0 ? void 0 : _menuRef$current.dismissMenu();
          }

        }) : auxiliaryProps === null || auxiliaryProps === void 0 ? void 0 : auxiliaryProps.children;
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, child);
      } : undefined,
      previewConfig: preview ? {
        // ...previewProps,
        previewType: 'CUSTOM',
        previewSize: previewProps === null || previewProps === void 0 ? void 0 : previewProps.size,
        backgroundColor: previewProps === null || previewProps === void 0 ? void 0 : previewProps.backgroundColor,
        borderRadius: previewProps === null || previewProps === void 0 ? void 0 : previewProps.borderRadius,
        isResizeAnimated: previewProps === null || previewProps === void 0 ? void 0 : previewProps.isResizeAnimated,
        preferredCommitStyle: previewProps === null || previewProps === void 0 ? void 0 : previewProps.preferredCommitStyle
      } : undefined,
      onMenuDidHide: onMenuDidHide,
      onMenuDidShow: onMenuDidShow,
      onMenuWillHide: onMenuWillHide,
      onMenuWillShow: onMenuWillShow
    }, props.__unsafeIosProps), triggerItem);
  }, 'Root');
  const Separator = (0, _displayNames.create)(_ => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }, 'Separator');
  const ItemIndicator = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'ItemIndicator');
  const Arrow = (0, _displayNames.create)(_ => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), 'Arrow');
  return {
    Root,
    Trigger,
    Content,
    Item,
    ItemTitle,
    ItemSubtitle,
    SubTrigger,
    Group,
    Separator,
    ItemIcon,
    ItemIndicator,
    CheckboxItem,
    ItemImage,
    Label,
    Preview,
    Arrow,
    Sub,
    SubContent,
    Auxiliary
  };
};

exports.createIosMenu = createIosMenu;
//# sourceMappingURL=index.ios.js.map