import React from 'react';
import type { MenuContentProps, MenuItemIconProps, ContextMenuContentProps } from '../types';
declare const createAndroidMenu: (Menu: "ContextMenu" | "DropdownMenu") => {
    Root: React.FC<import("@radix-ui/react-dropdown-menu").DropdownMenuProps & {
        children: React.ReactNode;
        style?: React.CSSProperties;
        onOpenChange?: (isOpen: boolean) => void;
        onOpenWillChange?: (willOpen: boolean) => void;
        __unsafeIosProps?: React.ComponentProps<typeof import("react-native-ios-context-menu").ContextMenuView> | React.ComponentProps<typeof import("react-native-ios-context-menu").ContextMenuButton>;
    }>;
    Trigger: React.FC<import("@radix-ui/react-dropdown-menu").DropdownMenuTriggerProps & {
        children: React.ReactElement;
        style?: React.CSSProperties;
        asChild?: boolean;
        action?: "press" | "longPress";
    }>;
    Content: React.FC<MenuContentProps | ContextMenuContentProps>;
    Item: React.FC<Omit<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuItemProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild" | "disabled" | "textValue">, keyof {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    }> & {
        children: React.ReactNode;
        style?: React.CSSProperties;
        textValue?: string;
    } & {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    }>;
    ItemTitle: React.FC<Omit<React.DetailedHTMLProps<React.HTMLAttributes<HTMLSpanElement>, HTMLSpanElement>, "children"> & {
        children: string | React.ReactNode;
    }>;
    ItemSubtitle: React.FC<Omit<React.DetailedHTMLProps<React.HTMLAttributes<HTMLSpanElement>, HTMLSpanElement>, "children"> & {
        children: string;
    }>;
    SubTrigger: React.FC<Omit<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuSubTriggerProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild" | "disabled" | "textValue">, keyof {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    }> & {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    }>;
    Group: React.FC<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuGroupProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild"> & {
        children: React.ReactNode;
        style?: React.CSSProperties;
        horizontal?: boolean;
    }>;
    Separator: React.FC<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuSeparatorProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild">>;
    ItemIcon: React.FC<MenuItemIconProps>;
    ItemIndicator: React.FC<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuItemIndicatorProps & React.RefAttributes<HTMLSpanElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild" | "forceMount">>;
    CheckboxItem: React.FC<Omit<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuCheckboxItemProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild" | "disabled" | "textValue" | "checked" | "onCheckedChange">, keyof {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    } | "onCheckedChange"> & {
        onSelect?: () => void;
        disabled?: boolean;
        hidden?: boolean;
        destructive?: boolean;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    } & {
        value: "mixed" | "on" | "off" | boolean;
        onValueChange?: (state: "mixed" | "on" | "off", prevState: "mixed" | "on" | "off") => void;
        key: string;
        shouldDismissMenuOnSelect?: boolean;
    }>;
    ItemImage: React.FC<Omit<React.DetailedHTMLProps<React.ImgHTMLAttributes<HTMLImageElement>, HTMLImageElement>, "height" | "width" | "ref" | "src"> & {
        source: (number | import("react-native").ImageURISource) | {
            src: string;
        };
        width?: number;
        height?: number;
        ios?: {
            style?: import("react-native-ios-utilities").ImageOptions;
            lazy?: boolean;
        };
        accessibilityLabel?: string;
    }>;
    Label: React.FC<Pick<import("@radix-ui/react-dropdown-menu").DropdownMenuLabelProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "dir" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild"> & {
        children: string | React.ReactNode;
    }>;
    Preview: React.FC<{
        children: React.ReactNode | (() => React.ReactNode);
        size?: NonNullable<React.ComponentProps<typeof import("react-native-ios-context-menu").ContextMenuView>["previewConfig"]>["previewSize"];
        onPress?: React.ComponentProps<typeof import("react-native-ios-context-menu").ContextMenuView>["onPressMenuPreview"];
    } & {
        isResizeAnimated?: boolean | undefined;
        borderRadius?: number | undefined;
        backgroundColor?: (import("react-native-ios-utilities").DynamicColor | string) | undefined;
        preferredCommitStyle?: import("react-native-ios-context-menu").ContextMenuInteractionCommitStyle | undefined;
    }>;
    Arrow: React.FC<{
        height?: number;
        width?: number;
        children?: React.ReactNode;
        asChild?: boolean;
    } & Pick<React.SVGAttributes<SVGSVGElement>, "style" | "className" | "fill">>;
    Sub: React.FC<import("@radix-ui/react-dropdown-menu").DropdownMenuSubProps & {
        children: React.ReactNode;
    }>;
    SubContent: React.FC<Pick<import("@radix-ui/react-menu").MenuSubContentProps & React.RefAttributes<HTMLDivElement>, "style" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "children" | "slot" | "title" | "key" | "defaultChecked" | "defaultValue" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "hidden" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "translate" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "prefix" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "color" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-hidden" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChange" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancelCapture" | "onTouchMoveCapture" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "asChild" | "sideOffset" | "alignOffset" | "arrowPadding" | "collisionBoundary" | "collisionPadding" | "sticky" | "hideWhenDetached" | "avoidCollisions" | "loop" | "onEscapeKeyDown" | "onPointerDownOutside" | "onFocusOutside" | "onInteractOutside" | "forceMount"> & {
        style?: React.CSSProperties | undefined;
        onTouchStart?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
        children: React.ReactNode | undefined;
        slot?: string | undefined;
        title?: string | undefined;
        key?: React.Key | null | undefined;
        defaultChecked?: boolean | undefined;
        defaultValue?: string | number | ReadonlyArray<string> | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        className?: string | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        placeholder?: string | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined;
        translate?: "yes" | "no" | undefined;
        radioGroup?: string | undefined;
        role?: React.AriaRole | undefined;
        about?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        resource?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        color?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
        is?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "false" | "mixed" | "true" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "false" | "mixed" | "true" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string;
        } | undefined;
        onCopy?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: React.FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: React.FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: React.FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: React.FocusEventHandler<HTMLDivElement> | undefined;
        onChange?: React.FormEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: React.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onInput?: React.FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onReset?: React.FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: React.FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: React.FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onError?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDown?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: React.DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnterCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeaveCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: React.UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: React.UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: React.WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: React.WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: React.TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: React.TransitionEventHandler<HTMLDivElement> | undefined;
        asChild?: boolean | undefined;
        sideOffset?: number | undefined;
        alignOffset?: number | undefined;
        arrowPadding?: number | undefined;
        collisionBoundary?: (import("@radix-ui/react-popper").Boundary | import("@radix-ui/react-popper").Boundary[]) | undefined;
        collisionPadding?: (number | Partial<Record<import("@radix-ui/react-popper").Side, number>>) | undefined;
        sticky?: ("partial" | "always") | undefined;
        hideWhenDetached?: boolean | undefined;
        avoidCollisions?: boolean | undefined;
        onCloseAutoFocus?: import("@radix-ui/react-menu").FocusScopeProps["onUnmountAutoFocus"];
        loop?: import("@radix-ui/react-menu").RovingFocusGroupProps["loop"];
        onEscapeKeyDown?: import("@radix-ui/react-menu").DismissableLayerProps["onEscapeKeyDown"];
        onPointerDownOutside?: import("@radix-ui/react-menu").DismissableLayerProps["onPointerDownOutside"];
        onFocusOutside?: import("@radix-ui/react-menu").DismissableLayerProps["onFocusOutside"];
        onInteractOutside?: import("@radix-ui/react-menu").DismissableLayerProps["onInteractOutside"];
        forceMount?: true | undefined;
    }>;
    Auxiliary: React.FC<Omit<import("react-native-ios-context-menu").MenuAuxiliaryPreviewConfig, "marginAuxiliaryPreview"> & {
        children: React.ReactNode | ((options: {
            dismissMenu: () => void;
        }) => React.ReactNode);
        onDidShow?: () => void;
        marginWithScreenEdge?: number;
        onWillShow?: () => void;
    }>;
};
export { createAndroidMenu };
