/**
 * Scraped from iOS developer site: https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/system-icons/
 *
 * ```js
 * const icons = []
 *
 * $('table').each(function() {
 *   $(this).find('a').each(function() {
 *     icons.push($(this).text())
 * })
 *   console.log($(this).find('a').text())
 * })
 *
 * console.log(icons.map(icon => `"${icon}"`).join(' | '))
 * ```
 */
export type IosIconName =
  | 'action'
  | 'add'
  | 'bookmarks'
  | 'camera'
  | 'cancel'
  | 'compose'
  | 'done'
  | 'edit'
  | 'fastForward'
  | 'organize'
  | 'pause'
  | 'play'
  | 'redo'
  | 'refresh'
  | 'reply'
  | 'rewind'
  | 'save'
  | 'search'
  | 'stop'
  | 'trash'
  | 'undo'
  | 'bookmarks'
  | 'contacts'
  | 'downloads'
  | 'favorites'
  | 'featured'
  | 'history'
  | 'more'
  | 'mostRecent'
  | 'mostViewed'
  | 'search'
  | 'topRated'
  | 'add'
  | 'alarm'
  | 'audio'
  | 'bookmark'
  | 'capturePhoto'
  | 'captureVideo'
  | 'cloud'
  | 'compose'
  | 'confirmation'
  | 'contact'
  | 'date'
  | 'favorite'
  | 'home'
  | 'invitation'
  | 'location'
  | 'love'
  | 'mail'
  | 'markLocation'
  | 'message'
  | 'pause'
  | 'play'
  | 'prohibit'
  | 'search'
  | 'share'
  | 'shuffle'
  | 'task'
  | 'taskCompleted'
  | 'time'
  | 'update'
