import React, { FC, useCallback, useMemo } from 'react';
import { useRouter, useSearchParams } from 'next/navigation';
import { TopTitle } from '@gitroom/frontend/components/launches/helpers/top.title.component';
import { continueProviderList } from '@gitroom/frontend/components/launches/providers/continue-provider/list';
import { IntegrationContext } from '@gitroom/frontend/components/launches/helpers/use.integration';
import dayjs from 'dayjs';
import useSWR, { useSWRConfig } from 'swr';
import { useFetch } from '@gitroom/helpers/utils/custom.fetch';

export const Null: FC<{ closeModal: () => void; existingId: string[] }> = () =>
  null;
export const ContinueProvider: FC = () => {
  const { mutate } = useSWRConfig();
  const fetch = useFetch();
  const searchParams = useSearchParams();
  const added = searchParams.get('added');
  const continueId = searchParams.get('continue');
  const router = useRouter();

  const load = useCallback(async (path: string) => {
    const list = (await (await fetch(path)).json()).integrations;
    return list;
  }, []);

  const { data: integrations } = useSWR('/integrations/list', load, {
    fallbackData: [],
  });

  const closeModal = useCallback(() => {
    mutate('/integrations/list');
    const url = new URL(window.location.href);
    url.searchParams.delete('added');
    url.searchParams.delete('continue');
    router.push(url.toString());
  }, []);

  const Provider = useMemo(() => {
    if (!added) {
      return Null;
    }
    return continueProviderList[added as keyof typeof continueProviderList] || Null;
  }, [added]);

  if (!added || !continueId || !integrations) {
    return null;
  }

  return (
    <div
      className="fixed left-0 top-0 w-full h-full bg-primary/40 z-[499]"
      onClick={closeModal}
    >
      <div
        className="w-[100%] max-w-[674px] absolute left-[50%] top-[65px] bg-customColor3 z-[500] -translate-x-[50%] text-textColor p-[16px] !pt-0 border border-customColor6 min-h-[300px]"
        onClick={(e) => e.stopPropagation()}
      >
        <div className="w-full h-full relative">
          <TopTitle title="Configure Provider" />
          <button
            onClick={closeModal}
            className="outline-none absolute right-0 top-[20px] mantine-UnstyledButton-root mantine-ActionIcon-root hover:bg-tableBorder cursor-pointer mantine-Modal-close mantine-1dcetaa"
            type="button"
          >
            <svg
              viewBox="0 0 15 15"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
              width="16"
              height="16"
            >
              <path
                d="M11.7816 4.03157C12.0062 3.80702 12.0062 3.44295 11.7816 3.2184C11.5571 2.99385 11.193 2.99385 10.9685 3.2184L7.50005 6.68682L4.03164 3.2184C3.80708 2.99385 3.44301 2.99385 3.21846 3.2184C2.99391 3.44295 2.99391 3.80702 3.21846 4.03157L6.68688 7.49999L3.21846 10.9684C2.99391 11.193 2.99391 11.557 3.21846 11.7816C3.44301 12.0061 3.80708 12.0061 4.03164 11.7816L7.50005 8.31316L10.9685 11.7816C11.193 12.0061 11.5571 12.0061 11.7816 11.7816C12.0062 11.557 12.0062 11.193 11.7816 10.9684L8.31322 7.49999L11.7816 4.03157Z"
                fill="currentColor"
                fillRule="evenodd"
                clipRule="evenodd"
              ></path>
            </svg>
          </button>
          <div className="pt-[16px] max-h-[600px] overflow-hidden overflow-y-auto">
            <IntegrationContext.Provider
              value={{
                date: dayjs(),
                value: [],
                allIntegrations: [],
                integration: {
                  additionalSettings: '',
                  display: '',
                  time: [{time: 0}],
                  id: continueId,
                  type: '',
                  name: '',
                  picture: '',
                  inBetweenSteps: true,
                  changeNickName: false,
                  changeProfilePicture: false,
                  identifier: added,
                },
              }}
            >
              <Provider closeModal={closeModal} existingId={integrations.map((p: any) => p.internalId)} />
            </IntegrationContext.Provider>
          </div>
        </div>
      </div>
    </div>
  );
};
