'use client';
import { useCallback, useEffect, useState } from 'react';

const ModeComponent = () => {
  const [mode, setMode] = useState(localStorage.getItem('mode') || 'dark');

  const changeMode = useCallback(() => {
    setMode(mode === 'dark' ? 'light' : 'dark');
    localStorage.setItem('mode', mode === 'dark' ? 'light' : 'dark');
  }, [mode]);

  useEffect(() => {
    document.body.classList.remove('dark', 'light');
    document.body.classList.add(mode);
  }, [mode]);

  return (
    <div onClick={changeMode} className="select-none cursor-pointer">
      {mode === 'dark' ? (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="24"
          height="24"
          viewBox="0 0 32 32"
          fill="none"
        >
          <path
            d="M29.0175 17.955C28.9211 17.8588 28.8004 17.7907 28.6683 17.7579C28.5362 17.725 28.3976 17.7288 28.2675 17.7688C26.3175 18.3582 24.244 18.4074 22.2682 17.9113C20.2924 17.4152 18.4882 16.3923 17.0479 14.9516C15.6076 13.5109 14.5852 11.7064 14.0896 9.73049C13.594 7.75454 13.6438 5.68114 14.2337 3.73126C14.2731 3.60124 14.2765 3.46294 14.2434 3.33116C14.2103 3.19938 14.1421 3.07906 14.0459 2.98305C13.9498 2.88704 13.8294 2.81895 13.6976 2.78605C13.5657 2.75315 13.4275 2.75668 13.2975 2.79626C10.7119 3.5895 8.44227 5.1777 6.81123 7.33501C4.96231 9.79013 4.06245 12.8305 4.2773 15.8964C4.49215 18.9623 5.80724 21.8475 7.9805 24.0207C10.1538 26.194 13.0389 27.5091 16.1048 27.7239C19.1708 27.9388 22.2111 27.0389 24.6662 25.19C26.8236 23.559 28.4117 21.2893 29.205 18.7038C29.2445 18.5737 29.248 18.4353 29.215 18.3034C29.1819 18.1715 29.1137 18.0511 29.0175 17.955ZM23.7675 23.9913C21.601 25.6161 18.9212 26.4049 16.22 26.213C13.5188 26.021 10.9774 24.8611 9.06253 22.9462C7.14766 21.0313 5.98776 18.49 5.79579 15.7888C5.60382 13.0875 6.39266 10.4077 8.01748 8.24126C9.1748 6.70679 10.7024 5.49096 12.4575 4.70751C12.088 6.73704 12.2162 8.8259 12.831 10.795C13.4459 12.7642 14.5291 14.5548 15.9878 16.0135C17.4464 17.4722 19.2371 18.5554 21.2062 19.1702C23.1753 19.7851 25.2642 19.9133 27.2937 19.5438C26.5124 21.3011 25.2978 22.8314 23.7637 23.9913H23.7675Z"
            fill="currentColor"
          />
        </svg>
      ) : (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="24"
          height="24"
          viewBox="0 0 32 32"
          fill="none"
        >
          <path
            d="M15 5V4C15 3.73478 15.1054 3.48043 15.2929 3.29289C15.4804 3.10536 15.7348 3 16 3C16.2652 3 16.5196 3.10536 16.7071 3.29289C16.8946 3.48043 17 3.73478 17 4V5C17 5.26522 16.8946 5.51957 16.7071 5.70711C16.5196 5.89464 16.2652 6 16 6C15.7348 6 15.4804 5.89464 15.2929 5.70711C15.1054 5.51957 15 5.26522 15 5ZM24 16C24 17.5823 23.5308 19.129 22.6518 20.4446C21.7727 21.7602 20.5233 22.7855 19.0615 23.391C17.5997 23.9965 15.9911 24.155 14.4393 23.8463C12.8874 23.5376 11.462 22.7757 10.3431 21.6569C9.22433 20.538 8.4624 19.1126 8.15372 17.5607C7.84504 16.0089 8.00346 14.4003 8.60896 12.9385C9.21447 11.4767 10.2398 10.2273 11.5554 9.34824C12.871 8.46919 14.4177 8 16 8C18.121 8.00232 20.1545 8.84591 21.6543 10.3457C23.1541 11.8455 23.9977 13.879 24 16ZM22 16C22 14.8133 21.6481 13.6533 20.9888 12.6666C20.3295 11.6799 19.3925 10.9108 18.2961 10.4567C17.1997 10.0026 15.9933 9.88378 14.8295 10.1153C13.6656 10.3468 12.5965 10.9182 11.7574 11.7574C10.9182 12.5965 10.3468 13.6656 10.1153 14.8295C9.88378 15.9933 10.0026 17.1997 10.4567 18.2961C10.9108 19.3925 11.6799 20.3295 12.6666 20.9888C13.6533 21.6481 14.8133 22 16 22C17.5908 21.9983 19.116 21.3657 20.2408 20.2408C21.3657 19.116 21.9983 17.5908 22 16ZM7.2925 8.7075C7.48014 8.89514 7.73464 9.00056 8 9.00056C8.26536 9.00056 8.51986 8.89514 8.7075 8.7075C8.89514 8.51986 9.00056 8.26536 9.00056 8C9.00056 7.73464 8.89514 7.48014 8.7075 7.2925L7.7075 6.2925C7.51986 6.10486 7.26536 5.99944 7 5.99944C6.73464 5.99944 6.48014 6.10486 6.2925 6.2925C6.10486 6.48014 5.99944 6.73464 5.99944 7C5.99944 7.26536 6.10486 7.51986 6.2925 7.7075L7.2925 8.7075ZM7.2925 23.2925L6.2925 24.2925C6.10486 24.4801 5.99944 24.7346 5.99944 25C5.99944 25.2654 6.10486 25.5199 6.2925 25.7075C6.48014 25.8951 6.73464 26.0006 7 26.0006C7.26536 26.0006 7.51986 25.8951 7.7075 25.7075L8.7075 24.7075C8.80041 24.6146 8.87411 24.5043 8.92439 24.3829C8.97468 24.2615 9.00056 24.1314 9.00056 24C9.00056 23.8686 8.97468 23.7385 8.92439 23.6171C8.87411 23.4957 8.80041 23.3854 8.7075 23.2925C8.61459 23.1996 8.50429 23.1259 8.3829 23.0756C8.2615 23.0253 8.13139 22.9994 8 22.9994C7.86861 22.9994 7.7385 23.0253 7.6171 23.0756C7.49571 23.1259 7.38541 23.1996 7.2925 23.2925ZM24 9C24.1314 9.0001 24.2615 8.97432 24.3829 8.92414C24.5042 8.87395 24.6146 8.80033 24.7075 8.7075L25.7075 7.7075C25.8951 7.51986 26.0006 7.26536 26.0006 7C26.0006 6.73464 25.8951 6.48014 25.7075 6.2925C25.5199 6.10486 25.2654 5.99944 25 5.99944C24.7346 5.99944 24.4801 6.10486 24.2925 6.2925L23.2925 7.2925C23.1525 7.43236 23.0571 7.61061 23.0185 7.80469C22.9798 7.99878 22.9996 8.19997 23.0754 8.38279C23.1511 8.56561 23.2794 8.72185 23.444 8.83172C23.6086 8.94159 23.8021 9.00016 24 9ZM24.7075 23.2925C24.5199 23.1049 24.2654 22.9994 24 22.9994C23.7346 22.9994 23.4801 23.1049 23.2925 23.2925C23.1049 23.4801 22.9994 23.7346 22.9994 24C22.9994 24.2654 23.1049 24.5199 23.2925 24.7075L24.2925 25.7075C24.3854 25.8004 24.4957 25.8741 24.6171 25.9244C24.7385 25.9747 24.8686 26.0006 25 26.0006C25.1314 26.0006 25.2615 25.9747 25.3829 25.9244C25.5043 25.8741 25.6146 25.8004 25.7075 25.7075C25.8004 25.6146 25.8741 25.5043 25.9244 25.3829C25.9747 25.2615 26.0006 25.1314 26.0006 25C26.0006 24.8686 25.9747 24.7385 25.9244 24.6171C25.8741 24.4957 25.8004 24.3854 25.7075 24.2925L24.7075 23.2925ZM5 15H4C3.73478 15 3.48043 15.1054 3.29289 15.2929C3.10536 15.4804 3 15.7348 3 16C3 16.2652 3.10536 16.5196 3.29289 16.7071C3.48043 16.8946 3.73478 17 4 17H5C5.26522 17 5.51957 16.8946 5.70711 16.7071C5.89464 16.5196 6 16.2652 6 16C6 15.7348 5.89464 15.4804 5.70711 15.2929C5.51957 15.1054 5.26522 15 5 15ZM16 26C15.7348 26 15.4804 26.1054 15.2929 26.2929C15.1054 26.4804 15 26.7348 15 27V28C15 28.2652 15.1054 28.5196 15.2929 28.7071C15.4804 28.8946 15.7348 29 16 29C16.2652 29 16.5196 28.8946 16.7071 28.7071C16.8946 28.5196 17 28.2652 17 28V27C17 26.7348 16.8946 26.4804 16.7071 26.2929C16.5196 26.1054 16.2652 26 16 26ZM28 15H27C26.7348 15 26.4804 15.1054 26.2929 15.2929C26.1054 15.4804 26 15.7348 26 16C26 16.2652 26.1054 16.5196 26.2929 16.7071C26.4804 16.8946 26.7348 17 27 17H28C28.2652 17 28.5196 16.8946 28.7071 16.7071C28.8946 16.5196 29 16.2652 29 16C29 15.7348 28.8946 15.4804 28.7071 15.2929C28.5196 15.1054 28.2652 15 28 15Z"
            fill="currentColor"
          />
        </svg>
      )}
    </div>
  );
};

export default ModeComponent;
