import {IsDefined, IsEmail, IsString, MinLength, ValidateIf} from "class-validator";
import {Provider} from '@prisma/client';

export class LoginUserDto {
    @IsString()
    @IsDefined()
    @ValidateIf(o => !o.providerToken)
    @MinLength(3)
    password: string;

    @IsString()
    @IsDefined()
    provider: Provider;

    @IsString()
    @IsDefined()
    @ValidateIf(o => !o.password)
    providerToken: string;

    @IsEmail()
    @IsDefined()
    email: string;
}
