import { ThrottlerGuard } from '@nestjs/throttler';
import { ExecutionContext, Injectable } from '@nestjs/common';

@Injectable()
export class ThrottlerBehindProxyGuard extends ThrottlerGuard {
  public override async canActivate(context: ExecutionContext): Promise<boolean> {
    if (context.switchToHttp().getRequest().url.includes('/public/v1')) {
      return super.canActivate(context);
    }

    return true;
  }

  protected override async getTracker(req: Record<string, any>): Promise<string> {
    return req.org.id;
  }
}