/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.26-MariaDB, for debian-linux-gnu (aarch64)
--
-- Host: localhost    Database: monica
-- ------------------------------------------------------
-- Server version	10.5.26-MariaDB-0+deb11u2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `has_access_to_paid_version_for_free` tinyint(1) NOT NULL DEFAULT 0,
  `api_key` varchar(255) NOT NULL,
  `number_of_invitations_sent` int(11) DEFAULT NULL,
  `default_time_reminder_is_sent` varchar(255) NOT NULL DEFAULT '12:00',
  `default_gender_id` int(10) unsigned DEFAULT NULL,
  `stripe_id` varchar(255) DEFAULT NULL,
  `pm_type` varchar(255) DEFAULT NULL,
  `pm_last_four` varchar(4) DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `legacy_free_plan_unlimited_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_default_gender_id_foreign` (`default_gender_id`),
  KEY `accounts_stripe_id_index` (`stripe_id`),
  KEY `accounts_uuid_index` (`uuid`),
  CONSTRAINT `accounts_default_gender_id_foreign` FOREIGN KEY (`default_gender_id`) REFERENCES `genders` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,NULL,0,'LVyHwwrwZuLYk80XDEeTHacIi2g79E',NULL,'12:00',NULL,NULL,NULL,NULL,NULL,0,'2024-01-02 23:41:16','2024-01-02 23:41:16'),(2,NULL,0,'OfH893BBYkEvXdwHZiZ8EJJqbOJQSu',NULL,'12:00',NULL,NULL,NULL,NULL,NULL,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,'bf80d89a-5293-4857-b52a-0d8af9e53e6d',0,'Q9GceHosu8Z7Z8MmLO5aTi2CPBtf2R',NULL,'12:00',9,NULL,NULL,NULL,NULL,0,'2024-01-02 23:41:19','2024-01-03 01:07:10');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `activity_type_id` int(10) unsigned DEFAULT NULL,
  `summary` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `happened_at` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activities_activity_type_id_foreign` (`activity_type_id`),
  KEY `activities_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `activities_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `activities_activity_type_id_foreign` FOREIGN KEY (`activity_type_id`) REFERENCES `activity_types` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_contact`
--

DROP TABLE IF EXISTS `activity_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_contact` (
  `activity_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  KEY `activity_contact_activity_id_foreign` (`activity_id`),
  KEY `activity_contact_contact_id_foreign` (`contact_id`),
  KEY `activity_contact_account_id_foreign` (`account_id`),
  CONSTRAINT `activity_contact_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `activity_contact_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `activity_contact_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_contact`
--

LOCK TABLES `activity_contact` WRITE;
/*!40000 ALTER TABLE `activity_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_statistics`
--

DROP TABLE IF EXISTS `activity_statistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_statistics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `year` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_statistics_account_id_foreign` (`account_id`),
  KEY `activity_statistics_contact_id_foreign` (`contact_id`),
  CONSTRAINT `activity_statistics_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `activity_statistics_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_statistics`
--

LOCK TABLES `activity_statistics` WRITE;
/*!40000 ALTER TABLE `activity_statistics` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_statistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_type_categories`
--

DROP TABLE IF EXISTS `activity_type_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_type_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `translation_key` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_type_categories_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `activity_type_categories_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_type_categories`
--

LOCK TABLES `activity_type_categories` WRITE;
/*!40000 ALTER TABLE `activity_type_categories` DISABLE KEYS */;
INSERT INTO `activity_type_categories` VALUES (1,NULL,1,NULL,'simple_activities',NULL,NULL),(2,NULL,1,NULL,'sport',NULL,NULL),(3,NULL,1,NULL,'food',NULL,NULL),(4,NULL,1,NULL,'cultural_activities',NULL,NULL),(5,NULL,2,NULL,'simple_activities',NULL,NULL),(6,NULL,2,NULL,'sport',NULL,NULL),(7,NULL,2,NULL,'food',NULL,NULL),(8,NULL,2,NULL,'cultural_activities',NULL,NULL),(9,NULL,3,NULL,'simple_activities',NULL,NULL),(10,NULL,3,NULL,'sport',NULL,NULL),(11,NULL,3,NULL,'food',NULL,NULL),(12,NULL,3,NULL,'cultural_activities',NULL,NULL);
/*!40000 ALTER TABLE `activity_type_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_types`
--

DROP TABLE IF EXISTS `activity_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `activity_type_category_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `translation_key` varchar(255) DEFAULT NULL,
  `location_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_types_activity_type_category_id_foreign` (`activity_type_category_id`),
  KEY `activity_types_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `activity_types_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `activity_types_activity_type_category_id_foreign` FOREIGN KEY (`activity_type_category_id`) REFERENCES `activity_type_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_types`
--

LOCK TABLES `activity_types` WRITE;
/*!40000 ALTER TABLE `activity_types` DISABLE KEYS */;
INSERT INTO `activity_types` VALUES (1,NULL,1,1,NULL,'just_hung_out',NULL,NULL,NULL),(2,NULL,1,1,NULL,'watched_movie_at_home',NULL,NULL,NULL),(3,NULL,1,1,NULL,'talked_at_home',NULL,NULL,NULL),(4,NULL,1,2,NULL,'did_sport_activities_together',NULL,NULL,NULL),(5,NULL,1,3,NULL,'ate_at_his_place',NULL,NULL,NULL),(6,NULL,1,3,NULL,'went_bar',NULL,NULL,NULL),(7,NULL,1,3,NULL,'ate_at_home',NULL,NULL,NULL),(8,NULL,1,3,NULL,'picnicked',NULL,NULL,NULL),(9,NULL,1,3,NULL,'ate_restaurant',NULL,NULL,NULL),(10,NULL,1,4,NULL,'went_theater',NULL,NULL,NULL),(11,NULL,1,4,NULL,'went_concert',NULL,NULL,NULL),(12,NULL,1,4,NULL,'went_play',NULL,NULL,NULL),(13,NULL,1,4,NULL,'went_museum',NULL,NULL,NULL),(14,NULL,2,5,NULL,'just_hung_out',NULL,NULL,NULL),(15,NULL,2,5,NULL,'watched_movie_at_home',NULL,NULL,NULL),(16,NULL,2,5,NULL,'talked_at_home',NULL,NULL,NULL),(17,NULL,2,6,NULL,'did_sport_activities_together',NULL,NULL,NULL),(18,NULL,2,7,NULL,'ate_at_his_place',NULL,NULL,NULL),(19,NULL,2,7,NULL,'went_bar',NULL,NULL,NULL),(20,NULL,2,7,NULL,'ate_at_home',NULL,NULL,NULL),(21,NULL,2,7,NULL,'picnicked',NULL,NULL,NULL),(22,NULL,2,7,NULL,'ate_restaurant',NULL,NULL,NULL),(23,NULL,2,8,NULL,'went_theater',NULL,NULL,NULL),(24,NULL,2,8,NULL,'went_concert',NULL,NULL,NULL),(25,NULL,2,8,NULL,'went_play',NULL,NULL,NULL),(26,NULL,2,8,NULL,'went_museum',NULL,NULL,NULL),(27,NULL,3,9,NULL,'just_hung_out',NULL,NULL,NULL),(28,NULL,3,9,NULL,'watched_movie_at_home',NULL,NULL,NULL),(29,NULL,3,9,NULL,'talked_at_home',NULL,NULL,NULL),(30,NULL,3,10,NULL,'did_sport_activities_together',NULL,NULL,NULL),(31,NULL,3,11,NULL,'ate_at_his_place',NULL,NULL,NULL),(32,NULL,3,11,NULL,'went_bar',NULL,NULL,NULL),(33,NULL,3,11,NULL,'ate_at_home',NULL,NULL,NULL),(34,NULL,3,11,NULL,'picnicked',NULL,NULL,NULL),(35,NULL,3,11,NULL,'ate_restaurant',NULL,NULL,NULL),(36,NULL,3,12,NULL,'went_theater',NULL,NULL,NULL),(37,NULL,3,12,NULL,'went_concert',NULL,NULL,NULL),(38,NULL,3,12,NULL,'went_play',NULL,NULL,NULL),(39,NULL,3,12,NULL,'went_museum',NULL,NULL,NULL);
/*!40000 ALTER TABLE `activity_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `address_contact_field_label`
--

DROP TABLE IF EXISTS `address_contact_field_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address_contact_field_label` (
  `contact_field_label_id` bigint(20) unsigned NOT NULL,
  `address_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  KEY `address_contact_field_label_index` (`contact_field_label_id`,`address_id`,`account_id`),
  KEY `address_contact_field_label_address_id_foreign` (`address_id`),
  KEY `address_contact_field_label_account_id_foreign` (`account_id`),
  CONSTRAINT `address_contact_field_label_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `address_contact_field_label_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `addresses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `address_contact_field_label_contact_field_label_id_foreign` FOREIGN KEY (`contact_field_label_id`) REFERENCES `contact_field_labels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address_contact_field_label`
--

LOCK TABLES `address_contact_field_label` WRITE;
/*!40000 ALTER TABLE `address_contact_field_label` DISABLE KEYS */;
/*!40000 ALTER TABLE `address_contact_field_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbook_subscriptions`
--

DROP TABLE IF EXISTS `addressbook_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addressbook_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `address_book_id` bigint(20) unsigned NOT NULL,
  `name` varchar(256) NOT NULL,
  `uri` varchar(2096) NOT NULL,
  `username` varchar(1024) NOT NULL,
  `password` varchar(2048) NOT NULL,
  `readonly` tinyint(1) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `capabilities` varchar(2048) NOT NULL,
  `syncToken` varchar(512) DEFAULT NULL,
  `localSyncToken` varchar(1024) DEFAULT NULL,
  `frequency` smallint(6) NOT NULL DEFAULT 180,
  `last_synchronized_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addressbook_subscriptions_user_id_foreign` (`user_id`),
  KEY `addressbook_subscriptions_address_book_id_foreign` (`address_book_id`),
  KEY `addressbook_subscriptions_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `addressbook_subscriptions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `addressbook_subscriptions_address_book_id_foreign` FOREIGN KEY (`address_book_id`) REFERENCES `addressbooks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `addressbook_subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbook_subscriptions`
--

LOCK TABLES `addressbook_subscriptions` WRITE;
/*!40000 ALTER TABLE `addressbook_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbook_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addressbooks`
--

DROP TABLE IF EXISTS `addressbooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addressbooks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addressbooks_name_index` (`name`),
  KEY `addressbooks_user_id_foreign` (`user_id`),
  KEY `addressbooks_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `addressbooks_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `addressbooks_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addressbooks`
--

LOCK TABLES `addressbooks` WRITE;
/*!40000 ALTER TABLE `addressbooks` DISABLE KEYS */;
/*!40000 ALTER TABLE `addressbooks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `place_id` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addresses_contact_id_foreign` (`contact_id`),
  KEY `addresses_place_id_foreign` (`place_id`),
  KEY `addresses_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `addresses_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `addresses_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `addresses_place_id_foreign` FOREIGN KEY (`place_id`) REFERENCES `places` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_usage`
--

DROP TABLE IF EXISTS `api_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_usage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `method` varchar(255) NOT NULL,
  `client_ip` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_usage`
--

LOCK TABLES `api_usage` WRITE;
/*!40000 ALTER TABLE `api_usage` DISABLE KEYS */;
INSERT INTO `api_usage` VALUES (1,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.89.158','2024-01-03 00:53:42','2024-01-03 00:53:42'),(2,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.89.158','2024-01-03 00:55:04','2024-01-03 00:55:04'),(3,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.89.158','2024-01-03 00:55:43','2024-01-03 00:55:43'),(4,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.89.158','2024-01-03 01:02:49','2024-01-03 01:02:49'),(5,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','85.190.89.158','2024-01-03 01:03:54','2024-01-03 01:03:54'),(6,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','85.190.89.158','2024-01-03 01:04:04','2024-01-03 01:04:04'),(7,'https://mandraw.noho.st/monica/api/contacts/5/activities?page=1','GET','85.190.89.158','2024-01-03 01:19:01','2024-01-03 01:19:01'),(8,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','85.190.89.158','2024-01-03 01:19:29','2024-01-03 01:19:29'),(9,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','85.190.89.158','2024-01-03 01:21:08','2024-01-03 01:21:08'),(10,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','85.190.89.158','2024-01-03 01:23:24','2024-01-03 01:23:24'),(11,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','85.190.89.158','2024-01-03 01:24:02','2024-01-03 01:24:02'),(12,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','85.190.89.158','2024-01-03 01:24:56','2024-01-03 01:24:56'),(13,'https://mandraw.noho.st/monica/api/contacts/8/activities?page=1','GET','85.190.89.158','2024-01-03 01:25:46','2024-01-03 01:25:46'),(14,'https://mandraw.noho.st/monica/api/contacts/8/activities?page=1','GET','85.190.89.158','2024-01-03 01:26:09','2024-01-03 01:26:09'),(15,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','85.190.89.158','2024-01-03 01:26:55','2024-01-03 01:26:55'),(16,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.89.158','2024-01-03 01:26:59','2024-01-03 01:26:59'),(17,'https://mandraw.noho.st/monica/api/contacts/5/activities?page=1','GET','85.190.89.158','2024-01-03 01:27:52','2024-01-03 01:27:52'),(18,'https://mandraw.noho.st/monica/api/contacts/5/activities?page=1','GET','85.190.89.158','2024-01-03 01:28:19','2024-01-03 01:28:19'),(19,'https://mandraw.noho.st/monica/api/contacts/9/activities?page=1','GET','85.190.89.158','2024-01-03 01:29:58','2024-01-03 01:29:58'),(20,'https://mandraw.noho.st/monica/api/contacts/9/activities?page=1','GET','85.190.89.158','2024-01-03 01:31:22','2024-01-03 01:31:22'),(21,'https://mandraw.noho.st/monica/api/contacts/10/activities?page=1','GET','85.190.89.158','2024-01-03 01:34:28','2024-01-03 01:34:28'),(22,'https://mandraw.noho.st/monica/api/contacts/10/activities?page=1','GET','85.190.89.158','2024-01-03 01:34:46','2024-01-03 01:34:46'),(23,'https://mandraw.noho.st/monica/api/contacts/10/activities?page=1','GET','85.190.89.158','2024-01-03 01:36:13','2024-01-03 01:36:13'),(24,'https://mandraw.noho.st/monica/api/contacts/11/activities?page=1','GET','85.190.90.2','2024-01-05 05:36:00','2024-01-05 05:36:00'),(25,'https://mandraw.noho.st/monica/api/contacts/11/activities?page=1','GET','85.190.90.2','2024-01-05 05:39:51','2024-01-05 05:39:51'),(26,'https://mandraw.noho.st/monica/api/contacts/11/activities?page=1','GET','85.190.90.2','2024-01-05 05:56:23','2024-01-05 05:56:23'),(27,'https://mandraw.noho.st/monica/api/contacts/11/activities?page=1','GET','85.190.90.2','2024-01-05 05:56:40','2024-01-05 05:56:40'),(28,'https://mandraw.noho.st/monica/api/contacts/12/activities?page=1','GET','85.190.90.2','2024-01-05 05:57:04','2024-01-05 05:57:04'),(29,'https://mandraw.noho.st/monica/api/contacts/12/activities?page=1','GET','85.190.90.2','2024-01-05 05:57:44','2024-01-05 05:57:44'),(30,'https://mandraw.noho.st/monica/api/contacts/8/activities?page=1','GET','85.190.90.2','2024-01-05 06:00:14','2024-01-05 06:00:14'),(31,'https://mandraw.noho.st/monica/api/contacts/9/activities?page=1','GET','85.190.90.2','2024-01-05 06:00:17','2024-01-05 06:00:17'),(32,'https://mandraw.noho.st/monica/api/contacts/1/activities?page=1','GET','85.190.90.2','2024-01-05 06:00:21','2024-01-05 06:00:21'),(33,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','85.190.90.2','2024-01-05 06:00:26','2024-01-05 06:00:26'),(34,'https://mandraw.noho.st/monica/api/contacts/13/activities?page=1','GET','85.190.90.2','2024-01-05 06:11:56','2024-01-05 06:11:56'),(35,'https://mandraw.noho.st/monica/api/contacts/13/activities?page=1','GET','85.190.90.2','2024-01-05 06:59:56','2024-01-05 06:59:56'),(36,'https://mandraw.noho.st/monica/api/contacts/14/activities?page=1','GET','185.161.170.69','2024-01-07 01:53:42','2024-01-07 01:53:42'),(37,'https://mandraw.noho.st/monica/api/contacts/14/activities?page=1','GET','185.161.170.69','2024-01-07 01:55:20','2024-01-07 01:55:20'),(38,'https://mandraw.noho.st/monica/api/contacts/14/activities?page=1','GET','185.161.170.69','2024-01-07 01:55:37','2024-01-07 01:55:37'),(39,'https://mandraw.noho.st/monica/api/contacts/14/activities?page=1','GET','185.161.170.69','2024-01-07 01:55:47','2024-01-07 01:55:47'),(40,'https://mandraw.noho.st/monica/api/contacts/15/activities?page=1','GET','185.161.170.69','2024-01-07 01:58:09','2024-01-07 01:58:09'),(41,'https://mandraw.noho.st/monica/api/contacts/15/activities?page=1','GET','185.161.170.69','2024-01-07 01:58:48','2024-01-07 01:58:48'),(42,'https://mandraw.noho.st/monica/api/contacts/16/activities?page=1','GET','185.161.170.69','2024-01-07 02:00:33','2024-01-07 02:00:33'),(43,'https://mandraw.noho.st/monica/api/contacts/16/activities?page=1','GET','185.161.170.69','2024-01-07 02:01:54','2024-01-07 02:01:54'),(44,'https://mandraw.noho.st/monica/api/contacts/15/activities?page=1','GET','185.161.170.69','2024-01-07 02:04:14','2024-01-07 02:04:14'),(45,'https://mandraw.noho.st/monica/api/contacts/16/activities?page=1','GET','185.161.170.69','2024-01-07 02:07:08','2024-01-07 02:07:08'),(46,'https://mandraw.noho.st/monica/api/contacts/15/activities?page=1','GET','185.161.170.69','2024-01-07 02:08:30','2024-01-07 02:08:30'),(47,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.69','2024-01-07 02:13:29','2024-01-07 02:13:29'),(48,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.69','2024-01-07 02:28:51','2024-01-07 02:28:51'),(49,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.69','2024-01-07 02:29:25','2024-01-07 02:29:25'),(50,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','185.161.170.69','2024-01-09 12:29:49','2024-01-09 12:29:49'),(51,'https://mandraw.noho.st/monica/api/contacts/3/activities?page=1','GET','185.161.170.69','2024-01-09 16:02:45','2024-01-09 16:02:45'),(52,'https://mandraw.noho.st/monica/api/contacts/3/activities?page=1','GET','185.161.170.69','2024-01-09 16:03:00','2024-01-09 16:03:00'),(53,'https://mandraw.noho.st/monica/api/contacts/3/activities?page=1','GET','185.161.170.69','2024-01-09 16:03:09','2024-01-09 16:03:09'),(54,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','185.161.170.69','2024-01-09 16:03:41','2024-01-09 16:03:41'),(55,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','185.161.170.69','2024-01-09 16:04:05','2024-01-09 16:04:05'),(56,'https://mandraw.noho.st/monica/api/contacts/2/activities?page=1','GET','185.161.170.69','2024-01-09 16:04:11','2024-01-09 16:04:11'),(57,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','185.161.170.69','2024-01-09 16:44:44','2024-01-09 16:44:44'),(58,'https://mandraw.noho.st/monica/api/contacts/7/activities?page=1','GET','185.161.170.69','2024-01-09 16:45:30','2024-01-09 16:45:30'),(59,'https://mandraw.noho.st/monica/api/contacts/18/activities?page=1','GET','85.190.89.148','2024-01-10 09:59:15','2024-01-10 09:59:15'),(60,'https://mandraw.noho.st/monica/api/contacts/18/activities?page=1','GET','85.190.89.148','2024-01-10 09:59:36','2024-01-10 09:59:36'),(61,'https://mandraw.noho.st/monica/api/contacts/18/activities?page=1','GET','85.190.89.148','2024-01-10 10:02:51','2024-01-10 10:02:51'),(62,'https://mandraw.noho.st/monica/api/contacts/9/activities?page=1','GET','85.190.89.148','2024-01-10 10:03:44','2024-01-10 10:03:44'),(63,'https://mandraw.noho.st/monica/api/contacts/3/activities?page=1','GET','85.190.89.148','2024-01-10 10:04:01','2024-01-10 10:04:01'),(64,'https://mandraw.noho.st/monica/api/contacts/3/activities?page=1','GET','85.190.89.148','2024-01-10 10:04:53','2024-01-10 10:04:53'),(65,'https://mandraw.noho.st/monica/api/contacts/4/activities?page=1','GET','85.190.89.148','2024-01-10 10:05:08','2024-01-10 10:05:08'),(66,'https://mandraw.noho.st/monica/api/contacts/4/activities?page=1','GET','85.190.89.148','2024-01-10 10:05:48','2024-01-10 10:05:48'),(67,'https://mandraw.noho.st/monica/api/contacts/19/activities?page=1','GET','85.190.89.148','2024-01-10 10:08:16','2024-01-10 10:08:16'),(68,'https://mandraw.noho.st/monica/api/contacts/19/activities?page=1','GET','85.190.89.148','2024-01-10 10:08:51','2024-01-10 10:08:51'),(69,'https://mandraw.noho.st/monica/api/contacts/20/activities?page=1','GET','85.190.89.148','2024-01-10 10:23:53','2024-01-10 10:23:53'),(70,'https://mandraw.noho.st/monica/api/contacts/20/activities?page=1','GET','85.190.89.148','2024-01-10 10:25:33','2024-01-10 10:25:33'),(71,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.148','2024-01-10 17:31:43','2024-01-10 17:31:43'),(72,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','85.190.90.7','2024-01-11 06:02:43','2024-01-11 06:02:43'),(73,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','85.190.90.7','2024-01-11 06:02:56','2024-01-11 06:02:56'),(74,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','85.190.90.7','2024-01-11 07:30:12','2024-01-11 07:30:12'),(75,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:24:42','2024-01-16 12:24:42'),(76,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:24:52','2024-01-16 12:24:52'),(77,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:25:02','2024-01-16 12:25:02'),(78,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:25:07','2024-01-16 12:25:07'),(79,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:25:13','2024-01-16 12:25:13'),(80,'https://mandraw.noho.st/monica/api/contacts/21/activities?page=1','GET','85.190.89.169','2024-01-16 12:26:02','2024-01-16 12:26:02'),(81,'https://mandraw.noho.st/monica/api/contacts/6/activities?page=1','GET','185.161.170.38','2024-01-17 07:04:27','2024-01-17 07:04:27'),(82,'https://mandraw.noho.st/monica/api/contacts/22/activities?page=1','GET','185.161.169.16','2024-01-20 15:31:35','2024-01-20 15:31:35'),(83,'https://mandraw.noho.st/monica/api/contacts/22/activities?page=1','GET','185.161.169.16','2024-01-20 16:01:26','2024-01-20 16:01:26'),(84,'https://mandraw.noho.st/monica/api/contacts/22/activities?page=1','GET','185.161.169.16','2024-01-20 16:26:25','2024-01-20 16:26:25'),(85,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.68','2024-01-25 04:22:07','2024-01-25 04:22:07'),(86,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.68','2024-01-25 04:22:54','2024-01-25 04:22:54'),(87,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.68','2024-01-25 04:23:09','2024-01-25 04:23:09'),(88,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.68','2024-01-25 04:23:12','2024-01-25 04:23:12'),(89,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','185.161.170.68','2024-01-25 04:24:24','2024-01-25 04:24:24'),(90,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','85.190.89.201','2024-01-25 14:49:06','2024-01-25 14:49:06'),(91,'https://mandraw.noho.st/monica/api/contacts/17/activities?page=1','GET','85.190.89.155','2024-02-02 01:12:26','2024-02-02 01:12:26'),(92,'https://mandraw.noho.st/monica/api/contacts/23/activities?page=1','GET','85.190.89.66','2024-02-04 18:47:06','2024-02-04 18:47:06'),(93,'https://mandraw.noho.st/monica/api/contacts/23/activities?page=1','GET','85.190.89.66','2024-02-04 18:47:23','2024-02-04 18:47:23'),(94,'https://mandraw.noho.st/monica/api/contacts/24/activities?page=1','GET','85.190.89.66','2024-02-04 19:53:42','2024-02-04 19:53:42'),(95,'https://mandraw.noho.st/monica/api/contacts/24/activities?page=1','GET','85.190.89.66','2024-02-04 21:01:58','2024-02-04 21:01:58'),(96,'https://mandraw.noho.st/monica/api/contacts/23/activities?page=1','GET','85.190.89.66','2024-02-04 21:03:10','2024-02-04 21:03:10'),(97,'https://mandraw.noho.st/monica/api/contacts/23/activities?page=1','GET','85.190.89.66','2024-02-04 21:03:21','2024-02-04 21:03:21'),(98,'https://mandraw.noho.st/monica/api/contacts/25/activities?page=1','GET','185.161.171.33','2024-05-19 13:03:57','2024-05-19 13:03:57'),(99,'https://mandraw.noho.st/monica/api/contacts/25/activities?page=1','GET','185.161.171.33','2024-05-19 13:04:22','2024-05-19 13:04:22'),(100,'https://mandraw.noho.st/monica/api/contacts/25/activities?page=1','GET','185.161.171.16','2024-05-20 17:25:45','2024-05-20 17:25:45'),(101,'https://mandraw.noho.st/monica/api/contacts/25/activities?page=1','GET','85.190.89.177','2024-05-21 14:48:54','2024-05-21 14:48:54');
/*!40000 ALTER TABLE `api_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_logs`
--

DROP TABLE IF EXISTS `audit_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `author_id` int(10) unsigned DEFAULT NULL,
  `about_contact_id` int(10) unsigned DEFAULT NULL,
  `author_name` varchar(255) NOT NULL,
  `action` varchar(255) NOT NULL,
  `objects` text NOT NULL,
  `audited_at` datetime NOT NULL,
  `should_appear_on_dashboard` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_logs_account_id_foreign` (`account_id`),
  KEY `audit_logs_author_id_foreign` (`author_id`),
  KEY `audit_logs_about_contact_id_foreign` (`about_contact_id`),
  CONSTRAINT `audit_logs_about_contact_id_foreign` FOREIGN KEY (`about_contact_id`) REFERENCES `contacts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `audit_logs_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `audit_logs_author_id_foreign` FOREIGN KEY (`author_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_logs`
--

LOCK TABLES `audit_logs` WRITE;
/*!40000 ALTER TABLE `audit_logs` DISABLE KEYS */;
INSERT INTO `audit_logs` VALUES (1,3,3,1,'John Doe','contact_created','{\"contact_name\":\"Raeyamoon (Raeya)\",\"contact_id\":1}','2024-01-03 00:53:18',1,'2024-01-03 00:53:18','2024-01-03 00:53:18'),(2,3,3,2,'John Doe','contact_created','{\"contact_name\":\"R3zzy_exe (Rezzy)\",\"contact_id\":2}','2024-01-03 00:54:44',1,'2024-01-03 00:54:44','2024-01-03 00:54:44'),(3,3,3,3,'John Doe','contact_created','{\"contact_name\":\"TheForebringer (Fore)\",\"contact_id\":3}','2024-01-03 01:18:23',1,'2024-01-03 01:18:23','2024-01-03 01:18:23'),(4,3,3,4,'John Doe','contact_created','{\"contact_name\":\"Raydel (Raydel)\",\"contact_id\":4}','2024-01-03 01:18:38',1,'2024-01-03 01:18:38','2024-01-03 01:18:38'),(5,3,3,5,'John Doe','contact_created','{\"contact_name\":\"Himmie (Himmers)\",\"contact_id\":5}','2024-01-03 01:18:59',1,'2024-01-03 01:18:59','2024-01-03 01:18:59'),(6,3,3,6,'John Doe','contact_created','{\"contact_name\":\"Gilphchen (Gilph)\",\"contact_id\":6}','2024-01-03 01:19:27',1,'2024-01-03 01:19:27','2024-01-03 01:19:27'),(7,3,3,7,'John Doe','contact_created','{\"contact_name\":\"Ryan (Ryan)\",\"contact_id\":7}','2024-01-03 01:21:07',1,'2024-01-03 01:21:07','2024-01-03 01:21:07'),(8,3,3,8,'John Doe','contact_created','{\"contact_name\":\"MiloAndVe (Milo)\",\"contact_id\":8}','2024-01-03 01:25:45',1,'2024-01-03 01:25:45','2024-01-03 01:25:45'),(9,3,3,9,'John Doe','contact_created','{\"contact_name\":\"CandlesVt (Candles)\",\"contact_id\":9}','2024-01-03 01:29:57',1,'2024-01-03 01:29:57','2024-01-03 01:29:57'),(10,3,3,10,'John Doe','contact_created','{\"contact_name\":\"RibstheGoblin (Ribs)\",\"contact_id\":10}','2024-01-03 01:34:27',1,'2024-01-03 01:34:27','2024-01-03 01:34:27'),(11,3,3,10,'John Doe','contact_description_cleared','{\"contact_name\":\"RibstheGoblin (Ribs)\",\"contact_id\":10}','2024-01-03 01:36:12',1,'2024-01-03 01:36:12','2024-01-03 01:36:12'),(12,3,3,11,'John Doe','contact_created','{\"contact_name\":\"Grumlarkin\",\"contact_id\":11}','2024-01-05 05:35:58',1,'2024-01-05 05:35:58','2024-01-05 05:35:58'),(13,3,3,11,'John Doe','contact_description_cleared','{\"contact_name\":\"Grumlarkin\",\"contact_id\":11}','2024-01-05 05:56:21',1,'2024-01-05 05:56:21','2024-01-05 05:56:21'),(14,3,3,12,'John Doe','contact_created','{\"contact_name\":\"Oreami\",\"contact_id\":12}','2024-01-05 05:57:03',1,'2024-01-05 05:57:03','2024-01-05 05:57:03'),(15,3,3,13,'John Doe','contact_created','{\"contact_name\":\"Hihsasuke (Sookie)\",\"contact_id\":13}','2024-01-05 06:11:55',1,'2024-01-05 06:11:55','2024-01-05 06:11:55'),(16,3,3,14,'John Doe','contact_created','{\"contact_name\":\"ArtxesSprinkles (Art)\",\"contact_id\":14}','2024-01-07 01:53:41',1,'2024-01-07 01:53:41','2024-01-07 01:53:41'),(17,3,3,14,'John Doe','contact_description_cleared','{\"contact_name\":\"ArtxesSprinkles (Art)\",\"contact_id\":14}','2024-01-07 01:55:36',1,'2024-01-07 01:55:36','2024-01-07 01:55:36'),(18,3,3,15,'John Doe','contact_created','{\"contact_name\":\"OnlySenpaii (Senpaii)\",\"contact_id\":15}','2024-01-07 01:58:08',1,'2024-01-07 01:58:08','2024-01-07 01:58:08'),(19,3,3,16,'John Doe','contact_created','{\"contact_name\":\"Hony_Beea (Beea)\",\"contact_id\":16}','2024-01-07 02:00:32',1,'2024-01-07 02:00:32','2024-01-07 02:00:32'),(20,3,3,16,'John Doe','contact_description_cleared','{\"contact_name\":\"Hony_Beea (Beea)\",\"contact_id\":16}','2024-01-07 02:07:07',1,'2024-01-07 02:07:07','2024-01-07 02:07:07'),(21,3,3,17,'John Doe','contact_created','{\"contact_name\":\"Dad_Knight (Dad)\",\"contact_id\":17}','2024-01-07 02:13:28',1,'2024-01-07 02:13:28','2024-01-07 02:13:28'),(22,3,3,3,'John Doe','contact_description_cleared','{\"contact_name\":\"TheForebringer (Fore)\",\"contact_id\":3}','2024-01-09 16:02:58',1,'2024-01-09 16:02:58','2024-01-09 16:02:58'),(23,3,3,3,'John Doe','contact_description_cleared','{\"contact_name\":\"TheForebringer (Fore)\",\"contact_id\":3}','2024-01-09 16:03:07',1,'2024-01-09 16:03:07','2024-01-09 16:03:07'),(24,3,3,2,'John Doe','contact_description_cleared','{\"contact_name\":\"R3zzy_exe (Rezzy)\",\"contact_id\":2}','2024-01-09 16:04:04',1,'2024-01-09 16:04:04','2024-01-09 16:04:04'),(25,3,3,2,'John Doe','contact_description_cleared','{\"contact_name\":\"R3zzy_exe (Rezzy)\",\"contact_id\":2}','2024-01-09 16:04:10',1,'2024-01-09 16:04:10','2024-01-09 16:04:10'),(26,3,3,7,'John Doe','contact_description_cleared','{\"contact_name\":\"Ryan (Ryan)\",\"contact_id\":7}','2024-01-09 16:45:29',1,'2024-01-09 16:45:29','2024-01-09 16:45:29'),(27,3,3,18,'John Doe','contact_created','{\"contact_name\":\"Feydruidia (Fey)\",\"contact_id\":18}','2024-01-10 09:59:14',1,'2024-01-10 09:59:14','2024-01-10 09:59:14'),(28,3,3,18,'John Doe','contact_description_cleared','{\"contact_name\":\"Feydruidia (Fey)\",\"contact_id\":18}','2024-01-10 09:59:35',1,'2024-01-10 09:59:35','2024-01-10 09:59:35'),(29,3,3,19,'John Doe','contact_created','{\"contact_name\":\"ReactiveCupid93\",\"contact_id\":19}','2024-01-10 10:08:14',1,'2024-01-10 10:08:14','2024-01-10 10:08:14'),(30,3,3,20,'John Doe','contact_created','{\"contact_name\":\"Zoebaskervillevt (Zoe)\",\"contact_id\":20}','2024-01-10 10:23:51',1,'2024-01-10 10:23:51','2024-01-10 10:23:51'),(31,3,3,21,'John Doe','contact_created','{\"contact_name\":\"The_Dummiest_Demon (Hex)\",\"contact_id\":21}','2024-01-10 17:31:41',1,'2024-01-10 17:31:41','2024-01-10 17:31:41'),(32,3,3,6,'John Doe','contact_description_cleared','{\"contact_name\":\"Gilphchen (Gilph)\",\"contact_id\":6}','2024-01-11 06:02:55',1,'2024-01-11 06:02:55','2024-01-11 06:02:55'),(33,3,3,21,'John Doe','contact_description_cleared','{\"contact_name\":\"The_Dummiest_Demon (Hex)\",\"contact_id\":21}','2024-01-16 12:25:01',1,'2024-01-16 12:25:01','2024-01-16 12:25:01'),(34,3,3,21,'John Doe','contact_description_cleared','{\"contact_name\":\"The_Dummiest_Demon (Hex)\",\"contact_id\":21}','2024-01-16 12:25:06',1,'2024-01-16 12:25:06','2024-01-16 12:25:06'),(35,3,3,22,'John Doe','contact_created','{\"contact_name\":\"ExEro (Henry)\",\"contact_id\":22}','2024-01-20 15:31:33',1,'2024-01-20 15:31:33','2024-01-20 15:31:33'),(36,3,3,22,'John Doe','contact_description_cleared','{\"contact_name\":\"ExEro (Henry)\",\"contact_id\":22}','2024-01-20 16:01:25',1,'2024-01-20 16:01:25','2024-01-20 16:01:25'),(37,3,3,23,'John Doe','contact_created','{\"contact_name\":\"LuceBreaks (Luce)\",\"contact_id\":23}','2024-02-04 18:47:04',1,'2024-02-04 18:47:04','2024-02-04 18:47:04'),(38,3,3,24,'John Doe','contact_created','{\"contact_name\":\"PartTimeKadence (Kadence)\",\"contact_id\":24}','2024-02-04 19:53:41',1,'2024-02-04 19:53:41','2024-02-04 19:53:41'),(39,3,3,23,'John Doe','contact_description_cleared','{\"contact_name\":\"LuceBreaks (Luce)\",\"contact_id\":23}','2024-02-04 21:03:18',1,'2024-02-04 21:03:18','2024-02-04 21:03:18'),(40,3,3,25,'Mai Dragora','contact_created','{\"contact_name\":\"Max (Max)\",\"contact_id\":25}','2024-05-19 14:03:55',1,'2024-05-19 13:03:55','2024-05-19 13:03:55'),(41,3,3,25,'Mai Dragora','contact_description_cleared','{\"contact_name\":\"Max (Max)\",\"contact_id\":25}','2024-05-19 14:04:21',1,'2024-05-19 13:04:21','2024-05-19 13:04:21');
/*!40000 ALTER TABLE `audit_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `expiration` int(11) NOT NULL,
  UNIQUE KEY `cache_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('laravel_cacheadorable.0d6de56532759c4fd191610e5b99bba2c8a58ed42b124ee3042ab10f6f4b0aac','s:14010:\"data:image/png;base64,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\";',2020241110),('laravel_cacheadorable.14b2bdf75caf0201dd419feec489a6c7b7c0b7acdf9547266a14068abeea205c','s:11774:\"data:image/png;base64,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\";',2022432427),('laravel_cacheadorable.15676fc3a894ffee3accf5b64b187487229a797f51f9fbfb979efb9ed1d7993f','s:12686:\"data:image/png;base64,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\";',2019603834),('laravel_cacheadorable.17d2a911f0692c60bb830c069e04c131d15fa2acf35fa4cea5c1e432c701f9e3','s:19426:\"data:image/png;base64,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\";',2019954551),('laravel_cacheadorable.1e2a5af9ceba0ef5410d5f843a1c74567ede1dcb1347aa096f1c780b1ddaf305','s:11842:\"data:image/png;base64,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\";',2021127977),('laravel_cacheadorable.20fe7a44635d3fb912243985ccfcd6cfde811457ef821b12f06c692bf3cd50c9','s:19426:\"data:image/png;base64,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\";',2022440508),('laravel_cacheadorable.25c24b661545a3d703751c5b878d2487e6d838cc1cdab2b32ca65a0f26d8d15b','s:17262:\"data:image/png;base64,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\";',2019952701),('laravel_cacheadorable.3236cfb3541f8a1cb5c7b2efe6e1a22fcc5584ec208c4ceb41fa1ad0b4f35e5a','s:20538:\"data:image/png;base64,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\";',2020767883),('laravel_cacheadorable.3cca8b9c15e15effcf23685a5f49cc068a63e8fd7c4e647bffb1bd6280e08870','s:12846:\"data:image/png;base64,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\";',2019952538),('laravel_cacheadorable.44ad041fe52523dfbba534e3407b94c3200f8f5b344f307525fecf4056f7f9fa','s:16222:\"data:image/png;base64,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\";',2019797740),('laravel_cacheadorable.5243797151b60936f93607df431c1c0a14a2dfb5cbb4baff578cb04c29eb6aa2','s:17638:\"data:image/png;base64,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\";',2019793182),('laravel_cacheadorable.5680ed12b5d29fbec42dc58bdad5917d9d922564c0a4e6894e2737ecbfad9d82','s:14010:\"data:image/png;base64,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\";',2019952835),('laravel_cacheadorable.5c065f55d30825f12422f7d3012418052e8d9d0dac920554ef97bb6d896a1c78','s:14266:\"data:image/png;base64,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\";',2019604995),('laravel_cacheadorable.6f3924bf0b12938e5c5b008bd3accbde9978c692e811ddcfede00d4025d99838','s:13362:\"data:image/png;base64,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\";',2019794239),('laravel_cacheadorable.82b9040d2a0b0dcbfdefe7bc568dd33dcb0212df9cb740b8976a1e0126e81809','s:24162:\"data:image/png;base64,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\";',2020241323),('laravel_cacheadorable.8c9cc6dc3d26086ec13e122d4c8dddb50fc5f6f580d63ca4e5c7b15852cedb3a','s:13246:\"data:image/png;base64,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\";',2019605474),('laravel_cacheadorable.bd0914bbb465388b11e99a95874164fc599d3a80ca7623c0d4f1da4cff37f1d8','s:16970:\"data:image/png;base64,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\";',2019605273),('laravel_cacheadorable.d26dc4e8f02609f84ab1f4c65045ea7ec5468a26fb8f3ef48715da8cc37087c7','s:13322:\"data:image/png;base64,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\";',2019605161),('laravel_cacheadorable.d334fe212cf13b3533b6e5f76368f49e553051020b21f4c5349ec6eb6cc82446','s:21206:\"data:image/png;base64,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\";',2020242323),('laravel_cacheadorable.d3421fec9b7ff0f71aed8d224d098096db56f9e90fb995dc023c9dd37cbc377a','s:16842:\"data:image/png;base64,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\";',2019605670),('laravel_cacheadorable.d3abf8d59922a8be63dc1e4c9ac6c936e4048aa8acd6d9b8e9211bb35390b3cc','s:16222:\"data:image/png;base64,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\";',2019605087),('laravel_cacheadorable.d700791160721d12634b763f42f773f00dd9a83f82356a7500dc9bfc31f383a4','s:17682:\"data:image/png;base64,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\";',2020241044),('laravel_cacheadorable.f1486db86c59a223abb756759c76de357cb65a35c14896bf326e0c74ad8b0f5d','s:14778:\"data:image/png;base64,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\";',2020240949),('laravel_cacheadorable.f3eb99856410c61794aab689ae59db37acd9cc7b7e3573775f70864fbe6c7270','s:16078:\"data:image/png;base64,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\";',2019603346),('laravel_cachecountries.en','O:29:\"Illuminate\\Support\\Collection\":2:{s:8:\"\0*\0items\";a:250:{s:2:\"af\";a:2:{s:2:\"id\";s:2:\"AF\";s:7:\"country\";s:11:\"Afghanistan\";}s:2:\"ax\";a:2:{s:2:\"id\";s:2:\"AX\";s:7:\"country\";s:14:\"Åland Islands\";}s:2:\"al\";a:2:{s:2:\"id\";s:2:\"AL\";s:7:\"country\";s:7:\"Albania\";}s:2:\"dz\";a:2:{s:2:\"id\";s:2:\"DZ\";s:7:\"country\";s:7:\"Algeria\";}s:2:\"as\";a:2:{s:2:\"id\";s:2:\"AS\";s:7:\"country\";s:14:\"American Samoa\";}s:2:\"ad\";a:2:{s:2:\"id\";s:2:\"AD\";s:7:\"country\";s:7:\"Andorra\";}s:2:\"ao\";a:2:{s:2:\"id\";s:2:\"AO\";s:7:\"country\";s:6:\"Angola\";}s:2:\"ai\";a:2:{s:2:\"id\";s:2:\"AI\";s:7:\"country\";s:8:\"Anguilla\";}s:2:\"aq\";a:2:{s:2:\"id\";s:2:\"AQ\";s:7:\"country\";s:10:\"Antarctica\";}s:2:\"ag\";a:2:{s:2:\"id\";s:2:\"AG\";s:7:\"country\";s:19:\"Antigua and Barbuda\";}s:2:\"ar\";a:2:{s:2:\"id\";s:2:\"AR\";s:7:\"country\";s:9:\"Argentina\";}s:2:\"am\";a:2:{s:2:\"id\";s:2:\"AM\";s:7:\"country\";s:7:\"Armenia\";}s:2:\"aw\";a:2:{s:2:\"id\";s:2:\"AW\";s:7:\"country\";s:5:\"Aruba\";}s:2:\"au\";a:2:{s:2:\"id\";s:2:\"AU\";s:7:\"country\";s:9:\"Australia\";}s:2:\"at\";a:2:{s:2:\"id\";s:2:\"AT\";s:7:\"country\";s:7:\"Austria\";}s:2:\"az\";a:2:{s:2:\"id\";s:2:\"AZ\";s:7:\"country\";s:10:\"Azerbaijan\";}s:2:\"bs\";a:2:{s:2:\"id\";s:2:\"BS\";s:7:\"country\";s:7:\"Bahamas\";}s:2:\"bh\";a:2:{s:2:\"id\";s:2:\"BH\";s:7:\"country\";s:7:\"Bahrain\";}s:2:\"bd\";a:2:{s:2:\"id\";s:2:\"BD\";s:7:\"country\";s:10:\"Bangladesh\";}s:2:\"bb\";a:2:{s:2:\"id\";s:2:\"BB\";s:7:\"country\";s:8:\"Barbados\";}s:2:\"by\";a:2:{s:2:\"id\";s:2:\"BY\";s:7:\"country\";s:7:\"Belarus\";}s:2:\"be\";a:2:{s:2:\"id\";s:2:\"BE\";s:7:\"country\";s:7:\"Belgium\";}s:2:\"bz\";a:2:{s:2:\"id\";s:2:\"BZ\";s:7:\"country\";s:6:\"Belize\";}s:2:\"bj\";a:2:{s:2:\"id\";s:2:\"BJ\";s:7:\"country\";s:5:\"Benin\";}s:2:\"bm\";a:2:{s:2:\"id\";s:2:\"BM\";s:7:\"country\";s:7:\"Bermuda\";}s:2:\"bt\";a:2:{s:2:\"id\";s:2:\"BT\";s:7:\"country\";s:6:\"Bhutan\";}s:2:\"bo\";a:2:{s:2:\"id\";s:2:\"BO\";s:7:\"country\";s:7:\"Bolivia\";}s:2:\"ba\";a:2:{s:2:\"id\";s:2:\"BA\";s:7:\"country\";s:22:\"Bosnia and Herzegovina\";}s:2:\"bw\";a:2:{s:2:\"id\";s:2:\"BW\";s:7:\"country\";s:8:\"Botswana\";}s:2:\"bv\";a:2:{s:2:\"id\";s:2:\"BV\";s:7:\"country\";s:13:\"Bouvet Island\";}s:2:\"br\";a:2:{s:2:\"id\";s:2:\"BR\";s:7:\"country\";s:6:\"Brazil\";}s:2:\"io\";a:2:{s:2:\"id\";s:2:\"IO\";s:7:\"country\";s:30:\"British Indian Ocean Territory\";}s:2:\"vg\";a:2:{s:2:\"id\";s:2:\"VG\";s:7:\"country\";s:22:\"British Virgin Islands\";}s:2:\"bn\";a:2:{s:2:\"id\";s:2:\"BN\";s:7:\"country\";s:6:\"Brunei\";}s:2:\"bg\";a:2:{s:2:\"id\";s:2:\"BG\";s:7:\"country\";s:8:\"Bulgaria\";}s:2:\"bf\";a:2:{s:2:\"id\";s:2:\"BF\";s:7:\"country\";s:12:\"Burkina Faso\";}s:2:\"bi\";a:2:{s:2:\"id\";s:2:\"BI\";s:7:\"country\";s:7:\"Burundi\";}s:2:\"kh\";a:2:{s:2:\"id\";s:2:\"KH\";s:7:\"country\";s:8:\"Cambodia\";}s:2:\"cm\";a:2:{s:2:\"id\";s:2:\"CM\";s:7:\"country\";s:8:\"Cameroon\";}s:2:\"ca\";a:2:{s:2:\"id\";s:2:\"CA\";s:7:\"country\";s:6:\"Canada\";}s:2:\"cv\";a:2:{s:2:\"id\";s:2:\"CV\";s:7:\"country\";s:10:\"Cape Verde\";}s:2:\"bq\";a:2:{s:2:\"id\";s:2:\"BQ\";s:7:\"country\";s:21:\"Caribbean Netherlands\";}s:2:\"ky\";a:2:{s:2:\"id\";s:2:\"KY\";s:7:\"country\";s:14:\"Cayman Islands\";}s:2:\"cf\";a:2:{s:2:\"id\";s:2:\"CF\";s:7:\"country\";s:24:\"Central African Republic\";}s:2:\"td\";a:2:{s:2:\"id\";s:2:\"TD\";s:7:\"country\";s:4:\"Chad\";}s:2:\"cl\";a:2:{s:2:\"id\";s:2:\"CL\";s:7:\"country\";s:5:\"Chile\";}s:2:\"cn\";a:2:{s:2:\"id\";s:2:\"CN\";s:7:\"country\";s:5:\"China\";}s:2:\"cx\";a:2:{s:2:\"id\";s:2:\"CX\";s:7:\"country\";s:16:\"Christmas Island\";}s:2:\"cc\";a:2:{s:2:\"id\";s:2:\"CC\";s:7:\"country\";s:23:\"Cocos (Keeling) Islands\";}s:2:\"co\";a:2:{s:2:\"id\";s:2:\"CO\";s:7:\"country\";s:8:\"Colombia\";}s:2:\"km\";a:2:{s:2:\"id\";s:2:\"KM\";s:7:\"country\";s:7:\"Comoros\";}s:2:\"ck\";a:2:{s:2:\"id\";s:2:\"CK\";s:7:\"country\";s:12:\"Cook Islands\";}s:2:\"cr\";a:2:{s:2:\"id\";s:2:\"CR\";s:7:\"country\";s:10:\"Costa Rica\";}s:2:\"hr\";a:2:{s:2:\"id\";s:2:\"HR\";s:7:\"country\";s:7:\"Croatia\";}s:2:\"cu\";a:2:{s:2:\"id\";s:2:\"CU\";s:7:\"country\";s:4:\"Cuba\";}s:2:\"cw\";a:2:{s:2:\"id\";s:2:\"CW\";s:7:\"country\";s:8:\"Curaçao\";}s:2:\"cy\";a:2:{s:2:\"id\";s:2:\"CY\";s:7:\"country\";s:6:\"Cyprus\";}s:2:\"cz\";a:2:{s:2:\"id\";s:2:\"CZ\";s:7:\"country\";s:14:\"Czech Republic\";}s:2:\"dk\";a:2:{s:2:\"id\";s:2:\"DK\";s:7:\"country\";s:7:\"Denmark\";}s:2:\"dj\";a:2:{s:2:\"id\";s:2:\"DJ\";s:7:\"country\";s:8:\"Djibouti\";}s:2:\"dm\";a:2:{s:2:\"id\";s:2:\"DM\";s:7:\"country\";s:8:\"Dominica\";}s:2:\"do\";a:2:{s:2:\"id\";s:2:\"DO\";s:7:\"country\";s:18:\"Dominican Republic\";}s:2:\"cd\";a:2:{s:2:\"id\";s:2:\"CD\";s:7:\"country\";s:8:\"DR Congo\";}s:2:\"ec\";a:2:{s:2:\"id\";s:2:\"EC\";s:7:\"country\";s:7:\"Ecuador\";}s:2:\"eg\";a:2:{s:2:\"id\";s:2:\"EG\";s:7:\"country\";s:5:\"Egypt\";}s:2:\"sv\";a:2:{s:2:\"id\";s:2:\"SV\";s:7:\"country\";s:11:\"El Salvador\";}s:2:\"gq\";a:2:{s:2:\"id\";s:2:\"GQ\";s:7:\"country\";s:17:\"Equatorial Guinea\";}s:2:\"er\";a:2:{s:2:\"id\";s:2:\"ER\";s:7:\"country\";s:7:\"Eritrea\";}s:2:\"ee\";a:2:{s:2:\"id\";s:2:\"EE\";s:7:\"country\";s:7:\"Estonia\";}s:2:\"et\";a:2:{s:2:\"id\";s:2:\"ET\";s:7:\"country\";s:8:\"Ethiopia\";}s:2:\"fk\";a:2:{s:2:\"id\";s:2:\"FK\";s:7:\"country\";s:16:\"Falkland Islands\";}s:2:\"fo\";a:2:{s:2:\"id\";s:2:\"FO\";s:7:\"country\";s:13:\"Faroe Islands\";}s:2:\"fj\";a:2:{s:2:\"id\";s:2:\"FJ\";s:7:\"country\";s:4:\"Fiji\";}s:2:\"fi\";a:2:{s:2:\"id\";s:2:\"FI\";s:7:\"country\";s:7:\"Finland\";}s:2:\"fr\";a:2:{s:2:\"id\";s:2:\"FR\";s:7:\"country\";s:6:\"France\";}s:2:\"gf\";a:2:{s:2:\"id\";s:2:\"GF\";s:7:\"country\";s:13:\"French Guiana\";}s:2:\"pf\";a:2:{s:2:\"id\";s:2:\"PF\";s:7:\"country\";s:16:\"French Polynesia\";}s:2:\"tf\";a:2:{s:2:\"id\";s:2:\"TF\";s:7:\"country\";s:35:\"French Southern and Antarctic Lands\";}s:2:\"ga\";a:2:{s:2:\"id\";s:2:\"GA\";s:7:\"country\";s:5:\"Gabon\";}s:2:\"gm\";a:2:{s:2:\"id\";s:2:\"GM\";s:7:\"country\";s:6:\"Gambia\";}s:2:\"ge\";a:2:{s:2:\"id\";s:2:\"GE\";s:7:\"country\";s:7:\"Georgia\";}s:2:\"de\";a:2:{s:2:\"id\";s:2:\"DE\";s:7:\"country\";s:7:\"Germany\";}s:2:\"gh\";a:2:{s:2:\"id\";s:2:\"GH\";s:7:\"country\";s:5:\"Ghana\";}s:2:\"gi\";a:2:{s:2:\"id\";s:2:\"GI\";s:7:\"country\";s:9:\"Gibraltar\";}s:2:\"gr\";a:2:{s:2:\"id\";s:2:\"GR\";s:7:\"country\";s:6:\"Greece\";}s:2:\"gl\";a:2:{s:2:\"id\";s:2:\"GL\";s:7:\"country\";s:9:\"Greenland\";}s:2:\"gd\";a:2:{s:2:\"id\";s:2:\"GD\";s:7:\"country\";s:7:\"Grenada\";}s:2:\"gp\";a:2:{s:2:\"id\";s:2:\"GP\";s:7:\"country\";s:10:\"Guadeloupe\";}s:2:\"gu\";a:2:{s:2:\"id\";s:2:\"GU\";s:7:\"country\";s:4:\"Guam\";}s:2:\"gt\";a:2:{s:2:\"id\";s:2:\"GT\";s:7:\"country\";s:9:\"Guatemala\";}s:2:\"gg\";a:2:{s:2:\"id\";s:2:\"GG\";s:7:\"country\";s:8:\"Guernsey\";}s:2:\"gn\";a:2:{s:2:\"id\";s:2:\"GN\";s:7:\"country\";s:6:\"Guinea\";}s:2:\"gw\";a:2:{s:2:\"id\";s:2:\"GW\";s:7:\"country\";s:13:\"Guinea-Bissau\";}s:2:\"gy\";a:2:{s:2:\"id\";s:2:\"GY\";s:7:\"country\";s:6:\"Guyana\";}s:2:\"ht\";a:2:{s:2:\"id\";s:2:\"HT\";s:7:\"country\";s:5:\"Haiti\";}s:2:\"hm\";a:2:{s:2:\"id\";s:2:\"HM\";s:7:\"country\";s:33:\"Heard Island and McDonald Islands\";}s:2:\"hn\";a:2:{s:2:\"id\";s:2:\"HN\";s:7:\"country\";s:8:\"Honduras\";}s:2:\"hk\";a:2:{s:2:\"id\";s:2:\"HK\";s:7:\"country\";s:9:\"Hong Kong\";}s:2:\"hu\";a:2:{s:2:\"id\";s:2:\"HU\";s:7:\"country\";s:7:\"Hungary\";}s:2:\"is\";a:2:{s:2:\"id\";s:2:\"IS\";s:7:\"country\";s:7:\"Iceland\";}s:2:\"in\";a:2:{s:2:\"id\";s:2:\"IN\";s:7:\"country\";s:5:\"India\";}s:2:\"id\";a:2:{s:2:\"id\";s:2:\"ID\";s:7:\"country\";s:9:\"Indonesia\";}s:2:\"ir\";a:2:{s:2:\"id\";s:2:\"IR\";s:7:\"country\";s:4:\"Iran\";}s:2:\"iq\";a:2:{s:2:\"id\";s:2:\"IQ\";s:7:\"country\";s:4:\"Iraq\";}s:2:\"ie\";a:2:{s:2:\"id\";s:2:\"IE\";s:7:\"country\";s:7:\"Ireland\";}s:2:\"im\";a:2:{s:2:\"id\";s:2:\"IM\";s:7:\"country\";s:11:\"Isle of Man\";}s:2:\"il\";a:2:{s:2:\"id\";s:2:\"IL\";s:7:\"country\";s:6:\"Israel\";}s:2:\"it\";a:2:{s:2:\"id\";s:2:\"IT\";s:7:\"country\";s:5:\"Italy\";}s:2:\"ci\";a:2:{s:2:\"id\";s:2:\"CI\";s:7:\"country\";s:11:\"Ivory Coast\";}s:2:\"jm\";a:2:{s:2:\"id\";s:2:\"JM\";s:7:\"country\";s:7:\"Jamaica\";}s:2:\"jp\";a:2:{s:2:\"id\";s:2:\"JP\";s:7:\"country\";s:5:\"Japan\";}s:2:\"je\";a:2:{s:2:\"id\";s:2:\"JE\";s:7:\"country\";s:6:\"Jersey\";}s:2:\"jo\";a:2:{s:2:\"id\";s:2:\"JO\";s:7:\"country\";s:6:\"Jordan\";}s:2:\"kz\";a:2:{s:2:\"id\";s:2:\"KZ\";s:7:\"country\";s:10:\"Kazakhstan\";}s:2:\"ke\";a:2:{s:2:\"id\";s:2:\"KE\";s:7:\"country\";s:5:\"Kenya\";}s:2:\"ki\";a:2:{s:2:\"id\";s:2:\"KI\";s:7:\"country\";s:8:\"Kiribati\";}s:2:\"xk\";a:2:{s:2:\"id\";s:2:\"XK\";s:7:\"country\";s:6:\"Kosovo\";}s:2:\"kw\";a:2:{s:2:\"id\";s:2:\"KW\";s:7:\"country\";s:6:\"Kuwait\";}s:2:\"kg\";a:2:{s:2:\"id\";s:2:\"KG\";s:7:\"country\";s:10:\"Kyrgyzstan\";}s:2:\"la\";a:2:{s:2:\"id\";s:2:\"LA\";s:7:\"country\";s:4:\"Laos\";}s:2:\"lv\";a:2:{s:2:\"id\";s:2:\"LV\";s:7:\"country\";s:6:\"Latvia\";}s:2:\"lb\";a:2:{s:2:\"id\";s:2:\"LB\";s:7:\"country\";s:7:\"Lebanon\";}s:2:\"ls\";a:2:{s:2:\"id\";s:2:\"LS\";s:7:\"country\";s:7:\"Lesotho\";}s:2:\"lr\";a:2:{s:2:\"id\";s:2:\"LR\";s:7:\"country\";s:7:\"Liberia\";}s:2:\"ly\";a:2:{s:2:\"id\";s:2:\"LY\";s:7:\"country\";s:5:\"Libya\";}s:2:\"li\";a:2:{s:2:\"id\";s:2:\"LI\";s:7:\"country\";s:13:\"Liechtenstein\";}s:2:\"lt\";a:2:{s:2:\"id\";s:2:\"LT\";s:7:\"country\";s:9:\"Lithuania\";}s:2:\"lu\";a:2:{s:2:\"id\";s:2:\"LU\";s:7:\"country\";s:10:\"Luxembourg\";}s:2:\"mo\";a:2:{s:2:\"id\";s:2:\"MO\";s:7:\"country\";s:5:\"Macau\";}s:2:\"mk\";a:2:{s:2:\"id\";s:2:\"MK\";s:7:\"country\";s:9:\"Macedonia\";}s:2:\"mg\";a:2:{s:2:\"id\";s:2:\"MG\";s:7:\"country\";s:10:\"Madagascar\";}s:2:\"mw\";a:2:{s:2:\"id\";s:2:\"MW\";s:7:\"country\";s:6:\"Malawi\";}s:2:\"my\";a:2:{s:2:\"id\";s:2:\"MY\";s:7:\"country\";s:8:\"Malaysia\";}s:2:\"mv\";a:2:{s:2:\"id\";s:2:\"MV\";s:7:\"country\";s:8:\"Maldives\";}s:2:\"ml\";a:2:{s:2:\"id\";s:2:\"ML\";s:7:\"country\";s:4:\"Mali\";}s:2:\"mt\";a:2:{s:2:\"id\";s:2:\"MT\";s:7:\"country\";s:5:\"Malta\";}s:2:\"mh\";a:2:{s:2:\"id\";s:2:\"MH\";s:7:\"country\";s:16:\"Marshall Islands\";}s:2:\"mq\";a:2:{s:2:\"id\";s:2:\"MQ\";s:7:\"country\";s:10:\"Martinique\";}s:2:\"mr\";a:2:{s:2:\"id\";s:2:\"MR\";s:7:\"country\";s:10:\"Mauritania\";}s:2:\"mu\";a:2:{s:2:\"id\";s:2:\"MU\";s:7:\"country\";s:9:\"Mauritius\";}s:2:\"yt\";a:2:{s:2:\"id\";s:2:\"YT\";s:7:\"country\";s:7:\"Mayotte\";}s:2:\"mx\";a:2:{s:2:\"id\";s:2:\"MX\";s:7:\"country\";s:6:\"Mexico\";}s:2:\"fm\";a:2:{s:2:\"id\";s:2:\"FM\";s:7:\"country\";s:10:\"Micronesia\";}s:2:\"md\";a:2:{s:2:\"id\";s:2:\"MD\";s:7:\"country\";s:7:\"Moldova\";}s:2:\"mc\";a:2:{s:2:\"id\";s:2:\"MC\";s:7:\"country\";s:6:\"Monaco\";}s:2:\"mn\";a:2:{s:2:\"id\";s:2:\"MN\";s:7:\"country\";s:8:\"Mongolia\";}s:2:\"me\";a:2:{s:2:\"id\";s:2:\"ME\";s:7:\"country\";s:10:\"Montenegro\";}s:2:\"ms\";a:2:{s:2:\"id\";s:2:\"MS\";s:7:\"country\";s:10:\"Montserrat\";}s:2:\"ma\";a:2:{s:2:\"id\";s:2:\"MA\";s:7:\"country\";s:7:\"Morocco\";}s:2:\"mz\";a:2:{s:2:\"id\";s:2:\"MZ\";s:7:\"country\";s:10:\"Mozambique\";}s:2:\"mm\";a:2:{s:2:\"id\";s:2:\"MM\";s:7:\"country\";s:7:\"Myanmar\";}s:2:\"na\";a:2:{s:2:\"id\";s:2:\"NA\";s:7:\"country\";s:7:\"Namibia\";}s:2:\"nr\";a:2:{s:2:\"id\";s:2:\"NR\";s:7:\"country\";s:5:\"Nauru\";}s:2:\"np\";a:2:{s:2:\"id\";s:2:\"NP\";s:7:\"country\";s:5:\"Nepal\";}s:2:\"nl\";a:2:{s:2:\"id\";s:2:\"NL\";s:7:\"country\";s:11:\"Netherlands\";}s:2:\"nc\";a:2:{s:2:\"id\";s:2:\"NC\";s:7:\"country\";s:13:\"New Caledonia\";}s:2:\"nz\";a:2:{s:2:\"id\";s:2:\"NZ\";s:7:\"country\";s:11:\"New Zealand\";}s:2:\"ni\";a:2:{s:2:\"id\";s:2:\"NI\";s:7:\"country\";s:9:\"Nicaragua\";}s:2:\"ne\";a:2:{s:2:\"id\";s:2:\"NE\";s:7:\"country\";s:5:\"Niger\";}s:2:\"ng\";a:2:{s:2:\"id\";s:2:\"NG\";s:7:\"country\";s:7:\"Nigeria\";}s:2:\"nu\";a:2:{s:2:\"id\";s:2:\"NU\";s:7:\"country\";s:4:\"Niue\";}s:2:\"nf\";a:2:{s:2:\"id\";s:2:\"NF\";s:7:\"country\";s:14:\"Norfolk Island\";}s:2:\"kp\";a:2:{s:2:\"id\";s:2:\"KP\";s:7:\"country\";s:11:\"North Korea\";}s:2:\"mp\";a:2:{s:2:\"id\";s:2:\"MP\";s:7:\"country\";s:24:\"Northern Mariana Islands\";}s:2:\"no\";a:2:{s:2:\"id\";s:2:\"NO\";s:7:\"country\";s:6:\"Norway\";}s:2:\"om\";a:2:{s:2:\"id\";s:2:\"OM\";s:7:\"country\";s:4:\"Oman\";}s:2:\"pk\";a:2:{s:2:\"id\";s:2:\"PK\";s:7:\"country\";s:8:\"Pakistan\";}s:2:\"pw\";a:2:{s:2:\"id\";s:2:\"PW\";s:7:\"country\";s:5:\"Palau\";}s:2:\"ps\";a:2:{s:2:\"id\";s:2:\"PS\";s:7:\"country\";s:9:\"Palestine\";}s:2:\"pa\";a:2:{s:2:\"id\";s:2:\"PA\";s:7:\"country\";s:6:\"Panama\";}s:2:\"pg\";a:2:{s:2:\"id\";s:2:\"PG\";s:7:\"country\";s:16:\"Papua New Guinea\";}s:2:\"py\";a:2:{s:2:\"id\";s:2:\"PY\";s:7:\"country\";s:8:\"Paraguay\";}s:2:\"pe\";a:2:{s:2:\"id\";s:2:\"PE\";s:7:\"country\";s:4:\"Peru\";}s:2:\"ph\";a:2:{s:2:\"id\";s:2:\"PH\";s:7:\"country\";s:11:\"Philippines\";}s:2:\"pn\";a:2:{s:2:\"id\";s:2:\"PN\";s:7:\"country\";s:16:\"Pitcairn Islands\";}s:2:\"pl\";a:2:{s:2:\"id\";s:2:\"PL\";s:7:\"country\";s:6:\"Poland\";}s:2:\"pt\";a:2:{s:2:\"id\";s:2:\"PT\";s:7:\"country\";s:8:\"Portugal\";}s:2:\"pr\";a:2:{s:2:\"id\";s:2:\"PR\";s:7:\"country\";s:11:\"Puerto Rico\";}s:2:\"qa\";a:2:{s:2:\"id\";s:2:\"QA\";s:7:\"country\";s:5:\"Qatar\";}s:2:\"cg\";a:2:{s:2:\"id\";s:2:\"CG\";s:7:\"country\";s:21:\"Republic of the Congo\";}s:2:\"re\";a:2:{s:2:\"id\";s:2:\"RE\";s:7:\"country\";s:8:\"Réunion\";}s:2:\"ro\";a:2:{s:2:\"id\";s:2:\"RO\";s:7:\"country\";s:7:\"Romania\";}s:2:\"ru\";a:2:{s:2:\"id\";s:2:\"RU\";s:7:\"country\";s:6:\"Russia\";}s:2:\"rw\";a:2:{s:2:\"id\";s:2:\"RW\";s:7:\"country\";s:6:\"Rwanda\";}s:2:\"bl\";a:2:{s:2:\"id\";s:2:\"BL\";s:7:\"country\";s:17:\"Saint Barthélemy\";}s:2:\"sh\";a:2:{s:2:\"id\";s:2:\"SH\";s:7:\"country\";s:12:\"Saint Helena\";}s:2:\"kn\";a:2:{s:2:\"id\";s:2:\"KN\";s:7:\"country\";s:21:\"Saint Kitts and Nevis\";}s:2:\"lc\";a:2:{s:2:\"id\";s:2:\"LC\";s:7:\"country\";s:11:\"Saint Lucia\";}s:2:\"mf\";a:2:{s:2:\"id\";s:2:\"MF\";s:7:\"country\";s:12:\"Saint Martin\";}s:2:\"pm\";a:2:{s:2:\"id\";s:2:\"PM\";s:7:\"country\";s:25:\"Saint Pierre and Miquelon\";}s:2:\"vc\";a:2:{s:2:\"id\";s:2:\"VC\";s:7:\"country\";s:32:\"Saint Vincent and the Grenadines\";}s:2:\"ws\";a:2:{s:2:\"id\";s:2:\"WS\";s:7:\"country\";s:5:\"Samoa\";}s:2:\"sm\";a:2:{s:2:\"id\";s:2:\"SM\";s:7:\"country\";s:10:\"San Marino\";}s:2:\"st\";a:2:{s:2:\"id\";s:2:\"ST\";s:7:\"country\";s:24:\"São Tomé and Príncipe\";}s:2:\"sa\";a:2:{s:2:\"id\";s:2:\"SA\";s:7:\"country\";s:12:\"Saudi Arabia\";}s:2:\"sn\";a:2:{s:2:\"id\";s:2:\"SN\";s:7:\"country\";s:7:\"Senegal\";}s:2:\"rs\";a:2:{s:2:\"id\";s:2:\"RS\";s:7:\"country\";s:6:\"Serbia\";}s:2:\"sc\";a:2:{s:2:\"id\";s:2:\"SC\";s:7:\"country\";s:10:\"Seychelles\";}s:2:\"sl\";a:2:{s:2:\"id\";s:2:\"SL\";s:7:\"country\";s:12:\"Sierra Leone\";}s:2:\"sg\";a:2:{s:2:\"id\";s:2:\"SG\";s:7:\"country\";s:9:\"Singapore\";}s:2:\"sx\";a:2:{s:2:\"id\";s:2:\"SX\";s:7:\"country\";s:12:\"Sint Maarten\";}s:2:\"sk\";a:2:{s:2:\"id\";s:2:\"SK\";s:7:\"country\";s:8:\"Slovakia\";}s:2:\"si\";a:2:{s:2:\"id\";s:2:\"SI\";s:7:\"country\";s:8:\"Slovenia\";}s:2:\"sb\";a:2:{s:2:\"id\";s:2:\"SB\";s:7:\"country\";s:15:\"Solomon Islands\";}s:2:\"so\";a:2:{s:2:\"id\";s:2:\"SO\";s:7:\"country\";s:7:\"Somalia\";}s:2:\"za\";a:2:{s:2:\"id\";s:2:\"ZA\";s:7:\"country\";s:12:\"South Africa\";}s:2:\"gs\";a:2:{s:2:\"id\";s:2:\"GS\";s:7:\"country\";s:13:\"South Georgia\";}s:2:\"kr\";a:2:{s:2:\"id\";s:2:\"KR\";s:7:\"country\";s:11:\"South Korea\";}s:2:\"ss\";a:2:{s:2:\"id\";s:2:\"SS\";s:7:\"country\";s:11:\"South Sudan\";}s:2:\"es\";a:2:{s:2:\"id\";s:2:\"ES\";s:7:\"country\";s:5:\"Spain\";}s:2:\"lk\";a:2:{s:2:\"id\";s:2:\"LK\";s:7:\"country\";s:9:\"Sri Lanka\";}s:2:\"sd\";a:2:{s:2:\"id\";s:2:\"SD\";s:7:\"country\";s:5:\"Sudan\";}s:2:\"sr\";a:2:{s:2:\"id\";s:2:\"SR\";s:7:\"country\";s:8:\"Suriname\";}s:2:\"sj\";a:2:{s:2:\"id\";s:2:\"SJ\";s:7:\"country\";s:22:\"Svalbard and Jan Mayen\";}s:2:\"sz\";a:2:{s:2:\"id\";s:2:\"SZ\";s:7:\"country\";s:9:\"Swaziland\";}s:2:\"se\";a:2:{s:2:\"id\";s:2:\"SE\";s:7:\"country\";s:6:\"Sweden\";}s:2:\"ch\";a:2:{s:2:\"id\";s:2:\"CH\";s:7:\"country\";s:11:\"Switzerland\";}s:2:\"sy\";a:2:{s:2:\"id\";s:2:\"SY\";s:7:\"country\";s:5:\"Syria\";}s:2:\"tw\";a:2:{s:2:\"id\";s:2:\"TW\";s:7:\"country\";s:6:\"Taiwan\";}s:2:\"tj\";a:2:{s:2:\"id\";s:2:\"TJ\";s:7:\"country\";s:10:\"Tajikistan\";}s:2:\"tz\";a:2:{s:2:\"id\";s:2:\"TZ\";s:7:\"country\";s:8:\"Tanzania\";}s:2:\"th\";a:2:{s:2:\"id\";s:2:\"TH\";s:7:\"country\";s:8:\"Thailand\";}s:2:\"tl\";a:2:{s:2:\"id\";s:2:\"TL\";s:7:\"country\";s:11:\"Timor-Leste\";}s:2:\"tg\";a:2:{s:2:\"id\";s:2:\"TG\";s:7:\"country\";s:4:\"Togo\";}s:2:\"tk\";a:2:{s:2:\"id\";s:2:\"TK\";s:7:\"country\";s:7:\"Tokelau\";}s:2:\"to\";a:2:{s:2:\"id\";s:2:\"TO\";s:7:\"country\";s:5:\"Tonga\";}s:2:\"tt\";a:2:{s:2:\"id\";s:2:\"TT\";s:7:\"country\";s:19:\"Trinidad and Tobago\";}s:2:\"tn\";a:2:{s:2:\"id\";s:2:\"TN\";s:7:\"country\";s:7:\"Tunisia\";}s:2:\"tr\";a:2:{s:2:\"id\";s:2:\"TR\";s:7:\"country\";s:6:\"Turkey\";}s:2:\"tm\";a:2:{s:2:\"id\";s:2:\"TM\";s:7:\"country\";s:12:\"Turkmenistan\";}s:2:\"tc\";a:2:{s:2:\"id\";s:2:\"TC\";s:7:\"country\";s:24:\"Turks and Caicos Islands\";}s:2:\"tv\";a:2:{s:2:\"id\";s:2:\"TV\";s:7:\"country\";s:6:\"Tuvalu\";}s:2:\"ug\";a:2:{s:2:\"id\";s:2:\"UG\";s:7:\"country\";s:6:\"Uganda\";}s:2:\"ua\";a:2:{s:2:\"id\";s:2:\"UA\";s:7:\"country\";s:7:\"Ukraine\";}s:2:\"ae\";a:2:{s:2:\"id\";s:2:\"AE\";s:7:\"country\";s:20:\"United Arab Emirates\";}s:2:\"gb\";a:2:{s:2:\"id\";s:2:\"GB\";s:7:\"country\";s:14:\"United Kingdom\";}s:2:\"us\";a:2:{s:2:\"id\";s:2:\"US\";s:7:\"country\";s:13:\"United States\";}s:2:\"um\";a:2:{s:2:\"id\";s:2:\"UM\";s:7:\"country\";s:36:\"United States Minor Outlying Islands\";}s:2:\"vi\";a:2:{s:2:\"id\";s:2:\"VI\";s:7:\"country\";s:28:\"United States Virgin Islands\";}s:2:\"uy\";a:2:{s:2:\"id\";s:2:\"UY\";s:7:\"country\";s:7:\"Uruguay\";}s:2:\"uz\";a:2:{s:2:\"id\";s:2:\"UZ\";s:7:\"country\";s:10:\"Uzbekistan\";}s:2:\"vu\";a:2:{s:2:\"id\";s:2:\"VU\";s:7:\"country\";s:7:\"Vanuatu\";}s:2:\"va\";a:2:{s:2:\"id\";s:2:\"VA\";s:7:\"country\";s:12:\"Vatican City\";}s:2:\"ve\";a:2:{s:2:\"id\";s:2:\"VE\";s:7:\"country\";s:9:\"Venezuela\";}s:2:\"vn\";a:2:{s:2:\"id\";s:2:\"VN\";s:7:\"country\";s:7:\"Vietnam\";}s:2:\"wf\";a:2:{s:2:\"id\";s:2:\"WF\";s:7:\"country\";s:17:\"Wallis and Futuna\";}s:2:\"eh\";a:2:{s:2:\"id\";s:2:\"EH\";s:7:\"country\";s:14:\"Western Sahara\";}s:2:\"ye\";a:2:{s:2:\"id\";s:2:\"YE\";s:7:\"country\";s:5:\"Yemen\";}s:2:\"zm\";a:2:{s:2:\"id\";s:2:\"ZM\";s:7:\"country\";s:6:\"Zambia\";}s:2:\"zw\";a:2:{s:2:\"id\";s:2:\"ZW\";s:7:\"country\";s:8:\"Zimbabwe\";}}s:28:\"\0*\0escapeWhenCastingToString\";b:0;}',2019603222),('laravel_cached2bfa8e8b749d2772a21edee7b70a2b3','i:1;',1716306594),('laravel_cached2bfa8e8b749d2772a21edee7b70a2b3:timer','i:1716306594;',1716306594),('laravel_cacheetag./monica/store/avatars/015ebe10-26d3-4db5-a317-9a04fb07db1c.jpg?1704244739','s:40:\"4b13a731c5c7e937048ab813d3ee52977010d23f\";',2019604740),('laravel_cacheetag./monica/store/avatars/1e874ed7-4310-4b23-be01-c07cc9712cc9.jpg?1704434223','s:40:\"e639b46a04e03c1e2cc7e80b49af2c4e576ddc83\";',2019794223),('laravel_cacheetag./monica/store/avatars/1f5ab7f8-eedd-42f3-b7ba-9d6974ff7f1e.jpg?1716127435','s:40:\"dd111243c23fe2885c19886a36be8a33b5781ecc\";',2031487436),('laravel_cacheetag./monica/store/avatars/2cc8cd6b-292f-4649-bc3a-6abbdb4d1ac8.jpg?1704244718','s:40:\"7a5db81692f455f1b45aa8193df63cc545254b5c\";',2019604744),('laravel_cacheetag./monica/store/avatars/33cfba7d-72b2-445d-b997-1e2261ff28fa.jpg?1704244867','s:40:\"6a6b3bb15eec2cbb7bd3c6a19354884c97a22a82\";',2019604867),('laravel_cacheetag./monica/store/avatars/3708dfe9-302d-4c98-8951-8454e76b429c.jpg?1704245145','s:40:\"3c15ed30a74b2d74cb7132b36a5f4bda3bdf5157\";',2019605146),('laravel_cacheetag./monica/store/avatars/420bbe8c-7d07-4285-91ae-5057bff1268a.jpg?1704907901','s:40:\"f58f3e16e822a43a276d09952a6f8e03ea00204d\";',2020267902),('laravel_cacheetag./monica/store/avatars/43c7b3a9-5b11-4b0b-b225-2af5cce8d57c.jpg?1707076421','s:40:\"af8d4486e7a8c73da7579e3c3c935ffa28f1562a\";',2022436422),('laravel_cacheetag./monica/store/avatars/4a32e728-1757-4d18-8fc2-e9ee4d91d519.jpg?1707072424','s:40:\"e2f935f8c6edc41f6cf6bee0fdcd3b6eb5c73009\";',2022432425),('laravel_cacheetag./monica/store/avatars/5496c613-22bd-4df6-953b-503d2bce3ced.jpg?1704245397','s:40:\"c151836853b0c913ec953ba65df9e2da57c9d0eb\";',2019605398),('laravel_cacheetag./monica/store/avatars/56bd1ba5-1b36-4ea4-8fc0-a88281022d19.jpg?1704592688','s:40:\"c2a074bb6c5cdd28bed70d1e142986cc7bc7ed41\";',2019952688),('laravel_cacheetag./monica/store/avatars/743ecfd5-dc4d-4d62-b2bb-3d2f94fb4160.jpg?1704592421','s:40:\"1d9ccda62c4ac0ff73900996a3780b4b1abf88dd\";',2019952421),('laravel_cacheetag./monica/store/avatars/746fc795-e78b-4340-8e51-d4f49dcbf8e3.jpg?1704435115','s:40:\"7cfd2b4ea20f14f7cc7a1e397586013643bf10e5\";',2019795116),('laravel_cacheetag./monica/store/avatars/868f26ff-a823-44ca-b0d3-21bbf8e0d493.jpg?1704244767','s:40:\"87df6f7dfd141a83ac51f8527d45dd3d4b6d85c0\";',2019604768),('laravel_cacheetag./monica/store/avatars/88feb418-5f08-4a1c-9ce9-60be45d96598.jpg?1705764693','s:40:\"e93e88f270f6b25e05e5ef63639b11f3e726ec83\";',2021124694),('laravel_cacheetag./monica/store/avatars/8d89628c-ec73-474f-bcd1-a040b45368a6.jpg?1704880754','s:40:\"e888d08275ab2bddc1045217480ff7b7120d7408\";',2020240755),('laravel_cacheetag./monica/store/avatars/9a528bd0-5b44-4d15-99bc-a0aec7e78344.jpg?1704882231','s:40:\"f1fbf9f0ad54553b587c010f5228dcb22f7800ce\";',2020242232),('laravel_cacheetag./monica/store/avatars/9e79a73f-bb57-45af-ac55-eca83cfd3a94.jpg?1704432958','s:40:\"de8267099a6126a8674e09ab03f9454b93fa759c\";',2019792959),('laravel_cacheetag./monica/store/avatars/a2ea9ef7-1f30-418c-b3ec-a2fe9e689cdc.jpg?1704593608','s:40:\"3798028376885c77b058ffae58836413270f14a6\";',2019953609),('laravel_cacheetag./monica/store/avatars/a5a58987-0040-432c-8d98-1eb739c6217d.jpg?1704245667','s:40:\"28c32018fcbd4e91836f6883667cd21f170c01f4\";',2019605667),('laravel_cacheetag./monica/store/avatars/b31ef81c-e03e-4c1b-9ca0-343568cbcb12.jpg?1704592832','s:40:\"ea0eab79a33ac61506a9f528c1bbba45ab1f0c0f\";',2019952833),('laravel_cacheetag./monica/store/avatars/bd777f56-729b-434c-a3c7-d4e8075ca360.jpg?1704244703','s:40:\"afb77b9dce3b50416968f611784f72ef942e9726\";',2019604744),('laravel_cacheetag./monica/store/avatars/bf79b693-c496-4f8f-ab80-1733857becfb.jpg?1704243198','s:40:\"ef33fc809eb5caa58b4f9bf7c2121cc56bb03a3f\";',2019603221),('laravel_cacheetag./monica/store/avatars/e8118e7e-d350-428a-a43b-2913a802cfd6.jpg?1704881294','s:40:\"4aa5b3c3af222b80e4f25018e6a2fec08000f27b\";',2020241295),('laravel_cacheetag./monica/store/avatars/f0061aa8-e995-45db-9885-75918ff586bd.jpg?1704243284','s:40:\"07ce18489b9d0c42745ed8f0cbb7493bd4aac863\";',2019603833),('laravel_cacheetag./monica/store/photos/0CYyOeS1vN1bcUg8BbRqWJbGWQx15AqbheVKiHPm.jpg','s:40:\"3b5a7b0e17c7e969414753a8428a70967fe00a0c\";',2019605298),('laravel_cacheetag./monica/store/photos/1mA8ySKeqEWS5UjgBIfXdV4RMfReqQ855jk4ATUY.jpg','s:40:\"32f9c76bc26af8dc6a1088c4f2af3718985f28d6\";',2019793191),('laravel_cacheetag./monica/store/photos/66eYwZYo5081zA0iWig2BukjdCERkKWtNBjMyqL9.jpg','s:40:\"5700af024c3cc1781b7459fd2eb42c033fa2fec4\";',2019794264),('laravel_cacheetag./monica/store/photos/6NOGWtEUovIUBO5qpOqEi4NRlTjEeqS88C8RPZgO.jpg','s:40:\"ca6a5a1db8f87f7e1370ef31ba39348964d9f834\";',2022432442),('laravel_cacheetag./monica/store/photos/8DKYDXFQ8Fhiq7ZKZEmbNMM8hZZ8zTJzwdHd5szM.jpg','s:40:\"0dbb1e55e31ff6f296fd7cca689e60f24e02e201\";',2020242332),('laravel_cacheetag./monica/store/photos/BJvrT9LcFkwOby4a9auyn05V6Qp7yGu0NYWmUNsc.jpg','s:40:\"3c958fe6ecfa718a14d4d185125738d05bff0390\";',2019954564),('laravel_cacheetag./monica/store/photos/D4x6q2PjbUfh4wto8NbhR04C3xJktz1Zziv9OIhW.jpg','s:40:\"775535bcc5303bd639d345dbc56d162b02e64602\";',2020241092),('laravel_cacheetag./monica/store/photos/eba7dt5esLH2ddsnXhnYMQHb157qb0JkhR6qHeP1.jpg','s:40:\"c3a884d54dbfd62d9d2a5df4498c01b93b85c50f\";',2019797995),('laravel_cacheetag./monica/store/photos/fLKsm45CwBlYcUyu142nMEIZAINqc6e70hwWJhuV.jpg','s:40:\"660ce7aee16a6363249dc4bced2cdf09c2724c4f\";',2020241148),('laravel_cacheetag./monica/store/photos/fSrPJAtKkIs5xYXNSYEtKluV3BhPlVQVGOlw6bg1.jpg','s:40:\"5b8e6fd3e0d842881b5586f5248e23101b71db34\";',2021127984),('laravel_cacheetag./monica/store/photos/Gkco32EXSTxA4e4GUHDfXEGt9CS4EP5HAdD9bfs2.jpg','s:40:\"3eee861d285801ca29c7f33ef80e81bb894f6205\";',2019952913),('laravel_cacheetag./monica/store/photos/GyAvrPESVvXMxjqeBcUu2XPfgKR5qMWoVHnHNugr.jpg','s:40:\"647c91357f47197b6bf9001e800197d05ccb87a3\";',2020240970),('laravel_cacheetag./monica/store/photos/IhVx1rvOcXESRCfYFKZiBvtAZP60IoN9SPXRB1Ya.jpg','s:40:\"529acc7515e0d852bb45255be21d5a4ff914e87c\";',2020767961),('laravel_cacheetag./monica/store/photos/J25DMi0j5r6IvRgbsqNA6iJpNSmyo03zxmt1I2jS.jpg','s:40:\"4390c75a1cdbba25c42c246223d2a2126a7568ec\";',2019605095),('laravel_cacheetag./monica/store/photos/K2Rk6Q3G3F8al2y03roI0NjK92SCMnOQWglvgbsJ.jpg','s:40:\"a39e051cfa26051cd3a28bdd2ac9d2fa25ce51ec\";',2019605482),('laravel_cacheetag./monica/store/photos/KGq9QGf6R5UXdftURjpBXZ08g27jS7aEwOAHRuYh.jpg','s:40:\"707f2140d602f18f3471ad9dd4f452d410515743\";',2019952546),('laravel_cacheetag./monica/store/photos/l6vgOZxoujXfKxCcK0hnm1FQGER9Yted44eDD7Or.jpg','s:40:\"fd5e3da28f32b22124f77de281fb2add22b50af7\";',2019605685),('laravel_cacheetag./monica/store/photos/mXSq8V0i2e562mbLNkes8V94iRkgBUchYTFXM0A5.jpg','s:40:\"0412c2d5e0fd916f1a6cff63b791f55225594a9b\";',2019605169),('laravel_cacheetag./monica/store/photos/oEioKUt3REQNNY7x5r2dxqwxphKx13DQ9tIFITVl.jpg','s:40:\"8e805c722b5f1d03f922c17324fe100cc5f533a8\";',2019605003),('laravel_cacheetag./monica/store/photos/OmzwHTfEwzcUUTPu6DciXA0IZtH3vktB1QxyzgMC.jpg','s:40:\"58b55baa71d597a5b08ba14b9dfa44332f1a0452\";',2019603843),('laravel_cacheetag./monica/store/photos/RcI8WAAzVWEZbJ8z4bPTVmOkc0pQ3jTb7Xrna4rL.jpg','s:40:\"ab1a8a3adbbeb36161432a8fc5447bc9e2644e0e\";',2020241330),('laravel_cacheetag./monica/store/photos/RID2mVXB9527SWtj4GeA2aXHp4lusTC00vo9MxMU.jpg','s:40:\"48c4bfcc8d28616b16b0947f958408d3751234f8\";',2022440517),('laravel_cacheetag./monica/store/photos/UoqCtVL1CV3HACxRWgjAM6dx4oYlRfEA1zvLlm76.jpg','s:40:\"caae4cc48716904a917af9f4803a38054b838e46\";',2019952728),('laravel_cacheetag./monica/store/photos/zfo4f18iCoA8J6tPQh7Sloj1USeJHAiLocUMam1b.jpg','s:40:\"87c5052c38d694142e28e25921ec721009e0ffea\";',2019603768);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calls`
--

DROP TABLE IF EXISTS `calls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `called_at` datetime NOT NULL,
  `content` mediumtext DEFAULT NULL,
  `contact_called` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calls_contact_id_foreign` (`contact_id`),
  KEY `calls_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `calls_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `calls_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calls`
--

LOCK TABLES `calls` WRITE;
/*!40000 ALTER TABLE `calls` DISABLE KEYS */;
/*!40000 ALTER TABLE `calls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companies`
--

DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `website` varchar(255) DEFAULT NULL,
  `number_of_employees` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_account_id_foreign` (`account_id`),
  CONSTRAINT `companies_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companies`
--

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_field_contact_field_label`
--

DROP TABLE IF EXISTS `contact_field_contact_field_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_field_contact_field_label` (
  `contact_field_label_id` bigint(20) unsigned NOT NULL,
  `contact_field_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  KEY `contact_field_contact_field_label_index` (`contact_field_label_id`,`contact_field_id`,`account_id`),
  KEY `contact_field_contact_field_label_contact_field_id_foreign` (`contact_field_id`),
  KEY `contact_field_contact_field_label_account_id_foreign` (`account_id`),
  CONSTRAINT `contact_field_contact_field_label_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_field_contact_field_label_contact_field_id_foreign` FOREIGN KEY (`contact_field_id`) REFERENCES `contact_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_field_contact_field_label_contact_field_label_id_foreign` FOREIGN KEY (`contact_field_label_id`) REFERENCES `contact_field_labels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_field_contact_field_label`
--

LOCK TABLES `contact_field_contact_field_label` WRITE;
/*!40000 ALTER TABLE `contact_field_contact_field_label` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_field_contact_field_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_field_labels`
--

DROP TABLE IF EXISTS `contact_field_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_field_labels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `label_i18n` varchar(20) DEFAULT NULL,
  `label` varchar(500) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_field_labels_label_i18n_account_id_index` (`label_i18n`,`account_id`),
  KEY `contact_field_labels_label_account_id_index` (`label`,`account_id`),
  KEY `contact_field_labels_account_id_foreign` (`account_id`),
  CONSTRAINT `contact_field_labels_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_field_labels`
--

LOCK TABLES `contact_field_labels` WRITE;
/*!40000 ALTER TABLE `contact_field_labels` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_field_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_field_types`
--

DROP TABLE IF EXISTS `contact_field_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_field_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `fontawesome_icon` varchar(255) DEFAULT NULL,
  `protocol` varchar(255) DEFAULT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 1,
  `type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_field_types_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `contact_field_types_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_field_types`
--

LOCK TABLES `contact_field_types` WRITE;
/*!40000 ALTER TABLE `contact_field_types` DISABLE KEYS */;
INSERT INTO `contact_field_types` VALUES (1,NULL,1,'Email','fa fa-envelope-open-o','mailto:',0,'email','2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,NULL,1,'Phone','fa fa-volume-control-phone','tel:',0,'phone','2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,NULL,1,'Facebook','fa fa-facebook-official','https://facebook.com/',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,NULL,1,'Twitter','fa fa-twitter-square',NULL,1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(5,NULL,1,'Whatsapp','fa fa-whatsapp','https://wa.me/',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(6,NULL,1,'Telegram','fa fa-telegram','telegram:',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(7,NULL,1,'LinkedIn','fa fa-linkedin-square',NULL,1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(8,NULL,2,'Email','fa fa-envelope-open-o','mailto:',0,'email','2024-01-02 23:41:18','2024-01-02 23:41:18'),(9,NULL,2,'Phone','fa fa-volume-control-phone','tel:',0,'phone','2024-01-02 23:41:18','2024-01-02 23:41:18'),(10,NULL,2,'Facebook','fa fa-facebook-official','https://facebook.com/',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(11,NULL,2,'Twitter','fa fa-twitter-square',NULL,1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(12,NULL,2,'Whatsapp','fa fa-whatsapp','https://wa.me/',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(13,NULL,2,'Telegram','fa fa-telegram','telegram:',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(14,NULL,2,'LinkedIn','fa fa-linkedin-square',NULL,1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(15,'ed09d358-4e20-4690-aa33-7343335305d4',3,'Email','fa fa-envelope-open-o','mailto:',0,'email','2024-01-02 23:41:19','2024-01-03 00:53:42'),(16,'94edb83c-760e-4147-a4a3-1265dcaa3545',3,'Phone','fa fa-volume-control-phone','tel:',0,'phone','2024-01-02 23:41:19','2024-01-03 00:53:42'),(17,'50de18e3-8ab4-4386-a708-c2ba3cf9343f',3,'Facebook','fa fa-facebook-official','https://facebook.com/',1,NULL,'2024-01-02 23:41:19','2024-01-03 00:53:42'),(18,'7fb5b87c-f938-40c8-9e32-a3b34c7df6cf',3,'Twitter','fa fa-twitter-square',NULL,1,NULL,'2024-01-02 23:41:19','2024-01-03 00:53:42'),(19,'0d77517a-2c7d-4c86-8c78-3e223663dfd6',3,'Whatsapp','fa fa-whatsapp','https://wa.me/',1,NULL,'2024-01-02 23:41:19','2024-01-03 00:53:42'),(20,'59c0fa5c-d76c-4e47-9ba9-65ef4ea7fe7a',3,'Telegram','fa fa-telegram','telegram:',1,NULL,'2024-01-02 23:41:19','2024-01-03 00:53:42'),(21,'4e4a1d52-4e33-492b-957a-9cf9bcd5026c',3,'LinkedIn','fa fa-linkedin-square',NULL,1,NULL,'2024-01-02 23:41:19','2024-01-03 00:53:42'),(22,'4c3ac6b8-b1e4-48ce-b76a-9ab2c49b65ec',3,'Twitch','fa fa-twitch',NULL,1,NULL,'2024-01-03 01:08:23','2024-01-03 01:17:31');
/*!40000 ALTER TABLE `contact_field_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_fields`
--

DROP TABLE IF EXISTS `contact_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `contact_field_type_id` int(10) unsigned NOT NULL,
  `data` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_fields_contact_id_foreign` (`contact_id`),
  KEY `contact_fields_contact_field_type_id_foreign` (`contact_field_type_id`),
  KEY `contact_fields_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `contact_fields_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_fields_contact_field_type_id_foreign` FOREIGN KEY (`contact_field_type_id`) REFERENCES `contact_field_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_fields_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_fields`
--

LOCK TABLES `contact_fields` WRITE;
/*!40000 ALTER TABLE `contact_fields` DISABLE KEYS */;
INSERT INTO `contact_fields` VALUES (1,NULL,3,2,18,'https://twitter.com/R3ZZY_EXE','2024-01-03 01:06:09','2024-01-03 01:06:09'),(2,NULL,3,6,22,'https://www.twitch.tv/gilphchen','2024-01-03 01:20:04','2024-01-03 01:20:04'),(3,NULL,3,7,22,'https://www.twitch.tv/spectre828','2024-01-03 01:22:28','2024-01-03 01:22:28'),(4,NULL,3,7,18,'https://twitter.com/KitsuneNoKage88','2024-01-03 01:22:52','2024-01-03 01:22:52'),(5,NULL,3,8,18,'https://twitter.com/MiloAndVe1','2024-01-03 01:26:16','2024-01-03 01:26:16'),(6,NULL,3,8,22,'https://www.twitch.tv/miloandve','2024-01-03 01:26:44','2024-01-03 01:26:44'),(8,NULL,3,1,18,'https://twitter.com/RaeyaMoon','2024-01-03 01:27:24','2024-01-03 01:27:24'),(9,NULL,3,1,22,'https://twitch.tv/RaeyaMoon','2024-01-03 01:27:40','2024-01-03 01:27:40'),(10,NULL,3,9,18,'https://twitter.com/CandlesVT','2024-01-03 01:30:11','2024-01-03 01:30:11'),(11,NULL,3,9,22,'https://www.twitch.tv/candlesthegoblin','2024-01-03 01:30:27','2024-01-03 01:30:27'),(12,NULL,3,10,18,'https://twitter.com/Ribsthegoblin','2024-01-03 01:35:16','2024-01-03 01:35:16'),(13,NULL,3,11,22,'https://www.twitch.tv/grumlarkin','2024-01-05 05:36:20','2024-01-05 05:36:20'),(14,NULL,3,11,18,'https://twitter.com/grumlarkin','2024-01-05 05:36:33','2024-01-05 05:36:33'),(15,NULL,3,12,18,'https://twitter.com/OreamiVT','2024-01-05 05:58:57','2024-01-05 05:58:57'),(16,NULL,3,12,22,'https://www.twitch.tv/oreamivt','2024-01-05 05:59:42','2024-01-05 05:59:42'),(17,NULL,3,13,22,'https://www.twitch.tv/Hihsasuke','2024-01-05 06:12:05','2024-01-05 06:12:05'),(18,NULL,3,13,18,'https://twitter.com/Hihsasuke','2024-01-05 06:12:58','2024-01-05 06:12:58'),(19,NULL,3,14,22,'https://www.twitch.tv/artxesprinkles','2024-01-07 01:54:00','2024-01-07 01:54:00'),(20,NULL,3,14,18,'https://twitter.com/ArtxeSprinkles','2024-01-07 01:54:38','2024-01-07 01:54:38'),(21,NULL,3,15,18,'https://twitter.com/onlysenpaii','2024-01-07 01:58:56','2024-01-07 01:58:56'),(22,NULL,3,15,22,'https://www.twitch.tv/onlysenpaii','2024-01-07 01:59:38','2024-01-07 01:59:38'),(23,NULL,3,16,18,'https://twitter.com/hony_beea','2024-01-07 02:09:21','2024-01-07 02:09:21'),(24,NULL,3,16,22,'https://www.twitch.tv/hony_beea','2024-01-07 02:09:38','2024-01-07 02:09:38'),(25,NULL,3,17,22,'https://www.twitch.tv/dad_knight','2024-01-07 02:14:06','2024-01-07 02:14:06'),(26,NULL,3,17,18,'https://twitter.com/spud_north','2024-01-07 02:28:21','2024-01-07 02:28:21'),(27,NULL,3,18,22,'https://www.twitch.tv/feydruidia','2024-01-10 10:00:50','2024-01-10 10:00:50'),(28,NULL,3,18,18,'https://twitter.com/FeyDruidia','2024-01-10 10:01:14','2024-01-10 10:01:14'),(29,NULL,3,4,18,'https://twitter.com/RaydelRestorer','2024-01-10 10:06:42','2024-01-10 10:06:42'),(30,NULL,3,4,22,'https://www.twitch.tv/raydel_r','2024-01-10 10:07:01','2024-01-10 10:07:01'),(31,NULL,3,19,18,'https://twitter.com/ReactiveCupid93/','2024-01-10 10:09:03','2024-01-10 10:09:03'),(32,NULL,3,20,18,'https://twitter.com/ZoeBaskerville','2024-01-10 10:24:16','2024-01-10 10:24:16'),(33,NULL,3,20,22,'https://www.twitch.tv/zoebaskervillevt','2024-01-10 10:24:35','2024-01-10 10:24:35'),(34,NULL,3,21,18,'https://twitter.com/Hexed_Maniac','2024-01-10 17:33:13','2024-01-10 17:33:13'),(35,NULL,3,21,22,'https://www.twitch.tv/the_dummiest_demon','2024-01-10 17:33:19','2024-01-10 17:33:19'),(36,NULL,3,24,18,'https://twitter.com/KadenceNashVT','2024-02-04 21:02:50','2024-02-04 21:02:50');
/*!40000 ALTER TABLE `contact_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_photo`
--

DROP TABLE IF EXISTS `contact_photo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_photo` (
  `contact_id` int(10) unsigned NOT NULL,
  `photo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `contact_photo_photo_id_foreign` (`photo_id`),
  KEY `contact_photo_contact_id_foreign` (`contact_id`),
  CONSTRAINT `contact_photo_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_photo_photo_id_foreign` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_photo`
--

LOCK TABLES `contact_photo` WRITE;
/*!40000 ALTER TABLE `contact_photo` DISABLE KEYS */;
INSERT INTO `contact_photo` VALUES (1,1,'2024-01-03 01:02:48','2024-01-03 01:02:48'),(2,2,'2024-01-03 01:04:03','2024-01-03 01:04:03'),(7,3,'2024-01-03 01:23:22','2024-01-03 01:23:22'),(6,4,'2024-01-03 01:24:55','2024-01-03 01:24:55'),(8,5,'2024-01-03 01:26:08','2024-01-03 01:26:08'),(5,6,'2024-01-03 01:28:18','2024-01-03 01:28:18'),(9,7,'2024-01-03 01:31:21','2024-01-03 01:31:21'),(10,8,'2024-01-03 01:34:44','2024-01-03 01:34:44'),(11,9,'2024-01-05 05:39:50','2024-01-05 05:39:50'),(12,10,'2024-01-05 05:57:43','2024-01-05 05:57:43'),(13,11,'2024-01-05 06:59:55','2024-01-05 06:59:55'),(14,12,'2024-01-07 01:55:46','2024-01-07 01:55:46'),(15,13,'2024-01-07 01:58:47','2024-01-07 01:58:47'),(16,14,'2024-01-07 02:01:53','2024-01-07 02:01:53'),(17,15,'2024-01-07 02:29:23','2024-01-07 02:29:23'),(18,16,'2024-01-10 10:02:50','2024-01-10 10:02:50'),(3,17,'2024-01-10 10:04:51','2024-01-10 10:04:51'),(4,18,'2024-01-10 10:05:47','2024-01-10 10:05:47'),(19,19,'2024-01-10 10:08:50','2024-01-10 10:08:50'),(20,20,'2024-01-10 10:25:32','2024-01-10 10:25:32'),(21,21,'2024-01-16 12:26:01','2024-01-16 12:26:01'),(22,22,'2024-01-20 16:26:24','2024-01-20 16:26:24'),(23,23,'2024-02-04 18:47:22','2024-02-04 18:47:22'),(24,24,'2024-02-04 21:01:56','2024-02-04 21:01:56');
/*!40000 ALTER TABLE `contact_photo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_tag`
--

DROP TABLE IF EXISTS `contact_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_tag` (
  `contact_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `contact_tag_account_id_foreign` (`account_id`),
  KEY `contact_tag_contact_id_foreign` (`contact_id`),
  KEY `contact_tag_tag_id_foreign` (`tag_id`),
  CONSTRAINT `contact_tag_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_tag_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_tag_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_tag`
--

LOCK TABLES `contact_tag` WRITE;
/*!40000 ALTER TABLE `contact_tag` DISABLE KEYS */;
INSERT INTO `contact_tag` VALUES (7,1,3,'2024-01-09 16:45:37','2024-01-09 16:45:37'),(9,1,3,'2024-01-10 10:03:48','2024-01-10 10:03:48'),(3,1,3,'2024-01-10 10:04:58','2024-01-10 10:04:58'),(19,1,3,'2024-01-10 10:08:56','2024-01-10 10:08:56'),(20,1,3,'2024-01-10 10:25:48','2024-01-10 10:25:48');
/*!40000 ALTER TABLE `contact_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `address_book_id` bigint(20) unsigned DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `nickname` varchar(255) DEFAULT NULL,
  `gender_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uuid` char(36) DEFAULT NULL,
  `is_starred` tinyint(1) NOT NULL DEFAULT 0,
  `is_partial` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `is_dead` tinyint(1) NOT NULL DEFAULT 0,
  `deceased_special_date_id` int(10) unsigned DEFAULT NULL,
  `deceased_reminder_id` int(10) unsigned DEFAULT NULL,
  `last_talked_to` date DEFAULT NULL,
  `stay_in_touch_frequency` int(11) DEFAULT NULL,
  `stay_in_touch_trigger_date` datetime DEFAULT NULL,
  `birthday_special_date_id` int(10) unsigned DEFAULT NULL,
  `birthday_reminder_id` int(10) unsigned DEFAULT NULL,
  `first_met_through_contact_id` int(11) DEFAULT NULL,
  `first_met_special_date_id` int(10) unsigned DEFAULT NULL,
  `first_met_reminder_id` int(10) unsigned DEFAULT NULL,
  `first_met_where` varchar(255) DEFAULT NULL,
  `first_met_additional_info` longtext DEFAULT NULL,
  `job` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `food_preferences` longtext DEFAULT NULL,
  `avatar_source` varchar(255) NOT NULL DEFAULT 'default',
  `avatar_gravatar_url` varchar(250) DEFAULT NULL,
  `avatar_adorable_uuid` char(36) DEFAULT NULL,
  `avatar_adorable_url` varchar(250) DEFAULT NULL,
  `avatar_default_url` varchar(250) DEFAULT NULL,
  `avatar_photo_id` int(10) unsigned DEFAULT NULL,
  `has_avatar` tinyint(1) NOT NULL DEFAULT 0,
  `avatar_external_url` varchar(400) DEFAULT NULL,
  `avatar_file_name` varchar(255) DEFAULT NULL,
  `avatar_location` varchar(255) NOT NULL DEFAULT 'local',
  `gravatar_url` varchar(255) DEFAULT NULL,
  `vcard` mediumtext DEFAULT NULL,
  `distant_etag` varchar(256) DEFAULT NULL,
  `last_consulted_at` timestamp NULL DEFAULT NULL,
  `number_of_views` int(11) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `default_avatar_color` varchar(255) NOT NULL,
  `has_avatar_bool` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `contacts_birthday_reminder_id_foreign` (`birthday_reminder_id`),
  KEY `contacts_first_met_reminder_id_foreign` (`first_met_reminder_id`),
  KEY `contacts_deceased_reminder_id_foreign` (`deceased_reminder_id`),
  KEY `contacts_birthday_special_date_id_foreign` (`birthday_special_date_id`),
  KEY `contacts_first_met_special_date_id_foreign` (`first_met_special_date_id`),
  KEY `contacts_deceased_special_date_id_foreign` (`deceased_special_date_id`),
  KEY `contacts_account_id_uuid_index` (`account_id`,`uuid`),
  KEY `contacts_avatar_photo_id_foreign` (`avatar_photo_id`),
  KEY `contacts_address_book_id_foreign` (`address_book_id`),
  CONSTRAINT `contacts_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_address_book_id_foreign` FOREIGN KEY (`address_book_id`) REFERENCES `addressbooks` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_avatar_photo_id_foreign` FOREIGN KEY (`avatar_photo_id`) REFERENCES `photos` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_birthday_reminder_id_foreign` FOREIGN KEY (`birthday_reminder_id`) REFERENCES `reminders` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_birthday_special_date_id_foreign` FOREIGN KEY (`birthday_special_date_id`) REFERENCES `special_dates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_deceased_reminder_id_foreign` FOREIGN KEY (`deceased_reminder_id`) REFERENCES `reminders` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_deceased_special_date_id_foreign` FOREIGN KEY (`deceased_special_date_id`) REFERENCES `special_dates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_first_met_reminder_id_foreign` FOREIGN KEY (`first_met_reminder_id`) REFERENCES `reminders` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contacts_first_met_special_date_id_foreign` FOREIGN KEY (`first_met_special_date_id`) REFERENCES `special_dates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,3,NULL,'Raeyamoon',NULL,NULL,'Raeya',8,NULL,'3b093b18-42d5-4227-89aa-c62cd6087695',1,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'d37ea91b-80bd-47f4-a3d7-4d679e1eb6fc','200/d37ea91b-80bd-47f4-a3d7-4d679e1eb6fc.png','avatars/bf79b693-c496-4f8f-ab80-1733857becfb.jpg?1704243198',1,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-05 06:00:20',6,NULL,'2024-01-03 00:53:01','2024-05-19 13:01:37','#fdb660',0),(2,3,NULL,'R3zzy_exe',NULL,NULL,'Rezzy',7,NULL,'c762be65-9d3f-4b60-b584-d5c5189dfd4a',0,0,1,0,NULL,NULL,NULL,NULL,NULL,8,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'469f213b-20d8-4972-ac2d-bb31443e6280','200/469f213b-20d8-4972-ac2d-bb31443e6280.png','avatars/f0061aa8-e995-45db-9885-75918ff586bd.jpg?1704243284',2,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-09 16:04:10',6,NULL,'2024-01-03 00:54:44','2024-05-19 13:01:37','#fdb660',0),(3,3,NULL,'TheForebringer',NULL,NULL,'Fore',7,NULL,'d856c2ff-b136-4bd8-b6a6-7a4d2ef4bd0f',0,0,1,0,NULL,NULL,NULL,NULL,NULL,6,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'7e3f7e4b-6e88-48be-a8e2-0e520aa33562','200/7e3f7e4b-6e88-48be-a8e2-0e520aa33562.png','avatars/bd777f56-729b-434c-a3c7-d4e8075ca360.jpg?1704244703',17,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:04:52',5,NULL,'2024-01-03 01:18:23','2024-05-19 13:01:37','#93521e',0),(4,3,NULL,'Raydel',NULL,NULL,'Raydel',9,NULL,'2d8719dc-4d51-42d2-81ed-5cd9761970f3',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'48eecd76-6b1f-4ab3-b315-d70072782f4c','200/48eecd76-6b1f-4ab3-b315-d70072782f4c.png','avatars/2cc8cd6b-292f-4649-bc3a-6abbdb4d1ac8.jpg?1704244718',18,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:05:47',2,NULL,'2024-01-03 01:18:38','2024-05-19 13:01:37','#709512',0),(5,3,NULL,'Himmie',NULL,NULL,'Himmers',8,NULL,'e2f0aa7c-89ee-49c5-b194-2ff09884997d',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'615bef2e-ce86-4b30-8d2a-8a13224fc8b1','200/615bef2e-ce86-4b30-8d2a-8a13224fc8b1.png','avatars/015ebe10-26d3-4db5-a317-9a04fb07db1c.jpg?1704244739',6,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-03 01:28:18',3,NULL,'2024-01-03 01:18:59','2024-05-19 13:01:37','#709512',0),(6,3,NULL,'Gilphchen',NULL,NULL,'Gilph',9,NULL,'fb90aaca-a974-4dc4-ac81-61c53a7f475c',0,0,1,0,NULL,NULL,NULL,NULL,NULL,11,6,7,NULL,NULL,NULL,'In Ryan\'s chat',NULL,NULL,NULL,'photo',NULL,'0a20adfb-80f2-42b6-a7c9-324f0bdaf5df','200/0a20adfb-80f2-42b6-a7c9-324f0bdaf5df.png','avatars/868f26ff-a823-44ca-b0d3-21bbf8e0d493.jpg?1704244767',4,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-17 07:04:27',6,NULL,'2024-01-03 01:19:27','2024-05-19 13:01:37','#ff9807',0),(7,3,NULL,'Ryan',NULL,NULL,'Ryan',7,NULL,'d1ec7385-5df1-438c-9bb3-0b04123527e8',1,0,1,0,NULL,NULL,NULL,NULL,NULL,9,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'689d03ae-76db-45bc-9272-e162b4d643b0','200/689d03ae-76db-45bc-9272-e162b4d643b0.png','avatars/33cfba7d-72b2-445d-b997-1e2261ff28fa.jpg?1704244867',3,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-09 16:45:29',6,NULL,'2024-01-03 01:21:07','2024-05-19 13:01:37','#b3d5fe',0),(8,3,NULL,'MiloAndVe',NULL,NULL,'Milo',7,NULL,'b7f727be-a7f4-4d30-8a4d-f2136f6133e5',1,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'61a10ea1-c5f7-491f-b47b-31d53c612633','200/61a10ea1-c5f7-491f-b47b-31d53c612633.png','avatars/3708dfe9-302d-4c98-8951-8454e76b429c.jpg?1704245145',5,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-05 06:00:13',3,NULL,'2024-01-03 01:25:45','2024-05-19 13:01:37','#b3d5fe',0),(9,3,NULL,'CandlesVt',NULL,NULL,'Candles',NULL,NULL,'57a13ec1-7ae4-40ce-b933-639caa8d6972',1,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'621f7455-4ca4-467f-927c-20ef288c2ed7','200/621f7455-4ca4-467f-927c-20ef288c2ed7.png','avatars/5496c613-22bd-4df6-953b-503d2bce3ced.jpg?1704245397',7,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:03:43',4,NULL,'2024-01-03 01:29:57','2024-05-19 13:01:37','#b3d5fe',0),(10,3,NULL,'RibstheGoblin',NULL,NULL,'Ribs',7,NULL,'70636e67-8b57-42ef-9587-2dcdeaa1b18c',0,0,1,0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'28e01542-a019-4efd-b381-c2ea31a3a18b','200/28e01542-a019-4efd-b381-c2ea31a3a18b.png','avatars/a5a58987-0040-432c-8d98-1eb739c6217d.jpg?1704245667',8,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-03 01:36:12',3,NULL,'2024-01-03 01:34:27','2024-05-19 13:01:37','#fdb660',0),(11,3,NULL,'Grumlarkin',NULL,NULL,NULL,9,NULL,'638f81fd-50e8-4919-91a3-5574eb4196ef',0,0,1,0,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'99067cc6-090e-436d-9d5e-7af0af380c37','200/99067cc6-090e-436d-9d5e-7af0af380c37.png','avatars/9e79a73f-bb57-45af-ac55-eca83cfd3a94.jpg?1704432958',9,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-05 05:56:39',4,NULL,'2024-01-05 05:35:58','2024-05-19 13:01:37','#fdb660',0),(12,3,NULL,'Oreami',NULL,NULL,NULL,7,NULL,'3277d8aa-f334-483b-8148-8956d468a6d2',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'57c70180-b2f1-4f5b-8d46-8917dddcddce','200/57c70180-b2f1-4f5b-8d46-8917dddcddce.png','avatars/1e874ed7-4310-4b23-be01-c07cc9712cc9.jpg?1704434223',10,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-05 05:57:43',2,NULL,'2024-01-05 05:57:03','2024-05-19 13:01:37','#e5e5cd',0),(13,3,NULL,'Hihsasuke',NULL,NULL,'Sookie',7,NULL,'8a81249f-5829-4650-99b9-36c518eac3e9',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'9dba76d6-60fe-49bd-b68e-1cc09bc2d3eb','200/9dba76d6-60fe-49bd-b68e-1cc09bc2d3eb.png','avatars/746fc795-e78b-4340-8e51-d4f49dcbf8e3.jpg?1704435115',11,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-05 06:59:55',2,NULL,'2024-01-05 06:11:55','2024-05-19 13:01:37','#fdb660',0),(14,3,NULL,'ArtxesSprinkles',NULL,NULL,'Art',7,NULL,'5cf53069-1469-43f1-97d0-e094ff0d1dbe',0,0,1,0,NULL,NULL,NULL,NULL,NULL,3,NULL,4,NULL,NULL,NULL,'Was collabbing with Raydel',NULL,NULL,NULL,'photo',NULL,'75822cb4-2720-40a7-ab7c-fd90efac66b3','200/75822cb4-2720-40a7-ab7c-fd90efac66b3.png','avatars/743ecfd5-dc4d-4d62-b2bb-3d2f94fb4160.jpg?1704592421',12,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-07 01:55:46',4,NULL,'2024-01-07 01:53:40','2024-05-19 13:01:37','#e5e5cd',0),(15,3,NULL,'OnlySenpaii',NULL,NULL,'Senpaii',7,NULL,'9809ac06-cb39-4835-b469-ff87989e6507',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,'Collab with Beea',NULL,NULL,NULL,'photo',NULL,'6b06e026-b55f-40f9-95e7-861a13c4ee19','200/6b06e026-b55f-40f9-95e7-861a13c4ee19.png','avatars/56bd1ba5-1b36-4ea4-8fc0-a88281022d19.jpg?1704592688',13,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-07 02:08:28',4,NULL,'2024-01-07 01:58:08','2024-05-19 13:01:37','#ff9807',0),(16,3,NULL,'Hony_Beea',NULL,NULL,'Beea',9,NULL,'66f35ae4-215f-4c54-a54b-117e6b9f7198',0,0,1,0,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'3b0479ef-fb1a-4c11-9372-b1a9d64c5b87','200/3b0479ef-fb1a-4c11-9372-b1a9d64c5b87.png','avatars/b31ef81c-e03e-4c1b-9ca0-343568cbcb12.jpg?1704592832',14,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-07 02:07:07',3,NULL,'2024-01-07 02:00:32','2024-05-19 13:01:37','#5f479a',0),(17,3,NULL,'Dad_Knight',NULL,NULL,'Dad',7,NULL,'ea799da1-4b32-4958-806f-161610da588d',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,'Met through Beea\'s chat',NULL,NULL,NULL,'photo',NULL,'532149d0-9654-48d5-b525-5ad18944ba04','200/532149d0-9654-48d5-b525-5ad18944ba04.png','avatars/a2ea9ef7-1f30-418c-b3ec-a2fe9e689cdc.jpg?1704593608',15,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-02-02 01:12:25',9,NULL,'2024-01-07 02:13:28','2024-05-19 13:01:37','#5f479a',0),(18,3,NULL,'Feydruidia',NULL,NULL,'Fey',8,NULL,'1cc11a72-fb2f-4a7d-92e9-81b6316f5662',0,0,1,0,NULL,NULL,NULL,NULL,NULL,10,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'076426af-680c-4b63-8441-a5c1070c3e17','200/076426af-680c-4b63-8441-a5c1070c3e17.png','avatars/8d89628c-ec73-474f-bcd1-a040b45368a6.jpg?1704880754',16,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:02:50',3,NULL,'2024-01-10 09:59:14','2024-05-19 13:01:37','#bd5067',0),(19,3,NULL,'ReactiveCupid93',NULL,NULL,NULL,NULL,NULL,'cdc25400-b813-420e-a9d2-22f3857bf74d',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'30bdf8d1-07cd-4b65-96df-69f69846d0bb','200/30bdf8d1-07cd-4b65-96df-69f69846d0bb.png','avatars/e8118e7e-d350-428a-a43b-2913a802cfd6.jpg?1704881294',19,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:08:50',2,NULL,'2024-01-10 10:08:14','2024-05-19 13:01:37','#ff9807',0),(20,3,NULL,'Zoebaskervillevt',NULL,NULL,'Zoe',8,NULL,'6ff99d5f-6103-4d56-9304-5813dcd3613d',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'e7ee132e-5cef-4165-804e-1afd02d09d35','200/e7ee132e-5cef-4165-804e-1afd02d09d35.png','avatars/9a528bd0-5b44-4d15-99bc-a0aec7e78344.jpg?1704882231',20,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-10 10:25:32',2,NULL,'2024-01-10 10:23:51','2024-05-19 13:01:37','#bd5067',0),(21,3,NULL,'The_Dummiest_Demon',NULL,NULL,'Hex',8,NULL,'0a9c713b-1321-4a4b-ac2b-cd687ae0e409',0,0,1,0,NULL,NULL,NULL,NULL,NULL,13,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'87b4e751-8c7f-442f-9da9-1c8deea6459b','200/87b4e751-8c7f-442f-9da9-1c8deea6459b.png','avatars/420bbe8c-7d07-4285-91ae-5057bff1268a.jpg?1704907901',21,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-16 12:26:01',6,NULL,'2024-01-10 17:31:41','2024-05-19 13:01:37','#b3d5fe',0),(22,3,NULL,'ExEro',NULL,NULL,'Henry',7,NULL,'d84a6890-0e4f-4fd1-9178-920bda4dfbd0',0,0,1,0,NULL,NULL,NULL,NULL,NULL,14,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'0efbe802-72a1-43c2-b56a-bff83dd80604','200/0efbe802-72a1-43c2-b56a-bff83dd80604.png','avatars/88feb418-5f08-4a1c-9ce9-60be45d96598.jpg?1705764693',22,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-01-21 13:51:14',4,NULL,'2024-01-20 15:31:33','2024-05-19 13:01:37','#5f479a',0),(23,3,NULL,'LuceBreaks',NULL,NULL,'Luce',8,NULL,'a397bf08-ea80-4af0-ae17-f4113a3c76a9',0,0,1,0,NULL,NULL,NULL,NULL,NULL,15,10,24,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'a96ded29-fa82-4dc5-9fa7-35030feeacfb','200/a96ded29-fa82-4dc5-9fa7-35030feeacfb.png','avatars/4a32e728-1757-4d18-8fc2-e9ee4d91d519.jpg?1707072424',23,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-02-04 21:03:18',4,NULL,'2024-02-04 18:47:04','2024-05-19 13:01:37','#bd5067',0),(24,3,NULL,'PartTimeKadence',NULL,NULL,'Kadence',NULL,NULL,'04822338-cb60-40ef-b7c4-d806e93d070e',0,0,1,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'photo',NULL,'0cf4029c-6e4a-4c03-95ef-59139244af26','200/0cf4029c-6e4a-4c03-95ef-59139244af26.png','avatars/43c7b3a9-5b11-4b0b-b225-2af5cce8d57c.jpg?1707076421',24,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-02-04 21:01:57',2,NULL,'2024-02-04 19:53:41','2024-05-19 13:01:37','#e5e5cd',0),(25,3,NULL,'Max',NULL,NULL,'Max',8,NULL,'1f5ab7f8-eedd-42f3-b7ba-9d6974ff7f1e',1,0,1,0,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'default',NULL,'3aadc2f9-8d25-4d18-9aba-d199e1397660','200/3aadc2f9-8d25-4d18-9aba-d199e1397660.png','avatars/1f5ab7f8-eedd-42f3-b7ba-9d6974ff7f1e.jpg?1716127435',NULL,0,NULL,NULL,'local',NULL,NULL,NULL,'2024-05-21 14:48:53',4,NULL,'2024-05-19 13:03:55','2024-05-19 13:04:21','#b3d5fe',0);
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations`
--

DROP TABLE IF EXISTS `conversations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `contact_field_type_id` int(10) unsigned NOT NULL,
  `happened_at` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversations_contact_id_foreign` (`contact_id`),
  KEY `conversations_contact_field_type_id_foreign` (`contact_field_type_id`),
  KEY `conversations_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `conversations_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conversations_contact_field_type_id_foreign` FOREIGN KEY (`contact_field_type_id`) REFERENCES `contact_field_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conversations_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations`
--

LOCK TABLES `conversations` WRITE;
/*!40000 ALTER TABLE `conversations` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crons`
--

DROP TABLE IF EXISTS `crons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `command` varchar(255) NOT NULL,
  `last_run` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `crons_command_unique` (`command`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crons`
--

LOCK TABLES `crons` WRITE;
/*!40000 ALTER TABLE `crons` DISABLE KEYS */;
/*!40000 ALTER TABLE `crons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `symbol` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'CAD','Canadian Dollar','$',NULL,NULL),(2,'USD','US Dollar','$',NULL,NULL),(3,'GBP','British Pound','£',NULL,NULL),(4,'EUR','Euro','€',NULL,NULL),(5,'RUB','Russian Ruble','₽',NULL,NULL),(6,'ZAR','South African Rand','R ',NULL,NULL),(7,'DKK','Danish krone','kr.',NULL,NULL),(8,'INR','Indian rupee','₹',NULL,NULL),(9,'BRL','Brazilian Real','R$',NULL,NULL),(10,'CHF','Swiss CHF','CHF',NULL,NULL),(11,'AED','Emirati Dirham','.د.ب',NULL,NULL),(12,'AFN','Afghan Afghani','؋',NULL,NULL),(13,'ALL','Albanian lek','lek',NULL,NULL),(14,'AMD','Armenian dram','',NULL,NULL),(15,'ANG','Dutch Guilder','ƒ',NULL,NULL),(16,'AOA','Angolan Kwanza','Kz',NULL,NULL),(17,'ARS','Argentine peso','$',NULL,NULL),(18,'AUD','Australian Dollar','$',NULL,NULL),(19,'AWG','Arubin florin','ƒ',NULL,NULL),(20,'AZN','Azerbaijani manat','ман',NULL,NULL),(21,'BAM','Bosnian Convertible Marka','KM',NULL,NULL),(22,'BBD','Barbadian dollar','$',NULL,NULL),(23,'BDT','Bangladeshi Taka','Tk',NULL,NULL),(24,'BGN','Bulgarian lev','лв',NULL,NULL),(25,'BHD','Bahraini Dinar','.د.ب or BD',NULL,NULL),(26,'BIF','Burundian Franc','',NULL,NULL),(27,'BMD','Bermudian dollar','$',NULL,NULL),(28,'BND','Bruneian Dollar','$',NULL,NULL),(29,'BOB','Bolivian Boliviano','$b',NULL,NULL),(30,'BSD','Bahamian dollar','B$',NULL,NULL),(31,'BTN','Bhutanese Ngultrum','Nu.',NULL,NULL),(32,'BWP','Botswana Pula','P',NULL,NULL),(33,'BYR','Belarusian ruble','р',NULL,NULL),(34,'BZD','Belize dollar','BZ$',NULL,NULL),(35,'CLP','Chilean Peso','$',NULL,NULL),(36,'CNY','Yuan or chinese renminbi','¥',NULL,NULL),(37,'COP','Colombian peso','$',NULL,NULL),(38,'CRC','Costa Rican colón','₡',NULL,NULL),(39,'CUC','Cuban convertible peso','$',NULL,NULL),(40,'CUP','Cuban peso','₱',NULL,NULL),(41,'CVE','Cape Verdean Escudo','$',NULL,NULL),(42,'CZK','Czech koruna','Kč',NULL,NULL),(43,'DJF','Djiboutian Franc','fdj',NULL,NULL),(44,'DOP','Dominican peso','$',NULL,NULL),(45,'DZD','Algerian Dinar','جد',NULL,NULL),(46,'EGP','Egyptian Pound','£ ',NULL,NULL),(47,'ERN','Eritrean nakfa','ናቕፋ',NULL,NULL),(48,'ETB','Ethiopian Birr','Br',NULL,NULL),(49,'FJD','Fijian dollar','$',NULL,NULL),(50,'FKP','Falkland Island Pound','£',NULL,NULL),(51,'GEL','Georgian lari','ლ',NULL,NULL),(52,'GHS','Ghanaian Cedi','GH¢',NULL,NULL),(53,'GIP','Gibraltar pound','£',NULL,NULL),(54,'GMD','Gambian dalasi','',NULL,NULL),(55,'GNF','Guinean Franc','',NULL,NULL),(56,'GTQ','Guatemalan Quetzal','Q',NULL,NULL),(57,'GYD','Guyanese dollar','$',NULL,NULL),(58,'HKD','Hong Kong dollar','HK$',NULL,NULL),(59,'HNL','Honduran lempira','L',NULL,NULL),(60,'HRK','Croatian kuna','kn',NULL,NULL),(61,'HTG','Haitian gourde','G',NULL,NULL),(62,'HUF','Hungarian forint','Ft',NULL,NULL),(63,'IDR','Indonesian Rupiah','Rp',NULL,NULL),(64,'ILS','Israeli Shekel','₪',NULL,NULL),(65,'IQD','Iraqi Dinar','ع.د',NULL,NULL),(66,'IRR','Iranian Rial','',NULL,NULL),(67,'ISK','Icelandic Krona','kr',NULL,NULL),(68,'JMD','Jamaican dollar','J$',NULL,NULL),(69,'JOD','Jordanian Dinar','',NULL,NULL),(70,'JPY','Japanese yen','¥',NULL,NULL),(71,'KES','Kenyan Shilling','KSh',NULL,NULL),(72,'KGS','Kyrgyzstani som','лв',NULL,NULL),(73,'KHR','Cambodian Riel','៛',NULL,NULL),(74,'KMF','Comoran Franc','',NULL,NULL),(75,'KPW','North Korean won','₩',NULL,NULL),(76,'KRW','South Korean won','₩',NULL,NULL),(77,'KWD','Kuwaiti Dinar','ك',NULL,NULL),(78,'KYD','Caymanian Dollar','$',NULL,NULL),(79,'KZT','Kazakhstani tenge','₸',NULL,NULL),(80,'LAK','Lao or Laotian Kip','₭',NULL,NULL),(81,'LBP','Lebanese Pound','ل.ل',NULL,NULL),(82,'LKR','Sri Lankan Rupee','Rs',NULL,NULL),(83,'LRD','Liberian Dollar','$',NULL,NULL),(84,'LSL','Lesotho loti','L or M',NULL,NULL),(85,'LTL','Lithuanian litas','Lt',NULL,NULL),(86,'LYD','Libyan Dinar',' د.ل',NULL,NULL),(87,'MAD','Moroccan Dirham','م.د.',NULL,NULL),(88,'MDL','Moldovan Leu','L',NULL,NULL),(89,'MGA','Malagasy Ariary','Ar',NULL,NULL),(90,'MKD','Macedonian Denar','ден',NULL,NULL),(91,'MMK','Burmese Kyat','K',NULL,NULL),(92,'MNT','Mongolian Tughrik','₮',NULL,NULL),(93,'MOP','Macau Pataca','MOP$',NULL,NULL),(94,'MRO','Mauritanian Ouguiya','UM',NULL,NULL),(95,'MUR','Mauritian rupee','Rs',NULL,NULL),(96,'MVR','Maldivian Rufiyaa','rf',NULL,NULL),(97,'MWK','Malawian Kwacha','MK',NULL,NULL),(98,'MXN','Mexico Peso','$',NULL,NULL),(99,'MYR','Malaysian Ringgit','RM',NULL,NULL),(100,'MZN','Mozambican Metical','MT',NULL,NULL),(101,'NAD','Namibian Dollar','$',NULL,NULL),(102,'NGN','Nigerian Naira','₦',NULL,NULL),(103,'NIO','Nicaraguan córdoba','C$',NULL,NULL),(104,'NOK','Norwegian krone','kr',NULL,NULL),(105,'NPR','Nepalese Rupee','Rs',NULL,NULL),(106,'NZD','New Zealand Dollar','$',NULL,NULL),(107,'OMR','Omani Rial','ع.ر.',NULL,NULL),(108,'PAB','Balboa panamérn','B/',NULL,NULL),(109,'PEN','Peruvian nuevo sol','S/',NULL,NULL),(110,'PGK','Papua New Guinean Kina','K',NULL,NULL),(111,'PHP','Philippine Peso','₱',NULL,NULL),(112,'PKR','Pakistani Rupee','Rs',NULL,NULL),(113,'PLN','Polish złoty','zł',NULL,NULL),(114,'PYG','Paraguayan guarani','₲',NULL,NULL),(115,'QAR','Qatari Riyal','ق.ر ',NULL,NULL),(116,'RON','Romanian leu','lei',NULL,NULL),(117,'RSD','Serbian Dinar','РСД',NULL,NULL),(118,'RWF','Rwandan franc','FRw, RF, R₣',NULL,NULL),(119,'SAR','Saudi Arabian Riyal','ر.س',NULL,NULL),(120,'SBD','Solomon Islander Dollar','SI$',NULL,NULL),(121,'SCR','Seychellois Rupee','Rs',NULL,NULL),(122,'SDG','Sudanese Pound','',NULL,NULL),(123,'SEK','Swedish krona','kr',NULL,NULL),(124,'SGD','Singapore Dollar','$',NULL,NULL),(125,'SLL','Sierra Leonean Leone','Le',NULL,NULL),(126,'SOS','Somali Shilling','S',NULL,NULL),(127,'SRD','Surinamese dollar','$',NULL,NULL),(128,'SSP','South Sudanese pound','£',NULL,NULL),(129,'SYP','Syrian Pound','£',NULL,NULL),(130,'SZL','Swazi Lilangeni','L or E',NULL,NULL),(131,'THB','Thai Baht','฿',NULL,NULL),(132,'TJS','Tajikistani somoni','',NULL,NULL),(133,'TMT','Turkmenistan manat','T',NULL,NULL),(134,'TND','Tunisian Dinar','',NULL,NULL),(135,'TOP','Tongan Pa\'anga','T$',NULL,NULL),(136,'TRY','Turkish Lira','',NULL,NULL),(137,'TTD','Trinidadian dollar','TT$',NULL,NULL),(138,'TWD','Taiwan New Dollar','NT$',NULL,NULL),(139,'TZS','Tanzanian Shilling','Sh',NULL,NULL),(140,'UAH','Ukrainian Hryvnia','₴',NULL,NULL),(141,'UGX','Ugandan Shilling','USh',NULL,NULL),(142,'UYU','Uruguayan peso','$U',NULL,NULL),(143,'UZS','Uzbekistani som','лв',NULL,NULL),(144,'VEF','Venezuelan bolivar','Bs',NULL,NULL),(145,'VND','Vietnamese Dong','₫',NULL,NULL),(146,'VUV','Ni-Vanuatu Vatu','VT',NULL,NULL),(147,'WST','Samoan Tālā','$',NULL,NULL),(148,'XCD','East Caribbean dollar','EC$',NULL,NULL),(149,'XOF','CFA Franc','',NULL,NULL),(150,'XPF','CFP Franc','',NULL,NULL),(151,'YER','Yemeni Rial','',NULL,NULL),(152,'ZMW','Zambian Kwacha','ZMK',NULL,NULL),(153,'ZWD','Zimbabwean Dollar','Z$',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `days`
--

DROP TABLE IF EXISTS `days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `days` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `rate` int(11) NOT NULL,
  `comment` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `days_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `days_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `days`
--

LOCK TABLES `days` WRITE;
/*!40000 ALTER TABLE `days` DISABLE KEYS */;
/*!40000 ALTER TABLE `days` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `debts`
--

DROP TABLE IF EXISTS `debts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `debts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `in_debt` varchar(255) NOT NULL DEFAULT 'no',
  `status` varchar(255) NOT NULL DEFAULT 'inprogress',
  `amount` int(11) NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `reason` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `debts_contact_id_foreign` (`contact_id`),
  KEY `debts_currency_id_foreign` (`currency_id`),
  KEY `debts_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `debts_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `debts_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `debts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `debts`
--

LOCK TABLES `debts` WRITE;
/*!40000 ALTER TABLE `debts` DISABLE KEYS */;
/*!40000 ALTER TABLE `debts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_activity_type_categories`
--

DROP TABLE IF EXISTS `default_activity_type_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_activity_type_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `translation_key` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_activity_type_categories`
--

LOCK TABLES `default_activity_type_categories` WRITE;
/*!40000 ALTER TABLE `default_activity_type_categories` DISABLE KEYS */;
INSERT INTO `default_activity_type_categories` VALUES (1,'simple_activities','2024-01-02 23:40:49','2024-01-02 23:40:49'),(2,'sport','2024-01-02 23:40:49','2024-01-02 23:40:49'),(3,'food','2024-01-02 23:40:49','2024-01-02 23:40:49'),(4,'cultural_activities','2024-01-02 23:40:49','2024-01-02 23:40:49');
/*!40000 ALTER TABLE `default_activity_type_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_activity_types`
--

DROP TABLE IF EXISTS `default_activity_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_activity_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `default_activity_type_category_id` int(11) NOT NULL,
  `translation_key` varchar(255) NOT NULL,
  `location_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_activity_types`
--

LOCK TABLES `default_activity_types` WRITE;
/*!40000 ALTER TABLE `default_activity_types` DISABLE KEYS */;
INSERT INTO `default_activity_types` VALUES (1,1,'just_hung_out','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(2,1,'watched_movie_at_home','my_place','2024-01-02 23:40:49','2024-01-02 23:40:49'),(3,1,'talked_at_home','my_place','2024-01-02 23:40:49','2024-01-02 23:40:49'),(4,2,'did_sport_activities_together','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(5,3,'ate_at_his_place','his_place','2024-01-02 23:40:49','2024-01-02 23:40:49'),(6,3,'went_bar','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(7,3,'ate_at_home','my_place','2024-01-02 23:40:49','2024-01-02 23:40:49'),(8,3,'picnicked','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(9,3,'ate_restaurant','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(10,4,'went_theater','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(11,4,'went_concert','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(12,4,'went_play','outside','2024-01-02 23:40:49','2024-01-02 23:40:49'),(13,4,'went_museum','outside','2024-01-02 23:40:49','2024-01-02 23:40:49');
/*!40000 ALTER TABLE `default_activity_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_contact_field_types`
--

DROP TABLE IF EXISTS `default_contact_field_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_contact_field_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `fontawesome_icon` varchar(255) DEFAULT NULL,
  `protocol` varchar(255) DEFAULT NULL,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `delible` tinyint(1) NOT NULL DEFAULT 1,
  `type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_contact_field_types`
--

LOCK TABLES `default_contact_field_types` WRITE;
/*!40000 ALTER TABLE `default_contact_field_types` DISABLE KEYS */;
INSERT INTO `default_contact_field_types` VALUES (1,'Email','fa fa-envelope-open-o','mailto:',1,0,'email',NULL,NULL),(2,'Phone','fa fa-volume-control-phone','tel:',1,0,'phone',NULL,NULL),(3,'Facebook','fa fa-facebook-official','https://facebook.com/',1,1,NULL,NULL,NULL),(4,'Twitter','fa fa-twitter-square',NULL,1,1,NULL,NULL,NULL),(5,'Whatsapp','fa fa-whatsapp','https://wa.me/',1,1,NULL,NULL,NULL),(6,'Telegram','fa fa-telegram','telegram:',1,1,NULL,NULL,NULL),(7,'LinkedIn','fa fa-linkedin-square',NULL,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `default_contact_field_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_contact_modules`
--

DROP TABLE IF EXISTS `default_contact_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_contact_modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `translation_key` varchar(255) NOT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_contact_modules`
--

LOCK TABLES `default_contact_modules` WRITE;
/*!40000 ALTER TABLE `default_contact_modules` DISABLE KEYS */;
INSERT INTO `default_contact_modules` VALUES (1,'love_relationships','app.relationship_type_group_love',0,1,1,NULL,NULL),(2,'family_relationships','app.relationship_type_group_family',0,1,1,NULL,NULL),(3,'other_relationships','app.relationship_type_group_other',0,1,1,NULL,NULL),(4,'pets','people.pets_title',0,1,1,NULL,NULL),(5,'contact_information','people.section_contact_information',0,1,1,NULL,NULL),(6,'addresses','people.contact_address_title',0,1,1,NULL,NULL),(7,'how_you_met','people.introductions_sidebar_title',0,1,1,NULL,NULL),(8,'work_information','people.work_information',0,1,1,NULL,NULL),(9,'food_preferences','people.food_preferences_title',0,1,1,NULL,NULL),(10,'notes','people.section_personal_notes',0,1,1,NULL,NULL),(11,'phone_calls','people.call_title',0,1,1,NULL,NULL),(12,'activities','people.activity_title',0,1,1,NULL,NULL),(13,'reminders','people.section_personal_reminders',0,1,1,NULL,NULL),(14,'tasks','people.section_personal_tasks',0,1,1,NULL,NULL),(15,'gifts','people.gifts_title',0,1,1,NULL,NULL),(16,'debts','people.debt_title',0,1,1,NULL,NULL),(17,'conversations','people.conversation_list_title',0,1,1,NULL,NULL),(18,'documents','people.document_list_title',0,1,1,NULL,NULL);
/*!40000 ALTER TABLE `default_contact_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_life_event_categories`
--

DROP TABLE IF EXISTS `default_life_event_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_life_event_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `translation_key` varchar(255) NOT NULL,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_life_event_categories`
--

LOCK TABLES `default_life_event_categories` WRITE;
/*!40000 ALTER TABLE `default_life_event_categories` DISABLE KEYS */;
INSERT INTO `default_life_event_categories` VALUES (1,'work_education',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(2,'family_relationships',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(3,'home_living',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(4,'health_wellness',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(5,'travel_experiences',1,'2024-01-02 23:40:50','2024-01-02 23:40:50');
/*!40000 ALTER TABLE `default_life_event_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_life_event_types`
--

DROP TABLE IF EXISTS `default_life_event_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_life_event_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `default_life_event_category_id` int(10) unsigned NOT NULL,
  `translation_key` varchar(255) NOT NULL,
  `specific_information_structure` text DEFAULT NULL,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `default_life_event_types_default_life_event_category_id_foreign` (`default_life_event_category_id`),
  CONSTRAINT `default_life_event_types_default_life_event_category_id_foreign` FOREIGN KEY (`default_life_event_category_id`) REFERENCES `default_life_event_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_life_event_types`
--

LOCK TABLES `default_life_event_types` WRITE;
/*!40000 ALTER TABLE `default_life_event_types` DISABLE KEYS */;
INSERT INTO `default_life_event_types` VALUES (1,1,'new_job','{\"employer\": {\"type\": \"string\", \"value\": \"\"}, \"job_title\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(2,1,'retirement','{\"profession\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(3,1,'new_school','{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(4,1,'study_abroad','{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(5,1,'volunteer_work','{\"organization\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(6,1,'published_book_or_paper','{\"full_citation\": {\"type\": \"string\", \"value\": \"\"}, \"url\": {\"type\": \"string\", \"value\": \"\"}, \"citation\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(7,1,'military_service','{\"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"branch\": {\"type\": \"string\", \"value\": \"\"}, \"division\": {\"type\": \"string\", \"value\": \"\"}, \"country\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(8,2,'new_relationship',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(9,2,'engagement','{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(10,2,'marriage','{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(11,2,'anniversary',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(12,2,'expecting_a_baby','{\"contact_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date\": {\"type\": \"date\", \"value\": \"\"}, \"expected_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_gender\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(13,2,'new_child',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(14,2,'new_family_member',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(15,2,'new_pet',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(16,2,'end_of_relationship','{\"breakup_reason\": {\"type\": \"string\", \"value\": \"\"}, \"who_broke_up_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(17,2,'loss_of_a_loved_one',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(18,3,'moved','{\"where_to\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(19,3,'bought_a_home','{\"address\": {\"type\": \"string\", \"value\": \"\"}, \"estimated_value\": {\"type\": \"number\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(20,3,'home_improvement',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(21,3,'holidays','{\"where\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(22,3,'new_vehicle','{\"type\": {\"type\": \"string\", \"value\": \"\"}, \"model\": {\"type\": \"string\", \"value\": \"\"}, \"model_year\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(23,3,'new_roommate','{\"contact_id\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(24,4,'overcame_an_illness',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(25,4,'quit_a_habit',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(26,4,'new_eating_habits',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(27,4,'weight_loss','{\"amount\": {\"type\": \"string\", \"value\": \"\"}, \"unit\": {\"type\": \"string\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(28,4,'wear_glass_or_contact',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(29,4,'broken_bone',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(30,4,'removed_braces',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(31,4,'surgery','{\"nature\": {\"type\": \"string\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date_out_of_hospital_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(32,4,'dentist',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(33,5,'new_sport',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(34,5,'new_hobby',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(35,5,'new_instrument',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(36,5,'new_language',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(37,5,'tattoo_or_piercing',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(38,5,'new_license',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(39,5,'travel','{\"visited_place\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}',1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(40,5,'achievement_or_award',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(41,5,'changed_beliefs',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(42,5,'first_word',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50'),(43,5,'first_kiss',NULL,1,'2024-01-02 23:40:50','2024-01-02 23:40:50');
/*!40000 ALTER TABLE `default_life_event_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_relationship_type_groups`
--

DROP TABLE IF EXISTS `default_relationship_type_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_relationship_type_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_relationship_type_groups`
--

LOCK TABLES `default_relationship_type_groups` WRITE;
/*!40000 ALTER TABLE `default_relationship_type_groups` DISABLE KEYS */;
INSERT INTO `default_relationship_type_groups` VALUES (1,'love',0,1,NULL,NULL),(2,'family',0,1,NULL,NULL),(3,'friend',0,1,NULL,NULL),(4,'work',0,1,NULL,NULL);
/*!40000 ALTER TABLE `default_relationship_type_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_relationship_types`
--

DROP TABLE IF EXISTS `default_relationship_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_relationship_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `name_reverse_relationship` varchar(255) NOT NULL,
  `relationship_type_group_id` int(11) NOT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `migrated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `default_relationship_types_migrated_index` (`migrated`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_relationship_types`
--

LOCK TABLES `default_relationship_types` WRITE;
/*!40000 ALTER TABLE `default_relationship_types` DISABLE KEYS */;
INSERT INTO `default_relationship_types` VALUES (1,'partner','partner',1,0,1,NULL,NULL),(2,'spouse','spouse',1,0,1,NULL,NULL),(3,'date','date',1,0,1,NULL,NULL),(4,'lover','lover',1,0,1,NULL,NULL),(5,'inlovewith','lovedby',1,0,1,NULL,NULL),(6,'lovedby','inlovewith',1,0,1,NULL,NULL),(7,'ex','ex',1,0,1,NULL,NULL),(8,'parent','child',2,0,1,NULL,NULL),(9,'child','parent',2,0,1,NULL,NULL),(10,'sibling','sibling',2,0,1,NULL,NULL),(11,'grandparent','grandchild',2,0,1,NULL,NULL),(12,'grandchild','grandparent',2,0,1,NULL,NULL),(13,'uncle','nephew',2,0,1,NULL,NULL),(14,'nephew','uncle',2,0,1,NULL,NULL),(15,'cousin','cousin',2,0,1,NULL,NULL),(16,'godfather','godson',2,0,1,NULL,NULL),(17,'godson','godfather',2,0,1,NULL,NULL),(18,'friend','friend',3,0,1,NULL,NULL),(19,'bestfriend','bestfriend',3,0,1,NULL,NULL),(20,'colleague','colleague',4,0,1,NULL,NULL),(21,'boss','subordinate',4,0,1,NULL,NULL),(22,'subordinate','boss',4,0,1,NULL,NULL),(23,'mentor','protege',4,0,1,NULL,NULL),(24,'protege','mentor',4,0,1,NULL,NULL),(25,'ex_husband','ex_husband',1,0,1,NULL,NULL),(26,'stepparent','stepchild',2,0,1,NULL,NULL),(27,'stepchild','stepparent',2,0,1,NULL,NULL);
/*!40000 ALTER TABLE `default_relationship_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documents`
--

DROP TABLE IF EXISTS `documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `original_filename` varchar(255) NOT NULL,
  `new_filename` varchar(255) NOT NULL,
  `filesize` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `number_of_downloads` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_contact_id_foreign` (`contact_id`),
  KEY `documents_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `documents_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `documents_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documents`
--

LOCK TABLES `documents` WRITE;
/*!40000 ALTER TABLE `documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emotion_activity`
--

DROP TABLE IF EXISTS `emotion_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emotion_activity` (
  `account_id` int(10) unsigned NOT NULL,
  `activity_id` int(10) unsigned NOT NULL,
  `emotion_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `emotion_activity_account_id_foreign` (`account_id`),
  KEY `emotion_activity_activity_id_foreign` (`activity_id`),
  KEY `emotion_activity_emotion_id_foreign` (`emotion_id`),
  CONSTRAINT `emotion_activity_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotion_activity_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotion_activity_emotion_id_foreign` FOREIGN KEY (`emotion_id`) REFERENCES `emotions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emotion_activity`
--

LOCK TABLES `emotion_activity` WRITE;
/*!40000 ALTER TABLE `emotion_activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `emotion_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emotion_call`
--

DROP TABLE IF EXISTS `emotion_call`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emotion_call` (
  `account_id` int(10) unsigned NOT NULL,
  `call_id` int(10) unsigned NOT NULL,
  `emotion_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `emotion_call_account_id_foreign` (`account_id`),
  KEY `emotion_call_call_id_foreign` (`call_id`),
  KEY `emotion_call_emotion_id_foreign` (`emotion_id`),
  KEY `emotion_call_contact_id_foreign` (`contact_id`),
  CONSTRAINT `emotion_call_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotion_call_call_id_foreign` FOREIGN KEY (`call_id`) REFERENCES `calls` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotion_call_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotion_call_emotion_id_foreign` FOREIGN KEY (`emotion_id`) REFERENCES `emotions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emotion_call`
--

LOCK TABLES `emotion_call` WRITE;
/*!40000 ALTER TABLE `emotion_call` DISABLE KEYS */;
/*!40000 ALTER TABLE `emotion_call` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emotions`
--

DROP TABLE IF EXISTS `emotions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emotions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emotion_primary_id` int(10) unsigned NOT NULL,
  `emotion_secondary_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emotions_emotion_primary_id_foreign` (`emotion_primary_id`),
  KEY `emotions_emotion_secondary_id_foreign` (`emotion_secondary_id`),
  CONSTRAINT `emotions_emotion_primary_id_foreign` FOREIGN KEY (`emotion_primary_id`) REFERENCES `emotions_primary` (`id`) ON DELETE CASCADE,
  CONSTRAINT `emotions_emotion_secondary_id_foreign` FOREIGN KEY (`emotion_secondary_id`) REFERENCES `emotions_secondary` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emotions`
--

LOCK TABLES `emotions` WRITE;
/*!40000 ALTER TABLE `emotions` DISABLE KEYS */;
INSERT INTO `emotions` VALUES (1,1,1,'adoration',NULL,NULL),(2,1,1,'affection',NULL,NULL),(3,1,1,'love',NULL,NULL),(4,1,1,'fondness',NULL,NULL),(5,1,1,'liking',NULL,NULL),(6,1,1,'attraction',NULL,NULL),(7,1,1,'caring',NULL,NULL),(8,1,1,'tenderness',NULL,NULL),(9,1,1,'compassion',NULL,NULL),(10,1,1,'sentimentality',NULL,NULL),(11,1,2,'arousal',NULL,NULL),(12,1,2,'desire',NULL,NULL),(13,1,2,'lust',NULL,NULL),(14,1,2,'passion',NULL,NULL),(15,1,2,'infatuation',NULL,NULL),(16,1,3,'longing',NULL,NULL),(17,2,4,'amusement',NULL,NULL),(18,2,4,'bliss',NULL,NULL),(19,2,4,'cheerfulness',NULL,NULL),(20,2,4,'gaiety',NULL,NULL),(21,2,4,'glee',NULL,NULL),(22,2,4,'jolliness',NULL,NULL),(23,2,4,'joviality',NULL,NULL),(24,2,4,'joy',NULL,NULL),(25,2,4,'delight',NULL,NULL),(26,2,4,'enjoyment',NULL,NULL),(27,2,4,'gladness',NULL,NULL),(28,2,4,'happiness',NULL,NULL),(29,2,4,'jubilation',NULL,NULL),(30,2,4,'elation',NULL,NULL),(31,2,4,'satisfaction',NULL,NULL),(32,2,4,'ecstasy',NULL,NULL),(33,2,4,'euphoria',NULL,NULL),(34,2,5,'enthusiasm',NULL,NULL),(35,2,5,'zeal',NULL,NULL),(36,2,5,'zest',NULL,NULL),(37,2,5,'excitement',NULL,NULL),(38,2,5,'thrill',NULL,NULL),(39,2,5,'exhilaration',NULL,NULL),(40,2,6,'contentment',NULL,NULL),(41,2,6,'pleasure',NULL,NULL),(42,2,7,'pride',NULL,NULL),(43,2,7,'pleasure',NULL,NULL),(44,2,8,'eagerness',NULL,NULL),(45,2,8,'hope',NULL,NULL),(46,2,9,'enthrallment',NULL,NULL),(47,2,9,'rapture',NULL,NULL),(48,2,10,'relief',NULL,NULL),(49,3,11,'amazement',NULL,NULL),(50,3,11,'surprise',NULL,NULL),(51,3,11,'astonishment',NULL,NULL),(52,4,12,'aggravation',NULL,NULL),(53,4,12,'irritation',NULL,NULL),(54,4,12,'agitation',NULL,NULL),(55,4,12,'annoyance',NULL,NULL),(56,4,12,'grouchiness',NULL,NULL),(57,4,12,'grumpiness',NULL,NULL),(58,4,13,'exasperation',NULL,NULL),(59,4,13,'frustration',NULL,NULL),(60,4,14,'anger',NULL,NULL),(61,4,14,'rage',NULL,NULL),(62,4,14,'outrage',NULL,NULL),(63,4,14,'fury',NULL,NULL),(64,4,14,'wrath',NULL,NULL),(65,4,14,'hostility',NULL,NULL),(66,4,14,'ferocity',NULL,NULL),(67,4,14,'bitterness',NULL,NULL),(68,4,14,'hate',NULL,NULL),(69,4,14,'loathing',NULL,NULL),(70,4,14,'scorn',NULL,NULL),(71,4,14,'spite',NULL,NULL),(72,4,14,'vengefulness',NULL,NULL),(73,4,14,'dislike',NULL,NULL),(74,4,14,'resentment',NULL,NULL),(75,4,15,'disgust',NULL,NULL),(76,4,15,'revulsion',NULL,NULL),(77,4,15,'contempt',NULL,NULL),(78,4,16,'envy',NULL,NULL),(79,4,16,'jealousy',NULL,NULL),(80,5,17,'agony',NULL,NULL),(81,5,17,'suffering',NULL,NULL),(82,5,17,'hurt',NULL,NULL),(83,5,17,'anguish',NULL,NULL),(84,5,18,'depression',NULL,NULL),(85,5,18,'despair',NULL,NULL),(86,5,18,'hopelessness',NULL,NULL),(87,5,18,'gloom',NULL,NULL),(88,5,18,'glumness',NULL,NULL),(89,5,18,'sadness',NULL,NULL),(90,5,18,'unhappiness',NULL,NULL),(91,5,18,'grief',NULL,NULL),(92,5,18,'sorrow',NULL,NULL),(93,5,18,'woe',NULL,NULL),(94,5,18,'misery',NULL,NULL),(95,5,18,'melancholy',NULL,NULL),(96,5,19,'dismay',NULL,NULL),(97,5,19,'disappointment',NULL,NULL),(98,5,19,'displeasure',NULL,NULL),(99,5,20,'guilt',NULL,NULL),(100,5,20,'shame',NULL,NULL),(101,5,20,'regret',NULL,NULL),(102,5,20,'remorse',NULL,NULL),(103,5,21,'alienation',NULL,NULL),(104,5,21,'isolation',NULL,NULL),(105,5,21,'neglect',NULL,NULL),(106,5,21,'loneliness',NULL,NULL),(107,5,21,'rejection',NULL,NULL),(108,5,21,'homesickness',NULL,NULL),(109,5,21,'defeat',NULL,NULL),(110,5,21,'dejection',NULL,NULL),(111,5,21,'insecurity',NULL,NULL),(112,5,21,'embarrassment',NULL,NULL),(113,5,21,'humiliation',NULL,NULL),(114,5,21,'insult',NULL,NULL),(115,5,22,'pity',NULL,NULL),(116,5,22,'sympathy',NULL,NULL),(117,6,23,'alarm',NULL,NULL),(118,6,23,'shock',NULL,NULL),(119,6,23,'fear',NULL,NULL),(120,6,23,'fright',NULL,NULL),(121,6,23,'horror',NULL,NULL),(122,6,23,'terror',NULL,NULL),(123,6,23,'panic',NULL,NULL),(124,6,23,'hysteria',NULL,NULL),(125,6,23,'mortification',NULL,NULL),(126,6,24,'anxiety',NULL,NULL),(127,6,24,'nervousness',NULL,NULL),(128,6,24,'tenseness',NULL,NULL),(129,6,24,'uneasiness',NULL,NULL),(130,6,24,'apprehension',NULL,NULL),(131,6,24,'worry',NULL,NULL),(132,6,24,'distress',NULL,NULL),(133,6,24,'dread',NULL,NULL);
/*!40000 ALTER TABLE `emotions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emotions_primary`
--

DROP TABLE IF EXISTS `emotions_primary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emotions_primary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emotions_primary`
--

LOCK TABLES `emotions_primary` WRITE;
/*!40000 ALTER TABLE `emotions_primary` DISABLE KEYS */;
INSERT INTO `emotions_primary` VALUES (1,'love',NULL,NULL),(2,'joy',NULL,NULL),(3,'surprise',NULL,NULL),(4,'anger',NULL,NULL),(5,'sadness',NULL,NULL),(6,'fear',NULL,NULL);
/*!40000 ALTER TABLE `emotions_primary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emotions_secondary`
--

DROP TABLE IF EXISTS `emotions_secondary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emotions_secondary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emotion_primary_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emotions_secondary_emotion_primary_id_foreign` (`emotion_primary_id`),
  CONSTRAINT `emotions_secondary_emotion_primary_id_foreign` FOREIGN KEY (`emotion_primary_id`) REFERENCES `emotions_primary` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emotions_secondary`
--

LOCK TABLES `emotions_secondary` WRITE;
/*!40000 ALTER TABLE `emotions_secondary` DISABLE KEYS */;
INSERT INTO `emotions_secondary` VALUES (1,1,'affection',NULL,NULL),(2,1,'lust',NULL,NULL),(3,1,'longing',NULL,NULL),(4,2,'cheerfulness',NULL,NULL),(5,2,'zest',NULL,NULL),(6,2,'contentment',NULL,NULL),(7,2,'pride',NULL,NULL),(8,2,'optimism',NULL,NULL),(9,2,'enthrallment',NULL,NULL),(10,2,'relief',NULL,NULL),(11,3,'surprise',NULL,NULL),(12,4,'irritation',NULL,NULL),(13,4,'exasperation',NULL,NULL),(14,4,'rage',NULL,NULL),(15,4,'disgust',NULL,NULL),(16,4,'envy',NULL,NULL),(17,5,'suffering',NULL,NULL),(18,5,'sadness',NULL,NULL),(19,5,'disappointment',NULL,NULL),(20,5,'shame',NULL,NULL),(21,5,'neglect',NULL,NULL),(22,5,'sympathy',NULL,NULL),(23,6,'horror',NULL,NULL),(24,6,'nervousness',NULL,NULL);
/*!40000 ALTER TABLE `emotions_secondary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `post` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entries_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `entries_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `export_jobs`
--

DROP TABLE IF EXISTS `export_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `export_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(4) NOT NULL,
  `status` varchar(6) DEFAULT NULL,
  `location` varchar(6) DEFAULT NULL,
  `filename` varchar(256) DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `export_jobs_account_id_foreign` (`account_id`),
  KEY `export_jobs_user_id_foreign` (`user_id`),
  KEY `export_jobs_uuid_index` (`uuid`),
  CONSTRAINT `export_jobs_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `export_jobs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `export_jobs`
--

LOCK TABLES `export_jobs` WRITE;
/*!40000 ALTER TABLE `export_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `export_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genders`
--

DROP TABLE IF EXISTS `genders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` char(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `genders_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `genders_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genders`
--

LOCK TABLES `genders` WRITE;
/*!40000 ALTER TABLE `genders` DISABLE KEYS */;
INSERT INTO `genders` VALUES (1,NULL,1,'Man','M','2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,NULL,1,'Woman','F','2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,NULL,1,'Rather not say','O','2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,NULL,2,'Man','M','2024-01-02 23:41:18','2024-01-02 23:41:18'),(5,NULL,2,'Woman','F','2024-01-02 23:41:18','2024-01-02 23:41:18'),(6,NULL,2,'Rather not say','O','2024-01-02 23:41:18','2024-01-02 23:41:18'),(7,'36ee5ef0-bbf8-4536-a7c2-f923d9ad9f78',3,'Man','M','2024-01-02 23:41:19','2024-01-03 01:06:09'),(8,'30d56c45-eb05-4d46-adc1-3bbbf9129f06',3,'Woman','F','2024-01-02 23:41:19','2024-01-03 01:27:24'),(9,'9e5b768f-4db1-4cb4-bb56-3c45d16fab50',3,'Non-binary','O','2024-01-02 23:41:19','2024-01-03 01:20:04');
/*!40000 ALTER TABLE `genders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gift_photo`
--

DROP TABLE IF EXISTS `gift_photo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gift_photo` (
  `photo_id` int(10) unsigned NOT NULL,
  `gift_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`photo_id`,`gift_id`),
  KEY `gift_photo_gift_id_foreign` (`gift_id`),
  CONSTRAINT `gift_photo_gift_id_foreign` FOREIGN KEY (`gift_id`) REFERENCES `gifts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gift_photo_photo_id_foreign` FOREIGN KEY (`photo_id`) REFERENCES `photos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gift_photo`
--

LOCK TABLES `gift_photo` WRITE;
/*!40000 ALTER TABLE `gift_photo` DISABLE KEYS */;
/*!40000 ALTER TABLE `gift_photo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gifts`
--

DROP TABLE IF EXISTS `gifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `is_for` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `url` longtext DEFAULT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(8) NOT NULL DEFAULT 'idea',
  `date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gifts_contact_id_foreign` (`contact_id`),
  KEY `gifts_is_for_foreign` (`is_for`),
  KEY `gifts_currency_id_foreign` (`currency_id`),
  KEY `gifts_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `gifts_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gifts_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gifts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `gifts_is_for_foreign` FOREIGN KEY (`is_for`) REFERENCES `contacts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gifts`
--

LOCK TABLES `gifts` WRITE;
/*!40000 ALTER TABLE `gifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `gifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import_job_reports`
--

DROP TABLE IF EXISTS `import_job_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `import_job_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `import_job_id` int(10) unsigned NOT NULL,
  `contact_information` mediumtext NOT NULL,
  `skipped` tinyint(1) NOT NULL,
  `skip_reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `import_job_reports_account_id_foreign` (`account_id`),
  KEY `import_job_reports_user_id_foreign` (`user_id`),
  KEY `import_job_reports_import_job_id_foreign` (`import_job_id`),
  CONSTRAINT `import_job_reports_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `import_job_reports_import_job_id_foreign` FOREIGN KEY (`import_job_id`) REFERENCES `import_jobs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `import_job_reports_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import_job_reports`
--

LOCK TABLES `import_job_reports` WRITE;
/*!40000 ALTER TABLE `import_job_reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `import_job_reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import_jobs`
--

DROP TABLE IF EXISTS `import_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `import_jobs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'vcard',
  `contacts_found` int(11) DEFAULT NULL,
  `contacts_skipped` int(11) DEFAULT NULL,
  `contacts_imported` int(11) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `started_at` date DEFAULT NULL,
  `ended_at` date DEFAULT NULL,
  `failed` tinyint(1) NOT NULL DEFAULT 0,
  `failed_reason` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `import_jobs_account_id_foreign` (`account_id`),
  KEY `import_jobs_user_id_foreign` (`user_id`),
  CONSTRAINT `import_jobs_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `import_jobs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import_jobs`
--

LOCK TABLES `import_jobs` WRITE;
/*!40000 ALTER TABLE `import_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `import_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `instances`
--

DROP TABLE IF EXISTS `instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `instances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `current_version` varchar(255) NOT NULL,
  `latest_version` varchar(255) DEFAULT NULL,
  `latest_release_notes` mediumtext DEFAULT NULL,
  `number_of_versions_since_current_version` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `instances`
--

LOCK TABLES `instances` WRITE;
/*!40000 ALTER TABLE `instances` DISABLE KEYS */;
INSERT INTO `instances` VALUES (1,'2158cf85-628a-41c8-b927-c2dfcbdd0150','','',NULL,NULL,'2024-01-02 23:40:46','2024-01-02 23:40:46');
/*!40000 ALTER TABLE `instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invitations`
--

DROP TABLE IF EXISTS `invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invitations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `invited_by_user_id` int(10) unsigned NOT NULL,
  `email` varchar(255) NOT NULL,
  `invitation_key` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invitations_account_id_foreign` (`account_id`),
  KEY `invitations_invited_by_user_id_foreign` (`invited_by_user_id`),
  CONSTRAINT `invitations_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `invitations_invited_by_user_id_foreign` FOREIGN KEY (`invited_by_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invitations`
--

LOCK TABLES `invitations` WRITE;
/*!40000 ALTER TABLE `invitations` DISABLE KEYS */;
/*!40000 ALTER TABLE `invitations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `journal_entries`
--

DROP TABLE IF EXISTS `journal_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `journal_entries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `journalable_id` int(11) NOT NULL,
  `journalable_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_entries_account_id_foreign` (`account_id`),
  CONSTRAINT `journal_entries_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `journal_entries`
--

LOCK TABLES `journal_entries` WRITE;
/*!40000 ALTER TABLE `journal_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `journal_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `life_event_categories`
--

DROP TABLE IF EXISTS `life_event_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `life_event_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `default_life_event_category_key` varchar(255) DEFAULT NULL,
  `core_monica_data` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `life_event_categories_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `life_event_categories_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `life_event_categories`
--

LOCK TABLES `life_event_categories` WRITE;
/*!40000 ALTER TABLE `life_event_categories` DISABLE KEYS */;
INSERT INTO `life_event_categories` VALUES (1,NULL,1,'Work & education','work_education',1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,NULL,1,'Family & relationships','family_relationships',1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,NULL,1,'Home & living','home_living',1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,NULL,1,'Health & wellness','health_wellness',1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(5,NULL,1,'Travel & experiences','travel_experiences',1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(6,NULL,2,'Work & education','work_education',1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(7,NULL,2,'Family & relationships','family_relationships',1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(8,NULL,2,'Home & living','home_living',1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(9,NULL,2,'Health & wellness','health_wellness',1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(10,NULL,2,'Travel & experiences','travel_experiences',1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(11,NULL,3,'Work & education','work_education',1,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(12,NULL,3,'Family & relationships','family_relationships',1,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(13,NULL,3,'Home & living','home_living',1,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(14,NULL,3,'Health & wellness','health_wellness',1,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(15,NULL,3,'Travel & experiences','travel_experiences',1,'2024-01-02 23:41:20','2024-01-02 23:41:20');
/*!40000 ALTER TABLE `life_event_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `life_event_types`
--

DROP TABLE IF EXISTS `life_event_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `life_event_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `life_event_category_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `default_life_event_type_key` varchar(255) DEFAULT NULL,
  `core_monica_data` tinyint(1) NOT NULL DEFAULT 0,
  `specific_information_structure` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `life_event_types_life_event_category_id_foreign` (`life_event_category_id`),
  KEY `life_event_types_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `life_event_types_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `life_event_types_life_event_category_id_foreign` FOREIGN KEY (`life_event_category_id`) REFERENCES `life_event_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `life_event_types`
--

LOCK TABLES `life_event_types` WRITE;
/*!40000 ALTER TABLE `life_event_types` DISABLE KEYS */;
INSERT INTO `life_event_types` VALUES (1,NULL,1,1,NULL,'new_job',1,'{\"employer\": {\"type\": \"string\", \"value\": \"\"}, \"job_title\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,NULL,1,1,NULL,'retirement',1,'{\"profession\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,NULL,1,1,NULL,'new_school',1,'{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,NULL,1,1,NULL,'study_abroad',1,'{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(5,NULL,1,1,NULL,'volunteer_work',1,'{\"organization\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(6,NULL,1,1,NULL,'published_book_or_paper',1,'{\"full_citation\": {\"type\": \"string\", \"value\": \"\"}, \"url\": {\"type\": \"string\", \"value\": \"\"}, \"citation\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(7,NULL,1,1,NULL,'military_service',1,'{\"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"branch\": {\"type\": \"string\", \"value\": \"\"}, \"division\": {\"type\": \"string\", \"value\": \"\"}, \"country\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(8,NULL,1,2,NULL,'new_relationship',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(9,NULL,1,2,NULL,'engagement',1,'{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(10,NULL,1,2,NULL,'marriage',1,'{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(11,NULL,1,2,NULL,'anniversary',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(12,NULL,1,2,NULL,'expecting_a_baby',1,'{\"contact_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date\": {\"type\": \"date\", \"value\": \"\"}, \"expected_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_gender\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(13,NULL,1,2,NULL,'new_child',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(14,NULL,1,2,NULL,'new_family_member',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(15,NULL,1,2,NULL,'new_pet',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(16,NULL,1,2,NULL,'end_of_relationship',1,'{\"breakup_reason\": {\"type\": \"string\", \"value\": \"\"}, \"who_broke_up_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(17,NULL,1,2,NULL,'loss_of_a_loved_one',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(18,NULL,1,3,NULL,'moved',1,'{\"where_to\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(19,NULL,1,3,NULL,'bought_a_home',1,'{\"address\": {\"type\": \"string\", \"value\": \"\"}, \"estimated_value\": {\"type\": \"number\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(20,NULL,1,3,NULL,'home_improvement',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(21,NULL,1,3,NULL,'holidays',1,'{\"where\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(22,NULL,1,3,NULL,'new_vehicle',1,'{\"type\": {\"type\": \"string\", \"value\": \"\"}, \"model\": {\"type\": \"string\", \"value\": \"\"}, \"model_year\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(23,NULL,1,3,NULL,'new_roommate',1,'{\"contact_id\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(24,NULL,1,4,NULL,'overcame_an_illness',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(25,NULL,1,4,NULL,'quit_a_habit',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(26,NULL,1,4,NULL,'new_eating_habits',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(27,NULL,1,4,NULL,'weight_loss',1,'{\"amount\": {\"type\": \"string\", \"value\": \"\"}, \"unit\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(28,NULL,1,4,NULL,'wear_glass_or_contact',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(29,NULL,1,4,NULL,'broken_bone',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(30,NULL,1,4,NULL,'removed_braces',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(31,NULL,1,4,NULL,'surgery',1,'{\"nature\": {\"type\": \"string\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date_out_of_hospital_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(32,NULL,1,4,NULL,'dentist',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(33,NULL,1,5,NULL,'new_sport',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(34,NULL,1,5,NULL,'new_hobby',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(35,NULL,1,5,NULL,'new_instrument',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(36,NULL,1,5,NULL,'new_language',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(37,NULL,1,5,NULL,'tattoo_or_piercing',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(38,NULL,1,5,NULL,'new_license',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(39,NULL,1,5,NULL,'travel',1,'{\"visited_place\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:17','2024-01-02 23:41:17'),(40,NULL,1,5,NULL,'achievement_or_award',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(41,NULL,1,5,NULL,'changed_beliefs',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(42,NULL,1,5,NULL,'first_word',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(43,NULL,1,5,NULL,'first_kiss',1,NULL,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(44,NULL,2,6,NULL,'new_job',1,'{\"employer\": {\"type\": \"string\", \"value\": \"\"}, \"job_title\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(45,NULL,2,6,NULL,'retirement',1,'{\"profession\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(46,NULL,2,6,NULL,'new_school',1,'{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(47,NULL,2,6,NULL,'study_abroad',1,'{\"degree\": {\"type\": \"string\", \"value\": \"\"}, \"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"school_name\": {\"type\": \"string\", \"value\": \"\"}, \"studying\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(48,NULL,2,6,NULL,'volunteer_work',1,'{\"organization\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(49,NULL,2,6,NULL,'published_book_or_paper',1,'{\"full_citation\": {\"type\": \"string\", \"value\": \"\"}, \"url\": {\"type\": \"string\", \"value\": \"\"}, \"citation\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(50,NULL,2,6,NULL,'military_service',1,'{\"end_date\": {\"type\": \"date\", \"value\": \"\"}, \"end_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"branch\": {\"type\": \"string\", \"value\": \"\"}, \"division\": {\"type\": \"string\", \"value\": \"\"}, \"country\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(51,NULL,2,7,NULL,'new_relationship',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(52,NULL,2,7,NULL,'engagement',1,'{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(53,NULL,2,7,NULL,'marriage',1,'{\"with_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(54,NULL,2,7,NULL,'anniversary',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(55,NULL,2,7,NULL,'expecting_a_baby',1,'{\"contact_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date\": {\"type\": \"date\", \"value\": \"\"}, \"expected_date_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_gender\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(56,NULL,2,7,NULL,'new_child',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(57,NULL,2,7,NULL,'new_family_member',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(58,NULL,2,7,NULL,'new_pet',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(59,NULL,2,7,NULL,'end_of_relationship',1,'{\"breakup_reason\": {\"type\": \"string\", \"value\": \"\"}, \"who_broke_up_contact_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(60,NULL,2,7,NULL,'loss_of_a_loved_one',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(61,NULL,2,8,NULL,'moved',1,'{\"where_to\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(62,NULL,2,8,NULL,'bought_a_home',1,'{\"address\": {\"type\": \"string\", \"value\": \"\"}, \"estimated_value\": {\"type\": \"number\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(63,NULL,2,8,NULL,'home_improvement',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(64,NULL,2,8,NULL,'holidays',1,'{\"where\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(65,NULL,2,8,NULL,'new_vehicle',1,'{\"type\": {\"type\": \"string\", \"value\": \"\"}, \"model\": {\"type\": \"string\", \"value\": \"\"}, \"model_year\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(66,NULL,2,8,NULL,'new_roommate',1,'{\"contact_id\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(67,NULL,2,9,NULL,'overcame_an_illness',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(68,NULL,2,9,NULL,'quit_a_habit',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(69,NULL,2,9,NULL,'new_eating_habits',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(70,NULL,2,9,NULL,'weight_loss',1,'{\"amount\": {\"type\": \"string\", \"value\": \"\"}, \"unit\": {\"type\": \"string\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(71,NULL,2,9,NULL,'wear_glass_or_contact',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(72,NULL,2,9,NULL,'broken_bone',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(73,NULL,2,9,NULL,'removed_braces',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(74,NULL,2,9,NULL,'surgery',1,'{\"nature\": {\"type\": \"string\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"number_days_in_hospital\": {\"type\": \"integer\", \"value\": \"\"}, \"expected_date_out_of_hospital_reminder_id\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(75,NULL,2,9,NULL,'dentist',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(76,NULL,2,10,NULL,'new_sport',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(77,NULL,2,10,NULL,'new_hobby',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(78,NULL,2,10,NULL,'new_instrument',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(79,NULL,2,10,NULL,'new_language',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(80,NULL,2,10,NULL,'tattoo_or_piercing',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(81,NULL,2,10,NULL,'new_license',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(82,NULL,2,10,NULL,'travel',1,'{\"visited_place\": {\"type\": \"string\", \"value\": \"\"}, \"duration_in_days\": {\"type\": \"integer\", \"value\": \"\"}}','2024-01-02 23:41:18','2024-01-02 23:41:18'),(83,NULL,2,10,NULL,'achievement_or_award',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(84,NULL,2,10,NULL,'changed_beliefs',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(85,NULL,2,10,NULL,'first_word',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(86,NULL,2,10,NULL,'first_kiss',1,NULL,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(87,NULL,3,11,NULL,'new_job',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(88,NULL,3,11,NULL,'retirement',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(89,NULL,3,11,NULL,'new_school',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(90,NULL,3,11,NULL,'study_abroad',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(91,NULL,3,11,NULL,'volunteer_work',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(92,NULL,3,11,NULL,'published_book_or_paper',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(93,NULL,3,11,NULL,'military_service',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(94,NULL,3,12,NULL,'new_relationship',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(95,NULL,3,12,NULL,'engagement',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(96,NULL,3,12,NULL,'marriage',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(97,NULL,3,12,NULL,'anniversary',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(98,NULL,3,12,NULL,'expecting_a_baby',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(99,NULL,3,12,NULL,'new_child',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(100,NULL,3,12,NULL,'new_family_member',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(101,NULL,3,12,NULL,'new_pet',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(102,NULL,3,12,NULL,'end_of_relationship',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(103,NULL,3,12,NULL,'loss_of_a_loved_one',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(104,NULL,3,13,NULL,'moved',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(105,NULL,3,13,NULL,'bought_a_home',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(106,NULL,3,13,NULL,'home_improvement',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(107,NULL,3,13,NULL,'holidays',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(108,NULL,3,13,NULL,'new_vehicle',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(109,NULL,3,13,NULL,'new_roommate',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(110,NULL,3,14,NULL,'overcame_an_illness',1,NULL,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(111,NULL,3,14,NULL,'quit_a_habit',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(112,NULL,3,14,NULL,'new_eating_habits',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(113,NULL,3,14,NULL,'weight_loss',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(114,NULL,3,14,NULL,'wear_glass_or_contact',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(115,NULL,3,14,NULL,'broken_bone',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(116,NULL,3,14,NULL,'removed_braces',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(117,NULL,3,14,NULL,'surgery',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(118,NULL,3,14,NULL,'dentist',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(119,NULL,3,15,NULL,'new_sport',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(120,NULL,3,15,NULL,'new_hobby',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(121,NULL,3,15,NULL,'new_instrument',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(122,NULL,3,15,NULL,'new_language',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(123,NULL,3,15,NULL,'tattoo_or_piercing',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(124,NULL,3,15,NULL,'new_license',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(125,NULL,3,15,NULL,'travel',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(126,NULL,3,15,NULL,'achievement_or_award',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(127,NULL,3,15,NULL,'changed_beliefs',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(128,NULL,3,15,NULL,'first_word',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(129,NULL,3,15,NULL,'first_kiss',1,NULL,'2024-01-02 23:41:20','2024-01-02 23:41:20');
/*!40000 ALTER TABLE `life_event_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `life_events`
--

DROP TABLE IF EXISTS `life_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `life_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `life_event_type_id` int(10) unsigned NOT NULL,
  `reminder_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `happened_at` datetime NOT NULL,
  `happened_at_month_unknown` tinyint(1) NOT NULL DEFAULT 0,
  `happened_at_day_unknown` tinyint(1) NOT NULL DEFAULT 0,
  `specific_information` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `life_events_contact_id_foreign` (`contact_id`),
  KEY `life_events_life_event_type_id_foreign` (`life_event_type_id`),
  KEY `life_events_reminder_id_foreign` (`reminder_id`),
  KEY `life_events_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `life_events_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `life_events_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `life_events_life_event_type_id_foreign` FOREIGN KEY (`life_event_type_id`) REFERENCES `life_event_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `life_events_reminder_id_foreign` FOREIGN KEY (`reminder_id`) REFERENCES `reminders` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `life_events`
--

LOCK TABLES `life_events` WRITE;
/*!40000 ALTER TABLE `life_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `life_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `conversation_id` int(10) unsigned NOT NULL,
  `content` longtext NOT NULL,
  `written_at` datetime NOT NULL,
  `written_by_me` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `messages_conversation_id_foreign` (`conversation_id`),
  KEY `messages_contact_id_foreign` (`contact_id`),
  KEY `messages_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `messages_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `messages_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `messages_conversation_id_foreign` FOREIGN KEY (`conversation_id`) REFERENCES `conversations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadata_love_relationships`
--

DROP TABLE IF EXISTS `metadata_love_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metadata_love_relationships` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `relationship_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `notes` mediumtext DEFAULT NULL,
  `meet_date` datetime DEFAULT NULL,
  `official_date` datetime DEFAULT NULL,
  `breakup_date` datetime DEFAULT NULL,
  `breakup_reason` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `metadata_love_relationships_account_id_foreign` (`account_id`),
  KEY `metadata_love_relationships_relationship_id_foreign` (`relationship_id`),
  CONSTRAINT `metadata_love_relationships_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `metadata_love_relationships_relationship_id_foreign` FOREIGN KEY (`relationship_id`) REFERENCES `relationships` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadata_love_relationships`
--

LOCK TABLES `metadata_love_relationships` WRITE;
/*!40000 ALTER TABLE `metadata_love_relationships` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadata_love_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2016_06_07_234741_create_account_table',1),(9,'2016_06_08_003006_add_account_info_table',1),(10,'2016_06_08_005413_create_contacts_table',1),(11,'2016_06_25_224219_create_reminder_type_table',1),(12,'2016_06_28_191025_create_tasks_table',1),(13,'2016_06_30_185050_create_notes_table',1),(14,'2016_07_25_133835_add_width_field',1),(15,'2016_08_28_122938_create_kids_table',1),(16,'2016_08_28_215159_create_relations_table',1),(17,'2016_09_03_202027_add_reminder_id_to_contacts',1),(18,'2016_09_05_134937_add_last_talked_to_field',1),(19,'2016_09_05_135927_add_people_id_to_contacts',1),(20,'2016_09_05_145111_add_name_info_to_peoples',1),(21,'2016_09_06_213550_create_activity_type_table',1),(22,'2016_09_10_164406_create_jobs_table',1),(23,'2016_09_10_170122_create_notifications_table',1),(24,'2016_09_12_014120_create_failed_jobs_table',1),(25,'2016_09_30_014720_add_kid_to_reminder',1),(26,'2016_10_15_024156_add_deleted_at_to_users',1),(27,'2016_10_19_155139_create_cache_table',1),(28,'2016_10_19_155800_create_sessions_table',1),(29,'2016_10_21_022941_add_statistics_table',1),(30,'2016_10_24_013543_add_journal_setting_to_users',1),(31,'2016_10_24_014257_create_journal_tables',1),(32,'2016_10_28_002518_add_metric_to_settings',1),(33,'2016_11_01_014353_create_activities_table',1),(34,'2016_11_01_015957_add_icon_column',1),(35,'2016_11_03_150307_add_activity_location_to_activities',1),(36,'2016_11_09_013049_add_events_table',1),(37,'2016_12_08_011555_remove_type_from_notes',1),(38,'2016_12_13_133945_add_gifts_table',1),(39,'2016_12_28_150831_change_title_column',1),(40,'2017_01_14_200815_add_facebook_columns_to_users_table',1),(41,'2017_01_15_045025_add_colors_to_users',1),(42,'2017_01_22_142645_add_fields_to_contacts',1),(43,'2017_01_23_043831_change_people_to_contact_for_kids',1),(44,'2017_01_26_013524_change_people_to_significantother',1),(45,'2017_01_26_022852_change_notes_to_contact',1),(46,'2017_01_26_034553_add_notes_count_to_contact',1),(47,'2017_01_27_024356_change_people_in_events',1),(48,'2017_01_28_180156_remove_deleted_at_from_significant_others',1),(49,'2017_01_28_184901_remove_deleted_at_from_kids',1),(50,'2017_01_28_193913_remove_deleted_at_from_notes',1),(51,'2017_01_28_222114_remove_viewed_at_from_contacts',1),(52,'2017_01_29_175146_remove_delete_at_from_activities',1),(53,'2017_01_29_175629_add_number_activities_to_contacts',1),(54,'2017_01_31_025849_add_activity_statistics_table',1),(55,'2017_02_02_232450_add_confirmation',1),(56,'2017_02_04_225618_change_reminders_table',1),(57,'2017_02_05_035925_add_gifts_metrics_to_contacts',1),(58,'2017_02_05_041740_change_gifts_table',1),(59,'2017_02_05_042122_change_people_to_contact_for_gifts',1),(60,'2017_02_07_041607_change_tasks_table',1),(61,'2017_02_07_051355_add_number_tasks_to_contact',1),(62,'2017_02_08_002251_change_number_tasks_contact',1),(63,'2017_02_08_025358_add_sort_preferences_to_users',1),(64,'2017_02_10_195613_remove_notifications_table',1),(65,'2017_02_10_214714_remove_people_table',1),(66,'2017_02_10_215405_remove_entities_table',1),(67,'2017_02_10_224355_calculate_statistics',1),(68,'2017_02_11_154900_add_avatars_to_contacts',1),(69,'2017_02_12_134220_create_entries_table',1),(70,'2017_05_03_155254_move_significant_other_data',1),(71,'2017_05_04_164723_remove_contact_encryption',1),(72,'2017_05_04_185921_add_title_to_activities',1),(73,'2017_05_04_193252_alter_activity_nullable',1),(74,'2017_05_08_164514_remove_encryption_tasks',1),(75,'2017_05_30_002239_remove_predefined_reminders',1),(76,'2017_05_30_023116_create_money_table',1),(77,'2017_06_07_173437_add_multiple_genders_choices',1),(78,'2017_06_10_152945_add_social_networks_to_contacts',1),(79,'2017_06_10_155349_create_currencies_data',1),(80,'2017_06_11_025227_remove_encryption_journal',1),(81,'2017_06_11_110735_change_unique_constraint_for_contacts',1),(82,'2017_06_13_035059_remove_gifts_encryption',1),(83,'2017_06_13_195740_add_company_to_contacts',1),(84,'2017_06_14_131803_remove_bern_timezone',1),(85,'2017_06_14_132911_add_zar_currency_to_currencies_table',1),(86,'2017_06_16_215256_add_about_who_to_reminders',1),(87,'2017_06_17_010900_fix_contacts_table',1),(88,'2017_06_17_153814_refactor_user_table',1),(89,'2017_06_19_105842_add_stripe_fields_to_users',1),(90,'2017_06_20_121345_add_invitations_statistics',1),(91,'2017_06_22_210813_add_name_order_to_users',1),(92,'2017_06_27_134704_create_import_table',1),(93,'2017_06_29_211725_add_import_job_to_statistics',1),(94,'2017_06_29_230523_add_gravatar_url_to_users',1),(95,'2017_07_02_155736_create_tags_table',1),(96,'2017_07_04_132743_add_tags_to_statistics',1),(97,'2017_07_09_164312_update_bad_translation_key',1),(98,'2017_07_12_014244_create_calls_table',1),(99,'2017_07_17_005012_drop_reminders_count_from_contacts',1),(100,'2017_07_18_215312_add_danish_kroner_to_currencies_table',1),(101,'2017_07_18_215758_add_indian_rupee_to_currencies_table',1),(102,'2017_07_19_094503_add_brazilian_real_to_currencies',1),(103,'2017_07_22_153209_create_instance_table',1),(104,'2017_07_26_220021_change_contacts_table',1),(105,'2017_08_02_152838_change_string_to_boolean_for_reminders',1),(106,'2017_08_06_085629_change_events_data',1),(107,'2017_08_06_153253_move_kids_to_contacts',1),(108,'2017_08_16_041431_add_contact_avatar_location',1),(109,'2017_08_21_224835_remove_paid_limitations_for_current_users',1),(110,'2017_09_10_125918_remove_unusued_counters',1),(111,'2017_09_13_095923_add_tracking_table',1),(112,'2017_09_13_191714_add_partial_notion',1),(113,'2017_10_14_083556_change_gift_column_structure',1),(114,'2017_10_17_170803_change_gift_structure',1),(115,'2017_10_19_134816_create_activity_contact_table',1),(116,'2017_10_19_135215_move_activities_to_pivot_table',1),(117,'2017_10_25_102923_remove_contact_id_activities_table',1),(118,'2017_11_01_122541_add_met_through_to_contacts',1),(119,'2017_11_02_202601_add_is_dead_to_contacts',1),(120,'2017_11_10_174654_create_contact_fields_table',1),(121,'2017_11_10_181043_migrate_contacts_information',1),(122,'2017_11_10_202620_move_addresses_from_contact_to_addresses',1),(123,'2017_11_10_204035_delete_contact_fields_from_contacts',1),(124,'2017_11_20_115635_change-amount-to-double-on-debts',1),(125,'2017_11_27_083043_add_more_statistics',1),(126,'2017_11_27_134403_add_new_avatar_to_contacts',1),(127,'2017_11_27_202857_change_tasks_table_structure',1),(128,'2017_12_01_113748_update_notes',1),(129,'2017_12_04_164831_create_ages_table',1),(130,'2017_12_04_165421_move_ages_data',1),(131,'2017_12_10_181535_remove_important_dates_table',1),(132,'2017_12_10_205328_add_account_id_to_activities',1),(133,'2017_12_10_214545_add_last_consulted_at_to_contacts',1),(134,'2017_12_13_115857_create_day_table',1),(135,'2017_12_21_163616_update_journal_entries_with_existing_activities',1),(136,'2017_12_21_170327_add_google2fa_secret_to_users',1),(137,'2017_12_24_115641_create_pets_table',1),(138,'2017_12_31_114224_add_dashboard_tab_to_users',1),(139,'2018_01_15_105858_create_additional_reminders_table',1),(140,'2018_01_16_203358_add_gift_received',1),(141,'2018_01_16_212320_rename_gift_columns',1),(142,'2018_01_17_230820_add_gift_tab_view_to_users',1),(143,'2018_01_27_014146_add_custom_gender',1),(144,'2018_02_25_202752_change_locale_in_db',1),(145,'2018_02_28_223747_update_notification_table',1),(146,'2018_03_03_204440_create_relationship_type_table',1),(147,'2018_03_18_085815_populate_default_relationship_type_tables',1),(148,'2018_03_18_090209_populate_relationship_type_tables_with_default_values',1),(149,'2018_03_18_090345_migrate_current_relationship_table_to_new_relationship_structure',1),(150,'2018_03_24_083258_migrate_offsprings',1),(151,'2018_04_04_220850_create_default_modules_table',1),(152,'2018_04_04_222608_create_account_modules_table',1),(153,'2018_04_10_205655_fix_production_error',1),(154,'2018_04_10_222515_migrate-modules',1),(155,'2018_04_13_131008_fix-contacts-data',1),(156,'2018_04_13_205231_create_changes_table',1),(157,'2018_04_14_081052_fix_wrong_gender',1),(158,'2018_04_19_190239_stay_in_touch',1),(159,'2018_05_06_061227_external_countries',1),(160,'2018_05_07_070458_create_terms_table',1),(161,'2018_05_13_110706_add_ex_wife_husband_relationship',1),(162,'2018_05_16_143631_add_nickname_to_contacts',1),(163,'2018_05_16_214222_add_timestamps_to_currencies',1),(164,'2018_05_20_121028_accept_terms',1),(165,'2018_05_20_225034_change_name_order_user-_preferencies',1),(166,'2018_05_24_160546_fix-inconsistant-reminder-time',1),(167,'2018_06_10_191450_add_love_metadata_relationshisp',1),(168,'2018_06_10_221746_migrate_entries_objects',1),(169,'2018_06_11_184017_change_default_user_table',1),(170,'2018_06_13_000100_create_u2f_key_table',1),(171,'2018_06_14_212502_change_default_name_order_user_table',1),(172,'2018_07_03_204220_create_default_activity_type_groups_table',1),(173,'2018_07_08_104306_update-timestamps-timezone',1),(174,'2018_07_26_104306_create-conversations',1),(175,'2018_08_06_145046_add_starred_to_contacts',1),(176,'2018_08_09_18000_fix-empty-reminder-time',1),(177,'2018_08_18_180426_add_legacy_free_plan',1),(178,'2018_08_29_124804_add_conversations_to_statistics',1),(179,'2018_08_29_222051_add_conversations_to_modules',1),(180,'2018_08_31_020908_create_life_events_table',1),(181,'2018_09_02_150531_contact_archiving',1),(182,'2018_09_05_025008_add_default_profile_view',1),(183,'2018_09_05_213507_mark_modules_migrated',1),(184,'2018_09_13_135926_add_description_field_to_contacts',1),(185,'2018_09_18_142844_remove_events',1),(186,'2018_09_23_024528_add_documents_table',1),(187,'2018_09_29_114125_add_reminder_to_life_events',1),(188,'2018_10_01_211757_add_number_of_views',1),(189,'2018_10_04_181116_life_event_vehicle',1),(190,'2018_10_07_120133_fix_json_column',1),(191,'2018_10_16_000703_add_documents_to_module_table',1),(192,'2018_10_19_081816_life_event_tattoo',1),(193,'2018_10_27_230346_fix_non_english_tab_slugs',1),(194,'2018_10_28_165814_email_verified',1),(195,'2018_11_11_145035_remove_changelogs_table',1),(196,'2018_11_15_172333_make_contact_id_nullable_in_tasks',1),(197,'2018_11_18_021908_create_images_table',1),(198,'2018_11_21_212932_add_contacts_uuid',1),(199,'2018_11_25_020818_add_contact_photo_table',1),(200,'2018_11_30_154729_recovery_codes',1),(201,'2018_12_08_233140_add_who_called_to_calls',1),(202,'2018_12_09_023232_add_emotions_table',1),(203,'2018_12_09_145956_create_emotion_call_table',1),(204,'2018_12_16_195440_add_gps_coordinates_to_addressess',1),(205,'2018_12_19_002819_create_places_table',1),(206,'2018_12_19_003444_move_addresses_data',1),(207,'2018_12_21_235418_add_weather_table',1),(208,'2018_12_22_021123_add_weather_preferences_to_users',1),(209,'2018_12_22_200413_add_reminder_initial_date_to_reminders',1),(210,'2018_12_24_164256_add_companies_table',1),(211,'2018_12_24_220019_add_occupations_table',1),(212,'2018_12_25_001736_add_linkedin_to_default_contact_field_type',1),(213,'2018_12_25_012011_move_linkedin_data_to_contact_field_type',1),(214,'2018_12_29_091017_default_temperature_scale',1),(215,'2018_12_29_135516_sync_token',1),(216,'2019_01_05_152329_add_reminder_ids_to_contacts',1),(217,'2019_01_05_152405_migrate_previous_remiders',1),(218,'2019_01_05_152456_drop_special_date_id_from_reminders',1),(219,'2019_01_05_152526_schedule_new_reminders',1),(220,'2019_01_05_202557_add_foreign_keys_to_reminder',1),(221,'2019_01_05_202748_add_foreign_key_to_reminder_rule',1),(222,'2019_01_05_202938_add_foreign_key_to_contacts',1),(223,'2019_01_05_203201_add_foreign_key_for_reminder_in_life-events_table',1),(224,'2019_01_06_135133_update_u2f_key_table',1),(225,'2019_01_06_150143_add_inactive_flag_to_reminders',1),(226,'2019_01_06_190036_u2f_key_name',1),(227,'2019_01_11_142944_add_foreign_keys_to_activities',1),(228,'2019_01_11_183717_change_activities_date_type',1),(229,'2019_01_17_093812_add_admin_user',1),(230,'2019_01_18_142032_add_dav_uuid',1),(231,'2019_01_22_034555_create_emotion_activity_table',1),(232,'2019_01_24_221539_change_activity_model_location',1),(233,'2019_01_31_223600_add_swiss_chf_to_currencies_table',1),(234,'2019_02_08_234959_remove_users_without_account',1),(235,'2019_02_09_200203_add_gender_type',1),(236,'2019_02_17_112452_add_default_gender',1),(237,'2019_02_20_205744_allow_gender_null',1),(238,'2019_02_24_223855_remove_relation_type_name',1),(239,'2019_03_27_103012_set_default_profile_links',1),(240,'2019_03_29_163611_add_webauthn',1),(241,'2019_05_05_194746_add_cron_schedule',1),(242,'2019_05_15_205533_rename_preferences',1),(243,'2019_05_26_000000_add_relationship_table_indexes',1),(244,'2019_05_27_000000_populate_relationship_type_tables_with_stepparent_values',1),(245,'2019_08_12_213308_change_avatars_structure',1),(246,'2019_08_12_222938_create_avatars_for_existing_contacts',1),(247,'2019_08_13_160332_add_me_contact_on_user',1),(248,'2019_08_14_091427_update_stripe_columns',1),(249,'2019_09_04_075311_fix_tattoo_or_piercing_translation',1),(250,'2019_12_17_024553_add_foreign_keys',1),(251,'2019_12_21_100315_change_gift_status',1),(252,'2019_12_21_194559_add_photo_gift',1),(253,'2019_12_27_23533_rename_picnicked',1),(254,'2020_02_03_015403_create_audit_log_table',1),(255,'2020_02_18_211620_add_contact_field_label',1),(256,'2020_03_22_132429_rename_birthday_reminder_title_deceased',1),(257,'2020_03_25_055551_add_address_book',1),(258,'2020_03_25_065551_add_addressbook_subscription',1),(259,'2020_03_25_082324_add_contact_address_book_id',1),(260,'2020_03_25_201407_add_contact_vcard_data',1),(261,'2020_04_24_185810_remove_duplicate_currency',1),(262,'2020_04_24_205810_currencies_table_seed',1),(263,'2020_04_24_212138_update_amount_format',1),(264,'2020_05_08_072433_google2fa_column_size',1),(265,'2020_05_31_091556_custom_life_event_types',1),(266,'2020_08_05_184814_upgrade_passport',1),(267,'2020_11_01_000001_create_subscription_items_table',1),(268,'2020_12_19_205923_add_uuids',1),(269,'2021_04_23_190837_remove_reminder_sent',1),(270,'2021_09_27_023405_create_job_batches_table',1),(271,'2021_10_11_060512_add_distant_etag',1),(272,'2021_10_14_212144_v_card_company',1),(273,'2022_01_01_202745_add_export_jobs',1),(274,'2022_01_02_222042_contact_soft_delete',1),(275,'2022_04_25_165338_cashier_stripe_rename_plan',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modules`
--

DROP TABLE IF EXISTS `modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `key` varchar(255) NOT NULL,
  `translation_key` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `modules_account_id_foreign` (`account_id`),
  CONSTRAINT `modules_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modules`
--

LOCK TABLES `modules` WRITE;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` VALUES (1,1,'love_relationships','app.relationship_type_group_love',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,1,'family_relationships','app.relationship_type_group_family',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,1,'other_relationships','app.relationship_type_group_other',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,1,'pets','people.pets_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(5,1,'contact_information','people.section_contact_information',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(6,1,'addresses','people.contact_address_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(7,1,'how_you_met','people.introductions_sidebar_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(8,1,'work_information','people.work_information',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(9,1,'food_preferences','people.food_preferences_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(10,1,'notes','people.section_personal_notes',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(11,1,'phone_calls','people.call_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(12,1,'activities','people.activity_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(13,1,'reminders','people.section_personal_reminders',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(14,1,'tasks','people.section_personal_tasks',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(15,1,'gifts','people.gifts_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(16,1,'debts','people.debt_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(17,1,'conversations','people.conversation_list_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(18,1,'documents','people.document_list_title',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(19,2,'love_relationships','app.relationship_type_group_love',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(20,2,'family_relationships','app.relationship_type_group_family',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(21,2,'other_relationships','app.relationship_type_group_other',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(22,2,'pets','people.pets_title',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(23,2,'contact_information','people.section_contact_information',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(24,2,'addresses','people.contact_address_title',1,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(25,2,'how_you_met','people.introductions_sidebar_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(26,2,'work_information','people.work_information',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(27,2,'food_preferences','people.food_preferences_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(28,2,'notes','people.section_personal_notes',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(29,2,'phone_calls','people.call_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(30,2,'activities','people.activity_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(31,2,'reminders','people.section_personal_reminders',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(32,2,'tasks','people.section_personal_tasks',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(33,2,'gifts','people.gifts_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(34,2,'debts','people.debt_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(35,2,'conversations','people.conversation_list_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(36,2,'documents','people.document_list_title',1,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(37,3,'love_relationships','app.relationship_type_group_love',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(38,3,'family_relationships','app.relationship_type_group_family',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(39,3,'other_relationships','app.relationship_type_group_other',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(40,3,'pets','people.pets_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(41,3,'contact_information','people.section_contact_information',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(42,3,'addresses','people.contact_address_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(43,3,'how_you_met','people.introductions_sidebar_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(44,3,'work_information','people.work_information',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(45,3,'food_preferences','people.food_preferences_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(46,3,'notes','people.section_personal_notes',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(47,3,'phone_calls','people.call_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(48,3,'activities','people.activity_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(49,3,'reminders','people.section_personal_reminders',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(50,3,'tasks','people.section_personal_tasks',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(51,3,'gifts','people.gifts_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(52,3,'debts','people.debt_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(53,3,'conversations','people.conversation_list_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20'),(54,3,'documents','people.document_list_title',1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `body` mediumtext NOT NULL,
  `is_favorited` tinyint(1) NOT NULL DEFAULT 0,
  `favorited_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_contact_id_foreign` (`contact_id`),
  KEY `notes_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `notes_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notes_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_access_tokens`
--

DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_access_tokens`
--

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_auth_codes`
--

DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_auth_codes`
--

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_clients`
--

DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_clients`
--

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Monica Personal Access Client','nfyifXuf6HS5XElELAXzgFm2dTv1q8nRsdxDViQC',NULL,'http://localhost',1,0,0,'2024-01-02 23:41:15','2024-01-02 23:41:15'),(2,NULL,'Monica Password Grant Client','e0gI00YbHi7fOm61RZzu1raJQXoR0kOu2C4TP3Xt','users','http://localhost',0,1,0,'2024-01-02 23:41:20','2024-01-02 23:41:20');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_personal_access_clients`
--

DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_personal_access_clients`
--

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2024-01-02 23:41:15','2024-01-02 23:41:15');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_refresh_tokens`
--

DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_refresh_tokens`
--

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `occupations`
--

DROP TABLE IF EXISTS `occupations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `occupations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `company_id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `salary` int(11) DEFAULT NULL,
  `salary_unit` varchar(255) DEFAULT NULL,
  `currently_works_here` tinyint(1) DEFAULT 0,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `occupations_account_id_foreign` (`account_id`),
  KEY `occupations_contact_id_foreign` (`contact_id`),
  KEY `occupations_company_id_foreign` (`company_id`),
  CONSTRAINT `occupations_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `occupations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `occupations_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `occupations`
--

LOCK TABLES `occupations` WRITE;
/*!40000 ALTER TABLE `occupations` DISABLE KEYS */;
/*!40000 ALTER TABLE `occupations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pet_categories`
--

DROP TABLE IF EXISTS `pet_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pet_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_common` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pet_categories`
--

LOCK TABLES `pet_categories` WRITE;
/*!40000 ALTER TABLE `pet_categories` DISABLE KEYS */;
INSERT INTO `pet_categories` VALUES (1,'reptile',0,NULL,NULL),(2,'bird',0,NULL,NULL),(3,'cat',1,NULL,NULL),(4,'dog',1,NULL,NULL),(5,'fish',1,NULL,NULL),(6,'hamster',0,NULL,NULL),(7,'horse',0,NULL,NULL),(8,'rabbit',0,NULL,NULL),(9,'rat',0,NULL,NULL),(10,'small_animal',0,NULL,NULL),(11,'other',0,NULL,NULL);
/*!40000 ALTER TABLE `pet_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pets`
--

DROP TABLE IF EXISTS `pets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `pet_category_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pets_contact_id_foreign` (`contact_id`),
  KEY `pets_pet_category_id_foreign` (`pet_category_id`),
  KEY `pets_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `pets_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pets_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pets_pet_category_id_foreign` FOREIGN KEY (`pet_category_id`) REFERENCES `pet_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pets`
--

LOCK TABLES `pets` WRITE;
/*!40000 ALTER TABLE `pets` DISABLE KEYS */;
/*!40000 ALTER TABLE `pets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photos`
--

DROP TABLE IF EXISTS `photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `photos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `original_filename` varchar(255) NOT NULL,
  `new_filename` varchar(255) NOT NULL,
  `filesize` int(11) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `photos_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `photos_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `photos`
--

LOCK TABLES `photos` WRITE;
/*!40000 ALTER TABLE `photos` DISABLE KEYS */;
INSERT INTO `photos` VALUES (1,'bfe94dae-4982-4717-a284-dceb83110da4',3,'NCpxduIM_400x400.jpg','photos/zfo4f18iCoA8J6tPQh7Sloj1USeJHAiLocUMam1b.jpg',150413,'image/jpeg','2024-01-03 01:02:48','2024-01-03 01:27:24'),(2,'84ac1c30-1c4c-459b-a1e1-c9c0d760596d',3,'qhl20SOn_400x400.jpg','photos/OmzwHTfEwzcUUTPu6DciXA0IZtH3vktB1QxyzgMC.jpg',159292,'image/jpeg','2024-01-03 01:04:03','2024-01-03 01:06:09'),(3,NULL,3,'1N0TznCa_400x400.jpg','photos/oEioKUt3REQNNY7x5r2dxqwxphKx13DQ9tIFITVl.jpg',52615,'image/jpeg','2024-01-03 01:23:22','2024-01-03 01:23:22'),(4,NULL,3,'c91657d1-a59d-44fe-84b1-3d7102af3f06-profile_image-70x70.png','photos/J25DMi0j5r6IvRgbsqNA6iJpNSmyo03zxmt1I2jS.jpg',8201,'image/jpeg','2024-01-03 01:24:55','2024-01-03 01:24:55'),(5,'eef34ba6-6fe3-478c-8ff0-d3a30a1c8fc0',3,'j5ZjRFjS_400x400.jpg','photos/mXSq8V0i2e562mbLNkes8V94iRkgBUchYTFXM0A5.jpg',189126,'image/jpeg','2024-01-03 01:26:08','2024-01-03 01:26:16'),(6,NULL,3,'70z9znnkd.png','photos/0CYyOeS1vN1bcUg8BbRqWJbGWQx15AqbheVKiHPm.jpg',28784,'image/jpeg','2024-01-03 01:28:18','2024-01-03 01:28:18'),(7,NULL,3,'7X6bPD4i_400x400.jpg','photos/K2Rk6Q3G3F8al2y03roI0NjK92SCMnOQWglvgbsJ.jpg',95532,'image/jpeg','2024-01-03 01:31:21','2024-01-03 01:31:21'),(8,'d9fc4079-be56-40ff-a4a7-869add279076',3,'Capture d\'écran 2024-01-03 023327.png','photos/l6vgOZxoujXfKxCcK0hnm1FQGER9Yted44eDD7Or.jpg',320423,'image/jpeg','2024-01-03 01:34:44','2024-01-03 01:35:16'),(9,NULL,3,'usb1ggdl_400x400.jpg','photos/1mA8ySKeqEWS5UjgBIfXdV4RMfReqQ855jk4ATUY.jpg',85903,'image/jpeg','2024-01-05 05:39:50','2024-01-05 05:39:50'),(10,'05ef4a88-ad53-4d42-a15d-07c2e4e292ea',3,'g4QOWPOv_400x400.jpg','photos/66eYwZYo5081zA0iWig2BukjdCERkKWtNBjMyqL9.jpg',129320,'image/jpeg','2024-01-05 05:57:43','2024-01-05 05:58:57'),(11,NULL,3,'FD_fl_5l_400x400.jpg','photos/eba7dt5esLH2ddsnXhnYMQHb157qb0JkhR6qHeP1.jpg',106299,'image/jpeg','2024-01-05 06:59:55','2024-01-05 06:59:55'),(12,NULL,3,'L1wZCKLR_400x400.jpg','photos/KGq9QGf6R5UXdftURjpBXZ08g27jS7aEwOAHRuYh.jpg',67079,'image/jpeg','2024-01-07 01:55:46','2024-01-07 01:55:46'),(13,'78db530f-d048-4d8c-88e1-42273d6ca637',3,'aImaGelN_400x400.jpg','photos/UoqCtVL1CV3HACxRWgjAM6dx4oYlRfEA1zvLlm76.jpg',134755,'image/jpeg','2024-01-07 01:58:47','2024-01-07 01:58:56'),(14,'40304874-2e78-4fb4-8548-4f938a075bc7',3,'F6cSYMwXQAEJ2i8.png','photos/Gkco32EXSTxA4e4GUHDfXEGt9CS4EP5HAdD9bfs2.jpg',1189763,'image/jpeg','2024-01-07 02:01:53','2024-01-07 02:09:21'),(15,'56597c8c-47da-4e5e-a93e-b713b1b92906',3,'Tvjs5UA0_400x400.jpg','photos/BJvrT9LcFkwOby4a9auyn05V6Qp7yGu0NYWmUNsc.jpg',113255,'image/jpeg','2024-01-07 02:29:23','2024-01-25 04:23:10'),(16,NULL,3,'GC3OQspWUAAukXj.jpg','photos/GyAvrPESVvXMxjqeBcUu2XPfgKR5qMWoVHnHNugr.jpg',393919,'image/jpeg','2024-01-10 10:02:50','2024-01-10 10:02:50'),(17,NULL,3,'1500x500.jpg','photos/D4x6q2PjbUfh4wto8NbhR04C3xJktz1Zziv9OIhW.jpg',266512,'image/jpeg','2024-01-10 10:04:51','2024-01-10 10:04:51'),(18,'9a646322-7b1b-469b-a724-a8e03ba68f57',3,'skibidi.png','photos/fLKsm45CwBlYcUyu142nMEIZAINqc6e70hwWJhuV.jpg',379929,'image/jpeg','2024-01-10 10:05:47','2024-01-10 10:06:42'),(19,'f038ef2c-7937-435b-a368-a2985f04d5e5',3,'0Aqpg7kq_400x400.jpg','photos/RcI8WAAzVWEZbJ8z4bPTVmOkc0pQ3jTb7Xrna4rL.jpg',66814,'image/jpeg','2024-01-10 10:08:50','2024-01-10 10:09:03'),(20,NULL,3,'D4iTCXC6_400x400.jpg','photos/8DKYDXFQ8Fhiq7ZKZEmbNMM8hZZ8zTJzwdHd5szM.jpg',114483,'image/jpeg','2024-01-10 10:25:32','2024-01-10 10:25:32'),(21,NULL,3,'Ap-_UykI_400x400.jpg','photos/IhVx1rvOcXESRCfYFKZiBvtAZP60IoN9SPXRB1Ya.jpg',78806,'image/jpeg','2024-01-16 12:26:01','2024-01-16 12:26:01'),(22,NULL,3,'35956416a1961cb4412654cbfd6c5719.webp','photos/fSrPJAtKkIs5xYXNSYEtKluV3BhPlVQVGOlw6bg1.jpg',163458,'image/jpeg','2024-01-20 16:26:24','2024-01-20 16:26:24'),(23,NULL,3,'3k5wpFSD_400x400.jpg','photos/6NOGWtEUovIUBO5qpOqEi4NRlTjEeqS88C8RPZgO.jpg',131732,'image/jpeg','2024-02-04 18:47:22','2024-02-04 18:47:22'),(24,'909260ac-5e70-46dd-ae40-5e5d53debfc7',3,'IVkc1NYS.png','photos/RID2mVXB9527SWtj4GeA2aXHp4lusTC00vo9MxMU.jpg',46084,'image/jpeg','2024-02-04 21:01:56','2024-02-04 21:02:50');
/*!40000 ALTER TABLE `photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `places`
--

DROP TABLE IF EXISTS `places`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `places` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `country` char(3) DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `places_account_id_foreign` (`account_id`),
  CONSTRAINT `places_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `places`
--

LOCK TABLES `places` WRITE;
/*!40000 ALTER TABLE `places` DISABLE KEYS */;
/*!40000 ALTER TABLE `places` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recovery_codes`
--

DROP TABLE IF EXISTS `recovery_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recovery_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `recovery` varchar(255) NOT NULL,
  `used` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recovery_codes_account_id_foreign` (`account_id`),
  KEY `recovery_codes_user_id_foreign` (`user_id`),
  CONSTRAINT `recovery_codes_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `recovery_codes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recovery_codes`
--

LOCK TABLES `recovery_codes` WRITE;
/*!40000 ALTER TABLE `recovery_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `recovery_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `relationship_type_groups`
--

DROP TABLE IF EXISTS `relationship_type_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relationship_type_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `relationship_type_groups_account_id_name_index` (`account_id`,`name`),
  CONSTRAINT `relationship_type_groups_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `relationship_type_groups`
--

LOCK TABLES `relationship_type_groups` WRITE;
/*!40000 ALTER TABLE `relationship_type_groups` DISABLE KEYS */;
INSERT INTO `relationship_type_groups` VALUES (1,1,'love',0,NULL,NULL),(2,1,'family',0,NULL,NULL),(3,1,'friend',0,NULL,NULL),(4,1,'work',0,NULL,NULL),(5,2,'love',0,NULL,NULL),(6,2,'family',0,NULL,NULL),(7,2,'friend',0,NULL,NULL),(8,2,'work',0,NULL,NULL),(9,3,'love',0,NULL,NULL),(10,3,'family',0,NULL,NULL),(11,3,'friend',0,NULL,NULL),(12,3,'work',0,NULL,NULL);
/*!40000 ALTER TABLE `relationship_type_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `relationship_types`
--

DROP TABLE IF EXISTS `relationship_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relationship_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `name_reverse_relationship` varchar(255) NOT NULL,
  `relationship_type_group_id` int(10) unsigned NOT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `relationship_types_account_id_foreign` (`account_id`),
  KEY `relationship_types_relationship_type_group_id_foreign` (`relationship_type_group_id`),
  CONSTRAINT `relationship_types_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `relationship_types_relationship_type_group_id_foreign` FOREIGN KEY (`relationship_type_group_id`) REFERENCES `relationship_type_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `relationship_types`
--

LOCK TABLES `relationship_types` WRITE;
/*!40000 ALTER TABLE `relationship_types` DISABLE KEYS */;
INSERT INTO `relationship_types` VALUES (1,1,'partner','partner',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,1,'spouse','spouse',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,1,'date','date',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(4,1,'lover','lover',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(5,1,'inlovewith','lovedby',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(6,1,'lovedby','inlovewith',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(7,1,'ex','ex',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(8,1,'parent','child',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(9,1,'child','parent',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(10,1,'sibling','sibling',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(11,1,'grandparent','grandchild',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(12,1,'grandchild','grandparent',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(13,1,'uncle','nephew',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(14,1,'nephew','uncle',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(15,1,'cousin','cousin',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(16,1,'godfather','godson',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(17,1,'godson','godfather',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(18,1,'friend','friend',3,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(19,1,'bestfriend','bestfriend',3,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(20,1,'colleague','colleague',4,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(21,1,'boss','subordinate',4,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(22,1,'subordinate','boss',4,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(23,1,'mentor','protege',4,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(24,1,'protege','mentor',4,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(25,1,'ex_husband','ex_husband',1,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(26,1,'stepparent','stepchild',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(27,1,'stepchild','stepparent',2,0,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(28,2,'partner','partner',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(29,2,'spouse','spouse',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(30,2,'date','date',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(31,2,'lover','lover',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(32,2,'inlovewith','lovedby',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(33,2,'lovedby','inlovewith',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(34,2,'ex','ex',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(35,2,'parent','child',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(36,2,'child','parent',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(37,2,'sibling','sibling',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(38,2,'grandparent','grandchild',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(39,2,'grandchild','grandparent',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(40,2,'uncle','nephew',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(41,2,'nephew','uncle',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(42,2,'cousin','cousin',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(43,2,'godfather','godson',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(44,2,'godson','godfather',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(45,2,'friend','friend',7,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(46,2,'bestfriend','bestfriend',7,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(47,2,'colleague','colleague',8,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(48,2,'boss','subordinate',8,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(49,2,'subordinate','boss',8,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(50,2,'mentor','protege',8,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(51,2,'protege','mentor',8,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(52,2,'ex_husband','ex_husband',5,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(53,2,'stepparent','stepchild',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(54,2,'stepchild','stepparent',6,0,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(55,3,'partner','partner',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(56,3,'spouse','spouse',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(57,3,'date','date',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(58,3,'lover','lover',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(59,3,'inlovewith','lovedby',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(60,3,'lovedby','inlovewith',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(61,3,'ex','ex',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(62,3,'parent','child',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(63,3,'child','parent',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(64,3,'sibling','sibling',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(65,3,'grandparent','grandchild',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(66,3,'grandchild','grandparent',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(67,3,'uncle','nephew',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(68,3,'nephew','uncle',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(69,3,'cousin','cousin',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(70,3,'godfather','godson',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(71,3,'godson','godfather',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(72,3,'friend','friend',11,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(73,3,'bestfriend','bestfriend',11,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(74,3,'colleague','colleague',12,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(75,3,'boss','subordinate',12,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(76,3,'subordinate','boss',12,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(77,3,'mentor','protege',12,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(78,3,'protege','mentor',12,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(79,3,'ex_husband','ex_husband',9,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(80,3,'stepparent','stepchild',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(81,3,'stepchild','stepparent',10,0,'2024-01-02 23:41:19','2024-01-02 23:41:19');
/*!40000 ALTER TABLE `relationship_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `relationships`
--

DROP TABLE IF EXISTS `relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relationships` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `relationship_type_id` int(10) unsigned NOT NULL,
  `contact_is` int(10) unsigned NOT NULL,
  `of_contact` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `relationships_relationship_type_id_foreign` (`relationship_type_id`),
  KEY `relationships_contact_is_foreign` (`contact_is`),
  KEY `relationships_of_contact_foreign` (`of_contact`),
  KEY `relationships_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `relationships_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `relationships_contact_is_foreign` FOREIGN KEY (`contact_is`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `relationships_of_contact_foreign` FOREIGN KEY (`of_contact`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `relationships_relationship_type_id_foreign` FOREIGN KEY (`relationship_type_id`) REFERENCES `relationship_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `relationships`
--

LOCK TABLES `relationships` WRITE;
/*!40000 ALTER TABLE `relationships` DISABLE KEYS */;
INSERT INTO `relationships` VALUES (1,NULL,3,55,1,2,'2024-01-03 00:55:03','2024-01-03 00:55:03'),(2,NULL,3,55,2,1,'2024-01-03 00:55:03','2024-01-03 00:55:03');
/*!40000 ALTER TABLE `relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminder_outbox`
--

DROP TABLE IF EXISTS `reminder_outbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reminder_outbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `reminder_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `planned_date` date NOT NULL,
  `nature` varchar(255) NOT NULL DEFAULT 'reminder',
  `notification_number_days_before` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reminder_outbox_account_id_foreign` (`account_id`),
  KEY `reminder_outbox_reminder_id_foreign` (`reminder_id`),
  KEY `reminder_outbox_user_id_foreign` (`user_id`),
  CONSTRAINT `reminder_outbox_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reminder_outbox_reminder_id_foreign` FOREIGN KEY (`reminder_id`) REFERENCES `reminders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reminder_outbox_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminder_outbox`
--

LOCK TABLES `reminder_outbox` WRITE;
/*!40000 ALTER TABLE `reminder_outbox` DISABLE KEYS */;
INSERT INTO `reminder_outbox` VALUES (1,3,1,3,'2024-01-04','reminder',NULL,'2024-01-03 01:36:12','2024-01-03 01:36:12'),(2,3,2,3,'2024-08-06','reminder',NULL,'2024-01-09 16:03:07','2024-01-09 16:03:07'),(3,3,2,3,'2024-07-30','notification',7,'2024-01-09 16:03:07','2024-01-09 16:03:07'),(4,3,2,3,'2024-07-07','notification',30,'2024-01-09 16:03:07','2024-01-09 16:03:07'),(5,3,3,3,'2024-05-12','reminder',NULL,'2024-01-09 16:04:10','2024-01-09 16:04:10'),(6,3,3,3,'2024-05-05','notification',7,'2024-01-09 16:04:10','2024-01-09 16:04:10'),(7,3,3,3,'2024-04-12','notification',30,'2024-01-09 16:04:10','2024-01-09 16:04:10'),(8,3,4,3,'2024-05-19','reminder',NULL,'2024-01-09 16:45:29','2024-01-09 16:45:29'),(9,3,4,3,'2024-05-12','notification',7,'2024-01-09 16:45:29','2024-01-09 16:45:29'),(10,3,4,3,'2024-04-19','notification',30,'2024-01-09 16:45:29','2024-01-09 16:45:29'),(11,3,5,3,'2024-01-15','reminder',NULL,'2024-01-10 09:59:35','2024-01-10 09:59:35'),(12,3,6,3,'2024-01-17','reminder',NULL,'2024-01-11 06:02:55','2024-01-11 06:02:55'),(13,3,7,3,'2025-01-16','reminder',NULL,'2024-01-16 12:25:06','2024-01-16 12:25:06'),(14,3,7,3,'2025-01-09','notification',7,'2024-01-16 12:25:06','2024-01-16 12:25:06'),(15,3,7,3,'2024-12-17','notification',30,'2024-01-16 12:25:06','2024-01-16 12:25:06'),(16,3,8,3,'2025-01-19','reminder',NULL,'2024-01-20 16:01:25','2024-01-20 16:01:25'),(17,3,8,3,'2025-01-12','notification',7,'2024-01-20 16:01:25','2024-01-20 16:01:25'),(18,3,8,3,'2024-12-20','notification',30,'2024-01-20 16:01:25','2024-01-20 16:01:25'),(19,3,9,3,'2024-02-05','reminder',NULL,'2024-01-25 04:24:22','2024-01-25 04:24:22'),(20,3,9,3,'2024-01-29','notification',7,'2024-01-25 04:24:22','2024-01-25 04:24:22'),(21,3,10,3,'2025-02-04','reminder',NULL,'2024-02-04 21:03:18','2024-02-04 21:03:18'),(22,3,10,3,'2025-01-28','notification',7,'2024-02-04 21:03:18','2024-02-04 21:03:18'),(23,3,10,3,'2025-01-05','notification',30,'2024-02-04 21:03:18','2024-02-04 21:03:18');
/*!40000 ALTER TABLE `reminder_outbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminder_rules`
--

DROP TABLE IF EXISTS `reminder_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reminder_rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `number_of_days_before` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reminder_rules_account_id_foreign` (`account_id`),
  CONSTRAINT `reminder_rules_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminder_rules`
--

LOCK TABLES `reminder_rules` WRITE;
/*!40000 ALTER TABLE `reminder_rules` DISABLE KEYS */;
INSERT INTO `reminder_rules` VALUES (1,1,7,1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,1,30,1,'2024-01-02 23:41:17','2024-01-02 23:41:17'),(3,2,7,1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(4,2,30,1,'2024-01-02 23:41:18','2024-01-02 23:41:18'),(5,3,7,1,'2024-01-02 23:41:19','2024-01-02 23:41:19'),(6,3,30,1,'2024-01-02 23:41:19','2024-01-02 23:41:19');
/*!40000 ALTER TABLE `reminder_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminders`
--

DROP TABLE IF EXISTS `reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `initial_date` date NOT NULL,
  `title` mediumtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `frequency_type` varchar(255) NOT NULL,
  `frequency_number` int(11) DEFAULT NULL,
  `delible` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reminders_contact_id_foreign` (`contact_id`),
  KEY `reminders_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `reminders_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reminders_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminders`
--

LOCK TABLES `reminders` WRITE;
/*!40000 ALTER TABLE `reminders` DISABLE KEYS */;
INSERT INTO `reminders` VALUES (1,NULL,3,10,'2024-01-04','Wish happy birthday to RibstheGoblin',NULL,'year',1,0,0,'2024-01-03 01:36:12','2024-01-03 01:36:12'),(2,NULL,3,3,'2024-08-06','Wish happy birthday to TheForebringer',NULL,'year',1,0,0,'2024-01-09 16:03:07','2024-01-09 16:03:07'),(3,NULL,3,2,'2024-05-12','Wish happy birthday to R3zzy_exe',NULL,'year',1,0,0,'2024-01-09 16:04:10','2024-01-09 16:04:10'),(4,NULL,3,7,'2024-05-19','Wish happy birthday to Ryan',NULL,'year',1,0,0,'2024-01-09 16:45:29','2024-01-09 16:45:29'),(5,NULL,3,18,'2024-01-15','Wish happy birthday to Feydruidia',NULL,'year',1,0,0,'2024-01-10 09:59:35','2024-01-10 09:59:35'),(6,NULL,3,6,'2024-01-17','Wish happy birthday to Gilphchen',NULL,'year',1,0,0,'2024-01-11 06:02:55','2024-01-11 06:02:55'),(7,NULL,3,21,'2024-01-16','Wish happy birthday to The_Dummiest_Demon',NULL,'year',1,0,0,'2024-01-16 12:25:06','2024-01-16 12:25:06'),(8,NULL,3,22,'2024-01-19','Wish happy birthday to ExEro',NULL,'year',1,0,0,'2024-01-20 16:01:25','2024-01-20 16:01:25'),(9,NULL,3,17,'2024-02-05','Collab','2am','one_time',1,1,0,'2024-01-25 04:24:22','2024-01-25 04:24:22'),(10,NULL,3,23,'2024-02-04','Wish happy birthday to LuceBreaks',NULL,'year',1,0,0,'2024-02-04 21:03:18','2024-02-04 21:03:18');
/*!40000 ALTER TABLE `reminders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminders_sent`
--

DROP TABLE IF EXISTS `reminders_sent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reminders_sent` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  `reminder_id` int(11) DEFAULT NULL,
  `title` mediumtext NOT NULL,
  `description` longtext NOT NULL,
  `html_sent_content` longtext NOT NULL,
  `sent_date` datetime NOT NULL,
  `scheduled_number_days_before` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminders_sent`
--

LOCK TABLES `reminders_sent` WRITE;
/*!40000 ALTER TABLE `reminders_sent` DISABLE KEYS */;
/*!40000 ALTER TABLE `reminders_sent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `special_dates`
--

DROP TABLE IF EXISTS `special_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `special_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `uuid` char(36) DEFAULT NULL,
  `is_age_based` tinyint(1) NOT NULL DEFAULT 0,
  `is_year_unknown` tinyint(1) NOT NULL DEFAULT 0,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `special_dates_account_id_uuid_index` (`account_id`,`uuid`),
  KEY `special_dates_contact_id_foreign` (`contact_id`),
  CONSTRAINT `special_dates_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `special_dates_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `special_dates`
--

LOCK TABLES `special_dates` WRITE;
/*!40000 ALTER TABLE `special_dates` DISABLE KEYS */;
INSERT INTO `special_dates` VALUES (1,3,10,NULL,0,1,'2024-01-04','2024-01-03 01:36:12','2024-01-03 01:36:12'),(2,3,11,NULL,0,1,'2024-01-08','2024-01-05 05:56:21','2024-01-05 05:56:22'),(3,3,14,NULL,0,1,'2024-05-14','2024-01-07 01:55:36','2024-01-07 01:55:36'),(4,3,16,NULL,0,0,'1999-09-26','2024-01-07 02:07:07','2024-01-07 02:07:07'),(6,3,3,NULL,0,1,'2024-08-06','2024-01-09 16:03:07','2024-01-09 16:03:07'),(8,3,2,NULL,0,1,'2024-05-12','2024-01-09 16:04:10','2024-01-09 16:04:10'),(9,3,7,NULL,0,1,'2024-05-19','2024-01-09 16:45:29','2024-01-09 16:45:29'),(10,3,18,NULL,0,1,'2024-01-15','2024-01-10 09:59:35','2024-01-10 09:59:35'),(11,3,6,NULL,0,1,'2024-01-17','2024-01-11 06:02:55','2024-01-11 06:02:55'),(13,3,21,NULL,0,1,'2024-01-16','2024-01-16 12:25:06','2024-01-16 12:25:06'),(14,3,22,NULL,0,1,'2024-01-19','2024-01-20 16:01:25','2024-01-20 16:01:25'),(15,3,23,NULL,0,1,'2024-02-04','2024-02-04 21:03:18','2024-02-04 21:03:18'),(16,3,25,NULL,0,1,'2024-05-09','2024-05-19 13:04:21','2024-05-19 13:04:21');
/*!40000 ALTER TABLE `special_dates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `statistics`
--

DROP TABLE IF EXISTS `statistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `statistics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number_of_users` int(11) NOT NULL,
  `number_of_contacts` int(11) NOT NULL,
  `number_of_notes` int(11) NOT NULL,
  `number_of_oauth_access_tokens` int(11) NOT NULL,
  `number_of_oauth_clients` int(11) NOT NULL,
  `number_of_offsprings` int(11) NOT NULL,
  `number_of_progenitors` int(11) NOT NULL,
  `number_of_relationships` int(11) NOT NULL,
  `number_of_subscriptions` int(11) NOT NULL,
  `number_of_reminders` int(11) NOT NULL,
  `number_of_tasks` int(11) NOT NULL,
  `number_of_kids` int(11) NOT NULL,
  `number_of_activities` int(11) NOT NULL,
  `number_of_addresses` int(11) NOT NULL,
  `number_of_api_calls` int(11) NOT NULL,
  `number_of_calls` int(11) NOT NULL,
  `number_of_contact_fields` int(11) NOT NULL,
  `number_of_contact_field_types` int(11) NOT NULL,
  `number_of_debts` int(11) NOT NULL,
  `number_of_entries` int(11) NOT NULL,
  `number_of_gifts` int(11) NOT NULL,
  `number_of_invitations_sent` int(11) DEFAULT NULL,
  `number_of_accounts_with_more_than_one_user` int(11) DEFAULT NULL,
  `number_of_tags` int(11) DEFAULT NULL,
  `number_of_import_jobs` int(11) DEFAULT NULL,
  `number_of_conversations` int(11) DEFAULT NULL,
  `number_of_messages` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `statistics`
--

LOCK TABLES `statistics` WRITE;
/*!40000 ALTER TABLE `statistics` DISABLE KEYS */;
/*!40000 ALTER TABLE `statistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscription_items`
--

DROP TABLE IF EXISTS `subscription_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscription_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) unsigned NOT NULL,
  `stripe_id` varchar(255) NOT NULL,
  `stripe_product` varchar(255) DEFAULT NULL,
  `stripe_price` varchar(255) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscription_items_subscription_id_stripe_plan_unique` (`subscription_id`,`stripe_price`),
  KEY `subscription_items_stripe_id_index` (`stripe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscription_items`
--

LOCK TABLES `subscription_items` WRITE;
/*!40000 ALTER TABLE `subscription_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscription_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `stripe_id` varchar(255) NOT NULL,
  `stripe_status` varchar(255) NOT NULL,
  `stripe_price` varchar(255) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `ends_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_account_id_stripe_status_index` (`account_id`,`stripe_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscriptions`
--

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `synctoken`
--

DROP TABLE IF EXISTS `synctoken`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `synctoken` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT 'contacts',
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `synctoken_user_id_foreign` (`user_id`),
  KEY `synctoken_account_id_user_id_name_index` (`account_id`,`user_id`,`name`),
  CONSTRAINT `synctoken_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `synctoken_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `synctoken`
--

LOCK TABLES `synctoken` WRITE;
/*!40000 ALTER TABLE `synctoken` DISABLE KEYS */;
/*!40000 ALTER TABLE `synctoken` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `name_slug` varchar(255) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tags_account_id_foreign` (`account_id`),
  CONSTRAINT `tags_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,3,'vtuber','vtuber',NULL,'2024-01-09 16:45:37','2024-01-09 16:45:37');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned DEFAULT NULL,
  `uuid` char(36) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT 0,
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_account_id_uuid_index` (`account_id`,`uuid`),
  KEY `tasks_contact_id_foreign` (`contact_id`),
  CONSTRAINT `tasks_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tasks_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `term_user`
--

DROP TABLE IF EXISTS `term_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `term_user` (
  `account_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `term_user_account_id_foreign` (`account_id`),
  KEY `term_user_user_id_foreign` (`user_id`),
  KEY `term_user_term_id_foreign` (`term_id`),
  CONSTRAINT `term_user_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `term_user_term_id_foreign` FOREIGN KEY (`term_id`) REFERENCES `terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `term_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `term_user`
--

LOCK TABLES `term_user` WRITE;
/*!40000 ALTER TABLE `term_user` DISABLE KEYS */;
INSERT INTO `term_user` VALUES (1,1,1,'127.0.0.1','2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,2,1,'127.0.0.1','2024-01-02 23:41:18','2024-01-02 23:41:18'),(3,3,1,'127.0.0.1','2024-01-02 23:41:19','2024-01-02 23:41:19');
/*!40000 ALTER TABLE `term_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `terms`
--

DROP TABLE IF EXISTS `terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `terms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term_version` varchar(255) NOT NULL,
  `term_content` mediumtext NOT NULL,
  `privacy_version` varchar(255) NOT NULL,
  `privacy_content` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `terms`
--

LOCK TABLES `terms` WRITE;
/*!40000 ALTER TABLE `terms` DISABLE KEYS */;
INSERT INTO `terms` VALUES (1,'2','\nScope of service\nMonica supports the following browsers:\n\nInternet Explorer (11+)\nFirefox (50+)\nChrome (latest)\nSafari (latest)\nI do not guarantee that the site will work with other browsers, but it’s very likely that it will just work.\n\nRights\nYou don’t have to provide your real name when you register to an account. You do however need a valid email address if you want to upgrade your account to the paid version, or receive reminders by email.\n\nYou have the right to close your account at any time.\n\nYou have the right to export your data at any time, in the SQL format.\n\nYour data will not be intentionally shown to other users or shared with third parties.\n\nYour personal data will not be shared with anyone without your consent.\n\nYour data is backed up every hour.\n\nIf the site ceases operation, you will receive an opportunity to export all your data before the site dies.\n\nAny new features that affect privacy will be strictly opt-in.\n\nResponsibilities\nYou will not use the site to store illegal information or data under the Canadian law (or any law).\n\nYou have to be at least 18+ to create an account and use the site.\n\nYou must not abuse the site by knowingly posting malicious code that could harm you or the other users.\n\nYou must only use the site to do things that are widely accepted as morally good.\n\nYou may not make automated requests to the site.\n\nYou may not abuse the invitation system.\n\nYou are responsible for keeping your account secure.\n\nI reserve the right to close accounts that abuse the system (thousands of contacts with hundred of thousands of reminders for instance) or use it in an unreasonable manner.\n\nOther important legal stuff\nThough I want to provide a great service, there are certain things about the service I cannot promise. For example, the services and software are provided “as-is”, at your own risk, without express or implied warranty or condition of any kind. I also disclaim any warranties of merchantability, fitness for a particular purpose or non-infringement. Monica will have no responsibility for any harm to your computer system, loss or corruption of data, or other harm that results from your access to or use of the Services or Software.\n\nThese Terms can change at any time, but I’ll never be a dick about it. Running this site is a dream come true to me, and I hope I’ll be able to run it as long as I can.\n        ','2','\nMonica is an open source project. The hosted version has a premium plan that let us collect money so we can pay for the servers and additional servers, but the main goal is not to make money (otherwise we wouldn’t have opened source it).\n\nMonica comes in two flavors: you can either use our hosted version, or download it and run it yourself. In the latter case, we do not track anything at all. We don’t know that you’ve even downloaded the product. Do whatever you want with it (but respect your local laws).\n\nWhen you create your account on our hosted version, you are giving the site information about yourself that we collect. This includes your name, your email address and your password, that is encrypted before being stored. We do not store any other personal information.\n\nWhen you login to the service, we are using cookies to remember your login credentials. This is the only use we do with the cookies.\n\nMonica runs on Linode and we are the only ones, apart from Linode’s employees, who have access to those servers.\n\nWe do hourly backups of the database.\n\nYour password is encrypted with bcrypt, a password hashing algorithm that is highly secure. You can also activate two factor authentication on your account if you need an extra layer of security. Apart from those encryptions mechanism, your data is not encrypted in the database. If someone gets access to the database, they will be able to read your data. We do our best to make sure that this will never happen, but it can happen.\n\nIf a data breach happens, we will contact the users who are affected to warn them about the breach.\n\nTransactional emails are dserved through Postmark.\n\nWe use an open source tool called Sentry to track errors that happen in production. Their service records the errors, but they don’t have access to any information apart the account ID, which lets me debug what’s going on.\n\nThe site does not currently and will never show ads. It also does not, and don’t intend to, sell data to a third party, with or without your consent. We are just against this. Fuck ads.\n\nWe do no use any tracking third parties, like Google Analytics or Intercom, that track user behaviours or data, neither on the marketing site or the hosted version. We are deeply against their principles as they would use those data to profile you, which we are totally against.\n\nAll the data you put on Monica belongs to you. We do not have any rights on it. Please don’t put illegal stuff on it, otherwise we’d be in trouble.\n\nAll the information about the contacts you put on Monica are private to you. We do not cross link information between accounts or use one information in an account to populate another account (unlike Facebook for instance).\n\nWe use Stripe to collect payments made to access the paid version. We do not store credit card information or anything concerning the transactions themselves on our servers. However, as per the open source library we use to process the payments (Laravel Cashier), we store the last 4 digits of the credit card, the brand name (VISA or MasterCard). As a user, you are identified on Stripe by a random number that they generate and use.\n\nRegarding the payments, you can downgrade to the free plan whenever you like. When you do, Stripe is automatically updated and we have no way to charge you again, even if we would like to. The less we deal with payment information, the happier we are.\n\nYou can export your data at any time. You can also use the API to export all your data if you know how to do it. You can also request that we process this ourselves and send it to you. Your data will be exported in the SQL format.\n\nWhen you close your account, we immediately destroy all your personal information and don’t keep any backup. While you have control over this, we can delete an account for you if you ask us.\n\nIn certain situations, we may be required to disclose peronal data in response to lawful requests by public authorities, including to met national security or law enforcements requirements. We just hope that this never happens.\n\nIf you violate the terms of use we will terminate your account and notify you about it. However if you follow the \"don’t be a dick\" policy, nothing should ever happen to you and we’ll all be happy.\n\nMonica uses only open-source projects that are mainly hosted on Github.\n\nWe will update this privacy policy as soon as we introduce new information practices. If we do, we will send an email to the email address specified in your account. We will never be a dick about it and will never, ever, introduce something in what we do that will affect your right to the absolute privacy.','2018-04-11 23:00:00',NULL);
/*!40000 ALTER TABLE `terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `u2f_key`
--

DROP TABLE IF EXISTS `u2f_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `u2f_key` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'key',
  `user_id` int(10) unsigned NOT NULL,
  `keyHandle` varchar(255) NOT NULL,
  `publicKey` varchar(255) NOT NULL,
  `certificate` text NOT NULL,
  `counter` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `u2f_key_publickey_unique` (`publicKey`),
  KEY `u2f_key_user_id_foreign` (`user_id`),
  CONSTRAINT `u2f_key_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `u2f_key`
--

LOCK TABLES `u2f_key` WRITE;
/*!40000 ALTER TABLE `u2f_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `u2f_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `me_contact_id` int(10) unsigned DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT 0,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `google2fa_secret` varchar(256) DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `timezone` varchar(255) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT 2,
  `locale` varchar(255) NOT NULL DEFAULT 'en',
  `metric` varchar(255) NOT NULL DEFAULT 'fahrenheit',
  `fluid_container` varchar(255) NOT NULL DEFAULT 'false',
  `contacts_sort_order` varchar(255) NOT NULL DEFAULT 'firstnameAZ',
  `name_order` varchar(255) NOT NULL DEFAULT 'firstname_lastname_nickname',
  `invited_by_user_id` int(10) unsigned DEFAULT NULL,
  `dashboard_active_tab` varchar(255) NOT NULL DEFAULT 'calls',
  `gifts_active_tab` varchar(255) NOT NULL DEFAULT 'ideas',
  `profile_active_tab` varchar(255) NOT NULL DEFAULT 'notes',
  `profile_new_life_event_badge_seen` tinyint(1) NOT NULL DEFAULT 0,
  `temperature_scale` varchar(255) DEFAULT 'celsius',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_me_contact_id_foreign` (`me_contact_id`),
  KEY `users_currency_id_foreign` (`currency_id`),
  KEY `users_invited_by_user_id_foreign` (`invited_by_user_id`),
  KEY `users_account_id_uuid_index` (`account_id`,`uuid`),
  CONSTRAINT `users_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_invited_by_user_id_foreign` FOREIGN KEY (`invited_by_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_me_contact_id_foreign` FOREIGN KEY (`me_contact_id`) REFERENCES `contacts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,NULL,'John','Doe','admin@admin.com',NULL,0,NULL,'$2y$10$n/HFsot/KCZ41PCiNprVKep53ZmP1BsSNtJve5xCfjs0FQ/ZdADeW',NULL,NULL,1,'America/Chicago',2,'en','fahrenheit','false','firstnameAZ','firstname_lastname_nickname',NULL,'calls','ideas','notes',0,'fahrenheit','2024-01-02 23:41:17','2024-01-02 23:41:17'),(2,NULL,'Blank','State','blank@blank.com',NULL,0,NULL,'$2y$10$yyXGZ1ONmiBn1WnHuqfEiORvmq.sVvF2eJgV5QsHa/dHQ31Kkl1JC',NULL,NULL,2,'America/Chicago',2,'en','fahrenheit','false','firstnameAZ','firstname_lastname_nickname',NULL,'calls','ideas','notes',0,'fahrenheit','2024-01-02 23:41:18','2024-01-02 23:41:18'),(3,NULL,'Mai','Dragora','mandraw@mandraw.noho.st',NULL,0,NULL,'$2y$10$27vcwGpZBmlkx4zPM24wsuXJZ0o0JQ7eAlP8Zaks1rppJISI9nyyW','icK0PWH4oTqheVvO7ArRydehD1CynClwSjOTH9JvlrhdfVvrInzIxvGlZd1r',NULL,3,'Europe/Paris',4,'en','fahrenheit','false','firstnameAZ','nickname_firstname_lastname',NULL,'calls','ideas','notes',1,'celsius','2024-01-02 23:41:19','2024-02-04 21:04:11');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `weather`
--

DROP TABLE IF EXISTS `weather`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `weather` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `place_id` int(10) unsigned NOT NULL,
  `weather_json` varchar(2000) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `weather_account_id_foreign` (`account_id`),
  KEY `weather_place_id_foreign` (`place_id`),
  CONSTRAINT `weather_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `weather_place_id_foreign` FOREIGN KEY (`place_id`) REFERENCES `places` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `weather`
--

LOCK TABLES `weather` WRITE;
/*!40000 ALTER TABLE `weather` DISABLE KEYS */;
/*!40000 ALTER TABLE `weather` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `webauthn_keys`
--

DROP TABLE IF EXISTS `webauthn_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `webauthn_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT 'key',
  `credentialId` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `transports` text NOT NULL,
  `attestationType` varchar(255) NOT NULL,
  `trustPath` text NOT NULL,
  `aaguid` text NOT NULL,
  `credentialPublicKey` text NOT NULL,
  `counter` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `webauthn_keys_user_id_foreign` (`user_id`),
  KEY `webauthn_keys_credentialid_index` (`credentialId`),
  CONSTRAINT `webauthn_keys_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `webauthn_keys`
--

LOCK TABLES `webauthn_keys` WRITE;
/*!40000 ALTER TABLE `webauthn_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `webauthn_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'monica'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed
