--
-- PostgreSQL database dump
--

-- Dumped from database version 13.16 (Debian 13.16-0+deb11u1)
-- Dumped by pg_dump version 13.16 (Debian 13.16-0+deb11u1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_emailaddress; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.account_emailaddress (
    id integer NOT NULL,
    email character varying(254) NOT NULL,
    verified boolean NOT NULL,
    "primary" boolean NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.account_emailaddress OWNER TO paperless_ngx;

--
-- Name: account_emailaddress_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.account_emailaddress ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.account_emailaddress_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: account_emailconfirmation; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.account_emailconfirmation (
    id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    sent timestamp with time zone,
    key character varying(64) NOT NULL,
    email_address_id integer NOT NULL
);


ALTER TABLE public.account_emailconfirmation OWNER TO paperless_ngx;

--
-- Name: account_emailconfirmation_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.account_emailconfirmation ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.account_emailconfirmation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auditlog_logentry; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auditlog_logentry (
    id integer NOT NULL,
    object_pk character varying(255) NOT NULL,
    object_id bigint,
    object_repr text NOT NULL,
    action smallint NOT NULL,
    changes text NOT NULL,
    "timestamp" timestamp with time zone NOT NULL,
    actor_id integer,
    content_type_id integer NOT NULL,
    remote_addr inet,
    additional_data jsonb,
    serialized_data jsonb,
    CONSTRAINT auditlog_logentry_action_check CHECK ((action >= 0))
);


ALTER TABLE public.auditlog_logentry OWNER TO paperless_ngx;

--
-- Name: auditlog_logentry_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auditlog_logentry ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auditlog_logentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_group; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_group (
    id integer NOT NULL,
    name character varying(150) NOT NULL
);


ALTER TABLE public.auth_group OWNER TO paperless_ngx;

--
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_group_permissions; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_group_permissions (
    id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_group_permissions OWNER TO paperless_ngx;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_group_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_permission; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_permission (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE public.auth_permission OWNER TO paperless_ngx;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_permission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_user (
    id integer NOT NULL,
    password character varying(128) NOT NULL,
    last_login timestamp with time zone,
    is_superuser boolean NOT NULL,
    username character varying(150) NOT NULL,
    first_name character varying(150) NOT NULL,
    last_name character varying(150) NOT NULL,
    email character varying(254) NOT NULL,
    is_staff boolean NOT NULL,
    is_active boolean NOT NULL,
    date_joined timestamp with time zone NOT NULL
);


ALTER TABLE public.auth_user OWNER TO paperless_ngx;

--
-- Name: auth_user_groups; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_user_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.auth_user_groups OWNER TO paperless_ngx;

--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_user_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_user ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user_user_permissions; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.auth_user_user_permissions (
    id integer NOT NULL,
    user_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_user_user_permissions OWNER TO paperless_ngx;

--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.auth_user_user_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authtoken_token; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.authtoken_token (
    key character varying(40) NOT NULL,
    created timestamp with time zone NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.authtoken_token OWNER TO paperless_ngx;

--
-- Name: django_admin_log; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_admin_log (
    id integer NOT NULL,
    action_time timestamp with time zone NOT NULL,
    object_id text,
    object_repr character varying(200) NOT NULL,
    action_flag smallint NOT NULL,
    change_message text NOT NULL,
    content_type_id integer,
    user_id integer NOT NULL,
    CONSTRAINT django_admin_log_action_flag_check CHECK ((action_flag >= 0))
);


ALTER TABLE public.django_admin_log OWNER TO paperless_ngx;

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_admin_log ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_admin_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_celery_results_chordcounter; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_celery_results_chordcounter (
    id integer NOT NULL,
    group_id character varying(255) NOT NULL,
    sub_tasks text NOT NULL,
    count integer NOT NULL,
    CONSTRAINT django_celery_results_chordcounter_count_check CHECK ((count >= 0))
);


ALTER TABLE public.django_celery_results_chordcounter OWNER TO paperless_ngx;

--
-- Name: django_celery_results_chordcounter_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_celery_results_chordcounter ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_celery_results_chordcounter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_celery_results_groupresult; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_celery_results_groupresult (
    id integer NOT NULL,
    group_id character varying(255) NOT NULL,
    date_created timestamp with time zone NOT NULL,
    date_done timestamp with time zone NOT NULL,
    content_type character varying(128) NOT NULL,
    content_encoding character varying(64) NOT NULL,
    result text
);


ALTER TABLE public.django_celery_results_groupresult OWNER TO paperless_ngx;

--
-- Name: django_celery_results_groupresult_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_celery_results_groupresult ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_celery_results_groupresult_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_celery_results_taskresult; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_celery_results_taskresult (
    id integer NOT NULL,
    task_id character varying(255) NOT NULL,
    status character varying(50) NOT NULL,
    content_type character varying(128) NOT NULL,
    content_encoding character varying(64) NOT NULL,
    result text,
    date_done timestamp with time zone NOT NULL,
    traceback text,
    meta text,
    task_args text,
    task_kwargs text,
    task_name character varying(255),
    worker character varying(100),
    date_created timestamp with time zone NOT NULL,
    periodic_task_name character varying(255)
);


ALTER TABLE public.django_celery_results_taskresult OWNER TO paperless_ngx;

--
-- Name: django_celery_results_taskresult_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_celery_results_taskresult ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_celery_results_taskresult_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_content_type; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_content_type (
    id integer NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE public.django_content_type OWNER TO paperless_ngx;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_content_type ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_migrations; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_migrations (
    id integer NOT NULL,
    app character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    applied timestamp with time zone NOT NULL
);


ALTER TABLE public.django_migrations OWNER TO paperless_ngx;

--
-- Name: django_migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.django_migrations ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_session; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp with time zone NOT NULL
);


ALTER TABLE public.django_session OWNER TO paperless_ngx;

--
-- Name: documents_note; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_note (
    id integer NOT NULL,
    note text NOT NULL,
    created timestamp with time zone NOT NULL,
    document_id integer,
    user_id integer
);


ALTER TABLE public.documents_note OWNER TO paperless_ngx;

--
-- Name: documents_comment_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_note ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_comment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_correspondent; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_correspondent (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    match character varying(256) NOT NULL,
    matching_algorithm integer NOT NULL,
    is_insensitive boolean NOT NULL,
    owner_id integer,
    CONSTRAINT documents_correspondent_matching_algorithm_check CHECK ((matching_algorithm >= 0))
);


ALTER TABLE public.documents_correspondent OWNER TO paperless_ngx;

--
-- Name: documents_customfield; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_customfield (
    id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    name character varying(128) NOT NULL,
    data_type character varying(50) NOT NULL
);


ALTER TABLE public.documents_customfield OWNER TO paperless_ngx;

--
-- Name: documents_customfield_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_customfield ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_customfield_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_customfieldinstance; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_customfieldinstance (
    id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    value_text character varying(128),
    value_bool boolean,
    value_url character varying(200),
    value_date date,
    value_int integer,
    value_float double precision,
    value_monetary character varying(128),
    document_id integer NOT NULL,
    field_id integer NOT NULL,
    value_document_ids jsonb
);


ALTER TABLE public.documents_customfieldinstance OWNER TO paperless_ngx;

--
-- Name: documents_customfieldinstance_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_customfieldinstance ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_customfieldinstance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_document; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_document (
    id integer NOT NULL,
    title character varying(128) NOT NULL,
    content text NOT NULL,
    created timestamp with time zone NOT NULL,
    modified timestamp with time zone NOT NULL,
    correspondent_id integer,
    checksum character varying(32) NOT NULL,
    added timestamp with time zone NOT NULL,
    storage_type character varying(11) NOT NULL,
    filename character varying(1024),
    archive_serial_number integer,
    document_type_id integer,
    mime_type character varying(256) NOT NULL,
    archive_checksum character varying(32),
    archive_filename character varying(1024),
    storage_path_id integer,
    original_filename character varying(1024),
    owner_id integer,
    CONSTRAINT documents_document_archive_serial_number_550aa63f_check CHECK ((archive_serial_number >= 0))
);


ALTER TABLE public.documents_document OWNER TO paperless_ngx;

--
-- Name: documents_document_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_document ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_document_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_document_tags; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_document_tags (
    id integer NOT NULL,
    document_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.documents_document_tags OWNER TO paperless_ngx;

--
-- Name: documents_document_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_document_tags ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_document_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_documenttype; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_documenttype (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    match character varying(256) NOT NULL,
    matching_algorithm integer NOT NULL,
    is_insensitive boolean NOT NULL,
    owner_id integer,
    CONSTRAINT documents_documenttype_matching_algorithm_check CHECK ((matching_algorithm >= 0))
);


ALTER TABLE public.documents_documenttype OWNER TO paperless_ngx;

--
-- Name: documents_documenttype_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_documenttype ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_documenttype_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_log; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_log (
    id integer NOT NULL,
    "group" uuid,
    message text NOT NULL,
    level integer NOT NULL,
    created timestamp with time zone NOT NULL,
    CONSTRAINT documents_log_level_check CHECK ((level >= 0))
);


ALTER TABLE public.documents_log OWNER TO paperless_ngx;

--
-- Name: documents_log_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_log ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_paperlesstask; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_paperlesstask (
    id integer NOT NULL,
    task_id character varying(255) NOT NULL,
    acknowledged boolean NOT NULL,
    date_created timestamp with time zone,
    date_done timestamp with time zone,
    date_started timestamp with time zone,
    result text,
    status character varying(30) NOT NULL,
    task_file_name character varying(255),
    task_name character varying(255)
);


ALTER TABLE public.documents_paperlesstask OWNER TO paperless_ngx;

--
-- Name: documents_paperlesstask_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_paperlesstask ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_paperlesstask_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_savedview; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_savedview (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    show_on_dashboard boolean NOT NULL,
    show_in_sidebar boolean NOT NULL,
    sort_field character varying(128),
    sort_reverse boolean NOT NULL,
    owner_id integer
);


ALTER TABLE public.documents_savedview OWNER TO paperless_ngx;

--
-- Name: documents_savedview_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_savedview ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_savedview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_savedviewfilterrule; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_savedviewfilterrule (
    id integer NOT NULL,
    rule_type integer NOT NULL,
    value character varying(255),
    saved_view_id integer NOT NULL,
    CONSTRAINT documents_savedviewfilterrule_rule_type_check CHECK ((rule_type >= 0))
);


ALTER TABLE public.documents_savedviewfilterrule OWNER TO paperless_ngx;

--
-- Name: documents_savedviewfilterrule_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_savedviewfilterrule ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_savedviewfilterrule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_correspondent ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_sender_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_sharelink; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_sharelink (
    id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    expiration timestamp with time zone,
    slug character varying(50) NOT NULL,
    file_version character varying(50) NOT NULL,
    document_id integer NOT NULL,
    owner_id integer
);


ALTER TABLE public.documents_sharelink OWNER TO paperless_ngx;

--
-- Name: documents_sharelink_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_sharelink ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_sharelink_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_storagepath; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_storagepath (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    match character varying(256) NOT NULL,
    matching_algorithm integer NOT NULL,
    is_insensitive boolean NOT NULL,
    path character varying(512) NOT NULL,
    owner_id integer,
    CONSTRAINT documents_storagepath_matching_algorithm_check CHECK ((matching_algorithm >= 0))
);


ALTER TABLE public.documents_storagepath OWNER TO paperless_ngx;

--
-- Name: documents_storagepath_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_storagepath ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_storagepath_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_tag; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_tag (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    match character varying(256) NOT NULL,
    matching_algorithm integer NOT NULL,
    is_insensitive boolean NOT NULL,
    is_inbox_tag boolean NOT NULL,
    color character varying(7) NOT NULL,
    owner_id integer,
    CONSTRAINT documents_tag_matching_algorithm_check CHECK ((matching_algorithm >= 0))
);


ALTER TABLE public.documents_tag OWNER TO paperless_ngx;

--
-- Name: documents_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_tag ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_uisettings; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_uisettings (
    id integer NOT NULL,
    settings jsonb,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_uisettings OWNER TO paperless_ngx;

--
-- Name: documents_uisettings_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_uisettings ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_uisettings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflow; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflow (
    id integer NOT NULL,
    name character varying(256) NOT NULL,
    "order" integer NOT NULL,
    enabled boolean NOT NULL
);


ALTER TABLE public.documents_workflow OWNER TO paperless_ngx;

--
-- Name: documents_workflow_actions; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflow_actions (
    id integer NOT NULL,
    workflow_id integer NOT NULL,
    workflowaction_id integer NOT NULL
);


ALTER TABLE public.documents_workflow_actions OWNER TO paperless_ngx;

--
-- Name: documents_workflow_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflow_actions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflow_actions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflow_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflow ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflow_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflow_triggers; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflow_triggers (
    id integer NOT NULL,
    workflow_id integer NOT NULL,
    workflowtrigger_id integer NOT NULL
);


ALTER TABLE public.documents_workflow_triggers OWNER TO paperless_ngx;

--
-- Name: documents_workflow_triggers_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflow_triggers ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflow_triggers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction (
    id integer NOT NULL,
    type integer NOT NULL,
    assign_title character varying(256),
    assign_correspondent_id integer,
    assign_document_type_id integer,
    assign_owner_id integer,
    assign_storage_path_id integer,
    remove_all_correspondents boolean NOT NULL,
    remove_all_custom_fields boolean NOT NULL,
    remove_all_document_types boolean NOT NULL,
    remove_all_owners boolean NOT NULL,
    remove_all_permissions boolean NOT NULL,
    remove_all_storage_paths boolean NOT NULL,
    remove_all_tags boolean NOT NULL,
    CONSTRAINT documents_workflowaction_type_check CHECK ((type >= 0))
);


ALTER TABLE public.documents_workflowaction OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_change_groups; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_change_groups (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_change_groups OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_change_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_change_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_change_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_assign_change_users; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_change_users (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_change_users OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_change_users_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_change_users ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_change_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_assign_custom_fields; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_custom_fields (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    customfield_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_custom_fields OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_custom_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_custom_fields ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_custom_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_assign_tags; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_tags (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_tags OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_tags ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_assign_view_groups; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_view_groups (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_view_groups OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_view_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_view_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_view_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_assign_view_users; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_assign_view_users (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_assign_view_users OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_assign_view_users_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_assign_view_users ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_assign_view_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_change_groups; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_change_groups (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_change_groups OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_change_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_change_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_change_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_change_users; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_change_users (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_change_users OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_change_users_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_change_users ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_change_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_correspondents; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_correspondents (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    correspondent_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_correspondents OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_correspondents_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_correspondents ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_correspondents_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_custom_fields; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_custom_fields (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    customfield_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_custom_fields OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_custom_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_custom_fields ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_custom_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_document_types; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_document_types (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    documenttype_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_document_types OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_document_types_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_document_types ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_document_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_owners; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_owners (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_owners OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_owners_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_owners ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_owners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_storage_paths; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_storage_paths (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    storagepath_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_storage_paths OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_storage_paths_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_storage_paths ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_storage_paths_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_tags; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_tags (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_tags OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_tags ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_view_groups; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_view_groups (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_view_groups OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_view_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_view_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_view_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowaction_remove_view_users; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowaction_remove_view_users (
    id integer NOT NULL,
    workflowaction_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.documents_workflowaction_remove_view_users OWNER TO paperless_ngx;

--
-- Name: documents_workflowaction_remove_view_users_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowaction_remove_view_users ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowaction_remove_view_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowtrigger; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowtrigger (
    id integer NOT NULL,
    type integer NOT NULL,
    sources character varying(5) NOT NULL,
    filter_path character varying(256),
    filter_filename character varying(256),
    filter_mailrule_id integer,
    matching_algorithm integer NOT NULL,
    match character varying(256) NOT NULL,
    is_insensitive boolean NOT NULL,
    filter_has_document_type_id integer,
    filter_has_correspondent_id integer,
    CONSTRAINT documents_workflowtrigger_matching_algorithm_check CHECK ((matching_algorithm >= 0)),
    CONSTRAINT documents_workflowtrigger_type_check CHECK ((type >= 0))
);


ALTER TABLE public.documents_workflowtrigger OWNER TO paperless_ngx;

--
-- Name: documents_workflowtrigger_filter_has_tags; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.documents_workflowtrigger_filter_has_tags (
    id integer NOT NULL,
    workflowtrigger_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.documents_workflowtrigger_filter_has_tags OWNER TO paperless_ngx;

--
-- Name: documents_workflowtrigger_filter_has_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowtrigger_filter_has_tags ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowtrigger_filter_has_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: documents_workflowtrigger_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.documents_workflowtrigger ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.documents_workflowtrigger_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: guardian_groupobjectpermission; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.guardian_groupobjectpermission (
    id integer NOT NULL,
    object_pk character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.guardian_groupobjectpermission OWNER TO paperless_ngx;

--
-- Name: guardian_groupobjectpermission_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.guardian_groupobjectpermission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.guardian_groupobjectpermission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: guardian_userobjectpermission; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.guardian_userobjectpermission (
    id integer NOT NULL,
    object_pk character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    permission_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.guardian_userobjectpermission OWNER TO paperless_ngx;

--
-- Name: guardian_userobjectpermission_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.guardian_userobjectpermission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.guardian_userobjectpermission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: paperless_applicationconfiguration; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.paperless_applicationconfiguration (
    id integer NOT NULL,
    output_type character varying(8),
    pages integer,
    language character varying(32),
    mode character varying(16),
    skip_archive_file character varying(16),
    image_dpi integer,
    unpaper_clean character varying(16),
    deskew boolean,
    rotate_pages boolean,
    rotate_pages_threshold double precision,
    max_image_pixels double precision,
    color_conversion_strategy character varying(32),
    user_args jsonb,
    app_logo character varying(100),
    app_title character varying(48),
    CONSTRAINT paperless_applicationconfiguration_image_dpi_check CHECK ((image_dpi >= 0)),
    CONSTRAINT paperless_applicationconfiguration_pages_check CHECK ((pages >= 0))
);


ALTER TABLE public.paperless_applicationconfiguration OWNER TO paperless_ngx;

--
-- Name: paperless_applicationconfiguration_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.paperless_applicationconfiguration ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.paperless_applicationconfiguration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: paperless_mail_mailaccount; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.paperless_mail_mailaccount (
    id integer NOT NULL,
    name character varying(256) NOT NULL,
    imap_server character varying(256) NOT NULL,
    imap_port integer,
    imap_security integer NOT NULL,
    username character varying(256) NOT NULL,
    password character varying(2048) NOT NULL,
    character_set character varying(256) NOT NULL,
    owner_id integer,
    is_token boolean NOT NULL,
    CONSTRAINT paperless_mail_mailaccount_imap_security_check CHECK ((imap_security >= 0))
);


ALTER TABLE public.paperless_mail_mailaccount OWNER TO paperless_ngx;

--
-- Name: paperless_mail_mailaccount_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.paperless_mail_mailaccount ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.paperless_mail_mailaccount_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: paperless_mail_mailrule; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.paperless_mail_mailrule (
    id integer NOT NULL,
    name character varying(256) NOT NULL,
    folder character varying(256) NOT NULL,
    filter_from character varying(256),
    filter_subject character varying(256),
    filter_body character varying(256),
    maximum_age integer NOT NULL,
    action integer NOT NULL,
    action_parameter character varying(256),
    assign_title_from integer NOT NULL,
    assign_correspondent_from integer NOT NULL,
    account_id integer NOT NULL,
    assign_correspondent_id integer,
    assign_document_type_id integer,
    "order" integer NOT NULL,
    attachment_type integer NOT NULL,
    filter_attachment_filename_include character varying(256),
    consumption_scope integer NOT NULL,
    owner_id integer,
    filter_to character varying(256),
    assign_owner_from_rule boolean NOT NULL,
    filter_attachment_filename_exclude character varying(256),
    CONSTRAINT paperless_mail_mailrule_action_check CHECK ((action >= 0)),
    CONSTRAINT paperless_mail_mailrule_assign_correspondent_from_check CHECK ((assign_correspondent_from >= 0)),
    CONSTRAINT paperless_mail_mailrule_assign_title_from_check CHECK ((assign_title_from >= 0)),
    CONSTRAINT paperless_mail_mailrule_attachment_type_check CHECK ((attachment_type >= 0)),
    CONSTRAINT paperless_mail_mailrule_consumption_scope_check CHECK ((consumption_scope >= 0)),
    CONSTRAINT paperless_mail_mailrule_maximum_age_check CHECK ((maximum_age >= 0))
);


ALTER TABLE public.paperless_mail_mailrule OWNER TO paperless_ngx;

--
-- Name: paperless_mail_mailrule_assign_tags; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.paperless_mail_mailrule_assign_tags (
    id integer NOT NULL,
    mailrule_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.paperless_mail_mailrule_assign_tags OWNER TO paperless_ngx;

--
-- Name: paperless_mail_mailrule_assign_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.paperless_mail_mailrule_assign_tags ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.paperless_mail_mailrule_assign_tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: paperless_mail_mailrule_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.paperless_mail_mailrule ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.paperless_mail_mailrule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: paperless_mail_processedmail; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.paperless_mail_processedmail (
    id integer NOT NULL,
    folder character varying(256) NOT NULL,
    uid character varying(256) NOT NULL,
    subject character varying(256) NOT NULL,
    received timestamp with time zone NOT NULL,
    processed timestamp with time zone NOT NULL,
    status character varying(256) NOT NULL,
    error text,
    owner_id integer,
    rule_id integer NOT NULL
);


ALTER TABLE public.paperless_mail_processedmail OWNER TO paperless_ngx;

--
-- Name: paperless_mail_processedmail_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.paperless_mail_processedmail ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.paperless_mail_processedmail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: socialaccount_socialaccount; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.socialaccount_socialaccount (
    id integer NOT NULL,
    provider character varying(200) NOT NULL,
    uid character varying(191) NOT NULL,
    last_login timestamp with time zone NOT NULL,
    date_joined timestamp with time zone NOT NULL,
    extra_data jsonb NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.socialaccount_socialaccount OWNER TO paperless_ngx;

--
-- Name: socialaccount_socialaccount_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.socialaccount_socialaccount ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.socialaccount_socialaccount_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: socialaccount_socialapp; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.socialaccount_socialapp (
    id integer NOT NULL,
    provider character varying(30) NOT NULL,
    name character varying(40) NOT NULL,
    client_id character varying(191) NOT NULL,
    secret character varying(191) NOT NULL,
    key character varying(191) NOT NULL,
    provider_id character varying(200) NOT NULL,
    settings jsonb NOT NULL
);


ALTER TABLE public.socialaccount_socialapp OWNER TO paperless_ngx;

--
-- Name: socialaccount_socialapp_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.socialaccount_socialapp ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.socialaccount_socialapp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: socialaccount_socialtoken; Type: TABLE; Schema: public; Owner: paperless_ngx
--

CREATE TABLE public.socialaccount_socialtoken (
    id integer NOT NULL,
    token text NOT NULL,
    token_secret text NOT NULL,
    expires_at timestamp with time zone,
    account_id integer NOT NULL,
    app_id integer
);


ALTER TABLE public.socialaccount_socialtoken OWNER TO paperless_ngx;

--
-- Name: socialaccount_socialtoken_id_seq; Type: SEQUENCE; Schema: public; Owner: paperless_ngx
--

ALTER TABLE public.socialaccount_socialtoken ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.socialaccount_socialtoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Data for Name: account_emailaddress; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.account_emailaddress (id, email, verified, "primary", user_id) FROM stdin;
\.


--
-- Data for Name: account_emailconfirmation; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.account_emailconfirmation (id, created, sent, key, email_address_id) FROM stdin;
\.


--
-- Data for Name: auditlog_logentry; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auditlog_logentry (id, object_pk, object_id, object_repr, action, changes, "timestamp", actor_id, content_type_id, remote_addr, additional_data, serialized_data) FROM stdin;
\.


--
-- Data for Name: auth_group; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_group (id, name) FROM stdin;
\.


--
-- Data for Name: auth_group_permissions; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_group_permissions (id, group_id, permission_id) FROM stdin;
\.


--
-- Data for Name: auth_permission; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_permission (id, name, content_type_id, codename) FROM stdin;
1	Can add log entry	1	add_logentry
2	Can change log entry	1	change_logentry
3	Can delete log entry	1	delete_logentry
4	Can view log entry	1	view_logentry
5	Can add permission	2	add_permission
6	Can change permission	2	change_permission
7	Can delete permission	2	delete_permission
8	Can view permission	2	view_permission
9	Can add group	3	add_group
10	Can change group	3	change_group
11	Can delete group	3	delete_group
12	Can view group	3	view_group
13	Can add user	4	add_user
14	Can change user	4	change_user
15	Can delete user	4	delete_user
16	Can view user	4	view_user
17	Can add Token	5	add_token
18	Can change Token	5	change_token
19	Can delete Token	5	delete_token
20	Can view Token	5	view_token
21	Can add token	6	add_tokenproxy
22	Can change token	6	change_tokenproxy
23	Can delete token	6	delete_tokenproxy
24	Can view token	6	view_tokenproxy
25	Can add content type	7	add_contenttype
26	Can change content type	7	change_contenttype
27	Can delete content type	7	delete_contenttype
28	Can view content type	7	view_contenttype
29	Can add task result	8	add_taskresult
30	Can change task result	8	change_taskresult
31	Can delete task result	8	delete_taskresult
32	Can view task result	8	view_taskresult
33	Can add chord counter	9	add_chordcounter
34	Can change chord counter	9	change_chordcounter
35	Can delete chord counter	9	delete_chordcounter
36	Can view chord counter	9	view_chordcounter
37	Can add group result	10	add_groupresult
38	Can change group result	10	change_groupresult
39	Can delete group result	10	delete_groupresult
40	Can view group result	10	view_groupresult
41	Can add document	11	add_document
42	Can change document	11	change_document
43	Can delete document	11	delete_document
44	Can view document	11	view_document
45	Can add tag	12	add_tag
46	Can change tag	12	change_tag
47	Can delete tag	12	delete_tag
48	Can view tag	12	view_tag
49	Can add log	13	add_log
50	Can change log	13	change_log
51	Can delete log	13	delete_log
52	Can view log	13	view_log
53	Can add correspondent	14	add_correspondent
54	Can change correspondent	14	change_correspondent
55	Can delete correspondent	14	delete_correspondent
56	Can view correspondent	14	view_correspondent
57	Can add document type	15	add_documenttype
58	Can change document type	15	change_documenttype
59	Can delete document type	15	delete_documenttype
60	Can view document type	15	view_documenttype
61	Can add saved view	16	add_savedview
62	Can change saved view	16	change_savedview
63	Can delete saved view	16	delete_savedview
64	Can view saved view	16	view_savedview
65	Can add filter rule	17	add_savedviewfilterrule
66	Can change filter rule	17	change_savedviewfilterrule
67	Can delete filter rule	17	delete_savedviewfilterrule
68	Can view filter rule	17	view_savedviewfilterrule
69	Can add ui settings	18	add_uisettings
70	Can change ui settings	18	change_uisettings
71	Can delete ui settings	18	delete_uisettings
72	Can view ui settings	18	view_uisettings
73	Can add storage path	19	add_storagepath
74	Can change storage path	19	change_storagepath
75	Can delete storage path	19	delete_storagepath
76	Can view storage path	19	view_storagepath
77	Can add paperless task	20	add_paperlesstask
78	Can change paperless task	20	change_paperlesstask
79	Can delete paperless task	20	delete_paperlesstask
80	Can view paperless task	20	view_paperlesstask
81	Can add note	21	add_note
82	Can change note	21	change_note
83	Can delete note	21	delete_note
84	Can view note	21	view_note
85	Can add share link	22	add_sharelink
86	Can change share link	22	change_sharelink
87	Can delete share link	22	delete_sharelink
88	Can view share link	22	view_sharelink
89	Can add mail account	23	add_mailaccount
90	Can change mail account	23	change_mailaccount
91	Can delete mail account	23	delete_mailaccount
92	Can view mail account	23	view_mailaccount
93	Can add mail rule	24	add_mailrule
94	Can change mail rule	24	change_mailrule
95	Can delete mail rule	24	delete_mailrule
96	Can view mail rule	24	view_mailrule
97	Can add processed mail	25	add_processedmail
98	Can change processed mail	25	change_processedmail
99	Can delete processed mail	25	delete_processedmail
100	Can view processed mail	25	view_processedmail
105	Can add custom field	27	add_customfield
106	Can change custom field	27	change_customfield
107	Can delete custom field	27	delete_customfield
108	Can view custom field	27	view_customfield
109	Can add custom field instance	28	add_customfieldinstance
110	Can change custom field instance	28	change_customfieldinstance
111	Can delete custom field instance	28	delete_customfieldinstance
112	Can view custom field instance	28	view_customfieldinstance
113	Can add session	29	add_session
114	Can change session	29	change_session
115	Can delete session	29	delete_session
116	Can view session	29	view_session
117	Can add group object permission	30	add_groupobjectpermission
118	Can change group object permission	30	change_groupobjectpermission
119	Can delete group object permission	30	delete_groupobjectpermission
120	Can view group object permission	30	view_groupobjectpermission
121	Can add user object permission	31	add_userobjectpermission
122	Can change user object permission	31	change_userobjectpermission
123	Can delete user object permission	31	delete_userobjectpermission
124	Can view user object permission	31	view_userobjectpermission
125	Can add workflow	32	add_workflow
126	Can change workflow	32	change_workflow
127	Can delete workflow	32	delete_workflow
128	Can view workflow	32	view_workflow
129	Can add workflow action	33	add_workflowaction
130	Can change workflow action	33	change_workflowaction
131	Can delete workflow action	33	delete_workflowaction
132	Can view workflow action	33	view_workflowaction
133	Can add workflow trigger	34	add_workflowtrigger
134	Can change workflow trigger	34	change_workflowtrigger
135	Can delete workflow trigger	34	delete_workflowtrigger
136	Can view workflow trigger	34	view_workflowtrigger
137	Can add paperless application settings	35	add_applicationconfiguration
138	Can change paperless application settings	35	change_applicationconfiguration
139	Can delete paperless application settings	35	delete_applicationconfiguration
140	Can view paperless application settings	35	view_applicationconfiguration
141	Can add email address	36	add_emailaddress
142	Can change email address	36	change_emailaddress
143	Can delete email address	36	delete_emailaddress
144	Can view email address	36	view_emailaddress
145	Can add email confirmation	37	add_emailconfirmation
146	Can change email confirmation	37	change_emailconfirmation
147	Can delete email confirmation	37	delete_emailconfirmation
148	Can view email confirmation	37	view_emailconfirmation
149	Can add social account	38	add_socialaccount
150	Can change social account	38	change_socialaccount
151	Can delete social account	38	delete_socialaccount
152	Can view social account	38	view_socialaccount
153	Can add social application	39	add_socialapp
154	Can change social application	39	change_socialapp
155	Can delete social application	39	delete_socialapp
156	Can view social application	39	view_socialapp
157	Can add social application token	40	add_socialtoken
158	Can change social application token	40	change_socialtoken
159	Can delete social application token	40	delete_socialtoken
160	Can view social application token	40	view_socialtoken
161	Can add log entry	41	add_logentry
162	Can change log entry	41	change_logentry
163	Can delete log entry	41	delete_logentry
164	Can view log entry	41	view_logentry
\.


--
-- Data for Name: auth_user; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_user (id, password, last_login, is_superuser, username, first_name, last_name, email, is_staff, is_active, date_joined) FROM stdin;
1		\N	f	consumer				f	t	2024-01-03 00:57:58.096142+00
2	!2VZQscEMXdED7UZQwvzKtJLcdnisNbd2AyZzszOY	\N	f	AnonymousUser				f	t	2024-01-03 00:58:14.472933+00
3	pbkdf2_sha256$600000$bYwBJ3Xglp5OpLEObAvZnS$zfN/53zA86esqbVT8oSWdM1Mn6Of4yOKMHpq1lKD0SY=	2024-01-03 01:36:57.28552+00	t	mandraw			mandraw@mandraw.noho.st	t	t	2024-01-03 00:58:20.249363+00
\.


--
-- Data for Name: auth_user_groups; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_user_groups (id, user_id, group_id) FROM stdin;
\.


--
-- Data for Name: auth_user_user_permissions; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.auth_user_user_permissions (id, user_id, permission_id) FROM stdin;
\.


--
-- Data for Name: authtoken_token; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.authtoken_token (key, created, user_id) FROM stdin;
\.


--
-- Data for Name: django_admin_log; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_admin_log (id, action_time, object_id, object_repr, action_flag, change_message, content_type_id, user_id) FROM stdin;
\.


--
-- Data for Name: django_celery_results_chordcounter; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_celery_results_chordcounter (id, group_id, sub_tasks, count) FROM stdin;
\.


--
-- Data for Name: django_celery_results_groupresult; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_celery_results_groupresult (id, group_id, date_created, date_done, content_type, content_encoding, result) FROM stdin;
\.


--
-- Data for Name: django_celery_results_taskresult; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_celery_results_taskresult (id, task_id, status, content_type, content_encoding, result, date_done, traceback, meta, task_args, task_kwargs, task_name, worker, date_created, periodic_task_name) FROM stdin;
13291	39aaaecf-25f1-43f2-a2be-fc01806cb44b	SUCCESS	application/json	utf-8	null	2024-03-21 04:05:00.122194+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 04:05:00.096372+00	\N
13390	2c8b38c2-7597-4543-a8eb-5b8966d12a15	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:10:00.158661+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:10:00.139493+00	\N
13308	c25e46e8-c65a-4600-836d-f56304a509fe	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:30:00.133653+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:30:00.119043+00	\N
13461	f92d1421-1dbc-4a66-8efd-c4746496065a	SUCCESS	application/json	utf-8	null	2024-03-22 04:05:00.181193+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 04:05:00.156876+00	\N
13325	b0c49081-95a5-438a-8c06-8b3574e8e70a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:00:00.199172+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:00:00.185611+00	\N
13407	d160dc8c-4506-49b1-b4c9-3134636cf4b5	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:40:00.208262+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:40:00.191126+00	\N
13478	8a2d339e-3f7c-4250-ab70-b724873a8ad8	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:30:00.217918+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:30:00.194207+00	\N
13342	853a8f73-76b5-4f7f-b561-3280f8cc532b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:20:00.136025+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:20:00.116869+00	\N
13359	7199c7fa-a341-438b-9c9a-7a495935b4cf	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:50:00.207306+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:50:00.192731+00	\N
13495	adb3934d-06ea-4d32-b898-7233a531b541	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:00:00.649551+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:00:00.190864+00	\N
13424	0b5fca3a-d511-4f74-8646-528f42a3cf4a	SUCCESS	application/json	utf-8	null	2024-03-21 23:05:00.203842+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 23:05:00.112699+00	\N
13376	ab31af2b-1816-407b-9905-93ee091dc5d5	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:10:00.202959+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:10:00.185501+00	\N
13534	3098650a-9863-4b5b-9351-81a8452c194e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.392732+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.392619+01	\N
13441	f6b4ff71-6c6e-427c-8e3a-824e667f1821	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:20:00.205898+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:20:00.188726+00	\N
13535	73e8e542-1e73-414f-9697-2b2d5c64715d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.45255+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:54.452491+01	\N
13536	01628caf-d400-4908-a285-c07e9ad80126	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.474338+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.474278+01	\N
13458	14d15952-3323-49b3-a6f8-1fd78a3515e5	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:50:00.201371+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:50:00.160575+00	\N
13537	4bada926-7b4f-4566-83f2-d06aaa5ec2fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.497489+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.497435+01	\N
13538	7411b3b9-9edc-4b06-b05f-8d42325362a9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.519517+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.519457+01	\N
13539	85815c15-3cb9-407d-9da4-ed74eaad35ef	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.549685+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.549624+01	\N
13540	0c469b32-ec4d-43e5-a1c0-678589d03360	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.60093+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:54.600862+01	\N
13541	3bfebaca-e9b8-4743-8f97-d21ac179e713	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.627844+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.627787+01	\N
13542	575c1f5e-1370-4ce6-925b-f59621641c1f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.654976+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.654918+01	\N
13543	72b8b342-280a-4637-af14-f2a31de86781	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.676434+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.676374+01	\N
13544	70695fa0-3efd-4a4b-ae19-121f7a81d398	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.698191+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.698135+01	\N
13545	d3f82a1f-211a-44a0-9c3d-d508f109563b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.72302+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.722971+01	\N
13462	90efbbe7-d305-4610-b611-404368c4e7ac	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:10:00.198227+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:10:00.185483+00	\N
13292	245d4c1f-dd4d-4fc0-a052-b53dff04ca00	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 04:10:00.187688+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 04:10:00.175247+00	\N
13391	4350dd03-fd9b-460e-9d2d-8b45429abca7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:20:00.138463+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:20:00.124603+00	\N
13309	284986d8-2d7b-4844-b154-26f8cd3164db	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:40:00.179558+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:40:00.165683+00	\N
13479	6570faa8-80e5-416b-bd81-70620d29ee28	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:40:00.194729+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:40:00.18148+00	\N
13326	d78b7731-0219-4d19-bda0-4ca0c86829bb	SUCCESS	application/json	utf-8	null	2024-03-21 09:05:00.216702+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 09:05:00.186757+00	\N
13408	a0868ee2-da7e-4b05-93fa-6879da19e183	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:50:00.204646+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:50:00.188363+00	\N
13343	9ceea526-6971-4690-a1cd-c4018c6e757b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:30:00.166172+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:30:00.148986+00	\N
13496	74cc8c35-3b07-46d4-8c3e-ee4891b3fbaa	SUCCESS	application/json	utf-8	null	2024-03-22 09:05:00.223603+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 09:05:00.176143+00	\N
13360	f0cab495-c936-46e9-a843-8f7e808283c3	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:00:00.208426+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:00:00.191749+00	\N
13425	620bc308-1c9e-4b24-a6a1-9e92248e1446	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:10:00.17837+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:10:00.162954+00	\N
13377	26edd146-4672-43cf-b921-290942c3ad8a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:20:00.203564+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:20:00.1874+00	\N
13546	fecb20cb-cd11-4a97-94fb-4a78b57d8e5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.749265+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.749209+01	\N
13442	84401ffb-ef14-40e6-9f56-52ece228ab97	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:30:00.189153+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:30:00.169804+00	\N
13547	906b3163-2972-40a3-8056-18ff503d5551	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.77395+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:54.773891+01	\N
13548	3b873767-2aa7-4c6e-bb85-a95f2bf1879a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.796522+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.796424+01	\N
13549	403d2353-8ab7-4934-a83c-a7c5c8fac9b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.820377+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.820321+01	\N
13459	53f5c986-c637-46a6-8bda-00043175d9f6	SUCCESS	application/json	utf-8	null	2024-03-22 04:00:00.211022+00	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-03-22 04:00:00.181086+00	\N
13550	0d641638-6cbe-4847-ad11-ce1acf957d26	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.845164+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.845116+01	\N
13551	6cb989f6-717e-4b6b-b5d8-bc9960cf0c91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.865649+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.865593+01	\N
13552	59f016d1-2db4-42c4-912f-e72c420b7bb9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.887127+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.887075+01	\N
13553	26da1428-0e0e-416f-b479-9e01ab8c3f45	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.909669+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.909614+01	\N
13554	792ae3b0-17fe-4361-bdce-bbb442462afc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.929577+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:54.929512+01	\N
13555	2ab73857-74ba-4444-b6f2-8a98235c710f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.952014+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.951961+01	\N
13556	1df886b8-59ec-4767-8139-9ee103ab3240	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.974033+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.973986+01	\N
13557	6c307536-5e2f-4bb2-a320-c79cd6c08ed8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:54.99457+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:54.994524+01	\N
13293	1391f0a3-d104-4552-b1cc-99769054eb0a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 04:20:00.139862+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 04:20:00.12732+00	\N
13392	a2f3cb50-f843-4a7f-97ae-944dcaaeb681	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:30:00.125427+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:30:00.105497+00	\N
13310	b43f67ff-7fc2-47d8-8a8b-6ff9f8be48dc	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:50:00.19393+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:50:00.179758+00	\N
13463	44f9d0ba-8af0-4290-9c4a-ec7823ae4df3	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:20:00.168506+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:20:00.15529+00	\N
13327	202b52ac-0d94-4f45-b991-5c489f96f2a1	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:10:00.15546+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:10:00.141+00	\N
13409	a3ec31fd-6983-4a05-a3bc-7ff8d00bcbed	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:00:00.207222+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:00:00.19089+00	\N
13480	33bb6eee-8564-49f8-8fff-e6b946816a3e	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:50:00.209118+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:50:00.191465+00	\N
13344	63ffcb8f-eee0-4282-9f4f-3c1b96b348f4	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:40:00.217247+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:40:00.200314+00	\N
13361	e84f7802-1e56-4256-8716-b70453eab915	SUCCESS	application/json	utf-8	null	2024-03-21 14:05:00.196606+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 14:05:00.167078+00	\N
13497	a42a3446-6192-4917-a5bc-8c6677327bc2	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:10:00.225998+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:10:00.189887+00	\N
13426	9db63fcc-be15-4a6d-b5b6-0ff260134774	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:20:00.212332+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:20:00.189969+00	\N
13378	b44db1b5-6bbc-47f3-88e5-a3056446a3d0	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:30:00.187824+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:30:00.171121+00	\N
13558	bb9d6f46-bb02-4b52-bd58-70e9c888926a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.015744+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.015688+01	\N
13443	b439ca65-bc19-45c9-8707-d874611b3203	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:40:00.19216+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:40:00.177005+00	\N
13559	af1731cc-4e93-4fec-912a-1be3197e3e78	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.044484+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.044429+01	\N
13560	654849f1-8c40-4969-bf68-ad52807e805a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.088722+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.088669+01	\N
13460	c7f6e0b0-35ef-42fc-8b15-e3513a28a363	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:00:00.764208+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:00:00.752018+00	\N
13561	0ff3fdb6-1d3f-42ab-ad47-3eff4d049f8e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.112241+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.112188+01	\N
13562	6e8e08fd-f6a7-4fd0-ad2b-2efc9ed74771	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.13688+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.136824+01	\N
13563	dd62f584-dac6-4bbc-aa58-5ebb3952f64e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.162024+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.161971+01	\N
13564	1aef7519-a74a-4406-aeeb-fc0dc59c4ff5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.1875+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.187434+01	\N
13565	e9b00ba4-a668-458d-8d22-d065635081ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.209586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.209527+01	\N
13566	bd56c54a-7673-4e28-abe5-34d97a73d668	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.233058+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.232996+01	\N
13567	9c7940ba-4614-4eae-9b2b-0d417d71a3ae	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.255242+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.255171+01	\N
13568	33896215-7082-4b7f-b974-2deda425b91c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.282115+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.282045+01	\N
13290	4fd22477-114c-454b-aa93-ebdecf4d210d	SUCCESS	application/json	utf-8	null	2024-03-21 04:00:00.743338+00	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-03-21 04:00:00.718879+00	\N
13464	4d8fae8f-56f5-4fd0-8cbb-a1fb19a11fb8	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:30:00.205955+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:30:00.193511+00	\N
13294	f20a2bec-a224-467e-8ee3-ccf85aa46bf9	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 04:30:00.175338+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 04:30:00.158616+00	\N
13393	23f59575-602f-4feb-b576-8888b8bcbabd	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:40:00.208966+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:40:00.192788+00	\N
13311	1a435458-9d1b-404e-86aa-c8dc2c6dbd4b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:00:00.198249+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:00:00.182031+00	\N
13481	149aeeea-3b91-4465-85cf-8c30c1668eee	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:00:00.205699+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:00:00.192113+00	\N
13328	24bd2bb4-9e3f-47e4-9e93-ab3500eb2ce2	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:20:00.189688+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:20:00.173698+00	\N
13410	d0058de8-1aa8-4fdc-a81f-cf83c775a196	SUCCESS	application/json	utf-8	null	2024-03-21 21:05:00.211307+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 21:05:00.185462+00	\N
13345	ceb521fb-a797-46d7-a5af-260e03511a59	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:50:00.189515+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:50:00.172326+00	\N
13498	5a8c8f88-3404-4d65-86e7-6e60d7ef0a87	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:20:00.19746+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:20:00.183199+00	\N
13362	3eb4a8af-530c-4a1a-aa45-a248b07eea72	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:10:00.179343+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:10:00.165289+00	\N
13427	dd312efc-e7d8-43a0-9b30-a86acf14bebe	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:30:00.205254+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:30:00.190168+00	\N
13379	928df351-5f7a-4c1b-bef0-e7bbe22eb7b3	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:40:00.197373+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:40:00.180325+00	\N
13569	cc2b0bc4-eac6-4120-b64f-0f91f9725d33	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.306236+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.306177+01	\N
13444	3cfcd920-4b6f-44d7-a607-16b41aa96aca	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:50:00.209915+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:50:00.19117+00	\N
13570	8ded3abf-ae24-4120-92fc-d6a2654fdcea	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.332314+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.332238+01	\N
13571	047e2423-075d-45cd-8844-6f07e1717172	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.35641+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.356351+01	\N
13572	57924615-765b-48d4-ac60-fb600b91b250	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.378284+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.378227+01	\N
13573	00f723a1-eac7-4e58-a830-61be7237f099	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.400144+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.40009+01	\N
13574	3f26376b-7509-4b6a-b13f-eda3dfb712a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.42129+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.421237+01	\N
13575	18b545bc-9fa0-4cf7-860b-decfb018e8da	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.442602+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.442547+01	\N
13576	5805e3b7-6524-4c1c-b64d-8e9544c7ce42	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.463666+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.463558+01	\N
13577	9d4b77cb-bfb0-40f6-914e-ab7101eee147	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.483993+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.483939+01	\N
13578	e9a96a9a-5953-4f0b-aa92-7e3acacbd939	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.507475+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.507427+01	\N
13579	a214d148-5e4f-4653-8f10-ae2b54d438d8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.528235+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.528173+01	\N
13580	9a0ffbb0-8aee-45db-a75f-62811296b1bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.549729+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.549665+01	\N
13295	25d5730f-6a44-465d-884a-15e0a76440fd	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 04:40:00.20451+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 04:40:00.190502+00	\N
13394	5ceaaa8e-bbbe-4739-9c51-43a19c8c6f2c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:50:00.170952+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:50:00.153279+00	\N
13312	107399fe-7f9f-41f4-a465-12809cdb97c3	SUCCESS	application/json	utf-8	null	2024-03-21 07:05:00.184898+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 07:05:00.153768+00	\N
13465	8839f94f-61ed-41bd-bc10-a471df3c1469	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:40:00.177219+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:40:00.164717+00	\N
13329	f47f4f17-a8e6-4ddd-8345-4786fa657de0	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:30:00.187322+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:30:00.172969+00	\N
13411	f304893d-7cd5-4c1b-b6d9-dc67ff39a314	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:10:00.188123+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:10:00.173795+00	\N
13482	9c6a6218-0554-4002-b2a4-17b5787b26ee	SUCCESS	application/json	utf-8	null	2024-03-22 07:05:00.187359+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 07:05:00.160846+00	\N
13346	2b949d69-e91c-495a-8f68-0ed1c0327f7c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:00:00.209257+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:00:00.19068+00	\N
13363	1d4fc2c4-e43d-44cb-86a6-d7012d0589eb	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:20:00.193584+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:20:00.178643+00	\N
13499	cf21345d-dfcb-4d46-81d4-8a318bb20d8b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:30:00.204457+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:30:00.190648+00	\N
13428	a0678073-393f-46d5-8c5f-ad80f02058bf	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:40:00.17555+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:40:00.149326+00	\N
13380	97be7a42-2e58-4bee-a541-2d52aaecbbbe	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:50:00.176298+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:50:00.158826+00	\N
13581	d62ccbff-441d-4476-a225-9bff6264bea2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.570806+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.570747+01	\N
13445	ca68fafc-0620-457c-8a77-f25ede643726	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:00:00.208594+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:00:00.191229+00	\N
13582	1e0725cd-5ee6-4498-93f5-31ce3ae0f61a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.592029+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.59197+01	\N
13583	eff9e009-f103-489b-b478-d7b7c6f3b213	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.613021+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.61297+01	\N
13584	45e5090f-319d-40c4-842e-ed8df4b2d0ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.634157+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.634099+01	\N
13585	0e6bb254-9c41-4bb6-9fd3-0c9caf15610c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.657267+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.657214+01	\N
13586	66c4b1e2-d59b-4ef3-b35c-e88b8a29ba85	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.681792+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.681745+01	\N
13587	f48d5873-9994-477a-af01-92d3e7b01382	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.72423+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.724164+01	\N
13588	0198f4ec-33cd-411f-ad1a-b0302b461225	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.746894+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.746843+01	\N
13589	b89e2032-27c6-4d37-ab83-b5292471f768	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.767839+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.767787+01	\N
13590	c741ba05-40f3-4bac-85ca-f2e6a2536bfe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.789957+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.789898+01	\N
13591	773922f8-2cd8-41b6-b682-9e9936d02bac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.811064+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.811015+01	\N
13592	8715c6db-511d-4df2-878d-047cfefaa7e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.832204+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.83215+01	\N
13466	568e4fc9-358d-4215-b6c8-91567e75721a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 04:50:00.205056+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 04:50:00.192701+00	\N
13296	941410cd-b291-4e2b-b283-71f96f7cb840	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 04:50:00.106952+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 04:50:00.094121+00	\N
13395	54178b60-10a6-4780-973b-d4c4cf7f0f63	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:00:00.153543+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:00:00.139468+00	\N
13313	b1e499c8-49c9-4f28-8976-7080fb17a1f4	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:10:00.195981+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:10:00.179725+00	\N
13483	82487d04-5229-4c17-9ec6-b012baa72bde	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:10:00.198708+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:10:00.185129+00	\N
13330	21425746-0335-4d07-ba79-90b4a5baa434	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:40:00.123922+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:40:00.101004+00	\N
13412	87a93d3f-3249-4ac6-b8f4-4659c265b64c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:20:00.201736+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:20:00.184354+00	\N
13347	223521e5-49c9-43a7-a489-ce505483b921	SUCCESS	application/json	utf-8	null	2024-03-21 12:05:00.155992+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 12:05:00.127091+00	\N
13500	7d383c65-1f67-4460-8647-faca6a977d8d	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:40:00.152557+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:40:00.137721+00	\N
13364	d94d61aa-937a-4d44-a6bf-e0408678866e	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:30:00.128134+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:30:00.113628+00	\N
13429	06400c6e-d79f-4710-b067-f4d7d9633d37	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:50:00.199605+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:50:00.182973+00	\N
13381	442b493c-677b-4a38-9a8e-d87e345cbeda	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:00:00.200009+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:00:00.183524+00	\N
13593	576e6069-d9b1-4233-8e42-24ddf5c05506	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.85271+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.852647+01	\N
13594	ef990ccb-c784-441b-9479-7046cd8b47e3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.875929+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.875882+01	\N
13446	feecc015-2732-4687-87eb-e62df2a7c261	SUCCESS	application/json	utf-8	null	2024-03-22 02:05:00.206145+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 02:05:00.17851+00	\N
13595	02b4126d-e248-49e1-97cf-6ea2cdbfb138	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.899743+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.899647+01	\N
13596	e0055201-5fbc-4830-a227-e93eb09792e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.922003+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.921945+01	\N
13597	27ecf874-2eaa-468a-9dde-a64757df3177	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.944321+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.944266+01	\N
13598	e5e16aea-3f86-4e09-9a7d-c9ea27327726	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.966547+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:55.966486+01	\N
13599	ae1e778e-77bf-4914-98ce-2c0e792ddcc9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:55.988931+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:55.988881+01	\N
13600	aae19917-dd26-4a73-8f33-daecddea9cc1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.011178+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.011128+01	\N
13601	65e696eb-93e4-4ad5-a7ad-2886966a4eac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.053295+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.053238+01	\N
13602	9a9b1492-7263-434e-903e-76a0ea45d5e8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.072707+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.072655+01	\N
13603	2c4576c3-33a0-4c60-83cf-37f47ca61178	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.095116+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.095037+01	\N
13604	c1c7b50e-6116-4f82-bf32-30851c122071	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.126679+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.126602+01	\N
13297	008d62dc-47e9-4e57-8fca-1df307b6555f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:00:00.167577+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:00:00.1549+00	\N
13396	d70f30ad-acf2-4de5-bbd4-df065c281349	SUCCESS	application/json	utf-8	null	2024-03-21 19:05:00.209025+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 19:05:00.181064+00	\N
13314	528f5a85-d7ae-4826-9d0f-e69d01ab1b5d	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:20:00.137791+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:20:00.1245+00	\N
13467	1da2001a-41cf-4417-9fec-5b372ff5ba92	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:00:00.188157+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:00:00.175546+00	\N
13331	f74a0514-ab17-4c51-ac15-4a4d7d7c49d6	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 09:50:00.168709+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 09:50:00.15174+00	\N
13413	e303f1a5-1060-47b6-ad69-abb8105dfb57	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:30:00.165442+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:30:00.150177+00	\N
13484	a3ed41fc-459a-4c23-b7d4-8a24a3efa9bc	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:20:00.159003+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:20:00.14443+00	\N
13348	f411c245-9723-4e62-a62c-84ca038403d7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:10:00.176439+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:10:00.161766+00	\N
13365	de9262cb-7ca8-40ff-a9b8-d55f53b0b094	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:40:00.214083+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:40:00.196693+00	\N
13501	bff38809-abb1-4060-bb9d-69aaed890790	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 09:50:38.331216+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 09:50:38.309767+00	\N
13430	e88518ee-4a4f-4829-856c-760fe9a6ff73	SUCCESS	application/json	utf-8	null	2024-03-22 00:00:00.254971+00	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-03-22 00:00:00.192027+00	\N
13382	38258c76-7587-46e2-8b51-cef39a73e342	SUCCESS	application/json	utf-8	null	2024-03-21 17:05:00.210844+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 17:05:00.178838+00	\N
13605	dd41bb01-f3af-4e44-9299-1758b60cbd9b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.156403+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.156302+01	\N
13447	1f00591d-e6da-4139-b8a4-a2f0d2856a7b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:10:00.197407+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:10:00.183024+00	\N
13606	a9640c8b-3841-4b28-a7bf-e2b9a36dd9e2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.186811+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:56.186748+01	\N
13607	73642176-b0a2-4a87-9ffa-94414de002ef	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.217329+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.217272+01	\N
13608	349e9092-a9a0-47ba-996c-709b58aa8074	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.241783+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.241725+01	\N
13609	119262f7-a0b3-4253-9b5b-2b95bcdb4742	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.265226+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.265154+01	\N
13610	a395bd0d-595c-411c-90a9-43996e659a25	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.297146+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.297098+01	\N
13611	83de7cad-c36a-44cf-a5ba-9d7947678340	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.33011+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.330058+01	\N
13612	998dfff1-5058-4a29-bb64-4cd5558882bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.3512+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.351149+01	\N
13613	c27ad0e0-65c9-4f89-ab35-342665dc4ced	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.372969+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:56.372917+01	\N
13614	1ad86d6c-f541-4b62-a85f-ba0b335a1a0c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.396534+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.396475+01	\N
13615	af73d09a-07d8-47b5-a1f4-59c01d119e61	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.422652+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.422597+01	\N
13616	6835c8e4-af3e-40d4-9f4b-4d63e0b914ce	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.469586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.46953+01	\N
13468	d78dcc34-b194-4c8d-b1cc-439f8c5e7996	SUCCESS	application/json	utf-8	null	2024-03-22 05:05:00.125814+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 05:05:00.100098+00	\N
13298	46f5827e-cbef-49eb-8048-ae3171843d68	SUCCESS	application/json	utf-8	null	2024-03-21 05:05:00.201675+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 05:05:00.176413+00	\N
13397	648b33ef-8c7e-4037-a9df-38150930e0ce	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:10:00.192971+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:10:00.179283+00	\N
13315	409548e7-fa74-45c5-b141-19e7f29ae013	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:30:00.143097+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:30:00.128291+00	\N
13485	3b517bb5-c750-4bb1-9eeb-e721e6274bed	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:30:00.190063+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:30:00.176439+00	\N
13332	6bf0b4df-b8de-4d15-a516-695414ba088f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:00:00.170202+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:00:00.152692+00	\N
13414	5cf6b8e7-c230-486e-90b2-e3e27cc7218a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:40:00.180683+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:40:00.162793+00	\N
13617	5db42ea7-662c-4604-8719-8e08a523d141	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.494062+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.493999+01	\N
13349	28c149d1-4152-4c0e-80c8-60dc24f644ee	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:20:00.184534+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:20:00.168364+00	\N
13618	577f8e38-d37c-43bf-b054-7e82e84ec3c1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.520523+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.520468+01	\N
13366	2324cdf7-9c50-4719-9ba6-3d7b39d4df24	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 14:50:00.199626+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 14:50:00.182829+00	\N
13431	b6b7457c-9dba-44b3-9fd6-eca35f7811eb	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:00:00.804015+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:00:00.791861+00	\N
13383	5663b776-d9f6-4522-9596-ba9fbaa0bb32	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:10:00.203208+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:10:00.186147+00	\N
13619	3c182041-0f76-449f-a729-b2518e5ae48c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.54255+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 21:17:56.542496+01	\N
13620	9998a8f7-e20a-4a4d-821a-d9444538b7bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.564845+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.564787+01	\N
13448	7b760e97-41a0-4361-9914-6552ba132549	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:20:00.178265+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:20:00.161905+00	\N
13621	d0f18c8a-aaa6-43e3-9d1b-3cb5b30a66ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.59248+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:56.592409+01	\N
13622	e30ad09f-db49-49da-aad0-a8f249e1f2df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.618391+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.618302+01	\N
13623	c02f9373-a2e0-4c2b-ae73-84de8ddf27ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.653433+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.653341+01	\N
13624	4ad5ff5a-ebea-41e0-911e-53de7f7482df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.688341+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.688245+01	\N
13625	cc92e1c7-9d87-4057-a7f8-5c1150e0e4c1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.718933+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.718842+01	\N
13626	06b02e73-8e5d-4b1d-a27e-9405504e7377	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.753163+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.753076+01	\N
13627	82a6ea29-82de-42d6-954e-0ec6fc7112f8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.784185+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.784111+01	\N
13628	edf8eb1d-6dc5-45d1-8e0f-5ab084a62133	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.81448+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:56.814395+01	\N
13629	e118739d-4cc2-4ca5-8938-ff933c307cbf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.835866+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.8358+01	\N
13630	8127f230-da65-494d-ba73-b1ce7683ab09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.865495+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.865432+01	\N
13299	91ff0c3a-0f1e-4ae4-9801-8338c34460ae	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:10:01.350487+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:10:00.769701+00	\N
13398	092317cb-6fa9-453b-92d6-de7c6c1dc0ab	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:20:00.215195+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:20:00.200991+00	\N
13316	fbae8963-6aa4-4092-b5ce-99bf0d67dab4	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:40:00.167532+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:40:00.152731+00	\N
13469	1089e32e-5e65-4520-8637-157994f4269a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:10:00.156814+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:10:00.141914+00	\N
13333	fb0cb478-c7c8-4fdc-bda4-cd2f06447060	SUCCESS	application/json	utf-8	null	2024-03-21 10:05:00.182181+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 10:05:00.152353+00	\N
13415	f6a42034-73cb-4dee-a4c3-33971cdaa63e	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 21:50:00.204989+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 21:50:00.190195+00	\N
13486	31ff1b2a-1022-4711-ba42-2d9839f65f10	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:40:00.665532+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:40:00.13326+00	\N
13350	28f327f2-7c48-40c5-aaaf-75ab4ba0b6fb	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:30:00.182155+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:30:00.166698+00	\N
13631	fbce1be2-d0c0-4bd2-b90b-c976d23ef6d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.893973+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.893925+01	\N
13367	47888d92-12ca-4716-a35b-a761969cd37c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:00:00.169533+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:00:00.152497+00	\N
13632	6b0b1abd-9939-4c9d-9cf8-b2190f4503b7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.914236+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.914179+01	\N
13432	e9cb6942-b66d-44ee-92b5-e5b1eabae5e5	SUCCESS	application/json	utf-8	null	2024-03-22 00:05:00.212395+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 00:05:00.185231+00	\N
13384	27f4bbbd-d3f0-4959-865b-25445bcc0e75	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:20:00.205269+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:20:00.189686+00	\N
13633	b5a90e75-f503-4833-b4fd-a345a48d0ad6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.940564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.940511+01	\N
13449	91b60bea-4cac-4151-ab87-ae676caad988	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:30:00.186085+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:30:00.168577+00	\N
13634	35e89273-8922-4a32-b880-4d792bdc85ad	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:56.97073+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:56.970671+01	\N
13635	905b10f5-7b73-48c6-9f60-58aac579dfcd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.002041+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.001966+01	\N
13636	d4f0a39a-e10c-4e70-8200-6dfa524525ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.019798+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.019747+01	\N
13637	65025143-b108-456e-a356-27b57d8b0a90	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.042161+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.042105+01	\N
13638	3656a06c-aecd-4cb3-8b8d-2e059e76d525	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.065748+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.065689+01	\N
13639	7ab8c631-21d1-4bf9-b2bf-8ba82ead45a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.089116+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.089066+01	\N
13640	d69dd93c-531d-46b1-95e9-e5c00425693a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.112046+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.111991+01	\N
13641	7d5ce449-0aee-4427-8859-0197c208b7a6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.137963+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.137917+01	\N
13642	52d5fd5b-2ad3-41bb-94e5-7d6ecf707d5b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.18089+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.180822+01	\N
13643	2559bc2d-01b3-43b2-9bab-96fa0e74d8a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.204935+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.204883+01	\N
13644	26b7cf7d-0d57-47c9-8439-636733d684bc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.226056+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.226007+01	\N
13470	2863724d-3dcf-4f6c-97ed-38c7ecf1c3ff	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:20:00.145961+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:20:00.132401+00	\N
13300	6e58c66d-5d01-430e-9d08-049b7cd853d7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:20:00.132027+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:20:00.118076+00	\N
13399	94c9bf70-0983-418a-82c0-2422fc113e29	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:30:00.203038+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:30:00.188305+00	\N
13317	cb0ee25e-b160-4b53-a3bf-b0d5715b6493	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 07:50:00.201076+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 07:50:00.187186+00	\N
13487	74d320dc-12f0-49ae-a837-72eed16437f5	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 07:50:00.125192+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 07:50:00.111251+00	\N
13334	bc5db62a-6f5d-43a2-aa93-199b7b217af7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:10:00.207052+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:10:00.192028+00	\N
13416	3f45539e-1446-480d-b087-a27f79999925	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:00:00.188305+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:00:00.173531+00	\N
13645	acfc04f1-4245-40ea-bf53-fecff9a065ef	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.245233+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.245181+01	\N
13351	2e04b3d0-4ae8-4399-a793-32ea9aaf3ad1	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:40:00.138689+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:40:00.123416+00	\N
13646	907332ae-47f2-4d39-ac68-7ed7c3b16bb6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.268129+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.268073+01	\N
13368	cee57c00-5209-45a0-a29c-856884a576ba	SUCCESS	application/json	utf-8	null	2024-03-21 15:05:00.18341+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 15:05:00.152743+00	\N
13433	aae294dd-5b70-4cfd-a655-a3ab7e8a942c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:10:00.171654+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:10:00.1548+00	\N
13385	b401c942-8357-4dca-abfb-9947eea4a818	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:30:00.195919+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:30:00.178699+00	\N
13647	ee7bf8b1-e966-4ef9-beb2-860f06d0e11a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.288383+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.288331+01	\N
13648	446ddc54-f0aa-448e-bbf9-9e09ca24cb65	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.314095+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.314045+01	\N
13450	e44ebc30-9b93-4d45-972f-26d21c497a09	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:40:00.203042+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:40:00.186578+00	\N
13649	73c75d6b-2d03-4473-9862-fd8ab1ea3857	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.340506+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 21:17:57.340443+01	\N
13650	6c5292b1-c24b-48f7-9e86-0e5608cb2c0e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.363901+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.363843+01	\N
13651	d8fc4f18-8878-4373-8f7f-fd6263031a9c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.38694+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.386892+01	\N
13652	548beee4-5ac5-43cc-ab6e-cbd1f8e49747	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.408522+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.40846+01	\N
13653	0eb53155-838c-42f4-b465-3e519b461760	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.434295+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.434247+01	\N
13654	44a0edb2-dc22-4600-bb49-2bb12bacc046	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.456021+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.455971+01	\N
13655	71751b82-125b-469a-bc82-e26b9ba650b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.477373+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.477287+01	\N
13656	b7dbad33-02c5-4175-87d5-47b52ca2fb4d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.499123+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.499076+01	\N
13657	6e2de562-5d8e-4e9c-be33-4a89fe7d98b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.521852+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.521765+01	\N
13658	a3aec381-989d-4951-b106-514aad26f0b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.557301+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.557205+01	\N
13301	730ee736-1b5c-4997-8649-3dba94e1c7bd	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:30:00.149603+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:30:00.135457+00	\N
13400	caafc46a-6e99-46d7-a374-d1af0f28af7c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:40:00.129624+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:40:00.115853+00	\N
13318	62a0db70-56c7-4604-93df-d5e3e9eb4ea7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:00:00.116949+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:00:00.101894+00	\N
13471	e5d4a4e1-2d1d-48c1-b928-0d932ba7dce4	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:30:00.199148+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:30:00.184145+00	\N
13335	47f3d3b4-1c94-4f0f-be3f-c39901686a2c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:20:00.191588+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:20:00.177856+00	\N
13417	6f1fbad6-8628-4d56-acfa-5aef27d8c4bb	SUCCESS	application/json	utf-8	null	2024-03-21 22:05:00.173922+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 22:05:00.145198+00	\N
13488	acc2e01a-b9fa-4bcd-a918-b31f43e27e4c	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:00:00.207696+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:00:00.193935+00	\N
13352	205a7090-90ce-4fd9-8dcd-d955e42ccf74	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 12:50:00.118589+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 12:50:00.100365+00	\N
13659	5ab1f4b8-55c7-4e5c-893f-65aaa43428f4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.587396+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.587347+01	\N
13369	1768e250-4a9c-4599-8a38-56b92ce3a128	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:10:00.190919+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:10:00.174153+00	\N
13660	950e9e1a-20c5-49d1-9c3b-f46905fedd27	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.609306+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.609249+01	\N
13434	a539365a-82c0-4506-a080-0d40de57c753	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:20:00.12307+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:20:00.10834+00	\N
13386	8b08bfc7-40da-4709-9d68-9e58eb3674b3	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:40:00.211936+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:40:00.195314+00	\N
13661	dfe0a3ca-b145-4d63-aad0-9ef1e93485ad	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.630411+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.630362+01	\N
13451	d77d33ad-53ff-48e1-94da-0016ee66e135	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 02:50:00.199032+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 02:50:00.183474+00	\N
13662	e6a02dd9-c04d-46f7-bf41-b58c1401896d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.656235+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.656179+01	\N
13663	44cd9b86-abde-4ed2-8ce9-ec5cc8ce5cd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.694839+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.694786+01	\N
13664	b3f4af03-0d47-4134-8286-3944fd81a373	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.718191+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.718132+01	\N
13665	908d31b0-d951-4127-b111-1373b4bbf34b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.742869+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.742818+01	\N
13666	d769f660-8a13-490b-9c1e-8778781382f4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.762385+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.762341+01	\N
13667	4687ce8d-36ed-4bb0-b104-ddfdc3f4858e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.781429+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.781382+01	\N
13668	5fef312f-1bcd-4dfc-a7ad-bd7040c7cebd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.799303+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.799258+01	\N
13669	50cad935-fbe1-4ea1-9017-49f73260b1ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.827263+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.827216+01	\N
13670	6e6a5b31-125b-4b32-b498-6d013a49e35b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.843973+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.843927+01	\N
13671	07bc9cf6-804d-4d2e-9178-df1f44243093	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.860589+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.860547+01	\N
13672	2b2416d2-bb49-4960-ab99-0b28a43fab26	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.876902+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.876855+01	\N
13472	f07701df-f89f-41e4-9081-5d0e7187a3e7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:40:00.178172+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:40:00.165169+00	\N
13302	87c2eb3e-603a-477a-afa5-3cf3764eb301	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:40:00.207706+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:40:00.193584+00	\N
13401	2eee63c6-9169-42e6-8aac-aa9866c16d06	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 19:50:10.642983+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 19:50:00.136796+00	\N
13319	8fc43e17-ed38-44d3-a014-6db985682122	SUCCESS	application/json	utf-8	null	2024-03-21 08:05:00.1906+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 08:05:00.161567+00	\N
13489	1ff5d007-208c-444f-9340-460d0ffbc976	SUCCESS	application/json	utf-8	null	2024-03-22 08:05:00.205767+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 08:05:00.179702+00	\N
13336	9165150f-f51e-4e62-994a-b1195ae242ff	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:30:00.181196+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:30:00.158302+00	\N
13418	ff474b76-3481-402b-8a5f-96583f2e16b6	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:10:00.203055+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:10:00.186032+00	\N
13673	ca6f029c-a1ec-4706-9568-f1228963b865	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.89425+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.894205+01	\N
13353	0283dce3-ed6f-487c-b43b-8135d87982eb	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:00:00.205625+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:00:00.191008+00	\N
13674	462884b4-a846-460b-9b31-ab4a384a7441	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.911864+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.91182+01	\N
13370	efc2a05d-a83f-4a3f-9cfd-efe09d1b6f81	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:20:00.17091+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:20:00.156298+00	\N
13435	b4e44430-6a22-4341-bd31-b3162fd86512	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:30:00.163661+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:30:00.148949+00	\N
13387	159a4a13-4b22-4566-bfb2-502ad797a2bb	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 17:50:00.189106+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 17:50:00.171264+00	\N
13675	bbfae596-580d-4abd-b174-eef2abe76476	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.931527+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.931482+01	\N
13676	1ad5ef27-b1e4-4148-b445-d7147abf069f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.951539+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.951494+01	\N
13452	031d7491-e459-4a16-a7f1-063b2ea1253f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:00:00.207725+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:00:00.18968+00	\N
13677	6e7219b5-895d-48d7-94c6-0663c396824f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.969184+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:57.969137+01	\N
13678	301ef777-5939-44b8-8bf9-7569519b53d0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:57.98574+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:57.985695+01	\N
13679	f04c67e2-433d-4d4b-bf81-3e5688438133	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.003077+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.003035+01	\N
13680	308d4e15-3a6c-431b-b3a1-714b439005a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.021153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.02111+01	\N
13681	b3f28bbc-ded7-4dd0-bba0-742b7b66467e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.037609+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.037562+01	\N
13682	587f9710-8a9a-44e0-af42-8608d5ec21ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.057681+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.057635+01	\N
13683	e59afa3f-0bb8-466c-bffe-e31461d6c59c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.074738+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.074691+01	\N
13684	d8237f21-eb1a-4edb-b628-9c91951ee22c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.091313+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.091266+01	\N
13685	b92ace05-e1dd-4f16-bc62-0639718fa05e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.107696+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.107643+01	\N
13686	22979c60-1911-46aa-a00d-7a6cdcf4cfe0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.124042+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.123998+01	\N
13473	eda218f7-2a83-45c1-a4b1-08a17ea74072	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 05:50:00.136098+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 05:50:00.123615+00	\N
13490	fa2d1269-dd46-430c-bdba-c51c609d4ee7	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:10:00.118354+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:10:00.10489+00	\N
13303	66702bdb-ef49-4402-8be5-8654cd85be22	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 05:50:00.199246+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 05:50:00.184554+00	\N
13687	72751399-c39d-4ec0-98f9-92fb7d55aee5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.140735+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.140693+01	\N
13688	a6bccacb-52de-4208-9a9b-ef485d3f9265	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.157899+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.157854+01	\N
13689	8d737a5f-4652-421f-9e21-6a442db4e913	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.177573+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.177529+01	\N
13402	ed9d1cdf-1d5a-46c8-ae9e-de9ae5a42aa1	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:00:00.201527+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:00:00.184553+00	\N
13690	8e066075-64a0-4359-9166-3eac036ad9a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.194496+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.194455+01	\N
13691	5564b231-f672-44f7-ac84-1331f466bbb0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.211445+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.211402+01	\N
13692	9980068a-1409-4aa5-9669-9391a7b907f6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.228666+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.228622+01	\N
13320	b0425474-d245-47d1-ab1b-c046f4005f70	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:10:00.170076+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:10:00.155271+00	\N
13693	f58366e4-fe15-4f1c-8538-f71339b14a0e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.245198+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.245152+01	\N
13694	0b190886-6cea-4345-a51b-d75d4687c746	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.262509+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.262462+01	\N
13337	216a3f04-7f74-4241-9309-1c87e089025d	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:40:00.199258+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:40:00.185662+00	\N
13419	84a1d09b-a017-4100-add3-ce0df16f6883	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:20:00.183577+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:20:00.168684+00	\N
13354	feb58274-c742-4b1a-ab4e-03eedf0aace2	SUCCESS	application/json	utf-8	null	2024-03-21 13:05:00.202176+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 13:05:00.175536+00	\N
13695	ec842bf6-80b9-4c24-acdf-809161c56c30	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.280228+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.280181+01	\N
13371	004bd8b6-a07b-4bbd-b437-97e23c25b916	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:30:00.17919+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:30:00.162205+00	\N
13436	0396c19e-27ed-4d97-8c49-d91298ff27b5	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:40:00.19383+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:40:00.178883+00	\N
13388	9e4879e3-bef0-4eea-939b-852044f5352a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 18:00:00.21288+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 18:00:00.196274+00	\N
13696	8e91b889-954c-4cb0-bf71-068dbe673324	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.297009+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.296961+01	\N
13453	0cc4f676-d81e-421d-8841-3f7e0b539e54	SUCCESS	application/json	utf-8	null	2024-03-22 03:05:00.212562+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 03:05:00.183446+00	\N
13697	3c69933f-f7a6-4c1f-917b-ccf944dff97d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.316287+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.31624+01	\N
13698	7c4edd08-811f-4995-a189-28f4b8883fd4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.335822+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.33578+01	\N
13699	c84ac7d7-c95f-42d9-87f7-1c3cd7d98c7b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.35279+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.352746+01	\N
13700	c504f97f-d7b6-45c8-ad71-67428ff9ef92	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.369955+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.369909+01	\N
13304	a085ac08-6d23-4790-9784-f564124d364d	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:00:00.207221+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:00:00.193497+00	\N
13474	d355acea-b2f1-486e-b7bd-ce5baaaceb94	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:00:00.192248+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:00:00.180025+00	\N
13491	38eda618-c63c-4012-9c3b-7489aa1c8d50	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:20:00.181368+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:20:00.167678+00	\N
13403	40857dcf-2c51-4928-b36d-862ce3cec6fd	SUCCESS	application/json	utf-8	null	2024-03-21 20:05:00.237169+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 20:05:00.181651+00	\N
13701	1a132948-2d38-4490-8689-805f54961512	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.386868+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.386822+01	\N
13702	2a464149-09ba-45f1-88d6-7fe22a970a22	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.403688+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.403636+01	\N
13703	c0829870-6f41-476e-bf5d-c2f18b6c4939	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.420329+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.420287+01	\N
13321	1868cffd-07f6-4706-b415-b16f6fdb7a67	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:20:00.183867+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:20:00.170199+00	\N
13704	90813607-c917-442f-b977-9e405d326800	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.437397+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.43735+01	\N
13705	ce1c0c35-3d82-40ce-84b8-4c3ea247314c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.45467+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.454621+01	\N
13706	7a0122f2-9890-4b76-bf1a-4901cbce1178	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.479847+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.479802+01	\N
13707	93216daa-d093-4822-ab20-0f1f99e74f44	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.496341+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.496297+01	\N
13708	bd1fae43-17c2-4917-a013-f4a98a65d124	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.513211+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.513166+01	\N
13338	6a3efc32-2d28-4639-b298-4ad97de55d13	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 10:50:00.13006+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 10:50:00.111637+00	\N
13420	16f277e8-447f-4184-982f-3601665ce3f0	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:30:00.190261+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:30:00.173353+00	\N
13355	042b455f-a06b-4ac3-af78-935a1015d9c1	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:10:00.188174+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:10:00.173228+00	\N
13709	c72e2809-d80d-4e27-83a2-a6e08ced9231	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.530424+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.530378+01	\N
13372	5eaf5df5-42d0-4a55-85dd-7ff62e02eee3	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:40:00.168377+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:40:00.152278+00	\N
13437	d79a4993-69d9-47b0-92b5-5086b9d67111	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 00:50:00.19602+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 00:50:00.181951+00	\N
13389	71294931-0133-480f-a50e-0eb09fb9636d	SUCCESS	application/json	utf-8	null	2024-03-21 18:05:00.188155+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 18:05:00.160806+00	\N
13710	edbeb0fe-fa1b-41b1-bf31-5f4d9c2ab75f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.547221+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.547178+01	\N
13454	529e1e95-cc1d-4815-b70b-69fc7bcffaac	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:10:00.152792+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:10:00.137774+00	\N
13711	12b7ab94-b953-449e-9720-5af377965d48	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.564142+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.564098+01	\N
13712	e76b5439-fe84-4fb4-9822-c70740e67239	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.581513+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.581468+01	\N
13713	109f0a50-4c05-4f4f-838a-2932297053e8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.598376+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.598333+01	\N
13714	e89366cc-ee41-445c-a021-be5ff06f883a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.615657+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.61556+01	\N
13305	8c3790dc-7c0c-447e-a644-40a5c1b070a3	SUCCESS	application/json	utf-8	null	2024-03-21 06:05:00.180994+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 06:05:00.152713+00	\N
13475	6c38e742-82ce-4a44-a61d-db71805eaa07	SUCCESS	application/json	utf-8	null	2024-03-22 06:05:00.205482+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 06:05:00.180553+00	\N
13492	527cfbad-4d67-4382-8950-de72ecd61a4b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:30:00.207298+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:30:00.193567+00	\N
13404	6103743e-f8cc-4c1e-af3f-441545edde9a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:10:00.199765+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:10:00.182+00	\N
13715	d36a3bd2-89c7-4298-8791-e90a66ed61df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.633974+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.633931+01	\N
13716	729d482f-ceef-4851-a0a1-c358817f86cd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.650339+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.650293+01	\N
13717	9d684459-2654-4a68-99e9-be9ee9e1377e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.666771+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.666725+01	\N
13322	fae1363b-0ef2-4ac1-b04d-1667a9bc80a4	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:30:00.199796+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:30:00.184464+00	\N
13718	c788786e-73ce-4d0e-895b-b5a2c74e2e74	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.683018+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.682976+01	\N
13719	15183f8b-833c-4a35-917f-ec6ac8f8cc98	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.699219+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.699175+01	\N
13720	008f3955-b671-486c-8f25-2493119d4fd9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.715992+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.715951+01	\N
13721	387eff64-35b4-43f2-9d71-80781d2b4aee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.732958+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.732917+01	\N
13339	ed9ece9d-4fa8-447d-92a0-a9d937e19a1f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:00:00.167716+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:00:00.152729+00	\N
13421	9f39b2f4-0bd2-4d48-9084-a99655c266ea	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:40:00.194372+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:40:00.180196+00	\N
13356	60785c2f-50b8-47ab-82cd-3bfaaf28ca70	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:20:00.180202+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:20:00.165847+00	\N
13722	b4d1e043-85e2-48a3-888c-418f734c3143	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.75313+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.753087+01	\N
13373	1406cce1-1cd0-408f-8a09-4f5c2cac131b	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 15:50:00.201506+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 15:50:00.184694+00	\N
13438	775269e4-3e5a-4230-9d4e-d82fdbb3889a	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:00:00.20302+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:00:00.187496+00	\N
13723	f9bff167-41b1-499b-98a4-8aade1cd76dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.770655+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.770608+01	\N
13455	8bb1e546-d6dc-4989-876e-0d2a64f96dea	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:20:00.20604+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:20:00.190388+00	\N
13724	c59337d4-9500-4158-8d40-f1d39e14dd85	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.788165+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.788121+01	\N
13725	59a421d5-a982-4590-a689-8522019966df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.805416+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.805371+01	\N
13726	ceffe930-9721-424c-92eb-5035cd06d4f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.822342+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.822295+01	\N
13727	aefe9111-af9c-43b2-8743-c045388b9254	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.839456+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.839413+01	\N
13728	83822dcc-d148-4524-8003-00f7975711f4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.856827+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.856781+01	\N
13729	1556e300-06c7-48cc-9515-4723a1ff72d4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.87405+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.874001+01	\N
13306	5a243bcb-b68c-41e4-a05f-d0fa6d42e245	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:10:00.201779+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:10:00.184649+00	\N
13476	a34bec8e-70eb-4b82-a166-08fe00063951	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:10:00.193506+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:10:00.181245+00	\N
13493	232537ae-da2c-4abb-8209-cb0e26845de6	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:40:00.207677+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:40:00.194057+00	\N
13405	10d9b96a-2972-4414-91d2-4a36c0688606	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:20:00.11208+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:20:00.095459+00	\N
13730	9acd58f3-f6a9-4304-9a18-cd8b8a336439	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.891299+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.891257+01	\N
13731	6a91bf54-1e3f-4058-a2f8-c70a48934519	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.908933+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.908887+01	\N
13732	0e6f4134-8d87-4b4b-89b0-9e712c1c883b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.926034+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.925987+01	\N
13323	f0e17a67-a302-49a6-9d97-3b6a6880790f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:40:00.182329+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:40:00.167579+00	\N
13733	c692915d-7c7d-4eb0-8016-9218fc87c478	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.943521+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.943479+01	\N
13734	e6788972-73ba-4e78-92fd-82488bf783c5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.961462+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:58.961409+01	\N
13735	96157f44-b16f-4a1c-9a90-72e872fca64e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.979464+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.979418+01	\N
13736	e7a2dede-8a50-4a2d-b1af-efcd18814188	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:58.99686+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:58.996816+01	\N
13340	ac2b4e14-c71d-4aac-a457-d92d64b8ec30	SUCCESS	application/json	utf-8	null	2024-03-21 11:05:00.143588+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 11:05:00.114756+00	\N
13422	7965a4b0-d97f-4efa-b162-04408e073bc8	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 22:50:00.198842+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 22:50:00.180714+00	\N
13357	47a67f81-00ba-4872-977d-b0872a2fff0f	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:30:00.109431+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:30:00.094666+00	\N
13737	25bde9e2-a4cb-46ba-a5a2-a6abff85ba79	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.014032+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.013984+01	\N
13374	7bcc8dad-5bca-4ea7-b0ee-0286842fa6c9	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 16:00:00.195931+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 16:00:00.181455+00	\N
13439	5a77d6b7-ac0d-4217-b072-61c1b83412ba	SUCCESS	application/json	utf-8	null	2024-03-22 01:05:00.201437+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-22 01:05:00.169481+00	\N
13738	8c15e2b3-ad0c-46c7-9836-fea54e89a2e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.031349+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.031305+01	\N
13456	8cb21102-6b20-46bb-93f6-b6ede4cc9181	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:30:00.21997+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:30:00.195179+00	\N
13739	9460750a-1992-4a44-affe-79c85f00a424	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.048064+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.048018+01	\N
13740	a02e0d49-a4f5-42e0-a3bb-62296b317023	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.064932+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.064886+01	\N
13741	35c185ae-dbe1-4a75-8a66-dffd51a90adf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.081352+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:17:59.081305+01	\N
13742	e9e7c2ba-c450-42c0-b30e-f54806cc7800	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.118928+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.118883+01	\N
13743	6fb7c525-0591-49b7-9dd1-e3f2e99ce975	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.266912+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.266867+01	\N
13744	9f2c4c97-1390-4495-a059-13db0d00a1f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.414947+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.414905+01	\N
13477	e4f02c15-1003-4b2d-9acd-366ba9c22541	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 06:20:00.179953+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 06:20:00.162199+00	\N
13307	fdfd513a-0294-421d-b2de-ee495a2ee5ab	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 06:20:00.207281+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 06:20:00.192536+00	\N
13406	ebf61e4f-f348-46f1-9a55-2347b5665cfc	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 20:30:00.185616+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 20:30:00.168224+00	\N
13494	a877d7b6-8914-4b95-8122-2ad03dd45f63	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 08:50:00.204366+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 08:50:00.19079+00	\N
13324	1b4e1852-f94f-49d2-9fe4-e199dd9a82db	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 08:50:00.142182+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 08:50:00.126437+00	\N
13745	2242a0d9-4bb9-48cf-ab3c-838bd37a9f09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:17:59.564661+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:17:59.56462+01	\N
13746	a852afed-785e-4b2f-9c7e-c6d6765d558e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.100255+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.100207+01	\N
13747	8010ba1b-d8c5-454f-9bbf-9505a4c143ee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.250018+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.249973+01	\N
13341	670e5107-40fa-42be-b0b8-f46afd2a8c43	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 11:10:00.160887+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 11:10:00.144014+00	\N
13423	388d70ff-9f8c-4037-acaf-4211495ea0ec	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 23:00:00.204913+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 23:00:00.187742+00	\N
13358	a0545d48-528b-42df-a8d7-7daf7f387832	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-21 13:40:00.18369+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-21 13:40:00.169285+00	\N
13748	e45a87b7-1ccb-4764-81d1-dc258678980e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.412954+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:00.412912+01	\N
13749	c5fd5b15-0453-4848-8412-f06db613769e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.578199+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.578152+01	\N
13375	6dc734ca-a2c7-4611-ab6c-5ad840b1f248	SUCCESS	application/json	utf-8	null	2024-03-21 16:05:00.212329+00	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-03-21 16:05:00.185509+00	\N
13440	03600616-b6e7-4a50-8632-3663b4e8f2bf	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 01:10:00.207055+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 01:10:00.192015+00	\N
13750	be06c388-fb8f-4a13-9aa5-56a2afbcd777	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.687045+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.687+01	\N
13457	9f3d441e-9888-4494-921c-d1acb4bafeac	SUCCESS	application/json	utf-8	"No new documents were added."	2024-03-22 03:40:00.207528+00	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-03-22 03:40:00.192229+00	\N
13751	e3b022f4-146a-44d4-8c4e-9fc68229c6be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.836549+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.836438+01	\N
13752	17e53569-0c09-4aff-81d4-f525524d5458	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:00.991481+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:00.991435+01	\N
13753	103165f0-8f94-46ed-b2fb-4edd5e213211	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.142563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.142512+01	\N
13754	d0869b2b-a5fd-46ac-8a89-0a8580adc12b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.291365+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.291318+01	\N
13755	ce45e712-9983-4ae5-af3d-95a027c2ac8e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.440144+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:01.440102+01	\N
13756	bba3414b-e989-4d9a-9db7-002148fcc436	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.50096+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.500911+01	\N
13757	c64ecbb5-b740-4945-8c36-0c187fbaaa2f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.651384+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.651336+01	\N
13758	35486bfe-85dc-40a4-980d-1f91580f2854	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.800876+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.800828+01	\N
13759	0cc74e28-65b8-483a-b5c3-2e3423868ccb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:01.952086+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:01.952038+01	\N
13760	255d0e6b-f7fb-44c5-a200-e2a2f5459f18	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:02.128886+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:02.128841+01	\N
13761	97f590fd-d182-4c6c-8e0f-645332142071	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:02.297175+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:02.297131+01	\N
13762	05cb55a8-916e-4902-bff9-46a4a38f9593	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:02.480275+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:02.480235+01	\N
13763	897a2749-b7da-409b-b08e-cd83c94631c9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:02.757313+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:02.757265+01	\N
13764	e8a08acf-dcc8-496d-8dd0-66eae605411a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:02.907134+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:02.90709+01	\N
13765	26e3475e-64c7-471c-ab1c-3c32d3e903fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.060011+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:03.059964+01	\N
13766	492a2cb9-9a2d-4acc-be9c-a06e2789d9ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.213849+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:03.2138+01	\N
13767	d5466a12-20eb-48fa-b2d7-d4f43e44bac4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.367349+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:03.367302+01	\N
13768	b8fd8b57-4fce-416a-8b19-7467d495d1b9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.535109+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:03.535063+01	\N
13769	dc058fd7-681f-454b-bdc5-bc9f9cd9873c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.702788+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:03.70274+01	\N
13770	1bf8c11b-8cb9-4e36-8a1e-b83f56918461	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:03.853109+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:03.853066+01	\N
13771	6150538a-f725-4b65-bff4-9ef92c7276f9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.005419+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:04.005371+01	\N
13772	a48d0f0b-e54d-4d11-83a2-c50bc3b6b36e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.157514+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:04.157466+01	\N
13773	391ce002-05cf-4652-90cd-516d8e7b4003	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.312941+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:04.312891+01	\N
13774	2b87b0a2-59dd-4e01-a4d7-96a876980d38	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.467445+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:04.467401+01	\N
13775	440396b0-dfa1-42cf-84ea-9998e9c493f0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.619563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:04.619453+01	\N
13776	9a8ecf08-46d0-44eb-be70-9d7dc64380d5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:04.769735+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:04.769694+01	\N
13777	4741e7d9-d04f-49af-8ace-cd5b3b1d1312	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.387324+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.387282+01	\N
13778	ca5c2995-f188-45a6-bd1c-1fa309afe345	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.581326+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.581282+01	\N
13779	4928eb61-390e-462a-a327-5d7227437fac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.645067+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.64502+01	\N
13780	6cd628b7-cd29-4daf-ba11-5c182587ecb1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.661979+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.661933+01	\N
13781	7dd5a232-1a26-4e10-8fa9-8c37f093b42f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.678365+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.678321+01	\N
13782	c24a1e7c-b12e-4e8b-9eb5-4078694cb773	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.694955+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.694914+01	\N
13783	ce37bdd7-457f-46a3-a51e-a41929c3966a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.711202+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:11.711157+01	\N
13784	138fe81f-3686-409f-9078-d7530d345968	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.728153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.728108+01	\N
13785	0692204f-1f2b-4b37-90a5-b90535ac8566	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.744744+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.744697+01	\N
13786	b0b3b28f-8751-4192-8d71-6ea2f91653a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.761679+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.761632+01	\N
13787	b19ef750-7455-4512-b29d-870b76b45128	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.777564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.777519+01	\N
13788	e7e5d355-d460-455f-a0fe-2584d449c400	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.79555+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.795509+01	\N
13789	81aef56d-1c2c-4cc5-8818-64ae5a1896d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.810397+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 21:18:11.810356+01	\N
13790	5910268d-0bf6-4cdd-9078-bcc0544484d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.825399+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.825359+01	\N
13791	ae70e0a1-c1b2-426b-bdc1-e0c368e6fa52	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.84009+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:11.84005+01	\N
13792	ccaa6c5f-0f19-4a20-9ddc-2aaf4190709b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.854649+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.854607+01	\N
13793	6af81288-dad2-4b07-a3a3-e4cc7a90f942	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.869148+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.869107+01	\N
13794	8668a32a-fdd7-475c-b84d-eda79a863f1c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.883066+01	\N	{"children": []}	"()"	"{}"	documents.tasks.sanity_check	celery@mandraw.noho.st	2024-04-02 21:18:11.883027+01	\N
13795	7aae3552-ac29-489e-a1f2-c1c3a54dc770	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.897552+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.89751+01	\N
13796	7e4d11bd-22db-4b29-b7d5-cc6358ef9a8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.912087+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.912042+01	\N
13797	f166214e-8d5b-4d62-905a-09a48e6fb441	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.926146+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.926105+01	\N
13798	0bdb9908-8e5e-428f-b37a-43e379a063e9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.940122+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.940081+01	\N
13799	976bdd9c-132e-4d97-8c33-2ed576d7a828	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.953994+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:11.953954+01	\N
13800	b614ff94-9620-400c-90a0-93eb1f5b2865	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.968224+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.968182+01	\N
13801	342bc4a4-c3dd-4511-810a-776477fcfcb0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.982017+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.981976+01	\N
13802	0112bd1c-307b-46d7-9844-6cf5fd03e194	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:11.996012+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:11.995968+01	\N
13803	63c34929-f1e1-4b0d-8335-6266a9406ea7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.009908+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.009867+01	\N
13804	15aa99a5-1dd6-412a-9d83-52bc767aa1fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.0246+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.024558+01	\N
13805	c46b96e4-92f4-4038-af13-703442150c9b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.038385+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.038344+01	\N
13806	dbf73faa-02d2-4857-97ae-1ee76f0e8fd9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.05233+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.052289+01	\N
13807	bbeccb62-fbd0-4f79-9e54-2bea8407a922	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.066859+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.066816+01	\N
13808	d6bad9a0-014d-4ecb-8adc-609b85b1d0bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.080884+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.080844+01	\N
13809	aea8291e-fa90-4635-a2f9-a4da4c1fa71d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.09522+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.095178+01	\N
13810	7ff906af-2f0e-4933-93f7-1abc3f69cf88	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.109242+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.109202+01	\N
13811	cde42e17-6fdb-4996-b657-12d646d0fb7c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.123853+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.123812+01	\N
13812	88e3b736-aadc-417a-aafd-3831720fe622	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.138462+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.138421+01	\N
13813	3abcd545-8793-485a-b24b-02a93528e74a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.156022+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.15598+01	\N
13814	d200e479-81a2-4dd7-bb67-99c035be8035	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.173821+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.17378+01	\N
13815	bdc6ed92-9c5b-4a68-a879-51f371c5f3b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.188311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.188269+01	\N
13816	48112c93-e853-49ca-b003-c00485bfdccf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.208137+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.208096+01	\N
13817	614b26b3-eec1-4a20-bb0f-dfe4b4a3b30c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.244215+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.244172+01	\N
13818	4ca9edf2-222e-403d-8f83-75ea3c7ee113	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.259181+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.259139+01	\N
13819	6334d9d6-59c0-4a4c-8765-c441ae003ed2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.273878+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 21:18:12.273837+01	\N
13820	829747d6-0c8a-4786-beed-4a7aec953830	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.288438+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.288397+01	\N
13821	8129e382-a8cc-4bad-94c0-23bc2c5c0e87	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.303082+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.303041+01	\N
13822	d9bea906-1ecb-450f-82d3-111dcd09ac70	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.317709+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.317668+01	\N
13823	8c3fce33-8b30-4697-9d67-d80ac7346302	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.332565+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.332524+01	\N
13824	cf71f733-95d1-4e6a-ade6-fb0b8c509d35	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.346682+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.346641+01	\N
13825	6d6110a3-f37c-4cea-a6ca-103acc277b64	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.360815+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.360774+01	\N
13826	e750eaf6-18f7-4e54-b506-fd5bc1d7e7e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.375071+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.37503+01	\N
13827	6234c4ed-86a9-46e6-8c8a-a8cf2e74dbf1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.388999+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.388958+01	\N
13828	0e7b1647-7faa-4a92-9559-0a2c304da446	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.403126+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.403085+01	\N
13829	7b889d8b-cb40-40ad-a89c-5b40f06f390f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.41752+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.41748+01	\N
13830	c694e5f3-5578-4815-bbb9-e9df5ff6dcbf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.43195+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.431909+01	\N
13831	bc294a71-9b65-4fd7-8f30-6cc8ca45c2d8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.445744+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.445702+01	\N
13832	d9f8b1ef-fecd-4358-889f-975a420e8af0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.459825+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.459783+01	\N
13833	28abc39c-262c-4b19-9d41-8f0fd426a09f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.473922+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.473881+01	\N
13834	670db5d6-82db-4387-b1f2-c53568a68840	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.487978+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.487936+01	\N
13835	5ef4349d-71fc-4252-be0b-4f46118d1285	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.501986+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.501946+01	\N
13836	429c9f19-fb84-4abe-9b92-ae7f478e1bbd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.516342+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.516302+01	\N
13837	6689b943-cc81-4f2e-b37a-ddd8ebede1b9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.532664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.532624+01	\N
13838	0a5de71a-56e0-4296-b4e3-fc15250a0739	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.54675+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.54671+01	\N
13839	6472494e-4491-4791-986f-cf47eeb2d505	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.560646+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.560604+01	\N
13840	147a10dd-b252-44d7-b9a9-efbb5a303bd7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.574793+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.574753+01	\N
13841	6cf1513c-75f8-4c26-a88d-45f83cdd8496	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.588903+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.588861+01	\N
13842	7725b250-2d72-43be-9893-3e7a69c49937	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.602767+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.602728+01	\N
13843	7f72ea9e-ea2e-441e-ade7-257ad17c5d7f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.617082+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.617041+01	\N
13844	ae57456e-86c1-4080-a659-e879af439e73	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.631116+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.631075+01	\N
13845	5c200894-7849-4a83-8b45-888a5757dd2d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.645219+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.645179+01	\N
13846	cdb96798-a35b-4bf8-9106-216a1a08b1a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.658928+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.658888+01	\N
13847	2190b5e7-85a8-4926-9570-957feadfb274	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.67352+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.673479+01	\N
13848	df48f919-1845-4488-a1fe-0b03bcfa9a0f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.68784+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.687798+01	\N
13849	0a4eb19a-5cbb-45c4-bd34-5f308c26e0b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.704747+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.704706+01	\N
13850	e8338fea-3041-4e31-9fb0-c89a9d3b6095	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.719071+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.719029+01	\N
13851	a0c4d649-defe-419a-9aeb-7e801b9458b9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.735067+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.735027+01	\N
13852	e11687ed-f28c-4385-a165-90a2558427ec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.755086+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.755044+01	\N
13853	5ccab5e3-3b10-4a42-a4ba-d6c8ad006b94	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.773531+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.77349+01	\N
13854	a7fca212-c690-4f22-9fef-d8104710b5a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.80879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.808749+01	\N
13855	9754b4d1-039c-485f-a378-f8a51faaf696	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.826764+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.826723+01	\N
13856	a5cc4b1a-68f5-44da-bfb2-10b689de6670	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.841859+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.841817+01	\N
13857	54dec2e3-500f-40a2-8fae-a7039543568a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.857041+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.857+01	\N
13858	4d8bffad-8f37-4447-8624-16d2bd2b2d14	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.870931+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.87089+01	\N
13859	0bf403d6-af70-48da-9780-71e7a80f179f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.885229+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.885187+01	\N
13860	d161ff54-54b1-487a-827e-97b1d3b5b1f2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.899889+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.899848+01	\N
13861	b84a7a25-1449-4694-a902-a0d08a9ad7bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.914344+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.914303+01	\N
14991	77f06058-3b4b-4af5-893a-e46912d304f0	SUCCESS	application/json	utf-8	"No issues detected."	2024-04-02 22:07:07.915368+01	\N	{"children": []}	"()"	"{}"	documents.tasks.sanity_check	celery@mandraw.noho.st	2024-04-02 22:07:07.889547+01	\N
13862	44621888-ea14-474c-8e35-0272954c30df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.928521+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.92848+01	\N
13863	8796fd64-79ab-405a-8295-8c1277103c6e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.942757+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:12.942715+01	\N
13864	535336f3-19b4-4f55-8892-9b72eb6651be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.956965+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.956925+01	\N
13865	35541a68-22b9-4749-94a6-ecf79a4e96cd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.971069+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.971028+01	\N
13866	e369c642-3db6-4a2f-830b-2447d1ee94d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.985031+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.98499+01	\N
13867	346fbbe9-1b43-47d8-a271-b2d3bbab759f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:12.999188+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:12.999147+01	\N
13868	4355570d-48da-4d23-ab47-365cec526a56	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.013304+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.013263+01	\N
13869	5f3f866b-0dd7-4642-8528-c3b1e023c26a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.027408+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.027366+01	\N
13870	9e697763-5812-4ac4-b92d-23dd9245f0bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.041545+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.041504+01	\N
13871	ab2b8287-11a9-4fae-8377-2852e9afd658	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.055514+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.055473+01	\N
13872	c5f1a1c2-02b7-4d85-8125-ee619393939f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.070323+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.070282+01	\N
13873	27907e5a-7dfa-4024-9351-ef701c69222d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.084364+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.084322+01	\N
13874	2bdf0b80-b460-4322-8ab4-61bd4ba87cff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.098574+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.098533+01	\N
13875	6c9eaeeb-be6d-42ea-93d8-c3294e915a44	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.113053+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.113011+01	\N
13876	afe2cc6b-2864-46b5-a46d-8a9c46244e0b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.127557+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.127516+01	\N
13877	92ede0c1-0690-4b45-9735-0f543a84ed63	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.141828+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.141787+01	\N
13878	a3515ecd-2316-4acb-9a8e-1d2d8d5f9fc6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.155961+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.155919+01	\N
13879	40eb0247-f51f-4362-949b-85c429538370	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.170025+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.169983+01	\N
13880	e1c5633e-853a-41e8-8d5e-7591ae1d670e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.184157+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.184116+01	\N
13881	61a74ab5-7f28-47e9-b585-09b10d9a7c8c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.200395+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.200354+01	\N
13882	c716535e-7efc-431f-9296-cdc95670f984	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.214865+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.214823+01	\N
13883	520fcb52-74f5-4b4f-93a1-28876ba786d1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.229742+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.229701+01	\N
13884	7c7bae3d-a843-4c64-8981-4f8b38fdef70	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.243757+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.243715+01	\N
13885	051d5bfb-2c9a-44ae-a42c-a659c686d440	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.257767+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.257727+01	\N
13886	42d663aa-7486-44ad-9b00-bdb52aaf14e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.272306+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.272265+01	\N
13887	5744f450-8654-4210-8650-858ab25a0638	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.286615+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.286574+01	\N
13888	455d08c6-3a49-4318-a56e-2db5a4047794	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.301391+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.30135+01	\N
13889	635b7587-38c3-45ad-aa1a-d9e4dd236b42	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.316033+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.315992+01	\N
13890	b7d9fee2-2319-4ef6-a9a4-1355e2ac802b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.336951+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.33691+01	\N
13891	b0b573df-0c66-4093-9818-8bdc7b1f7d99	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.375307+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.375266+01	\N
13892	3086ef74-9e4c-4528-b3bd-a2ad216840ee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.392693+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.392652+01	\N
13893	640d6246-bc49-4a3d-ae6a-2a568ce5c1e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.407233+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.407192+01	\N
13894	4e56cc57-a1f6-4e6b-b550-b2c6a07a76ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.421695+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.421654+01	\N
13895	e7fb1b05-e82d-43ef-9252-d9546d668f35	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.435992+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.435951+01	\N
13896	da889039-8bc9-49e9-ac87-bebed050cec5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.450094+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.450052+01	\N
13897	e4d66873-7bae-425f-880f-ecd4ad337151	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.464385+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.464345+01	\N
13898	7b6f26f1-1209-4c78-81af-ec3aead53ac0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.478716+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.478676+01	\N
13899	edc57dea-1235-4dc2-8da3-67ba7a8ff005	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.492711+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.49267+01	\N
13900	005ea217-0d7b-43d8-b5a5-1809e69b7095	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.506966+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.506924+01	\N
13901	5b69629e-0097-4761-82ca-f43180e3e02c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.521206+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.52116+01	\N
13902	ff047cba-c6a1-491e-a3a3-d8d07f8d6242	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.535276+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.535235+01	\N
13903	272ddf57-d6e9-4281-9167-ab5673e5c9eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.549549+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.549509+01	\N
13904	64f88ec2-bec1-4e3a-94d3-a49756cfda05	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.563548+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.563508+01	\N
13905	e4fd1921-0984-451b-b562-406d2e332d36	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.577656+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.577617+01	\N
13906	3f04a02d-4a3f-410c-97e4-bbc70b9d4d52	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.591795+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.591753+01	\N
13907	859f73bd-7480-4ac2-8dc0-147def529c2b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.605841+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.605798+01	\N
13908	7fb78691-06d4-4186-a9a7-240ee68509d2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.620083+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.620041+01	\N
13909	3f36fa6e-03bc-4b99-b692-9333503dd505	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.634227+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.634187+01	\N
13910	ec8f172d-1785-40ec-ae24-0f29a7c5ab85	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.648451+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.64841+01	\N
13911	c7a29b55-5a5f-4066-8388-fe5817aec1ec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.662643+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.662602+01	\N
15319	a4694e94-71e9-4208-9fb9-b9c4c32448b9	SUCCESS	application/json	utf-8	null	2024-04-02 22:07:13.094829+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:07:13.036456+01	\N
13912	7fd8f74d-0796-48c9-9a2c-8ebd61617016	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.67694+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.6769+01	\N
13913	7e863792-ced8-4a88-9936-1c086444501f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.691186+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.691144+01	\N
13914	3d598512-6371-495c-a829-7027664a3ff8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.705344+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.705302+01	\N
13915	0c4e0c57-1728-4750-b7b2-f0cec54e1342	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.720084+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.720043+01	\N
13916	8aa51ce7-8bcc-438a-b396-81c2a50edf72	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.733915+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.733874+01	\N
13917	d7c24fe5-1cc9-4490-adcf-c994cfeb4780	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.747995+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.747953+01	\N
13918	aa097f0a-5585-477a-a8e3-abb4bf75f796	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.761996+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.761956+01	\N
13919	3d9639ef-8fc5-42b7-a2d1-ce5beb2e7259	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.776918+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.776878+01	\N
13920	4ae9a073-6a31-4650-88ea-f83b78cb64ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.790934+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.790892+01	\N
13921	d47695b5-7945-400e-ba9a-e93a1dc9f4b1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.805811+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.805769+01	\N
13922	03827f2d-3656-4368-9cb4-091b23c306f8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.822586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.822544+01	\N
13923	11b429c4-3ee8-4f8d-afbc-a805cae715ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.842652+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.842612+01	\N
13924	e9582676-b40a-42ad-9203-586be62d4cb0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.879643+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.879557+01	\N
13925	95ed7d10-a55c-46c2-8e3a-7b19634b8e09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.895922+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.895881+01	\N
13926	a23ff54d-4c52-422e-9395-4cd3fc2b491d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.910077+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:13.910036+01	\N
13927	364e1f1a-b221-4e79-bbf2-ab00f44ad81f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.924629+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.924588+01	\N
13928	81101a2f-4eb0-4615-a76b-e255b1932d63	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.939995+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.939953+01	\N
13929	4f26e8a1-be53-4653-8154-d32797463dc1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.955109+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.955066+01	\N
13930	05db47c1-df09-46d2-b2d3-26e316da4dc3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.969545+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.969503+01	\N
13931	ccd2080f-7237-4b7e-87a4-576ce649dfd7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:13.984019+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:13.983978+01	\N
13932	dfdc4b36-3d34-4047-96d6-510cb87d5063	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.001112+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.001071+01	\N
13933	3d9c287d-970a-49f9-9151-c424ef71be87	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.018364+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.018324+01	\N
13934	e7656f5d-bae0-43a6-b295-b40eb2a4d48e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.032815+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.032774+01	\N
13935	84605500-e12e-43dd-b560-d1d6e85ef234	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.046744+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.046703+01	\N
13936	e1085b1e-5e33-48c6-825d-0047807ae025	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.061421+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.061379+01	\N
13937	ad5aea86-52a6-4ef9-9c65-75bb2d6f929b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.075652+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.075548+01	\N
13938	1247bc72-52a5-4e0b-878e-765f18e50baf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.090134+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.090092+01	\N
13939	b6de7309-7ecd-45fd-805e-7b33a06d5c91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.104503+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.104462+01	\N
13940	9aa677a9-f33b-47d5-b142-8d1e545263ac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.118784+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.118744+01	\N
13941	e8d3a856-04ac-447a-8873-4af1b3657919	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.132919+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.132878+01	\N
13942	452af84b-4117-4852-bedb-77ac0ffc3b23	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.14712+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.147078+01	\N
13943	a1a910e8-326f-4b44-88d3-976b238818d5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.161055+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.161015+01	\N
13944	9b4e949b-c690-4d39-a850-6e991df66b5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.175322+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.175281+01	\N
13945	28a355bd-6bc8-4a8f-a47b-3be1da1156ac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.189539+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.189498+01	\N
13946	9f8b4054-048a-47c0-846c-562c58ecf4cb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.204076+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.204035+01	\N
13947	c2e4e265-51b1-4015-85b1-90d4ef28a995	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.218056+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.218016+01	\N
13948	7cc86f76-2879-4640-9fa9-46f4151c9d98	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.23276+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.232719+01	\N
13949	8efc077c-aee5-4464-b690-9023061d6710	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.246867+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.246826+01	\N
13950	96581f8b-070b-4dcb-bd33-0c629dd200b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.260874+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.260834+01	\N
13951	d42c635f-5fbe-4bdf-8a2f-c5fe727f4fe3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.274927+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.274885+01	\N
13952	7c5c501c-6608-45aa-9b37-848dee9a8720	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.28906+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.289018+01	\N
13953	6c9e195b-4e4a-4c69-a2b5-e8bc3e138a22	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.303409+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.303366+01	\N
13954	25c1261f-dc2f-4da4-8add-3aedc9992b17	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.321675+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.321635+01	\N
13955	c8dd8396-7a38-4755-b947-085273142c79	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.372651+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.372609+01	\N
13956	873fcf00-b471-429d-9ba4-b098eab9f7c7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.388151+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.388107+01	\N
13957	dcf0744a-8983-46d4-825e-6470d646cb57	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.402358+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.402316+01	\N
13958	067df180-ddb1-48cd-8438-c9d18f77109b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.416808+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.416766+01	\N
13959	a2f491fb-9fb4-4f07-95d8-e5522d5f2f8a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.431258+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.431217+01	\N
13960	c7a7a0e6-1d3e-486d-bf25-607f23aca8fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.445271+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.445229+01	\N
13961	ec76de05-9040-4f06-8a0e-30508c753cac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.459171+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 21:18:14.45913+01	\N
15465	f094ea90-8831-4cbb-ac63-5f03fb84c559	SUCCESS	application/json	utf-8	"No new documents were added."	2024-04-02 22:07:15.554919+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.540226+01	\N
13962	65ccfa4e-6ebd-4b77-9418-3b076d9a1b5f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.473271+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.47323+01	\N
13963	22ec5972-d990-4d45-8c91-da68dd3a1eb5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.487711+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.48767+01	\N
13964	048bdb8e-9110-4765-84a6-b8b6f190d490	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.502352+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.502311+01	\N
13965	fd544f9b-08d3-468c-a0f8-e6a1ba162e1b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.517588+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.517547+01	\N
13966	021c3c4b-61dd-46a9-8203-8f72a5fc3a12	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.532243+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.532202+01	\N
13967	4a17d3ed-154d-4a8a-9d61-e6216140694c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.54632+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.546278+01	\N
13968	eecd030a-fc99-4a3a-951a-f044d9a1ac33	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.560484+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.560443+01	\N
13969	0ba28f6b-ce42-4152-9970-9a97ca0bfe61	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.575383+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.575343+01	\N
13970	71840eaf-9224-4920-98e6-0035ee776cdd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.590151+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.59011+01	\N
13971	2fcd5ff7-72be-433e-a0f1-ef6cf759f559	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.60707+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.60703+01	\N
13972	78e814a0-66d8-4f48-ad6e-5a70b82dcb9a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.624842+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.624802+01	\N
13973	49c12074-e4af-4f1a-866e-4b6eac9c453f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.639057+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.639015+01	\N
13974	4bc034de-b398-475d-a808-8c1a41faf994	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.65428+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.654239+01	\N
13975	47774cba-1950-47ea-8418-1bf9e71cb09c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.668781+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.66874+01	\N
13976	a2e0c394-6a6a-401e-85a9-b1f673808e86	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.683307+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.683266+01	\N
13977	69090abb-99f6-4e9f-8c1a-70e1ca11e5c9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.69804+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.697999+01	\N
13978	43f2bda9-d9f4-4e29-a778-99323b7f3ad6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.712311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.71227+01	\N
13979	17f87be4-00cf-4d78-9eec-df56a06a8bdd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.730476+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.730435+01	\N
13980	47daa48a-67e3-42b5-abb7-473b4084844a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.748746+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.748704+01	\N
13981	bd864bc5-85da-47af-82e1-b95556f8ff4e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.763394+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.763353+01	\N
13982	e6337928-bed3-4024-a4fd-f97b17c9604c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.777782+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.777741+01	\N
13983	a4d0eaea-c8f0-4d44-93c5-5286d85873de	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.79202+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.791979+01	\N
13984	db9e18b6-dc2f-4749-b595-7494ef57889b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.806706+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.806665+01	\N
13985	cb92d064-77ac-485b-a971-8dabb78c7e79	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.821372+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.821331+01	\N
13986	8b0a2c95-1984-4b35-a095-4ef858cba9a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.835977+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.835936+01	\N
13987	d46ee31b-d148-42c9-b6ad-e9374732392c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.849868+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.849826+01	\N
13988	7437b668-4283-4553-8997-b0788e075878	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.864521+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.864479+01	\N
13989	bd28b87f-c464-4134-8ed3-1abd1dd7eebe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.878634+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 21:18:14.878593+01	\N
13990	52ad704b-4e39-44c4-aef2-e19a96751e04	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.892794+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.892753+01	\N
13991	f4253cf4-3796-4305-88b1-6de19517351e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.907036+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:14.906997+01	\N
13992	a18051e0-8a99-418a-a0bb-1c5b41ce930e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.921612+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.921571+01	\N
13993	fe295e7a-b3dc-4516-9f98-8afe6be92616	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.935545+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.935504+01	\N
13994	c4fca8bb-3bf5-4737-852f-3adb994edabd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.949476+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.949435+01	\N
13995	760f8507-e164-4910-a00d-6fd26fe6fb7d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.963731+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.96369+01	\N
13996	50ae8fc0-7158-4f6e-ac0b-0b4990fcf62a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.978368+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.978327+01	\N
13997	9035e03a-87a7-414f-a5cb-4c7febb24021	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:14.992446+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:14.992405+01	\N
13998	86b82017-3806-48d8-b085-9c51f9498067	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.006809+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.006768+01	\N
13999	0fd8770e-afdb-49e8-acf5-56d770b79831	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.020935+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.020894+01	\N
14000	92ad49d8-7956-4656-a6f8-958ab82977f3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.035341+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.0353+01	\N
14001	2db9bad3-4180-4702-a4d6-ef7c48f2a781	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.049344+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.049303+01	\N
14002	677ea9ea-c5f9-40ad-a8aa-c3e520cd830e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.064638+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.064597+01	\N
14003	f57b6205-ed99-4f3e-836e-f046461692c2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.078847+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.078805+01	\N
14004	e6c32064-b45f-444b-8bd7-f20cc5af7103	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.092877+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.092836+01	\N
14005	baf6e5c8-4d56-46e8-8321-fdd269ff3f4c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.107493+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.107453+01	\N
14006	a8f69be5-4e97-4d8e-a5c4-9e90cb15d748	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.122119+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.122079+01	\N
14007	b6803623-6071-460a-80b0-231f1940c685	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.143022+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.142982+01	\N
14008	a7c1724c-92db-483b-855e-7d3ddfbfeae7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.159885+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.159843+01	\N
14009	dd9ce930-96aa-4469-b7c0-776b862b2d51	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.17398+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.173939+01	\N
14010	0f55b98c-7808-495c-bb89-ff21dc3c37e6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.187943+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.187901+01	\N
14011	984ea36c-98d0-40d4-acfa-97b326b8265a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.202661+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.202622+01	\N
14012	bc8ffa2b-5ab1-426f-ad0e-54b5b8917c3b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.21727+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.21723+01	\N
14013	ea0860f6-067e-4124-962f-8010449bf582	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.231352+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.231311+01	\N
14014	37a19790-e1e2-4613-8659-4a23ca80f6ec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.245538+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.245497+01	\N
14015	d1aecc4e-5127-4747-bac5-9a25b16e7076	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.259829+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.259788+01	\N
14016	acef5aae-ceee-458e-a82b-8c6d2d6f1b5f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.274244+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.274203+01	\N
14017	9e5cc211-d5d4-44fe-9b1e-bddb1ac9596a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.28879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.288749+01	\N
14018	8fe66604-19aa-46c1-bb67-b692c10460f0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.306069+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.30603+01	\N
14019	b38ce6c0-1919-4285-a220-71469f2414c8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.324292+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.324252+01	\N
14020	d1ac1350-327c-4bbd-a5c4-8d9d5e37d516	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.338516+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.338476+01	\N
14021	3dd5d9f8-7a5a-40d6-a594-81daab223558	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.352664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.352623+01	\N
14022	29cbf8ed-6e99-415e-8c34-52ebbe1c4de6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.366741+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.3667+01	\N
14023	18ffda10-5344-4761-b3d2-e08039238821	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.380672+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.380632+01	\N
14024	efd5b8dc-b845-4354-81e9-615ef99fe8a7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.396805+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.396764+01	\N
14025	bd976621-6af8-4a0e-9d74-9efe17fbcd31	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.41205+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.412009+01	\N
14026	280e867c-2b22-44e6-ac28-4e1c97edba6d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.427274+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.427233+01	\N
14027	fc6e3dd6-f7e7-4799-9720-a254cdf4329c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.441501+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.44146+01	\N
14028	7736c7ee-194d-4471-869b-2a861ab86f83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.455852+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.455811+01	\N
14029	bee0eded-8e1b-4566-bde3-964c357970ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.469877+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.469836+01	\N
14030	7c4422d7-945a-413c-985d-3c8527806e8e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.484061+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.48402+01	\N
14031	7a9021dc-8c75-4a25-a996-69015f3282a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.497989+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.497947+01	\N
14032	29799918-cf13-4be4-980c-f01e7194f86d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.51304+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.512998+01	\N
14033	b692db91-4a7b-41e0-b030-7bb02ff9f2fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.527+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.526959+01	\N
14034	794b7cb1-a188-482b-80da-a56bd45101f4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.54129+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.541246+01	\N
14035	fdcd246d-b27b-402f-99fe-6d622ce0e400	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.555447+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.555404+01	\N
14036	8211d994-b9cb-45b5-9b4b-18a5dc20fe80	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.569799+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.569758+01	\N
14037	1fc0107a-f11e-41e6-9811-e7e295dc9fa6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.584622+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.584581+01	\N
14038	46c38cfe-6b77-4070-81fc-0a02cd4f7e8f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.598678+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.598636+01	\N
14039	29f2df40-db40-49cf-ab1e-c5f8a626fca2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.613345+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.613302+01	\N
14040	6600c62d-4a6a-4d5d-a6cd-3fe931e0be44	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.627573+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.627533+01	\N
14041	bb6dce8c-957e-486d-83d0-84c2665efb14	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.641614+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.641572+01	\N
14042	bcab9f89-8800-4ad2-b3ba-de664085bd48	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.656188+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.656147+01	\N
14043	46a65d31-64a4-406f-92b1-338b4ec6cb6c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.670275+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.670234+01	\N
14044	f54f72f5-baf4-4643-80e1-e2114906c1ae	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.684664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.684621+01	\N
14045	27812575-ac06-430d-aee0-194b15b4d1b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.698684+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.698642+01	\N
14046	f2d1c56a-3112-4775-abfb-621bc3f86191	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.713278+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.713236+01	\N
14047	9559f502-755d-420a-88af-3ba03e25dac3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.727861+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.727822+01	\N
14048	e4249810-f30b-41b3-8229-df3aeb88c070	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.742653+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.742614+01	\N
14049	41159329-f42c-412d-afff-f422719cd60c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.757278+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.757239+01	\N
14050	4c862592-e749-4b0b-8e81-38f1d43ac926	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.771563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.771522+01	\N
14051	79af8e01-fb1c-4a9f-953c-4f5b7fa54c41	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.785604+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.785564+01	\N
14052	4a6ffad7-5711-47c0-bd78-fc9645d5ae8a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.800832+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.800791+01	\N
14053	d0496352-cdd3-4d48-8610-c4b68eb8b295	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.818114+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.818062+01	\N
14054	5047b068-9b66-4ce7-93ef-9d94f7490b08	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.837784+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.837731+01	\N
14055	8218fc34-86be-4cbd-a36d-5207a3cb8dce	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.856591+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.856537+01	\N
14056	16913bfa-653f-4b4c-9670-8053e770c587	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.874554+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.8745+01	\N
14057	4e8c4f10-8caa-4e73-90c8-c9244dc00f4a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.892708+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.892654+01	\N
14058	2c3ced30-3aa1-4507-81c9-192e08b616a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.910689+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.910637+01	\N
14059	b4614285-7bf8-4f93-9c2f-e176a49ab10f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.925378+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.925336+01	\N
14060	be57aca2-3cdc-4db0-be47-187e78a4a3a9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.939817+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.939777+01	\N
14061	f48c006c-e9dc-4ec2-b617-5e60cf0b24be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.953823+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:15.953782+01	\N
14062	2eb8857d-5d01-431b-a64a-1507ef0f9716	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.967783+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.967742+01	\N
14063	75922cb3-ef66-457f-ad49-592c0d1ab2de	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.982425+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.982383+01	\N
14064	06934c8a-e011-4850-931d-23eb2d59e3ea	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:15.996768+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:15.996728+01	\N
14065	6b2ab1c4-2e85-44dd-a046-15372786f1e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.010625+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.010586+01	\N
14066	e02c6cea-dd86-43fa-9050-c0538c10323a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.024657+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.024617+01	\N
14067	7fa17a23-3c17-4695-a7cd-5168a69fd88f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.038718+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.038678+01	\N
14068	f39aace0-cfe9-4cf4-9363-ffc12a07fa54	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.057547+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.057507+01	\N
14069	97972630-771f-4671-83a1-c36e7b6de286	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.071993+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.071953+01	\N
14070	842206eb-35d5-4495-a9d4-26427a123edb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.086674+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.086634+01	\N
14071	776de5a9-0c4f-4c1c-848a-6c3a103d9534	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.101051+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.101011+01	\N
14072	4649f659-b4ac-428b-bb29-7e2aa28a14ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.118215+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.118174+01	\N
14073	c42f6df8-b46b-44b7-976c-9953981cd689	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.133928+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.133882+01	\N
14074	eb93223c-334d-47b4-922c-d5bcbcb68778	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.155266+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.155225+01	\N
14075	9cbdf555-63fd-4a69-a586-f5910f42eeaf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.170014+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.169973+01	\N
14076	c452fd15-0d43-4695-b490-2bd3df4adf1e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.184267+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.184226+01	\N
14077	438b0469-30bb-4036-a845-25b0c16fb1a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.198496+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.198456+01	\N
14078	765f3c3b-056e-474e-9b39-1e2a51f01fb2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.212817+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.212778+01	\N
14079	0a1dca2f-4efb-4a9c-b98c-00e4e3984a86	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.227288+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.227247+01	\N
14080	1e28b440-28e3-4d98-8b14-984d6484171d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.241481+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.241441+01	\N
14081	ddad3b5a-b11e-4c13-9336-72f4d2dfae37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.255762+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.25572+01	\N
14082	2713d59c-3dd1-4393-9eb5-0ec129d219ae	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.269753+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.269713+01	\N
14083	5b64f3ff-9b4e-4b03-ad13-944b29824f03	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.284145+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.284105+01	\N
14084	1d891296-7278-493a-b291-cacf2fc85f55	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.298185+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.298144+01	\N
14085	7baca79c-30e3-4244-bf28-2329d98e9d21	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.312333+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.312293+01	\N
14086	be73db0e-c28c-4273-a140-6f8d2e991be3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.32644+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.3264+01	\N
14087	acc5f55f-8b96-45dd-85ed-7863e75c530f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.340888+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.340849+01	\N
14088	a8ad66c6-ee91-4534-ba3d-274daaad261d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.35515+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.355109+01	\N
14089	f43fe053-286a-4aef-a0ae-4a08df8d9f9a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.369135+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.369094+01	\N
14090	c15f67a4-e94e-4d23-a449-c58f9c827e6a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.383686+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.383576+01	\N
14091	65f704b4-bcae-43f9-98a7-fbd171e2b1a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.400796+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.400755+01	\N
14092	ab58c59d-ee00-47a9-ae39-0c6ca142b98f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.414999+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.41496+01	\N
14093	98e423e3-5532-4438-82ad-8c8620fa2845	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.429523+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.429482+01	\N
14094	e3b03614-2d29-4265-a6d3-c3b21928eb9a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.447145+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.447104+01	\N
14095	e1f9c56d-ab2e-42b8-a738-1201301acf8c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.464636+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.464596+01	\N
14096	fc56abff-a4a2-4ff5-82c8-7088e3846e40	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.479169+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.479129+01	\N
14097	c758256f-efc9-4c16-8450-1f54b5c3f0c7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.493288+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.493249+01	\N
14098	8cba7049-c10b-460d-a36c-dacf4225976c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.507452+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.507413+01	\N
14099	4dfe1b41-35d4-40e1-9d1b-11aebc250c54	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.521652+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.521612+01	\N
14100	a8d46b5b-ca44-4c40-8262-489c1105fc10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.535921+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.53588+01	\N
14101	5c291e6f-78ff-48a5-b614-bd6355644005	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.549765+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.549725+01	\N
14102	900ebffd-2029-4f1c-9950-0ce2c27d91e8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.56376+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.563717+01	\N
14103	a0fcd4c6-be70-4583-8912-0ae01311b5d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.578056+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.578017+01	\N
14104	a8e9946f-7849-4df1-a840-841f726994a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.59256+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.592519+01	\N
14105	cbca4e84-2e91-4e0b-b4b9-b236ff0bb451	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.606721+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.606681+01	\N
14106	2aec4dfb-0352-4772-a356-69553d78fcd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.621147+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.621107+01	\N
14107	abf69451-3186-4e53-aea1-893a8db44796	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.635068+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.635028+01	\N
14108	0a8ea6cd-0fd4-4c28-963b-0ca9f6368e79	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.649322+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.649282+01	\N
14109	2331cb99-21c9-46b3-8663-e821022558b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.663442+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.663402+01	\N
14110	e8263aa0-113c-4fe9-bf5d-54c669f5c475	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.677442+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.677401+01	\N
14111	c7c9bcb8-0a86-4cb4-9e3c-bad94d3e1abc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.691959+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.691917+01	\N
14112	bea6aad5-cb6d-4612-b3a6-838baee1fad1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.706129+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.706088+01	\N
14113	32bfdfb2-7c26-4f65-878c-274eb54dc7c5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.720114+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.720072+01	\N
14114	b758862f-359b-4cb7-87e7-d662ed8be23e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.734173+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.734131+01	\N
14115	ee770309-6a1c-4f83-a11f-1dc08a478903	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.748621+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.74858+01	\N
14116	081174f3-0a2a-42a0-9d76-8ac57264f790	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.7626+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.76256+01	\N
14117	ec4f4f18-afb2-4950-af99-0f4de3b0127d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.776813+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.776773+01	\N
14118	d021c9e9-e5fe-43cc-b26f-ce111e1ce09b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.790612+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.790571+01	\N
14119	17ec9289-54ac-4e72-9360-90abc8463ea0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.805221+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.805181+01	\N
14120	148d17b0-46ea-4185-aa8f-95e759cfab76	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.819465+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.819424+01	\N
14121	24598ea0-835c-4bdf-a1da-051891cf182a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.834051+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.834011+01	\N
14122	8ec7bf68-1163-4505-bd07-c08cbae63a9a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.848636+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.848596+01	\N
14123	6a27eddb-de35-45bd-97a0-aef50add623f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.862976+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.862935+01	\N
14124	72fa4079-c241-4fe8-85cf-cb29b6133326	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.878465+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.878426+01	\N
14125	f48286ce-14bc-48c4-b474-15f5fd1f892f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.89255+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.892509+01	\N
14126	5baf7dbc-0d57-4841-b7d4-6f29896553c3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.906637+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.906596+01	\N
14127	187aa577-de1c-4d9c-a4f1-149acf624111	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.921118+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.921074+01	\N
14128	95ef39b8-7594-40c5-ba15-32fa9e4f58bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.935176+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.935135+01	\N
14129	23fa8f8b-e6a9-4e4e-a746-49a1371e4e54	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.949858+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.949818+01	\N
14130	3d21b137-dbe1-4b94-9c91-f3b3ffe818d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.964065+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 21:18:16.964025+01	\N
14131	832f7085-7faf-4218-a107-91e5686f54dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.978563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:16.978521+01	\N
14132	de2215b1-ef4c-497e-b97b-2a9923a2ebc7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:16.992927+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:16.992886+01	\N
14133	6346822d-4fdf-4969-8f69-d75f28539f57	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.007196+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.007155+01	\N
14134	6d3fecaf-585c-480f-9187-40c2e269c47c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.021564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.021523+01	\N
14135	e4ec73a6-e1f2-4f87-9093-f9198238eef8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.036189+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.036148+01	\N
14136	1c7c42ff-cf80-40d0-9ac0-f879fcc7a30a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.050021+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.04998+01	\N
14137	91a1d09f-393d-470e-9e17-042aebdbaf2e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.064014+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.063974+01	\N
14138	5be3da82-25a5-4f20-99e3-50cef06a3467	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.078287+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.078246+01	\N
14139	d8098471-837e-420e-87c9-093f6fd3a22d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.092913+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.092872+01	\N
14140	2cdb122f-5a3a-41a0-bda8-1353fdb148c6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.107169+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.10713+01	\N
14141	9287e874-50a1-4f59-b0a6-9a52e1361d90	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.121201+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.121161+01	\N
14142	1b4951ae-3a54-4ad2-a080-50c03c70ba69	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.135223+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.135171+01	\N
14143	690da220-490b-4ae1-923c-15676bda1c0d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.149659+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.149618+01	\N
14144	5d3d6253-79f5-4e54-a579-247f303571c3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.164255+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.164215+01	\N
14145	01ff2098-111b-492f-a649-b6b560d18f9b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.178974+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.178934+01	\N
14146	954dacb6-228c-4dce-8b90-cc1248378693	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.19332+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.19328+01	\N
14147	21442a30-5bf2-4abf-84f2-d9f319746993	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.207903+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.207863+01	\N
14148	9217d185-cc7c-4572-ab60-eb666011b55b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.222131+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.222091+01	\N
14149	32cac527-1457-4877-afc1-5e2a05dc3f61	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.236184+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.23614+01	\N
14150	4223a916-daef-4d71-9537-8cf6e8d5717a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.250171+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.250129+01	\N
14151	c25e1cbe-d1a1-4792-9a54-e3bd8bfa14c3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.264423+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.264384+01	\N
14152	70922596-8d9f-4a24-bfc3-f04ce3085609	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.281311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.281271+01	\N
14153	3e07aad2-1107-4e8e-9adb-0a2f73b3b6eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.298422+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.298382+01	\N
14154	8a55e0f1-4638-4538-bb93-9a2ebb5eb6eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.312642+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.312601+01	\N
14155	b1a7fd7c-580d-4717-92bf-d480d5ddac9c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.326592+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.326551+01	\N
14156	832d0b16-d9c6-41c9-bbfc-b6c0cd65e6cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.340731+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.340689+01	\N
14157	1bf3c3b5-b2f4-4af1-a0cf-084603b29130	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.354444+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.354403+01	\N
14158	74b4fca2-5ba7-42b6-9271-cb9e4b432a84	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.368408+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.368367+01	\N
14159	70fef581-0216-4210-b73d-a2632ced5bdd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.382458+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 21:18:17.382418+01	\N
14160	cd16d847-c690-41cc-abab-0e5ef52ff831	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.396605+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.396563+01	\N
14161	c3a640e8-73e0-4f14-b4a3-119629a20790	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.41214+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.4121+01	\N
14162	d35e9ea4-f47d-40ef-82d9-92e6137ee09d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.42647+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.426428+01	\N
14163	bdfadb68-be5e-4b51-b617-5a89f0e3a59f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.440746+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.440707+01	\N
14164	e77b8b72-fa8a-4da8-9ed8-a16eb117a51f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.454732+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.454692+01	\N
14165	dd5529e0-e29e-42cc-8531-a6ccb9a4a3ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.469234+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.469193+01	\N
14166	94e24139-5c26-49e8-9aca-6c91ab88d8f7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.483323+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.483282+01	\N
14167	4501e19b-546d-4580-a1c0-034896d9a426	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.497586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.497545+01	\N
14168	01ee1667-8093-46b7-94cd-fa33c384d982	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.512516+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.512475+01	\N
14169	51c83793-4267-4f98-b08e-620612e22dc6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.526595+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.526554+01	\N
14170	f17aa69c-f063-4958-a3bf-5092f6f67376	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.540693+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.540652+01	\N
14171	5f77696a-3d0d-4998-aa41-e951fa3ca232	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.554841+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.554799+01	\N
14172	00fdeede-b6df-4d33-913c-4dde60205f5d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.568646+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.568604+01	\N
14173	1645a785-d7e1-4c94-b330-1f44319ae64b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.58268+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.582639+01	\N
14174	c5e6c058-5c54-469c-89f5-ae4057ab5705	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.597005+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.596964+01	\N
14175	bc1bd492-c366-482f-8572-c72b590d4101	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.6124+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.612359+01	\N
14176	f07ce2a8-d69d-4261-8233-2cace2c38875	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.626403+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.626362+01	\N
14177	3baef098-b788-4339-96d4-cc180da03cdb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.640883+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.640842+01	\N
14178	673153f0-e5be-49c1-9528-273d5f88bd17	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.654766+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.654724+01	\N
14179	8c2e0cc9-0c74-4010-b4e0-5d5d83ad4713	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.668811+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.668771+01	\N
14180	04213279-1d6a-44c4-b580-fe1815f95dec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.68287+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.682829+01	\N
14181	848adb4a-1166-4f8b-acba-5c574a84cd91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.697078+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.697038+01	\N
14182	affcee25-c3a9-4e10-bf77-f44d9f35201d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.710999+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.710957+01	\N
14183	2d6310a9-3df5-4b6b-9de1-2114ad1176c8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.725047+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.725007+01	\N
14184	806d642a-2c20-4303-ae2d-ee34ff34d8b9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.739525+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.739485+01	\N
14185	c8665c1d-55da-415d-be8e-c55964509653	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.756281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.756241+01	\N
14186	98fbacda-0e47-4b4f-a5ae-1da5b326b16e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.770759+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.770717+01	\N
14187	59c84f04-5937-4832-810b-996b9bfc8937	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.784969+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.784928+01	\N
14188	4de86e96-f9b4-43ae-9c3e-9c4ae3efc26a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.800207+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.800167+01	\N
14189	68b97422-ceb8-42f4-8c64-8452844bc816	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.815502+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.815462+01	\N
14190	5a1a4054-6abc-489d-8e7e-f05b7d8dcd0b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.829751+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.829711+01	\N
14191	d8f44932-1514-466f-96b6-9cb19900ad82	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.844494+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.844454+01	\N
14192	46292845-f2ba-48ba-8a57-9e651cb6e63e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.858476+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.858434+01	\N
14193	41b906f8-4bdd-4cac-b0a0-476c03a5f9fd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.872421+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.87238+01	\N
14194	9cb7f9dd-046e-4904-ada4-30216014a459	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.887128+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.887088+01	\N
14195	1ba34e49-ca0d-4dc0-a796-f1d4887aac73	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.90107+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.901029+01	\N
14196	fe378f0b-595d-4db5-afe1-e591fff03c8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.915234+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:17.915195+01	\N
14197	fcce686c-6f9d-48cc-a446-faf2544bb860	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.929299+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.929259+01	\N
14198	df1ff197-8dee-4e86-b363-23201032e308	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.943679+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.943575+01	\N
14199	53f14fac-7d66-434a-acb0-f83e15fec3af	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.957715+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.957673+01	\N
14200	c64eb1bb-e06b-460a-a507-fb9f26b6d453	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.972148+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.972108+01	\N
14201	d899a954-0168-44ca-81c1-2674d3c4550c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:17.986394+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:17.986353+01	\N
14202	238451b7-8581-4aa6-b963-044a5bf5e236	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.000485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.000444+01	\N
14203	13362233-1cec-4211-a703-92b23090d82d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.014817+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.014777+01	\N
14204	ec8b583e-f64c-4523-8cf0-8b6caf5dbf3f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.029035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.028994+01	\N
14205	e541b018-1746-4492-87c7-3c110c0a3c72	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.043058+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.043019+01	\N
14206	0de9865c-6739-4670-98f4-bde1da0a8bd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.057196+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.057155+01	\N
14207	d73dae16-c26e-46e3-bf08-a8deefa5d685	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.071035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.070994+01	\N
14208	fd7effb7-bd11-473d-87c5-82eefb553a25	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.085491+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.08545+01	\N
14209	024de8b2-2533-4c11-b7a9-b6e0551aea15	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.099262+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.09922+01	\N
14210	ab56adb0-9550-4d37-aca4-821bbd1053a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.113283+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.113243+01	\N
14211	756d6b57-468a-40cd-ae58-e63c7f8f4f44	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.127332+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.127291+01	\N
14212	5e9904e1-c5fa-47ea-ad44-9ad10ecefada	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.141674+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.141634+01	\N
14213	d8686fe4-69a0-4b9f-97d2-8e1fa4830192	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.155462+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.15542+01	\N
14214	4c8555b8-6d44-4baa-98d6-4ab80dc50d82	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.169982+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.169942+01	\N
14215	45fec2a4-4826-4d02-b00c-217bedef0c31	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.184815+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.184775+01	\N
14216	6de1759f-6eff-4c43-90e6-9c24766bd172	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.199229+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.199187+01	\N
14217	1aa97419-ca52-41b4-96ca-4e41fa283ca8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.216054+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.216014+01	\N
14218	6a50ac9e-665b-429a-a84a-4840599533b7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.230285+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.230245+01	\N
14219	bffc533c-1bd0-4bb0-a935-bb86351c7249	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.244427+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.244388+01	\N
14220	ad8e966d-1a53-4e51-84db-7abeaf65ad03	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.261669+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.261628+01	\N
14221	b63d4900-58d1-4112-abca-70db1c22c35e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.275566+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.275526+01	\N
14222	ee6f13a5-c687-440f-b2cc-54b4e3baf22e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.290222+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.290181+01	\N
14223	8c5071a9-628d-4754-9c29-010c4966caa6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.304688+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.304648+01	\N
14224	559929de-14da-4e74-8446-9d218c749cab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.318825+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.318785+01	\N
14225	6f9c38f7-93a7-486c-b5ab-c7b4a967ecde	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.333346+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.333307+01	\N
14226	e2555e6f-ae25-4179-8a7a-05c64473f66a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.3474+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.347359+01	\N
14227	8db65d05-826c-411e-b895-612016b86324	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.361316+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.361275+01	\N
14228	1f76dd2e-04b0-4aeb-bc02-329fa347564b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.37506+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.37502+01	\N
14229	c79583e0-883e-48ce-a3bb-d3a414f44a0f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.38937+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.389329+01	\N
14230	83c88239-7129-495d-9056-cc2e2735e229	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.403481+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.403441+01	\N
14231	6890a359-2b19-4c90-9d21-0855e9d3d480	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.417444+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.417403+01	\N
14232	d9e5799e-1184-4ea2-afef-10b760389d8d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.43179+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.431749+01	\N
14233	24efc054-87d6-4f18-b8c4-f442d67c4ac8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.446021+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.445981+01	\N
14234	3695a735-f9bb-4a1e-8e55-1e68ce7d87ce	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.460117+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.460076+01	\N
14235	c4ff0657-e3f4-450c-9358-ac467d87b740	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.47435+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.47431+01	\N
14236	82253940-0a72-4b29-b0d1-5e4980440024	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.488751+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.48871+01	\N
14237	6b39ced0-abbd-4b38-ba46-2351e91de4fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.50291+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.502868+01	\N
14238	00804520-a734-40cc-87b0-2059d04d7a96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.517351+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.517311+01	\N
14239	750b9cbf-e06d-46d0-accc-ff91376cc773	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.531301+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.53126+01	\N
14240	e199f67b-4760-4185-910e-15987f16cf4a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.545774+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.545734+01	\N
14241	f3cf6826-fe59-4c8c-b679-2a6c379cd13c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.559533+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.559492+01	\N
14242	01963f8a-b8c9-4848-b541-a232d2699102	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.57352+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.57348+01	\N
14243	02ee1011-41d6-47fb-bddc-5c78720ffc08	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.588416+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.588373+01	\N
14244	7d0bd04f-b166-45c2-a64a-28e69304a4fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.602863+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.602822+01	\N
14245	e433965d-9f4b-4794-a2fd-450b281ebf62	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.617105+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.617064+01	\N
14246	95a607cb-b66e-4f94-8d54-7d7b9a9386cd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.631722+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.631681+01	\N
14247	679e97b4-9c3a-4e6f-ab17-c12f91999b89	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.646294+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.646253+01	\N
14248	3d8776e5-4b6b-41a3-bf3f-cb929a004971	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.661524+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.661484+01	\N
14249	cdc5799f-c7e8-434e-b32c-4343520343a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.675733+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.675691+01	\N
14250	2a3af74f-dd30-43c2-b849-6b29492a4d2b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.691549+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.691507+01	\N
14251	e405f37b-494a-4e29-bb39-56f82117a75d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.706162+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.706123+01	\N
14252	a6ef5a6d-7815-4a7b-8371-99dbe74b4585	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.720581+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.72054+01	\N
14253	2e8a39b6-5075-4f6a-ac84-b4bfffb83ca3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.735281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.735241+01	\N
14254	53370a63-25aa-4be9-b7d4-b5d4115f9b10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.749885+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.749845+01	\N
14255	1dda7787-9cdf-4d26-9357-96955b5c9b00	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.764186+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.764145+01	\N
14256	560c1965-4dae-46ba-acec-dc478af09e5d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.778283+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.778242+01	\N
14257	3c4dc7bd-1b74-4f07-ac4c-767c96d44790	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.792567+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.792525+01	\N
14258	bfc45442-b030-494b-8845-bd33cb8353fe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.807537+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.807496+01	\N
14259	a523a1d3-e8f8-4164-b5f1-8c23e7bcd696	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.822242+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.822202+01	\N
14260	d3f003be-8085-40c3-99d1-f545c8d50768	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.836684+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.836643+01	\N
14261	4cef36f8-f6bd-4705-b1b7-7b71b2ece832	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.850853+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.850813+01	\N
14262	26041cfc-ca26-47d0-a489-79de935f3b5b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.864683+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.864644+01	\N
14263	42d2a468-86ab-4d2d-9b5b-0481347c098a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.878699+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.878658+01	\N
14264	6fc7b24b-204b-44af-8c1c-55584a5be4d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.892669+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.892627+01	\N
14265	f9c705e1-bf44-4017-862f-1d8630f2d71a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.906665+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.906626+01	\N
14266	d6e76ecf-da3c-4efe-aa34-3dd7281ce31a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.920997+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:18.920957+01	\N
14267	729e6f84-e42c-4a99-8ba2-a71de2befaaa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.934938+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.934897+01	\N
14268	73b94306-75e1-4f8c-b2d3-5878ae0bb8bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.949442+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.949401+01	\N
14269	acc6fbbc-68df-4df7-ae13-ad9f30bac72d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.963353+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.963313+01	\N
14270	329c808d-2d2c-41d4-a1be-f88e3841c147	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.977692+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.977651+01	\N
14271	e4ef7372-8908-49ea-a5d8-33288ae09bff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:18.992186+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:18.992144+01	\N
14272	8dbcd468-0238-4694-adfa-7e5b12e2c310	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.006292+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.006251+01	\N
14273	230db051-9547-4149-8b83-4f75e3bedea3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.020983+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.020943+01	\N
14274	9c3e0953-8ad9-40ce-8e09-b08f87900271	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.035549+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.035509+01	\N
14275	444f33b2-b286-4a38-a968-cd1bd4588365	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.05007+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.050029+01	\N
14276	7e9a33a9-0c91-481e-b114-6456b89f997e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.064294+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.064254+01	\N
14277	355914d0-77eb-4e3a-b96b-190f81fc689e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.079097+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.079056+01	\N
14278	0223fad5-b62b-4f07-a694-38b9b1ad576e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.093406+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.093365+01	\N
14279	fa74840e-3534-4f38-8a52-92320bac57cf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.108006+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.107967+01	\N
14280	91099898-9c26-4c4a-b9cf-acebd23e0b17	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.122279+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.122241+01	\N
14281	ed120d74-6d33-48e5-8958-a71ab782d01e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.136884+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.136843+01	\N
14282	3d459037-5b2a-4373-ac50-4f2d8bbfe1fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.151829+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.151787+01	\N
14283	b3d3ed0c-4065-42dd-afa0-de0e777bbf3b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.166224+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.166183+01	\N
14284	43f6cb92-5165-4774-8452-cf0878d76fb2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.180679+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.18064+01	\N
14285	1c2dbd12-1d9a-4874-aa0f-b1879b208044	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.195134+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.195094+01	\N
14286	79bb44aa-533e-4677-a69c-f6f1b11e8c75	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.20979+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.209749+01	\N
14287	9db56606-683a-48fc-bdf8-0ba4b793f35c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.224396+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.224356+01	\N
14288	d585aa07-be13-41f6-9af9-25f3af051a3c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.240592+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.240546+01	\N
14289	be3ca72d-194a-4d5c-8b83-b95b15c2024d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.257663+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.257622+01	\N
14290	1a7bd4d2-f3e7-413f-8e9c-1c1840879029	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.272228+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.272188+01	\N
14291	fd52220d-28c2-46ab-a412-619f470f86a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.286694+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.286653+01	\N
14292	c483340b-61ae-4c18-b07b-fa0de1063648	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.301022+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.300981+01	\N
14293	06c3c569-5048-477b-9eae-6e8862271de6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.317796+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.317756+01	\N
14294	67b494d7-6741-495c-897a-da31fab9f63d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.335247+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.335204+01	\N
14295	9f12b857-6c15-45a2-8577-8f9ca26a5846	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.349417+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.349377+01	\N
14296	cd41ca83-7aec-480a-8888-9514170a5312	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.363338+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.363298+01	\N
14297	a2576504-a0f5-41cc-a547-3b50242da36d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.37725+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.37721+01	\N
14298	75a9470f-d1a5-46c8-9744-5dfb4c2aad45	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.391561+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.391521+01	\N
14299	5ca7778c-540d-4759-99a5-d245a0da5e40	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.405499+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.405457+01	\N
14300	0270090b-93ef-48c8-a66f-440d69c93b75	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.420988+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 21:18:19.420948+01	\N
14301	7909f023-cd80-42bf-a68d-070b1ae5c936	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.435297+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.435256+01	\N
14302	2ff10905-3b7c-43d2-af87-8c36433999c3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.449614+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.449573+01	\N
14303	8d1807df-8f00-4854-bcc6-c5a6decb2753	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.463868+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.463826+01	\N
14304	593bfe6b-7034-4bab-8edb-bdee7aebe27c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.47773+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.477689+01	\N
14305	2de55859-1cad-4e21-8419-2791e353eca5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.492076+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.492036+01	\N
14306	90451abd-932a-4426-8510-b51116bf5a84	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.506328+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.506288+01	\N
14307	bfeadb60-d312-4a28-90ec-ae4decc6eddd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.520341+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.520301+01	\N
14308	53bcc802-201b-40be-899e-fd4a827883a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.534348+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.534309+01	\N
14309	ff81d4f1-8734-400d-9088-dd6fb55a68c2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.548452+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.548412+01	\N
14310	1635d5d5-2ad3-4a9b-b92c-ea79c389c366	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.562524+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.562485+01	\N
14311	48c71f4c-a21c-446d-b6e9-ef798ef6b4fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.576493+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.576454+01	\N
14312	d15e8b20-11e2-4429-ac0d-ea1f1437af3d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.590485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.590444+01	\N
14313	f4fdc24f-595e-478b-b515-45062d7e478d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.608273+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.608232+01	\N
14314	8b01382c-6fcc-408a-a3b3-fe707edd8ec2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.622534+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.622493+01	\N
14315	37b29164-b853-4bbe-8d4d-b533fdfabc37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.636693+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.636653+01	\N
14316	c02ab4c1-15c0-4874-b991-6847fcdb4c56	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.650909+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.650869+01	\N
14317	d72dfdc4-318a-4be6-afc0-c2b686b63898	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.664756+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.664716+01	\N
14318	2d42ec7e-3f0f-45db-a032-36cab04603d6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.678686+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.678646+01	\N
14319	86db68e8-0cd4-4d2f-8514-5868abf66d7b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.692721+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.69268+01	\N
14320	55bbb6ec-7774-4582-928e-49e5a75ea61f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.706749+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.706709+01	\N
14321	316ba30d-28d6-4b73-a179-b79c29910047	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.720755+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.720716+01	\N
14322	67899076-bfff-445b-b79e-dd8123f604be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.73486+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.734821+01	\N
14323	db53e982-b3ed-405b-98a5-8297861444dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.749478+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.749437+01	\N
14324	144b38ce-9738-4eb1-9d70-ddfa7f6bfd90	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.763217+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.763177+01	\N
14325	0e823428-962d-4785-a9b5-56ec1e0b2461	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.777086+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.777045+01	\N
14326	628daecb-d094-4d78-93e4-2cd6739095ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.79137+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.791329+01	\N
14327	3883198d-5ddf-4e6b-bb78-b990f0597da6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.805999+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.805957+01	\N
14328	dfa93261-3dbf-417b-913d-615d551af61c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.821195+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.82115+01	\N
14329	7c74f0fd-3c96-484c-b3ad-f9d36ad661ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.839233+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.839192+01	\N
14330	b29bed7d-a8be-46e0-b4e2-bf277b57c20e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.854615+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 21:18:19.854575+01	\N
14331	7bb627ca-b604-4efa-b8cb-66d1825c22cb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.868796+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.868755+01	\N
14332	312d7386-2917-4790-b4dd-9a8fd112799d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.88309+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.883049+01	\N
14333	d1eef242-0a5f-4c50-b761-004827103baf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.897336+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.897294+01	\N
14334	a71edeb2-5fac-4dd6-adc9-55b353f75942	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.911755+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.911714+01	\N
14335	ed28238a-4655-4b2c-aa67-2d3714afbe32	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.925651+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.92561+01	\N
14336	617ebc3d-f9c0-4a97-9b8f-7050a74e07e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.939533+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.939493+01	\N
14337	ca2494e1-eb07-4b69-84ab-33d3103ee16e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.953828+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.953787+01	\N
14338	50399390-5be4-4c92-9c1d-3a4c148e1e1a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.968423+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:19.968383+01	\N
14339	2a3def10-8ff6-4ebe-9aec-c5250978e839	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.982284+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.982244+01	\N
14340	7dc27d7a-e534-4de7-8caa-ecc1e32abcb2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:19.996316+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:19.996275+01	\N
14341	2a1fb9e7-5a56-416e-bc31-5024e2e365c9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.01069+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.010649+01	\N
14342	23199355-eec9-4a1f-a98d-8956fa3958df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.028198+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.028157+01	\N
14343	17a339e4-5566-4e27-b24e-6e878ec9d1a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.042175+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.042014+01	\N
14344	b1bbddbc-9500-48eb-a140-81526bc011e9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.056638+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.056598+01	\N
14345	f20717a5-98ab-47b2-8dc3-511d9bf3de38	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.070493+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.070454+01	\N
14346	c5ab57b5-95e8-4295-8e16-019fa45d3360	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.084929+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.084887+01	\N
14347	ff03e7a0-e3f2-430f-987f-d14879d4b1df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.099155+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.099114+01	\N
14348	43541109-41bb-4864-bf61-e77546a794ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.113368+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.113326+01	\N
14349	9cc1cb5e-d4ae-49d8-bbd2-2f4094d026f1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.127175+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.127132+01	\N
14350	92dfbeab-1439-48ae-8ee1-984c56f505cb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.141236+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.141195+01	\N
14351	09bdf29a-1156-4ac9-a376-68016d89f099	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.155133+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.155093+01	\N
14352	9f4f043e-6040-4336-ad30-242a67966801	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.169171+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.169131+01	\N
14353	76602910-b71a-4b43-9883-bc41d6ca83ac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.182918+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.182878+01	\N
14354	87f715c8-e4c7-4059-a799-b011c16e6cab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.197577+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.197537+01	\N
14355	41f97647-fe8b-4bba-a1b3-53651d02fdb4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.211687+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.211645+01	\N
14356	61bce80a-c8c6-42ad-8c75-e46f307f0dcb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.225568+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.225527+01	\N
14357	0db68f29-9f10-4e5e-9c02-50cdfa81be1c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.239915+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.239874+01	\N
14358	4d8f50cf-b8d4-4d7b-afff-494863828f0e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.254097+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.254056+01	\N
14359	954afe73-e560-4aa8-b1f3-3cb14587ae3f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.26814+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.268099+01	\N
14360	f59c9ea7-b87f-4b3d-b6be-8b58cd562de8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.282017+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.281977+01	\N
14361	cbb58da8-ae34-40ba-b1e3-500001b36fff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.296168+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.296127+01	\N
14362	e2a47b73-9e12-4bb3-bccd-62a1f17b4db1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.310416+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.310375+01	\N
14363	16fd4729-52eb-4884-b7ba-9e4a2a5a3e48	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.324774+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.324734+01	\N
14364	c86fcff5-4d1e-4b78-9527-2e72f386cc96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.339307+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.339268+01	\N
14365	247c7c55-ea5c-4539-bffa-35fdda5854e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.353821+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.35378+01	\N
14366	f1b95585-a116-48b3-98cc-b7d51ec3f455	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.367938+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.367897+01	\N
14367	a68b3ad3-7938-4aae-83b3-b42cc850ead5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.381818+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.381776+01	\N
14368	f3b81bcc-53f2-4537-addd-eccb33c8c65f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.396536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.396496+01	\N
14369	8eb260a2-2495-4837-b266-e301ce6cbced	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.410805+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.410763+01	\N
14370	ce632fac-3f36-4aa0-994d-cc8e15c46786	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.425118+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.425076+01	\N
14371	25361711-b2cd-4b19-bbd0-5fadad828da7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.440075+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.440034+01	\N
14372	11433af4-c5e9-438c-8e05-de02ffd4503b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.454233+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.454192+01	\N
14373	5e427a6e-d3b1-451a-a227-9e5a909109aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.468378+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.468338+01	\N
14374	aba09a36-3ae5-48b9-b8ef-82c6aaaceb05	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.482449+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.482409+01	\N
14375	b6d24544-a091-45aa-9644-332dba726736	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.496564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.496525+01	\N
14376	702e309c-5a89-46e6-b586-5e561000d5c7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.510774+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.510733+01	\N
14377	cd0d165e-9ef9-43a8-8bb9-06c58c203de2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.524648+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.524607+01	\N
14378	bd54f421-d88b-49a8-b71c-5884913c1b03	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.538591+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.53855+01	\N
14379	ec31f610-d3d6-4d5b-964a-dcc09ecda647	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.55323+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.553189+01	\N
14380	279b0712-38c5-4761-bb10-a1ae20081592	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.566988+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.566947+01	\N
14381	78e774f9-c949-443f-959b-084246025ba1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.58132+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.58128+01	\N
14382	a399fd50-b41e-490a-b6c6-0d86c618347a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.59513+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.59509+01	\N
14383	bf9d29fc-453c-4e4b-aa86-7a77a8c99034	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.609447+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.609406+01	\N
14384	0ab6cee2-1e35-4a98-b19c-31f20a553e37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.623672+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.623572+01	\N
14385	6bcd7ece-764c-4d25-bad3-e34cdb0e603c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.637962+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.637919+01	\N
14386	0519441e-6019-473b-8380-3cceb3b3ec53	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.653954+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.653912+01	\N
14387	8acca5d1-d79a-4e90-ae1f-6b61ee84d97a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.668377+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.668337+01	\N
14388	dfd7128c-0557-428a-9680-445437f878be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.68235+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.682309+01	\N
14389	542260f3-d52e-4dda-9f26-4ae218af575f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.696297+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.696256+01	\N
14390	763b2089-ccb5-429f-8ddd-f184743c4b5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.710346+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.710305+01	\N
14391	6663c0d3-2079-47bb-af4a-362d99892e77	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.72602+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.725979+01	\N
14392	d2309ecc-03f6-4b42-a482-ebb8a8276099	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.740324+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.740283+01	\N
14393	1948ad2e-dd56-4e0f-b2f9-2f0e803bfc62	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.754905+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.754864+01	\N
14394	c0b102cf-1fc0-4b80-bdd7-8416deb9fa52	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.769291+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 21:18:20.769251+01	\N
14395	82856329-5a9c-4ece-a6bd-417a7bd6637c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.783533+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.783492+01	\N
14396	eac4a4e1-5170-48ab-acca-8e92d929810d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.797806+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.797765+01	\N
14397	c74d2ba0-851b-4b9f-a2a1-fc4c053fd24f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 21:18:20.811807+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 21:18:20.811766+01	\N
14398	dede3528-7667-4543-b14b-8df46e1acbd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.052623+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.052578+01	\N
14399	3fa9e0c4-488b-44d5-a294-8c3191e46cdd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.086281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.086237+01	\N
14400	ae9be29e-11e9-4897-aa54-fb4c73e151ce	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.108546+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.108493+01	\N
14401	d5ea43a6-be94-4602-b557-de06d7c51bb6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.127575+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.127523+01	\N
14402	1e1a4457-8811-45bb-8c6d-c8aa8b4f8c3f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.152044+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.151975+01	\N
14403	d6e1a39b-6183-4334-b25d-4e6a167365fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.182561+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.182498+01	\N
14404	ebcffddc-b30f-4fef-893d-f16bb84c334f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.205824+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.205763+01	\N
14405	3249ced8-eb00-4a06-9799-b41761c69f23	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.23223+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.232165+01	\N
14406	962b6ec4-a3c4-4474-96c9-5dcc84addb11	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.253165+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.253089+01	\N
14407	d5e1a478-85a5-4308-8a35-552664f2bee0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.280104+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.280058+01	\N
14408	0f668e83-b76b-4be4-9b8c-1a8ac43ab726	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.303759+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.303683+01	\N
14409	265b8c59-59a3-42e6-bb2e-48eaf96f0168	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.327184+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.327129+01	\N
14410	76147a5f-6159-4a04-bae8-fc6661fac958	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.353523+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.353476+01	\N
14411	3e278ca8-ba89-4198-8007-cde9eb0254e3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.378395+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.378294+01	\N
14412	658366d2-ff3f-4996-a42a-18b519382a4a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.422128+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.421998+01	\N
14413	827b57bc-1d51-472e-a4fd-62f898b68be0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.447375+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.447317+01	\N
14414	d20dc975-7ce3-4574-83a7-27112de84040	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.465862+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.465813+01	\N
14415	0b160d3a-8c36-4ca1-8ef1-ed90553ec237	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.483405+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.483353+01	\N
14416	040887b7-ec47-4d64-afb7-4d2b8daf8c43	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.500633+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.500586+01	\N
14417	f1ab4bc5-b829-4e41-aea7-efa9ffc864b0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.516764+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.516717+01	\N
14418	157e249b-6eb7-48ca-8899-4620d2341d8c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.534766+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.534719+01	\N
14419	8624f40e-48e9-4548-9a45-861315fd29f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.553081+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.553038+01	\N
14420	fd3c9c15-e9e8-4aec-8663-d6512f373cd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.573958+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.573911+01	\N
14421	81c45d71-05df-4b1e-83bb-20cadb0283aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.595128+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.595079+01	\N
14422	470ff71a-7e97-4b54-820f-2bc0935e09dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.617576+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.617528+01	\N
14423	d066a5ce-3911-45d2-802f-5c91690a91c8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.63578+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.635739+01	\N
14424	54ab060e-6c4c-4274-b02f-1c4bed67342e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.652841+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.6528+01	\N
14425	010560cf-9ae0-45ca-92a4-8f34eeda893b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.674856+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.674809+01	\N
14426	809e036c-3047-4215-aa80-57307d1aaf34	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.691275+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.691236+01	\N
14427	db8acc80-a411-45ef-a8e7-3766d9e02749	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.708466+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.708425+01	\N
14428	1d8d33fb-0a93-46e1-8d22-95b9e4fb6831	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.72879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.728747+01	\N
14429	51ee663a-fc1f-49c9-b5ed-ea5963263202	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.746439+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.746394+01	\N
14430	fc670e3c-265d-48e1-9ddd-d023c89ae22c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.763791+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.763744+01	\N
14431	12dd6a1f-a66e-4937-b9a6-67df446c4b35	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.780302+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.780255+01	\N
14432	c0333841-99ee-45c4-a90c-d6ac27582019	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.796889+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.796847+01	\N
14433	68e48155-72ef-4e31-a61a-43b6af45d2fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.811659+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.811616+01	\N
14434	00dcef25-8300-4476-919a-06de212911e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.828327+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.828275+01	\N
14435	5762fdb3-303b-425a-9025-80aacf8e047a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.848048+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.847995+01	\N
14436	2e3ec4b4-4932-43ab-863e-5ebdc1971e46	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.866194+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.866147+01	\N
14437	db408497-53a8-45aa-94fc-ffe4ce3368a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.884262+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.884216+01	\N
14438	20f9ebee-a9d2-4d64-a1e4-0270ffb36d85	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.900865+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.900819+01	\N
14439	c1c962eb-4be4-4761-98b9-d8ff78fbadc6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.917991+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.917945+01	\N
14440	dc4e7dde-1a69-4070-8b49-98a02f64ad76	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.934625+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.934579+01	\N
14441	70255826-0abe-4a8e-ab07-1cead5ebf7ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.955471+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.955425+01	\N
14442	bf2cc276-33f1-4167-86b4-f7a362185294	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.973544+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:56.973495+01	\N
14443	e8d51ae0-38c0-4222-a1df-47521b8dbc62	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:56.994232+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:56.994188+01	\N
14444	e8740719-748a-4d8e-aba6-adad2c70dc78	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.022157+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.022113+01	\N
14445	5baf6eb4-ee80-4bdc-b661-c7b81a05746f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.056875+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.056828+01	\N
14446	b381f361-da23-4021-bbc2-68bd2f13c8ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.080121+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.08008+01	\N
14447	89bbdd3b-d22d-4c1f-a6fa-99123258aafd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.101735+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.101696+01	\N
14448	6eec1c05-9a6e-47cc-85d5-25fe98148585	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.118057+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.118016+01	\N
14449	7ee2ecaa-9348-4ad9-9d62-bcf9f5d697e2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.138978+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.138937+01	\N
14450	94558edd-1643-46c7-8f93-93ef4c271698	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.16773+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.167691+01	\N
14451	0faf6fa0-45ed-4e94-9632-b270c27303af	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.197438+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.197397+01	\N
14452	b16df195-c47a-4947-9445-b8e029d7c5fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.230743+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.230697+01	\N
14453	b8a99c89-09ff-4784-b0c0-42b6c364cf90	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.254853+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.254805+01	\N
14454	517b7371-3511-4f0b-8931-baf9c74a52c0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.278182+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.278142+01	\N
14455	a6c73462-d58e-456f-a29f-20668745a971	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.310055+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.309991+01	\N
14456	1fb04ef3-780f-4206-826d-16c023a44923	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.337231+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.337154+01	\N
14457	8bd22dfc-6ef0-4352-bc4a-b8dce8a67c4a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.369122+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.369061+01	\N
14458	2e9dc541-11b8-47bd-9cdb-80d36da3b601	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.401139+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.401075+01	\N
14459	79412986-ab88-4848-97b8-f48ed81827a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.429293+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.429226+01	\N
14460	990a2c42-40df-4a24-8a68-2b51387376f9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.451964+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.451902+01	\N
14461	fd045c64-aa5f-4144-a400-074b9453b446	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.472349+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.472292+01	\N
14462	05d75a18-84fe-4a83-8c33-857037e33108	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.492549+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.492492+01	\N
14463	423186fe-683c-4962-bd66-8a9c2c77d733	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.513672+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.513619+01	\N
14464	2944b849-048f-4a64-90a3-a7a0b728f28f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.53632+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.536266+01	\N
14465	d2ec3197-48d1-47d7-9408-8992467e4843	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.55643+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.556373+01	\N
14466	c74761d4-4499-4ed6-a245-8cf2e47e0e59	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.575569+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.575516+01	\N
14467	4a8bf24c-376e-4a3b-b21b-052e227eb592	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.594925+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.594872+01	\N
14468	bef0cf51-9961-4733-91c1-feb453f0e581	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.614603+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.614551+01	\N
14469	2f309937-846a-450c-a5f0-73c7a83e3e3e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.638852+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.638798+01	\N
14470	ca1d297a-8f78-4884-94c0-214a0b4e96b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.660281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.660228+01	\N
14471	027f3c5d-6480-46aa-8c88-8a1f9e3961f6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.678952+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:06:57.678907+01	\N
14472	71883f47-e9f5-437b-9ab5-eefe051a67b3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.696577+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.696533+01	\N
14473	4d5f0770-38e2-49e4-9a7f-7c03b5327dcb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.714006+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.713957+01	\N
14474	d15e406a-3d35-40da-bf70-22577bcc331f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.73128+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.731237+01	\N
14475	5914919a-7867-422b-ace5-8540f06978c1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.748937+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.748889+01	\N
14476	9b759257-6e07-4f9a-980f-babeb3ed6f2b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.766671+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.766625+01	\N
14477	32b5eded-d733-4a60-b8c8-08f9f56c7284	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.784264+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.784219+01	\N
14478	c95e74d4-363c-481c-b17d-a91ad1dabaff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.809275+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.80922+01	\N
14479	6448e8ff-6456-4f5f-9ef2-f9b941fa1a91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.834701+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.834656+01	\N
14480	08e6cf66-9813-443f-a15a-4f5cab26fd28	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.852012+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.851967+01	\N
14481	4d45cfde-8e63-454f-b1e5-fefe53987fe8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.869279+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.869233+01	\N
14482	ba1a2749-4f84-4d79-939a-0845e86abb30	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.887976+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.887931+01	\N
14483	ea8d4760-da5a-485b-b613-c68bb9d535c0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.906375+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.906327+01	\N
14484	e2970990-4da8-4df7-ba03-6cee40f5c5db	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.951425+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.951382+01	\N
14485	7631a0bb-40e4-4d5b-86a4-c4549fdb62e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.971765+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:57.971722+01	\N
14486	3adaff40-c012-4e69-8165-fe816669016d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:57.98755+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:57.98751+01	\N
14487	71ce1ce7-fde5-400c-ac62-6ef9ba197b47	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.005789+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.005748+01	\N
14488	805ab6dc-41dc-4c25-ba40-658445da2b96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.025804+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.025764+01	\N
14489	e429853e-627a-439e-988a-5a626183d62e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.050908+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.050867+01	\N
14490	29a3c1e7-9b50-4099-8c88-c1819e0ee237	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.077178+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.077136+01	\N
14491	781dd134-2446-4eea-85e9-a2cbd51bedcf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.104311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.104271+01	\N
14492	572e027b-5c09-48cd-bb96-919fc43c19a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.129162+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.129122+01	\N
14493	1cd48852-447d-497d-86e6-11b67a857758	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.153124+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.153084+01	\N
14494	2241674d-835a-4933-aeb8-e8dbfe448712	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.180212+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.180153+01	\N
14495	fd5cf275-e697-49f4-b3bc-400952e1e903	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.20397+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.203921+01	\N
14496	c711b8e1-10b0-4edb-8aaf-676930e592a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.220159+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.220115+01	\N
14497	4df8db6a-3367-4652-801c-44249f11252e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.236891+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.236847+01	\N
14498	8fbb1cc0-c92c-40ae-a770-8a1f8f55e78a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.253754+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.25371+01	\N
14499	b685c192-4618-4416-b624-0e044569afac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.270903+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:06:58.270859+01	\N
14500	aa15f068-d5c3-484a-8be5-52d9f54e10f9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.288133+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.28809+01	\N
14501	e86d2a27-b289-42d5-bbf7-f6d398964df1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.304765+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.304721+01	\N
14502	1d3459b9-5a0f-4aec-9ba4-225c4cac19df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.321644+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.3216+01	\N
14503	b0001c6a-3160-4ee8-8f26-a6fad0d835f8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.338536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.338491+01	\N
14504	8b2ac4e7-01df-495b-aa64-0c29ba265b55	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.356565+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.35652+01	\N
14505	3f71c5df-386c-41a8-9553-dd61191803c3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.373273+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.37323+01	\N
14506	7f58f796-6f51-4375-bd15-ba076758647d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.390155+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.390111+01	\N
14507	cd19443a-914d-4783-97ff-8a01102f2765	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.410533+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.410489+01	\N
14508	c3705a14-6b8d-4551-94b8-539d0c11fb8d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.428211+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.428164+01	\N
14509	021c6388-7929-4b9a-aa2a-7c9e4fc0be73	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.445253+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.44521+01	\N
14510	f592dffa-9dd3-49f0-a116-68a16a86c619	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.462684+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.462638+01	\N
14511	f6fde567-e472-41f3-987a-fcc9ef2d8672	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.480035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.479991+01	\N
14512	15591f59-6475-4407-acae-29ba077b0f93	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.497931+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.497884+01	\N
14513	b4480395-5bae-4ab2-9163-990544218bf3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.515274+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.515227+01	\N
14514	4b378b54-7987-4eec-ba65-5cd3f26f3700	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.532896+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.532849+01	\N
14515	3ea31eb6-4f59-43e5-934e-d590652a3094	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.549469+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.549425+01	\N
14516	f413511c-978d-4d16-b63c-1d07d81b350c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.566452+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.566408+01	\N
14517	8455483e-3b1f-452c-b654-48b11a93b204	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.584146+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.5841+01	\N
14518	32fd54df-00b7-43ff-ba21-6cb340441179	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.617664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.617586+01	\N
14519	d7d1af95-1b20-43a3-83a6-547aa0089665	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.643115+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.64304+01	\N
14520	0c66f178-b87c-48eb-9024-23a088ac9b48	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.667783+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.667737+01	\N
14521	888c73a2-c0a2-4306-9d1f-62ca167b9036	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.691789+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.691742+01	\N
14522	d74c03df-9061-460f-8164-838646d551c4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.709855+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.709808+01	\N
14523	53cf6889-b94e-4583-977c-5455f0749707	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.725093+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.72505+01	\N
14524	6194c212-0ff5-4732-a9be-5d168eb9d182	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.741839+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.741794+01	\N
14525	86f3066c-4b6d-4093-8ad6-75517111c74e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.760485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.76044+01	\N
14526	36be4ce5-78fc-46d9-9db4-0e18c2d269a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.776955+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.776909+01	\N
14527	fc60de67-0075-4667-9245-efc58a6414dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.793953+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.793908+01	\N
14528	423dca12-519b-4d2e-9dca-381e6138012a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.811244+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.811199+01	\N
14529	fb6b1192-592f-4ce4-8e22-f71c823b8cfb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.828525+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.828482+01	\N
14530	d9e59785-f29c-410d-9dff-96c802cba3da	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.846113+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.846068+01	\N
14531	87debd04-6144-4bf0-bd24-ac8ef45d89ff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.864026+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.863976+01	\N
14532	460ca45a-8028-4594-87a6-499a198d8e67	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.881798+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.881751+01	\N
14533	30c1cad4-33a0-4b56-811b-dba60539ddd4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.898329+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.898288+01	\N
14534	4928bd88-eceb-4bfc-8194-4295052f2d18	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.91528+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.915236+01	\N
14535	3a4b651d-072b-4863-a9bc-576b94eb2776	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.932623+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.93258+01	\N
14536	bc87b449-8ed4-4515-b8a4-5797d88bf3a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.948639+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:58.948595+01	\N
14537	099b4b72-8789-4561-8972-5a454755cf68	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.965191+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.965147+01	\N
14538	a461ace0-8393-44d3-9a13-d63d2c06b3a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:58.981372+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:58.981331+01	\N
14539	2ca0dc72-8c1e-4f76-9865-399335849e36	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.001419+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.001372+01	\N
14540	23c7cc6b-9bc7-47e1-a3ec-52c3aedfa524	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.018982+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.018935+01	\N
14541	17eaccd8-497c-43a1-a0b2-1a9baefd8e00	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.038566+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.03852+01	\N
14542	55d9548e-fdde-4ec7-81c2-4a4b3b02121f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.056758+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.056712+01	\N
14543	634c8945-53d8-45a5-b4d1-f991ead26dcd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.073634+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.073591+01	\N
14544	184f88ce-d848-4e0b-b008-0b07e3c82498	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.09061+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.090565+01	\N
14545	5b003082-bc67-4a64-858a-b6d0e54506cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.108056+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.108011+01	\N
14546	b174a80d-4057-4e45-b781-5d129ce3867a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.124887+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.124843+01	\N
14547	ce250018-1784-4b90-a751-6e9356f78358	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.141002+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.140955+01	\N
14548	8762b3c4-082c-4911-ad69-f5cdf2463f25	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.157425+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.157379+01	\N
14549	643aea2a-8c20-446c-b97e-7900dd3f9d41	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.173631+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.173587+01	\N
14550	7c5320cf-ee4e-4c85-b5d6-d86aa9a03cb1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.191102+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.191057+01	\N
14551	6edd0287-fd8c-4e71-b32e-b533058732b9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.212476+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.212431+01	\N
14552	491b13e0-b85b-48ed-b1f2-2bac65062235	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.229304+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.229259+01	\N
14553	b7214e7d-701d-4749-a5d1-1a81cfd7b64a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.245669+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.245627+01	\N
14554	b2b1aa67-8bd3-4dca-ba2e-f6d1fcf46105	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.261895+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.261853+01	\N
14555	9f349a02-4150-4db2-a386-ea88e252fc91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.277862+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.277821+01	\N
14556	b30af6dd-7539-4d41-a2ce-0733efb70575	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.294999+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.294953+01	\N
14557	bb5a83ac-273f-4f3a-906c-00002635d6bc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.313412+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.313367+01	\N
14558	243ac8ea-8ae0-4a64-9d84-697c8187d55f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.330853+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.330806+01	\N
14559	bd455598-d970-4e61-9da9-db9af702026d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.348588+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.34854+01	\N
14560	b92ae3b2-5b8b-4008-b862-2ff39de3f906	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.365956+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.36591+01	\N
14561	831c447d-ed96-4858-b95a-d2f1d29bc27c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.38392+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.383875+01	\N
14562	36942b33-d1b7-48f6-a219-3dffe6956dc1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.40139+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.401345+01	\N
14563	65777643-c6da-4b16-8e35-2d904a1df7f9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.418471+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.418421+01	\N
14564	7524ccb9-98ec-462e-bb81-9f6356eac586	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.435777+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.435735+01	\N
14565	d8ecff41-0b48-462e-ae65-6152efa6174c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.452298+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.452251+01	\N
14566	d4a06fd6-68a6-4f05-b049-cb9c578a823a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.469397+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.469349+01	\N
14567	15b075e6-44a3-48aa-ac86-50641318cee7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.487148+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.487104+01	\N
14568	1b306e51-2f01-4301-a216-632a372ba32f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.504088+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.504044+01	\N
14569	8c15548d-0b32-405d-ba7b-83e904ef1139	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.521499+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.521458+01	\N
14570	e197903d-2cea-4a52-b84e-b3249aed66fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.539035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.53899+01	\N
14571	5df7f627-8925-44eb-a26e-0f4a3a5e59a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.556472+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.556427+01	\N
14572	35fbe934-8bbe-4cb7-9fa6-2a5ad492e420	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.573088+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.573039+01	\N
14573	06b373c4-497e-46d2-94c2-391711e35521	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.591672+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.591617+01	\N
14574	1eb4acaf-a445-4dd7-b643-e3e8a2d73188	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.612578+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.612533+01	\N
14575	035e503d-bdcb-4156-9b5a-c184c0372d1f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.630621+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.630576+01	\N
14576	9f517f23-4373-402f-9bd8-9e3fe2dffd22	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.64842+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.648375+01	\N
14577	5d96d5f1-ef80-4ee2-8d63-af1e63df0df2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.668001+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.667957+01	\N
14578	ce529773-0d71-4e4b-963e-f9ba66fef2a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.685755+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.685708+01	\N
14579	c49bbc59-31db-4dca-9eb8-3e35a9c2f20f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.703426+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.703376+01	\N
14580	d5c7ec08-1363-41eb-b09a-49cba1e31c62	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.722336+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.722285+01	\N
14581	06b8bf13-295b-40ff-817a-50ec641b0dad	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.740587+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.74054+01	\N
14582	460f50fc-d799-49b9-b1d3-bd12fef7f983	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.7599+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.759851+01	\N
14583	7a503fa7-1536-4c43-97d6-963ed399e907	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.780029+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.779977+01	\N
14584	411676ea-e937-49a3-8820-992112b3f1b3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.805484+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.805436+01	\N
14585	77ba3be3-6165-4d98-bbfb-18e449e9bf40	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.827228+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.827182+01	\N
14586	6b642c85-2260-462c-abac-730e14368382	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.845647+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.845591+01	\N
14587	48c8e8d5-f663-463e-9782-bf99dc99ff03	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.892151+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.892109+01	\N
14588	c2cf0cbb-99ca-474c-883c-39d7cff3d13d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.912204+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.912159+01	\N
14589	2f3cc23f-2513-4772-8e8d-1010ca754747	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.929644+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.929598+01	\N
14590	28530919-22cc-4c08-862f-9b90b48f7e04	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.946762+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.946718+01	\N
14591	bee5ae21-1d12-4b23-af5f-361d4784155c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.964586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:06:59.964534+01	\N
14592	ffe88d72-896e-4b8b-9c80-fcd241df4cdf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:06:59.982257+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:06:59.982209+01	\N
14593	09b966d4-d835-45ca-842b-f34f3b8aaa83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.000661+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.000612+01	\N
14594	e1f66007-6d82-4141-a1a0-76a302d7ed15	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.019219+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.019173+01	\N
14595	869ea280-c899-41e7-83b8-b03ddac15a4f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.039217+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.039171+01	\N
14596	b0e86e67-1f0e-472c-8605-b2c64ebbb92f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.060192+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.060132+01	\N
14597	1e295961-793a-45aa-a756-1cb36e620921	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.078687+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.078638+01	\N
14598	22b7e354-75c5-4389-8fbd-4587ef970487	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.098971+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.098926+01	\N
14599	34deafe4-844c-4257-98c6-484f87dd55fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.120155+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:00.120092+01	\N
14600	5ee8e2b6-1b66-4ac9-b5b2-2f807c716595	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.144184+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.144136+01	\N
14601	a6a7c441-e34b-4c35-8ab2-06569b58c4c4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.161659+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.161614+01	\N
14602	7e593585-f62b-4502-bed1-8705816f3556	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.180541+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.180485+01	\N
14603	5c283dcc-f7c6-4981-8f5f-87573533dec1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.203479+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.203421+01	\N
14604	23308287-3eaa-48ca-9767-3a7924137ab2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.229579+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.229533+01	\N
14605	8e27af0d-2852-4552-92fc-b2a34fe1a8a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.273639+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.273595+01	\N
14606	32d62eb5-e0bc-4ba0-a297-4c4852df31a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.311812+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:00.311741+01	\N
14607	366b2112-c04d-4e9d-a1ed-e385aa96c20b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.361811+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.361761+01	\N
14608	330af9aa-6ad5-4a7a-94fe-a85497b071ef	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.379856+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.379808+01	\N
14609	6687bed2-d850-4889-a65c-25bd5a1e6b25	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.398517+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.398469+01	\N
14610	4ae05386-33c6-42b6-9c3f-a6a16590eef8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.41667+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.416625+01	\N
14611	7852a4eb-5d7a-4181-b22d-fd7746e64a5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.435241+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.435198+01	\N
14612	2c21bfc0-e762-4db2-b759-bcf1001bd213	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.454556+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.454509+01	\N
14613	ae60e2c7-17cf-44bd-a344-7bd5183cd26e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.473954+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:00.473902+01	\N
14614	6cced392-05f8-4e09-bf88-1bb262f3984c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.491789+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.491745+01	\N
14615	07c01e99-16ec-4d18-884d-c7dbcb6a719e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.510379+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.510337+01	\N
14616	5f6db721-d15c-463e-9d1b-9f286551d902	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.528788+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.528743+01	\N
14617	f14ce506-dca0-4ec1-9c09-d3d9126004d6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.547204+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.54716+01	\N
14618	006dd77b-784a-4c42-8db6-7073dc7f49a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.565177+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.565134+01	\N
14619	7ed6f08f-62fc-4354-a2b3-b1c153bc7c95	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.582922+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.582866+01	\N
14620	362ad6aa-c724-4d21-9a56-b0be1418d6de	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.600623+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:00.600576+01	\N
14621	bf46bb76-7e25-457a-a1d3-2b0ad5697307	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.816192+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.816138+01	\N
14622	3f03f4b6-ab84-418a-8d66-b155f3c190e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:00.836142+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:00.836093+01	\N
14623	0d218851-2d90-4961-a316-8336ea3f649c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.121288+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.121243+01	\N
14624	9077baa6-f47a-4584-ac91-04d1df0e7748	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.139752+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.139692+01	\N
14625	b5f7bc0e-c9ce-49cd-9634-c80e71b3e472	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.159552+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.159499+01	\N
14626	3dc06c70-14ef-4940-815d-366fae4c9be1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.177677+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.177631+01	\N
14627	4fadcf54-45ae-46ac-a02a-5bd80f815424	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.197332+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.197291+01	\N
14628	cda83f0f-e8b9-46aa-8e5d-69fe16af5257	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.214899+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.214853+01	\N
14629	948c25f7-bd67-4260-bc4c-f894fb485fbb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.231493+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.231444+01	\N
14630	ea093c65-9f99-4159-a806-d541c4bcc6d8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.248411+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.248368+01	\N
14631	d32257d7-1a68-4c3d-a152-a0066919ff98	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.26524+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.265199+01	\N
14632	73ef5655-e1f0-4096-b576-7c3c6905576e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.284941+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.284891+01	\N
14633	c9a163cb-72b3-49ac-948c-6284e45ae770	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.301256+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.30121+01	\N
14634	c2e37c58-8ebe-4c84-8580-45006253f5b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.317894+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.317851+01	\N
14635	3a08d21b-1b12-4974-bbb7-a38d6b0655c2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.335023+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.334981+01	\N
14636	992d9183-996b-4e80-9ddf-330afa016a5c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.350967+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.350922+01	\N
14637	2fc90f76-0cc5-4138-ae3c-2f661862252e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.367629+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.367574+01	\N
14638	b1632dfc-39b0-478c-bbaf-14705197f59d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.384966+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.38492+01	\N
14639	ff0a876c-600f-4e5c-a525-84dec01ff64d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.401643+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.401598+01	\N
14640	1a73483b-07f1-4673-86d9-8c086ca69c16	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.420225+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:07:01.420177+01	\N
14641	ed9fc291-7bb2-4757-943b-1d23ca68236c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.443136+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.443086+01	\N
14642	42367a1d-d3bd-4365-8652-f38b7f118078	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.464234+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.464183+01	\N
14643	12e6ae68-820b-4038-bc83-eb2c5c08e4ad	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.485235+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.485185+01	\N
14644	0e17b08b-8b7a-44b3-b678-ff7bccfb9280	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.501842+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.501799+01	\N
14645	771d8b78-ccae-403e-a729-bfddbbc92df6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.519953+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.519908+01	\N
14646	bd831399-4683-4644-91d9-caee7d2d9b28	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.539826+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.539781+01	\N
14647	96443078-38bc-49fc-b81b-664667ae3ac0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.56015+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.560105+01	\N
14648	8c1bc944-e4a6-408b-aa65-e9c1aadad72c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.578311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.578266+01	\N
14649	486f25eb-8dd4-4f86-84a3-a4ab3a772127	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.59571+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.595662+01	\N
14650	1b0144c2-69c7-4273-8a73-593d412ae782	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.614682+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.614624+01	\N
14651	6052f07b-b9ae-4234-aabc-3e798fdf7e3f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.63435+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.634304+01	\N
14652	a66456c5-4e93-45a2-8cf3-8d4acf1105b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.654561+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.654509+01	\N
14653	c6e23dc1-4fd9-4136-b1f0-8c87a1c35dba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.672375+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.672333+01	\N
14654	c6582aff-bf73-4775-9b1a-7a240551bb2a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.690172+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.690126+01	\N
14655	c0af4025-1972-40ed-bf04-16830bdc1ca7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.707264+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.707218+01	\N
14656	f90db7f0-9bce-4c7b-bcc8-900e2da7638a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.724023+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.72398+01	\N
14657	ebea8b27-cf03-4bfb-86a2-cfcf116f2362	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.741086+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.741046+01	\N
14658	0c7f7857-c88d-4e39-be9e-9e79e122263d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.757757+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.757709+01	\N
14659	496324ee-b8a6-43c0-bf80-935086893e53	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.774459+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.774415+01	\N
14660	51d946d5-b79c-488a-94a0-811ac98595a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.791231+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.791186+01	\N
14661	aa4fa351-3599-41be-bf5d-0477fe1b2fbe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.807467+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.807419+01	\N
14662	82361013-f0a7-4460-8f3a-eb7e2235562c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.825234+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.825075+01	\N
14663	9563e15e-c462-422f-8364-169803c60ba1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.844284+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.84424+01	\N
14664	7dccd72d-ef89-4fad-8477-d48894cbf835	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.861893+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.861846+01	\N
14665	2302d62b-2b44-478c-9f7d-e3166da57c99	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.88049+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.880448+01	\N
14666	851f2d08-8f8d-4ddf-bdbd-99243fad1672	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.896432+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.896385+01	\N
14667	545eb2bc-2da8-43bb-a837-b6f2b4da39a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.912773+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.912728+01	\N
14668	34e3d2e9-ed66-4a8e-839c-deef1793968f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.929048+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.929001+01	\N
14669	0ee13108-133d-41b9-adf8-be8fafd0a70d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.9471+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.947046+01	\N
14670	de65bb2f-e699-4a18-a2ef-962b736676b5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.964663+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:07:01.964622+01	\N
14671	76b3f219-0f52-48c1-bf78-71f54cdf59b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.982262+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:01.982218+01	\N
14672	faeb84ad-c391-498c-9252-cd9d3fd2fee1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:01.999089+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:01.999049+01	\N
14673	6ee951b9-9ad4-46df-9bae-59a17d5b1ee9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.016133+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.016089+01	\N
14674	3d8e15c9-4a3e-4765-aa0a-344a65c090e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.034054+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.033996+01	\N
14675	52daf185-fcb5-483c-b32b-d9835ef8f5c9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.05158+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.051531+01	\N
14676	79baa4a6-2b48-4341-b730-0617fc375a3b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.06965+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.069608+01	\N
14677	9e68c680-1f3d-4585-8260-528c792e9808	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.086989+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.086946+01	\N
14678	8a656c60-e72e-4da3-a7a0-50b2326ffacc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.107781+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.107738+01	\N
14679	fb1c6e90-0f15-49d6-a423-7c75dc2a72ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.124302+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.124257+01	\N
14680	0b661e33-4bd9-4c97-be55-be3da3d116be	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.140919+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.140868+01	\N
14681	07dc3eca-1654-4368-ad12-96cd20071dc7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.175433+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.175388+01	\N
14682	231044d1-7655-4dba-abb2-f6a10e135ca4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.191577+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.191536+01	\N
14683	197c890c-1082-4ce2-84aa-4589c993885b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.20761+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.207564+01	\N
14684	495c3fb3-cd71-4062-9923-80ff24d61f5e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.227963+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.227921+01	\N
14685	bca09c3b-902d-4e4f-8146-c0653715b5b2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.244822+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.244779+01	\N
14686	0928aca5-516b-46c1-8a3b-67a3f578d3d1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.261701+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.261656+01	\N
14687	01154f1a-3780-47cf-b850-39e3257b4420	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.278971+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.278924+01	\N
14688	389fa990-42f3-473e-964e-624299aeeac2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.296495+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.296447+01	\N
14689	69914b08-7b21-4e02-aae7-2c03035f19da	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.314283+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.314242+01	\N
14690	184b33d8-aed7-48ac-a782-e4b19c92ecab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.332007+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.331951+01	\N
14691	76114932-e2ce-4bfd-a3a9-97aae5d12f6a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.349032+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.348988+01	\N
14692	223ae606-e455-49e5-9bc2-4707ae755116	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.366313+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.366272+01	\N
14693	7643eae9-e8f7-4bdb-bc1f-1410609cfdf3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.384229+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.384183+01	\N
14694	8b2847d9-9e8e-4c2e-aabd-f7b4a8c00ad1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.4014+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.401353+01	\N
14695	06fb9437-2b1e-4ac7-946e-35d40ec6c5d1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.42202+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.421974+01	\N
14696	7a9f7b1d-9288-4046-b15b-9a74a96c48fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.445743+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.445681+01	\N
14697	a6b4d3d5-3a9a-453e-8926-016d202e6ea5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.478801+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.478757+01	\N
14698	8f15a611-fc78-4fd4-a788-c2ad04dd34e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.496829+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.496784+01	\N
14699	aa7d0f3e-3d98-4962-8717-2c3b9ab2de39	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.514243+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.514198+01	\N
14700	574bfb4d-53b5-4de5-92c1-a2a7f02b1e80	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.530281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.530235+01	\N
14701	d17f3eb3-6c53-4fd3-b85d-945705697b84	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.548412+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.548367+01	\N
14702	7f268a51-0981-4dd3-aef3-8f04d8db7bf5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.565965+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.56592+01	\N
14703	1407c060-0ed5-4eb5-a634-b115d7c86ba5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.583837+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.58379+01	\N
14704	326012f2-b9be-4888-9732-4d96dcf1c6a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.600497+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.600455+01	\N
14705	4e421de9-3764-4e16-868d-47446c65ebbd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.617451+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.617404+01	\N
14706	4d1d1bf6-3dc2-4849-823a-d30e08a50201	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.635818+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.635778+01	\N
14707	95f967e5-bb7c-4b96-b883-cc4de55e7a0a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.653659+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.653611+01	\N
14708	ff8d6606-86cd-45d7-aaf6-7c0e99045b14	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.670775+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.670729+01	\N
14709	b9a8ff5e-57a8-4cc6-9777-8a52cd8b895a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.688141+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.688096+01	\N
14710	e945da1e-40a4-452a-a24c-3bb13a1e7267	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.704336+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.70429+01	\N
14711	f5663e1f-199e-4083-8290-048df17ca5bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.725236+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.725192+01	\N
14712	69464432-25ff-4431-b2bc-6982fc0ccf9f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.749108+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.749043+01	\N
14713	46c0dd37-d457-4933-bb1d-206db165173a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.772241+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.772193+01	\N
14714	1f873ab8-8921-4eb8-a188-abf18c1c27d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.790838+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.790796+01	\N
14715	dd28198c-6ff4-4881-9eb5-48bd1794407a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.808455+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.808415+01	\N
14716	f7f8b1ce-4b99-42f3-b0a7-9ff65810e944	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.829584+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.829541+01	\N
14717	4c1ddba1-c836-43ae-879d-f09b4cf4abeb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.847248+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.847205+01	\N
14718	3b6d742b-9569-4e6e-a25d-9ea51e3c642d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.863809+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.863764+01	\N
14719	30f0523a-7eab-43a8-b1b7-f4b278e33366	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.879844+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.879802+01	\N
14720	d25da1ab-9d89-4153-854c-ea014e306b3b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.896197+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:02.896155+01	\N
14721	d0df8c46-b6a0-480d-ba52-0b6944492cc8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.912891+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.912847+01	\N
14722	26a6ce9f-42db-4c52-be9a-899b64572b92	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.929622+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.929578+01	\N
14723	ffd89db2-7d75-4412-a243-d3452098d136	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.946219+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.946175+01	\N
14724	ff656e52-9412-497c-bdae-6253f07da62e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.963927+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.963881+01	\N
14725	e5e9796c-f0b0-455d-b9d6-4d8f26037874	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:02.987253+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:02.987205+01	\N
14726	880bfc8d-5a82-4c8c-85d5-142f520ec598	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.007766+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.007718+01	\N
14727	cc720c4a-69fc-417e-9c7d-a9d2861f7f09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.028029+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.027989+01	\N
14728	cd9ddd4a-4525-4f12-b4f2-94de0707072c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.04567+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.045625+01	\N
14729	82f7522e-e5eb-4d2b-b0df-a7ac98dbbe09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.062771+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.062726+01	\N
14730	5352d1f5-9bfa-4022-9099-5b7ec71b5632	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.081015+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.08097+01	\N
14731	e60d7fc8-83cd-4e58-b98c-bda79e8b1615	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.098039+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.097994+01	\N
14732	6086c156-c9c1-480a-8e17-99b7448c937f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.114859+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.114815+01	\N
14733	9576bac4-31ef-494b-ada1-03e8dbc0b96c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.131627+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.131583+01	\N
14734	47ac6c91-c66e-49b1-8311-a95d07207c10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.153107+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.153029+01	\N
14735	cb6aa66b-15ec-43f0-b424-825bb046bf21	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.175042+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.174998+01	\N
14736	2fe9b020-d93e-4d96-a7aa-6aa06e9cc2cf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.196868+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.196825+01	\N
14737	169d2387-54b7-48cb-a420-66b6c3579c6c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.213787+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.21372+01	\N
14738	713baa70-36ca-492e-82b8-d4213a6fb42c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.231154+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.231107+01	\N
14739	28ce5cc4-7d64-4529-9d40-473fff46d4da	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.248325+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.24828+01	\N
14740	41dd2287-7915-43c2-8035-a3b52d43e2f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.264996+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.264951+01	\N
14741	d2341893-3ef8-4df0-8e39-9f148f07e828	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.282228+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.282183+01	\N
14742	2ddddb55-f302-4161-8291-f1412e4e1604	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.299692+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.299645+01	\N
14743	be2e08a1-7624-4ea1-8ea3-988ee99589af	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.316564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.316521+01	\N
14744	cd9a88c8-3472-411e-818a-eff175c2b8a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.333274+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.333227+01	\N
14745	0e4ac2fb-e289-458d-a385-17c8145469eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.350348+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.350307+01	\N
14746	ce89c0a2-d111-4f5f-84ae-599450a14471	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.368492+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.368448+01	\N
14747	e9fc6456-22be-49d8-8b6b-1e4385ebea7e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.385219+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.385175+01	\N
14748	bcd6c6da-41b1-46bb-a293-414bc530197b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.403716+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.403675+01	\N
14749	09605f15-3ab4-4c9c-8272-4ecfe074494c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.422403+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.42236+01	\N
14750	78906012-9c22-402f-b348-f24f87eaba40	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.440729+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.440683+01	\N
14751	27026a7c-dced-4268-b9a9-7f4c400853cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.458205+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.458155+01	\N
14752	ced3922b-8a4d-435b-9118-b53e1c9a3e93	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.474093+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.474042+01	\N
14753	291bbb65-a0fb-47c7-9b3c-036bf9b57705	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.492165+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.492124+01	\N
14754	472b2ab5-ca90-4189-8bc3-6134c67abd2c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.511196+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.51115+01	\N
14755	994baa31-019c-460c-aceb-cee2ec8af523	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.531506+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.531426+01	\N
14756	91ae24d8-5cb5-4e0e-8888-ed391bff6c10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.55542+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.555357+01	\N
14757	41e0bbf8-3f41-48dd-834a-784ac2e084b7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.580746+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.580697+01	\N
14758	89e51ba7-d0de-4526-b44a-1dd1dbee778c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.600197+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.600135+01	\N
14759	055e974d-9bb3-45e1-948b-4c5fb5e1422b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.620825+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.62078+01	\N
14760	f469df54-943f-48e1-9cf5-2690049fa3d8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.641292+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.641236+01	\N
14761	e9ab5726-2047-46d0-b028-43e7cc152ccd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.660693+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.660648+01	\N
14762	0c8c7172-33ff-4997-83d7-fc2a53a82565	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.678533+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.678488+01	\N
14763	a33283a8-402a-469a-b2c8-28328aa5680a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.698161+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.698115+01	\N
14764	a5669504-2184-43fb-bfd5-37b45d0b681c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.716879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.716829+01	\N
14765	36d81d8b-c349-45a8-b933-9ad552da8d9d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.734877+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.734833+01	\N
14766	111e0740-f851-40a3-bf5e-db836d22a836	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.752357+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.752313+01	\N
14767	39713059-5e70-4429-b7da-43aabc7525b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.770843+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.770795+01	\N
14768	01ccf920-f8af-4116-86ef-96c59351da71	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.794765+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.794714+01	\N
14769	90613930-84e2-46bd-8017-f8d6669dcda8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.814108+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.81406+01	\N
14770	63eefe2a-df6b-4ee4-8c88-41b2e697a5f8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.836161+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.836118+01	\N
14771	025f3a7f-bfed-44de-9934-625d192a6e78	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.856498+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.856449+01	\N
14772	99e57cad-ea4a-486c-8988-3e0f94a07205	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.875241+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.875195+01	\N
14773	76677983-9301-4e25-890f-14f2e38106a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.892851+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.892806+01	\N
14774	b96d41fe-26ea-4e4d-b048-a34aa814de14	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.91099+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.910944+01	\N
14775	9a4dbfd6-1041-4e63-ad4d-b6cd938dd0a2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.928487+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.928442+01	\N
14776	869fff26-7933-4691-8e1e-f96252cff6ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.948825+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:03.948776+01	\N
14777	8b99be9b-8be1-43fa-8182-915d99cb643f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.974039+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.973989+01	\N
14778	4b2d7c05-1ca9-4051-9a2b-821de544b9dc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:03.996604+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:03.996554+01	\N
14779	8fc50447-3f15-43c2-849d-6fe199051bf0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.017501+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.017455+01	\N
14780	1ada0bb4-311d-4b7b-8163-cbacdd9befdc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.034764+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.034719+01	\N
14781	669d4253-5a0d-44b7-8b98-65fa7b2f4c12	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.052659+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.052615+01	\N
14782	2d78c497-51da-4f7f-b424-a143bbb6e6a9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.070434+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.070389+01	\N
14783	b0f3a441-f899-4503-a8e6-4fba7965b63b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.089004+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.08896+01	\N
14784	22387d18-c3cd-4c19-b1e6-77f6000e299e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.106025+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.10598+01	\N
14785	1313a524-d287-4e7a-993e-a4673e7ad265	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.123389+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.123264+01	\N
14786	7935444c-566a-4de1-9574-4231e3c2e27d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.140933+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.140887+01	\N
14787	339233a8-ef93-4923-8b10-dad0efabf934	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.166303+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.166247+01	\N
14788	69fe452c-80ad-480f-9249-dc90f723d5aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.189722+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.189674+01	\N
14789	ae52fee0-b524-4f92-b247-cc58ac32e041	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.214497+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.214449+01	\N
14790	3c7f4932-aa6d-4886-a06e-5baf263e8299	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.234331+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.234284+01	\N
14791	733dcf61-bf11-4322-b705-cdf85b60e83f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.253117+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.253072+01	\N
14792	57b64695-cf36-45f0-a8ba-1f8eaefcaba6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.270576+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.270532+01	\N
14793	2a81ab23-9710-44f9-a331-9e8c636461a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.287929+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.287883+01	\N
14794	eaf61237-cc30-47b0-951e-40bbeef367e9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.304801+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.304754+01	\N
14795	178c42df-fcd3-45bf-ba6e-a468609bdabb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.333608+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.333559+01	\N
14796	d8e74532-0d68-49eb-958e-9156034baa9b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.364174+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.364125+01	\N
14797	dc088c9d-23bd-4eaf-931a-faae4e16e84d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.3844+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.384353+01	\N
14798	d70eaf65-e8a2-4394-a8ee-643b662273de	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.402187+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.402142+01	\N
14799	14c42d17-f3e3-4b27-bc43-60da2a6b6554	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.419413+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.419366+01	\N
14800	e34048ea-500a-43df-b900-3bc25f0f10fc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.436915+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.436871+01	\N
14801	85fff585-681f-46d5-b057-1d5ae4ee29e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.45694+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.456885+01	\N
14802	9a879921-adda-4b96-a47d-61c1025363a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.473672+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.47363+01	\N
14803	520be6d1-9a9e-4461-8fea-a4b133189549	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.495788+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.495745+01	\N
14804	23448583-529f-46dd-bb34-34b67b2eb715	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.514165+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.514123+01	\N
14805	1eadae53-a2de-4ac1-b52e-2cb05340e51f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.532788+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.532746+01	\N
14806	f68732de-cc99-4087-a28d-c4c55b52ab77	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.549567+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.549514+01	\N
14807	e19418d2-45db-41fc-9829-6d8a605b8cee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.567879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.56783+01	\N
14808	09495530-cce9-45d4-95e1-52cc04753690	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.585261+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.585217+01	\N
14809	70a2c177-13b4-4e5f-96cc-7eabad029b0e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.601927+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.601885+01	\N
14810	a7ef7479-ecc1-4fd1-b851-1003d1cc7046	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.619553+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.619509+01	\N
14811	d38f29f3-96e4-487d-85fc-6734518be50f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.637849+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:07:04.637807+01	\N
14812	7e4014d6-b4ad-4703-b819-253654657acb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.654506+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.654461+01	\N
14813	2b932b64-c391-45d1-af97-6e93230787e2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.672561+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.672519+01	\N
14814	74cd2def-8805-4f62-a60a-e0222239e0ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.691834+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.691793+01	\N
14815	43f3c036-e5a3-4bb0-9906-b33344cc5487	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.708572+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.70853+01	\N
14816	d9183f6f-ae70-4c7c-8bfb-12f0a9fab34b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.729675+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.729624+01	\N
14817	14c6b5e3-f32e-4976-ae0e-8f6cc9c62812	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.748735+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.748688+01	\N
14818	fdb7f28e-2234-4ae4-8223-d17bfd21240a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.765399+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.765354+01	\N
14819	f6e752ec-f87d-41d5-8a83-ac7c16b4435a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.782283+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.782226+01	\N
14820	157b4f56-65c5-48da-a691-5530ff645854	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.800338+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.800293+01	\N
14821	32f6e52a-b696-4016-a5ac-bc37e17e8a35	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.817244+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.817192+01	\N
14822	4c333966-1141-4a77-a7de-cffe0603cf28	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.838866+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.838806+01	\N
14823	8a960822-5203-4365-bc8f-08aae8a85664	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.859392+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.859343+01	\N
14824	eab16806-14ce-4f50-b6fb-2187280fe830	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.876067+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.876024+01	\N
14825	0077e357-e403-4378-950c-851892119a19	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.894139+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.894096+01	\N
14826	0d63a995-edf0-4eb1-b27d-265d0c814577	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.911672+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:04.91163+01	\N
14827	a7de51b5-f12e-4da0-9ac4-b35d7069db02	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.928223+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.928179+01	\N
14828	0fef3a70-54af-4546-b0ca-780319150713	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.946536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.946493+01	\N
14829	f74584a1-41e4-445a-a907-7026226ae010	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.963228+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.963185+01	\N
14830	11971e91-bea4-41c8-ad47-f16206792fd3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.980654+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.980611+01	\N
14831	a7f9cc4c-acdf-488c-8f34-c78e90d70a09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:04.997715+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:04.997669+01	\N
14832	5bca9921-e5ac-4dae-8c72-cd3f524f2467	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.015258+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.015213+01	\N
14833	4251c4c0-465a-4ab9-bf9c-0549fed5bbc7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.033289+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.033239+01	\N
14834	812b7688-78b7-483a-a177-837d43813e76	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.060059+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.059992+01	\N
14835	ba236af1-640c-47e8-a36f-c530c5e74885	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.083009+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.082962+01	\N
14836	692b476c-750a-4dbf-b9cc-c0db354798aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.102693+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.102648+01	\N
14837	aadbc1f8-0ae4-42c9-9384-b4284068b0e2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.128539+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.128488+01	\N
14838	e28a0fa6-ef67-41cd-9759-028bf103e421	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.151474+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.151413+01	\N
14839	0dec371b-9c69-49fe-bfdc-e459555bc773	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.170497+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:07:05.170452+01	\N
14840	08a71d06-0f3c-4df8-9427-46f99714b960	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.188484+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.18844+01	\N
14841	82d5e2e2-05a4-4213-8455-f6062184d26e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.205048+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.205005+01	\N
14842	8aa386e0-7a4a-4554-a4bf-e7b10b4e7711	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.222238+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.222193+01	\N
14843	bcbf1709-28c4-42e9-811d-6a1185d09a60	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.239153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.23911+01	\N
14844	cd0954e0-92f0-4d11-9045-509e8f9fd11f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.2611+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.261053+01	\N
14845	f0b9c4d6-a477-427e-be1b-b8ffa171b62e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.279965+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.279914+01	\N
14846	8daea30c-7b34-4138-b5ac-237f3a02364d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.298117+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.298071+01	\N
14847	a981c831-def6-4236-9dc3-450b563b825e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.314853+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.314809+01	\N
14848	d402f28f-47c8-4d60-92db-1963714f0dda	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.331634+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.331587+01	\N
14849	2b704eb8-e4d4-4ed9-a64c-1b25dbcbb07f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.349439+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.349396+01	\N
14850	8d0a5c16-a5d2-4ab2-891d-061dfddf1d58	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.380976+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.380923+01	\N
14851	37ff1d25-a5b7-406c-aa76-bd38b8bc58fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.40509+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.40503+01	\N
14852	a2a57390-5103-4fc2-bb9e-bc4d36576772	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.427605+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.427548+01	\N
14853	a777b619-b5f5-4730-88a4-a7660d00e5e3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.449593+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.449539+01	\N
14854	5254bcc7-2682-4513-874d-4eb89820dad9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.469903+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.469845+01	\N
14855	c544a762-f441-4e35-adc8-c80f9cb1c52d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.492001+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.49195+01	\N
14856	4796a5d9-5929-4041-a080-12aed2108ab2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.514564+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.514507+01	\N
14857	4d1cbe62-bf72-4cf4-9614-0c8a4849cb0f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.537327+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.53726+01	\N
14858	12845e48-5258-4435-9558-0b91d6f7d497	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.558299+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.558111+01	\N
14859	3432892f-07f9-4256-a2e7-9e37fd2ac3cb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.591496+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.591409+01	\N
14860	8b791df6-55ec-44f0-8de2-ba4129c30854	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.620448+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.620395+01	\N
14861	9d4f90b0-58a1-450c-ae0e-7305575e273d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.638538+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.638492+01	\N
14862	0a2dca4f-0056-46ca-a6bf-89256a30ada5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.656436+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.656392+01	\N
14863	e3c77ca9-f720-4366-bd7f-7a0c3938f546	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.673597+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.673552+01	\N
14864	8cf27d0b-dee3-4ee4-ad95-b32829c935ef	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.690812+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.690767+01	\N
14865	b7bb0d8c-c826-40d9-aa61-9b17b23ca086	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.707045+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.707001+01	\N
14866	fccfae49-034c-4673-8f10-106c51f2f5b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.726666+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.726624+01	\N
14867	0d45192a-c132-4baa-ad51-e81115983888	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.742934+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.742889+01	\N
14868	aec6dffe-0562-4706-829e-49fa4cf59dd8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.760177+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.760132+01	\N
14869	5b5be068-877d-49ff-aa0b-2ab3d632f062	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.777192+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.777148+01	\N
14870	ea2749cc-08eb-4ce6-bddd-458dd0ab5e45	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.793984+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.793935+01	\N
14871	08da1df3-2dee-409c-9560-04bcd1d9d6a6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.810402+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.810361+01	\N
14872	12fad7e7-e220-48c0-960c-bd6118d531d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.831153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.831107+01	\N
14873	2cab0ec7-2dde-4358-b39a-58277d4804d4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.85173+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.851685+01	\N
14874	80d949cc-5fba-4755-9208-a3a5735fadd9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.868986+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.868943+01	\N
14875	5c24927d-1ea5-4e85-903d-3b8c95163e14	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.886571+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.886525+01	\N
14876	d70d4b0b-bb99-409a-883f-5be95c374de0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.904156+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:05.90411+01	\N
14877	142be93c-0360-44a9-9665-78f7b75623e3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.922371+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.922325+01	\N
14878	01bac54b-b218-4fb8-80a0-8081628f3c7c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.940618+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.940574+01	\N
14879	4da5b252-1526-4ab4-9f53-d649a5e787d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.958656+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.958593+01	\N
14880	db183e5c-b71e-4e54-9671-0db4a645ab95	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.976286+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.976242+01	\N
14881	d2056250-5624-47cb-af8c-da2b22445c4d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:05.993405+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:05.993351+01	\N
14882	12c2632f-2668-4305-a2a3-2bb441fd8267	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.014513+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.014436+01	\N
14883	73a58e6c-4caf-4d5c-a595-3c198cd1c3a2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.036422+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.03638+01	\N
14884	2de0ab24-50a9-4f5a-aea1-2543af4c33e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.056648+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.056604+01	\N
14885	393f5b13-e97d-445b-9825-bfb55a2c5549	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.075544+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.075472+01	\N
14886	0384ffbc-eeaa-4959-94f9-8c54a296858e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.098737+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.098692+01	\N
14887	db599381-3df8-41f6-8ff9-0d89668558de	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.12636+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.126298+01	\N
14888	30b95ec0-8cef-47bf-a9db-ae1054973460	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.145867+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.145817+01	\N
14889	10b2c2d8-3497-46db-b34a-9d7510ae0b11	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.164756+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.16471+01	\N
14890	f649c383-5f07-426e-a823-4e670560ba82	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.185206+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.18515+01	\N
14891	85c8c09d-163e-4678-a0c2-1ca0f4702e1a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.204686+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.204635+01	\N
14892	a6b185b6-eca3-4dd5-add1-cfc7a863968b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.223904+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.223859+01	\N
14893	846f3439-9a7d-461f-858f-20f83650c0a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.243448+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.2434+01	\N
14894	23e62559-807c-44e8-9220-f38ff347abcd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.261854+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.261814+01	\N
14895	82cfe8f1-69e2-47d4-9792-5a9c830a5062	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.279046+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.278999+01	\N
14896	8b4e0e03-cdd2-4e69-af58-a5d9826b672f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.297009+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.296964+01	\N
14897	019f36a8-89d5-4343-a5cf-60d84b5e80e8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.313818+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.313774+01	\N
14898	1902258c-da6e-4db5-8697-d6832d28ddba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.333129+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.333076+01	\N
14899	6187abc7-2995-4670-9fde-62f7c7c3e681	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.352106+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.352054+01	\N
14900	4b81eae7-45c4-477d-9436-c87fd7e0b248	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.370065+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.370018+01	\N
14901	78a8020e-45c5-4bde-9bed-16c68e3c96a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.388901+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.388854+01	\N
14902	f6419958-4f85-400f-8d33-57cf9f6a558c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.407141+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.407096+01	\N
14903	9d3bbfed-2219-46ca-a765-97fbac081a42	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.424951+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.424904+01	\N
14904	2c57ab0c-2392-4018-93d6-9795a4c77eb1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.442909+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.442865+01	\N
14905	ada2df9c-11c2-4030-a41e-a886b1559deb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.469802+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.46975+01	\N
14906	6d6cf2d8-d608-482c-b3e3-ec5361b6a04c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.487989+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.487947+01	\N
14907	4df356d6-8df7-48c4-8c57-506680e7d2b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.505627+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.50558+01	\N
14908	0524b991-fd23-4e2b-a69e-c19a3f62121b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.523198+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.523154+01	\N
14909	4e78b455-87f9-48f0-bb4b-6e552c82b7dd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.540676+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.540632+01	\N
14910	7bbc4239-ba99-4d42-81ce-dc092bb7b7ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.559752+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.559698+01	\N
14911	b8e7cea9-924e-4e96-810d-c7b44d8b0912	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.579086+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.579041+01	\N
14912	c83a87a2-24a6-43cf-bdb6-d14faf2e9b04	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.597597+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.597553+01	\N
14913	a4b88f1f-34f7-4f43-a09a-aadbbdfa9eb7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.614981+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.614935+01	\N
14914	464b1de7-2533-41c1-be7c-4e3eaf227948	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.632545+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.632492+01	\N
14915	caa5b4c0-1ea2-4fa7-b0a6-b718b32c478f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.651047+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.651003+01	\N
14916	c97f287f-71b4-4b83-8d63-5aceeeab6b4c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.670456+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.670411+01	\N
14917	71230866-2e61-4d64-ae55-33cd17a23753	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.690478+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.690435+01	\N
14918	49ff9233-62a7-44f1-a162-3426e1c40ee9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.710998+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.710953+01	\N
14919	df655e9c-cfb8-409a-97bd-6b50059a3af1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.733035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.732988+01	\N
14920	be7279de-72ff-4822-a3f7-275c19b21905	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.75611+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.756061+01	\N
14921	1db47518-e867-4cdc-867e-17d7831691f0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.775527+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.775485+01	\N
14922	5fc53761-77d3-4862-b767-86b7f9f07674	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.797211+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.79715+01	\N
14923	1fa77a39-6bc0-4239-b9f8-7654a63b3cb7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.818725+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.818681+01	\N
14924	d09a60eb-ca34-43e1-9f88-c9821ce7edff	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.841033+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.840991+01	\N
14925	df2d3070-ab8a-4fd9-a4a3-774004a5d6a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.878565+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:06.878525+01	\N
14926	55891368-ff20-4fc0-a071-b68830cf6ac4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.898108+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.898063+01	\N
14927	2b42ebb4-4726-4c3a-9353-a4a1c2a3a1aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.920298+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.920246+01	\N
14928	1588b494-b659-438e-ab1d-ea39aadd6b9c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.939061+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.938997+01	\N
14929	2be17257-d92a-4e7f-94d6-dcb1b3d6c58e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.956599+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.956551+01	\N
14930	cf9d75cb-2918-4384-961c-d99c52af537d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.973351+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.973305+01	\N
14931	975f18f1-9421-4d37-90f2-5beb07d15ec6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:06.989556+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:06.98951+01	\N
14932	66bc22df-6170-40f7-98c0-d8211ee6f975	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.006285+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.006239+01	\N
14933	f35cc3b5-e1c7-4fbc-982d-2ae1ed78866c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.022463+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.022417+01	\N
14934	3e0e4db4-325a-4852-93b0-d460af881871	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.03953+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.039483+01	\N
14935	35fe93ba-f24c-4c9a-be80-124c5221df37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.05713+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.057086+01	\N
14936	c5ac15ff-3939-4d97-b1bf-f301a7a14c69	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.075864+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.075816+01	\N
14937	fd5c4b84-edba-4cbf-b97f-8b1d6808b0da	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.09526+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.095217+01	\N
14938	dff79806-ac3b-4b9b-9bce-b41b6918ff8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.110551+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.110505+01	\N
14939	bb2b8a37-769f-4581-9b6a-2da16768fb26	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.125725+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.125683+01	\N
14940	b8b490b4-8d2e-4483-8a28-06a10c84f2e7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.140253+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.140207+01	\N
14941	937a6128-919b-4ff3-8183-ac1878beb2e0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.156135+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.15609+01	\N
14942	64ede900-d234-46fb-9a3e-26c45119d6fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.171509+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.171467+01	\N
14943	e210e72c-becb-4f58-96da-7adaa9c88254	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.186214+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.186173+01	\N
14944	347973ab-13bf-42fa-915e-6b7f17406087	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.20061+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.200568+01	\N
14945	3b0f7302-b71b-419f-8977-14a874762d28	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.214375+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.214333+01	\N
14946	03ea54d2-e00f-46c5-92c4-7215a9c5251b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.228313+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.228274+01	\N
14947	e5f7b89d-0269-4bcf-9fc1-b457963e4167	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.242483+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.242442+01	\N
14948	81f42204-bd68-4893-8a70-b31816ee749b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.25721+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.25717+01	\N
14949	786792d0-c17b-4a3c-85d0-d8ed6bab1bfb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.271481+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.271439+01	\N
14950	24481ea5-4927-4272-931c-51176b066181	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.285356+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.285315+01	\N
14951	4f045aca-35b9-42ed-b6de-e1e5972bdcfe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.29935+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.299256+01	\N
14952	03891230-67a1-4ff7-8b4d-e854a37c791b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.31583+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.315789+01	\N
14953	d75ab5b1-6c7a-4d9a-be33-ae01a68ae587	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.329649+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.329609+01	\N
14954	e6dec21d-b63a-49e0-ae2a-2ca3afc3aa3b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.343709+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.343668+01	\N
14955	2c2f1c43-98a2-4194-8ea7-cd8b45cb1c83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.35818+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.35814+01	\N
14956	e0228d5c-6e04-456b-b801-25aa4de2b36d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.372786+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.372745+01	\N
14957	0d58a2d4-3846-408d-88bc-73e01ff7a817	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.386775+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.386735+01	\N
14958	25c10779-42da-49ae-9f5c-d1fb3464a9bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.40115+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.40111+01	\N
14959	49838570-7b82-49a3-a964-aca1252ddb51	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.416004+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.415963+01	\N
14960	fdfcb3f5-659d-4de4-8abb-b4668847b807	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.430613+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.430574+01	\N
14961	932ece87-ffc1-4a4b-acb5-db523548fd18	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.444512+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.44447+01	\N
14962	aaae2a19-ea21-44c3-870c-8db4603e353b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.459063+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.459022+01	\N
14963	ccbfc0f2-efe6-40c5-8de7-2bc7dce1fac7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.47294+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.472898+01	\N
14964	a6489fb8-0771-4482-bec2-3592ef898807	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.487042+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.487001+01	\N
14965	d426aede-8eb2-40bc-90da-1c66eac08435	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.501504+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.501462+01	\N
14966	2934e1ff-d7d6-4924-a225-44b3ca463099	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.515585+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.515544+01	\N
14967	1023a80f-6888-46a2-b1ff-d8bc2af07ad6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.530655+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.530616+01	\N
14968	7a58227f-4a8f-4665-a2b0-4de6cbf65c7a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.544914+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.544873+01	\N
14969	033a32ba-86ed-44e3-97fa-164018b1ab1c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.558852+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.558813+01	\N
14970	670664d4-4bca-47f6-865a-76646e0d4934	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.572943+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.572903+01	\N
14971	3ba673c8-55d9-4449-8d88-64e37d43ac36	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.587163+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.587122+01	\N
14972	88f4a225-9bb0-4ba4-997e-ff6df74951c7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.601215+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.601175+01	\N
14973	9d84d9f6-7c2f-4419-9d6f-ae63aae18f0c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.615238+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.615078+01	\N
14974	85c30be4-66b8-4cc8-96d3-d9b7e0b0f894	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.629362+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.629321+01	\N
14975	642f5846-df94-4d41-ba9b-a8912d832024	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.643666+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.643624+01	\N
14976	0dcf7889-9065-414f-99d1-2330be751cb8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.658142+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.658101+01	\N
14977	cca8e617-cb53-4089-8421-a60f8504e4ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.672533+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.672493+01	\N
14978	902edf03-f6ca-481f-83fb-b43f410460b2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.686594+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.686554+01	\N
14979	4d71e71c-9333-4f17-b203-ea791e208e67	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.700876+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.700834+01	\N
14980	d87f4d22-a7f9-4376-9293-6364d91eeff0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.715507+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:07:07.715467+01	\N
14981	b072eb76-e131-4699-8aa3-dc8a9a7e6b2c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.729446+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.729404+01	\N
14982	8ae3946c-280e-4ac5-abcf-62768a9f14b1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.743756+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.743716+01	\N
14983	20a476a7-12d9-466c-8d79-47426ee20015	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.758509+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.758469+01	\N
14984	2d61b810-0b80-4e2b-9b62-0d372692b557	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.772755+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.772715+01	\N
14985	9d270207-8647-4077-b49e-43b8873f34bd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.786748+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.786707+01	\N
14986	46d0e1ff-7e96-4e29-8dd7-3abc1bdbfb61	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.807026+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.806985+01	\N
14987	e1b15591-e055-4761-9201-9a844b7d6590	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.823666+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.823621+01	\N
14988	ad303b6e-6e83-468e-be13-bcccaf4952f8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.8407+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.840652+01	\N
14989	605f002b-e908-48de-adcd-5093f1a89792	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.858138+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.858077+01	\N
14990	a44a418e-d393-4244-bcf4-d618a140c292	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.87441+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.874361+01	\N
14992	9a644b51-31cb-41dd-96ea-21f618b2f8f9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.891386+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.89128+01	\N
14993	9f66d4c9-96a2-489f-ada4-c741bfe2a1d8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.908556+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.908509+01	\N
14994	1542ae8e-c4b6-4011-8147-03e3620e85d1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.925227+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.925174+01	\N
14995	211518f7-9d72-4119-b56e-c02ab45ec27d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.941909+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.941863+01	\N
14996	4b4b23c2-e460-4646-9292-20acb22219a1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.96072+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.960666+01	\N
14997	41547915-2738-4236-b483-86f89d5d8530	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.976481+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:07.97644+01	\N
14998	0c19fd90-52f5-4949-93b1-094716fa9a6b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:07.991035+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:07.990995+01	\N
14999	1899eb6f-357d-4fcf-8356-7ce305446e53	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.005374+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.005332+01	\N
15000	642e0d27-a72e-4bd2-a1e3-6e80088e7df3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.022322+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.022281+01	\N
15001	12023f16-d449-49b6-af5f-20ea2efbad10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.036496+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.036456+01	\N
15002	07c95010-ed6c-4d50-9e2d-be1fcce18458	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.054+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.053959+01	\N
15003	b32d0068-08fb-46a0-b363-7f3ac3c71308	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.06913+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.06909+01	\N
15004	502ebb4e-72fd-494c-b051-8ee57cf93927	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.083183+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.083143+01	\N
15005	9d2b1096-8f16-495e-87ce-a3054146f8d2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.103759+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.103714+01	\N
15006	68654d4b-b436-418a-b11e-2c2e7da9380d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.331749+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.331619+01	\N
15007	6593bfdc-6db3-4db8-aa15-e84e56b71878	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.350497+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.350449+01	\N
15008	be509f31-3fe8-4cf1-b77a-ac150eca20ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.367383+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.367336+01	\N
15009	437c179b-8f4f-4073-944e-d7939e3bdc2c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.383144+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.383101+01	\N
15010	a33caa46-f1be-4e63-8686-f3cfb82d0662	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.398813+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.398772+01	\N
15011	6ee267b4-0bd4-4a45-ba08-d21bcda66572	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.416555+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:07:08.41651+01	\N
15012	d7088ae7-d7ec-48b1-812a-2354a6db65eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.433305+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.433256+01	\N
15013	5db8a704-e953-4811-88e9-11ec53579a49	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.448313+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.448274+01	\N
15014	853ec593-da78-409a-8699-4c61e2785b1c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.463175+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.463134+01	\N
15015	61b8eed5-6f6a-402f-b2e2-6aa5fdc017cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.477415+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.477376+01	\N
15016	42e74f4e-18f3-4cff-8064-72b10a86a937	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.491709+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.491668+01	\N
15017	dcafa0ce-a18d-4c57-b992-6855b7bade83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.505692+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.505651+01	\N
15018	7f757f6d-952e-4a34-8bb7-954d585c79b7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.520196+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.520156+01	\N
15019	3117b11f-52dd-4987-a6d9-9757d355b5b0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.534654+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.534613+01	\N
15020	4b5f56d3-1bb8-40c9-8127-d41757c02f87	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.549346+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.549305+01	\N
15021	36f80290-5a65-40e5-841f-97d41002e57d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.566432+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.566392+01	\N
15022	5c2f529e-7316-4830-952f-dc8752564b1d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.580836+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.580796+01	\N
15023	83c1573f-b9c1-497f-a6cf-9d61cf1ec5fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.595088+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.595048+01	\N
15024	e3b5f8ef-e1e4-4f2d-9b99-6c6a7f82d633	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.609076+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.609036+01	\N
15025	963d1974-de1b-4919-9eeb-b62bd6f6625e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.622872+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.622832+01	\N
15026	622456ee-ea68-484c-a3cb-23574f51fe4f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.636986+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.636946+01	\N
15027	0182b9c6-8461-4a0e-9120-94e02c88e600	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.650985+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.650946+01	\N
15028	f8070352-77cf-49d0-bc76-70c7a7ca411a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.664981+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.664941+01	\N
15029	b4c1b79f-ca3d-46a4-a06b-3806a65d4847	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.678813+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.678773+01	\N
15030	ffcd3f7a-cc5d-4977-9518-0bac3ff75967	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.692773+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.692733+01	\N
15031	d985e9a8-1c14-4ad8-90f6-4e27f1b2075b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.707198+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.707157+01	\N
15032	9ba4efb6-32b3-48b3-96e3-e9e4cedd03bf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.721318+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.721278+01	\N
15033	d0c42e28-b355-4ce1-b28e-6c2478f32909	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.735162+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.735121+01	\N
15034	56237f6c-eeed-402c-a72a-2b9817862bb0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.749288+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.74925+01	\N
15035	0f42ca12-90b4-4ce3-bb8b-aa3535219432	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.763563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.763523+01	\N
15036	908975e2-852a-4054-8cf1-c74cb3be1771	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.777838+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.777797+01	\N
15037	a82bcb61-6386-4d89-ada1-b93b201e6688	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.795422+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.795247+01	\N
15038	445b7b96-f077-4deb-8241-9b8ebb6056e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.809435+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.809394+01	\N
15039	50dea438-80e0-493f-9ff1-f3c0a34bb495	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.823782+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.823742+01	\N
15040	1aefae9e-3c12-4f9b-be1f-638a7d0c5f59	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.838071+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.838031+01	\N
15041	57e2c502-1eae-4baf-88f4-2845ed65d599	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.854057+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.854018+01	\N
15042	5940128a-de85-4fda-98b2-393a806a9441	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.869091+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.869051+01	\N
15043	88ca134e-a3e8-41d5-bfdb-f16443f18505	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.883784+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.883742+01	\N
15044	ffd0184d-ae07-4eef-aa94-17818ab01eab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.897968+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.897927+01	\N
15045	1d301eb2-5b76-4f7f-bec4-639b5904ee10	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.912861+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.912821+01	\N
15046	a5bda2b9-ed73-4e72-9697-81de5ea4a1cd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.927172+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.927132+01	\N
15047	e435ef57-099c-4b3a-985e-95a3c5704f81	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.941781+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.941741+01	\N
15048	c0f0f46c-6457-404f-9ee4-7194abea25ae	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.956161+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:08.956121+01	\N
15049	033ec3c4-839e-4bfd-a3a7-d7f9f1e76c0e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.970502+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.970462+01	\N
15050	50040fb2-39d4-4839-ad86-3c20ff0e433b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.984734+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.984694+01	\N
15051	4dc7283f-bad8-4604-88ba-26ecd27e405c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:08.999273+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:08.999233+01	\N
15052	d008783d-eb2c-401f-9f4c-9ce5b602af4e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.014817+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.014776+01	\N
15053	4e27483e-d92f-4996-97dc-c57f74db3651	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.029089+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.029048+01	\N
15054	3e837916-7c79-42f8-92dc-3ebe08cf70e6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.043859+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.043819+01	\N
15055	1a39e542-00de-4c76-9156-aaed890969b5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.05845+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.05841+01	\N
15056	51524a03-6f05-4630-9d19-f65888be36fe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.072892+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.072853+01	\N
15057	29d52da1-c899-4377-b48f-efc432d03182	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.086864+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.086824+01	\N
15058	03828e9e-58f2-4b5d-826a-be664b7a239d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.10141+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.101371+01	\N
15059	ef19edc0-675d-4a7f-9669-ba83257a125b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.116144+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.116103+01	\N
15060	d1677542-389b-4564-a427-8268be8429ec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.130177+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.130135+01	\N
15061	3fd97315-cd62-4211-bec3-aa00af8f54ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.144343+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.144303+01	\N
15062	af8d1137-3111-4505-be59-8231569e8f20	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.158645+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.158606+01	\N
15063	39eca8eb-33f0-4bbf-a6de-dcae69f37444	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.173013+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.172972+01	\N
15064	67540979-0fca-43db-857c-6d446f4bd878	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.186952+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.186912+01	\N
15065	dfe10bf2-ced7-4dbc-addd-aaf72c6f1d97	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.201104+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.201063+01	\N
15066	a245a5d8-f962-480b-b0e9-66f88cc54c07	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.215628+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.215587+01	\N
15067	b07fbf3c-0b53-41bd-afa7-fc0b418e2ee3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.229428+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.229389+01	\N
15068	6e0a6128-586b-4135-903d-affa8ca0dc98	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.243623+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.243582+01	\N
15069	e571b549-b28f-436a-be56-cdbfd83abdbc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.258172+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.258132+01	\N
15070	19188824-b606-4f80-8d1d-0586b138c95a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.272719+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.272679+01	\N
15071	795d256c-2c2f-45e3-a872-0b91dddb2ac7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.287241+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.287201+01	\N
15072	4ea37251-d423-42c3-a551-4bc6b6450c86	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.301938+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.301898+01	\N
15073	fbefd2dc-e7b3-46ea-9800-7d35c0ef959a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.316565+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.316525+01	\N
15074	7812a394-c245-493d-b05a-557a6c6a5f83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.330805+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.330764+01	\N
15075	3934a402-b3ea-469e-9cf6-753dd7e9a49a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.345839+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.345798+01	\N
15076	b7a5a4c0-363b-4337-849e-28452cd1adcd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.360367+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.360326+01	\N
15077	042614de-f4e9-4674-8f64-f90510913077	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.374614+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.374575+01	\N
15078	51ad1f12-cffd-4def-bf71-e4d7b8f70dcf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.389943+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.389903+01	\N
15079	912375be-dbcc-4290-b300-2fb5aa366808	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.404548+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.404507+01	\N
15080	9e9a6384-36d5-45b0-8884-d2662a9ab27a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.419604+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.419564+01	\N
15081	c8913e95-f866-44c1-87e8-573b6dcde587	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.433899+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.433859+01	\N
15082	239c948d-b209-4175-9e55-af2bc6362e4f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.448592+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.448551+01	\N
15083	4aa0f98c-e7ea-4a01-8684-84799ffb4e96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.462672+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.462632+01	\N
15084	a44212cd-1adf-482e-b033-36fec805ae0d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.476711+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.476671+01	\N
15085	e518e1db-d74a-4a1a-b294-9692ae98771f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.490813+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.490772+01	\N
15086	0b81efe8-0fbc-4e14-84e1-2287d36aab87	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.505165+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.505123+01	\N
15087	50657cbc-374f-465f-a693-c42f496263ee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.520451+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.520412+01	\N
15088	8fd59383-e122-4ac6-808d-d2e33c930da3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.534808+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.534768+01	\N
15089	7e98c295-6664-48fd-a2b3-19c513d0093a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.548803+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.548763+01	\N
15090	6130d406-5003-40a5-b4d2-90fd52464224	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.56309+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.563051+01	\N
15091	f6a9bcf9-d385-4132-b3e9-ac9b286365f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.57716+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.577118+01	\N
15092	8e1da199-7cfe-4751-bd7f-0213e68bcbf2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.591719+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.591679+01	\N
15093	6efaccc8-1678-4ebb-95d5-21538bb7030b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.605879+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.605838+01	\N
15094	791b9d76-0d60-486d-b165-aa02bbfd933e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.620298+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.620257+01	\N
15095	51d9e335-e533-4231-8fac-8fbccfa78dc8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.6352+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.635159+01	\N
15096	32035788-79c6-492a-acba-f9fe549a9707	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.652565+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.652524+01	\N
15097	4d07bb81-46d1-49d2-8a69-528c80c1e483	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.670395+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.670355+01	\N
15098	3fe43bf8-5456-43f5-8961-4e2ed1a479ce	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.684889+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.684849+01	\N
15099	fd2394d0-7c54-4845-a041-b9d8151443a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.700333+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.700292+01	\N
15100	bee07577-d06e-47d8-9c96-a8202d6ec5a2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.714887+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.714848+01	\N
15101	501ef156-464f-44be-ae7a-9391dfcdc43d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.729228+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.729187+01	\N
15102	177621ab-265d-441c-8121-f0d820120f9e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.743697+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.743657+01	\N
15103	b4a1685a-8ddd-4b0b-a3da-4f053379e68d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.758355+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.758315+01	\N
15104	70908584-ca5d-465d-99ac-dcd14e4c512f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.773052+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.773011+01	\N
15105	939c2e8f-318e-4c9e-908b-a934bbab0a9e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.787015+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.786974+01	\N
15106	d2431d05-79a8-4a3b-8fa9-618901e57d5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.800886+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.800846+01	\N
15107	a9b77ac6-bf49-4a29-b05a-4eda9dc566bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.815612+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.815571+01	\N
15108	0afb191a-b65a-42d3-987d-6d576905bb26	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.829485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.829444+01	\N
15109	affd67b3-6d67-4bf1-9be4-b93585746248	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.844074+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.844033+01	\N
15110	f809e3ff-8896-4d6e-9c51-357c9a9662fe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.858153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.858112+01	\N
15111	0925c3f0-bfda-4bca-9944-23507a7f7886	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.872179+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.87214+01	\N
15112	928bf1c8-6acf-45e4-925e-1ed1529c73ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.886128+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.886088+01	\N
15113	e901b213-58b6-47b2-af87-f3baca729a06	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.900183+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.900144+01	\N
15114	c387a030-8e11-4e07-88e2-42a63ec5cd39	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.914232+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.914192+01	\N
15115	1c615f47-b39b-4c64-b269-09f22b7382e8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.928649+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.92861+01	\N
15116	de4129eb-ce60-4ccf-82fb-c9e0a1e8decf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.942728+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.942688+01	\N
15117	9357e9c0-3b69-434f-a943-469f6616e569	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.956739+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.956699+01	\N
15118	0cc44244-db7c-40d8-8b6b-7fe84804925d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.970711+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:09.970671+01	\N
15119	812df9b0-7969-4bb1-bcd5-57b084596301	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.985232+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.985192+01	\N
15120	5fa66431-2af3-4658-803f-3e715b093934	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:09.999586+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:09.999546+01	\N
15121	d703d890-e3be-445f-baa6-795e8bb63560	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.013857+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.013817+01	\N
15122	ab712754-df51-481c-ad70-1fdbaab91905	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.028181+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.028141+01	\N
15123	a3ad1dcb-a686-40d8-9b29-046b58f0020d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.042534+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.042493+01	\N
15124	9d6d684c-e41e-4bba-8637-8627efcab090	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.056828+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.056786+01	\N
15125	52257b61-be15-4f8b-9b63-8561961b8d5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.071264+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.071224+01	\N
15126	c62899da-67ee-49ca-90ed-1955d84e64db	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.086023+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.085981+01	\N
15127	d8aa2fed-f399-4593-a0cb-a71b4d2f8631	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.100298+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.100258+01	\N
15128	147eee5a-fca3-4eb2-91d9-39d7e523d474	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.114455+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.114415+01	\N
15129	57d427cf-91ea-4a83-8a9c-cf1c5fa92fc1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.131575+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.131534+01	\N
15130	f86b8d9b-a7e9-4dce-afb3-0815153872aa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.145908+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.145866+01	\N
15131	0c11157a-6b42-4896-be42-0f9a2fdebef3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.160639+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.160598+01	\N
15132	200de7a3-33d5-4101-8395-805c46c3099a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.174569+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.17453+01	\N
15133	2465a206-4721-408a-9de2-6a7a282b9756	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.188905+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.188863+01	\N
15134	38125141-3b8a-434d-8c5b-e43b06ef1a66	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.203226+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.203185+01	\N
15135	de99f8e5-d996-47c7-a0ab-3cbf736aa407	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.217688+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.217648+01	\N
15136	54cb3b2f-943b-455f-821e-63abbdc2e2a3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.231763+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.231723+01	\N
15137	4a2770d7-19a4-4108-b4e3-b807da85a941	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.245667+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.245626+01	\N
15138	d4a0a855-4cbb-465f-8e83-52b9fec094ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.259836+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.259796+01	\N
15139	7c7f66da-7164-4be7-b638-e51f4df4dabc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.274216+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.274175+01	\N
15140	629b3812-7528-4a49-b4ee-3c41e1327106	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.288246+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.288207+01	\N
15141	9fb6730e-2e41-408a-a189-bf710549be37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.302194+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.302153+01	\N
15142	36ea4124-e5f1-4ab6-8ced-624d7e5d4509	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.319867+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.319825+01	\N
15143	9f48f0e3-295c-4e4c-b586-b6340cc0c697	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.334151+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.33411+01	\N
15144	1fd92759-cf4f-4019-802d-14ce7ab6920d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.348789+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.348749+01	\N
15145	9783b951-43e0-4b74-bc27-7e921d5c4c66	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.363355+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.363258+01	\N
15146	3c56aa96-2401-4f1f-86dd-6689e61e46ae	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.37802+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.377981+01	\N
15147	0d268a13-cd05-4014-86b4-09df7d6e41ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.393658+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.393618+01	\N
15148	b02abc38-84ee-4397-af9b-3b8b16b23e95	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.421218+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.421152+01	\N
15149	834c7365-c42d-4605-a8ae-bf2d5b44bc97	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.443401+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.443359+01	\N
15150	096245a0-20bd-4146-8312-01019cf26f5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.457548+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.457507+01	\N
15151	5e1b62d0-2a7c-46c0-bcc7-454d2e4a952a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.471818+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.471778+01	\N
15152	eeec1bc8-2574-4e7d-bcff-ee0e8fafb50d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.486184+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.486146+01	\N
15153	8f2ad24f-27ee-46ea-ae51-7e315ce750e3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.500721+01	\N	{"children": []}	"()"	"{}"	documents.tasks.index_optimize	celery@mandraw.noho.st	2024-04-02 22:07:10.500681+01	\N
15154	820d730b-c12a-4bdd-a915-8307f6a47ae3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.515919+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.515879+01	\N
15155	8e347061-599e-471a-81f8-7c916226fa31	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.531225+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.531184+01	\N
15156	0259c0c2-b253-4ad3-b16b-2ceaf2893b8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.546727+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.546689+01	\N
15157	a7b3e8df-2b58-4785-bb63-22b4bf5d6fe8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.560896+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.560855+01	\N
15158	648c76dd-6b7f-4aea-acce-494cef0493ec	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.574893+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.574852+01	\N
15159	b7c7ccb9-52d0-4b93-b138-ab96e5eaea91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.589381+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.589342+01	\N
15160	aefcb015-f0b7-43b4-963b-d6fbd9f00a09	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.604463+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.604422+01	\N
15161	5f7f07a0-d48e-4c71-a0b2-721024a6be1d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.618823+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.618784+01	\N
15162	cc43ceb0-6988-4e27-8ddb-a2ba1d8132f1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.633033+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.632992+01	\N
15163	d22bff52-a242-4ec4-ac8c-c98bd09a4a73	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.647695+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.647655+01	\N
15164	15645e3c-acce-4190-9d5d-bbb8ef32656c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.662445+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.662405+01	\N
15165	b22ee989-908c-4baf-bf04-214bdff138e9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.67662+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.67658+01	\N
15166	71ce2f2e-bbb0-4481-a3ec-42d3a589cae0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.690872+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.690831+01	\N
15167	38681a89-2e81-474d-84ff-a7035583e9d4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.705575+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.705535+01	\N
15168	28c057e5-b570-4b15-85c0-f496990bdccb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.720653+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.720614+01	\N
15169	6b8f01aa-375f-412a-9493-923222e1829b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.734605+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.734566+01	\N
15170	21c6fdbe-a687-404b-9691-333e59660244	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.749145+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.749105+01	\N
15171	0c23d831-9074-4869-8037-20d22392397b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.763542+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.763501+01	\N
15172	a79348b2-a3b3-419a-b59f-c4b44047c885	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.782385+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.782345+01	\N
15173	85892013-577f-45c0-9152-d0d0b8cf64cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.79664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.7966+01	\N
15174	07da5cb6-e1a1-4399-a3ce-0f645859fc4b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.810624+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:07:10.810584+01	\N
15175	6d688c7c-3ee4-4010-bbf6-8c64c913fb87	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.824829+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.824789+01	\N
15176	7ed40534-c2f1-4300-97d3-35714e30ea07	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.839047+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.839008+01	\N
15177	83d5c1c0-7608-4eaf-b6dc-be29e138a1f1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.853153+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.853112+01	\N
15178	54fea211-3cf8-4448-9a95-3f2c9ce4976e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.869149+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.86911+01	\N
15179	c02205a9-c4d9-461a-a00f-dff030bc874d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.883702+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.883661+01	\N
15180	d579e353-91c1-497c-a529-b1a18ad04af9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.897484+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.897445+01	\N
15181	74659687-cbd1-4d29-b776-8ef4982022ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.912041+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.912001+01	\N
15182	a68728a6-663f-4f45-8ca8-5dbe904c8475	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.928505+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.928465+01	\N
15183	8fabfaa2-a64d-4800-b7e8-ae3a12752949	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.942439+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:10.9424+01	\N
15184	e46421f0-f3b3-44e8-9878-0656ac3d1dbe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.956403+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.956364+01	\N
15185	827f62e9-2a81-44c8-a98e-c909a0b158a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.970427+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.970387+01	\N
15186	598f8215-ba27-4de6-a9eb-448720572e3a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:10.987485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:10.987444+01	\N
15187	2909d016-4209-4639-b4fd-5c0a3f6d0ac5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.001207+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.001165+01	\N
15188	732737a0-4337-4b76-86c3-cba83401aa63	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.015714+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.015674+01	\N
15189	a627c368-8ddb-40a0-8e39-68cbbd4dd4df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.029504+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.029463+01	\N
15190	f2e477b9-bc91-48a8-946c-244a29fad737	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.056136+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.056089+01	\N
15191	1c79087a-3d88-4de7-bc17-ae4f281a1a35	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.075046+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.075006+01	\N
15192	f9312391-d5d8-42ce-a101-4e7a8f9ff932	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.088979+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.088939+01	\N
15193	a71401a5-0cf2-4173-842b-23a8a8626b78	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.102809+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.102768+01	\N
15194	07b8ef69-d090-4888-8558-2f2d7119eecb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.123091+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.123051+01	\N
15195	b32d0a69-0085-4d2c-989d-1ffa0b80e609	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.13716+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.137119+01	\N
15196	da975e65-cf1a-40b9-b113-b02c9bd52b39	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.151091+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.15105+01	\N
15197	1bfee4cc-d2f1-4982-a650-4b63654e4e3e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.165691+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.165645+01	\N
15198	3738c491-0943-4a21-a6fe-b86f8bfba6dc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.181216+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.181175+01	\N
15199	018fe2f9-d375-442c-9230-9704618420eb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.196014+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.195974+01	\N
15200	e8dea660-bef3-42b9-ac74-ff656ef9bffd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.210369+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.210329+01	\N
15201	cafe2aed-6d69-4b77-b776-4b01811db58f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.22461+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.22457+01	\N
15202	05c9e769-9ade-43a0-8fdb-ae0e80e1fb8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.241131+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.241075+01	\N
15203	a62a3c80-006a-47b2-94f8-9653e1ab4312	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.263531+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.263473+01	\N
15204	8df79206-73f7-4d48-b36e-29c7f183146c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.286317+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.286262+01	\N
15205	021ad108-5419-4e62-95e5-48a4e0546c62	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.306203+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.306147+01	\N
15206	498d08bf-d3ee-46f2-9b00-46b7036d6944	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.326258+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.326203+01	\N
15207	61ad1d32-649f-497b-9250-526f076bc42d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.343457+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.343416+01	\N
15208	9588321f-bee2-4822-b121-ccde00003d80	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.357882+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.357841+01	\N
15209	2cf04b97-f68d-43e6-9950-846f80c0d96a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.373081+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.373039+01	\N
15210	9d7eedb1-ace5-4c32-9b28-590556717b50	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.387919+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.387879+01	\N
15211	f5446061-394c-4558-94a8-43480f3a7fa7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.402228+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.402189+01	\N
15212	78f28299-6c8e-45a4-abca-5d555385b242	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.417025+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.416983+01	\N
15213	02d051fd-fc26-476a-be12-536bd149c7f0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.435704+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.435658+01	\N
15214	a674b0e5-a98d-4053-a885-b726497cb32d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.453349+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.453308+01	\N
15215	43f6d400-6955-4bbc-aea1-2c5420a9f6ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.467679+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.46764+01	\N
15216	9c2a38e9-d75e-4064-a08d-8e0aaf2aa125	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.481896+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.481856+01	\N
15217	3c44e631-65d7-44f6-8aed-4cb395840211	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.496366+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.496326+01	\N
15218	fa8ac422-8e37-4919-b78f-bdc42257b215	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.510695+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.510655+01	\N
15219	8c896241-dd1f-4247-b0db-937885a699dc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.524952+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.524911+01	\N
15220	aad3c147-d7b2-4a2e-8f22-467f6da705d4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.539068+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.539028+01	\N
15221	6d4ca8b3-a413-4585-9a9b-4a5c3d7e5cfe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.553138+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.553097+01	\N
15222	35d7333e-8f5b-4c6e-b5b9-ca793c5f0d45	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.567682+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.567642+01	\N
15223	bca20ac9-0b51-48ff-a83d-51c9d62f5c45	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.58156+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.581521+01	\N
15224	1ffbdba4-ef4d-424b-8a08-1bf899d0492d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.595559+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.595517+01	\N
15225	208fb29c-f36b-4002-8cf6-e1438eb267a5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.609882+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.609842+01	\N
15226	a465c42d-6521-4ceb-a7b5-277e1dee2697	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.625775+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.625736+01	\N
15227	1a47798d-b037-4244-b585-ff44f1b5e9a7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.64018+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.640139+01	\N
15228	94d7f6c6-aace-4b2e-be98-a0737054543a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.654926+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.654886+01	\N
15229	d863020a-632d-4aef-92c0-6a1089552907	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.669592+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.669552+01	\N
15230	0c171c0b-7b87-4353-a9aa-ec1e19f865c1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.684298+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.684259+01	\N
15231	0c302539-1697-40d2-81b1-ff23ca4685cb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.698585+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.698544+01	\N
15232	28502d93-311d-423a-ace8-91f02b23dfa8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.713125+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.713085+01	\N
15233	e1f76645-a7f4-45ec-b977-061725e7c5d2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.728364+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.728324+01	\N
15234	b8a483f8-b601-480d-8da9-5bef915aab69	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.743085+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.743039+01	\N
15235	0c2cb6c7-7e69-44b3-86c3-d08e0495d91d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.758567+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.758527+01	\N
15236	de840586-0211-4b08-8523-b973140c982d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.773313+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.773274+01	\N
15237	4599c754-d630-45c5-9286-8043a44a6a57	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.789067+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.789026+01	\N
15238	8e186c8d-a09e-4324-bda5-5d63dafa3ff2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.80323+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.803185+01	\N
15239	d7ffdaea-ff38-4a10-a5d7-523499ccb27c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.820907+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.820864+01	\N
15240	4aace422-e7b0-4b66-8e92-23b9f2993922	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.835393+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.835351+01	\N
15241	e8229f46-7ed0-47dc-aa08-cc3db93e19f5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.849593+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.849553+01	\N
15242	d4e74de3-a831-4a06-a170-203343b9aaa2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.864471+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.86443+01	\N
15243	80483fb5-c65e-4b74-956f-e72d9cce5131	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.879088+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.879048+01	\N
15244	19ec89ec-834e-4758-b3da-b9df0b8810e0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.89375+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.89371+01	\N
15245	5838e4b4-f79e-4daf-be01-3d281d97324b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.908479+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.908438+01	\N
15246	46ff6274-35fa-4a5f-856b-ec1c6dc7f375	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.925394+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:11.925354+01	\N
15247	d37c69dd-9e0d-4c66-bf0e-b0e55be835ad	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.939376+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.939261+01	\N
15248	d4b3a0e1-d654-4625-8dd8-0aeb9ef19f8e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.953459+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.953419+01	\N
15249	c9421474-0201-4150-ab7f-7d6c5048338e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.967785+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.967745+01	\N
15250	784742ef-41e3-4269-966a-95baf6ce4f42	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.982171+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.98213+01	\N
15251	291f1c01-0dfe-4b3d-914b-90d7be77af59	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:11.996364+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:11.996323+01	\N
15252	1171eb9a-fea2-4360-bbd9-19bc41099ba2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.010422+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.010381+01	\N
15253	8743ebd6-6021-4f26-abf2-cdf770c39e89	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.024765+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.024725+01	\N
15254	e0c37e35-3fab-47cc-85ec-bf19dbded9ed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.038667+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.038626+01	\N
15255	03f61a09-f882-417c-a3b8-136f696b6074	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.05295+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.05291+01	\N
15256	4939dca8-4d33-45c1-800e-e100002741d6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.067274+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.067234+01	\N
15257	eac43d82-3572-40c6-91b2-aee797b7dd07	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.081299+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.081259+01	\N
15258	893bf8e2-6deb-4f1d-87db-0d1bd31db5d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.095875+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.095835+01	\N
15259	b37077aa-581f-4247-b0a0-7d06d18f7b02	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.109849+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.109808+01	\N
15260	29273f2e-a774-4565-a4f8-7973740509d7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.124062+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.124022+01	\N
15261	410d6936-9df2-401c-acf1-dbc52c20e30b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.137922+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.137881+01	\N
15262	f93cf494-c075-41f3-b695-ef5fc9eab6af	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.153391+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.15335+01	\N
15263	4cb5a76f-3c87-45ba-8ad4-5c3367ecd8c9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.171178+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.171134+01	\N
15264	85264c5e-c1f6-4b97-a487-d7c3c9ba185d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.186701+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.186661+01	\N
15265	ddc85260-46e1-4923-a87c-f7fc9b65a08a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.201386+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.201345+01	\N
15266	46857923-fa1e-42fa-a21f-19e00ce69b5d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.215882+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.21584+01	\N
15267	57eca597-f45d-4ab1-8a62-f83f6de39656	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.23018+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.230141+01	\N
15268	8ec4dda8-ef97-4558-b816-4041c8be709c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.244401+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.244361+01	\N
15269	712fe99a-4e7a-4b27-a847-82d1c1522e37	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.258591+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.258549+01	\N
15270	8e52f693-e1a4-4266-86f9-91702702293e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.272968+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.272928+01	\N
15271	3c89d9e3-27da-492a-bae3-7d6cf6cdcb08	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.28703+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.286989+01	\N
15272	c850d6cd-2de5-4d63-b51d-946bfb05a2af	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.304408+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.304367+01	\N
15273	a4c5b0c8-8b10-4e5e-a275-fc1c6fa5480b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.319465+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.319421+01	\N
15274	ba7da026-4f0e-4d9c-b452-7c70b5dd78b2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.333899+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.333861+01	\N
15275	54c7ab3c-b661-4735-8830-0ef666fbe33f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.348172+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.348132+01	\N
15276	73993eda-bc11-4ec6-b540-d2785bfc50b6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.363368+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.363269+01	\N
15277	193acd19-def6-49e2-ba84-a017648ee31e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.37816+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.37812+01	\N
15278	fd3bff8f-ec8b-41d9-8cf1-b59e712ed837	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.41428+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.414242+01	\N
15279	388880ab-26e8-4557-b217-cbe11964d4ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.429001+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.428961+01	\N
15280	3e06d692-e11a-440c-bed9-58a95d42069a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.443929+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.443888+01	\N
15281	5f621350-a8ef-4471-8e6e-73031a1a4d6d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.458657+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.458617+01	\N
15282	237f6334-9067-47a5-88bb-770fe033aa7c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.47373+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.473564+01	\N
15283	ed3f803a-e9dd-489a-bb1f-4c0cd4516888	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.491665+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.491624+01	\N
15284	e04a0b6a-770f-483a-a474-ebaf03af3fc2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.506334+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.506294+01	\N
15285	95df8186-8070-4d47-a885-357081d654ab	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.5212+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.521161+01	\N
15286	fbb7b0b0-0a79-45af-ba05-5d7a705411e5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.535916+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.535874+01	\N
15287	cbf4556b-a910-4cd7-8bdf-e5e8097ab23d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.549899+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.549859+01	\N
15288	66f2c872-875d-453a-a222-42932c393879	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.564248+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.564207+01	\N
15289	a5051b7b-8476-443b-82db-c01ba861421c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.57845+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.578408+01	\N
15290	e5675cfb-adc2-4a27-b5c9-672ac68d3e82	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.592822+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.592782+01	\N
15291	1d9d85bc-ab48-4f03-abe1-56564c2e3dc7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.606808+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.606768+01	\N
15292	b60881bb-b206-44e3-b1b5-8c6ea2488f60	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.621033+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.62099+01	\N
15293	de9bc457-6bc9-44da-9057-a17460959e96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.635554+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.635512+01	\N
15294	5f7c9ccd-84a0-48e9-afd1-3e152e04a9e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.649587+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.649547+01	\N
15295	d37880fd-c045-4fa7-b718-73fb724f162f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.664445+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.664405+01	\N
15296	61ce9438-cffc-4159-b364-8fcd775fdd61	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.678547+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.678508+01	\N
15297	4083ede4-cb6f-4f63-b1e5-3d140a3accc6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.692664+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.692624+01	\N
15298	e50b3882-0f31-45e5-a22d-65b941eb8882	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.707196+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.707156+01	\N
15299	5b2b9f8b-0a2a-4cdf-8218-8de3c41107b1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.721532+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.721485+01	\N
15300	231d86de-5f20-4f4e-941d-616df8dcea74	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.736274+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.736232+01	\N
15301	1b546100-e789-48fd-a892-4c27383e05b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.750273+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.750232+01	\N
15302	8c980b8a-59e5-421b-a770-bea3f48937b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.764722+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.764686+01	\N
15303	a276d1b3-b632-4cc4-8451-20e48ed98f5a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.778834+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.778793+01	\N
15304	1193d237-580f-4a7a-9283-99e5aa704aa6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.79299+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.792949+01	\N
15305	e0daa6bb-dd9f-41fc-ae65-0551c8cc044e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.808354+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.808314+01	\N
15306	b4cefa01-16ea-477f-8d07-ec3fb5ab8877	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.822644+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.822604+01	\N
15307	381ba2a8-02e1-46e0-bead-9ff99d2c714a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.836735+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.836695+01	\N
15308	65167bae-bcfd-4ae0-8376-b9b11745f346	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.850726+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.850686+01	\N
15309	1bb84ed0-9724-48f6-ae57-f002f1deff91	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.865171+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.865132+01	\N
15310	51c08ba5-56fd-40c4-981e-5b9d5ce1302d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.881461+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.881421+01	\N
15311	b1886bbc-aa6b-4a9a-8651-9c5a766200bd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.895913+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.895872+01	\N
15312	9f693f5d-bcac-43e2-8620-aba026ab5924	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.909856+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.909817+01	\N
15313	b1e9047c-adf5-4510-a0de-693c83dc2613	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.926014+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.925974+01	\N
15314	51b233f9-741a-47db-8649-ce8171726dca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.940577+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.940537+01	\N
15315	242117d1-82c4-482f-a14d-ca5c222c0163	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.961094+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.961054+01	\N
15316	a4bb25e6-2f00-44d0-832e-0f1a9435ebb8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.977202+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:12.977146+01	\N
15317	ec6a198d-aaad-4a62-88cd-d4a0d9984f84	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:12.998828+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:12.998782+01	\N
15318	cde6932d-0119-4d73-b5ab-0257531de6f6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.018399+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.018358+01	\N
15320	d7fa5c63-31b5-4e81-bf6e-8ebb4a240539	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.038478+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.038433+01	\N
15321	7af3255d-4c1b-41e3-88e2-d7b1e287f8cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.055181+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.055139+01	\N
15322	48f53386-0171-4bb7-9680-9b2690483fdc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.07263+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.072553+01	\N
15323	5632a0b1-74b7-47e0-9b9f-2c7e501c8552	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.091232+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.091187+01	\N
15324	940eea73-fa82-478c-90dd-c7b14c426819	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.111964+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.111921+01	\N
15325	263bdee1-d2de-4c23-a14e-083360f15ebd	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.129281+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.129235+01	\N
15326	b6f14fc5-24f9-4b2a-9e7b-eeb8c5567f0d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.146177+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.146137+01	\N
15327	3aca2ca8-af63-4ac0-9bac-b38955c6aa67	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.161536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.161496+01	\N
15328	22bcd971-6ef1-4675-b986-4243f45a6f94	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.176108+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.176067+01	\N
15329	9e4ec101-76c0-49b9-826b-7e46965e0a6a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.190867+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.190827+01	\N
15330	f0136062-fbd3-435f-878f-1b5d0756349a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.205413+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.205373+01	\N
15331	e14378b2-235a-47c1-b99c-5692504797ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.219789+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.219748+01	\N
15332	d91fdd83-7a1f-484d-93d7-fbc5ab7c4bb9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.234613+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.234571+01	\N
15333	34d66659-8430-48b0-873e-d4ac906f18b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.249185+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.249145+01	\N
15334	b02741a4-8886-4038-95f0-28d7e25343cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.269957+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.269911+01	\N
15335	7a846781-5c2e-4784-87da-4482b9d526a8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.284448+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.284407+01	\N
15336	b5247778-e2fb-4e18-9358-6ea0a21f9ced	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.518486+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.518374+01	\N
15337	4c7cc72a-fc1d-41b3-9551-b1ff9f4fe619	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.537461+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.53741+01	\N
15338	438c2043-14bb-4145-9188-091192b4d732	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.554266+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.554223+01	\N
15339	8508e7d6-dae7-4185-accf-bda14cc92523	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.57035+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.570308+01	\N
15340	62de2842-8820-4479-aeb8-349763fecb0a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.587977+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.587932+01	\N
15341	e0fbeb23-9429-410d-a1ce-e204bbf2dbd8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.605597+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.605551+01	\N
15342	55aec74d-76b8-4573-8e1d-0544c9de7f79	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.622576+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.622535+01	\N
15343	cef2be38-0437-443a-9ee6-bd631b03515e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.637183+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.637143+01	\N
15344	85e392b8-2b11-4328-8497-ffc1aea5b962	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.65295+01	\N	{"children": []}	"()"	"{}"	celery.backend_cleanup	celery@mandraw.noho.st	2024-04-02 22:07:13.652908+01	\N
15345	f46437e1-fac1-4627-8c63-537718946443	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.667854+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.667813+01	\N
15346	846217db-ba3e-4d85-b0df-549177722d11	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.682633+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.682592+01	\N
15347	8e0ab932-2ee0-465d-9475-ba7569dbf458	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.69726+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.697219+01	\N
15348	44facbb7-49ca-49bb-8f7c-08e0918115d9	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.711727+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.711686+01	\N
15349	1b678216-ed1e-41f0-b53d-3e132cc57e0f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.726847+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.726806+01	\N
15350	07010913-5844-479a-b82e-62280cf9c3ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.74095+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.740909+01	\N
15351	1b6781f3-bd21-4370-8f85-2103ac875b6e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.754934+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.754893+01	\N
15352	1a4e8278-0fb6-4c4a-8100-6e0b893e127d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.769397+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.769356+01	\N
15353	e7e7d159-2b02-4aa9-a9a9-05d2a33faeca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.783667+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.783625+01	\N
15354	7beafcdf-3816-4401-a83e-e3c7b03dde63	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.797815+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.797775+01	\N
15355	1887f8c5-7149-4c31-a148-0e539e3449df	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.812371+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.812329+01	\N
15356	c0260a10-efb4-40bb-9288-9f92edf47ad1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.826383+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.826343+01	\N
15357	3dcfa8fc-cbf9-465a-9a4e-868dcb05f42f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.840311+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.840269+01	\N
15358	a712c933-be3b-47a5-b755-1f5dd81c89a7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.854976+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.854935+01	\N
15359	f5a479e6-63f5-4c6c-a361-d8530ff6f4d4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.869763+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.869723+01	\N
15360	d9221395-fc89-435d-94df-d34d8d63a29e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.883806+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.883766+01	\N
15361	ee493fc6-306d-4b2d-96d7-4be55a424996	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.89808+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.898039+01	\N
15362	d5bf3acc-5211-46f0-aa0b-8d49fcfd9039	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.912632+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.91259+01	\N
15363	6675eb90-346d-43c9-acbb-052202c864b4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.927164+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.927122+01	\N
15364	578e3169-303e-44c3-814b-803a430c0ace	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.941508+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.941468+01	\N
15365	339f949c-cc67-420b-a023-09cac61281c6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.956194+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.956154+01	\N
15366	a8992c34-c125-447d-90a8-53aa907d223a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.970413+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:13.970373+01	\N
15367	6059edb3-fdad-4419-b785-be9caff48611	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:13.987664+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:13.987623+01	\N
15368	3cfc62a5-5e87-45d2-b3c9-0abc09293f96	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.002621+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.002581+01	\N
15369	20caf91d-0329-4e4d-b635-1c661ac4d44b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.016983+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.016942+01	\N
15370	cd7f22d4-127b-4ad7-8b0c-81fc8a3a46c5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.049746+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.049618+01	\N
15371	cdef9af8-0c45-473c-a323-b4d2010e9c18	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.072166+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.072121+01	\N
15372	0f0578e2-f027-4dac-b87d-0d61563b8c8f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.08663+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.086587+01	\N
15373	f898b62e-728c-4799-b916-4fef130ff744	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.100725+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.100684+01	\N
15374	6a12bbd0-18ff-4c48-aefa-9737ea70417b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.114587+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.114547+01	\N
15375	22360748-ff06-4d63-b9a7-fb26ec0af1bb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.128644+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.128603+01	\N
15376	3aad29b7-8550-4a48-aaef-ecae984f866e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.142934+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.142893+01	\N
15377	b0e09465-9231-4b5b-9960-7a9a076306ca	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.157454+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.157414+01	\N
15378	f9e3cc3a-406b-4d33-915c-474a854ddc36	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.171815+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.171772+01	\N
15379	1a646b98-ebac-4b89-8db3-d87dc84b0094	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.186572+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.186531+01	\N
15380	60bb4f54-e0ca-4bc7-bc31-acd6fd5b2235	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.20105+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.201009+01	\N
15381	f689526e-10de-46dd-8757-166cf546cbbf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.218664+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.218623+01	\N
15382	d27db234-b4e7-4847-a05b-0d1d8dd448e4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.232997+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.232956+01	\N
15383	144b13ce-b680-420e-ad2c-a5576433a35d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.248186+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.248146+01	\N
15384	65aaa325-e005-4708-bccc-a887e836eb68	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.262592+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.262551+01	\N
15385	eff2079f-d5b8-40da-bcac-c25731a24a38	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.278187+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.278146+01	\N
15386	ae6530a3-013c-48fd-9f10-e596616c2cee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.293869+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.293828+01	\N
15387	5df9e661-e056-48f2-b02b-36638d333432	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.308338+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.308297+01	\N
15388	1e673247-ab3c-40a7-aefe-a1ceeeb044e2	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.322671+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.32263+01	\N
15389	09caab16-81c8-4575-8a9b-40c9764cf991	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.33729+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.337244+01	\N
15390	cf50dda5-2cbf-4e38-9b83-7565b186a605	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.351833+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.351792+01	\N
15391	c1f8d411-b7a4-410c-9e2c-b04b3a9afd1f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.366367+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.366325+01	\N
15392	c574d903-df00-486c-b89e-eea4981d20fe	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.381086+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.381046+01	\N
15393	cecb6cf3-acbf-4e59-b528-547b269c4bbb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.396052+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.396011+01	\N
15394	e2b4319b-01f2-44a5-a2de-93937e8f31b8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.410225+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.410184+01	\N
15395	c0528d51-9ea5-4c7e-947a-969c43067713	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.424745+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.424705+01	\N
15396	9a2c1be4-fdbb-47aa-a7ff-c55330291ee0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.44016+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.440121+01	\N
15397	d0cb7ba4-e616-455c-bf82-8a079b087423	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.454636+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.454596+01	\N
15398	90e2ea9a-0b65-4aef-ae8a-c9d93175c65a	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.469407+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.469364+01	\N
15399	14918ed6-ae9f-480d-9949-2c216bfc5eb0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.483922+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.483881+01	\N
15400	2a4e7648-50a2-40ca-9ec2-18b084e4843c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.4991+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.49906+01	\N
15401	28be64ed-f8a2-47f9-9e09-dbac5a52239b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.513694+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.513653+01	\N
15402	219a40ee-6d2f-428d-ad4f-ccd770e4f697	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.528536+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.528496+01	\N
15403	af46ccbc-5c1a-4fcd-a087-694fdcd0b816	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.543093+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.543053+01	\N
15404	5b14e5a0-a215-433e-a3db-af9789d2eec7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.557776+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.557735+01	\N
15405	0e708cc8-6dee-4e26-b15c-a7551b26e046	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.572865+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.572824+01	\N
15406	72248be3-0268-4cb9-9873-6d2f411b7d23	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.586896+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.586856+01	\N
15407	2c3cc917-c267-481a-b281-e4bc12ac392d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.600919+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.600878+01	\N
15408	ca2b7776-1c0d-409f-8f8e-3270f1949bbf	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.615422+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.615381+01	\N
15409	96745c28-c0d0-4de1-bbc6-135b9000188f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.629882+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.629841+01	\N
15410	37190056-9e49-4e3b-a688-26217c72b1ba	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.644536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.644495+01	\N
15411	30deb889-e69f-4c5d-8cf4-0239b05c6902	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.658747+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.658706+01	\N
15412	11b7a5ea-6a67-4537-b5ec-34a67c2f0c93	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.675397+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.675273+01	\N
15413	5f9cd2b5-b0a5-4d23-94d5-82f853f0c339	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.70535+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.705309+01	\N
15414	ff2143d9-5d0e-401b-b537-c118243000fa	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.71997+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.719929+01	\N
15415	77481afe-fe8d-4531-a62e-a28a2d24e9c6	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.734357+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.734316+01	\N
15416	a95997b4-1cb9-4859-9af7-f4d4d73bd629	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.749143+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.749103+01	\N
15417	43b92118-eb96-4455-99bb-197e8d538409	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.763759+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.763718+01	\N
15418	27b1eae6-a81b-4acb-b81e-95400135a597	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.778361+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.778321+01	\N
15419	019e170f-1cd5-4812-b62c-110623b7794d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.79255+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.79251+01	\N
15420	de4839d9-c131-4616-8b26-6ea66c7ba148	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.806507+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.806467+01	\N
15421	19d4880e-e35e-4659-92e8-71376b669aa3	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.820823+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.820781+01	\N
15422	15112b80-dc46-4807-848b-05b9b63bd1fb	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.834873+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.834833+01	\N
15423	e9399083-1cb5-40f2-a50e-c040a88db320	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.853214+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.853163+01	\N
15424	b5cab51f-0bb5-4ddd-8aef-88357481ef83	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.870129+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.870089+01	\N
15425	b3fefc4a-30b0-4596-800e-4289c6f28826	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.886472+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.886429+01	\N
15426	082e3130-07c7-4ae0-aeab-ba8842da862c	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.901093+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.901052+01	\N
15427	a912de60-0fca-496e-adcf-f487c29556c7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.914994+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.914955+01	\N
15428	d934de4f-0956-47ec-b622-048e7b976b23	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.929016+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.928976+01	\N
15429	5418019c-fa33-449c-9762-144dd8ab410e	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.943493+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.943449+01	\N
15430	703eab6a-1250-42bc-8a5a-1f343803bc25	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.957582+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.957541+01	\N
15431	e5717afe-26d1-45b6-af21-f194f5227585	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.971594+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:14.971554+01	\N
15432	07273d18-1897-438d-8af1-bbfce004b2b1	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:14.985959+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:14.985913+01	\N
15433	41f966db-8a2b-4edc-8ae8-d1376f912c01	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.000305+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.000264+01	\N
15434	57dd8733-d246-4f52-b551-64057535393f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.014318+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.014274+01	\N
15435	9ef226ec-ce25-471b-9f99-149cf5f4659d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.02838+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.028339+01	\N
15436	70e754c4-c40b-43b0-9a54-1f7df61d32bc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.042833+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.042793+01	\N
15437	71ead650-b32b-4acc-a263-e898ab9433db	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.0574+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.057358+01	\N
15438	1141742f-9d40-442a-9213-a9d6cec922f0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.071636+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:15.071595+01	\N
15439	b4697591-b75d-478c-98bb-c2474025c01d	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.086047+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.086006+01	\N
15440	130e7984-aa12-466c-89f3-9497f1490922	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.100265+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.100224+01	\N
15441	aca3af1c-8947-4f47-bcbc-9a6e629974a4	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.114862+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.114821+01	\N
15442	e3c8c851-3920-4caa-af40-1bbfe235c141	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.132275+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.132236+01	\N
15443	5b512bb1-bcfe-4a22-911a-c1511a4cc0b0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.149563+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.149523+01	\N
15444	3732d605-029c-4815-9a62-f0934470f48f	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.164425+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.164383+01	\N
15445	ab3c80f7-881e-48e0-ba14-9440c65340cc	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.179043+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:15.179002+01	\N
15446	3219e8f8-6b98-43eb-9447-2f3dd093af53	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.193705+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.193664+01	\N
15447	681baa41-f13d-4645-b3b5-48a9a9424a8b	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.20777+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.207728+01	\N
15448	a5344d55-4ce3-4f76-ba20-ae7287e18430	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.221803+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.221763+01	\N
15449	585b2787-809f-4cc6-8f60-41ee4877a747	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.236146+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.236105+01	\N
15450	6248173f-deca-430c-bebc-0d91a8b71cf8	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.250544+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.250503+01	\N
15451	6845d1ac-cbd2-4e94-b102-9b1e8b477828	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.264539+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.264498+01	\N
15452	699505c3-de0c-4c70-af44-8551e7feaaac	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.278708+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:15.278668+01	\N
15453	5467b375-c8ff-4d8a-a5f8-cf8047b90bee	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.2931+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.29306+01	\N
15454	b3ac1c3d-b6d7-40ca-b737-f515820024f7	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.307206+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.307166+01	\N
15455	7f010f1e-1d4b-4daf-b4ab-54af64698cf0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.321305+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.321264+01	\N
15456	186ba4c9-00f0-4bd8-8e81-11b702cf1199	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.336466+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.336425+01	\N
15457	45a29c6f-7d89-49f7-b0d9-c6bc89166122	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.351107+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.351066+01	\N
15458	f820bcf3-ca78-46c6-bf0e-68f89ec70c36	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.365365+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.365324+01	\N
15459	ee442567-9b85-4ec8-bffa-9548bf19fd55	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.380236+01	\N	{"children": []}	"()"	"{}"	documents.tasks.train_classifier	celery@mandraw.noho.st	2024-04-02 22:07:15.380195+01	\N
15460	55258ad8-380b-4ffa-9545-7f8a03ec89c5	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.39485+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.394809+01	\N
15461	3715f7bc-8ccd-4851-9b35-6ae09c29f831	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.408954+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.408912+01	\N
15462	ee49cd39-cdd2-462e-afb6-7484d94cf1a0	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.422988+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.422947+01	\N
15463	455bdb12-5687-43cd-b90f-46c7c26fec27	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.437536+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.437495+01	\N
15464	4980b05b-743f-4feb-bdf7-108f19a4abed	REVOKED	application/json	utf-8	{"exc_type": "TaskRevokedError", "exc_message": ["expired"], "exc_module": "celery.exceptions"}	2024-04-02 22:07:15.452594+01	\N	{"children": []}	"()"	"{}"	paperless_mail.tasks.process_mail_accounts	celery@mandraw.noho.st	2024-04-02 22:07:15.452553+01	\N
\.


--
-- Data for Name: django_content_type; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_content_type (id, app_label, model) FROM stdin;
1	admin	logentry
2	auth	permission
3	auth	group
4	auth	user
5	authtoken	token
6	authtoken	tokenproxy
7	contenttypes	contenttype
8	django_celery_results	taskresult
9	django_celery_results	chordcounter
10	django_celery_results	groupresult
11	documents	document
12	documents	tag
13	documents	log
14	documents	correspondent
15	documents	documenttype
16	documents	savedview
17	documents	savedviewfilterrule
18	documents	uisettings
19	documents	storagepath
20	documents	paperlesstask
21	documents	note
22	documents	sharelink
23	paperless_mail	mailaccount
24	paperless_mail	mailrule
25	paperless_mail	processedmail
27	documents	customfield
28	documents	customfieldinstance
29	sessions	session
30	guardian	groupobjectpermission
31	guardian	userobjectpermission
32	documents	workflow
33	documents	workflowaction
34	documents	workflowtrigger
35	paperless	applicationconfiguration
36	account	emailaddress
37	account	emailconfirmation
38	socialaccount	socialaccount
39	socialaccount	socialapp
40	socialaccount	socialtoken
41	auditlog	logentry
\.


--
-- Data for Name: django_migrations; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_migrations (id, app, name, applied) FROM stdin;
1	contenttypes	0001_initial	2024-01-03 00:57:55.595804+00
2	auth	0001_initial	2024-01-03 00:57:55.882539+00
3	admin	0001_initial	2024-01-03 00:57:55.969563+00
4	admin	0002_logentry_remove_auto_add	2024-01-03 00:57:56.003962+00
5	admin	0003_logentry_add_action_flag_choices	2024-01-03 00:57:56.035254+00
6	contenttypes	0002_remove_content_type_name	2024-01-03 00:57:56.081808+00
7	auth	0002_alter_permission_name_max_length	2024-01-03 00:57:56.110209+00
8	auth	0003_alter_user_email_max_length	2024-01-03 00:57:56.134405+00
9	auth	0004_alter_user_username_opts	2024-01-03 00:57:56.156853+00
10	auth	0005_alter_user_last_login_null	2024-01-03 00:57:56.180264+00
11	auth	0006_require_contenttypes_0002	2024-01-03 00:57:56.187812+00
12	auth	0007_alter_validators_add_error_messages	2024-01-03 00:57:56.209331+00
13	auth	0008_alter_user_username_max_length	2024-01-03 00:57:56.246145+00
14	auth	0009_alter_user_last_name_max_length	2024-01-03 00:57:56.269059+00
15	auth	0010_alter_group_name_max_length	2024-01-03 00:57:56.295723+00
16	auth	0011_update_proxy_permissions	2024-01-03 00:57:56.32278+00
17	auth	0012_alter_user_first_name_max_length	2024-01-03 00:57:56.347117+00
18	authtoken	0001_initial	2024-01-03 00:57:56.402581+00
19	authtoken	0002_auto_20160226_1747	2024-01-03 00:57:56.468734+00
20	authtoken	0003_tokenproxy	2024-01-03 00:57:56.477734+00
21	django_celery_results	0001_initial	2024-01-03 00:57:56.538711+00
22	django_celery_results	0002_add_task_name_args_kwargs	2024-01-03 00:57:56.559572+00
23	django_celery_results	0003_auto_20181106_1101	2024-01-03 00:57:56.570544+00
24	django_celery_results	0004_auto_20190516_0412	2024-01-03 00:57:56.671928+00
25	django_celery_results	0005_taskresult_worker	2024-01-03 00:57:56.702677+00
26	django_celery_results	0006_taskresult_date_created	2024-01-03 00:57:56.750912+00
27	django_celery_results	0007_remove_taskresult_hidden	2024-01-03 00:57:56.762274+00
28	django_celery_results	0008_chordcounter	2024-01-03 00:57:56.821423+00
29	django_celery_results	0009_groupresult	2024-01-03 00:57:57.072052+00
30	django_celery_results	0010_remove_duplicate_indices	2024-01-03 00:57:57.093055+00
31	django_celery_results	0011_taskresult_periodic_task_name	2024-01-03 00:57:57.107205+00
32	documents	0001_initial	2024-01-03 00:57:57.194837+00
33	documents	0002_auto_20151226_1316	2024-01-03 00:57:57.208696+00
34	documents	0003_sender	2024-01-03 00:57:57.345213+00
35	documents	0004_auto_20160114_1844	2024-01-03 00:57:57.370468+00
36	documents	0005_auto_20160123_0313	2024-01-03 00:57:57.384163+00
37	documents	0006_auto_20160123_0430	2024-01-03 00:57:57.513667+00
38	documents	0007_auto_20160126_2114	2024-01-03 00:57:57.548266+00
39	documents	0008_document_file_type	2024-01-03 00:57:57.575542+00
40	documents	0009_auto_20160214_0040	2024-01-03 00:57:57.595816+00
41	documents	0010_log	2024-01-03 00:57:57.62824+00
42	documents	0011_auto_20160303_1929	2024-01-03 00:57:57.741159+00
43	documents	0012_auto_20160305_0040	2024-01-03 00:57:57.777994+00
44	documents	0013_auto_20160325_2111	2024-01-03 00:57:57.821037+00
45	documents	0014_document_checksum	2024-01-03 00:57:57.936706+00
46	documents	0015_add_insensitive_to_match	2024-01-03 00:57:58.001445+00
47	documents	0016_auto_20170325_1558	2024-01-03 00:57:58.020078+00
48	documents	0017_auto_20170512_0507	2024-01-03 00:57:58.044031+00
49	documents	0018_auto_20170715_1712	2024-01-03 00:57:58.060917+00
50	documents	0019_add_consumer_user	2024-01-03 00:57:58.102622+00
51	documents	0020_document_added	2024-01-03 00:57:58.291566+00
52	documents	0021_document_storage_type	2024-01-03 00:57:58.320178+00
53	documents	0022_auto_20181007_1420	2024-01-03 00:57:58.396766+00
54	documents	0023_document_current_filename	2024-01-03 00:57:58.455246+00
55	documents	1000_update_paperless_all	2024-01-03 00:57:58.660572+00
56	documents	1001_auto_20201109_1636	2024-01-03 00:57:58.705768+00
57	documents	1002_auto_20201111_1105	2024-01-03 00:57:58.728503+00
58	paperless_mail	0001_initial	2024-01-03 00:57:58.881558+00
59	paperless_mail	0002_auto_20201117_1334	2024-01-03 00:57:58.925314+00
60	paperless_mail	0003_auto_20201118_1940	2024-01-03 00:57:58.973699+00
61	paperless_mail	0004_mailrule_order	2024-01-03 00:57:59.005351+00
62	paperless_mail	0005_help_texts	2024-01-03 00:57:59.044828+00
63	documents	1003_mime_types	2024-01-03 00:57:59.186242+00
64	documents	1004_sanity_check_schedule	2024-01-03 00:57:59.230416+00
65	documents	1005_checksums	2024-01-03 00:57:59.26907+00
66	documents	1006_auto_20201208_2209	2024-01-03 00:57:59.323998+00
67	documents	1007_savedview_savedviewfilterrule	2024-01-03 00:57:59.431269+00
68	documents	1008_auto_20201216_1736	2024-01-03 00:57:59.506085+00
69	documents	1009_auto_20201216_2005	2024-01-03 00:57:59.571622+00
70	documents	1010_auto_20210101_2159	2024-01-03 00:57:59.592376+00
71	documents	1011_auto_20210101_2340	2024-01-03 00:58:00.435675+00
72	paperless_mail	0006_auto_20210101_2340	2024-01-03 00:58:00.751898+00
73	paperless_mail	0007_auto_20210106_0138	2024-01-03 00:58:00.795059+00
74	paperless_mail	0008_auto_20210516_0940	2024-01-03 00:58:00.852148+00
75	paperless_mail	0009_mailrule_assign_tags	2024-01-03 00:58:00.930172+00
76	paperless_mail	0010_auto_20220311_1602	2024-01-03 00:58:00.981003+00
77	paperless_mail	0011_remove_mailrule_assign_tag	2024-01-03 00:58:01.017013+00
78	paperless_mail	0012_alter_mailrule_assign_tags	2024-01-03 00:58:01.043561+00
79	paperless_mail	0009_alter_mailrule_action_alter_mailrule_folder	2024-01-03 00:58:01.09451+00
80	paperless_mail	0013_merge_20220412_1051	2024-01-03 00:58:01.102365+00
81	paperless_mail	0014_alter_mailrule_action	2024-01-03 00:58:01.127368+00
82	paperless_mail	0015_alter_mailrule_action	2024-01-03 00:58:01.152785+00
83	paperless_mail	0016_mailrule_consumption_scope	2024-01-03 00:58:01.182159+00
84	paperless_mail	0017_mailaccount_owner_mailrule_owner	2024-01-03 00:58:01.300122+00
85	paperless_mail	0018_processedmail	2024-01-03 00:58:01.396361+00
86	paperless_mail	0019_mailrule_filter_to	2024-01-03 00:58:01.440178+00
87	paperless_mail	0020_mailaccount_is_token	2024-01-03 00:58:01.483094+00
88	paperless_mail	0021_alter_mailaccount_password	2024-01-03 00:58:01.52065+00
89	documents	1012_fix_archive_files	2024-01-03 00:58:01.657634+00
90	documents	1013_migrate_tag_colour	2024-01-03 00:58:01.794728+00
91	documents	1014_auto_20210228_1614	2024-01-03 00:58:01.815457+00
92	documents	1015_remove_null_characters	2024-01-03 00:58:01.872623+00
93	documents	1016_auto_20210317_1351	2024-01-03 00:58:01.92247+00
94	documents	1017_alter_savedviewfilterrule_rule_type	2024-01-03 00:58:01.942273+00
95	documents	1018_alter_savedviewfilterrule_value	2024-01-03 00:58:01.963258+00
96	documents	1019_uisettings	2024-01-03 00:58:02.049703+00
97	documents	1019_storagepath_document_storage_path	2024-01-03 00:58:02.153205+00
98	documents	1020_merge_20220518_1839	2024-01-03 00:58:02.161653+00
99	documents	1021_webp_thumbnail_conversion	2024-01-03 00:58:02.223621+00
100	documents	1022_paperlesstask	2024-01-03 00:58:02.301726+00
101	documents	1023_add_comments	2024-01-03 00:58:02.413657+00
102	documents	1024_document_original_filename	2024-01-03 00:58:02.450346+00
103	documents	1025_alter_savedviewfilterrule_rule_type	2024-01-03 00:58:02.626047+00
104	documents	1026_transition_to_celery	2024-01-03 00:58:04.844668+00
105	documents	1027_remove_paperlesstask_attempted_task_and_more	2024-01-03 00:58:06.403428+00
106	documents	1028_remove_paperlesstask_task_args_and_more	2024-01-03 00:58:06.449979+00
107	documents	1029_alter_document_archive_serial_number	2024-01-03 00:58:06.488915+00
108	documents	1030_alter_paperlesstask_task_file_name	2024-01-03 00:58:06.510018+00
109	documents	1031_remove_savedview_user_correspondent_owner_and_more	2024-01-03 00:58:07.238944+00
110	documents	1032_alter_correspondent_matching_algorithm_and_more	2024-01-03 00:58:07.43366+00
111	documents	1033_alter_documenttype_options_alter_tag_options_and_more	2024-01-03 00:58:08.371288+00
112	documents	1034_alter_savedviewfilterrule_rule_type	2024-01-03 00:58:08.402018+00
113	documents	1035_rename_comment_note	2024-01-03 00:58:08.936369+00
114	documents	1036_alter_savedviewfilterrule_rule_type	2024-01-03 00:58:08.961181+00
115	documents	1037_webp_encrypted_thumbnail_conversion	2024-01-03 00:58:09.032118+00
116	documents	1038_sharelink	2024-01-03 00:58:09.704883+00
117	documents	1039_consumptiontemplate	2024-01-03 00:58:12.245582+00
118	documents	1040_customfield_customfieldinstance_and_more	2024-01-03 00:58:12.741763+00
119	documents	1041_alter_consumptiontemplate_sources	2024-01-03 00:58:12.809261+00
120	documents	1042_consumptiontemplate_assign_custom_fields_and_more	2024-01-03 00:58:13.062974+00
121	documents	1043_alter_savedviewfilterrule_rule_type	2024-01-03 00:58:13.084577+00
122	guardian	0001_initial	2024-01-03 00:58:13.65831+00
123	guardian	0002_generic_permissions_index	2024-01-03 00:58:13.78649+00
124	paperless_mail	0022_mailrule_assign_owner_from_rule_and_more	2024-01-03 00:58:13.922795+00
125	paperless_mail	0023_remove_mailrule_filter_attachment_filename_and_more	2024-01-03 00:58:14.124188+00
126	sessions	0001_initial	2024-01-03 00:58:14.177021+00
127	documents	1044_workflow_workflowaction_workflowtrigger_and_more	2024-01-13 14:55:04.287423+00
128	paperless	0001_initial	2024-01-13 14:55:04.33102+00
129	account	0001_initial	2024-03-18 04:25:07.847951+00
130	account	0002_email_max_length	2024-03-18 04:25:07.939141+00
131	account	0003_alter_emailaddress_create_unique_verified_email	2024-03-18 04:25:08.098774+00
132	account	0004_alter_emailaddress_drop_unique_email	2024-03-18 04:25:08.19599+00
133	account	0005_emailaddress_idx_upper_email	2024-03-18 04:25:08.281576+00
134	paperless	0002_applicationconfiguration_app_logo_and_more	2024-03-18 04:25:08.308156+00
135	socialaccount	0001_initial	2024-03-18 04:25:08.893978+00
136	socialaccount	0002_token_max_lengths	2024-03-18 04:25:09.008223+00
137	socialaccount	0003_extra_data_default_dict	2024-03-18 04:25:09.094738+00
138	socialaccount	0004_app_provider_id_settings	2024-03-18 04:25:09.220641+00
139	socialaccount	0005_socialtoken_nullable_app	2024-03-18 04:25:09.353028+00
140	socialaccount	0006_alter_socialaccount_extra_data	2024-03-18 04:25:09.467484+00
141	auditlog	0001_initial	2024-04-29 10:15:12.313153+01
142	auditlog	0002_auto_support_long_primary_keys	2024-04-29 10:15:12.461172+01
143	auditlog	0003_logentry_remote_addr	2024-04-29 10:15:12.550297+01
144	auditlog	0004_logentry_detailed_object_repr	2024-04-29 10:15:12.630614+01
145	auditlog	0005_logentry_additional_data_verbose_name	2024-04-29 10:15:12.714896+01
146	auditlog	0006_object_pk_index	2024-04-29 10:15:13.041163+01
147	auditlog	0007_object_pk_type	2024-04-29 10:15:13.127013+01
148	auditlog	0008_action_index	2024-04-29 10:15:13.221956+01
149	auditlog	0009_alter_logentry_additional_data	2024-04-29 10:15:13.305403+01
150	auditlog	0010_alter_logentry_timestamp	2024-04-29 10:15:13.393419+01
151	auditlog	0011_logentry_serialized_data	2024-04-29 10:15:13.478374+01
152	auditlog	0012_add_logentry_action_access	2024-04-29 10:15:13.562742+01
153	documents	1045_alter_customfieldinstance_value_monetary	2024-04-29 10:15:13.672754+01
154	documents	1046_workflowaction_remove_all_correspondents_and_more	2024-04-29 10:15:17.143791+01
155	paperless	0003_alter_applicationconfiguration_max_image_pixels	2024-04-29 10:15:17.160912+01
\.


--
-- Data for Name: django_session; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.django_session (session_key, session_data, expire_date) FROM stdin;
s86xdf7m1qkbbudk0qh7efbutne7q1sk	.eJxVjMsOwiAURP-FtSEg3MvFpXu_gfCUqoGktCvjv9smXehqkjln5s2cX5fq1pFnNyV2YYqdfrvg4zO3HaSHb_fOY2_LPAW-K_ygg996yq_r4f4dVD_qtvYapJBgsNBZK5kNUFDBKxEsChAiWtwyaSAMhnJJBFhk1AVt0paAfb6rJzab:1rKqBl:m--hV5UZxBOVlGaPT_lkFy_DAbr8svHxc-nB7Q8cHs8	2024-01-17 01:36:57.293199+00
\.


--
-- Data for Name: documents_correspondent; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_correspondent (id, name, match, matching_algorithm, is_insensitive, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_customfield; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_customfield (id, created, name, data_type) FROM stdin;
\.


--
-- Data for Name: documents_customfieldinstance; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_customfieldinstance (id, created, value_text, value_bool, value_url, value_date, value_int, value_float, value_monetary, document_id, field_id, value_document_ids) FROM stdin;
\.


--
-- Data for Name: documents_document; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_document (id, title, content, created, modified, correspondent_id, checksum, added, storage_type, filename, archive_serial_number, document_type_id, mime_type, archive_checksum, archive_filename, storage_path_id, original_filename, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_document_tags; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_document_tags (id, document_id, tag_id) FROM stdin;
\.


--
-- Data for Name: documents_documenttype; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_documenttype (id, name, match, matching_algorithm, is_insensitive, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_log; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_log (id, "group", message, level, created) FROM stdin;
\.


--
-- Data for Name: documents_note; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_note (id, note, created, document_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_paperlesstask; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_paperlesstask (id, task_id, acknowledged, date_created, date_done, date_started, result, status, task_file_name, task_name) FROM stdin;
\.


--
-- Data for Name: documents_savedview; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_savedview (id, name, show_on_dashboard, show_in_sidebar, sort_field, sort_reverse, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_savedviewfilterrule; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_savedviewfilterrule (id, rule_type, value, saved_view_id) FROM stdin;
\.


--
-- Data for Name: documents_sharelink; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_sharelink (id, created, expiration, slug, file_version, document_id, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_storagepath; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_storagepath (id, name, match, matching_algorithm, is_insensitive, path, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_tag; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_tag (id, name, match, matching_algorithm, is_insensitive, is_inbox_tag, color, owner_id) FROM stdin;
\.


--
-- Data for Name: documents_uisettings; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_uisettings (id, settings, user_id) FROM stdin;
1	{"theme": {"color": ""}, "language": "en-gb", "bulk_edit": {"apply_on_close": false, "confirmation_dialogs": true}, "dark_mode": {"enabled": "false", "use_system": true, "thumb_inverted": "true"}, "permissions": {"default_owner": 3, "default_edit_users": [], "default_view_users": [], "default_edit_groups": [], "default_view_groups": []}, "saved_views": {"warn_on_unsaved_change": true}, "date_display": {"date_format": "longDate", "date_locale": ""}, "slim_sidebar": false, "notes_enabled": true, "notifications": {"consumer_failed": true, "consumer_success": true, "consumer_new_documents": true, "consumer_suppress_on_dashboard": true}, "update_checking": {"enabled": false}, "documentListSize": 50, "document_details": {"native_pdf_viewer": false}}	3
\.


--
-- Data for Name: documents_workflow; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflow (id, name, "order", enabled) FROM stdin;
\.


--
-- Data for Name: documents_workflow_actions; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflow_actions (id, workflow_id, workflowaction_id) FROM stdin;
\.


--
-- Data for Name: documents_workflow_triggers; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflow_triggers (id, workflow_id, workflowtrigger_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction (id, type, assign_title, assign_correspondent_id, assign_document_type_id, assign_owner_id, assign_storage_path_id, remove_all_correspondents, remove_all_custom_fields, remove_all_document_types, remove_all_owners, remove_all_permissions, remove_all_storage_paths, remove_all_tags) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_change_groups; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_change_groups (id, workflowaction_id, group_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_change_users; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_change_users (id, workflowaction_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_custom_fields; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_custom_fields (id, workflowaction_id, customfield_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_tags; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_tags (id, workflowaction_id, tag_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_view_groups; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_view_groups (id, workflowaction_id, group_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_assign_view_users; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_assign_view_users (id, workflowaction_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_change_groups; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_change_groups (id, workflowaction_id, group_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_change_users; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_change_users (id, workflowaction_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_correspondents; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_correspondents (id, workflowaction_id, correspondent_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_custom_fields; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_custom_fields (id, workflowaction_id, customfield_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_document_types; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_document_types (id, workflowaction_id, documenttype_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_owners; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_owners (id, workflowaction_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_storage_paths; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_storage_paths (id, workflowaction_id, storagepath_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_tags; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_tags (id, workflowaction_id, tag_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_view_groups; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_view_groups (id, workflowaction_id, group_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowaction_remove_view_users; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowaction_remove_view_users (id, workflowaction_id, user_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowtrigger; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowtrigger (id, type, sources, filter_path, filter_filename, filter_mailrule_id, matching_algorithm, match, is_insensitive, filter_has_document_type_id, filter_has_correspondent_id) FROM stdin;
\.


--
-- Data for Name: documents_workflowtrigger_filter_has_tags; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.documents_workflowtrigger_filter_has_tags (id, workflowtrigger_id, tag_id) FROM stdin;
\.


--
-- Data for Name: guardian_groupobjectpermission; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.guardian_groupobjectpermission (id, object_pk, content_type_id, group_id, permission_id) FROM stdin;
\.


--
-- Data for Name: guardian_userobjectpermission; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.guardian_userobjectpermission (id, object_pk, content_type_id, permission_id, user_id) FROM stdin;
\.


--
-- Data for Name: paperless_applicationconfiguration; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.paperless_applicationconfiguration (id, output_type, pages, language, mode, skip_archive_file, image_dpi, unpaper_clean, deskew, rotate_pages, rotate_pages_threshold, max_image_pixels, color_conversion_strategy, user_args, app_logo, app_title) FROM stdin;
1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: paperless_mail_mailaccount; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.paperless_mail_mailaccount (id, name, imap_server, imap_port, imap_security, username, password, character_set, owner_id, is_token) FROM stdin;
\.


--
-- Data for Name: paperless_mail_mailrule; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.paperless_mail_mailrule (id, name, folder, filter_from, filter_subject, filter_body, maximum_age, action, action_parameter, assign_title_from, assign_correspondent_from, account_id, assign_correspondent_id, assign_document_type_id, "order", attachment_type, filter_attachment_filename_include, consumption_scope, owner_id, filter_to, assign_owner_from_rule, filter_attachment_filename_exclude) FROM stdin;
\.


--
-- Data for Name: paperless_mail_mailrule_assign_tags; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.paperless_mail_mailrule_assign_tags (id, mailrule_id, tag_id) FROM stdin;
\.


--
-- Data for Name: paperless_mail_processedmail; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.paperless_mail_processedmail (id, folder, uid, subject, received, processed, status, error, owner_id, rule_id) FROM stdin;
\.


--
-- Data for Name: socialaccount_socialaccount; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.socialaccount_socialaccount (id, provider, uid, last_login, date_joined, extra_data, user_id) FROM stdin;
\.


--
-- Data for Name: socialaccount_socialapp; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.socialaccount_socialapp (id, provider, name, client_id, secret, key, provider_id, settings) FROM stdin;
\.


--
-- Data for Name: socialaccount_socialtoken; Type: TABLE DATA; Schema: public; Owner: paperless_ngx
--

COPY public.socialaccount_socialtoken (id, token, token_secret, expires_at, account_id, app_id) FROM stdin;
\.


--
-- Name: account_emailaddress_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.account_emailaddress_id_seq', 1, false);


--
-- Name: account_emailconfirmation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.account_emailconfirmation_id_seq', 1, false);


--
-- Name: auditlog_logentry_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auditlog_logentry_id_seq', 1, false);


--
-- Name: auth_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_group_id_seq', 1, false);


--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_group_permissions_id_seq', 1, false);


--
-- Name: auth_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_permission_id_seq', 164, true);


--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_user_groups_id_seq', 1, false);


--
-- Name: auth_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_user_id_seq', 3, true);


--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.auth_user_user_permissions_id_seq', 1, false);


--
-- Name: django_admin_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_admin_log_id_seq', 1, false);


--
-- Name: django_celery_results_chordcounter_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_celery_results_chordcounter_id_seq', 1, false);


--
-- Name: django_celery_results_groupresult_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_celery_results_groupresult_id_seq', 1, false);


--
-- Name: django_celery_results_taskresult_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_celery_results_taskresult_id_seq', 15465, true);


--
-- Name: django_content_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_content_type_id_seq', 41, true);


--
-- Name: django_migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.django_migrations_id_seq', 155, true);


--
-- Name: documents_comment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_comment_id_seq', 1, false);


--
-- Name: documents_customfield_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_customfield_id_seq', 1, false);


--
-- Name: documents_customfieldinstance_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_customfieldinstance_id_seq', 1, false);


--
-- Name: documents_document_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_document_id_seq', 1, false);


--
-- Name: documents_document_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_document_tags_id_seq', 1, false);


--
-- Name: documents_documenttype_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_documenttype_id_seq', 1, false);


--
-- Name: documents_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_log_id_seq', 1, false);


--
-- Name: documents_paperlesstask_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_paperlesstask_id_seq', 1, false);


--
-- Name: documents_savedview_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_savedview_id_seq', 1, false);


--
-- Name: documents_savedviewfilterrule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_savedviewfilterrule_id_seq', 1, false);


--
-- Name: documents_sender_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_sender_id_seq', 1, false);


--
-- Name: documents_sharelink_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_sharelink_id_seq', 1, false);


--
-- Name: documents_storagepath_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_storagepath_id_seq', 1, false);


--
-- Name: documents_tag_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_tag_id_seq', 1, false);


--
-- Name: documents_uisettings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_uisettings_id_seq', 1, true);


--
-- Name: documents_workflow_actions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflow_actions_id_seq', 1, false);


--
-- Name: documents_workflow_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflow_id_seq', 1, false);


--
-- Name: documents_workflow_triggers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflow_triggers_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_change_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_change_groups_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_change_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_change_users_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_custom_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_custom_fields_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_tags_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_view_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_view_groups_id_seq', 1, false);


--
-- Name: documents_workflowaction_assign_view_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_assign_view_users_id_seq', 1, false);


--
-- Name: documents_workflowaction_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_change_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_change_groups_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_change_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_change_users_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_correspondents_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_correspondents_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_custom_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_custom_fields_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_document_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_document_types_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_owners_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_owners_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_storage_paths_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_storage_paths_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_tags_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_view_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_view_groups_id_seq', 1, false);


--
-- Name: documents_workflowaction_remove_view_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowaction_remove_view_users_id_seq', 1, false);


--
-- Name: documents_workflowtrigger_filter_has_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowtrigger_filter_has_tags_id_seq', 1, false);


--
-- Name: documents_workflowtrigger_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.documents_workflowtrigger_id_seq', 1, false);


--
-- Name: guardian_groupobjectpermission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.guardian_groupobjectpermission_id_seq', 1, false);


--
-- Name: guardian_userobjectpermission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.guardian_userobjectpermission_id_seq', 1, false);


--
-- Name: paperless_applicationconfiguration_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.paperless_applicationconfiguration_id_seq', 1, true);


--
-- Name: paperless_mail_mailaccount_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.paperless_mail_mailaccount_id_seq', 1, false);


--
-- Name: paperless_mail_mailrule_assign_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.paperless_mail_mailrule_assign_tags_id_seq', 1, false);


--
-- Name: paperless_mail_mailrule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.paperless_mail_mailrule_id_seq', 1, false);


--
-- Name: paperless_mail_processedmail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.paperless_mail_processedmail_id_seq', 1, false);


--
-- Name: socialaccount_socialaccount_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.socialaccount_socialaccount_id_seq', 1, false);


--
-- Name: socialaccount_socialapp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.socialaccount_socialapp_id_seq', 1, false);


--
-- Name: socialaccount_socialtoken_id_seq; Type: SEQUENCE SET; Schema: public; Owner: paperless_ngx
--

SELECT pg_catalog.setval('public.socialaccount_socialtoken_id_seq', 1, false);


--
-- Name: account_emailaddress account_emailaddress_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailaddress
    ADD CONSTRAINT account_emailaddress_pkey PRIMARY KEY (id);


--
-- Name: account_emailaddress account_emailaddress_user_id_email_987c8728_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailaddress
    ADD CONSTRAINT account_emailaddress_user_id_email_987c8728_uniq UNIQUE (user_id, email);


--
-- Name: account_emailconfirmation account_emailconfirmation_key_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailconfirmation
    ADD CONSTRAINT account_emailconfirmation_key_key UNIQUE (key);


--
-- Name: account_emailconfirmation account_emailconfirmation_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailconfirmation
    ADD CONSTRAINT account_emailconfirmation_pkey PRIMARY KEY (id);


--
-- Name: auditlog_logentry auditlog_logentry_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auditlog_logentry
    ADD CONSTRAINT auditlog_logentry_pkey PRIMARY KEY (id);


--
-- Name: auth_group auth_group_name_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_name_key UNIQUE (name);


--
-- Name: auth_group_permissions auth_group_permissions_group_id_permission_id_0cd325b0_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_permission_id_0cd325b0_uniq UNIQUE (group_id, permission_id);


--
-- Name: auth_group_permissions auth_group_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_group auth_group_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_pkey PRIMARY KEY (id);


--
-- Name: auth_permission auth_permission_content_type_id_codename_01ab375a_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_codename_01ab375a_uniq UNIQUE (content_type_id, codename);


--
-- Name: auth_permission auth_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups auth_user_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups auth_user_groups_user_id_group_id_94350c0c_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_group_id_94350c0c_uniq UNIQUE (user_id, group_id);


--
-- Name: auth_user auth_user_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT auth_user_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions auth_user_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_permission_id_14a6b632_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_permission_id_14a6b632_uniq UNIQUE (user_id, permission_id);


--
-- Name: auth_user auth_user_username_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT auth_user_username_key UNIQUE (username);


--
-- Name: authtoken_token authtoken_token_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.authtoken_token
    ADD CONSTRAINT authtoken_token_pkey PRIMARY KEY (key);


--
-- Name: authtoken_token authtoken_token_user_id_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.authtoken_token
    ADD CONSTRAINT authtoken_token_user_id_key UNIQUE (user_id);


--
-- Name: django_admin_log django_admin_log_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_pkey PRIMARY KEY (id);


--
-- Name: django_celery_results_chordcounter django_celery_results_chordcounter_group_id_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_chordcounter
    ADD CONSTRAINT django_celery_results_chordcounter_group_id_key UNIQUE (group_id);


--
-- Name: django_celery_results_chordcounter django_celery_results_chordcounter_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_chordcounter
    ADD CONSTRAINT django_celery_results_chordcounter_pkey PRIMARY KEY (id);


--
-- Name: django_celery_results_groupresult django_celery_results_groupresult_group_id_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_groupresult
    ADD CONSTRAINT django_celery_results_groupresult_group_id_key UNIQUE (group_id);


--
-- Name: django_celery_results_groupresult django_celery_results_groupresult_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_groupresult
    ADD CONSTRAINT django_celery_results_groupresult_pkey PRIMARY KEY (id);


--
-- Name: django_celery_results_taskresult django_celery_results_taskresult_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_taskresult
    ADD CONSTRAINT django_celery_results_taskresult_pkey PRIMARY KEY (id);


--
-- Name: django_celery_results_taskresult django_celery_results_taskresult_task_id_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_celery_results_taskresult
    ADD CONSTRAINT django_celery_results_taskresult_task_id_key UNIQUE (task_id);


--
-- Name: django_content_type django_content_type_app_label_model_76bd3d3b_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_app_label_model_76bd3d3b_uniq UNIQUE (app_label, model);


--
-- Name: django_content_type django_content_type_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_pkey PRIMARY KEY (id);


--
-- Name: django_migrations django_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_migrations
    ADD CONSTRAINT django_migrations_pkey PRIMARY KEY (id);


--
-- Name: django_session django_session_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_session
    ADD CONSTRAINT django_session_pkey PRIMARY KEY (session_key);


--
-- Name: documents_note documents_comment_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_note
    ADD CONSTRAINT documents_comment_pkey PRIMARY KEY (id);


--
-- Name: documents_correspondent documents_correspondent_unique_name_owner; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_correspondent
    ADD CONSTRAINT documents_correspondent_unique_name_owner UNIQUE (name, owner_id);


--
-- Name: documents_customfield documents_customfield_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfield
    ADD CONSTRAINT documents_customfield_pkey PRIMARY KEY (id);


--
-- Name: documents_customfield documents_customfield_unique_name; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfield
    ADD CONSTRAINT documents_customfield_unique_name UNIQUE (name);


--
-- Name: documents_customfieldinstance documents_customfieldinstance_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfieldinstance
    ADD CONSTRAINT documents_customfieldinstance_pkey PRIMARY KEY (id);


--
-- Name: documents_customfieldinstance documents_customfieldinstance_unique_document_field; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfieldinstance
    ADD CONSTRAINT documents_customfieldinstance_unique_document_field UNIQUE (document_id, field_id);


--
-- Name: documents_document documents_document_archive_filename_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_archive_filename_key UNIQUE (archive_filename);


--
-- Name: documents_document documents_document_archive_serial_number_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_archive_serial_number_key UNIQUE (archive_serial_number);


--
-- Name: documents_document documents_document_checksum_75209391_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_checksum_75209391_uniq UNIQUE (checksum);


--
-- Name: documents_document documents_document_filename_3ee5ad97_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_filename_3ee5ad97_uniq UNIQUE (filename);


--
-- Name: documents_document documents_document_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_pkey PRIMARY KEY (id);


--
-- Name: documents_document_tags documents_document_tags_document_id_tag_id_07e90502_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document_tags
    ADD CONSTRAINT documents_document_tags_document_id_tag_id_07e90502_uniq UNIQUE (document_id, tag_id);


--
-- Name: documents_document_tags documents_document_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document_tags
    ADD CONSTRAINT documents_document_tags_pkey PRIMARY KEY (id);


--
-- Name: documents_documenttype documents_documenttype_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_documenttype
    ADD CONSTRAINT documents_documenttype_pkey PRIMARY KEY (id);


--
-- Name: documents_documenttype documents_documenttype_unique_name_owner; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_documenttype
    ADD CONSTRAINT documents_documenttype_unique_name_owner UNIQUE (name, owner_id);


--
-- Name: documents_log documents_log_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_log
    ADD CONSTRAINT documents_log_pkey PRIMARY KEY (id);


--
-- Name: documents_paperlesstask documents_paperlesstask_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_paperlesstask
    ADD CONSTRAINT documents_paperlesstask_pkey PRIMARY KEY (id);


--
-- Name: documents_paperlesstask documents_paperlesstask_task_id_24b393f9_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_paperlesstask
    ADD CONSTRAINT documents_paperlesstask_task_id_24b393f9_uniq UNIQUE (task_id);


--
-- Name: documents_savedview documents_savedview_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_savedview
    ADD CONSTRAINT documents_savedview_pkey PRIMARY KEY (id);


--
-- Name: documents_savedviewfilterrule documents_savedviewfilterrule_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_savedviewfilterrule
    ADD CONSTRAINT documents_savedviewfilterrule_pkey PRIMARY KEY (id);


--
-- Name: documents_correspondent documents_sender_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_correspondent
    ADD CONSTRAINT documents_sender_pkey PRIMARY KEY (id);


--
-- Name: documents_sharelink documents_sharelink_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_sharelink
    ADD CONSTRAINT documents_sharelink_pkey PRIMARY KEY (id);


--
-- Name: documents_sharelink documents_sharelink_slug_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_sharelink
    ADD CONSTRAINT documents_sharelink_slug_key UNIQUE (slug);


--
-- Name: documents_storagepath documents_storagepath_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_storagepath
    ADD CONSTRAINT documents_storagepath_pkey PRIMARY KEY (id);


--
-- Name: documents_storagepath documents_storagepath_unique_name_owner; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_storagepath
    ADD CONSTRAINT documents_storagepath_unique_name_owner UNIQUE (name, owner_id);


--
-- Name: documents_tag documents_tag_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_tag
    ADD CONSTRAINT documents_tag_pkey PRIMARY KEY (id);


--
-- Name: documents_tag documents_tag_unique_name_owner; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_tag
    ADD CONSTRAINT documents_tag_unique_name_owner UNIQUE (name, owner_id);


--
-- Name: documents_uisettings documents_uisettings_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_uisettings
    ADD CONSTRAINT documents_uisettings_pkey PRIMARY KEY (id);


--
-- Name: documents_uisettings documents_uisettings_user_id_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_uisettings
    ADD CONSTRAINT documents_uisettings_user_id_key UNIQUE (user_id);


--
-- Name: documents_workflow_actions documents_workflow_actio_workflow_id_workflowacti_314baf08_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_actions
    ADD CONSTRAINT documents_workflow_actio_workflow_id_workflowacti_314baf08_uniq UNIQUE (workflow_id, workflowaction_id);


--
-- Name: documents_workflow_actions documents_workflow_actions_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_actions
    ADD CONSTRAINT documents_workflow_actions_pkey PRIMARY KEY (id);


--
-- Name: documents_workflow documents_workflow_name_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow
    ADD CONSTRAINT documents_workflow_name_key UNIQUE (name);


--
-- Name: documents_workflow documents_workflow_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow
    ADD CONSTRAINT documents_workflow_pkey PRIMARY KEY (id);


--
-- Name: documents_workflow_triggers documents_workflow_trigg_workflow_id_workflowtrig_379ec41b_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_triggers
    ADD CONSTRAINT documents_workflow_trigg_workflow_id_workflowtrig_379ec41b_uniq UNIQUE (workflow_id, workflowtrigger_id);


--
-- Name: documents_workflow_triggers documents_workflow_triggers_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_triggers
    ADD CONSTRAINT documents_workflow_triggers_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_change_groups documents_workflowaction_assign_change_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_groups
    ADD CONSTRAINT documents_workflowaction_assign_change_groups_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_change_users documents_workflowaction_assign_change_users_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_users
    ADD CONSTRAINT documents_workflowaction_assign_change_users_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_custom_fields documents_workflowaction_assign_custom_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_custom_fields
    ADD CONSTRAINT documents_workflowaction_assign_custom_fields_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_tags documents_workflowaction_assign_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_tags
    ADD CONSTRAINT documents_workflowaction_assign_tags_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_view_groups documents_workflowaction_assign_view_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_groups
    ADD CONSTRAINT documents_workflowaction_assign_view_groups_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_assign_view_users documents_workflowaction_assign_view_users_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_users
    ADD CONSTRAINT documents_workflowaction_assign_view_users_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction documents_workflowaction_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction
    ADD CONSTRAINT documents_workflowaction_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_change_groups documents_workflowaction_remove_change_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_groups
    ADD CONSTRAINT documents_workflowaction_remove_change_groups_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_change_users documents_workflowaction_remove_change_users_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_users
    ADD CONSTRAINT documents_workflowaction_remove_change_users_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_correspondents documents_workflowaction_remove_correspondents_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_correspondents
    ADD CONSTRAINT documents_workflowaction_remove_correspondents_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_custom_fields documents_workflowaction_remove_custom_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_custom_fields
    ADD CONSTRAINT documents_workflowaction_remove_custom_fields_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_document_types documents_workflowaction_remove_document_types_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_document_types
    ADD CONSTRAINT documents_workflowaction_remove_document_types_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_owners documents_workflowaction_remove_owners_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_owners
    ADD CONSTRAINT documents_workflowaction_remove_owners_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_storage_paths documents_workflowaction_remove_storage_paths_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_storage_paths
    ADD CONSTRAINT documents_workflowaction_remove_storage_paths_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_tags documents_workflowaction_remove_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_tags
    ADD CONSTRAINT documents_workflowaction_remove_tags_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_view_groups documents_workflowaction_remove_view_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_groups
    ADD CONSTRAINT documents_workflowaction_remove_view_groups_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_view_users documents_workflowaction_remove_view_users_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_users
    ADD CONSTRAINT documents_workflowaction_remove_view_users_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowaction_remove_correspondents documents_workflowaction_workflowaction_id_corres_1f286308_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_correspondents
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_corres_1f286308_uniq UNIQUE (workflowaction_id, correspondent_id);


--
-- Name: documents_workflowaction_assign_custom_fields documents_workflowaction_workflowaction_id_custom_7325b36e_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_custom_fields
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_custom_7325b36e_uniq UNIQUE (workflowaction_id, customfield_id);


--
-- Name: documents_workflowaction_remove_custom_fields documents_workflowaction_workflowaction_id_custom_ae47c643_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_custom_fields
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_custom_ae47c643_uniq UNIQUE (workflowaction_id, customfield_id);


--
-- Name: documents_workflowaction_remove_document_types documents_workflowaction_workflowaction_id_docume_50d4bf5f_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_document_types
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_docume_50d4bf5f_uniq UNIQUE (workflowaction_id, documenttype_id);


--
-- Name: documents_workflowaction_remove_change_groups documents_workflowaction_workflowaction_id_group__4103392d_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_groups
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_group__4103392d_uniq UNIQUE (workflowaction_id, group_id);


--
-- Name: documents_workflowaction_assign_change_groups documents_workflowaction_workflowaction_id_group__45663b3e_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_groups
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_group__45663b3e_uniq UNIQUE (workflowaction_id, group_id);


--
-- Name: documents_workflowaction_assign_view_groups documents_workflowaction_workflowaction_id_group__7418d9f8_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_groups
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_group__7418d9f8_uniq UNIQUE (workflowaction_id, group_id);


--
-- Name: documents_workflowaction_remove_view_groups documents_workflowaction_workflowaction_id_group__84d7de00_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_groups
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_group__84d7de00_uniq UNIQUE (workflowaction_id, group_id);


--
-- Name: documents_workflowaction_remove_storage_paths documents_workflowaction_workflowaction_id_storag_6db77de5_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_storage_paths
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_storag_6db77de5_uniq UNIQUE (workflowaction_id, storagepath_id);


--
-- Name: documents_workflowaction_assign_tags documents_workflowaction_workflowaction_id_tag_id_0d903a8d_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_tags
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_tag_id_0d903a8d_uniq UNIQUE (workflowaction_id, tag_id);


--
-- Name: documents_workflowaction_remove_tags documents_workflowaction_workflowaction_id_tag_id_e1afdcb9_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_tags
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_tag_id_e1afdcb9_uniq UNIQUE (workflowaction_id, tag_id);


--
-- Name: documents_workflowaction_remove_owners documents_workflowaction_workflowaction_id_user_i_2a14ca1c_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_owners
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_user_i_2a14ca1c_uniq UNIQUE (workflowaction_id, user_id);


--
-- Name: documents_workflowaction_assign_change_users documents_workflowaction_workflowaction_id_user_i_3c0995e7_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_users
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_user_i_3c0995e7_uniq UNIQUE (workflowaction_id, user_id);


--
-- Name: documents_workflowaction_remove_view_users documents_workflowaction_workflowaction_id_user_i_73b4501a_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_users
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_user_i_73b4501a_uniq UNIQUE (workflowaction_id, user_id);


--
-- Name: documents_workflowaction_assign_view_users documents_workflowaction_workflowaction_id_user_i_8765917e_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_users
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_user_i_8765917e_uniq UNIQUE (workflowaction_id, user_id);


--
-- Name: documents_workflowaction_remove_change_users documents_workflowaction_workflowaction_id_user_i_941e6bd9_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_users
    ADD CONSTRAINT documents_workflowaction_workflowaction_id_user_i_941e6bd9_uniq UNIQUE (workflowaction_id, user_id);


--
-- Name: documents_workflowtrigger_filter_has_tags documents_workflowtrigge_workflowtrigger_id_tag_i_dbb02540_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger_filter_has_tags
    ADD CONSTRAINT documents_workflowtrigge_workflowtrigger_id_tag_i_dbb02540_uniq UNIQUE (workflowtrigger_id, tag_id);


--
-- Name: documents_workflowtrigger_filter_has_tags documents_workflowtrigger_filter_has_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger_filter_has_tags
    ADD CONSTRAINT documents_workflowtrigger_filter_has_tags_pkey PRIMARY KEY (id);


--
-- Name: documents_workflowtrigger documents_workflowtrigger_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger
    ADD CONSTRAINT documents_workflowtrigger_pkey PRIMARY KEY (id);


--
-- Name: guardian_groupobjectpermission guardian_groupobjectperm_group_id_permission_id_o_3f189f7c_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobjectperm_group_id_permission_id_o_3f189f7c_uniq UNIQUE (group_id, permission_id, object_pk);


--
-- Name: guardian_groupobjectpermission guardian_groupobjectpermission_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobjectpermission_pkey PRIMARY KEY (id);


--
-- Name: guardian_userobjectpermission guardian_userobjectpermi_user_id_permission_id_ob_b0b3d2fc_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectpermi_user_id_permission_id_ob_b0b3d2fc_uniq UNIQUE (user_id, permission_id, object_pk);


--
-- Name: guardian_userobjectpermission guardian_userobjectpermission_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectpermission_pkey PRIMARY KEY (id);


--
-- Name: paperless_applicationconfiguration paperless_applicationconfiguration_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_applicationconfiguration
    ADD CONSTRAINT paperless_applicationconfiguration_pkey PRIMARY KEY (id);


--
-- Name: paperless_mail_mailaccount paperless_mail_mailaccount_name_key; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailaccount
    ADD CONSTRAINT paperless_mail_mailaccount_name_key UNIQUE (name);


--
-- Name: paperless_mail_mailaccount paperless_mail_mailaccount_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailaccount
    ADD CONSTRAINT paperless_mail_mailaccount_pkey PRIMARY KEY (id);


--
-- Name: paperless_mail_mailrule_assign_tags paperless_mail_mailrule__mailrule_id_tag_id_0960fdac_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule_assign_tags
    ADD CONSTRAINT paperless_mail_mailrule__mailrule_id_tag_id_0960fdac_uniq UNIQUE (mailrule_id, tag_id);


--
-- Name: paperless_mail_mailrule_assign_tags paperless_mail_mailrule_assign_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule_assign_tags
    ADD CONSTRAINT paperless_mail_mailrule_assign_tags_pkey PRIMARY KEY (id);


--
-- Name: paperless_mail_mailrule paperless_mail_mailrule_name_ee9b53bd_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailrule_name_ee9b53bd_uniq UNIQUE (name);


--
-- Name: paperless_mail_mailrule paperless_mail_mailrule_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailrule_pkey PRIMARY KEY (id);


--
-- Name: paperless_mail_processedmail paperless_mail_processedmail_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_processedmail
    ADD CONSTRAINT paperless_mail_processedmail_pkey PRIMARY KEY (id);


--
-- Name: socialaccount_socialaccount socialaccount_socialaccount_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialaccount
    ADD CONSTRAINT socialaccount_socialaccount_pkey PRIMARY KEY (id);


--
-- Name: socialaccount_socialaccount socialaccount_socialaccount_provider_uid_fc810c6e_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialaccount
    ADD CONSTRAINT socialaccount_socialaccount_provider_uid_fc810c6e_uniq UNIQUE (provider, uid);


--
-- Name: socialaccount_socialapp socialaccount_socialapp_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialapp
    ADD CONSTRAINT socialaccount_socialapp_pkey PRIMARY KEY (id);


--
-- Name: socialaccount_socialtoken socialaccount_socialtoken_app_id_account_id_fca4e0ac_uniq; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialtoken
    ADD CONSTRAINT socialaccount_socialtoken_app_id_account_id_fca4e0ac_uniq UNIQUE (app_id, account_id);


--
-- Name: socialaccount_socialtoken socialaccount_socialtoken_pkey; Type: CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialtoken
    ADD CONSTRAINT socialaccount_socialtoken_pkey PRIMARY KEY (id);


--
-- Name: account_emailaddress_upper; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX account_emailaddress_upper ON public.account_emailaddress USING btree (upper((email)::text));


--
-- Name: account_emailaddress_user_id_2c513194; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX account_emailaddress_user_id_2c513194 ON public.account_emailaddress USING btree (user_id);


--
-- Name: account_emailconfirmation_email_address_id_5b7f8c58; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX account_emailconfirmation_email_address_id_5b7f8c58 ON public.account_emailconfirmation USING btree (email_address_id);


--
-- Name: account_emailconfirmation_key_f43612bd_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX account_emailconfirmation_key_f43612bd_like ON public.account_emailconfirmation USING btree (key varchar_pattern_ops);


--
-- Name: auditlog_logentry_action_229afe39; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_action_229afe39 ON public.auditlog_logentry USING btree (action);


--
-- Name: auditlog_logentry_actor_id_959271d2; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_actor_id_959271d2 ON public.auditlog_logentry USING btree (actor_id);


--
-- Name: auditlog_logentry_content_type_id_75830218; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_content_type_id_75830218 ON public.auditlog_logentry USING btree (content_type_id);


--
-- Name: auditlog_logentry_object_id_09c2eee8; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_object_id_09c2eee8 ON public.auditlog_logentry USING btree (object_id);


--
-- Name: auditlog_logentry_object_pk_6e3219c0; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_object_pk_6e3219c0 ON public.auditlog_logentry USING btree (object_pk);


--
-- Name: auditlog_logentry_object_pk_6e3219c0_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_object_pk_6e3219c0_like ON public.auditlog_logentry USING btree (object_pk varchar_pattern_ops);


--
-- Name: auditlog_logentry_timestamp_37867bb0; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auditlog_logentry_timestamp_37867bb0 ON public.auditlog_logentry USING btree ("timestamp");


--
-- Name: auth_group_name_a6ea08ec_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_group_name_a6ea08ec_like ON public.auth_group USING btree (name varchar_pattern_ops);


--
-- Name: auth_group_permissions_group_id_b120cbf9; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_group_permissions_group_id_b120cbf9 ON public.auth_group_permissions USING btree (group_id);


--
-- Name: auth_group_permissions_permission_id_84c5c92e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_group_permissions_permission_id_84c5c92e ON public.auth_group_permissions USING btree (permission_id);


--
-- Name: auth_permission_content_type_id_2f476e4b; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_permission_content_type_id_2f476e4b ON public.auth_permission USING btree (content_type_id);


--
-- Name: auth_user_groups_group_id_97559544; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_user_groups_group_id_97559544 ON public.auth_user_groups USING btree (group_id);


--
-- Name: auth_user_groups_user_id_6a12ed8b; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_user_groups_user_id_6a12ed8b ON public.auth_user_groups USING btree (user_id);


--
-- Name: auth_user_user_permissions_permission_id_1fbb5f2c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_user_user_permissions_permission_id_1fbb5f2c ON public.auth_user_user_permissions USING btree (permission_id);


--
-- Name: auth_user_user_permissions_user_id_a95ead1b; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_user_user_permissions_user_id_a95ead1b ON public.auth_user_user_permissions USING btree (user_id);


--
-- Name: auth_user_username_6821ab7c_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX auth_user_username_6821ab7c_like ON public.auth_user USING btree (username varchar_pattern_ops);


--
-- Name: authtoken_token_key_10f0b77e_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX authtoken_token_key_10f0b77e_like ON public.authtoken_token USING btree (key varchar_pattern_ops);


--
-- Name: django_admin_log_content_type_id_c4bce8eb; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_admin_log_content_type_id_c4bce8eb ON public.django_admin_log USING btree (content_type_id);


--
-- Name: django_admin_log_user_id_c564eba6; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_admin_log_user_id_c564eba6 ON public.django_admin_log USING btree (user_id);


--
-- Name: django_cele_date_cr_bd6c1d_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_date_cr_bd6c1d_idx ON public.django_celery_results_groupresult USING btree (date_created);


--
-- Name: django_cele_date_cr_f04a50_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_date_cr_f04a50_idx ON public.django_celery_results_taskresult USING btree (date_created);


--
-- Name: django_cele_date_do_caae0e_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_date_do_caae0e_idx ON public.django_celery_results_groupresult USING btree (date_done);


--
-- Name: django_cele_date_do_f59aad_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_date_do_f59aad_idx ON public.django_celery_results_taskresult USING btree (date_done);


--
-- Name: django_cele_status_9b6201_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_status_9b6201_idx ON public.django_celery_results_taskresult USING btree (status);


--
-- Name: django_cele_task_na_08aec9_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_task_na_08aec9_idx ON public.django_celery_results_taskresult USING btree (task_name);


--
-- Name: django_cele_worker_d54dd8_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_cele_worker_d54dd8_idx ON public.django_celery_results_taskresult USING btree (worker);


--
-- Name: django_celery_results_chordcounter_group_id_1f70858c_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_celery_results_chordcounter_group_id_1f70858c_like ON public.django_celery_results_chordcounter USING btree (group_id varchar_pattern_ops);


--
-- Name: django_celery_results_groupresult_group_id_a085f1a9_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_celery_results_groupresult_group_id_a085f1a9_like ON public.django_celery_results_groupresult USING btree (group_id varchar_pattern_ops);


--
-- Name: django_celery_results_taskresult_task_id_de0d95bf_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_celery_results_taskresult_task_id_de0d95bf_like ON public.django_celery_results_taskresult USING btree (task_id varchar_pattern_ops);


--
-- Name: django_session_expire_date_a5c62663; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_session_expire_date_a5c62663 ON public.django_session USING btree (expire_date);


--
-- Name: django_session_session_key_c0390e0f_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX django_session_session_key_c0390e0f_like ON public.django_session USING btree (session_key varchar_pattern_ops);


--
-- Name: documents_comment_created_dd512b3b; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_comment_created_dd512b3b ON public.documents_note USING btree (created);


--
-- Name: documents_comment_document_id_3f5d21c7; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_comment_document_id_3f5d21c7 ON public.documents_note USING btree (document_id);


--
-- Name: documents_comment_user_id_c281d4d5; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_comment_user_id_c281d4d5 ON public.documents_note USING btree (user_id);


--
-- Name: documents_correspondent_name_uniq; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE UNIQUE INDEX documents_correspondent_name_uniq ON public.documents_correspondent USING btree (name) WHERE (owner_id IS NULL);


--
-- Name: documents_correspondent_owner_id_078f7f8a; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_correspondent_owner_id_078f7f8a ON public.documents_correspondent USING btree (owner_id);


--
-- Name: documents_customfield_created_501ef047; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_customfield_created_501ef047 ON public.documents_customfield USING btree (created);


--
-- Name: documents_customfieldinstance_created_75f17f1d; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_customfieldinstance_created_75f17f1d ON public.documents_customfieldinstance USING btree (created);


--
-- Name: documents_customfieldinstance_document_id_610a968e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_customfieldinstance_document_id_610a968e ON public.documents_customfieldinstance USING btree (document_id);


--
-- Name: documents_customfieldinstance_field_id_6c59e32f; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_customfieldinstance_field_id_6c59e32f ON public.documents_customfieldinstance USING btree (field_id);


--
-- Name: documents_document_added_28cfa360; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_added_28cfa360 ON public.documents_document USING btree (added);


--
-- Name: documents_document_archive_filename_fc3cb023_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_archive_filename_fc3cb023_like ON public.documents_document USING btree (archive_filename varchar_pattern_ops);


--
-- Name: documents_document_checksum_75209391_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_checksum_75209391_like ON public.documents_document USING btree (checksum varchar_pattern_ops);


--
-- Name: documents_document_created_bedd0818; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_created_bedd0818 ON public.documents_document USING btree (created);


--
-- Name: documents_document_document_type_id_1f88b50c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_document_type_id_1f88b50c ON public.documents_document USING btree (document_type_id);


--
-- Name: documents_document_filename_3ee5ad97_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_filename_3ee5ad97_like ON public.documents_document USING btree (filename varchar_pattern_ops);


--
-- Name: documents_document_modified_2eae15bc; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_modified_2eae15bc ON public.documents_document USING btree (modified);


--
-- Name: documents_document_owner_id_04d2b723; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_owner_id_04d2b723 ON public.documents_document USING btree (owner_id);


--
-- Name: documents_document_sender_id_950512b2; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_sender_id_950512b2 ON public.documents_document USING btree (correspondent_id);


--
-- Name: documents_document_storage_path_id_07d27bdb; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_storage_path_id_07d27bdb ON public.documents_document USING btree (storage_path_id);


--
-- Name: documents_document_tags_document_id_006f35a8; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_tags_document_id_006f35a8 ON public.documents_document_tags USING btree (document_id);


--
-- Name: documents_document_tags_tag_id_4f4a71e9; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_tags_tag_id_4f4a71e9 ON public.documents_document_tags USING btree (tag_id);


--
-- Name: documents_document_title_6b08e02a; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_title_6b08e02a ON public.documents_document USING btree (title);


--
-- Name: documents_document_title_6b08e02a_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_document_title_6b08e02a_like ON public.documents_document USING btree (title varchar_pattern_ops);


--
-- Name: documents_documenttype_name_uniq; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE UNIQUE INDEX documents_documenttype_name_uniq ON public.documents_documenttype USING btree (name) WHERE (owner_id IS NULL);


--
-- Name: documents_documenttype_owner_id_a19f201d; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_documenttype_owner_id_a19f201d ON public.documents_documenttype USING btree (owner_id);


--
-- Name: documents_paperlesstask_task_id_24b393f9_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_paperlesstask_task_id_24b393f9_like ON public.documents_paperlesstask USING btree (task_id varchar_pattern_ops);


--
-- Name: documents_savedview_user_id_48baf272; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_savedview_user_id_48baf272 ON public.documents_savedview USING btree (owner_id);


--
-- Name: documents_savedviewfilterrule_saved_view_id_038e2c89; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_savedviewfilterrule_saved_view_id_038e2c89 ON public.documents_savedviewfilterrule USING btree (saved_view_id);


--
-- Name: documents_sender_name_18997c37_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sender_name_18997c37_like ON public.documents_correspondent USING btree (name varchar_pattern_ops);


--
-- Name: documents_sharelink_created_23f24996; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sharelink_created_23f24996 ON public.documents_sharelink USING btree (created);


--
-- Name: documents_sharelink_document_id_1be5ab03; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sharelink_document_id_1be5ab03 ON public.documents_sharelink USING btree (document_id);


--
-- Name: documents_sharelink_expiration_152b32a7; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sharelink_expiration_152b32a7 ON public.documents_sharelink USING btree (expiration);


--
-- Name: documents_sharelink_owner_id_3fd35a08; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sharelink_owner_id_3fd35a08 ON public.documents_sharelink USING btree (owner_id);


--
-- Name: documents_sharelink_slug_47d0454d_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_sharelink_slug_47d0454d_like ON public.documents_sharelink USING btree (slug varchar_pattern_ops);


--
-- Name: documents_storagepath_name_uniq; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE UNIQUE INDEX documents_storagepath_name_uniq ON public.documents_storagepath USING btree (name) WHERE (owner_id IS NULL);


--
-- Name: documents_storagepath_owner_id_c8f01fe8; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_storagepath_owner_id_c8f01fe8 ON public.documents_storagepath USING btree (owner_id);


--
-- Name: documents_tag_name_uniq; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE UNIQUE INDEX documents_tag_name_uniq ON public.documents_tag USING btree (name) WHERE (owner_id IS NULL);


--
-- Name: documents_tag_owner_id_f0875d77; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_tag_owner_id_f0875d77 ON public.documents_tag USING btree (owner_id);


--
-- Name: documents_workflow_actions_workflow_id_5445f1de; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflow_actions_workflow_id_5445f1de ON public.documents_workflow_actions USING btree (workflow_id);


--
-- Name: documents_workflow_actions_workflowaction_id_7ed6a4fa; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflow_actions_workflowaction_id_7ed6a4fa ON public.documents_workflow_actions USING btree (workflowaction_id);


--
-- Name: documents_workflow_name_e88f7b19_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflow_name_e88f7b19_like ON public.documents_workflow USING btree (name varchar_pattern_ops);


--
-- Name: documents_workflow_triggers_workflow_id_77d63852; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflow_triggers_workflow_id_77d63852 ON public.documents_workflow_triggers USING btree (workflow_id);


--
-- Name: documents_workflow_triggers_workflowtrigger_id_566f2a31; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflow_triggers_workflowtrigger_id_566f2a31 ON public.documents_workflow_triggers USING btree (workflowtrigger_id);


--
-- Name: documents_workflowaction_a_customfield_id_09df9cc4; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_customfield_id_09df9cc4 ON public.documents_workflowaction_assign_custom_fields USING btree (customfield_id);


--
-- Name: documents_workflowaction_a_workflowaction_id_03784a7e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_workflowaction_id_03784a7e ON public.documents_workflowaction_assign_change_groups USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_a_workflowaction_id_518e70e5; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_workflowaction_id_518e70e5 ON public.documents_workflowaction_assign_custom_fields USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_a_workflowaction_id_79b5b0b4; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_workflowaction_id_79b5b0b4 ON public.documents_workflowaction_assign_view_users USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_a_workflowaction_id_bcc0465a; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_workflowaction_id_bcc0465a ON public.documents_workflowaction_assign_change_users USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_a_workflowaction_id_f8ef83c1; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_a_workflowaction_id_f8ef83c1 ON public.documents_workflowaction_assign_view_groups USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_assign_change_groups_group_id_a6d3bc2c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_change_groups_group_id_a6d3bc2c ON public.documents_workflowaction_assign_change_groups USING btree (group_id);


--
-- Name: documents_workflowaction_assign_change_users_user_id_73bec49c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_change_users_user_id_73bec49c ON public.documents_workflowaction_assign_change_users USING btree (user_id);


--
-- Name: documents_workflowaction_assign_correspondent_id_2292447e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_correspondent_id_2292447e ON public.documents_workflowaction USING btree (assign_correspondent_id);


--
-- Name: documents_workflowaction_assign_document_type_id_4d37bd10; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_document_type_id_4d37bd10 ON public.documents_workflowaction USING btree (assign_document_type_id);


--
-- Name: documents_workflowaction_assign_owner_id_a409d275; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_owner_id_a409d275 ON public.documents_workflowaction USING btree (assign_owner_id);


--
-- Name: documents_workflowaction_assign_storage_path_id_6fec4231; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_storage_path_id_6fec4231 ON public.documents_workflowaction USING btree (assign_storage_path_id);


--
-- Name: documents_workflowaction_assign_tags_tag_id_6770cb84; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_tags_tag_id_6770cb84 ON public.documents_workflowaction_assign_tags USING btree (tag_id);


--
-- Name: documents_workflowaction_assign_tags_workflowaction_id_cc9ef2da; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_tags_workflowaction_id_cc9ef2da ON public.documents_workflowaction_assign_tags USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_assign_view_groups_group_id_0ff4e812; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_view_groups_group_id_0ff4e812 ON public.documents_workflowaction_assign_view_groups USING btree (group_id);


--
-- Name: documents_workflowaction_assign_view_users_user_id_24b6d448; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_assign_view_users_user_id_24b6d448 ON public.documents_workflowaction_assign_view_users USING btree (user_id);


--
-- Name: documents_workflowaction_r_correspondent_id_16093a7c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_correspondent_id_16093a7c ON public.documents_workflowaction_remove_correspondents USING btree (correspondent_id);


--
-- Name: documents_workflowaction_r_customfield_id_80028fe8; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_customfield_id_80028fe8 ON public.documents_workflowaction_remove_custom_fields USING btree (customfield_id);


--
-- Name: documents_workflowaction_r_documenttype_id_f99ac948; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_documenttype_id_f99ac948 ON public.documents_workflowaction_remove_document_types USING btree (documenttype_id);


--
-- Name: documents_workflowaction_r_storagepath_id_3f0130af; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_storagepath_id_3f0130af ON public.documents_workflowaction_remove_storage_paths USING btree (storagepath_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_1b269578; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_1b269578 ON public.documents_workflowaction_remove_storage_paths USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_27560d24; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_27560d24 ON public.documents_workflowaction_remove_owners USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_4aa554c0; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_4aa554c0 ON public.documents_workflowaction_remove_view_users USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_4ec66e2f; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_4ec66e2f ON public.documents_workflowaction_remove_correspondents USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_6629046f; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_6629046f ON public.documents_workflowaction_remove_change_groups USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_8c532b6c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_8c532b6c ON public.documents_workflowaction_remove_view_groups USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_beae1e27; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_beae1e27 ON public.documents_workflowaction_remove_change_users USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_d80bd370; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_d80bd370 ON public.documents_workflowaction_remove_document_types USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_r_workflowaction_id_edf3a9f1; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_r_workflowaction_id_edf3a9f1 ON public.documents_workflowaction_remove_custom_fields USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_remove_change_groups_group_id_905a1a61; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_change_groups_group_id_905a1a61 ON public.documents_workflowaction_remove_change_groups USING btree (group_id);


--
-- Name: documents_workflowaction_remove_change_users_user_id_ff94707a; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_change_users_user_id_ff94707a ON public.documents_workflowaction_remove_change_users USING btree (user_id);


--
-- Name: documents_workflowaction_remove_owners_user_id_b9cd308d; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_owners_user_id_b9cd308d ON public.documents_workflowaction_remove_owners USING btree (user_id);


--
-- Name: documents_workflowaction_remove_tags_tag_id_981465ff; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_tags_tag_id_981465ff ON public.documents_workflowaction_remove_tags USING btree (tag_id);


--
-- Name: documents_workflowaction_remove_tags_workflowaction_id_921c52c0; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_tags_workflowaction_id_921c52c0 ON public.documents_workflowaction_remove_tags USING btree (workflowaction_id);


--
-- Name: documents_workflowaction_remove_view_groups_group_id_43f07529; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_view_groups_group_id_43f07529 ON public.documents_workflowaction_remove_view_groups USING btree (group_id);


--
-- Name: documents_workflowaction_remove_view_users_user_id_1939732e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowaction_remove_view_users_user_id_1939732e ON public.documents_workflowaction_remove_view_users USING btree (user_id);


--
-- Name: documents_workflowtrigger__workflowtrigger_id_844712e1; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowtrigger__workflowtrigger_id_844712e1 ON public.documents_workflowtrigger_filter_has_tags USING btree (workflowtrigger_id);


--
-- Name: documents_workflowtrigger_filter_has_correspondent_id_cd1d603d; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowtrigger_filter_has_correspondent_id_cd1d603d ON public.documents_workflowtrigger USING btree (filter_has_correspondent_id);


--
-- Name: documents_workflowtrigger_filter_has_document_type_id_a7f7f504; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowtrigger_filter_has_document_type_id_a7f7f504 ON public.documents_workflowtrigger USING btree (filter_has_document_type_id);


--
-- Name: documents_workflowtrigger_filter_has_tags_tag_id_f5d3bce9; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowtrigger_filter_has_tags_tag_id_f5d3bce9 ON public.documents_workflowtrigger_filter_has_tags USING btree (tag_id);


--
-- Name: documents_workflowtrigger_filter_mailrule_id_6e1798b1; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX documents_workflowtrigger_filter_mailrule_id_6e1798b1 ON public.documents_workflowtrigger USING btree (filter_mailrule_id);


--
-- Name: guardian_gr_content_ae6aec_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_gr_content_ae6aec_idx ON public.guardian_groupobjectpermission USING btree (content_type_id, object_pk);


--
-- Name: guardian_groupobjectpermission_content_type_id_7ade36b8; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_groupobjectpermission_content_type_id_7ade36b8 ON public.guardian_groupobjectpermission USING btree (content_type_id);


--
-- Name: guardian_groupobjectpermission_group_id_4bbbfb62; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_groupobjectpermission_group_id_4bbbfb62 ON public.guardian_groupobjectpermission USING btree (group_id);


--
-- Name: guardian_groupobjectpermission_permission_id_36572738; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_groupobjectpermission_permission_id_36572738 ON public.guardian_groupobjectpermission USING btree (permission_id);


--
-- Name: guardian_us_content_179ed2_idx; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_us_content_179ed2_idx ON public.guardian_userobjectpermission USING btree (content_type_id, object_pk);


--
-- Name: guardian_userobjectpermission_content_type_id_2e892405; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_userobjectpermission_content_type_id_2e892405 ON public.guardian_userobjectpermission USING btree (content_type_id);


--
-- Name: guardian_userobjectpermission_permission_id_71807bfc; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_userobjectpermission_permission_id_71807bfc ON public.guardian_userobjectpermission USING btree (permission_id);


--
-- Name: guardian_userobjectpermission_user_id_d5c1e964; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX guardian_userobjectpermission_user_id_d5c1e964 ON public.guardian_userobjectpermission USING btree (user_id);


--
-- Name: paperless_mail_mailaccount_name_6af0ff82_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailaccount_name_6af0ff82_like ON public.paperless_mail_mailaccount USING btree (name varchar_pattern_ops);


--
-- Name: paperless_mail_mailaccount_owner_id_a894e5ee; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailaccount_owner_id_a894e5ee ON public.paperless_mail_mailaccount USING btree (owner_id);


--
-- Name: paperless_mail_mailrule_account_id_461903f4; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_account_id_461903f4 ON public.paperless_mail_mailrule USING btree (account_id);


--
-- Name: paperless_mail_mailrule_assign_correspondent_id_d2651486; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_assign_correspondent_id_d2651486 ON public.paperless_mail_mailrule USING btree (assign_correspondent_id);


--
-- Name: paperless_mail_mailrule_assign_document_type_id_cb809476; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_assign_document_type_id_cb809476 ON public.paperless_mail_mailrule USING btree (assign_document_type_id);


--
-- Name: paperless_mail_mailrule_assign_tags_mailrule_id_80d0b16c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_assign_tags_mailrule_id_80d0b16c ON public.paperless_mail_mailrule_assign_tags USING btree (mailrule_id);


--
-- Name: paperless_mail_mailrule_assign_tags_tag_id_4d0ac8d5; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_assign_tags_tag_id_4d0ac8d5 ON public.paperless_mail_mailrule_assign_tags USING btree (tag_id);


--
-- Name: paperless_mail_mailrule_name_ee9b53bd_like; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_name_ee9b53bd_like ON public.paperless_mail_mailrule USING btree (name varchar_pattern_ops);


--
-- Name: paperless_mail_mailrule_owner_id_05d1c50f; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_mailrule_owner_id_05d1c50f ON public.paperless_mail_mailrule USING btree (owner_id);


--
-- Name: paperless_mail_processedmail_owner_id_63d8ece4; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_processedmail_owner_id_63d8ece4 ON public.paperless_mail_processedmail USING btree (owner_id);


--
-- Name: paperless_mail_processedmail_rule_id_55bb3322; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX paperless_mail_processedmail_rule_id_55bb3322 ON public.paperless_mail_processedmail USING btree (rule_id);


--
-- Name: socialaccount_socialaccount_user_id_8146e70c; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX socialaccount_socialaccount_user_id_8146e70c ON public.socialaccount_socialaccount USING btree (user_id);


--
-- Name: socialaccount_socialtoken_account_id_951f210e; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX socialaccount_socialtoken_account_id_951f210e ON public.socialaccount_socialtoken USING btree (account_id);


--
-- Name: socialaccount_socialtoken_app_id_636a42d7; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE INDEX socialaccount_socialtoken_app_id_636a42d7 ON public.socialaccount_socialtoken USING btree (app_id);


--
-- Name: unique_verified_email; Type: INDEX; Schema: public; Owner: paperless_ngx
--

CREATE UNIQUE INDEX unique_verified_email ON public.account_emailaddress USING btree (email) WHERE verified;


--
-- Name: account_emailaddress account_emailaddress_user_id_2c513194_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailaddress
    ADD CONSTRAINT account_emailaddress_user_id_2c513194_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: account_emailconfirmation account_emailconfirm_email_address_id_5b7f8c58_fk_account_e; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.account_emailconfirmation
    ADD CONSTRAINT account_emailconfirm_email_address_id_5b7f8c58_fk_account_e FOREIGN KEY (email_address_id) REFERENCES public.account_emailaddress(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auditlog_logentry auditlog_logentry_actor_id_959271d2_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auditlog_logentry
    ADD CONSTRAINT auditlog_logentry_actor_id_959271d2_fk_auth_user_id FOREIGN KEY (actor_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auditlog_logentry auditlog_logentry_content_type_id_75830218_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auditlog_logentry
    ADD CONSTRAINT auditlog_logentry_content_type_id_75830218_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions auth_group_permissio_permission_id_84c5c92e_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissio_permission_id_84c5c92e_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions auth_group_permissions_group_id_b120cbf9_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_b120cbf9_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_permission auth_permission_content_type_id_2f476e4b_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_2f476e4b_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_groups auth_user_groups_group_id_97559544_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_group_id_97559544_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_groups auth_user_groups_user_id_6a12ed8b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_6a12ed8b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_user_permissions auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authtoken_token authtoken_token_user_id_35299eff_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.authtoken_token
    ADD CONSTRAINT authtoken_token_user_id_35299eff_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log django_admin_log_content_type_id_c4bce8eb_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_content_type_id_c4bce8eb_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log django_admin_log_user_id_c564eba6_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_user_id_c564eba6_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_note documents_comment_document_id_3f5d21c7_fk_documents_document_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_note
    ADD CONSTRAINT documents_comment_document_id_3f5d21c7_fk_documents_document_id FOREIGN KEY (document_id) REFERENCES public.documents_document(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_note documents_comment_user_id_c281d4d5_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_note
    ADD CONSTRAINT documents_comment_user_id_c281d4d5_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_correspondent documents_correspondent_owner_id_078f7f8a_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_correspondent
    ADD CONSTRAINT documents_correspondent_owner_id_078f7f8a_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_customfieldinstance documents_customfiel_document_id_610a968e_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfieldinstance
    ADD CONSTRAINT documents_customfiel_document_id_610a968e_fk_documents FOREIGN KEY (document_id) REFERENCES public.documents_document(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_customfieldinstance documents_customfiel_field_id_6c59e32f_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_customfieldinstance
    ADD CONSTRAINT documents_customfiel_field_id_6c59e32f_fk_documents FOREIGN KEY (field_id) REFERENCES public.documents_customfield(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document documents_document_correspondent_id_6164eb0c_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_correspondent_id_6164eb0c_fk_documents FOREIGN KEY (correspondent_id) REFERENCES public.documents_correspondent(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document documents_document_document_type_id_1f88b50c_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_document_type_id_1f88b50c_fk_documents FOREIGN KEY (document_type_id) REFERENCES public.documents_documenttype(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document documents_document_owner_id_04d2b723_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_owner_id_04d2b723_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document documents_document_storage_path_id_07d27bdb_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document
    ADD CONSTRAINT documents_document_storage_path_id_07d27bdb_fk_documents FOREIGN KEY (storage_path_id) REFERENCES public.documents_storagepath(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document_tags documents_document_t_document_id_006f35a8_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document_tags
    ADD CONSTRAINT documents_document_t_document_id_006f35a8_fk_documents FOREIGN KEY (document_id) REFERENCES public.documents_document(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_document_tags documents_document_tags_tag_id_4f4a71e9_fk_documents_tag_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_document_tags
    ADD CONSTRAINT documents_document_tags_tag_id_4f4a71e9_fk_documents_tag_id FOREIGN KEY (tag_id) REFERENCES public.documents_tag(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_documenttype documents_documenttype_owner_id_a19f201d_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_documenttype
    ADD CONSTRAINT documents_documenttype_owner_id_a19f201d_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_savedview documents_savedview_owner_id_2df222ee_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_savedview
    ADD CONSTRAINT documents_savedview_owner_id_2df222ee_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_savedviewfilterrule documents_savedviewf_saved_view_id_038e2c89_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_savedviewfilterrule
    ADD CONSTRAINT documents_savedviewf_saved_view_id_038e2c89_fk_documents FOREIGN KEY (saved_view_id) REFERENCES public.documents_savedview(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_sharelink documents_sharelink_document_id_1be5ab03_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_sharelink
    ADD CONSTRAINT documents_sharelink_document_id_1be5ab03_fk_documents FOREIGN KEY (document_id) REFERENCES public.documents_document(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_sharelink documents_sharelink_owner_id_3fd35a08_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_sharelink
    ADD CONSTRAINT documents_sharelink_owner_id_3fd35a08_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_storagepath documents_storagepath_owner_id_c8f01fe8_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_storagepath
    ADD CONSTRAINT documents_storagepath_owner_id_c8f01fe8_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_tag documents_tag_owner_id_f0875d77_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_tag
    ADD CONSTRAINT documents_tag_owner_id_f0875d77_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_uisettings documents_uisettings_user_id_2df2adc2_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_uisettings
    ADD CONSTRAINT documents_uisettings_user_id_2df2adc2_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflow_actions documents_workflow_a_workflow_id_5445f1de_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_actions
    ADD CONSTRAINT documents_workflow_a_workflow_id_5445f1de_fk_documents FOREIGN KEY (workflow_id) REFERENCES public.documents_workflow(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflow_actions documents_workflow_a_workflowaction_id_7ed6a4fa_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_actions
    ADD CONSTRAINT documents_workflow_a_workflowaction_id_7ed6a4fa_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflow_triggers documents_workflow_t_workflow_id_77d63852_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_triggers
    ADD CONSTRAINT documents_workflow_t_workflow_id_77d63852_fk_documents FOREIGN KEY (workflow_id) REFERENCES public.documents_workflow(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflow_triggers documents_workflow_t_workflowtrigger_id_566f2a31_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflow_triggers
    ADD CONSTRAINT documents_workflow_t_workflowtrigger_id_566f2a31_fk_documents FOREIGN KEY (workflowtrigger_id) REFERENCES public.documents_workflowtrigger(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction documents_workflowac_assign_correspondent_2292447e_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction
    ADD CONSTRAINT documents_workflowac_assign_correspondent_2292447e_fk_documents FOREIGN KEY (assign_correspondent_id) REFERENCES public.documents_correspondent(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction documents_workflowac_assign_document_type_4d37bd10_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction
    ADD CONSTRAINT documents_workflowac_assign_document_type_4d37bd10_fk_documents FOREIGN KEY (assign_document_type_id) REFERENCES public.documents_documenttype(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction documents_workflowac_assign_owner_id_a409d275_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction
    ADD CONSTRAINT documents_workflowac_assign_owner_id_a409d275_fk_auth_user FOREIGN KEY (assign_owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction documents_workflowac_assign_storage_path__6fec4231_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction
    ADD CONSTRAINT documents_workflowac_assign_storage_path__6fec4231_fk_documents FOREIGN KEY (assign_storage_path_id) REFERENCES public.documents_storagepath(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_correspondents documents_workflowac_correspondent_id_16093a7c_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_correspondents
    ADD CONSTRAINT documents_workflowac_correspondent_id_16093a7c_fk_documents FOREIGN KEY (correspondent_id) REFERENCES public.documents_correspondent(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_custom_fields documents_workflowac_customfield_id_09df9cc4_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_custom_fields
    ADD CONSTRAINT documents_workflowac_customfield_id_09df9cc4_fk_documents FOREIGN KEY (customfield_id) REFERENCES public.documents_customfield(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_custom_fields documents_workflowac_customfield_id_80028fe8_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_custom_fields
    ADD CONSTRAINT documents_workflowac_customfield_id_80028fe8_fk_documents FOREIGN KEY (customfield_id) REFERENCES public.documents_customfield(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_document_types documents_workflowac_documenttype_id_f99ac948_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_document_types
    ADD CONSTRAINT documents_workflowac_documenttype_id_f99ac948_fk_documents FOREIGN KEY (documenttype_id) REFERENCES public.documents_documenttype(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_view_groups documents_workflowac_group_id_0ff4e812_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_groups
    ADD CONSTRAINT documents_workflowac_group_id_0ff4e812_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_view_groups documents_workflowac_group_id_43f07529_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_groups
    ADD CONSTRAINT documents_workflowac_group_id_43f07529_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_change_groups documents_workflowac_group_id_905a1a61_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_groups
    ADD CONSTRAINT documents_workflowac_group_id_905a1a61_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_change_groups documents_workflowac_group_id_a6d3bc2c_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_groups
    ADD CONSTRAINT documents_workflowac_group_id_a6d3bc2c_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_storage_paths documents_workflowac_storagepath_id_3f0130af_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_storage_paths
    ADD CONSTRAINT documents_workflowac_storagepath_id_3f0130af_fk_documents FOREIGN KEY (storagepath_id) REFERENCES public.documents_storagepath(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_tags documents_workflowac_tag_id_6770cb84_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_tags
    ADD CONSTRAINT documents_workflowac_tag_id_6770cb84_fk_documents FOREIGN KEY (tag_id) REFERENCES public.documents_tag(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_tags documents_workflowac_tag_id_981465ff_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_tags
    ADD CONSTRAINT documents_workflowac_tag_id_981465ff_fk_documents FOREIGN KEY (tag_id) REFERENCES public.documents_tag(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_view_users documents_workflowac_user_id_1939732e_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_users
    ADD CONSTRAINT documents_workflowac_user_id_1939732e_fk_auth_user FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_view_users documents_workflowac_user_id_24b6d448_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_users
    ADD CONSTRAINT documents_workflowac_user_id_24b6d448_fk_auth_user FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_change_users documents_workflowac_user_id_73bec49c_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_users
    ADD CONSTRAINT documents_workflowac_user_id_73bec49c_fk_auth_user FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_owners documents_workflowac_user_id_b9cd308d_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_owners
    ADD CONSTRAINT documents_workflowac_user_id_b9cd308d_fk_auth_user FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_change_users documents_workflowac_user_id_ff94707a_fk_auth_user; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_users
    ADD CONSTRAINT documents_workflowac_user_id_ff94707a_fk_auth_user FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_change_groups documents_workflowac_workflowaction_id_03784a7e_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_groups
    ADD CONSTRAINT documents_workflowac_workflowaction_id_03784a7e_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_storage_paths documents_workflowac_workflowaction_id_1b269578_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_storage_paths
    ADD CONSTRAINT documents_workflowac_workflowaction_id_1b269578_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_owners documents_workflowac_workflowaction_id_27560d24_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_owners
    ADD CONSTRAINT documents_workflowac_workflowaction_id_27560d24_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_view_users documents_workflowac_workflowaction_id_4aa554c0_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_users
    ADD CONSTRAINT documents_workflowac_workflowaction_id_4aa554c0_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_correspondents documents_workflowac_workflowaction_id_4ec66e2f_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_correspondents
    ADD CONSTRAINT documents_workflowac_workflowaction_id_4ec66e2f_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_custom_fields documents_workflowac_workflowaction_id_518e70e5_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_custom_fields
    ADD CONSTRAINT documents_workflowac_workflowaction_id_518e70e5_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_change_groups documents_workflowac_workflowaction_id_6629046f_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_groups
    ADD CONSTRAINT documents_workflowac_workflowaction_id_6629046f_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_view_users documents_workflowac_workflowaction_id_79b5b0b4_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_users
    ADD CONSTRAINT documents_workflowac_workflowaction_id_79b5b0b4_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_view_groups documents_workflowac_workflowaction_id_8c532b6c_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_view_groups
    ADD CONSTRAINT documents_workflowac_workflowaction_id_8c532b6c_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_tags documents_workflowac_workflowaction_id_921c52c0_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_tags
    ADD CONSTRAINT documents_workflowac_workflowaction_id_921c52c0_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_change_users documents_workflowac_workflowaction_id_bcc0465a_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_change_users
    ADD CONSTRAINT documents_workflowac_workflowaction_id_bcc0465a_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_change_users documents_workflowac_workflowaction_id_beae1e27_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_change_users
    ADD CONSTRAINT documents_workflowac_workflowaction_id_beae1e27_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_tags documents_workflowac_workflowaction_id_cc9ef2da_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_tags
    ADD CONSTRAINT documents_workflowac_workflowaction_id_cc9ef2da_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_document_types documents_workflowac_workflowaction_id_d80bd370_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_document_types
    ADD CONSTRAINT documents_workflowac_workflowaction_id_d80bd370_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_remove_custom_fields documents_workflowac_workflowaction_id_edf3a9f1_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_remove_custom_fields
    ADD CONSTRAINT documents_workflowac_workflowaction_id_edf3a9f1_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowaction_assign_view_groups documents_workflowac_workflowaction_id_f8ef83c1_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowaction_assign_view_groups
    ADD CONSTRAINT documents_workflowac_workflowaction_id_f8ef83c1_fk_documents FOREIGN KEY (workflowaction_id) REFERENCES public.documents_workflowaction(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowtrigger documents_workflowtr_filter_has_correspon_cd1d603d_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger
    ADD CONSTRAINT documents_workflowtr_filter_has_correspon_cd1d603d_fk_documents FOREIGN KEY (filter_has_correspondent_id) REFERENCES public.documents_correspondent(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowtrigger documents_workflowtr_filter_has_document__a7f7f504_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger
    ADD CONSTRAINT documents_workflowtr_filter_has_document__a7f7f504_fk_documents FOREIGN KEY (filter_has_document_type_id) REFERENCES public.documents_documenttype(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowtrigger documents_workflowtr_filter_mailrule_id_6e1798b1_fk_paperless; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger
    ADD CONSTRAINT documents_workflowtr_filter_mailrule_id_6e1798b1_fk_paperless FOREIGN KEY (filter_mailrule_id) REFERENCES public.paperless_mail_mailrule(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowtrigger_filter_has_tags documents_workflowtr_tag_id_f5d3bce9_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger_filter_has_tags
    ADD CONSTRAINT documents_workflowtr_tag_id_f5d3bce9_fk_documents FOREIGN KEY (tag_id) REFERENCES public.documents_tag(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: documents_workflowtrigger_filter_has_tags documents_workflowtr_workflowtrigger_id_844712e1_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.documents_workflowtrigger_filter_has_tags
    ADD CONSTRAINT documents_workflowtr_workflowtrigger_id_844712e1_fk_documents FOREIGN KEY (workflowtrigger_id) REFERENCES public.documents_workflowtrigger(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_content_type_id_7ade36b8_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_content_type_id_7ade36b8_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_group_id_4bbbfb62_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_group_id_4bbbfb62_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_permission_id_36572738_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_permission_id_36572738_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectp_content_type_id_2e892405_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectp_content_type_id_2e892405_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectp_permission_id_71807bfc_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectp_permission_id_71807bfc_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectpermission_user_id_d5c1e964_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectpermission_user_id_d5c1e964_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailaccount paperless_mail_mailaccount_owner_id_a894e5ee_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailaccount
    ADD CONSTRAINT paperless_mail_mailaccount_owner_id_a894e5ee_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule paperless_mail_mailr_account_id_461903f4_fk_paperless; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailr_account_id_461903f4_fk_paperless FOREIGN KEY (account_id) REFERENCES public.paperless_mail_mailaccount(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule paperless_mail_mailr_assign_correspondent_d2651486_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailr_assign_correspondent_d2651486_fk_documents FOREIGN KEY (assign_correspondent_id) REFERENCES public.documents_correspondent(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule paperless_mail_mailr_assign_document_type_cb809476_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailr_assign_document_type_cb809476_fk_documents FOREIGN KEY (assign_document_type_id) REFERENCES public.documents_documenttype(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule_assign_tags paperless_mail_mailr_mailrule_id_80d0b16c_fk_paperless; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule_assign_tags
    ADD CONSTRAINT paperless_mail_mailr_mailrule_id_80d0b16c_fk_paperless FOREIGN KEY (mailrule_id) REFERENCES public.paperless_mail_mailrule(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule_assign_tags paperless_mail_mailr_tag_id_4d0ac8d5_fk_documents; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule_assign_tags
    ADD CONSTRAINT paperless_mail_mailr_tag_id_4d0ac8d5_fk_documents FOREIGN KEY (tag_id) REFERENCES public.documents_tag(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_mailrule paperless_mail_mailrule_owner_id_05d1c50f_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_mailrule
    ADD CONSTRAINT paperless_mail_mailrule_owner_id_05d1c50f_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_processedmail paperless_mail_proce_rule_id_55bb3322_fk_paperless; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_processedmail
    ADD CONSTRAINT paperless_mail_proce_rule_id_55bb3322_fk_paperless FOREIGN KEY (rule_id) REFERENCES public.paperless_mail_mailrule(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: paperless_mail_processedmail paperless_mail_processedmail_owner_id_63d8ece4_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.paperless_mail_processedmail
    ADD CONSTRAINT paperless_mail_processedmail_owner_id_63d8ece4_fk_auth_user_id FOREIGN KEY (owner_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: socialaccount_socialtoken socialaccount_social_account_id_951f210e_fk_socialacc; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialtoken
    ADD CONSTRAINT socialaccount_social_account_id_951f210e_fk_socialacc FOREIGN KEY (account_id) REFERENCES public.socialaccount_socialaccount(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: socialaccount_socialtoken socialaccount_social_app_id_636a42d7_fk_socialacc; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialtoken
    ADD CONSTRAINT socialaccount_social_app_id_636a42d7_fk_socialacc FOREIGN KEY (app_id) REFERENCES public.socialaccount_socialapp(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: socialaccount_socialaccount socialaccount_socialaccount_user_id_8146e70c_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: paperless_ngx
--

ALTER TABLE ONLY public.socialaccount_socialaccount
    ADD CONSTRAINT socialaccount_socialaccount_user_id_8146e70c_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- PostgreSQL database dump complete
--

